//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomation

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Account.
func (a *Account) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountCreateOrUpdateParameters.
func (a AccountCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountCreateOrUpdateParameters.
func (a *AccountCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountCreateOrUpdateProperties.
func (a AccountCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disableLocalAuth", a.DisableLocalAuth)
	populate(objectMap, "encryption", a.Encryption)
	populate(objectMap, "publicNetworkAccess", a.PublicNetworkAccess)
	populate(objectMap, "sku", a.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountCreateOrUpdateProperties.
func (a *AccountCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &a.DisableLocalAuth)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &a.Encryption)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &a.PublicNetworkAccess)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountListResult.
func (a AccountListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountListResult.
func (a *AccountListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountProperties.
func (a AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "automationHybridServiceUrl", a.AutomationHybridServiceURL)
	populateTimeRFC3339(objectMap, "creationTime", a.CreationTime)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "disableLocalAuth", a.DisableLocalAuth)
	populate(objectMap, "encryption", a.Encryption)
	populate(objectMap, "lastModifiedBy", a.LastModifiedBy)
	populateTimeRFC3339(objectMap, "lastModifiedTime", a.LastModifiedTime)
	populate(objectMap, "privateEndpointConnections", a.PrivateEndpointConnections)
	populate(objectMap, "publicNetworkAccess", a.PublicNetworkAccess)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "state", a.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountProperties.
func (a *AccountProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "automationHybridServiceUrl":
			err = unpopulate(val, "AutomationHybridServiceURL", &a.AutomationHybridServiceURL)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &a.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &a.DisableLocalAuth)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &a.Encryption)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &a.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &a.LastModifiedTime)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &a.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &a.PublicNetworkAccess)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountUpdateParameters.
func (a AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountUpdateParameters.
func (a *AccountUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountUpdateProperties.
func (a AccountUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disableLocalAuth", a.DisableLocalAuth)
	populate(objectMap, "encryption", a.Encryption)
	populate(objectMap, "publicNetworkAccess", a.PublicNetworkAccess)
	populate(objectMap, "sku", a.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountUpdateProperties.
func (a *AccountUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &a.DisableLocalAuth)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &a.Encryption)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &a.PublicNetworkAccess)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Activity.
func (a Activity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Activity.
func (a *Activity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActivityListResult.
func (a ActivityListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActivityListResult.
func (a *ActivityListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActivityOutputType.
func (a ActivityOutputType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", a.Name)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActivityOutputType.
func (a *ActivityOutputType) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActivityParameter.
func (a ActivityParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", a.Description)
	populate(objectMap, "isDynamic", a.IsDynamic)
	populate(objectMap, "isMandatory", a.IsMandatory)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "position", a.Position)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "validationSet", a.ValidationSet)
	populate(objectMap, "valueFromPipeline", a.ValueFromPipeline)
	populate(objectMap, "valueFromPipelineByPropertyName", a.ValueFromPipelineByPropertyName)
	populate(objectMap, "valueFromRemainingArguments", a.ValueFromRemainingArguments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActivityParameter.
func (a *ActivityParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "isDynamic":
			err = unpopulate(val, "IsDynamic", &a.IsDynamic)
			delete(rawMsg, key)
		case "isMandatory":
			err = unpopulate(val, "IsMandatory", &a.IsMandatory)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "position":
			err = unpopulate(val, "Position", &a.Position)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "validationSet":
			err = unpopulate(val, "ValidationSet", &a.ValidationSet)
			delete(rawMsg, key)
		case "valueFromPipeline":
			err = unpopulate(val, "ValueFromPipeline", &a.ValueFromPipeline)
			delete(rawMsg, key)
		case "valueFromPipelineByPropertyName":
			err = unpopulate(val, "ValueFromPipelineByPropertyName", &a.ValueFromPipelineByPropertyName)
			delete(rawMsg, key)
		case "valueFromRemainingArguments":
			err = unpopulate(val, "ValueFromRemainingArguments", &a.ValueFromRemainingArguments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActivityParameterSet.
func (a ActivityParameterSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", a.Name)
	populate(objectMap, "parameters", a.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActivityParameterSet.
func (a *ActivityParameterSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActivityParameterValidationSet.
func (a ActivityParameterValidationSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "memberValue", a.MemberValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActivityParameterValidationSet.
func (a *ActivityParameterValidationSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "memberValue":
			err = unpopulate(val, "MemberValue", &a.MemberValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActivityProperties.
func (a ActivityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", a.CreationTime)
	populate(objectMap, "definition", a.Definition)
	populate(objectMap, "description", a.Description)
	populateTimeRFC3339(objectMap, "lastModifiedTime", a.LastModifiedTime)
	populate(objectMap, "outputTypes", a.OutputTypes)
	populate(objectMap, "parameterSets", a.ParameterSets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActivityProperties.
func (a *ActivityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &a.CreationTime)
			delete(rawMsg, key)
		case "definition":
			err = unpopulate(val, "Definition", &a.Definition)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &a.LastModifiedTime)
			delete(rawMsg, key)
		case "outputTypes":
			err = unpopulate(val, "OutputTypes", &a.OutputTypes)
			delete(rawMsg, key)
		case "parameterSets":
			err = unpopulate(val, "ParameterSets", &a.ParameterSets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdvancedSchedule.
func (a AdvancedSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "monthDays", a.MonthDays)
	populate(objectMap, "monthlyOccurrences", a.MonthlyOccurrences)
	populate(objectMap, "weekDays", a.WeekDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdvancedSchedule.
func (a *AdvancedSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "monthDays":
			err = unpopulate(val, "MonthDays", &a.MonthDays)
			delete(rawMsg, key)
		case "monthlyOccurrences":
			err = unpopulate(val, "MonthlyOccurrences", &a.MonthlyOccurrences)
			delete(rawMsg, key)
		case "weekDays":
			err = unpopulate(val, "WeekDays", &a.WeekDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdvancedScheduleMonthlyOccurrence.
func (a AdvancedScheduleMonthlyOccurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "day", a.Day)
	populate(objectMap, "occurrence", a.Occurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdvancedScheduleMonthlyOccurrence.
func (a *AdvancedScheduleMonthlyOccurrence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "day":
			err = unpopulate(val, "Day", &a.Day)
			delete(rawMsg, key)
		case "occurrence":
			err = unpopulate(val, "Occurrence", &a.Occurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentRegistration.
func (a AgentRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dscMetaConfiguration", a.DscMetaConfiguration)
	populate(objectMap, "endpoint", a.Endpoint)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "keys", a.Keys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentRegistration.
func (a *AgentRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dscMetaConfiguration":
			err = unpopulate(val, "DscMetaConfiguration", &a.DscMetaConfiguration)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "keys":
			err = unpopulate(val, "Keys", &a.Keys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentRegistrationKeys.
func (a AgentRegistrationKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "primary", a.Primary)
	populate(objectMap, "secondary", a.Secondary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentRegistrationKeys.
func (a *AgentRegistrationKeys) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primary":
			err = unpopulate(val, "Primary", &a.Primary)
			delete(rawMsg, key)
		case "secondary":
			err = unpopulate(val, "Secondary", &a.Secondary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentRegistrationRegenerateKeyParameter.
func (a AgentRegistrationRegenerateKeyParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyName", a.KeyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentRegistrationRegenerateKeyParameter.
func (a *AgentRegistrationRegenerateKeyParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyName":
			err = unpopulate(val, "KeyName", &a.KeyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureQueryProperties.
func (a AzureQueryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "locations", a.Locations)
	populate(objectMap, "scope", a.Scope)
	populate(objectMap, "tagSettings", a.TagSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureQueryProperties.
func (a *AzureQueryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locations":
			err = unpopulate(val, "Locations", &a.Locations)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &a.Scope)
			delete(rawMsg, key)
		case "tagSettings":
			err = unpopulate(val, "TagSettings", &a.TagSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Certificate.
func (c Certificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Certificate.
func (c *Certificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateCreateOrUpdateParameters.
func (c CertificateCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateCreateOrUpdateParameters.
func (c *CertificateCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateCreateOrUpdateProperties.
func (c CertificateCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "base64Value", c.Base64Value)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "isExportable", c.IsExportable)
	populate(objectMap, "thumbprint", c.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateCreateOrUpdateProperties.
func (c *CertificateCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "base64Value":
			err = unpopulate(val, "Base64Value", &c.Base64Value)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "isExportable":
			err = unpopulate(val, "IsExportable", &c.IsExportable)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateListResult.
func (c CertificateListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateListResult.
func (c *CertificateListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateProperties.
func (c CertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", c.CreationTime)
	populate(objectMap, "description", c.Description)
	populateTimeRFC3339(objectMap, "expiryTime", c.ExpiryTime)
	populate(objectMap, "isExportable", c.IsExportable)
	populateTimeRFC3339(objectMap, "lastModifiedTime", c.LastModifiedTime)
	populate(objectMap, "thumbprint", c.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateProperties.
func (c *CertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &c.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &c.ExpiryTime)
			delete(rawMsg, key)
		case "isExportable":
			err = unpopulate(val, "IsExportable", &c.IsExportable)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &c.LastModifiedTime)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateUpdateParameters.
func (c CertificateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateUpdateParameters.
func (c *CertificateUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateUpdateProperties.
func (c CertificateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", c.Description)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateUpdateProperties.
func (c *CertificateUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties.
func (c ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientId", c.ClientID)
	populate(objectMap, "principalId", c.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties.
func (c *ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &c.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &c.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Connection.
func (c Connection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Connection.
func (c *Connection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionCreateOrUpdateParameters.
func (c ConnectionCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionCreateOrUpdateParameters.
func (c *ConnectionCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionCreateOrUpdateProperties.
func (c ConnectionCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectionType", c.ConnectionType)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "fieldDefinitionValues", c.FieldDefinitionValues)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionCreateOrUpdateProperties.
func (c *ConnectionCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionType":
			err = unpopulate(val, "ConnectionType", &c.ConnectionType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "fieldDefinitionValues":
			err = unpopulate(val, "FieldDefinitionValues", &c.FieldDefinitionValues)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionListResult.
func (c ConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionListResult.
func (c *ConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionProperties.
func (c ConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectionType", c.ConnectionType)
	populateTimeRFC3339(objectMap, "creationTime", c.CreationTime)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "fieldDefinitionValues", c.FieldDefinitionValues)
	populateTimeRFC3339(objectMap, "lastModifiedTime", c.LastModifiedTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionProperties.
func (c *ConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionType":
			err = unpopulate(val, "ConnectionType", &c.ConnectionType)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &c.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "fieldDefinitionValues":
			err = unpopulate(val, "FieldDefinitionValues", &c.FieldDefinitionValues)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &c.LastModifiedTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionType.
func (c ConnectionType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionType.
func (c *ConnectionType) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionTypeAssociationProperty.
func (c ConnectionTypeAssociationProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionTypeAssociationProperty.
func (c *ConnectionTypeAssociationProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionTypeCreateOrUpdateParameters.
func (c ConnectionTypeCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionTypeCreateOrUpdateParameters.
func (c *ConnectionTypeCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionTypeCreateOrUpdateProperties.
func (c ConnectionTypeCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fieldDefinitions", c.FieldDefinitions)
	populate(objectMap, "isGlobal", c.IsGlobal)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionTypeCreateOrUpdateProperties.
func (c *ConnectionTypeCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fieldDefinitions":
			err = unpopulate(val, "FieldDefinitions", &c.FieldDefinitions)
			delete(rawMsg, key)
		case "isGlobal":
			err = unpopulate(val, "IsGlobal", &c.IsGlobal)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionTypeListResult.
func (c ConnectionTypeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionTypeListResult.
func (c *ConnectionTypeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionTypeProperties.
func (c ConnectionTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", c.CreationTime)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "fieldDefinitions", c.FieldDefinitions)
	populate(objectMap, "isGlobal", c.IsGlobal)
	populateTimeRFC3339(objectMap, "lastModifiedTime", c.LastModifiedTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionTypeProperties.
func (c *ConnectionTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &c.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "fieldDefinitions":
			err = unpopulate(val, "FieldDefinitions", &c.FieldDefinitions)
			delete(rawMsg, key)
		case "isGlobal":
			err = unpopulate(val, "IsGlobal", &c.IsGlobal)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &c.LastModifiedTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionUpdateParameters.
func (c ConnectionUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionUpdateParameters.
func (c *ConnectionUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionUpdateProperties.
func (c ConnectionUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", c.Description)
	populate(objectMap, "fieldDefinitionValues", c.FieldDefinitionValues)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionUpdateProperties.
func (c *ConnectionUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "fieldDefinitionValues":
			err = unpopulate(val, "FieldDefinitionValues", &c.FieldDefinitionValues)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentHash.
func (c ContentHash) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "algorithm", c.Algorithm)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentHash.
func (c *ContentHash) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "algorithm":
			err = unpopulate(val, "Algorithm", &c.Algorithm)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentLink.
func (c ContentLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentHash", c.ContentHash)
	populate(objectMap, "uri", c.URI)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentLink.
func (c *ContentLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentHash":
			err = unpopulate(val, "ContentHash", &c.ContentHash)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &c.URI)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentSource.
func (c ContentSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hash", c.Hash)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "value", c.Value)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentSource.
func (c *ContentSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hash":
			err = unpopulate(val, "Hash", &c.Hash)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Credential.
func (c Credential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Credential.
func (c *Credential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialCreateOrUpdateParameters.
func (c CredentialCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialCreateOrUpdateParameters.
func (c *CredentialCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialCreateOrUpdateProperties.
func (c CredentialCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", c.Description)
	populate(objectMap, "password", c.Password)
	populate(objectMap, "userName", c.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialCreateOrUpdateProperties.
func (c *CredentialCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &c.Password)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &c.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialListResult.
func (c CredentialListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialListResult.
func (c *CredentialListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialProperties.
func (c CredentialProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", c.CreationTime)
	populate(objectMap, "description", c.Description)
	populateTimeRFC3339(objectMap, "lastModifiedTime", c.LastModifiedTime)
	populate(objectMap, "userName", c.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialProperties.
func (c *CredentialProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &c.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &c.LastModifiedTime)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &c.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialUpdateParameters.
func (c CredentialUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialUpdateParameters.
func (c *CredentialUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialUpdateProperties.
func (c CredentialUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", c.Description)
	populate(objectMap, "password", c.Password)
	populate(objectMap, "userName", c.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialUpdateProperties.
func (c *CredentialUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &c.Password)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &c.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedAutomationAccount.
func (d DeletedAutomationAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedAutomationAccount.
func (d *DeletedAutomationAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedAutomationAccountListResult.
func (d DeletedAutomationAccountListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedAutomationAccountListResult.
func (d *DeletedAutomationAccountListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedAutomationAccountProperties.
func (d DeletedAutomationAccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "automationAccountId", d.AutomationAccountID)
	populate(objectMap, "automationAccountResourceId", d.AutomationAccountResourceID)
	populateTimeRFC3339(objectMap, "deletionTime", d.DeletionTime)
	populate(objectMap, "location", d.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedAutomationAccountProperties.
func (d *DeletedAutomationAccountProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "automationAccountId":
			err = unpopulate(val, "AutomationAccountID", &d.AutomationAccountID)
			delete(rawMsg, key)
		case "automationAccountResourceId":
			err = unpopulate(val, "AutomationAccountResourceID", &d.AutomationAccountResourceID)
			delete(rawMsg, key)
		case "deletionTime":
			err = unpopulateTimeRFC3339(val, "DeletionTime", &d.DeletionTime)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscCompilationJob.
func (d DscCompilationJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscCompilationJob.
func (d *DscCompilationJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscCompilationJobCreateParameters.
func (d DscCompilationJobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscCompilationJobCreateParameters.
func (d *DscCompilationJobCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscCompilationJobCreateProperties.
func (d DscCompilationJobCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", d.Configuration)
	populate(objectMap, "incrementNodeConfigurationBuild", d.IncrementNodeConfigurationBuild)
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscCompilationJobCreateProperties.
func (d *DscCompilationJobCreateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &d.Configuration)
			delete(rawMsg, key)
		case "incrementNodeConfigurationBuild":
			err = unpopulate(val, "IncrementNodeConfigurationBuild", &d.IncrementNodeConfigurationBuild)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscCompilationJobListResult.
func (d DscCompilationJobListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscCompilationJobListResult.
func (d *DscCompilationJobListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscCompilationJobProperties.
func (d DscCompilationJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", d.Configuration)
	populateTimeRFC3339(objectMap, "creationTime", d.CreationTime)
	populateTimeRFC3339(objectMap, "endTime", d.EndTime)
	populate(objectMap, "exception", d.Exception)
	populate(objectMap, "jobId", d.JobID)
	populateTimeRFC3339(objectMap, "lastModifiedTime", d.LastModifiedTime)
	populateTimeRFC3339(objectMap, "lastStatusModifiedTime", d.LastStatusModifiedTime)
	populate(objectMap, "parameters", d.Parameters)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "runOn", d.RunOn)
	populateTimeRFC3339(objectMap, "startTime", d.StartTime)
	populate(objectMap, "startedBy", d.StartedBy)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "statusDetails", d.StatusDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscCompilationJobProperties.
func (d *DscCompilationJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &d.Configuration)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &d.CreationTime)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &d.EndTime)
			delete(rawMsg, key)
		case "exception":
			err = unpopulate(val, "Exception", &d.Exception)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &d.JobID)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &d.LastModifiedTime)
			delete(rawMsg, key)
		case "lastStatusModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastStatusModifiedTime", &d.LastStatusModifiedTime)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "runOn":
			err = unpopulate(val, "RunOn", &d.RunOn)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		case "startedBy":
			err = unpopulate(val, "StartedBy", &d.StartedBy)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &d.StatusDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscConfiguration.
func (d DscConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscConfiguration.
func (d *DscConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscConfigurationAssociationProperty.
func (d DscConfigurationAssociationProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscConfigurationAssociationProperty.
func (d *DscConfigurationAssociationProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscConfigurationCreateOrUpdateParameters.
func (d DscConfigurationCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscConfigurationCreateOrUpdateParameters.
func (d *DscConfigurationCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscConfigurationCreateOrUpdateProperties.
func (d DscConfigurationCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", d.Description)
	populate(objectMap, "logProgress", d.LogProgress)
	populate(objectMap, "logVerbose", d.LogVerbose)
	populate(objectMap, "parameters", d.Parameters)
	populate(objectMap, "source", d.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscConfigurationCreateOrUpdateProperties.
func (d *DscConfigurationCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "logProgress":
			err = unpopulate(val, "LogProgress", &d.LogProgress)
			delete(rawMsg, key)
		case "logVerbose":
			err = unpopulate(val, "LogVerbose", &d.LogVerbose)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &d.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscConfigurationListResult.
func (d DscConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "totalCount", d.TotalCount)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscConfigurationListResult.
func (d *DscConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &d.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscConfigurationParameter.
func (d DscConfigurationParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultValue", d.DefaultValue)
	populate(objectMap, "isMandatory", d.IsMandatory)
	populate(objectMap, "position", d.Position)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscConfigurationParameter.
func (d *DscConfigurationParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultValue":
			err = unpopulate(val, "DefaultValue", &d.DefaultValue)
			delete(rawMsg, key)
		case "isMandatory":
			err = unpopulate(val, "IsMandatory", &d.IsMandatory)
			delete(rawMsg, key)
		case "position":
			err = unpopulate(val, "Position", &d.Position)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscConfigurationProperties.
func (d DscConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", d.CreationTime)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "jobCount", d.JobCount)
	populateTimeRFC3339(objectMap, "lastModifiedTime", d.LastModifiedTime)
	populate(objectMap, "logVerbose", d.LogVerbose)
	populate(objectMap, "nodeConfigurationCount", d.NodeConfigurationCount)
	populate(objectMap, "parameters", d.Parameters)
	objectMap["provisioningState"] = "Succeeded"
	populate(objectMap, "source", d.Source)
	populate(objectMap, "state", d.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscConfigurationProperties.
func (d *DscConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &d.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "jobCount":
			err = unpopulate(val, "JobCount", &d.JobCount)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &d.LastModifiedTime)
			delete(rawMsg, key)
		case "logVerbose":
			err = unpopulate(val, "LogVerbose", &d.LogVerbose)
			delete(rawMsg, key)
		case "nodeConfigurationCount":
			err = unpopulate(val, "NodeConfigurationCount", &d.NodeConfigurationCount)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &d.Source)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscConfigurationUpdateParameters.
func (d DscConfigurationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscConfigurationUpdateParameters.
func (d *DscConfigurationUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscMetaConfiguration.
func (d DscMetaConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionAfterReboot", d.ActionAfterReboot)
	populate(objectMap, "allowModuleOverwrite", d.AllowModuleOverwrite)
	populate(objectMap, "certificateId", d.CertificateID)
	populate(objectMap, "configurationMode", d.ConfigurationMode)
	populate(objectMap, "configurationModeFrequencyMins", d.ConfigurationModeFrequencyMins)
	populate(objectMap, "rebootNodeIfNeeded", d.RebootNodeIfNeeded)
	populate(objectMap, "refreshFrequencyMins", d.RefreshFrequencyMins)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscMetaConfiguration.
func (d *DscMetaConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionAfterReboot":
			err = unpopulate(val, "ActionAfterReboot", &d.ActionAfterReboot)
			delete(rawMsg, key)
		case "allowModuleOverwrite":
			err = unpopulate(val, "AllowModuleOverwrite", &d.AllowModuleOverwrite)
			delete(rawMsg, key)
		case "certificateId":
			err = unpopulate(val, "CertificateID", &d.CertificateID)
			delete(rawMsg, key)
		case "configurationMode":
			err = unpopulate(val, "ConfigurationMode", &d.ConfigurationMode)
			delete(rawMsg, key)
		case "configurationModeFrequencyMins":
			err = unpopulate(val, "ConfigurationModeFrequencyMins", &d.ConfigurationModeFrequencyMins)
			delete(rawMsg, key)
		case "rebootNodeIfNeeded":
			err = unpopulate(val, "RebootNodeIfNeeded", &d.RebootNodeIfNeeded)
			delete(rawMsg, key)
		case "refreshFrequencyMins":
			err = unpopulate(val, "RefreshFrequencyMins", &d.RefreshFrequencyMins)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNode.
func (d DscNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNode.
func (d *DscNode) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeConfiguration.
func (d DscNodeConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeConfiguration.
func (d *DscNodeConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeConfigurationAssociationProperty.
func (d DscNodeConfigurationAssociationProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeConfigurationAssociationProperty.
func (d *DscNodeConfigurationAssociationProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeConfigurationCreateOrUpdateParameters.
func (d DscNodeConfigurationCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeConfigurationCreateOrUpdateParameters.
func (d *DscNodeConfigurationCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeConfigurationCreateOrUpdateParametersProperties.
func (d DscNodeConfigurationCreateOrUpdateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", d.Configuration)
	populate(objectMap, "incrementNodeConfigurationBuild", d.IncrementNodeConfigurationBuild)
	populate(objectMap, "source", d.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeConfigurationCreateOrUpdateParametersProperties.
func (d *DscNodeConfigurationCreateOrUpdateParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &d.Configuration)
			delete(rawMsg, key)
		case "incrementNodeConfigurationBuild":
			err = unpopulate(val, "IncrementNodeConfigurationBuild", &d.IncrementNodeConfigurationBuild)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &d.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeConfigurationListResult.
func (d DscNodeConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "totalCount", d.TotalCount)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeConfigurationListResult.
func (d *DscNodeConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &d.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeConfigurationProperties.
func (d DscNodeConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", d.Configuration)
	populateTimeRFC3339(objectMap, "creationTime", d.CreationTime)
	populate(objectMap, "incrementNodeConfigurationBuild", d.IncrementNodeConfigurationBuild)
	populateTimeRFC3339(objectMap, "lastModifiedTime", d.LastModifiedTime)
	populate(objectMap, "nodeCount", d.NodeCount)
	populate(objectMap, "source", d.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeConfigurationProperties.
func (d *DscNodeConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &d.Configuration)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &d.CreationTime)
			delete(rawMsg, key)
		case "incrementNodeConfigurationBuild":
			err = unpopulate(val, "IncrementNodeConfigurationBuild", &d.IncrementNodeConfigurationBuild)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &d.LastModifiedTime)
			delete(rawMsg, key)
		case "nodeCount":
			err = unpopulate(val, "NodeCount", &d.NodeCount)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &d.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeExtensionHandlerAssociationProperty.
func (d DscNodeExtensionHandlerAssociationProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", d.Name)
	populate(objectMap, "version", d.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeExtensionHandlerAssociationProperty.
func (d *DscNodeExtensionHandlerAssociationProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeListResult.
func (d DscNodeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "totalCount", d.TotalCount)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeListResult.
func (d *DscNodeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &d.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeProperties.
func (d DscNodeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accountId", d.AccountID)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "extensionHandler", d.ExtensionHandler)
	populate(objectMap, "ip", d.IP)
	populateTimeRFC3339(objectMap, "lastSeen", d.LastSeen)
	populate(objectMap, "nodeConfiguration", d.NodeConfiguration)
	populate(objectMap, "nodeId", d.NodeID)
	populateTimeRFC3339(objectMap, "registrationTime", d.RegistrationTime)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "totalCount", d.TotalCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeProperties.
func (d *DscNodeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &d.AccountID)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "extensionHandler":
			err = unpopulate(val, "ExtensionHandler", &d.ExtensionHandler)
			delete(rawMsg, key)
		case "ip":
			err = unpopulate(val, "IP", &d.IP)
			delete(rawMsg, key)
		case "lastSeen":
			err = unpopulateTimeRFC3339(val, "LastSeen", &d.LastSeen)
			delete(rawMsg, key)
		case "nodeConfiguration":
			err = unpopulate(val, "NodeConfiguration", &d.NodeConfiguration)
			delete(rawMsg, key)
		case "nodeId":
			err = unpopulate(val, "NodeID", &d.NodeID)
			delete(rawMsg, key)
		case "registrationTime":
			err = unpopulateTimeRFC3339(val, "RegistrationTime", &d.RegistrationTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &d.TotalCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeReport.
func (d DscNodeReport) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configurationVersion", d.ConfigurationVersion)
	populateTimeRFC3339(objectMap, "endTime", d.EndTime)
	populate(objectMap, "errors", d.Errors)
	populate(objectMap, "hostName", d.HostName)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "iPV4Addresses", d.IPV4Addresses)
	populate(objectMap, "iPV6Addresses", d.IPV6Addresses)
	populateTimeRFC3339(objectMap, "lastModifiedTime", d.LastModifiedTime)
	populate(objectMap, "metaConfiguration", d.MetaConfiguration)
	populate(objectMap, "numberOfResources", d.NumberOfResources)
	populate(objectMap, "rawErrors", d.RawErrors)
	populate(objectMap, "rebootRequested", d.RebootRequested)
	populate(objectMap, "refreshMode", d.RefreshMode)
	populate(objectMap, "reportFormatVersion", d.ReportFormatVersion)
	populate(objectMap, "reportId", d.ReportID)
	populate(objectMap, "resources", d.Resources)
	populateTimeRFC3339(objectMap, "startTime", d.StartTime)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeReport.
func (d *DscNodeReport) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationVersion":
			err = unpopulate(val, "ConfigurationVersion", &d.ConfigurationVersion)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &d.EndTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &d.Errors)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &d.HostName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "iPV4Addresses":
			err = unpopulate(val, "IPV4Addresses", &d.IPV4Addresses)
			delete(rawMsg, key)
		case "iPV6Addresses":
			err = unpopulate(val, "IPV6Addresses", &d.IPV6Addresses)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &d.LastModifiedTime)
			delete(rawMsg, key)
		case "metaConfiguration":
			err = unpopulate(val, "MetaConfiguration", &d.MetaConfiguration)
			delete(rawMsg, key)
		case "numberOfResources":
			err = unpopulate(val, "NumberOfResources", &d.NumberOfResources)
			delete(rawMsg, key)
		case "rawErrors":
			err = unpopulate(val, "RawErrors", &d.RawErrors)
			delete(rawMsg, key)
		case "rebootRequested":
			err = unpopulate(val, "RebootRequested", &d.RebootRequested)
			delete(rawMsg, key)
		case "refreshMode":
			err = unpopulate(val, "RefreshMode", &d.RefreshMode)
			delete(rawMsg, key)
		case "reportFormatVersion":
			err = unpopulate(val, "ReportFormatVersion", &d.ReportFormatVersion)
			delete(rawMsg, key)
		case "reportId":
			err = unpopulate(val, "ReportID", &d.ReportID)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &d.Resources)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeReportListResult.
func (d DscNodeReportListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeReportListResult.
func (d *DscNodeReportListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeUpdateParameters.
func (d DscNodeUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nodeId", d.NodeID)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeUpdateParameters.
func (d *DscNodeUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nodeId":
			err = unpopulate(val, "NodeID", &d.NodeID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscNodeUpdateParametersProperties.
func (d DscNodeUpdateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nodeConfiguration", d.NodeConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscNodeUpdateParametersProperties.
func (d *DscNodeUpdateParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nodeConfiguration":
			err = unpopulate(val, "NodeConfiguration", &d.NodeConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscReportError.
func (d DscReportError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorCode", d.ErrorCode)
	populate(objectMap, "errorDetails", d.ErrorDetails)
	populate(objectMap, "errorMessage", d.ErrorMessage)
	populate(objectMap, "errorSource", d.ErrorSource)
	populate(objectMap, "locale", d.Locale)
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscReportError.
func (d *DscReportError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &d.ErrorCode)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &d.ErrorDetails)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &d.ErrorMessage)
			delete(rawMsg, key)
		case "errorSource":
			err = unpopulate(val, "ErrorSource", &d.ErrorSource)
			delete(rawMsg, key)
		case "locale":
			err = unpopulate(val, "Locale", &d.Locale)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscReportResource.
func (d DscReportResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dependsOn", d.DependsOn)
	populate(objectMap, "durationInSeconds", d.DurationInSeconds)
	populate(objectMap, "error", d.Error)
	populate(objectMap, "moduleName", d.ModuleName)
	populate(objectMap, "moduleVersion", d.ModuleVersion)
	populate(objectMap, "resourceId", d.ResourceID)
	populate(objectMap, "resourceName", d.ResourceName)
	populate(objectMap, "sourceInfo", d.SourceInfo)
	populateTimeRFC3339(objectMap, "startDate", d.StartDate)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscReportResource.
func (d *DscReportResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &d.DependsOn)
			delete(rawMsg, key)
		case "durationInSeconds":
			err = unpopulate(val, "DurationInSeconds", &d.DurationInSeconds)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		case "moduleName":
			err = unpopulate(val, "ModuleName", &d.ModuleName)
			delete(rawMsg, key)
		case "moduleVersion":
			err = unpopulate(val, "ModuleVersion", &d.ModuleVersion)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &d.ResourceName)
			delete(rawMsg, key)
		case "sourceInfo":
			err = unpopulate(val, "SourceInfo", &d.SourceInfo)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateTimeRFC3339(val, "StartDate", &d.StartDate)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscReportResourceNavigation.
func (d DscReportResourceNavigation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscReportResourceNavigation.
func (d *DscReportResourceNavigation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionProperties.
func (e EncryptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", e.Identity)
	populate(objectMap, "keySource", e.KeySource)
	populate(objectMap, "keyVaultProperties", e.KeyVaultProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionProperties.
func (e *EncryptionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &e.Identity)
			delete(rawMsg, key)
		case "keySource":
			err = unpopulate(val, "KeySource", &e.KeySource)
			delete(rawMsg, key)
		case "keyVaultProperties":
			err = unpopulate(val, "KeyVaultProperties", &e.KeyVaultProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionPropertiesIdentity.
func (e EncryptionPropertiesIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "userAssignedIdentity", &e.UserAssignedIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionPropertiesIdentity.
func (e *EncryptionPropertiesIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "userAssignedIdentity":
			err = unpopulate(val, "UserAssignedIdentity", &e.UserAssignedIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FieldDefinition.
func (f FieldDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isEncrypted", f.IsEncrypted)
	populate(objectMap, "isOptional", f.IsOptional)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FieldDefinition.
func (f *FieldDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isEncrypted":
			err = unpopulate(val, "IsEncrypted", &f.IsEncrypted)
			delete(rawMsg, key)
		case "isOptional":
			err = unpopulate(val, "IsOptional", &f.IsOptional)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GraphicalRunbookContent.
func (g GraphicalRunbookContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "graphRunbookJson", g.GraphRunbookJSON)
	populate(objectMap, "rawContent", g.RawContent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GraphicalRunbookContent.
func (g *GraphicalRunbookContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "graphRunbookJson":
			err = unpopulate(val, "GraphRunbookJSON", &g.GraphRunbookJSON)
			delete(rawMsg, key)
		case "rawContent":
			err = unpopulate(val, "RawContent", &g.RawContent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridRunbookWorker.
func (h HybridRunbookWorker) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "systemData", h.SystemData)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridRunbookWorker.
func (h *HybridRunbookWorker) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &h.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridRunbookWorkerCreateOrUpdateParameters.
func (h HybridRunbookWorkerCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "vmResourceId", h.VMResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridRunbookWorkerCreateOrUpdateParameters.
func (h *HybridRunbookWorkerCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vmResourceId":
			err = unpopulate(val, "VMResourceID", &h.VMResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridRunbookWorkerCreateParameters.
func (h HybridRunbookWorkerCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridRunbookWorkerCreateParameters.
func (h *HybridRunbookWorkerCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridRunbookWorkerGroup.
func (h HybridRunbookWorkerGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "systemData", h.SystemData)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridRunbookWorkerGroup.
func (h *HybridRunbookWorkerGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &h.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridRunbookWorkerGroupCreateOrUpdateParameters.
func (h HybridRunbookWorkerGroupCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridRunbookWorkerGroupCreateOrUpdateParameters.
func (h *HybridRunbookWorkerGroupCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridRunbookWorkerGroupCreateOrUpdateProperties.
func (h HybridRunbookWorkerGroupCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "credential", h.Credential)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridRunbookWorkerGroupCreateOrUpdateProperties.
func (h *HybridRunbookWorkerGroupCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credential":
			err = unpopulate(val, "Credential", &h.Credential)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridRunbookWorkerGroupProperties.
func (h HybridRunbookWorkerGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "credential", h.Credential)
	populate(objectMap, "groupType", h.GroupType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridRunbookWorkerGroupProperties.
func (h *HybridRunbookWorkerGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credential":
			err = unpopulate(val, "Credential", &h.Credential)
			delete(rawMsg, key)
		case "groupType":
			err = unpopulate(val, "GroupType", &h.GroupType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridRunbookWorkerGroupsListResult.
func (h HybridRunbookWorkerGroupsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridRunbookWorkerGroupsListResult.
func (h *HybridRunbookWorkerGroupsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridRunbookWorkerMoveParameters.
func (h HybridRunbookWorkerMoveParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hybridRunbookWorkerGroupName", h.HybridRunbookWorkerGroupName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridRunbookWorkerMoveParameters.
func (h *HybridRunbookWorkerMoveParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hybridRunbookWorkerGroupName":
			err = unpopulate(val, "HybridRunbookWorkerGroupName", &h.HybridRunbookWorkerGroupName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridRunbookWorkerProperties.
func (h HybridRunbookWorkerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ip", h.IP)
	populateTimeRFC3339(objectMap, "lastSeenDateTime", h.LastSeenDateTime)
	populateTimeRFC3339(objectMap, "registeredDateTime", h.RegisteredDateTime)
	populate(objectMap, "vmResourceId", h.VMResourceID)
	populate(objectMap, "workerName", h.WorkerName)
	populate(objectMap, "workerType", h.WorkerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridRunbookWorkerProperties.
func (h *HybridRunbookWorkerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ip":
			err = unpopulate(val, "IP", &h.IP)
			delete(rawMsg, key)
		case "lastSeenDateTime":
			err = unpopulateTimeRFC3339(val, "LastSeenDateTime", &h.LastSeenDateTime)
			delete(rawMsg, key)
		case "registeredDateTime":
			err = unpopulateTimeRFC3339(val, "RegisteredDateTime", &h.RegisteredDateTime)
			delete(rawMsg, key)
		case "vmResourceId":
			err = unpopulate(val, "VMResourceID", &h.VMResourceID)
			delete(rawMsg, key)
		case "workerName":
			err = unpopulate(val, "WorkerName", &h.WorkerName)
			delete(rawMsg, key)
		case "workerType":
			err = unpopulate(val, "WorkerType", &h.WorkerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridRunbookWorkersListResult.
func (h HybridRunbookWorkersListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridRunbookWorkersListResult.
func (h *HybridRunbookWorkersListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssignedIdentities", i.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Identity.
func (i *Identity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &i.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &i.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &i.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Job.
func (j *Job) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobCollectionItem.
func (j JobCollectionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobCollectionItem.
func (j *JobCollectionItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobCollectionItemProperties.
func (j JobCollectionItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", j.CreationTime)
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "jobId", j.JobID)
	populateTimeRFC3339(objectMap, "lastModifiedTime", j.LastModifiedTime)
	populate(objectMap, "provisioningState", j.ProvisioningState)
	populate(objectMap, "runOn", j.RunOn)
	populate(objectMap, "runbook", j.Runbook)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "status", j.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobCollectionItemProperties.
func (j *JobCollectionItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &j.CreationTime)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &j.JobID)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &j.LastModifiedTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &j.ProvisioningState)
			delete(rawMsg, key)
		case "runOn":
			err = unpopulate(val, "RunOn", &j.RunOn)
			delete(rawMsg, key)
		case "runbook":
			err = unpopulate(val, "Runbook", &j.Runbook)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobCreateParameters.
func (j JobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", j.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobCreateParameters.
func (j *JobCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobCreateProperties.
func (j JobCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "parameters", j.Parameters)
	populate(objectMap, "runOn", j.RunOn)
	populate(objectMap, "runbook", j.Runbook)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobCreateProperties.
func (j *JobCreateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &j.Parameters)
			delete(rawMsg, key)
		case "runOn":
			err = unpopulate(val, "RunOn", &j.RunOn)
			delete(rawMsg, key)
		case "runbook":
			err = unpopulate(val, "Runbook", &j.Runbook)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobListResultV2.
func (j JobListResultV2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobListResultV2.
func (j *JobListResultV2) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobNavigation.
func (j JobNavigation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobNavigation.
func (j *JobNavigation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", j.CreationTime)
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "exception", j.Exception)
	populate(objectMap, "jobId", j.JobID)
	populateTimeRFC3339(objectMap, "lastModifiedTime", j.LastModifiedTime)
	populateTimeRFC3339(objectMap, "lastStatusModifiedTime", j.LastStatusModifiedTime)
	populate(objectMap, "parameters", j.Parameters)
	populate(objectMap, "provisioningState", j.ProvisioningState)
	populate(objectMap, "runOn", j.RunOn)
	populate(objectMap, "runbook", j.Runbook)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "startedBy", j.StartedBy)
	populate(objectMap, "status", j.Status)
	populate(objectMap, "statusDetails", j.StatusDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &j.CreationTime)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "exception":
			err = unpopulate(val, "Exception", &j.Exception)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &j.JobID)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &j.LastModifiedTime)
			delete(rawMsg, key)
		case "lastStatusModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastStatusModifiedTime", &j.LastStatusModifiedTime)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &j.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &j.ProvisioningState)
			delete(rawMsg, key)
		case "runOn":
			err = unpopulate(val, "RunOn", &j.RunOn)
			delete(rawMsg, key)
		case "runbook":
			err = unpopulate(val, "Runbook", &j.Runbook)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "startedBy":
			err = unpopulate(val, "StartedBy", &j.StartedBy)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &j.StatusDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobSchedule.
func (j JobSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobSchedule.
func (j *JobSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobScheduleCreateParameters.
func (j JobScheduleCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", j.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobScheduleCreateParameters.
func (j *JobScheduleCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobScheduleCreateProperties.
func (j JobScheduleCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "parameters", j.Parameters)
	populate(objectMap, "runOn", j.RunOn)
	populate(objectMap, "runbook", j.Runbook)
	populate(objectMap, "schedule", j.Schedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobScheduleCreateProperties.
func (j *JobScheduleCreateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &j.Parameters)
			delete(rawMsg, key)
		case "runOn":
			err = unpopulate(val, "RunOn", &j.RunOn)
			delete(rawMsg, key)
		case "runbook":
			err = unpopulate(val, "Runbook", &j.Runbook)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &j.Schedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobScheduleListResult.
func (j JobScheduleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobScheduleListResult.
func (j *JobScheduleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobScheduleProperties.
func (j JobScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "jobScheduleId", j.JobScheduleID)
	populate(objectMap, "parameters", j.Parameters)
	populate(objectMap, "runOn", j.RunOn)
	populate(objectMap, "runbook", j.Runbook)
	populate(objectMap, "schedule", j.Schedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobScheduleProperties.
func (j *JobScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobScheduleId":
			err = unpopulate(val, "JobScheduleID", &j.JobScheduleID)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &j.Parameters)
			delete(rawMsg, key)
		case "runOn":
			err = unpopulate(val, "RunOn", &j.RunOn)
			delete(rawMsg, key)
		case "runbook":
			err = unpopulate(val, "Runbook", &j.Runbook)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &j.Schedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStream.
func (j JobStream) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "properties", j.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStream.
func (j *JobStream) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStreamListResult.
func (j JobStreamListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStreamListResult.
func (j *JobStreamListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStreamProperties.
func (j JobStreamProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "jobStreamId", j.JobStreamID)
	populate(objectMap, "streamText", j.StreamText)
	populate(objectMap, "streamType", j.StreamType)
	populate(objectMap, "summary", j.Summary)
	populateTimeRFC3339(objectMap, "time", j.Time)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStreamProperties.
func (j *JobStreamProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobStreamId":
			err = unpopulate(val, "JobStreamID", &j.JobStreamID)
			delete(rawMsg, key)
		case "streamText":
			err = unpopulate(val, "StreamText", &j.StreamText)
			delete(rawMsg, key)
		case "streamType":
			err = unpopulate(val, "StreamType", &j.StreamType)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &j.Summary)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &j.Time)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Key.
func (k Key) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "KeyName", k.KeyName)
	populate(objectMap, "Permissions", k.Permissions)
	populate(objectMap, "Value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Key.
func (k *Key) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "KeyName":
			err = unpopulate(val, "KeyName", &k.KeyName)
			delete(rawMsg, key)
		case "Permissions":
			err = unpopulate(val, "Permissions", &k.Permissions)
			delete(rawMsg, key)
		case "Value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyListResult.
func (k KeyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keys", k.Keys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyListResult.
func (k *KeyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keys":
			err = unpopulate(val, "Keys", &k.Keys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultProperties.
func (k KeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyName", k.KeyName)
	populate(objectMap, "keyVersion", k.KeyVersion)
	populate(objectMap, "keyvaultUri", k.KeyvaultURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultProperties.
func (k *KeyVaultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyName":
			err = unpopulate(val, "KeyName", &k.KeyName)
			delete(rawMsg, key)
		case "keyVersion":
			err = unpopulate(val, "KeyVersion", &k.KeyVersion)
			delete(rawMsg, key)
		case "keyvaultUri":
			err = unpopulate(val, "KeyvaultURI", &k.KeyvaultURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedWorkspace.
func (l LinkedWorkspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", l.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedWorkspace.
func (l *LinkedWorkspace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxProperties.
func (l LinuxProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "excludedPackageNameMasks", l.ExcludedPackageNameMasks)
	populate(objectMap, "includedPackageClassifications", l.IncludedPackageClassifications)
	populate(objectMap, "includedPackageNameMasks", l.IncludedPackageNameMasks)
	populate(objectMap, "rebootSetting", l.RebootSetting)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxProperties.
func (l *LinuxProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "excludedPackageNameMasks":
			err = unpopulate(val, "ExcludedPackageNameMasks", &l.ExcludedPackageNameMasks)
			delete(rawMsg, key)
		case "includedPackageClassifications":
			err = unpopulate(val, "IncludedPackageClassifications", &l.IncludedPackageClassifications)
			delete(rawMsg, key)
		case "includedPackageNameMasks":
			err = unpopulate(val, "IncludedPackageNameMasks", &l.IncludedPackageNameMasks)
			delete(rawMsg, key)
		case "rebootSetting":
			err = unpopulate(val, "RebootSetting", &l.RebootSetting)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Module.
func (m Module) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Module.
func (m *Module) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModuleCreateOrUpdateParameters.
func (m ModuleCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModuleCreateOrUpdateParameters.
func (m *ModuleCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModuleCreateOrUpdateProperties.
func (m ModuleCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentLink", m.ContentLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModuleCreateOrUpdateProperties.
func (m *ModuleCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentLink":
			err = unpopulate(val, "ContentLink", &m.ContentLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModuleErrorInfo.
func (m ModuleErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", m.Code)
	populate(objectMap, "message", m.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModuleErrorInfo.
func (m *ModuleErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModuleListResult.
func (m ModuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModuleListResult.
func (m *ModuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModuleProperties.
func (m ModuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "activityCount", m.ActivityCount)
	populate(objectMap, "contentLink", m.ContentLink)
	populateTimeRFC3339(objectMap, "creationTime", m.CreationTime)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "error", m.Error)
	populate(objectMap, "isComposite", m.IsComposite)
	populate(objectMap, "isGlobal", m.IsGlobal)
	populateTimeRFC3339(objectMap, "lastModifiedTime", m.LastModifiedTime)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "sizeInBytes", m.SizeInBytes)
	populate(objectMap, "version", m.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModuleProperties.
func (m *ModuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityCount":
			err = unpopulate(val, "ActivityCount", &m.ActivityCount)
			delete(rawMsg, key)
		case "contentLink":
			err = unpopulate(val, "ContentLink", &m.ContentLink)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &m.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "isComposite":
			err = unpopulate(val, "IsComposite", &m.IsComposite)
			delete(rawMsg, key)
		case "isGlobal":
			err = unpopulate(val, "IsGlobal", &m.IsGlobal)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &m.LastModifiedTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &m.SizeInBytes)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &m.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModuleUpdateParameters.
func (m ModuleUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModuleUpdateParameters.
func (m *ModuleUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModuleUpdateProperties.
func (m ModuleUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentLink", m.ContentLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModuleUpdateProperties.
func (m *ModuleUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentLink":
			err = unpopulate(val, "ContentLink", &m.ContentLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NodeCount.
func (n NodeCount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NodeCount.
func (n *NodeCount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NodeCountProperties.
func (n NodeCountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "count", n.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NodeCountProperties.
func (n *NodeCountProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &n.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NodeCounts.
func (n NodeCounts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "totalCount", n.TotalCount)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NodeCounts.
func (n *NodeCounts) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "totalCount":
			err = unpopulate(val, "TotalCount", &n.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NonAzureQueryProperties.
func (n NonAzureQueryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "functionAlias", n.FunctionAlias)
	populate(objectMap, "workspaceId", n.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NonAzureQueryProperties.
func (n *NonAzureQueryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "functionAlias":
			err = unpopulate(val, "FunctionAlias", &n.FunctionAlias)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &n.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupIds", p.GroupIDs)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupIds":
			err = unpopulate(val, "GroupIDs", &p.GroupIDs)
			delete(rawMsg, key)
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointProperty.
func (p PrivateEndpointProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointProperty.
func (p *PrivateEndpointProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionStateProperty.
func (p PrivateLinkServiceConnectionStateProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionStateProperty.
func (p *PrivateLinkServiceConnectionStateProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PythonPackageCreateParameters.
func (p PythonPackageCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PythonPackageCreateParameters.
func (p *PythonPackageCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PythonPackageCreateProperties.
func (p PythonPackageCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentLink", p.ContentLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PythonPackageCreateProperties.
func (p *PythonPackageCreateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentLink":
			err = unpopulate(val, "ContentLink", &p.ContentLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PythonPackageUpdateParameters.
func (p PythonPackageUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PythonPackageUpdateParameters.
func (p *PythonPackageUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RawGraphicalRunbookContent.
func (r RawGraphicalRunbookContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "runbookDefinition", r.RunbookDefinition)
	populate(objectMap, "runbookType", r.RunbookType)
	populate(objectMap, "schemaVersion", r.SchemaVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RawGraphicalRunbookContent.
func (r *RawGraphicalRunbookContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "runbookDefinition":
			err = unpopulate(val, "RunbookDefinition", &r.RunbookDefinition)
			delete(rawMsg, key)
		case "runbookType":
			err = unpopulate(val, "RunbookType", &r.RunbookType)
			delete(rawMsg, key)
		case "schemaVersion":
			err = unpopulate(val, "SchemaVersion", &r.SchemaVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunAsCredentialAssociationProperty.
func (r RunAsCredentialAssociationProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunAsCredentialAssociationProperty.
func (r *RunAsCredentialAssociationProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Runbook.
func (r Runbook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Runbook.
func (r *Runbook) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookAssociationProperty.
func (r RunbookAssociationProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookAssociationProperty.
func (r *RunbookAssociationProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookCreateOrUpdateDraftParameters.
func (r RunbookCreateOrUpdateDraftParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "runbookContent", r.RunbookContent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookCreateOrUpdateDraftParameters.
func (r *RunbookCreateOrUpdateDraftParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "runbookContent":
			err = unpopulate(val, "RunbookContent", &r.RunbookContent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookCreateOrUpdateDraftProperties.
func (r RunbookCreateOrUpdateDraftProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", r.Description)
	populate(objectMap, "draft", r.Draft)
	populate(objectMap, "logActivityTrace", r.LogActivityTrace)
	populate(objectMap, "logProgress", r.LogProgress)
	populate(objectMap, "logVerbose", r.LogVerbose)
	populate(objectMap, "runbookType", r.RunbookType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookCreateOrUpdateDraftProperties.
func (r *RunbookCreateOrUpdateDraftProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "draft":
			err = unpopulate(val, "Draft", &r.Draft)
			delete(rawMsg, key)
		case "logActivityTrace":
			err = unpopulate(val, "LogActivityTrace", &r.LogActivityTrace)
			delete(rawMsg, key)
		case "logProgress":
			err = unpopulate(val, "LogProgress", &r.LogProgress)
			delete(rawMsg, key)
		case "logVerbose":
			err = unpopulate(val, "LogVerbose", &r.LogVerbose)
			delete(rawMsg, key)
		case "runbookType":
			err = unpopulate(val, "RunbookType", &r.RunbookType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookCreateOrUpdateParameters.
func (r RunbookCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookCreateOrUpdateParameters.
func (r *RunbookCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookCreateOrUpdateProperties.
func (r RunbookCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", r.Description)
	populate(objectMap, "draft", r.Draft)
	populate(objectMap, "logActivityTrace", r.LogActivityTrace)
	populate(objectMap, "logProgress", r.LogProgress)
	populate(objectMap, "logVerbose", r.LogVerbose)
	populate(objectMap, "publishContentLink", r.PublishContentLink)
	populate(objectMap, "runbookType", r.RunbookType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookCreateOrUpdateProperties.
func (r *RunbookCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "draft":
			err = unpopulate(val, "Draft", &r.Draft)
			delete(rawMsg, key)
		case "logActivityTrace":
			err = unpopulate(val, "LogActivityTrace", &r.LogActivityTrace)
			delete(rawMsg, key)
		case "logProgress":
			err = unpopulate(val, "LogProgress", &r.LogProgress)
			delete(rawMsg, key)
		case "logVerbose":
			err = unpopulate(val, "LogVerbose", &r.LogVerbose)
			delete(rawMsg, key)
		case "publishContentLink":
			err = unpopulate(val, "PublishContentLink", &r.PublishContentLink)
			delete(rawMsg, key)
		case "runbookType":
			err = unpopulate(val, "RunbookType", &r.RunbookType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookDraft.
func (r RunbookDraft) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", r.CreationTime)
	populate(objectMap, "draftContentLink", r.DraftContentLink)
	populate(objectMap, "inEdit", r.InEdit)
	populateTimeRFC3339(objectMap, "lastModifiedTime", r.LastModifiedTime)
	populate(objectMap, "outputTypes", r.OutputTypes)
	populate(objectMap, "parameters", r.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookDraft.
func (r *RunbookDraft) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &r.CreationTime)
			delete(rawMsg, key)
		case "draftContentLink":
			err = unpopulate(val, "DraftContentLink", &r.DraftContentLink)
			delete(rawMsg, key)
		case "inEdit":
			err = unpopulate(val, "InEdit", &r.InEdit)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &r.LastModifiedTime)
			delete(rawMsg, key)
		case "outputTypes":
			err = unpopulate(val, "OutputTypes", &r.OutputTypes)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &r.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookDraftUndoEditResult.
func (r RunbookDraftUndoEditResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "requestId", r.RequestID)
	populate(objectMap, "statusCode", r.StatusCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookDraftUndoEditResult.
func (r *RunbookDraftUndoEditResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requestId":
			err = unpopulate(val, "RequestID", &r.RequestID)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &r.StatusCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookListResult.
func (r RunbookListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookListResult.
func (r *RunbookListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookParameter.
func (r RunbookParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultValue", r.DefaultValue)
	populate(objectMap, "isMandatory", r.IsMandatory)
	populate(objectMap, "position", r.Position)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookParameter.
func (r *RunbookParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultValue":
			err = unpopulate(val, "DefaultValue", &r.DefaultValue)
			delete(rawMsg, key)
		case "isMandatory":
			err = unpopulate(val, "IsMandatory", &r.IsMandatory)
			delete(rawMsg, key)
		case "position":
			err = unpopulate(val, "Position", &r.Position)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookProperties.
func (r RunbookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", r.CreationTime)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "draft", r.Draft)
	populate(objectMap, "jobCount", r.JobCount)
	populate(objectMap, "lastModifiedBy", r.LastModifiedBy)
	populateTimeRFC3339(objectMap, "lastModifiedTime", r.LastModifiedTime)
	populate(objectMap, "logActivityTrace", r.LogActivityTrace)
	populate(objectMap, "logProgress", r.LogProgress)
	populate(objectMap, "logVerbose", r.LogVerbose)
	populate(objectMap, "outputTypes", r.OutputTypes)
	populate(objectMap, "parameters", r.Parameters)
	objectMap["provisioningState"] = "Succeeded"
	populate(objectMap, "publishContentLink", r.PublishContentLink)
	populate(objectMap, "runbookType", r.RunbookType)
	populate(objectMap, "state", r.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookProperties.
func (r *RunbookProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &r.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "draft":
			err = unpopulate(val, "Draft", &r.Draft)
			delete(rawMsg, key)
		case "jobCount":
			err = unpopulate(val, "JobCount", &r.JobCount)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &r.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &r.LastModifiedTime)
			delete(rawMsg, key)
		case "logActivityTrace":
			err = unpopulate(val, "LogActivityTrace", &r.LogActivityTrace)
			delete(rawMsg, key)
		case "logProgress":
			err = unpopulate(val, "LogProgress", &r.LogProgress)
			delete(rawMsg, key)
		case "logVerbose":
			err = unpopulate(val, "LogVerbose", &r.LogVerbose)
			delete(rawMsg, key)
		case "outputTypes":
			err = unpopulate(val, "OutputTypes", &r.OutputTypes)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &r.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "publishContentLink":
			err = unpopulate(val, "PublishContentLink", &r.PublishContentLink)
			delete(rawMsg, key)
		case "runbookType":
			err = unpopulate(val, "RunbookType", &r.RunbookType)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &r.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookUpdateParameters.
func (r RunbookUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookUpdateParameters.
func (r *RunbookUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunbookUpdateProperties.
func (r RunbookUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", r.Description)
	populate(objectMap, "logActivityTrace", r.LogActivityTrace)
	populate(objectMap, "logProgress", r.LogProgress)
	populate(objectMap, "logVerbose", r.LogVerbose)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunbookUpdateProperties.
func (r *RunbookUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "logActivityTrace":
			err = unpopulate(val, "LogActivityTrace", &r.LogActivityTrace)
			delete(rawMsg, key)
		case "logProgress":
			err = unpopulate(val, "LogProgress", &r.LogProgress)
			delete(rawMsg, key)
		case "logVerbose":
			err = unpopulate(val, "LogVerbose", &r.LogVerbose)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "family", s.Family)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &s.Family)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SUCScheduleProperties.
func (s SUCScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "advancedSchedule", s.AdvancedSchedule)
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "description", s.Description)
	populateTimeRFC3339(objectMap, "expiryTime", s.ExpiryTime)
	populate(objectMap, "expiryTimeOffsetMinutes", s.ExpiryTimeOffsetMinutes)
	populate(objectMap, "frequency", s.Frequency)
	populate(objectMap, "interval", s.Interval)
	populate(objectMap, "isEnabled", s.IsEnabled)
	populateTimeRFC3339(objectMap, "lastModifiedTime", s.LastModifiedTime)
	populateTimeRFC3339(objectMap, "nextRun", s.NextRun)
	populate(objectMap, "nextRunOffsetMinutes", s.NextRunOffsetMinutes)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "startTimeOffsetMinutes", s.StartTimeOffsetMinutes)
	populate(objectMap, "timeZone", s.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SUCScheduleProperties.
func (s *SUCScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "advancedSchedule":
			err = unpopulate(val, "AdvancedSchedule", &s.AdvancedSchedule)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &s.ExpiryTime)
			delete(rawMsg, key)
		case "expiryTimeOffsetMinutes":
			err = unpopulate(val, "ExpiryTimeOffsetMinutes", &s.ExpiryTimeOffsetMinutes)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &s.Frequency)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &s.Interval)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &s.IsEnabled)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &s.LastModifiedTime)
			delete(rawMsg, key)
		case "nextRun":
			err = unpopulateTimeRFC3339(val, "NextRun", &s.NextRun)
			delete(rawMsg, key)
		case "nextRunOffsetMinutes":
			err = unpopulate(val, "NextRunOffsetMinutes", &s.NextRunOffsetMinutes)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "startTimeOffsetMinutes":
			err = unpopulate(val, "StartTimeOffsetMinutes", &s.StartTimeOffsetMinutes)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &s.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Schedule.
func (s *Schedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleAssociationProperty.
func (s ScheduleAssociationProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleAssociationProperty.
func (s *ScheduleAssociationProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleCreateOrUpdateParameters.
func (s ScheduleCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleCreateOrUpdateParameters.
func (s *ScheduleCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleCreateOrUpdateProperties.
func (s ScheduleCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "advancedSchedule", s.AdvancedSchedule)
	populate(objectMap, "description", s.Description)
	populateTimeRFC3339(objectMap, "expiryTime", s.ExpiryTime)
	populate(objectMap, "frequency", s.Frequency)
	populate(objectMap, "interval", &s.Interval)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "timeZone", s.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleCreateOrUpdateProperties.
func (s *ScheduleCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "advancedSchedule":
			err = unpopulate(val, "AdvancedSchedule", &s.AdvancedSchedule)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &s.ExpiryTime)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &s.Frequency)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &s.Interval)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &s.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleListResult.
func (s ScheduleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleListResult.
func (s *ScheduleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleProperties.
func (s ScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "advancedSchedule", s.AdvancedSchedule)
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "description", s.Description)
	populateTimeRFC3339(objectMap, "expiryTime", s.ExpiryTime)
	populate(objectMap, "expiryTimeOffsetMinutes", s.ExpiryTimeOffsetMinutes)
	populate(objectMap, "frequency", s.Frequency)
	populate(objectMap, "interval", &s.Interval)
	populate(objectMap, "isEnabled", s.IsEnabled)
	populateTimeRFC3339(objectMap, "lastModifiedTime", s.LastModifiedTime)
	populateTimeRFC3339(objectMap, "nextRun", s.NextRun)
	populate(objectMap, "nextRunOffsetMinutes", s.NextRunOffsetMinutes)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "startTimeOffsetMinutes", s.StartTimeOffsetMinutes)
	populate(objectMap, "timeZone", s.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleProperties.
func (s *ScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "advancedSchedule":
			err = unpopulate(val, "AdvancedSchedule", &s.AdvancedSchedule)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &s.ExpiryTime)
			delete(rawMsg, key)
		case "expiryTimeOffsetMinutes":
			err = unpopulate(val, "ExpiryTimeOffsetMinutes", &s.ExpiryTimeOffsetMinutes)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &s.Frequency)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &s.Interval)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &s.IsEnabled)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &s.LastModifiedTime)
			delete(rawMsg, key)
		case "nextRun":
			err = unpopulateTimeRFC3339(val, "NextRun", &s.NextRun)
			delete(rawMsg, key)
		case "nextRunOffsetMinutes":
			err = unpopulate(val, "NextRunOffsetMinutes", &s.NextRunOffsetMinutes)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "startTimeOffsetMinutes":
			err = unpopulate(val, "StartTimeOffsetMinutes", &s.StartTimeOffsetMinutes)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &s.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleUpdateParameters.
func (s ScheduleUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleUpdateParameters.
func (s *ScheduleUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleUpdateProperties.
func (s ScheduleUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", s.Description)
	populate(objectMap, "isEnabled", s.IsEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleUpdateProperties.
func (s *ScheduleUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &s.IsEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfiguration.
func (s SoftwareUpdateConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfiguration.
func (s *SoftwareUpdateConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationCollectionItem.
func (s SoftwareUpdateConfigurationCollectionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationCollectionItem.
func (s *SoftwareUpdateConfigurationCollectionItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationCollectionItemProperties.
func (s SoftwareUpdateConfigurationCollectionItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "frequency", s.Frequency)
	populateTimeRFC3339(objectMap, "lastModifiedTime", s.LastModifiedTime)
	populateTimeRFC3339(objectMap, "nextRun", s.NextRun)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "tasks", s.Tasks)
	populate(objectMap, "updateConfiguration", s.UpdateConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationCollectionItemProperties.
func (s *SoftwareUpdateConfigurationCollectionItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &s.Frequency)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &s.LastModifiedTime)
			delete(rawMsg, key)
		case "nextRun":
			err = unpopulateTimeRFC3339(val, "NextRun", &s.NextRun)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "tasks":
			err = unpopulate(val, "Tasks", &s.Tasks)
			delete(rawMsg, key)
		case "updateConfiguration":
			err = unpopulate(val, "UpdateConfiguration", &s.UpdateConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationListResult.
func (s SoftwareUpdateConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationListResult.
func (s *SoftwareUpdateConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationMachineRun.
func (s SoftwareUpdateConfigurationMachineRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationMachineRun.
func (s *SoftwareUpdateConfigurationMachineRun) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationMachineRunListResult.
func (s SoftwareUpdateConfigurationMachineRunListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationMachineRunListResult.
func (s *SoftwareUpdateConfigurationMachineRunListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationProperties.
func (s SoftwareUpdateConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "createdBy", s.CreatedBy)
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "error", s.Error)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populateTimeRFC3339(objectMap, "lastModifiedTime", s.LastModifiedTime)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "scheduleInfo", s.ScheduleInfo)
	populate(objectMap, "tasks", s.Tasks)
	populate(objectMap, "updateConfiguration", s.UpdateConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationProperties.
func (s *SoftwareUpdateConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &s.Error)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &s.LastModifiedTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "scheduleInfo":
			err = unpopulate(val, "ScheduleInfo", &s.ScheduleInfo)
			delete(rawMsg, key)
		case "tasks":
			err = unpopulate(val, "Tasks", &s.Tasks)
			delete(rawMsg, key)
		case "updateConfiguration":
			err = unpopulate(val, "UpdateConfiguration", &s.UpdateConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationRun.
func (s SoftwareUpdateConfigurationRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationRun.
func (s *SoftwareUpdateConfigurationRun) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationRunListResult.
func (s SoftwareUpdateConfigurationRunListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationRunListResult.
func (s *SoftwareUpdateConfigurationRunListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationRunProperties.
func (s SoftwareUpdateConfigurationRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computerCount", s.ComputerCount)
	populate(objectMap, "configuredDuration", s.ConfiguredDuration)
	populate(objectMap, "createdBy", s.CreatedBy)
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "failedCount", s.FailedCount)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populateTimeRFC3339(objectMap, "lastModifiedTime", s.LastModifiedTime)
	populate(objectMap, "osType", s.OSType)
	populate(objectMap, "softwareUpdateConfiguration", s.SoftwareUpdateConfiguration)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "tasks", s.Tasks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationRunProperties.
func (s *SoftwareUpdateConfigurationRunProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computerCount":
			err = unpopulate(val, "ComputerCount", &s.ComputerCount)
			delete(rawMsg, key)
		case "configuredDuration":
			err = unpopulate(val, "ConfiguredDuration", &s.ConfiguredDuration)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "failedCount":
			err = unpopulate(val, "FailedCount", &s.FailedCount)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &s.LastModifiedTime)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		case "softwareUpdateConfiguration":
			err = unpopulate(val, "SoftwareUpdateConfiguration", &s.SoftwareUpdateConfiguration)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "tasks":
			err = unpopulate(val, "Tasks", &s.Tasks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationRunTaskProperties.
func (s SoftwareUpdateConfigurationRunTaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "jobId", s.JobID)
	populate(objectMap, "source", s.Source)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationRunTaskProperties.
func (s *SoftwareUpdateConfigurationRunTaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobId":
			err = unpopulate(val, "JobID", &s.JobID)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &s.Source)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationRunTasks.
func (s SoftwareUpdateConfigurationRunTasks) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "postTask", s.PostTask)
	populate(objectMap, "preTask", s.PreTask)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationRunTasks.
func (s *SoftwareUpdateConfigurationRunTasks) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "postTask":
			err = unpopulate(val, "PostTask", &s.PostTask)
			delete(rawMsg, key)
		case "preTask":
			err = unpopulate(val, "PreTask", &s.PreTask)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareUpdateConfigurationTasks.
func (s SoftwareUpdateConfigurationTasks) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "postTask", s.PostTask)
	populate(objectMap, "preTask", s.PreTask)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareUpdateConfigurationTasks.
func (s *SoftwareUpdateConfigurationTasks) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "postTask":
			err = unpopulate(val, "PostTask", &s.PostTask)
			delete(rawMsg, key)
		case "preTask":
			err = unpopulate(val, "PreTask", &s.PreTask)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControl.
func (s SourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControl.
func (s *SourceControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlCreateOrUpdateParameters.
func (s SourceControlCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlCreateOrUpdateParameters.
func (s *SourceControlCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlCreateOrUpdateProperties.
func (s SourceControlCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoSync", s.AutoSync)
	populate(objectMap, "branch", s.Branch)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "folderPath", s.FolderPath)
	populate(objectMap, "publishRunbook", s.PublishRunbook)
	populate(objectMap, "repoUrl", s.RepoURL)
	populate(objectMap, "securityToken", s.SecurityToken)
	populate(objectMap, "sourceType", s.SourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlCreateOrUpdateProperties.
func (s *SourceControlCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoSync":
			err = unpopulate(val, "AutoSync", &s.AutoSync)
			delete(rawMsg, key)
		case "branch":
			err = unpopulate(val, "Branch", &s.Branch)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &s.FolderPath)
			delete(rawMsg, key)
		case "publishRunbook":
			err = unpopulate(val, "PublishRunbook", &s.PublishRunbook)
			delete(rawMsg, key)
		case "repoUrl":
			err = unpopulate(val, "RepoURL", &s.RepoURL)
			delete(rawMsg, key)
		case "securityToken":
			err = unpopulate(val, "SecurityToken", &s.SecurityToken)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &s.SourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlListResult.
func (s SourceControlListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlListResult.
func (s *SourceControlListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlProperties.
func (s SourceControlProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoSync", s.AutoSync)
	populate(objectMap, "branch", s.Branch)
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "folderPath", s.FolderPath)
	populateTimeRFC3339(objectMap, "lastModifiedTime", s.LastModifiedTime)
	populate(objectMap, "publishRunbook", s.PublishRunbook)
	populate(objectMap, "repoUrl", s.RepoURL)
	populate(objectMap, "sourceType", s.SourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlProperties.
func (s *SourceControlProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoSync":
			err = unpopulate(val, "AutoSync", &s.AutoSync)
			delete(rawMsg, key)
		case "branch":
			err = unpopulate(val, "Branch", &s.Branch)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &s.FolderPath)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &s.LastModifiedTime)
			delete(rawMsg, key)
		case "publishRunbook":
			err = unpopulate(val, "PublishRunbook", &s.PublishRunbook)
			delete(rawMsg, key)
		case "repoUrl":
			err = unpopulate(val, "RepoURL", &s.RepoURL)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &s.SourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSecurityTokenProperties.
func (s SourceControlSecurityTokenProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessToken", s.AccessToken)
	populate(objectMap, "refreshToken", s.RefreshToken)
	populate(objectMap, "tokenType", s.TokenType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSecurityTokenProperties.
func (s *SourceControlSecurityTokenProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			err = unpopulate(val, "AccessToken", &s.AccessToken)
			delete(rawMsg, key)
		case "refreshToken":
			err = unpopulate(val, "RefreshToken", &s.RefreshToken)
			delete(rawMsg, key)
		case "tokenType":
			err = unpopulate(val, "TokenType", &s.TokenType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJob.
func (s SourceControlSyncJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJob.
func (s *SourceControlSyncJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJobByID.
func (s SourceControlSyncJobByID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJobByID.
func (s *SourceControlSyncJobByID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJobByIDProperties.
func (s SourceControlSyncJobByIDProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "exception", s.Exception)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "sourceControlSyncJobId", s.SourceControlSyncJobID)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "syncType", s.SyncType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJobByIDProperties.
func (s *SourceControlSyncJobByIDProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "exception":
			err = unpopulate(val, "Exception", &s.Exception)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "sourceControlSyncJobId":
			err = unpopulate(val, "SourceControlSyncJobID", &s.SourceControlSyncJobID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "syncType":
			err = unpopulate(val, "SyncType", &s.SyncType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJobCreateParameters.
func (s SourceControlSyncJobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJobCreateParameters.
func (s *SourceControlSyncJobCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJobCreateProperties.
func (s SourceControlSyncJobCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "commitId", s.CommitID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJobCreateProperties.
func (s *SourceControlSyncJobCreateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commitId":
			err = unpopulate(val, "CommitID", &s.CommitID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJobListResult.
func (s SourceControlSyncJobListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJobListResult.
func (s *SourceControlSyncJobListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJobProperties.
func (s SourceControlSyncJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "sourceControlSyncJobId", s.SourceControlSyncJobID)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "syncType", s.SyncType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJobProperties.
func (s *SourceControlSyncJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "sourceControlSyncJobId":
			err = unpopulate(val, "SourceControlSyncJobID", &s.SourceControlSyncJobID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "syncType":
			err = unpopulate(val, "SyncType", &s.SyncType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJobStream.
func (s SourceControlSyncJobStream) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJobStream.
func (s *SourceControlSyncJobStream) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJobStreamByID.
func (s SourceControlSyncJobStreamByID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJobStreamByID.
func (s *SourceControlSyncJobStreamByID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJobStreamByIDProperties.
func (s SourceControlSyncJobStreamByIDProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sourceControlSyncJobStreamId", s.SourceControlSyncJobStreamID)
	populate(objectMap, "streamText", s.StreamText)
	populate(objectMap, "streamType", s.StreamType)
	populate(objectMap, "summary", s.Summary)
	populateTimeRFC3339(objectMap, "time", s.Time)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJobStreamByIDProperties.
func (s *SourceControlSyncJobStreamByIDProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceControlSyncJobStreamId":
			err = unpopulate(val, "SourceControlSyncJobStreamID", &s.SourceControlSyncJobStreamID)
			delete(rawMsg, key)
		case "streamText":
			err = unpopulate(val, "StreamText", &s.StreamText)
			delete(rawMsg, key)
		case "streamType":
			err = unpopulate(val, "StreamType", &s.StreamType)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &s.Summary)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &s.Time)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJobStreamProperties.
func (s SourceControlSyncJobStreamProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sourceControlSyncJobStreamId", s.SourceControlSyncJobStreamID)
	populate(objectMap, "streamType", s.StreamType)
	populate(objectMap, "summary", s.Summary)
	populateTimeRFC3339(objectMap, "time", s.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJobStreamProperties.
func (s *SourceControlSyncJobStreamProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceControlSyncJobStreamId":
			err = unpopulate(val, "SourceControlSyncJobStreamID", &s.SourceControlSyncJobStreamID)
			delete(rawMsg, key)
		case "streamType":
			err = unpopulate(val, "StreamType", &s.StreamType)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &s.Summary)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &s.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlSyncJobStreamsListBySyncJob.
func (s SourceControlSyncJobStreamsListBySyncJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlSyncJobStreamsListBySyncJob.
func (s *SourceControlSyncJobStreamsListBySyncJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlUpdateParameters.
func (s SourceControlUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlUpdateParameters.
func (s *SourceControlUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlUpdateProperties.
func (s SourceControlUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoSync", s.AutoSync)
	populate(objectMap, "branch", s.Branch)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "folderPath", s.FolderPath)
	populate(objectMap, "publishRunbook", s.PublishRunbook)
	populate(objectMap, "securityToken", s.SecurityToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlUpdateProperties.
func (s *SourceControlUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoSync":
			err = unpopulate(val, "AutoSync", &s.AutoSync)
			delete(rawMsg, key)
		case "branch":
			err = unpopulate(val, "Branch", &s.Branch)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &s.FolderPath)
			delete(rawMsg, key)
		case "publishRunbook":
			err = unpopulate(val, "PublishRunbook", &s.PublishRunbook)
			delete(rawMsg, key)
		case "securityToken":
			err = unpopulate(val, "SecurityToken", &s.SecurityToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Statistics.
func (s Statistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "counterProperty", s.CounterProperty)
	populate(objectMap, "counterValue", s.CounterValue)
	populateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "id", s.ID)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Statistics.
func (s *Statistics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "counterProperty":
			err = unpopulate(val, "CounterProperty", &s.CounterProperty)
			delete(rawMsg, key)
		case "counterValue":
			err = unpopulate(val, "CounterValue", &s.CounterValue)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatisticsListResult.
func (s StatisticsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatisticsListResult.
func (s *StatisticsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagSettingsProperties.
func (t TagSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filterOperator", t.FilterOperator)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagSettingsProperties.
func (t *TagSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filterOperator":
			err = unpopulate(val, "FilterOperator", &t.FilterOperator)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetProperties.
func (t TargetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureQueries", t.AzureQueries)
	populate(objectMap, "nonAzureQueries", t.NonAzureQueries)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetProperties.
func (t *TargetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureQueries":
			err = unpopulate(val, "AzureQueries", &t.AzureQueries)
			delete(rawMsg, key)
		case "nonAzureQueries":
			err = unpopulate(val, "NonAzureQueries", &t.NonAzureQueries)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskProperties.
func (t TaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "parameters", t.Parameters)
	populate(objectMap, "source", t.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskProperties.
func (t *TaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &t.Parameters)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &t.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestJob.
func (t TestJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", t.CreationTime)
	populateTimeRFC3339(objectMap, "endTime", t.EndTime)
	populate(objectMap, "exception", t.Exception)
	populateTimeRFC3339(objectMap, "lastModifiedTime", t.LastModifiedTime)
	populateTimeRFC3339(objectMap, "lastStatusModifiedTime", t.LastStatusModifiedTime)
	populate(objectMap, "logActivityTrace", t.LogActivityTrace)
	populate(objectMap, "parameters", t.Parameters)
	populate(objectMap, "runOn", t.RunOn)
	populateTimeRFC3339(objectMap, "startTime", t.StartTime)
	populate(objectMap, "status", t.Status)
	populate(objectMap, "statusDetails", t.StatusDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestJob.
func (t *TestJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &t.CreationTime)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &t.EndTime)
			delete(rawMsg, key)
		case "exception":
			err = unpopulate(val, "Exception", &t.Exception)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &t.LastModifiedTime)
			delete(rawMsg, key)
		case "lastStatusModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastStatusModifiedTime", &t.LastStatusModifiedTime)
			delete(rawMsg, key)
		case "logActivityTrace":
			err = unpopulate(val, "LogActivityTrace", &t.LogActivityTrace)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &t.Parameters)
			delete(rawMsg, key)
		case "runOn":
			err = unpopulate(val, "RunOn", &t.RunOn)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &t.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &t.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &t.StatusDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestJobCreateParameters.
func (t TestJobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "parameters", t.Parameters)
	populate(objectMap, "runOn", t.RunOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestJobCreateParameters.
func (t *TestJobCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &t.Parameters)
			delete(rawMsg, key)
		case "runOn":
			err = unpopulate(val, "RunOn", &t.RunOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TypeField.
func (t TypeField) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", t.Name)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TypeField.
func (t *TypeField) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TypeFieldListResult.
func (t TypeFieldListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TypeFieldListResult.
func (t *TypeFieldListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateConfiguration.
func (u UpdateConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureVirtualMachines", u.AzureVirtualMachines)
	populate(objectMap, "duration", u.Duration)
	populate(objectMap, "linux", u.Linux)
	populate(objectMap, "nonAzureComputerNames", u.NonAzureComputerNames)
	populate(objectMap, "operatingSystem", u.OperatingSystem)
	populate(objectMap, "targets", u.Targets)
	populate(objectMap, "windows", u.Windows)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateConfiguration.
func (u *UpdateConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureVirtualMachines":
			err = unpopulate(val, "AzureVirtualMachines", &u.AzureVirtualMachines)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &u.Duration)
			delete(rawMsg, key)
		case "linux":
			err = unpopulate(val, "Linux", &u.Linux)
			delete(rawMsg, key)
		case "nonAzureComputerNames":
			err = unpopulate(val, "NonAzureComputerNames", &u.NonAzureComputerNames)
			delete(rawMsg, key)
		case "operatingSystem":
			err = unpopulate(val, "OperatingSystem", &u.OperatingSystem)
			delete(rawMsg, key)
		case "targets":
			err = unpopulate(val, "Targets", &u.Targets)
			delete(rawMsg, key)
		case "windows":
			err = unpopulate(val, "Windows", &u.Windows)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateConfigurationMachineRunProperties.
func (u UpdateConfigurationMachineRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuredDuration", u.ConfiguredDuration)
	populate(objectMap, "correlationId", u.CorrelationID)
	populate(objectMap, "createdBy", u.CreatedBy)
	populateTimeRFC3339(objectMap, "creationTime", u.CreationTime)
	populateTimeRFC3339(objectMap, "endTime", u.EndTime)
	populate(objectMap, "error", u.Error)
	populate(objectMap, "job", u.Job)
	populate(objectMap, "lastModifiedBy", u.LastModifiedBy)
	populateTimeRFC3339(objectMap, "lastModifiedTime", u.LastModifiedTime)
	populate(objectMap, "osType", u.OSType)
	populate(objectMap, "softwareUpdateConfiguration", u.SoftwareUpdateConfiguration)
	populate(objectMap, "sourceComputerId", u.SourceComputerID)
	populateTimeRFC3339(objectMap, "startTime", u.StartTime)
	populate(objectMap, "status", u.Status)
	populate(objectMap, "targetComputer", u.TargetComputer)
	populate(objectMap, "targetComputerType", u.TargetComputerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateConfigurationMachineRunProperties.
func (u *UpdateConfigurationMachineRunProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuredDuration":
			err = unpopulate(val, "ConfiguredDuration", &u.ConfiguredDuration)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &u.CorrelationID)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &u.CreatedBy)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &u.CreationTime)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &u.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &u.Error)
			delete(rawMsg, key)
		case "job":
			err = unpopulate(val, "Job", &u.Job)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &u.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &u.LastModifiedTime)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &u.OSType)
			delete(rawMsg, key)
		case "softwareUpdateConfiguration":
			err = unpopulate(val, "SoftwareUpdateConfiguration", &u.SoftwareUpdateConfiguration)
			delete(rawMsg, key)
		case "sourceComputerId":
			err = unpopulate(val, "SourceComputerID", &u.SourceComputerID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &u.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &u.Status)
			delete(rawMsg, key)
		case "targetComputer":
			err = unpopulate(val, "TargetComputer", &u.TargetComputer)
			delete(rawMsg, key)
		case "targetComputerType":
			err = unpopulate(val, "TargetComputerType", &u.TargetComputerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateConfigurationNavigation.
func (u UpdateConfigurationNavigation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", u.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateConfigurationNavigation.
func (u *UpdateConfigurationNavigation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "currentValue", u.CurrentValue)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "limit", u.Limit)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "throttleStatus", u.ThrottleStatus)
	populate(objectMap, "unit", u.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Usage.
func (u *Usage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &u.CurrentValue)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "throttleStatus":
			err = unpopulate(val, "ThrottleStatus", &u.ThrottleStatus)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageCounterName.
func (u UsageCounterName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "localizedValue", u.LocalizedValue)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageCounterName.
func (u *UsageCounterName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &u.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageListResult.
func (u UsageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageListResult.
func (u *UsageListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Variable.
func (v Variable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Variable.
func (v *Variable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VariableCreateOrUpdateParameters.
func (v VariableCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VariableCreateOrUpdateParameters.
func (v *VariableCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VariableCreateOrUpdateProperties.
func (v VariableCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", v.Description)
	populate(objectMap, "isEncrypted", v.IsEncrypted)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VariableCreateOrUpdateProperties.
func (v *VariableCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "isEncrypted":
			err = unpopulate(val, "IsEncrypted", &v.IsEncrypted)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VariableListResult.
func (v VariableListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VariableListResult.
func (v *VariableListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VariableProperties.
func (v VariableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", v.CreationTime)
	populate(objectMap, "description", v.Description)
	populate(objectMap, "isEncrypted", v.IsEncrypted)
	populateTimeRFC3339(objectMap, "lastModifiedTime", v.LastModifiedTime)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VariableProperties.
func (v *VariableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &v.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "isEncrypted":
			err = unpopulate(val, "IsEncrypted", &v.IsEncrypted)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &v.LastModifiedTime)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VariableUpdateParameters.
func (v VariableUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VariableUpdateParameters.
func (v *VariableUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VariableUpdateProperties.
func (v VariableUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", v.Description)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VariableUpdateProperties.
func (v *VariableUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Watcher.
func (w Watcher) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", w.Etag)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Watcher.
func (w *Watcher) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &w.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WatcherListResult.
func (w WatcherListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WatcherListResult.
func (w *WatcherListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WatcherProperties.
func (w WatcherProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", w.CreationTime)
	populate(objectMap, "description", w.Description)
	populate(objectMap, "executionFrequencyInSeconds", w.ExecutionFrequencyInSeconds)
	populate(objectMap, "lastModifiedBy", w.LastModifiedBy)
	populateTimeRFC3339(objectMap, "lastModifiedTime", w.LastModifiedTime)
	populate(objectMap, "scriptName", w.ScriptName)
	populate(objectMap, "scriptParameters", w.ScriptParameters)
	populate(objectMap, "scriptRunOn", w.ScriptRunOn)
	populate(objectMap, "status", w.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WatcherProperties.
func (w *WatcherProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &w.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "executionFrequencyInSeconds":
			err = unpopulate(val, "ExecutionFrequencyInSeconds", &w.ExecutionFrequencyInSeconds)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &w.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &w.LastModifiedTime)
			delete(rawMsg, key)
		case "scriptName":
			err = unpopulate(val, "ScriptName", &w.ScriptName)
			delete(rawMsg, key)
		case "scriptParameters":
			err = unpopulate(val, "ScriptParameters", &w.ScriptParameters)
			delete(rawMsg, key)
		case "scriptRunOn":
			err = unpopulate(val, "ScriptRunOn", &w.ScriptRunOn)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WatcherUpdateParameters.
func (w WatcherUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WatcherUpdateParameters.
func (w *WatcherUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WatcherUpdateProperties.
func (w WatcherUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "executionFrequencyInSeconds", w.ExecutionFrequencyInSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WatcherUpdateProperties.
func (w *WatcherUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "executionFrequencyInSeconds":
			err = unpopulate(val, "ExecutionFrequencyInSeconds", &w.ExecutionFrequencyInSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Webhook.
func (w Webhook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Webhook.
func (w *Webhook) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebhookCreateOrUpdateParameters.
func (w WebhookCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebhookCreateOrUpdateParameters.
func (w *WebhookCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebhookCreateOrUpdateProperties.
func (w WebhookCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expiryTime", w.ExpiryTime)
	populate(objectMap, "isEnabled", w.IsEnabled)
	populate(objectMap, "parameters", w.Parameters)
	populate(objectMap, "runOn", w.RunOn)
	populate(objectMap, "runbook", w.Runbook)
	populate(objectMap, "uri", w.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebhookCreateOrUpdateProperties.
func (w *WebhookCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &w.ExpiryTime)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &w.IsEnabled)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &w.Parameters)
			delete(rawMsg, key)
		case "runOn":
			err = unpopulate(val, "RunOn", &w.RunOn)
			delete(rawMsg, key)
		case "runbook":
			err = unpopulate(val, "Runbook", &w.Runbook)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &w.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebhookListResult.
func (w WebhookListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebhookListResult.
func (w *WebhookListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebhookProperties.
func (w WebhookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", w.CreationTime)
	populate(objectMap, "description", w.Description)
	populateTimeRFC3339(objectMap, "expiryTime", w.ExpiryTime)
	populate(objectMap, "isEnabled", w.IsEnabled)
	populateTimeRFC3339(objectMap, "lastInvokedTime", w.LastInvokedTime)
	populate(objectMap, "lastModifiedBy", w.LastModifiedBy)
	populateTimeRFC3339(objectMap, "lastModifiedTime", w.LastModifiedTime)
	populate(objectMap, "parameters", w.Parameters)
	populate(objectMap, "runOn", w.RunOn)
	populate(objectMap, "runbook", w.Runbook)
	populate(objectMap, "uri", w.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebhookProperties.
func (w *WebhookProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &w.CreationTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &w.ExpiryTime)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &w.IsEnabled)
			delete(rawMsg, key)
		case "lastInvokedTime":
			err = unpopulateTimeRFC3339(val, "LastInvokedTime", &w.LastInvokedTime)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &w.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &w.LastModifiedTime)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &w.Parameters)
			delete(rawMsg, key)
		case "runOn":
			err = unpopulate(val, "RunOn", &w.RunOn)
			delete(rawMsg, key)
		case "runbook":
			err = unpopulate(val, "Runbook", &w.Runbook)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &w.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebhookUpdateParameters.
func (w WebhookUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebhookUpdateParameters.
func (w *WebhookUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebhookUpdateProperties.
func (w WebhookUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", w.Description)
	populate(objectMap, "isEnabled", w.IsEnabled)
	populate(objectMap, "parameters", w.Parameters)
	populate(objectMap, "runOn", w.RunOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebhookUpdateProperties.
func (w *WebhookUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &w.IsEnabled)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &w.Parameters)
			delete(rawMsg, key)
		case "runOn":
			err = unpopulate(val, "RunOn", &w.RunOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsProperties.
func (w WindowsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "excludedKbNumbers", w.ExcludedKbNumbers)
	populate(objectMap, "includedKbNumbers", w.IncludedKbNumbers)
	populate(objectMap, "includedUpdateClassifications", w.IncludedUpdateClassifications)
	populate(objectMap, "rebootSetting", w.RebootSetting)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsProperties.
func (w *WindowsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "excludedKbNumbers":
			err = unpopulate(val, "ExcludedKbNumbers", &w.ExcludedKbNumbers)
			delete(rawMsg, key)
		case "includedKbNumbers":
			err = unpopulate(val, "IncludedKbNumbers", &w.IncludedKbNumbers)
			delete(rawMsg, key)
		case "includedUpdateClassifications":
			err = unpopulate(val, "IncludedUpdateClassifications", &w.IncludedUpdateClassifications)
			delete(rawMsg, key)
		case "rebootSetting":
			err = unpopulate(val, "RebootSetting", &w.RebootSetting)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
