//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmaps

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// Client contains the methods for the Maps group.
// Don't use this type directly, use NewClient() instead.
type Client struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewClient creates a new instance of Client with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*Client, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &Client{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// NewListOperationsPager - List operations available for the Maps Resource Provider
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// options - ClientListOperationsOptions contains the optional parameters for the Client.ListOperations method.
func (client *Client) NewListOperationsPager(options *ClientListOperationsOptions) *runtime.Pager[ClientListOperationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ClientListOperationsResponse]{
		More: func(page ClientListOperationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ClientListOperationsResponse) (ClientListOperationsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listOperationsCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ClientListOperationsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ClientListOperationsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ClientListOperationsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listOperationsHandleResponse(resp)
		},
	})
}

// listOperationsCreateRequest creates the ListOperations request.
func (client *Client) listOperationsCreateRequest(ctx context.Context, options *ClientListOperationsOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Maps/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOperationsHandleResponse handles the ListOperations response.
func (client *Client) listOperationsHandleResponse(resp *http.Response) (ClientListOperationsResponse, error) {
	result := ClientListOperationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Operations); err != nil {
		return ClientListOperationsResponse{}, err
	}
	return result, nil
}

// NewListSubscriptionOperationsPager - List operations available for the Maps Resource Provider
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// options - ClientListSubscriptionOperationsOptions contains the optional parameters for the Client.ListSubscriptionOperations
// method.
func (client *Client) NewListSubscriptionOperationsPager(options *ClientListSubscriptionOperationsOptions) *runtime.Pager[ClientListSubscriptionOperationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ClientListSubscriptionOperationsResponse]{
		More: func(page ClientListSubscriptionOperationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ClientListSubscriptionOperationsResponse) (ClientListSubscriptionOperationsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSubscriptionOperationsCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ClientListSubscriptionOperationsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ClientListSubscriptionOperationsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ClientListSubscriptionOperationsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSubscriptionOperationsHandleResponse(resp)
		},
	})
}

// listSubscriptionOperationsCreateRequest creates the ListSubscriptionOperations request.
func (client *Client) listSubscriptionOperationsCreateRequest(ctx context.Context, options *ClientListSubscriptionOperationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Maps/operations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSubscriptionOperationsHandleResponse handles the ListSubscriptionOperations response.
func (client *Client) listSubscriptionOperationsHandleResponse(resp *http.Response) (ClientListSubscriptionOperationsResponse, error) {
	result := ClientListSubscriptionOperationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Operations); err != nil {
		return ClientListSubscriptionOperationsResponse{}, err
	}
	return result, nil
}
