//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrelay

import "time"

// AccessKeys - Namespace/Relay Connection String
type AccessKeys struct {
	// A string that describes the authorization rule.
	KeyName *string `json:"keyName,omitempty"`

	// Primary connection string of the created namespace authorization rule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`

	// A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Secondary connection string of the created namespace authorization rule.
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`

	// A base64-encoded 256-bit secondary key for signing and validating the SAS token.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// AuthorizationRule - Single item in a List or Get AuthorizationRule operation
type AuthorizationRule struct {
	// Properties supplied to create or update AuthorizationRule
	Properties *AuthorizationRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AuthorizationRuleListResult - The response from the list namespace operation.
type AuthorizationRuleListResult struct {
	// Link to the next set of results. Not empty if value contains incomplete list of authorization rules.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the list authorization rules operation.
	Value []*AuthorizationRule `json:"value,omitempty"`
}

// AuthorizationRuleProperties - Properties supplied to create or update AuthorizationRule
type AuthorizationRuleProperties struct {
	// REQUIRED; The rights associated with the rule.
	Rights []*AccessRights `json:"rights,omitempty"`
}

// CheckNameAvailability - Description of the check name availability request properties.
type CheckNameAvailability struct {
	// REQUIRED; The namespace name to check for availability. The namespace name can contain only letters, numbers, and hyphens.
	// The namespace must start with a letter, and it must end with a letter or number.
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult - Description of the check name availability request properties.
type CheckNameAvailabilityResult struct {
	// Value indicating namespace is available. Returns true if the namespace is available; otherwise, false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason for unavailability of a namespace.
	Reason *UnavailableReason `json:"reason,omitempty"`

	// READ-ONLY; The detailed info regarding the reason associated with the namespace.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ConnectionState information.
type ConnectionState struct {
	// Description of the connection state.
	Description *string `json:"description,omitempty"`

	// Status of the connection.
	Status *PrivateLinkConnectionStatus `json:"status,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// HybridConnection - Description of hybrid connection resource.
type HybridConnection struct {
	// Properties of the HybridConnection.
	Properties *HybridConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridConnectionListResult - The response of the list hybrid connection operation.
type HybridConnectionListResult struct {
	// Link to the next set of results. Not empty if value contains incomplete list hybrid connection operation.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the list hybrid connections.
	Value []*HybridConnection `json:"value,omitempty"`
}

// HybridConnectionProperties - Properties of the HybridConnection.
type HybridConnectionProperties struct {
	// Returns true if client authorization is needed for this hybrid connection; otherwise, false.
	RequiresClientAuthorization *bool `json:"requiresClientAuthorization,omitempty"`

	// The usermetadata is a placeholder to store user-defined string data for the hybrid connection endpoint. For example, it
	// can be used to store descriptive data, such as a list of teams and their contact
	// information. Also, user-defined configuration settings can be stored.
	UserMetadata *string `json:"userMetadata,omitempty"`

	// READ-ONLY; The time the hybrid connection was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; The number of listeners for this hybrid connection. Note that min : 1 and max:25 are supported.
	ListenerCount *int32 `json:"listenerCount,omitempty" azure:"ro"`

	// READ-ONLY; The time the namespace was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// HybridConnectionsClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the HybridConnectionsClient.CreateOrUpdateAuthorizationRule
// method.
type HybridConnectionsClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// HybridConnectionsClientCreateOrUpdateOptions contains the optional parameters for the HybridConnectionsClient.CreateOrUpdate
// method.
type HybridConnectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// HybridConnectionsClientDeleteAuthorizationRuleOptions contains the optional parameters for the HybridConnectionsClient.DeleteAuthorizationRule
// method.
type HybridConnectionsClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// HybridConnectionsClientDeleteOptions contains the optional parameters for the HybridConnectionsClient.Delete method.
type HybridConnectionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// HybridConnectionsClientGetAuthorizationRuleOptions contains the optional parameters for the HybridConnectionsClient.GetAuthorizationRule
// method.
type HybridConnectionsClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// HybridConnectionsClientGetOptions contains the optional parameters for the HybridConnectionsClient.Get method.
type HybridConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HybridConnectionsClientListAuthorizationRulesOptions contains the optional parameters for the HybridConnectionsClient.ListAuthorizationRules
// method.
type HybridConnectionsClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// HybridConnectionsClientListByNamespaceOptions contains the optional parameters for the HybridConnectionsClient.ListByNamespace
// method.
type HybridConnectionsClientListByNamespaceOptions struct {
	// placeholder for future optional parameters
}

// HybridConnectionsClientListKeysOptions contains the optional parameters for the HybridConnectionsClient.ListKeys method.
type HybridConnectionsClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// HybridConnectionsClientRegenerateKeysOptions contains the optional parameters for the HybridConnectionsClient.RegenerateKeys
// method.
type HybridConnectionsClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// NWRuleSetIPRules - The response from the List namespace operation.
type NWRuleSetIPRules struct {
	// The IP Filter Action
	Action *NetworkRuleIPAction `json:"action,omitempty"`

	// IP Mask
	IPMask *string `json:"ipMask,omitempty"`
}

// Namespace - Description of a namespace resource.
type Namespace struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Description of Relay namespace
	Properties *NamespaceProperties `json:"properties,omitempty"`

	// SKU of the namespace.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NamespaceListResult - The response from the list namespace operation.
type NamespaceListResult struct {
	// Link to the next set of results. Not empty if value contains incomplete list of namespaces.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the list namespace operation.
	Value []*Namespace `json:"value,omitempty"`
}

// NamespaceProperties - Properties of the namespace.
type NamespaceProperties struct {
	// List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`

	// This determines if traffic is allowed over public network. By default it is enabled.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; The time the namespace was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for Azure Insights metrics.
	MetricID *string `json:"metricId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Namespace.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Namespace.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The time the namespace was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// NamespacesClientBeginCreateOrUpdateOptions contains the optional parameters for the NamespacesClient.BeginCreateOrUpdate
// method.
type NamespacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamespacesClientBeginDeleteOptions contains the optional parameters for the NamespacesClient.BeginDelete method.
type NamespacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamespacesClientCheckNameAvailabilityOptions contains the optional parameters for the NamespacesClient.CheckNameAvailability
// method.
type NamespacesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.CreateOrUpdateAuthorizationRule
// method.
type NamespacesClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientCreateOrUpdateNetworkRuleSetOptions contains the optional parameters for the NamespacesClient.CreateOrUpdateNetworkRuleSet
// method.
type NamespacesClientCreateOrUpdateNetworkRuleSetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientDeleteAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.DeleteAuthorizationRule
// method.
type NamespacesClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.GetAuthorizationRule
// method.
type NamespacesClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetNetworkRuleSetOptions contains the optional parameters for the NamespacesClient.GetNetworkRuleSet method.
type NamespacesClientGetNetworkRuleSetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetOptions contains the optional parameters for the NamespacesClient.Get method.
type NamespacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListAuthorizationRulesOptions contains the optional parameters for the NamespacesClient.ListAuthorizationRules
// method.
type NamespacesClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListByResourceGroupOptions contains the optional parameters for the NamespacesClient.ListByResourceGroup
// method.
type NamespacesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListKeysOptions contains the optional parameters for the NamespacesClient.ListKeys method.
type NamespacesClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListOptions contains the optional parameters for the NamespacesClient.List method.
type NamespacesClientListOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientRegenerateKeysOptions contains the optional parameters for the NamespacesClient.RegenerateKeys method.
type NamespacesClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientUpdateOptions contains the optional parameters for the NamespacesClient.Update method.
type NamespacesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// NetworkRuleSet - Description of topic resource.
type NetworkRuleSet struct {
	// NetworkRuleSet properties
	Properties *NetworkRuleSetProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkRuleSetProperties - NetworkRuleSet properties
type NetworkRuleSetProperties struct {
	// Default Action for Network Rule Set
	DefaultAction *DefaultAction `json:"defaultAction,omitempty"`

	// List of IpRules
	IPRules []*NWRuleSetIPRules `json:"ipRules,omitempty"`
}

// Operation - A Relay REST API operation
type Operation struct {
	// Properties of the operation
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; Display of the operation
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Origin of the operation
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Operation display payload
type OperationDisplay struct {
	// READ-ONLY; Localized friendly description for the operation
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Localized friendly name for the operation
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Resource provider of the operation
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource of the operation
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of the request to list Relay operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Relay operations supported by the Microsoft.EventHub resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint information.
type PrivateEndpoint struct {
	// The ARM identifier for Private Endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection - Properties of the PrivateEndpointConnection.
type PrivateEndpointConnection struct {
	// Properties of the PrivateEndpointConnection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - Result of the list of all private endpoint connections operation.
type PrivateEndpointConnectionListResult struct {
	// A link for the next page of private endpoint connection resources.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of private endpoint connection resources.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// The Private Endpoint resource for this Connection.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// Details about the state of the connection.
	PrivateLinkServiceConnectionState *ConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// Provisioning state of the Private Endpoint Connection.
	ProvisioningState *EndPointProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.CreateOrUpdate
// method.
type PrivateEndpointConnectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - Information of the private link resource.
type PrivateLinkResource struct {
	// Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`

	// Name of the resource
	Name *string `json:"name,omitempty"`

	// Properties of the private link resource.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// Type of the resource
	Type *string `json:"type,omitempty"`
}

// PrivateLinkResourceProperties - Properties of PrivateLinkResource
type PrivateLinkResourceProperties struct {
	// The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`

	// The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty"`

	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkResourcesClient.List method.
type PrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesListResult - Result of the List private link resources operation.
type PrivateLinkResourcesListResult struct {
	// A link for the next page of private link resources.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// ProxyResource - Common fields that are returned in the response for all Azure Resource Manager resources
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegenerateAccessKeyParameters - Parameters supplied to the regenerate authorization rule operation, specifies which key
// needs to be reset.
type RegenerateAccessKeyParameters struct {
	// REQUIRED; The access key to regenerate.
	KeyType *KeyType `json:"keyType,omitempty"`

	// Optional. If the key value is provided, this is set to key type, or autogenerated key value set for key type.
	Key *string `json:"key,omitempty"`
}

// Resource - The resource definition.
type Resource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceNamespacePatch - Definition of resource.
type ResourceNamespacePatch struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SKU of the namespace.
type SKU struct {
	// REQUIRED; Name of this SKU.
	Name *SKUName `json:"name,omitempty"`

	// The tier of this SKU.
	Tier *SKUTier `json:"tier,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - Definition of resource.
type TrackedResource struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpdateParameters - Description of a namespace resource.
type UpdateParameters struct {
	// Description of Relay namespace.
	Properties *NamespaceProperties `json:"properties,omitempty"`

	// SKU of the namespace.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WCFRelaysClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the WCFRelaysClient.CreateOrUpdateAuthorizationRule
// method.
type WCFRelaysClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// WCFRelaysClientCreateOrUpdateOptions contains the optional parameters for the WCFRelaysClient.CreateOrUpdate method.
type WCFRelaysClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// WCFRelaysClientDeleteAuthorizationRuleOptions contains the optional parameters for the WCFRelaysClient.DeleteAuthorizationRule
// method.
type WCFRelaysClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// WCFRelaysClientDeleteOptions contains the optional parameters for the WCFRelaysClient.Delete method.
type WCFRelaysClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WCFRelaysClientGetAuthorizationRuleOptions contains the optional parameters for the WCFRelaysClient.GetAuthorizationRule
// method.
type WCFRelaysClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// WCFRelaysClientGetOptions contains the optional parameters for the WCFRelaysClient.Get method.
type WCFRelaysClientGetOptions struct {
	// placeholder for future optional parameters
}

// WCFRelaysClientListAuthorizationRulesOptions contains the optional parameters for the WCFRelaysClient.ListAuthorizationRules
// method.
type WCFRelaysClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// WCFRelaysClientListByNamespaceOptions contains the optional parameters for the WCFRelaysClient.ListByNamespace method.
type WCFRelaysClientListByNamespaceOptions struct {
	// placeholder for future optional parameters
}

// WCFRelaysClientListKeysOptions contains the optional parameters for the WCFRelaysClient.ListKeys method.
type WCFRelaysClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// WCFRelaysClientRegenerateKeysOptions contains the optional parameters for the WCFRelaysClient.RegenerateKeys method.
type WCFRelaysClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// WcfRelay - Description of the WCF relay resource.
type WcfRelay struct {
	// Properties of the WCF relay.
	Properties *WcfRelayProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WcfRelayProperties - Properties of the WCF relay.
type WcfRelayProperties struct {
	// WCF relay type.
	RelayType *Relaytype `json:"relayType,omitempty"`

	// Returns true if client authorization is needed for this relay; otherwise, false.
	RequiresClientAuthorization *bool `json:"requiresClientAuthorization,omitempty"`

	// Returns true if transport security is needed for this relay; otherwise, false.
	RequiresTransportSecurity *bool `json:"requiresTransportSecurity,omitempty"`

	// The usermetadata is a placeholder to store user-defined string data for the WCF Relay endpoint. For example, it can be
	// used to store descriptive data, such as list of teams and their contact
	// information. Also, user-defined configuration settings can be stored.
	UserMetadata *string `json:"userMetadata,omitempty"`

	// READ-ONLY; The time the WCF relay was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Returns true if the relay is dynamic; otherwise, false.
	IsDynamic *bool `json:"isDynamic,omitempty" azure:"ro"`

	// READ-ONLY; The number of listeners for this relay. Note that min :1 and max:25 are supported.
	ListenerCount *int32 `json:"listenerCount,omitempty" azure:"ro"`

	// READ-ONLY; The time the namespace was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// WcfRelaysListResult - The response of the list WCF relay operation.
type WcfRelaysListResult struct {
	// Link to the next set of results. Not empty if value contains incomplete list of WCF relays.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the list WCF relay operation.
	Value []*WcfRelay `json:"value,omitempty"`
}
