// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modify a resource CIDR. You can use this action to transfer resource CIDRs
// between scopes and ignore resource CIDRs that you do not want to manage. If set
// to false, the resource will not be tracked for overlap, it cannot be
// auto-imported into a pool, and it will be removed from any pool it has an
// allocation in. For more information, see Move resource CIDRs between scopes
// (https://docs.aws.amazon.com/vpc/latest/ipam/move-resource-ipam.html) and Change
// the monitoring state of resource CIDRs
// (https://docs.aws.amazon.com/vpc/latest/ipam/change-monitoring-state-ipam.html)
// in the Amazon VPC IPAM User Guide.
func (c *Client) ModifyIpamResourceCidr(ctx context.Context, params *ModifyIpamResourceCidrInput, optFns ...func(*Options)) (*ModifyIpamResourceCidrOutput, error) {
	if params == nil {
		params = &ModifyIpamResourceCidrInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ModifyIpamResourceCidr", params, optFns, c.addOperationModifyIpamResourceCidrMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ModifyIpamResourceCidrOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ModifyIpamResourceCidrInput struct {

	// The ID of the current scope that the resource CIDR is in.
	//
	// This member is required.
	CurrentIpamScopeId *string

	// Determines if the resource is monitored by IPAM. If a resource is monitored, the
	// resource is discovered by IPAM and you can view details about the resource’s
	// CIDR.
	//
	// This member is required.
	Monitored *bool

	// The CIDR of the resource you want to modify.
	//
	// This member is required.
	ResourceCidr *string

	// The ID of the resource you want to modify.
	//
	// This member is required.
	ResourceId *string

	// The Amazon Web Services Region of the resource you want to modify.
	//
	// This member is required.
	ResourceRegion *string

	// The ID of the scope you want to transfer the resource CIDR to.
	DestinationIpamScopeId *string

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation. Otherwise, it is
	// UnauthorizedOperation.
	DryRun *bool

	noSmithyDocumentSerde
}

type ModifyIpamResourceCidrOutput struct {

	// The CIDR for an IPAM resource.
	IpamResourceCidr *types.IpamResourceCidr

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationModifyIpamResourceCidrMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpModifyIpamResourceCidr{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpModifyIpamResourceCidr{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpModifyIpamResourceCidrValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opModifyIpamResourceCidr(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opModifyIpamResourceCidr(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ec2",
		OperationName: "ModifyIpamResourceCidr",
	}
}
