// Code generated by smithy-go-codegen DO NOT EDIT.

package panorama

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/panorama/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateApplicationInstance struct {
}

func (*validateOpCreateApplicationInstance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateApplicationInstance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateApplicationInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateApplicationInstanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateJobForDevices struct {
}

func (*validateOpCreateJobForDevices) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateJobForDevices) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateJobForDevicesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateJobForDevicesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateNodeFromTemplateJob struct {
}

func (*validateOpCreateNodeFromTemplateJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateNodeFromTemplateJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateNodeFromTemplateJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateNodeFromTemplateJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePackageImportJob struct {
}

func (*validateOpCreatePackageImportJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePackageImportJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePackageImportJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePackageImportJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePackage struct {
}

func (*validateOpCreatePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDevice struct {
}

func (*validateOpDeleteDevice) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDevice) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDeviceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDeviceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeletePackage struct {
}

func (*validateOpDeletePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeletePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeletePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeletePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeregisterPackageVersion struct {
}

func (*validateOpDeregisterPackageVersion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeregisterPackageVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeregisterPackageVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeregisterPackageVersionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeApplicationInstanceDetails struct {
}

func (*validateOpDescribeApplicationInstanceDetails) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeApplicationInstanceDetails) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeApplicationInstanceDetailsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeApplicationInstanceDetailsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeApplicationInstance struct {
}

func (*validateOpDescribeApplicationInstance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeApplicationInstance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeApplicationInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeApplicationInstanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDevice struct {
}

func (*validateOpDescribeDevice) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDevice) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDeviceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDeviceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDeviceJob struct {
}

func (*validateOpDescribeDeviceJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDeviceJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDeviceJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDeviceJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeNodeFromTemplateJob struct {
}

func (*validateOpDescribeNodeFromTemplateJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeNodeFromTemplateJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeNodeFromTemplateJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeNodeFromTemplateJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeNode struct {
}

func (*validateOpDescribeNode) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeNode) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeNodeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeNodeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribePackageImportJob struct {
}

func (*validateOpDescribePackageImportJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribePackageImportJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribePackageImportJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribePackageImportJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribePackage struct {
}

func (*validateOpDescribePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribePackageVersion struct {
}

func (*validateOpDescribePackageVersion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribePackageVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribePackageVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribePackageVersionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListApplicationInstanceDependencies struct {
}

func (*validateOpListApplicationInstanceDependencies) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListApplicationInstanceDependencies) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListApplicationInstanceDependenciesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListApplicationInstanceDependenciesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListApplicationInstanceNodeInstances struct {
}

func (*validateOpListApplicationInstanceNodeInstances) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListApplicationInstanceNodeInstances) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListApplicationInstanceNodeInstancesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListApplicationInstanceNodeInstancesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpProvisionDevice struct {
}

func (*validateOpProvisionDevice) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpProvisionDevice) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ProvisionDeviceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpProvisionDeviceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRegisterPackageVersion struct {
}

func (*validateOpRegisterPackageVersion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRegisterPackageVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RegisterPackageVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRegisterPackageVersionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveApplicationInstance struct {
}

func (*validateOpRemoveApplicationInstance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveApplicationInstance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveApplicationInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveApplicationInstanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDeviceMetadata struct {
}

func (*validateOpUpdateDeviceMetadata) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDeviceMetadata) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDeviceMetadataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDeviceMetadataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateApplicationInstanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateApplicationInstance{}, middleware.After)
}

func addOpCreateJobForDevicesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateJobForDevices{}, middleware.After)
}

func addOpCreateNodeFromTemplateJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateNodeFromTemplateJob{}, middleware.After)
}

func addOpCreatePackageImportJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePackageImportJob{}, middleware.After)
}

func addOpCreatePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePackage{}, middleware.After)
}

func addOpDeleteDeviceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDevice{}, middleware.After)
}

func addOpDeletePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeletePackage{}, middleware.After)
}

func addOpDeregisterPackageVersionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeregisterPackageVersion{}, middleware.After)
}

func addOpDescribeApplicationInstanceDetailsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeApplicationInstanceDetails{}, middleware.After)
}

func addOpDescribeApplicationInstanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeApplicationInstance{}, middleware.After)
}

func addOpDescribeDeviceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDevice{}, middleware.After)
}

func addOpDescribeDeviceJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDeviceJob{}, middleware.After)
}

func addOpDescribeNodeFromTemplateJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeNodeFromTemplateJob{}, middleware.After)
}

func addOpDescribeNodeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeNode{}, middleware.After)
}

func addOpDescribePackageImportJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribePackageImportJob{}, middleware.After)
}

func addOpDescribePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribePackage{}, middleware.After)
}

func addOpDescribePackageVersionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribePackageVersion{}, middleware.After)
}

func addOpListApplicationInstanceDependenciesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListApplicationInstanceDependencies{}, middleware.After)
}

func addOpListApplicationInstanceNodeInstancesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListApplicationInstanceNodeInstances{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpProvisionDeviceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpProvisionDevice{}, middleware.After)
}

func addOpRegisterPackageVersionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRegisterPackageVersion{}, middleware.After)
}

func addOpRemoveApplicationInstanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveApplicationInstance{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateDeviceMetadataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDeviceMetadata{}, middleware.After)
}

func validateDeviceJobConfig(v *types.DeviceJobConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeviceJobConfig"}
	if v.OTAJobConfig != nil {
		if err := validateOTAJobConfig(v.OTAJobConfig); err != nil {
			invalidParams.AddNested("OTAJobConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEthernetPayload(v *types.EthernetPayload) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EthernetPayload"}
	if len(v.ConnectionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectionType"))
	}
	if v.StaticIpConnectionInfo != nil {
		if err := validateStaticIpConnectionInfo(v.StaticIpConnectionInfo); err != nil {
			invalidParams.AddNested("StaticIpConnectionInfo", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateJobResourceTags(v *types.JobResourceTags) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "JobResourceTags"}
	if len(v.ResourceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceType"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateJobTagsList(v []types.JobResourceTags) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "JobTagsList"}
	for i := range v {
		if err := validateJobResourceTags(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNetworkPayload(v *types.NetworkPayload) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NetworkPayload"}
	if v.Ethernet0 != nil {
		if err := validateEthernetPayload(v.Ethernet0); err != nil {
			invalidParams.AddNested("Ethernet0", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ethernet1 != nil {
		if err := validateEthernetPayload(v.Ethernet1); err != nil {
			invalidParams.AddNested("Ethernet1", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ntp != nil {
		if err := validateNtpPayload(v.Ntp); err != nil {
			invalidParams.AddNested("Ntp", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNtpPayload(v *types.NtpPayload) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NtpPayload"}
	if v.NtpServers == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NtpServers"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOTAJobConfig(v *types.OTAJobConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OTAJobConfig"}
	if v.ImageVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePackageImportJobInputConfig(v *types.PackageImportJobInputConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PackageImportJobInputConfig"}
	if v.PackageVersionInputConfig != nil {
		if err := validatePackageVersionInputConfig(v.PackageVersionInputConfig); err != nil {
			invalidParams.AddNested("PackageVersionInputConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePackageImportJobOutputConfig(v *types.PackageImportJobOutputConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PackageImportJobOutputConfig"}
	if v.PackageVersionOutputConfig != nil {
		if err := validatePackageVersionOutputConfig(v.PackageVersionOutputConfig); err != nil {
			invalidParams.AddNested("PackageVersionOutputConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePackageVersionInputConfig(v *types.PackageVersionInputConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PackageVersionInputConfig"}
	if v.S3Location == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Location"))
	} else if v.S3Location != nil {
		if err := validateS3Location(v.S3Location); err != nil {
			invalidParams.AddNested("S3Location", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePackageVersionOutputConfig(v *types.PackageVersionOutputConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PackageVersionOutputConfig"}
	if v.PackageName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageName"))
	}
	if v.PackageVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3Location(v *types.S3Location) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3Location"}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if v.ObjectKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ObjectKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStaticIpConnectionInfo(v *types.StaticIpConnectionInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StaticIpConnectionInfo"}
	if v.IpAddress == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IpAddress"))
	}
	if v.Mask == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Mask"))
	}
	if v.Dns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Dns"))
	}
	if v.DefaultGateway == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DefaultGateway"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateApplicationInstanceInput(v *CreateApplicationInstanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateApplicationInstanceInput"}
	if v.ManifestPayload == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ManifestPayload"))
	}
	if v.DefaultRuntimeContextDevice == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DefaultRuntimeContextDevice"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateJobForDevicesInput(v *CreateJobForDevicesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateJobForDevicesInput"}
	if v.DeviceIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeviceIds"))
	}
	if v.DeviceJobConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeviceJobConfig"))
	} else if v.DeviceJobConfig != nil {
		if err := validateDeviceJobConfig(v.DeviceJobConfig); err != nil {
			invalidParams.AddNested("DeviceJobConfig", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.JobType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("JobType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateNodeFromTemplateJobInput(v *CreateNodeFromTemplateJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateNodeFromTemplateJobInput"}
	if len(v.TemplateType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("TemplateType"))
	}
	if v.OutputPackageName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputPackageName"))
	}
	if v.OutputPackageVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputPackageVersion"))
	}
	if v.NodeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NodeName"))
	}
	if v.TemplateParameters == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TemplateParameters"))
	}
	if v.JobTags != nil {
		if err := validateJobTagsList(v.JobTags); err != nil {
			invalidParams.AddNested("JobTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePackageImportJobInput(v *CreatePackageImportJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePackageImportJobInput"}
	if len(v.JobType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("JobType"))
	}
	if v.InputConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputConfig"))
	} else if v.InputConfig != nil {
		if err := validatePackageImportJobInputConfig(v.InputConfig); err != nil {
			invalidParams.AddNested("InputConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.OutputConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputConfig"))
	} else if v.OutputConfig != nil {
		if err := validatePackageImportJobOutputConfig(v.OutputConfig); err != nil {
			invalidParams.AddNested("OutputConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.JobTags != nil {
		if err := validateJobTagsList(v.JobTags); err != nil {
			invalidParams.AddNested("JobTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePackageInput(v *CreatePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePackageInput"}
	if v.PackageName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDeviceInput(v *DeleteDeviceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDeviceInput"}
	if v.DeviceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeviceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeletePackageInput(v *DeletePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeletePackageInput"}
	if v.PackageId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeregisterPackageVersionInput(v *DeregisterPackageVersionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeregisterPackageVersionInput"}
	if v.PackageId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageId"))
	}
	if v.PackageVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageVersion"))
	}
	if v.PatchVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PatchVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeApplicationInstanceDetailsInput(v *DescribeApplicationInstanceDetailsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeApplicationInstanceDetailsInput"}
	if v.ApplicationInstanceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationInstanceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeApplicationInstanceInput(v *DescribeApplicationInstanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeApplicationInstanceInput"}
	if v.ApplicationInstanceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationInstanceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDeviceInput(v *DescribeDeviceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDeviceInput"}
	if v.DeviceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeviceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDeviceJobInput(v *DescribeDeviceJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDeviceJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeNodeFromTemplateJobInput(v *DescribeNodeFromTemplateJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeNodeFromTemplateJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeNodeInput(v *DescribeNodeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeNodeInput"}
	if v.NodeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NodeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribePackageImportJobInput(v *DescribePackageImportJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribePackageImportJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribePackageInput(v *DescribePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribePackageInput"}
	if v.PackageId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribePackageVersionInput(v *DescribePackageVersionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribePackageVersionInput"}
	if v.PackageId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageId"))
	}
	if v.PackageVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListApplicationInstanceDependenciesInput(v *ListApplicationInstanceDependenciesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListApplicationInstanceDependenciesInput"}
	if v.ApplicationInstanceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationInstanceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListApplicationInstanceNodeInstancesInput(v *ListApplicationInstanceNodeInstancesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListApplicationInstanceNodeInstancesInput"}
	if v.ApplicationInstanceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationInstanceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpProvisionDeviceInput(v *ProvisionDeviceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ProvisionDeviceInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.NetworkingConfiguration != nil {
		if err := validateNetworkPayload(v.NetworkingConfiguration); err != nil {
			invalidParams.AddNested("NetworkingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRegisterPackageVersionInput(v *RegisterPackageVersionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegisterPackageVersionInput"}
	if v.PackageId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageId"))
	}
	if v.PackageVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageVersion"))
	}
	if v.PatchVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PatchVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveApplicationInstanceInput(v *RemoveApplicationInstanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveApplicationInstanceInput"}
	if v.ApplicationInstanceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationInstanceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDeviceMetadataInput(v *UpdateDeviceMetadataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDeviceMetadataInput"}
	if v.DeviceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeviceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
