// Code generated by smithy-go-codegen DO NOT EDIT.

package servicecatalog

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/servicecatalog/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Shares the specified portfolio with the specified account or organization node.
// Shares to an organization node can only be created by the management account of
// an organization or by a delegated administrator. You can share portfolios to an
// organization, an organizational unit, or a specific account. Note that if a
// delegated admin is de-registered, they can no longer create portfolio shares.
// AWSOrganizationsAccess must be enabled in order to create a portfolio share to
// an organization node. You can't share a shared resource, including portfolios
// that contain a shared product. If the portfolio share with the specified account
// or organization node already exists, this action will have no effect and will
// not return an error. To update an existing share, you must use the
// UpdatePortfolioShare API instead.
func (c *Client) CreatePortfolioShare(ctx context.Context, params *CreatePortfolioShareInput, optFns ...func(*Options)) (*CreatePortfolioShareOutput, error) {
	if params == nil {
		params = &CreatePortfolioShareInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePortfolioShare", params, optFns, c.addOperationCreatePortfolioShareMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePortfolioShareOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePortfolioShareInput struct {

	// The portfolio identifier.
	//
	// This member is required.
	PortfolioId *string

	// The language code.
	//
	// * en - English (default)
	//
	// * jp - Japanese
	//
	// * zh - Chinese
	AcceptLanguage *string

	// The AWS account ID. For example, 123456789012.
	AccountId *string

	// The organization node to whom you are going to share. If OrganizationNode is
	// passed in, PortfolioShare will be created for the node an
	// ListOrganizationPortfolioAccessd its children (when applies), and a
	// PortfolioShareToken will be returned in the output in order for the
	// administrator to monitor the status of the PortfolioShare creation process.
	OrganizationNode *types.OrganizationNode

	// Enables or disables TagOptions  sharing when creating the portfolio share. If
	// this flag is not provided, TagOptions sharing is disabled.
	ShareTagOptions bool

	noSmithyDocumentSerde
}

type CreatePortfolioShareOutput struct {

	// The portfolio shares a unique identifier that only returns if the portfolio is
	// shared to an organization node.
	PortfolioShareToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePortfolioShareMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreatePortfolioShare{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreatePortfolioShare{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreatePortfolioShareValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePortfolioShare(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreatePortfolioShare(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "servicecatalog",
		OperationName: "CreatePortfolioShare",
	}
}
