#!/bin/sh
set -e

dbname=gitlab_production

# Take gitlab_user from envornment variable or use gitlab
gitlab_user=${gitlab_user:-gitlab}

# If gitlab user cannot access gitlab_production,
# then it means the gitlab role does not exist
if ! su ${gitlab_user} -c 'psql gitlab_production -c ""'
then
	echo "Create ${gitlab_user} user with create database privillege..."
	su postgres -c "psql -c \"CREATE USER ${gitlab_user} CREATEDB;\""
fi

# By default the gitlab_prodcution is not owned by gitlab user
echo "Make ${gitlab_user} user owner of $dbname database..."
su postgres -c "psql -c \"ALTER DATABASE $dbname OWNER to ${gitlab_user};\""

echo "Grant all privileges to ${gitlab_user} user..."
su postgres -c "psql -c \"GRANT ALL PRIVILEGES ON DATABASE template1 to ${gitlab_user};\""

# enable the pg_trgm extension
su postgres -c "psql -d $dbname -c \"CREATE EXTENSION IF NOT EXISTS pg_trgm;\""
