#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2019-2020 Mathieu Parent <math.parent@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gitlabracadabra.objects.application_settings import GitLabracadabraApplicationSettings
from gitlabracadabra.tests import my_vcr
from gitlabracadabra.tests.case import TestCaseWithManager


class TestApplicationSettings(TestCaseWithManager):
    @my_vcr.use_cassette
    def test_settings(self, cass):
        # On the GitLab rails console, before recording:
        # defaults = ApplicationSetting.defaults
        # defaults.delete(:throttle_protected_paths_in_seconds)
        # defaults.delete(:throttle_protected_paths_per_period)
        # defaults.delete(:elasticsearch_max_bulk_size_bytes)
        # ApplicationSetting.find_or_create_without_cache.update!(defaults)
        obj = GitLabracadabraApplicationSettings('memory', 'application_settings', {
            # 'abuse_notification_email': 'some string',
            # 'admin_mode': True,
            'after_sign_out_path': 'https://example.org/sign_out',
            'after_sign_up_text': 'some string',
            'akismet_api_key': 'some string',
            'akismet_enabled': True,
            'allow_group_owners_to_manage_ldap': False,
            # 'allow_local_requests_from_system_hooks': False,
            # 'allow_local_requests_from_web_hooks_and_services': True,
            'archive_builds_in_human_readable': '15 days',
            # 'asset_proxy_allowlist': 'some string',
            # 'asset_proxy_enabled': True,
            # 'asset_proxy_secret_key': 'some string',
            # 'asset_proxy_url': 'some string',
            'authorized_keys_enabled': False,
            'auto_devops_domain': 'autodevops.example.org',
            'auto_devops_enabled': True,
            # 'automatic_purchased_storage_allocation': True,
            'check_namespace_plan': True,
            'commit_email_hostname': 'users.noreply.127.0.0.1',
            # 'container_expiration_policies_enable_historic_entries': True,
            # 'container_registry_cleanup_tags_service_max_list_size': 200,
            # 'container_registry_delete_tags_service_timeout': 250,
            # 'container_registry_expiration_policies_caching': False,
            # 'container_registry_expiration_policies_worker_capacity': 4,
            # 'container_registry_import_created_before': '2022-01-23 00:00:00',
            # 'container_registry_import_max_retries': 3,
            # 'container_registry_import_max_step_duration': 300,
            # 'container_registry_import_max_tags_count': 100,
            # 'container_registry_import_start_max_retries': 50,
            # 'container_registry_import_target_plan': 'free',
            'container_registry_token_expire_delay': 5,
            # 'custom_http_clone_url_root': 'some string',
            # 'deactivate_dormant_users': 'some string',
            'default_artifacts_expire_in': '30 days',
            # 'default_branch_name': 'some string',
            'default_branch_protection': 2,
            'default_ci_config_path': 'some string',
            'default_group_visibility': 'internal',
            'default_project_creation': 2,
            # 'default_project_deletion_protection': True,
            'default_project_visibility': 'internal',
            'default_projects_limit': 100000,
            'default_snippet_visibility': 'internal',
            # 'delayed_project_deletion': 'some string',
            # 'delete_inactive_projects': 'some string',
            # 'deletion_adjourned_period': 7,
            # 'diff_max_files': 1000,
            # 'diff_max_lines': 50000,
            'diff_max_patch_bytes': 204800,
            # 'disable_feed_token': True,
            # 'disable_overriding_approvers_per_merge_request': 'some string',
            'disabled_oauth_sign_in_sources': [],
            'dns_rebinding_protection_enabled': False,
            # 'domain_allowlist': [],
            # 'domain_allowlist_raw': 'some string',
            # 'domain_denylist': 'some string',
            # 'domain_denylist_enabled': True,
            # 'domain_denylist_raw': 'some string',
            'dsa_key_restriction': 0,
            'ecdsa_key_restriction': 0,
            # 'ecdsa_sk_key_restriction': 0,
            'ed25519_key_restriction': 0,
            # 'ed25519_sk_key_restriction': 0,
            # 'eks_access_key_id': 'some string',
            # 'eks_account_id': 'some string',
            # 'eks_integration_enabled': True,
            # 'eks_secret_access_key': 'some string',
            # 'elasticsearch_analyzers_kuromoji_enabled': True,
            # 'elasticsearch_analyzers_kuromoji_search': True,
            # 'elasticsearch_analyzers_smartcn_enabled': True,
            # 'elasticsearch_analyzers_smartcn_search': True,
            'elasticsearch_aws': True,
            'elasticsearch_aws_access_key': 'some string',
            'elasticsearch_aws_region': 'us-east-1',
            'elasticsearch_aws_secret_access_key': 'some string',
            # 'elasticsearch_client_request_timeout': 0,
            # 'elasticsearch_indexed_field_length_limit': 0,
            # 'elasticsearch_indexed_file_size_limit_kb': 1024,
            'elasticsearch_indexing': True,
            'elasticsearch_limit_indexing': True,
            # 'elasticsearch_max_bulk_concurrency': 10,
            # 'elasticsearch_max_bulk_size_mb': 'some string',
            'elasticsearch_namespace_ids': [1],
            # 'elasticsearch_password': 'some string',
            # 'elasticsearch_pause_indexing': 'some string',
            'elasticsearch_project_ids': [2],
            # 'elasticsearch_replicas': 'some string',
            'elasticsearch_search': True,
            # 'elasticsearch_shards': 'some string',
            'elasticsearch_url': 'http://localhost:9200',
            # 'elasticsearch_username': 'some string',
            # 'email_additional_text': 'some string',  # current value is not available
            'email_author_in_body': True,
            # 'email_restrictions': 'some string',
            # 'email_restrictions_enabled': True,
            'enabled_git_access_protocol': 'http',
            # 'enforce_namespace_storage_limit': True,
            # 'enforce_pat_expiration': False,
            # 'enforce_ssh_key_expiration': 'some string',
            'enforce_terms': True,
            # 'external_auth_client_cert': 'some string',  # FIXME is not a valid X509 certificate.
            # 'external_auth_client_key': 'some string',  # FIXME could not read private key, is the passphrase correct?
            'external_auth_client_key_pass': 'some string',
            'external_authorization_service_default_label': 'some string',
            'external_authorization_service_enabled': True,
            'external_authorization_service_timeout': 5,
            'external_authorization_service_url': 'https://example.org/external_authorization_service_url',
            # 'external_pipeline_validation_service_timeout': 'some string',
            # 'external_pipeline_validation_service_token': 'some string',
            # 'external_pipeline_validation_service_url': 'some string',
            # 'file_template_project_id': 42,  # current value is not available
            'first_day_of_week': 'monday',
            # 'floc_enabled': True,
            # 'force_pages_access_control': 'some string',
            'geo_node_allowed_ips': '0.0.0.0/0, ::/0',
            'geo_status_timeout': 10,
            # 'git_two_factor_session_expiry': 15,
            'gitaly_timeout_default': 57,
            'gitaly_timeout_fast': 20,
            'gitaly_timeout_medium': 56,
            # 'gitpod_enabled': True,
            # 'gitpod_url': 'https://gitpod.io/',
            'grafana_enabled': True,
            'grafana_url': 'some string',
            'gravatar_enabled': False,
            # 'group_download_export_limit': 1,
            # 'group_export_limit': 6,
            # 'group_import_limit': 6,
            # 'group_owners_can_manage_default_branch_protection': 'some string',
            # 'group_runner_token_expiration_interval': 'some string',
            'hashed_storage_enabled': True,
            # 'help_page_documentation_base_url': 'some string',
            'help_page_hide_commercial_content': True,
            'help_page_support_url': 'https://example.org/help_page_support_url',
            'help_page_text': 'some string',
            'help_text': 'some string',
            'hide_third_party_offers': True,
            'home_page_url': 'https://example.org/home_page_url',
            'housekeeping_enabled': False,
            'housekeeping_full_repack_period': 50,
            'housekeeping_gc_period': 200,
            'housekeeping_incremental_repack_period': 10,
            'html_emails_enabled': True,
            'import_sources': [
                'github',
                'bitbucket',
                'bitbucket_server',
                'gitlab',
                # 'google_code',
                'fogbugz',
                'git',
                'gitlab_project',
                'gitea',
                'manifest',
                'phabricator',
            ],
            # 'in_product_marketing_emails_enabled': True,
            # 'inactive_projects_delete_after_months': 'some string',
            # 'inactive_projects_min_size_mb': 'some string',
            # 'inactive_projects_send_warning_email_after_months': 'some string',
            # 'invisible_captcha_enabled': True,
            # 'issues_create_limit': 300,
            # 'keep_latest_artifact': 'some string',
            # 'kroki_enabled': True,
            # 'kroki_formats': {'blockdiag': True, 'bpmn': True, 'excalidraw': True},
            # 'kroki_url': 'some string',
            'local_markdown_version': 0,
            # 'lock_memberships_to_ldap': True,
            # 'login_recaptcha_protection_enabled': True,
            # 'mailgun_events_enabled': True,
            # 'mailgun_signing_key': 'some string',
            # 'maintenance_mode': True,
            # 'maintenance_mode_message': 'some string',
            'max_artifacts_size': 100,
            'max_attachment_size': 10,
            # 'max_import_size': 0,
            'max_pages_size': 12,
            # 'max_personal_access_token_lifetime': 'some string',
            # 'max_ssh_key_lifetime': 'some string',
            # 'max_yaml_depth': 100,
            # 'max_yaml_size_bytes': 1048576,
            'metrics_method_call_threshold': 42,
            # 'minimum_password_length': 8,
            'mirror_available': False,
            # 'mirror_capacity_threshold': 15,  # current value is not available
            # 'mirror_max_capacity': 30,  # current value is not available
            # 'mirror_max_delay': 300,  # current value is not available
            # 'notes_create_limit': 300,
            # 'notes_create_limit_allowlist_raw': 'some string',
            # 'notify_on_unknown_sign_in': False,
            # 'npm_package_requests_forwarding': 'some string',
            # 'outbound_local_requests_allowlist_raw': 'some string',
            'pages_domain_verification_enabled': True,
            # 'password_authentication_enabled': True,
            # 'password_authentication_enabled_for_git': False,
            # 'password_authentication_enabled_for_web': False,
            # 'performance_bar_allowed_group_path': 'some string',  # current value is not available
            # 'personal_access_token_prefix': 'some string',
            'plantuml_enabled': True,
            'plantuml_url': 'some string',
            'polling_interval_multiplier': 1,
            # 'prevent_merge_requests_author_approval': 'some string',
            # 'prevent_merge_requests_committers_approval': 'some string',
            # 'project_download_export_limit': 1,
            'project_export_enabled': False,
            # 'project_export_limit': 6,
            # 'project_import_limit': 6,
            # 'project_runner_token_expiration_interval': 'some string',
            'prometheus_metrics_enabled': True,
            'protected_ci_variables': False,
            # 'protected_paths_raw': 'some string',
            'pseudonymizer_enabled': True,
            # 'push_event_activities_limit': 3,
            # 'push_event_hooks_limit': 3,
            # 'pypi_package_requests_forwarding': 'some string',
            # 'rate_limiting_response_text': 'some string',
            # 'raw_blob_request_limit': 300,
            'recaptcha_enabled': True,
            'recaptcha_private_key': 'some string',
            'recaptcha_site_key': 'some string',
            'receive_max_input_size': 42,
            'repository_checks_enabled': False,
            'repository_size_limit': 42,
            # 'repository_storages_weighted': {'default': 100},
            # 'require_admin_approval_after_user_signup': False,
            'require_two_factor_authentication': True,
            'restricted_visibility_levels': [],
            'rsa_key_restriction': 0,
            # 'runner_token_expiration_interval': 'some string',
            # 'search_rate_limit': 30,
            # 'search_rate_limit_unauthenticated': 10,
            # 'secret_detection_revocation_token_types_url': 'some string',
            # 'secret_detection_token_revocation_enabled': True,
            # 'secret_detection_token_revocation_token': 'some string',
            # 'secret_detection_token_revocation_url': 'some string',
            'send_user_confirmation_email': True,
            # 'sentry_clientside_dsn': 'some string',
            # 'sentry_dsn': 'some string',
            # 'sentry_enabled': True,
            # 'sentry_environment': 'some string',
            'session_expire_delay': 10080,
            'shared_runners_enabled': False,
            'shared_runners_minutes': 42,
            'shared_runners_text': 'some string',
            # 'sidekiq_job_limiter_compression_threshold_bytes': 100000,
            # 'sidekiq_job_limiter_limit_bytes': 0,
            # 'sidekiq_job_limiter_mode': 'compress',
            'sign_in_text': 'some string',
            # 'signin_enabled': True,
            'signup_enabled': False,
            'slack_app_enabled': True,
            'slack_app_id': 'some string',
            'slack_app_secret': 'some string',
            'slack_app_verification_token': 'some string',
            # 'snippet_size_limit': 52428800,
            # 'snowplow_app_id': 'some string',
            # 'snowplow_collector_hostname': 'some string',
            # 'snowplow_cookie_domain': 'some string',
            # 'snowplow_enabled': True,
            # 'sourcegraph_enabled': True,
            # 'sourcegraph_public_only': False,
            # 'sourcegraph_url': 'some string',
            # 'spam_check_api_key': 'some string',
            # 'spam_check_endpoint_enabled': True,
            # 'spam_check_endpoint_url': 'some string',
            # 'static_objects_external_storage_auth_token': 'some string',
            # 'static_objects_external_storage_url': 'some string',
            # 'suggest_pipeline_enabled': False,
            'terminal_max_session_time': 0,
            'terms': 'some string',
            'throttle_authenticated_api_enabled': True,
            'throttle_authenticated_api_period_in_seconds': 3600,
            'throttle_authenticated_api_requests_per_period': 7200,
            # 'throttle_authenticated_deprecated_api_enabled': True,
            # 'throttle_authenticated_deprecated_api_period_in_seconds': 3600,
            # 'throttle_authenticated_deprecated_api_requests_per_period': 3600,
            # 'throttle_authenticated_files_api_enabled': True,
            # 'throttle_authenticated_files_api_period_in_seconds': 15,
            # 'throttle_authenticated_files_api_requests_per_period': 500,
            # 'throttle_authenticated_git_lfs_enabled': True,
            # 'throttle_authenticated_git_lfs_period_in_seconds': 60,
            # 'throttle_authenticated_git_lfs_requests_per_period': 1000,
            # 'throttle_authenticated_packages_api_enabled': True,
            # 'throttle_authenticated_packages_api_period_in_seconds': 15,
            # 'throttle_authenticated_packages_api_requests_per_period': 1000,
            'throttle_authenticated_web_enabled': True,
            'throttle_authenticated_web_period_in_seconds': 3600,
            'throttle_authenticated_web_requests_per_period': 7200,
            # 'throttle_incident_management_notification_enabled': True,
            # 'throttle_incident_management_notification_per_period': 3600,
            # 'throttle_incident_management_notification_period_in_seconds': 3600,
            # 'throttle_protected_paths_enabled': True,
            # 'throttle_protected_paths_period_in_seconds': 'some string',
            # 'throttle_protected_paths_requests_per_period': 'some string',
            # 'throttle_unauthenticated_api_enabled': True,
            # 'throttle_unauthenticated_api_period_in_seconds': 3600,
            # 'throttle_unauthenticated_api_requests_per_period': 3600,
            # 'throttle_unauthenticated_deprecated_api_enabled': True,
            # 'throttle_unauthenticated_deprecated_api_period_in_seconds': 3600,
            # 'throttle_unauthenticated_deprecated_api_requests_per_period': 1800,
            'throttle_unauthenticated_enabled': True,
            # 'throttle_unauthenticated_files_api_enabled': True,
            # 'throttle_unauthenticated_files_api_period_in_seconds': 15,
            # 'throttle_unauthenticated_files_api_requests_per_period': 125,
            # 'throttle_unauthenticated_packages_api_enabled': True,
            # 'throttle_unauthenticated_packages_api_period_in_seconds': 15,
            # 'throttle_unauthenticated_packages_api_requests_per_period': 800,
            'throttle_unauthenticated_period_in_seconds': 3600,
            'throttle_unauthenticated_requests_per_period': 3600,
            # 'throttle_unauthenticated_web_enabled': True,
            # 'throttle_unauthenticated_web_period_in_seconds': 'some string',
            # 'throttle_unauthenticated_web_requests_per_period': 'some string',
            'time_tracking_limit_to_hours': True,
            'two_factor_grace_period': 48,
            'unique_ips_limit_enabled': True,
            'unique_ips_limit_per_user': 10,
            'unique_ips_limit_time_window': 3600,
            # 'updating_name_disabled_for_users': 'some string',
            'usage_ping_enabled': False,
            # 'usage_ping_features_enabled': True,
            # 'user_deactivation_emails_enabled': False,
            'user_default_external': True,
            'user_default_internal_regex': 'some string',
            'user_oauth_applications': True,
            'user_show_add_ssh_key_message': False,
            # 'users_get_by_id_limit': 300,
            # 'users_get_by_id_limit_allowlist_raw': 'some string',
            'version_check_enabled': True,
            'web_ide_clientside_preview_enabled': True,
            # 'whats_new_variant': 0,
            # 'wiki_page_max_content_bytes': 52428800,
        })
        self.assertEqual(obj.errors(), [])
        if self.gitlab_version(lt='3'):
            return
        obj.process()
        self.assertTrue(cass.all_played)
