close all;
clear all;

%% l2 [Order][Mesh]

%% f = Sin(10x) +  Sin(10y)

h = [1, 1/2, 1/4, 1/8, 1/16];
p = [1:5];

l2 = ...
    [...
        +1.764505e+00 , +8.014519e-01 , +2.753813e-01 , +6.588849e-02 , +1.437111e-02 ; ...
        +1.242235e+00 , +2.845904e-01 , +5.342474e-02 , +8.940386e-03 , +1.335518e-03 ; ...
        +8.589849e-01 , +1.161231e-01 , +8.372573e-03 , +5.054424e-04 , +2.729638e-05 ; ...
        +3.903518e-01 , +2.324497e-02 , +1.059408e-03 , +4.057946e-05 , +1.382465e-06 ; ...
        +2.495505e-01 , +6.620142e-03 , +1.102353e-04 , +1.619398e-06 , +2.500901e-08 ; ...
    ];

P = size(p, 2);
H = size(h, 2);

delta = zeros(P, H - 1);

for i = 1:H-1
    delta(:, i) = ...
        (log10(l2(:, i + 1)) - log10(l2(:, i))) / ...
        (log10(1/h(i + 1))   - log10(1/h(i)));
end

delta

figure;
loglog(1./h, l2', '-*');
grid;
