close all;
clear all;

%% l2 [Order][Mesh]

%% f = [Sin(10x),  Sin(10y), sin(10z)]

h = [1, 1/2, 1/4, 1/8];%% 1/16];
p = [1:3];

l2 = ...
    [...
        +9.482214e-01 , +6.628264e-01 , +1.829869e-01 , +5.081894e-02 ; ...
        +8.431566e-01 , +3.056228e-01 , +7.243922e-02 , +1.794435e-02 ; ...
        +6.749199e-01 , +1.699379e-01 , +4.083307e-02 , +1.099684e-02 ; ...
    ];

P = size(p, 2);
H = size(h, 2);

delta = zeros(P, H - 1);

for i = 1:H-1
    delta(:, i) = ...
        (log10(l2(:, i + 1)) - log10(l2(:, i))) / ...
        (log10(1/h(i + 1))   - log10(1/h(i)));
end

delta

figure;
loglog(1./h, l2', '-*');
grid;
