/* vm-configurator.c generated by valac 0.18.0.79-04df6, the Vala compiler
 * generated from vm-configurator.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <libcommon.h>
#include <osinfo/osinfo.h>
#include <config.h>
#include <unistd.h>
#include <libxml/parser.h>
#include <libxml/xmlreader.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define BOXES_TYPE_VM_CONFIGURATOR (boxes_vm_configurator_get_type ())
#define BOXES_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator))
#define BOXES_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))
#define BOXES_IS_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_IS_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_VM_CONFIGURATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))

typedef struct _BoxesVMConfigurator BoxesVMConfigurator;
typedef struct _BoxesVMConfiguratorClass BoxesVMConfiguratorClass;
typedef struct _BoxesVMConfiguratorPrivate BoxesVMConfiguratorPrivate;

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _xmlFreeTextReader0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextReader (var), NULL)))
typedef struct _BoxesParamSpecVMConfigurator BoxesParamSpecVMConfigurator;

typedef enum  {
	BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS
} BoxesVMConfiguratorError;
#define BOXES_VM_CONFIGURATOR_ERROR boxes_vm_configurator_error_quark ()
struct _BoxesVMConfigurator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesVMConfiguratorPrivate * priv;
};

struct _BoxesVMConfiguratorClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesVMConfigurator *self);
};

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
	void (*set_direct_boot_params) (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
	void (*prepare_for_installation) (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_for_installation_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_, GError** error);
	void (*setup_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*populate_setup_vbox) (BoxesInstallerMedia* self, GtkVBox* setup_vbox);
	GList* (*get_vm_properties) (BoxesInstallerMedia* self);
	guint64 (*get_installed_size) (BoxesInstallerMedia* self);
	gboolean (*get_need_user_input_for_vm_creation) (BoxesInstallerMedia* self);
	gboolean (*get_ready_to_create) (BoxesInstallerMedia* self);
	gboolean (*get_supports_virtio_disk) (BoxesInstallerMedia* self);
};

struct _BoxesParamSpecVMConfigurator {
	GParamSpec parent_instance;
};


static gpointer boxes_vm_configurator_parent_class = NULL;

GQuark boxes_vm_configurator_error_quark (void);
gpointer boxes_vm_configurator_ref (gpointer instance);
void boxes_vm_configurator_unref (gpointer instance);
GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_vm_configurator (GValue* value, gpointer v_object);
void boxes_value_take_vm_configurator (GValue* value, gpointer v_object);
gpointer boxes_value_get_vm_configurator (const GValue* value);
GType boxes_vm_configurator_get_type (void) G_GNUC_CONST;
enum  {
	BOXES_VM_CONFIGURATOR_DUMMY_PROPERTY
};
#define BOXES_VM_CONFIGURATOR_BOXES_NS "boxes"
#define BOXES_VM_CONFIGURATOR_BOXES_NS_URI "http://live.gnome.org/Boxes/"
#define BOXES_VM_CONFIGURATOR_LIVE_STATE "live"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "installation"
#define BOXES_VM_CONFIGURATOR_INSTALLED_STATE "installed"
#define BOXES_VM_CONFIGURATOR_LIVE_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIVE_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLED_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLED_STATE "</os-state>"
GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media, const gchar* target_path, GVirConfigCapabilities* caps, GError** error);
gboolean boxes_installer_media_get_live (BoxesInstallerMedia* self);
static GVirConfigCapabilitiesGuest* boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps, BoxesInstallerMedia* install_media, GError** error);
static void boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain, GVirConfigCapabilities* caps);
static gboolean boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps);
static void boxes_vm_configurator_set_os_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, GVirConfigCapabilitiesGuest* guest_caps);
static gboolean boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps, const gchar* feature_name);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
static void boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain, const gchar* target_path, BoxesInstallerMedia* install_media);
void boxes_installer_media_setup_domain_config (BoxesInstallerMedia* self, GVirConfigDomain* domain);
static void boxes_vm_configurator_set_video_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
void boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain);
static void boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain);
static void boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gboolean boxes_vm_configurator_is_install_config (GVirConfigDomain* domain);
static gchar* boxes_vm_configurator_get_os_state (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_live_config (GVirConfigDomain* domain);
GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (const gchar* name, gint64 storage, GError** error);
static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (void);
GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (GError** error);
gboolean boxes_installer_media_get_supports_virtio_disk (BoxesInstallerMedia* self);
void boxes_installer_media_set_direct_boot_params (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
OsinfoDevice* boxes_get_os_device_by_prop (OsinfoOs* os, const gchar* prop_name, const gchar* prop_value);
gboolean boxes_installer_media_is_architecture_compatible (BoxesInstallerMedia* self, const gchar* architecture);
static gboolean boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps);
BoxesVMConfigurator* boxes_vm_configurator_new (void);
BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type);
static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark boxes_vm_configurator_error_quark (void) {
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	return g_quark_from_static_string ("boxes_vm_configurator_error-quark");
#line 162 "vm-configurator.c"
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 173 "vm-configurator.c"
	}
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 179 "vm-configurator.c"
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 190 "vm-configurator.c"
	}
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 196 "vm-configurator.c"
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 207 "vm-configurator.c"
	}
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 213 "vm-configurator.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 1228 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1228 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1229 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1229 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1229 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1229 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 233 "vm-configurator.c"
}


GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media, const gchar* target_path, GVirConfigCapabilities* caps, GError** error) {
	GVirConfigDomain* result = NULL;
	GVirConfigDomain* _tmp0_;
	GVirConfigDomain* domain;
	const gchar* _tmp1_ = NULL;
	BoxesInstallerMedia* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* xml;
	GVirConfigCapabilities* _tmp8_;
	BoxesInstallerMedia* _tmp9_;
	GVirConfigCapabilitiesGuest* _tmp10_ = NULL;
	GVirConfigCapabilitiesGuest* best_caps;
	GVirConfigDomain* _tmp11_;
	BoxesInstallerMedia* _tmp12_;
	OsinfoResources* _tmp13_;
	gint64 _tmp14_;
	gint64 _tmp15_;
	GVirConfigDomain* _tmp16_;
	GVirConfigCapabilities* _tmp17_;
	GVirConfigDomainVirtType _tmp18_ = 0;
	gboolean _tmp19_ = FALSE;
	GVirConfigDomainVirtType _tmp20_;
	GVirConfigDomainVirtType virt_type;
	GVirConfigDomain* _tmp21_;
	GVirConfigDomainVirtType _tmp22_;
	GVirConfigDomain* _tmp23_;
	BoxesInstallerMedia* _tmp24_;
	gchar** _tmp25_ = NULL;
	gchar** features;
	gint features_length1;
	gint _features_size_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp32_ = FALSE;
	GVirConfigDomain* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	GVirConfigDomainClock* _tmp37_;
	GVirConfigDomainClock* clock;
	gboolean _tmp38_ = FALSE;
	BoxesInstallerMedia* _tmp39_;
	OsinfoOs* _tmp40_;
	gboolean _tmp46_;
	GVirConfigDomainTimerRtc* _tmp49_;
	GVirConfigDomainTimer* timer;
	GVirConfigDomainTimer* _tmp50_;
	GVirConfigDomainClock* _tmp51_;
	GVirConfigDomainTimer* _tmp52_;
	GVirConfigDomainTimerPit* _tmp53_;
	GVirConfigDomainTimer* _tmp54_;
	GVirConfigDomainClock* _tmp55_;
	GVirConfigDomainTimer* _tmp56_;
	GVirConfigDomain* _tmp57_;
	GVirConfigDomainClock* _tmp58_;
	GVirConfigDomain* _tmp59_;
	const gchar* _tmp60_;
	BoxesInstallerMedia* _tmp61_;
	BoxesInstallerMedia* _tmp62_;
	GVirConfigDomain* _tmp63_;
	GVirConfigDomainGraphicsSpice* _tmp64_;
	GVirConfigDomainGraphicsSpice* graphics;
	GVirConfigDomainGraphicsSpice* _tmp65_;
	GVirConfigDomain* _tmp66_;
	GVirConfigDomainGraphicsSpice* _tmp67_;
	GVirConfigDomainChannel* _tmp68_;
	GVirConfigDomainChannel* channel;
	GVirConfigDomainChannel* _tmp69_;
	GVirConfigDomainChannel* _tmp70_;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp71_;
	GVirConfigDomainChardevSourceSpiceVmc* vmc;
	GVirConfigDomainChannel* _tmp72_;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp73_;
	GVirConfigDomain* _tmp74_;
	GVirConfigDomainChannel* _tmp75_;
	GVirConfigDomain* _tmp76_;
	BoxesInstallerMedia* _tmp77_;
	GVirConfigDomain* _tmp78_;
	BoxesInstallerMedia* _tmp79_;
	GVirConfigDomain* _tmp80_;
	BoxesInstallerMedia* _tmp81_;
	GVirConfigDomain* _tmp82_;
	GVirConfigDomain* _tmp83_;
	GVirConfigDomain* _tmp84_;
	GVirConfigDomainConsole* _tmp90_;
	GVirConfigDomainConsole* console;
	GVirConfigDomainConsole* _tmp91_;
	GVirConfigDomainChardevSourcePty* _tmp92_;
	GVirConfigDomainChardevSourcePty* _tmp93_;
	GVirConfigDomain* _tmp94_;
	GVirConfigDomainConsole* _tmp95_;
	GVirConfigDomainInterfaceUser* _tmp96_;
	GVirConfigDomainInterfaceUser* iface;
	GVirConfigDomain* _tmp97_;
	GVirConfigDomainInterfaceUser* _tmp98_;
	GError * _inner_error_ = NULL;
#line 20 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (install_media != NULL, NULL);
#line 20 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (target_path != NULL, NULL);
#line 20 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_new ();
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	domain = _tmp0_;
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = install_media;
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = boxes_installer_media_get_live (_tmp2_);
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = _tmp3_;
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp4_) {
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp1_ = BOXES_VM_CONFIGURATOR_LIVE_XML;
#line 355 "vm-configurator.c"
	} else {
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp1_ = BOXES_VM_CONFIGURATOR_INSTALLATION_XML;
#line 359 "vm-configurator.c"
	}
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = _tmp1_;
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	xml = _tmp6_;
#line 367 "vm-configurator.c"
	{
		GVirConfigDomain* _tmp7_;
#line 27 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = domain;
#line 27 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_set_custom_xml (_tmp7_, xml, BOXES_VM_CONFIGURATOR_BOXES_NS, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, &_inner_error_);
#line 27 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_inner_error_ != NULL) {
#line 376 "vm-configurator.c"
			goto __catch63_g_error;
		}
	}
	goto __finally63;
	__catch63_g_error:
	{
		GError* _error_ = NULL;
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_error_ = _inner_error_;
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_inner_error_ = NULL;
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_assert_not_reached ();
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_error_free0 (_error_);
#line 392 "vm-configurator.c"
	}
	__finally63:
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_inner_error_ != NULL) {
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_propagate_error (error, _inner_error_);
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (xml);
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_object_unref0 (domain);
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return NULL;
#line 407 "vm-configurator.c"
		} else {
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (xml);
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_object_unref0 (domain);
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_clear_error (&_inner_error_);
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return NULL;
#line 419 "vm-configurator.c"
		}
	}
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = caps;
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = install_media;
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = boxes_vm_configurator_get_best_guest_caps (_tmp8_, _tmp9_, &_inner_error_);
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	best_caps = _tmp10_;
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_inner_error_ != NULL) {
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_propagate_error (error, _inner_error_);
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (xml);
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_object_unref0 (domain);
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return NULL;
#line 442 "vm-configurator.c"
		} else {
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (xml);
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_object_unref0 (domain);
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_clear_error (&_inner_error_);
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return NULL;
#line 454 "vm-configurator.c"
		}
	}
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = domain;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = install_media;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = _tmp12_->resources;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = osinfo_resources_get_ram (_tmp13_);
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = _tmp14_;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_memory (_tmp11_, (guint64) (_tmp15_ / OSINFO_KIBIBYTES));
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = domain;
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp17_ = caps;
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_cpu_config (_tmp16_, _tmp17_);
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = boxes_vm_configurator_guest_kvm_enabled (best_caps);
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp19_) {
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp18_ = GVIR_CONFIG_DOMAIN_VIRT_KVM;
#line 481 "vm-configurator.c"
	} else {
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp18_ = GVIR_CONFIG_DOMAIN_VIRT_QEMU;
#line 485 "vm-configurator.c"
	}
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp20_ = _tmp18_;
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	virt_type = _tmp20_;
#line 35 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp21_ = domain;
#line 35 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp22_ = virt_type;
#line 35 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_virt_type (_tmp21_, _tmp22_);
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp23_ = domain;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp24_ = install_media;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_os_config (_tmp23_, _tmp24_, best_caps);
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp25_ = g_new0 (gchar*, 0 + 1);
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	features = _tmp25_;
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	features_length1 = 0;
#line 39 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_features_size_ = features_length1;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp26_ = boxes_vm_configurator_guest_supports_feature (best_caps, "acpi");
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp26_) {
#line 515 "vm-configurator.c"
		gchar** _tmp27_;
		gint _tmp27__length1;
		gchar* _tmp28_;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp27_ = features;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp27__length1 = features_length1;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp28_ = g_strdup ("acpi");
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add8 (&features, &features_length1, &_features_size_, _tmp28_);
#line 527 "vm-configurator.c"
	}
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp29_ = boxes_vm_configurator_guest_supports_feature (best_caps, "apic");
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp29_) {
#line 533 "vm-configurator.c"
		gchar** _tmp30_;
		gint _tmp30__length1;
		gchar* _tmp31_;
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp30_ = features;
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp30__length1 = features_length1;
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp31_ = g_strdup ("apic");
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add9 (&features, &features_length1, &_features_size_, _tmp31_);
#line 545 "vm-configurator.c"
	}
#line 44 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp32_ = boxes_vm_configurator_guest_supports_feature (best_caps, "pae");
#line 44 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp32_) {
#line 551 "vm-configurator.c"
		gchar** _tmp33_;
		gint _tmp33__length1;
		gchar* _tmp34_;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp33_ = features;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp33__length1 = features_length1;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp34_ = g_strdup ("pae");
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add10 (&features, &features_length1, &_features_size_, _tmp34_);
#line 563 "vm-configurator.c"
	}
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp35_ = domain;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp36_ = features;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp36__length1 = features_length1;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_features (_tmp35_, _tmp36_);
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp37_ = gvir_config_domain_clock_new ();
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	clock = _tmp37_;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp39_ = install_media;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp40_ = _tmp39_->os;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp40_ != NULL) {
#line 583 "vm-configurator.c"
		BoxesInstallerMedia* _tmp41_;
		OsinfoOs* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gboolean _tmp45_ = FALSE;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp41_ = install_media;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp42_ = _tmp41_->os;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp43_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp42_);
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp44_ = _tmp43_;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp45_ = string_contains (_tmp44_, "win");
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp38_ = _tmp45_;
#line 601 "vm-configurator.c"
	} else {
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp38_ = FALSE;
#line 605 "vm-configurator.c"
	}
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp46_ = _tmp38_;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp46_) {
#line 611 "vm-configurator.c"
		GVirConfigDomainClock* _tmp47_;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp47_ = clock;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_clock_set_offset (_tmp47_, GVIR_CONFIG_DOMAIN_CLOCK_LOCALTIME);
#line 617 "vm-configurator.c"
	} else {
		GVirConfigDomainClock* _tmp48_;
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp48_ = clock;
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_clock_set_offset (_tmp48_, GVIR_CONFIG_DOMAIN_CLOCK_UTC);
#line 624 "vm-configurator.c"
	}
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp49_ = gvir_config_domain_timer_rtc_new ();
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	timer = (GVirConfigDomainTimer*) _tmp49_;
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp50_ = timer;
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_timer_set_tick_policy (_tmp50_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_CATCHUP);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp51_ = clock;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp52_ = timer;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_clock_add_timer (_tmp51_, _tmp52_);
#line 57 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp53_ = gvir_config_domain_timer_pit_new ();
#line 57 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (timer);
#line 57 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	timer = (GVirConfigDomainTimer*) _tmp53_;
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp54_ = timer;
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_timer_set_tick_policy (_tmp54_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_DELAY);
#line 59 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp55_ = clock;
#line 59 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp56_ = timer;
#line 59 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_clock_add_timer (_tmp55_, _tmp56_);
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp57_ = domain;
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp58_ = clock;
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_clock (_tmp57_, _tmp58_);
#line 62 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp59_ = domain;
#line 62 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp60_ = target_path;
#line 62 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp61_ = install_media;
#line 62 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_target_media_config (_tmp59_, _tmp60_, _tmp61_);
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp62_ = install_media;
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp63_ = domain;
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_installer_media_setup_domain_config (_tmp62_, _tmp63_);
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp64_ = gvir_config_domain_graphics_spice_new ();
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	graphics = _tmp64_;
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp65_ = graphics;
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_graphics_spice_set_autoport (_tmp65_, TRUE);
#line 67 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp66_ = domain;
#line 67 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp67_ = graphics;
#line 67 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp66_, (GVirConfigDomainDevice*) _tmp67_);
#line 70 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp68_ = gvir_config_domain_channel_new ();
#line 70 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	channel = _tmp68_;
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp69_ = channel;
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_channel_set_target_type (_tmp69_, GVIR_CONFIG_DOMAIN_CHANNEL_TARGET_VIRTIO);
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp70_ = channel;
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_channel_set_target_name (_tmp70_, "com.redhat.spice.0");
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp71_ = gvir_config_domain_chardev_source_spicevmc_new ();
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	vmc = _tmp71_;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp72_ = channel;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp73_ = vmc;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp72_, (GVirConfigDomainChardevSource*) _tmp73_);
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp74_ = domain;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp75_ = channel;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp74_, (GVirConfigDomainDevice*) _tmp75_);
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp76_ = domain;
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp77_ = install_media;
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_video_config (_tmp76_, _tmp77_);
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp78_ = domain;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp79_ = install_media;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_sound_config (_tmp78_, _tmp79_);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp80_ = domain;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp81_ = install_media;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_tablet_config (_tmp80_, _tmp81_);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp82_ = domain;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (_tmp82_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_POWEROFF, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp83_ = domain;
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (_tmp83_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 83 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp84_ = domain;
#line 83 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (_tmp84_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_CRASH, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (HAVE_PM) {
#line 750 "vm-configurator.c"
		GVirConfigDomainPowerManagement* _tmp85_;
		GVirConfigDomainPowerManagement* pm;
		GVirConfigDomainPowerManagement* _tmp86_;
		GVirConfigDomainPowerManagement* _tmp87_;
		GVirConfigDomain* _tmp88_;
		GVirConfigDomainPowerManagement* _tmp89_;
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp85_ = gvir_config_domain_power_management_new ();
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		pm = _tmp85_;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp86_ = pm;
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_power_management_set_mem_suspend_enabled (_tmp86_, FALSE);
#line 90 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp87_ = pm;
#line 90 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_power_management_set_disk_suspend_enabled (_tmp87_, FALSE);
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp88_ = domain;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp89_ = pm;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_set_power_management (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, gvir_config_domain_get_type (), GVirConfigDomain), _tmp89_);
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_object_unref0 (pm);
#line 777 "vm-configurator.c"
	}
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp90_ = gvir_config_domain_console_new ();
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	console = _tmp90_;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp91_ = console;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp92_ = gvir_config_domain_chardev_source_pty_new ();
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp93_ = _tmp92_;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp91_, (GVirConfigDomainChardevSource*) _tmp93_);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp93_);
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp94_ = domain;
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp95_ = console;
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp94_, (GVirConfigDomainDevice*) _tmp95_);
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp96_ = gvir_config_domain_interface_user_new ();
#line 98 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	iface = _tmp96_;
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp97_ = domain;
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp98_ = iface;
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp97_, (GVirConfigDomainDevice*) _tmp98_);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = domain;
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (iface);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (console);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (vmc);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (channel);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (graphics);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (timer);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (clock);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	features = (_vala_array_free (features, features_length1, (GDestroyNotify) g_free), NULL);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (best_caps);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (xml);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 833 "vm-configurator.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return self ? g_object_ref (self) : NULL;
#line 840 "vm-configurator.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 847 "vm-configurator.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_list_free (self);
#line 856 "vm-configurator.c"
}


void boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain) {
	GVirConfigDomain* _tmp0_;
	GVirConfigDomain* _tmp1_;
	GVirConfigDomain* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* devices;
	GList* _tmp4_;
	GVirConfigDomain* _tmp16_;
	GList* _tmp17_;
	GVirConfigDomain* _tmp18_;
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 105 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 105 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_post_install_os_config (_tmp0_);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = domain;
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (_tmp1_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_RESTART);
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = domain;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_domain_get_devices (_tmp2_);
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	devices = _tmp3_;
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = devices;
#line 888 "vm-configurator.c"
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		device_collection = _tmp4_;
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 896 "vm-configurator.c"
			GVirConfigDomainDevice* _tmp5_;
			GVirConfigDomainDevice* device = NULL;
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp5_ = _g_object_ref0 ((GVirConfigDomainDevice*) device_it->data);
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			device = _tmp5_;
#line 903 "vm-configurator.c"
			{
				GVirConfigDomainDevice* _tmp6_;
				GVirConfigDomainDevice* _tmp7_;
				GVirConfigDomainDisk* _tmp8_;
				GVirConfigDomainDisk* disk;
				GVirConfigDomainDisk* _tmp9_;
				GVirConfigDomainDiskGuestDeviceType _tmp10_ = 0;
				GVirConfigDomainDiskGuestDeviceType disk_type;
				gboolean _tmp11_ = FALSE;
				GVirConfigDomainDiskGuestDeviceType _tmp12_;
				gboolean _tmp14_;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = device;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gvir_config_domain_disk_get_type ())) {
#line 112 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (device);
#line 112 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					continue;
#line 923 "vm-configurator.c"
				}
#line 116 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp7_ = device;
#line 116 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gvir_config_domain_disk_get_type ()) ? ((GVirConfigDomainDisk*) _tmp7_) : NULL);
#line 116 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				disk = _tmp8_;
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp9_ = disk;
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp10_ = gvir_config_domain_disk_get_guest_device_type (_tmp9_);
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				disk_type = _tmp10_;
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp12_ = disk_type;
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp12_ == GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_CDROM) {
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp11_ = TRUE;
#line 943 "vm-configurator.c"
				} else {
					GVirConfigDomainDiskGuestDeviceType _tmp13_;
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp13_ = disk_type;
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp11_ = _tmp13_ == GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_FLOPPY;
#line 950 "vm-configurator.c"
				}
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp14_ = _tmp11_;
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp14_) {
#line 956 "vm-configurator.c"
					GVirConfigDomainDisk* _tmp15_;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp15_ = disk;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					gvir_config_domain_disk_set_startup_policy (_tmp15_, GVIR_CONFIG_DOMAIN_DISK_STARTUP_POLICY_OPTIONAL);
#line 962 "vm-configurator.c"
				}
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (disk);
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (device);
#line 968 "vm-configurator.c"
			}
		}
	}
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = domain;
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp17_ = devices;
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_devices (_tmp16_, _tmp17_);
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp18_ = domain;
#line 124 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_mark_as_installed (_tmp18_);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (devices);
#line 984 "vm-configurator.c"
}


gboolean boxes_vm_configurator_is_install_config (GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
#line 127 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 128 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 128 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_os_state (_tmp0_);
#line 128 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 128 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_INSTALLATION_STATE) == 0;
#line 128 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp2_);
#line 128 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp3_;
#line 128 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1010 "vm-configurator.c"
}


gboolean boxes_vm_configurator_is_live_config (GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_os_state (_tmp0_);
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_LIVE_STATE) == 0;
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp2_);
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp3_;
#line 132 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1036 "vm-configurator.c"
}


GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (const gchar* name, gint64 storage, GError** error) {
	GVirConfigStorageVol* result = NULL;
	GVirConfigStorageVol* _tmp0_;
	GVirConfigStorageVol* volume;
	const gchar* _tmp1_;
	gint64 _tmp2_;
	GVirConfigStorageVolTarget* _tmp3_;
	GVirConfigStorageVolTarget* target;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
	GVirConfigStoragePermissions* permissions;
#line 135 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 136 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_storage_vol_new ();
#line 136 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	volume = _tmp0_;
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = name;
#line 137 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_name (volume, _tmp1_);
#line 138 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = storage;
#line 138 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_capacity (volume, (guint64) _tmp2_);
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_storage_vol_target_new ();
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	target = _tmp3_;
#line 140 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_target_set_format (target, "qcow2");
#line 141 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = boxes_vm_configurator_get_default_permissions ();
#line 141 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp4_;
#line 142 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_target_set_permissions (target, permissions);
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_target (volume, target);
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = volume;
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (permissions);
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (target);
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1086 "vm-configurator.c"
}


GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (GError** error) {
	GVirConfigStoragePool* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* pool_path;
	GVirConfigStoragePool* _tmp1_;
	GVirConfigStoragePool* pool;
	GVirConfigStoragePoolSource* _tmp2_;
	GVirConfigStoragePoolSource* source;
	GVirConfigStoragePoolTarget* _tmp3_;
	GVirConfigStoragePoolTarget* target;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
	GVirConfigStoragePermissions* permissions;
#line 149 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_get_user_pkgdata ("images");
#line 149 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	pool_path = _tmp0_;
#line 150 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_ensure_directory (pool_path);
#line 152 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_storage_pool_new ();
#line 152 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	pool = _tmp1_;
#line 153 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_pool_type (pool, GVIR_CONFIG_STORAGE_POOL_TYPE_DIR);
#line 154 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_name (pool, PACKAGE_TARNAME);
#line 156 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_storage_pool_source_new ();
#line 156 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	source = _tmp2_;
#line 157 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_source_set_directory (source, pool_path);
#line 158 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_source (pool, source);
#line 160 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_storage_pool_target_new ();
#line 160 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	target = _tmp3_;
#line 161 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_target_set_path (target, pool_path);
#line 162 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = boxes_vm_configurator_get_default_permissions ();
#line 162 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp4_;
#line 163 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_target_set_permissions (target, permissions);
#line 164 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_target (pool, target);
#line 166 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = pool;
#line 166 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (permissions);
#line 166 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (target);
#line 166 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (source);
#line 166 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (pool_path);
#line 166 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1150 "vm-configurator.c"
}


static void boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain) {
	GError * _inner_error_ = NULL;
#line 170 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 1158 "vm-configurator.c"
	{
		GVirConfigDomain* _tmp0_;
#line 172 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp0_ = domain;
#line 172 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_set_custom_xml (_tmp0_, BOXES_VM_CONFIGURATOR_INSTALLED_XML, BOXES_VM_CONFIGURATOR_BOXES_NS, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, &_inner_error_);
#line 172 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_inner_error_ != NULL) {
#line 1167 "vm-configurator.c"
			goto __catch64_g_error;
		}
	}
	goto __finally64;
	__catch64_g_error:
	{
		GError* _error_ = NULL;
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_error_ = _inner_error_;
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_inner_error_ = NULL;
#line 173 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_assert_not_reached ();
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_error_free0 (_error_);
#line 1183 "vm-configurator.c"
	}
	__finally64:
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_inner_error_ != NULL) {
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_clear_error (&_inner_error_);
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return;
#line 1194 "vm-configurator.c"
	}
}


static void boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain, GVirConfigCapabilities* caps) {
	GVirConfigCapabilities* _tmp0_;
	GVirConfigCapabilitiesHost* _tmp1_ = NULL;
	GVirConfigCapabilitiesHost* _tmp2_;
	GVirConfigCapabilitiesCpu* _tmp3_ = NULL;
	GVirConfigCapabilitiesCpu* _tmp4_;
	GVirConfigCapabilitiesCpuTopology* _tmp5_ = NULL;
	GVirConfigCapabilitiesCpuTopology* _tmp6_;
	GVirConfigCapabilitiesCpuTopology* topology;
	GVirConfigCapabilitiesCpuTopology* _tmp7_;
	GVirConfigDomain* _tmp8_;
	GVirConfigCapabilitiesCpuTopology* _tmp9_;
	guint64 _tmp10_ = 0ULL;
	GVirConfigCapabilitiesCpuTopology* _tmp11_;
	guint64 _tmp12_ = 0ULL;
	GVirConfigCapabilitiesCpuTopology* _tmp13_;
	guint64 _tmp14_ = 0ULL;
	GVirConfigDomainCpu* _tmp15_;
	GVirConfigDomainCpu* cpu;
	GVirConfigDomainCpu* _tmp16_;
	GVirConfigDomainCpu* _tmp17_;
	GVirConfigCapabilitiesCpuTopology* _tmp18_;
	GVirConfigDomain* _tmp19_;
	GVirConfigDomainCpu* _tmp20_;
#line 176 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 176 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (caps != NULL);
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = caps;
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_get_host (_tmp0_);
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_capabilities_host_get_cpu (_tmp2_);
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = _tmp3_;
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = gvir_config_capabilities_cpu_get_topology (_tmp4_);
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = _tmp5_;
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp4_);
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp2_);
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	topology = _tmp6_;
#line 179 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = topology;
#line 179 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp7_ == NULL) {
#line 180 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_object_unref0 (topology);
#line 180 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return;
#line 1255 "vm-configurator.c"
	}
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = domain;
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = topology;
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = gvir_config_capabilities_cpu_topology_get_sockets (_tmp9_);
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = topology;
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = gvir_config_capabilities_cpu_topology_get_cores (_tmp11_);
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = topology;
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = gvir_config_capabilities_cpu_topology_get_threads (_tmp13_);
#line 182 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_object_set (_tmp8_, "vcpu", (_tmp10_ * _tmp12_) * _tmp14_, NULL);
#line 184 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = gvir_config_domain_cpu_new ();
#line 184 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	cpu = _tmp15_;
#line 185 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = cpu;
#line 185 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_cpu_set_mode (_tmp16_, GVIR_CONFIG_DOMAIN_CPU_MODE_HOST_MODEL);
#line 186 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp17_ = cpu;
#line 186 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp18_ = topology;
#line 186 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_capabilities_cpu_set_topology ((GVirConfigCapabilitiesCpu*) _tmp17_, _tmp18_);
#line 187 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = domain;
#line 187 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp20_ = cpu;
#line 187 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_cpu (_tmp19_, _tmp20_);
#line 176 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (cpu);
#line 176 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (topology);
#line 1297 "vm-configurator.c"
}


static void boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain, const gchar* target_path, BoxesInstallerMedia* install_media) {
	GVirConfigDomainDisk* _tmp0_;
	GVirConfigDomainDisk* disk;
	GVirConfigDomainDisk* _tmp1_;
	GVirConfigDomainDisk* _tmp2_;
	GVirConfigDomainDisk* _tmp3_;
	GVirConfigDomainDisk* _tmp4_;
	GVirConfigDomainDisk* _tmp5_;
	const gchar* _tmp6_;
	GVirConfigDomainDisk* _tmp7_;
	BoxesInstallerMedia* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GVirConfigDomain* _tmp15_;
	GVirConfigDomainDisk* _tmp16_;
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (target_path != NULL);
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 191 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_disk_new ();
#line 191 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	disk = _tmp0_;
#line 192 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = disk;
#line 192 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_type (_tmp1_, GVIR_CONFIG_DOMAIN_DISK_FILE);
#line 193 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = disk;
#line 193 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_guest_device_type (_tmp2_, GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_DISK);
#line 194 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = disk;
#line 194 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_name (_tmp3_, "qemu");
#line 195 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = disk;
#line 195 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_type (_tmp4_, "qcow2");
#line 196 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = disk;
#line 196 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = target_path;
#line 196 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_source (_tmp5_, _tmp6_);
#line 197 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = disk;
#line 197 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_cache (_tmp7_, GVIR_CONFIG_DOMAIN_DISK_CACHE_NONE);
#line 199 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = install_media;
#line 199 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = boxes_installer_media_get_supports_virtio_disk (_tmp8_);
#line 199 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = _tmp9_;
#line 199 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp10_) {
#line 1360 "vm-configurator.c"
		GVirConfigDomainDisk* _tmp11_;
		GVirConfigDomainDisk* _tmp12_;
#line 200 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_debug ("vm-configurator.vala:200: Using virtio controller for the main disk");
#line 201 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = disk;
#line 201 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_bus (_tmp11_, GVIR_CONFIG_DOMAIN_DISK_BUS_VIRTIO);
#line 202 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp12_ = disk;
#line 202 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_dev (_tmp12_, "vda");
#line 1373 "vm-configurator.c"
	} else {
		GVirConfigDomainDisk* _tmp13_;
		GVirConfigDomainDisk* _tmp14_;
#line 204 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_debug ("vm-configurator.vala:204: Using IDE controller for the main disk");
#line 205 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp13_ = disk;
#line 205 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_bus (_tmp13_, GVIR_CONFIG_DOMAIN_DISK_BUS_IDE);
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp14_ = disk;
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_dev (_tmp14_, "hda");
#line 1387 "vm-configurator.c"
	}
#line 209 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = domain;
#line 209 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = disk;
#line 209 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp15_, (GVirConfigDomainDevice*) _tmp16_);
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (disk);
#line 1397 "vm-configurator.c"
}


static void boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain) {
	GVirConfigDomainOs* _tmp0_;
	GVirConfigDomainOs* os;
	GVirConfigDomain* _tmp1_;
	GVirConfigDomainOs* _tmp2_ = NULL;
	GVirConfigDomainOs* old_os;
	GList* _tmp3_ = NULL;
	GList* boot_devices;
	const gchar* _tmp4_ = NULL;
	GVirConfigDomain* _tmp5_;
#line 212 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 213 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_os_new ();
#line 213 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	os = _tmp0_;
#line 214 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_os_type (os, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
#line 216 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = domain;
#line 216 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_domain_get_os (_tmp1_);
#line 216 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	old_os = _tmp2_;
#line 217 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_domain_os_get_boot_devices (old_os);
#line 217 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = _tmp3_;
#line 218 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_remove (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
#line 219 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_boot_devices (os, boot_devices);
#line 221 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = gvir_config_domain_os_get_arch (old_os);
#line 221 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_arch (os, _tmp4_);
#line 223 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = domain;
#line 223 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_os (_tmp5_, os);
#line 212 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_list_free0 (boot_devices);
#line 212 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (old_os);
#line 212 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (os);
#line 1447 "vm-configurator.c"
}


static void boxes_vm_configurator_set_os_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, GVirConfigCapabilitiesGuest* guest_caps) {
	GVirConfigDomainOs* _tmp0_;
	GVirConfigDomainOs* os;
	GVirConfigCapabilitiesGuest* _tmp1_;
	GVirConfigCapabilitiesGuestArch* _tmp2_ = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GList* boot_devices;
	BoxesInstallerMedia* _tmp5_;
	GVirConfigDomain* _tmp6_;
#line 226 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 226 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 226 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (guest_caps != NULL);
#line 227 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_os_new ();
#line 227 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	os = _tmp0_;
#line 228 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_os_type (os, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
#line 229 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = guest_caps;
#line 229 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_capabilities_guest_get_arch (_tmp1_);
#line 229 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = _tmp2_;
#line 229 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = gvir_config_capabilities_guest_arch_get_name (_tmp3_);
#line 229 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_arch (os, _tmp4_);
#line 229 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp3_);
#line 231 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = NULL;
#line 232 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = install_media;
#line 232 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_installer_media_set_direct_boot_params (_tmp5_, os);
#line 233 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
#line 234 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_HD));
#line 235 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_boot_devices (os, boot_devices);
#line 237 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = domain;
#line 237 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_os (_tmp6_, os);
#line 226 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_list_free0 (boot_devices);
#line 226 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (os);
#line 1505 "vm-configurator.c"
}


static void boxes_vm_configurator_set_video_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainVideo* _tmp0_;
	GVirConfigDomainVideo* video;
	BoxesInstallerMedia* _tmp1_;
	OsinfoOs* _tmp2_;
	OsinfoDevice* _tmp3_ = NULL;
	OsinfoDevice* device;
	gint _tmp4_ = 0;
	OsinfoDevice* _tmp5_;
	gint _tmp9_;
	gint model;
	GVirConfigDomainVideo* _tmp10_;
	GVirConfigDomain* _tmp11_;
	GVirConfigDomainVideo* _tmp12_;
#line 240 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 240 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 241 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_video_new ();
#line 241 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	video = _tmp0_;
#line 242 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 242 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_->os;
#line 242 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = boxes_get_os_device_by_prop (_tmp2_, OSINFO_DEVICE_PROP_CLASS, "video");
#line 242 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	device = _tmp3_;
#line 243 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = device;
#line 243 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp5_ != NULL) {
#line 1543 "vm-configurator.c"
		OsinfoDevice* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 243 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = device;
#line 243 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = osinfo_device_get_name (_tmp6_);
#line 243 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp8_ = boxes_get_enum_value (_tmp7_, gvir_config_domain_video_model_get_type ());
#line 243 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = _tmp8_;
#line 1555 "vm-configurator.c"
	} else {
#line 244 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = (gint) GVIR_CONFIG_DOMAIN_VIDEO_MODEL_QXL;
#line 1559 "vm-configurator.c"
	}
#line 243 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = _tmp4_;
#line 243 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	model = _tmp9_;
#line 245 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (model != (-1));
#line 246 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = video;
#line 246 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_video_set_model (_tmp10_, (GVirConfigDomainVideoModel) model);
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = domain;
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = video;
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp11_, (GVirConfigDomainDevice*) _tmp12_);
#line 240 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (device);
#line 240 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (video);
#line 1581 "vm-configurator.c"
}


static void boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainSound* _tmp0_;
	GVirConfigDomainSound* sound;
	BoxesInstallerMedia* _tmp1_;
	OsinfoOs* _tmp2_;
	OsinfoDevice* _tmp3_ = NULL;
	OsinfoDevice* device;
	gint _tmp4_ = 0;
	OsinfoDevice* _tmp5_;
	gint _tmp9_;
	gint model;
	GVirConfigDomainSound* _tmp10_;
	GVirConfigDomain* _tmp11_;
	GVirConfigDomainSound* _tmp12_;
#line 251 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 251 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 252 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_sound_new ();
#line 252 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	sound = _tmp0_;
#line 253 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 253 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_->os;
#line 253 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = boxes_get_os_device_by_prop (_tmp2_, OSINFO_DEVICE_PROP_CLASS, "audio");
#line 253 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	device = _tmp3_;
#line 254 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = device;
#line 254 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp5_ != NULL) {
#line 1619 "vm-configurator.c"
		OsinfoDevice* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 254 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = device;
#line 254 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = osinfo_device_get_name (_tmp6_);
#line 254 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp8_ = boxes_get_enum_value (_tmp7_, gvir_config_domain_sound_model_get_type ());
#line 254 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = _tmp8_;
#line 1631 "vm-configurator.c"
	} else {
#line 255 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = (gint) GVIR_CONFIG_DOMAIN_SOUND_MODEL_AC97;
#line 1635 "vm-configurator.c"
	}
#line 254 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = _tmp4_;
#line 254 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	model = _tmp9_;
#line 256 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (model != (-1));
#line 257 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = sound;
#line 257 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_sound_set_model (_tmp10_, (GVirConfigDomainSoundModel) model);
#line 259 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = domain;
#line 259 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = sound;
#line 259 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp11_, (GVirConfigDomainDevice*) _tmp12_);
#line 251 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (device);
#line 251 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (sound);
#line 1657 "vm-configurator.c"
}


static void boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainInput* _tmp0_;
	GVirConfigDomainInput* input;
	GVirConfigDomain* _tmp1_;
#line 262 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 262 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 263 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_input_new ();
#line 263 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	input = _tmp0_;
#line 264 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_input_set_device_type (input, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_TABLET);
#line 266 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = domain;
#line 266 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp1_, (GVirConfigDomainDevice*) input);
#line 262 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (input);
#line 1681 "vm-configurator.c"
}


static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (void) {
	GVirConfigStoragePermissions* result = NULL;
	GVirConfigStoragePermissions* _tmp0_;
	GVirConfigStoragePermissions* permissions;
	uid_t _tmp1_ = {0};
	gid_t _tmp2_ = {0};
#line 270 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_storage_permissions_new ();
#line 270 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp0_;
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = getuid ();
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_owner (permissions, (guint) _tmp1_);
#line 273 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = getgid ();
#line 273 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_group (permissions, (guint) _tmp2_);
#line 274 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_mode (permissions, (guint) 744);
#line 276 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = permissions;
#line 276 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1709 "vm-configurator.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1250 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1251 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1251 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1251 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1252 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1252 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1252 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1252 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1253 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1253 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1253 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1253 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1253 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1253 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1753 "vm-configurator.c"
	}
#line 1253 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1253 "/home/zeenix/jhbuild/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1759 "vm-configurator.c"
}


static gchar* boxes_vm_configurator_get_os_state (GVirConfigDomain* domain) {
	gchar* result = NULL;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* xml;
	const gchar* _tmp2_;
	GVirConfigDomain* _tmp20_;
	const gchar* _tmp21_ = NULL;
#line 279 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 280 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 280 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_domain_get_custom_xml (_tmp0_, BOXES_VM_CONFIGURATOR_BOXES_NS_URI);
#line 280 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	xml = _tmp1_;
#line 281 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = xml;
#line 281 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp2_ != NULL) {
#line 1783 "vm-configurator.c"
		const gchar* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		guint8* _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		xmlTextReader* _tmp9_;
		xmlTextReader* reader;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp3_ = xml;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp5_ = _tmp4_;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp5__length1 = _tmp4__length1;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = xml;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = strlen (_tmp6_);
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp8_ = _tmp7_;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = xmlReaderForMemory ((gchar*) _tmp5_, _tmp8_, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, NULL, (gint) XML_PARSE_COMPACT);
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		reader = _tmp9_;
#line 1812 "vm-configurator.c"
		{
			gboolean _tmp10_;
#line 287 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp10_ = TRUE;
#line 287 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			while (TRUE) {
#line 1819 "vm-configurator.c"
				gboolean _tmp11_;
				xmlTextReader* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gboolean _tmp17_;
#line 287 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp11_ = _tmp10_;
#line 287 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (!_tmp11_) {
#line 1829 "vm-configurator.c"
					xmlTextReader* _tmp12_;
					gint _tmp13_ = 0;
#line 290 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp12_ = reader;
#line 290 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp13_ = xmlTextReaderNext (_tmp12_);
#line 290 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					if (!(_tmp13_ == 1)) {
#line 290 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
						break;
#line 1840 "vm-configurator.c"
					}
				}
#line 287 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp10_ = FALSE;
#line 288 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp14_ = reader;
#line 288 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp15_ = xmlTextReaderName (_tmp14_);
#line 288 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp16_ = _tmp15_;
#line 288 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp17_ = g_strcmp0 (_tmp16_, "boxes:os-state") == 0;
#line 288 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (_tmp16_);
#line 288 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp17_) {
#line 1857 "vm-configurator.c"
					xmlTextReader* _tmp18_;
					gchar* _tmp19_ = NULL;
#line 289 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp18_ = reader;
#line 289 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp19_ = xmlTextReaderReadString (_tmp18_);
#line 289 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = _tmp19_;
#line 289 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_xmlFreeTextReader0 (reader);
#line 289 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_free0 (xml);
#line 289 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 1872 "vm-configurator.c"
				}
			}
		}
#line 281 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_xmlFreeTextReader0 (reader);
#line 1878 "vm-configurator.c"
	}
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp20_ = domain;
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp21_ = gvir_config_domain_get_name (_tmp20_);
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_debug ("vm-configurator.vala:293: no Boxes OS state for domain '%s'.", _tmp21_);
#line 295 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = NULL;
#line 295 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (xml);
#line 295 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1892 "vm-configurator.c"
}


static GVirConfigCapabilitiesGuest* boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps, BoxesInstallerMedia* install_media, GError** error) {
	GVirConfigCapabilitiesGuest* result = NULL;
	GVirConfigCapabilities* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* guests_caps;
	GList* compat_guests_caps;
	GList* _tmp2_;
	GList* _tmp15_;
	GList* _tmp19_;
	const gchar* _tmp23_ = NULL;
	GError* _tmp24_;
	GError * _inner_error_ = NULL;
#line 298 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 298 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (install_media != NULL, NULL);
#line 300 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = caps;
#line 300 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_get_guests (_tmp0_);
#line 300 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	guests_caps = _tmp1_;
#line 303 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	compat_guests_caps = NULL;
#line 304 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = guests_caps;
#line 1922 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 304 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp2_;
#line 304 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 1930 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp3_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 304 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp3_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 304 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp3_;
#line 1937 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuest* _tmp4_;
				GVirConfigCapabilitiesGuestArch* _tmp5_ = NULL;
				GVirConfigCapabilitiesGuestArch* _tmp6_;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* guest_arch;
				BoxesInstallerMedia* _tmp10_;
				const gchar* _tmp11_;
				gboolean _tmp12_ = FALSE;
#line 305 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = guest_caps;
#line 305 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = gvir_config_capabilities_guest_get_arch (_tmp4_);
#line 305 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = _tmp5_;
#line 305 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp7_ = gvir_config_capabilities_guest_arch_get_name (_tmp6_);
#line 305 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp8_ = g_strdup (_tmp7_);
#line 305 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp9_ = _tmp8_;
#line 305 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (_tmp6_);
#line 305 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				guest_arch = _tmp9_;
#line 307 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp10_ = install_media;
#line 307 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp11_ = guest_arch;
#line 307 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp12_ = boxes_installer_media_is_architecture_compatible (_tmp10_, _tmp11_);
#line 307 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp12_) {
#line 1973 "vm-configurator.c"
					GVirConfigCapabilitiesGuest* _tmp13_;
					GVirConfigCapabilitiesGuest* _tmp14_;
#line 308 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp13_ = guest_caps;
#line 308 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp14_ = _g_object_ref0 (_tmp13_);
#line 308 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					compat_guests_caps = g_list_append (compat_guests_caps, _tmp14_);
#line 1982 "vm-configurator.c"
				}
#line 304 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (guest_arch);
#line 304 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 1988 "vm-configurator.c"
			}
		}
	}
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = compat_guests_caps;
#line 1994 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp15_;
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 2002 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp16_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp16_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp16_;
#line 2009 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuest* _tmp17_;
				gboolean _tmp18_ = FALSE;
#line 313 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp17_ = guest_caps;
#line 313 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp18_ = boxes_vm_configurator_guest_kvm_enabled (_tmp17_);
#line 313 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp18_) {
#line 314 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = guest_caps;
#line 314 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 314 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (guests_caps);
#line 314 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2027 "vm-configurator.c"
				}
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 2031 "vm-configurator.c"
			}
		}
	}
#line 317 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = compat_guests_caps;
#line 2037 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 317 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp19_;
#line 317 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 2045 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp20_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 317 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp20_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 317 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp20_;
#line 2052 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuest* _tmp21_;
				gboolean _tmp22_ = FALSE;
#line 318 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp21_ = guest_caps;
#line 318 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp22_ = boxes_vm_configurator_guest_is_qemu (_tmp21_);
#line 318 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp22_) {
#line 319 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = guest_caps;
#line 319 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 319 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (guests_caps);
#line 319 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2070 "vm-configurator.c"
				}
#line 317 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 2074 "vm-configurator.c"
			}
		}
	}
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp23_ = _ ("Incapable host system");
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp24_ = g_error_new_literal (BOXES_VM_CONFIGURATOR_ERROR, BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS, _tmp23_);
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_inner_error_ = _tmp24_;
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_propagate_error (error, _inner_error_);
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (guests_caps);
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return NULL;
#line 2094 "vm-configurator.c"
	} else {
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (guests_caps);
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_clear_error (&_inner_error_);
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return NULL;
#line 2106 "vm-configurator.c"
	}
#line 298 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 298 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (guests_caps);
#line 2112 "vm-configurator.c"
}


static gboolean boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps) {
	gboolean result = FALSE;
	GVirConfigCapabilitiesGuest* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_ = NULL;
	GVirConfigCapabilitiesGuestArch* arch;
	GVirConfigCapabilitiesGuestArch* _tmp2_;
	GList* _tmp3_ = NULL;
#line 326 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 327 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = guest_caps;
#line 327 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_guest_get_arch (_tmp0_);
#line 327 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	arch = _tmp1_;
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = arch;
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_capabilities_guest_arch_get_domains (_tmp2_);
#line 2135 "vm-configurator.c"
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		domain_collection = _tmp3_;
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
#line 2143 "vm-configurator.c"
			GVirConfigCapabilitiesGuestDomain* _tmp4_;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp4_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			domain = _tmp4_;
#line 2150 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuestDomain* _tmp5_;
				GVirConfigDomainVirtType _tmp6_ = 0;
#line 329 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = domain;
#line 329 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = gvir_config_capabilities_guest_domain_get_virt_type (_tmp5_);
#line 329 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp6_ == GVIR_CONFIG_DOMAIN_VIRT_KVM) {
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = TRUE;
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (domain);
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (domain_collection);
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (arch);
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2170 "vm-configurator.c"
				}
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (domain);
#line 2174 "vm-configurator.c"
			}
		}
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (domain_collection);
#line 2179 "vm-configurator.c"
	}
#line 332 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = FALSE;
#line 332 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (arch);
#line 332 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2187 "vm-configurator.c"
}


static gboolean boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps) {
	gboolean result = FALSE;
	GVirConfigCapabilitiesGuest* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_ = NULL;
	GVirConfigCapabilitiesGuestArch* arch;
	GVirConfigCapabilitiesGuestArch* _tmp2_;
	GList* _tmp3_ = NULL;
#line 335 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 336 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = guest_caps;
#line 336 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_guest_get_arch (_tmp0_);
#line 336 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	arch = _tmp1_;
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = arch;
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_capabilities_guest_arch_get_domains (_tmp2_);
#line 2210 "vm-configurator.c"
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		domain_collection = _tmp3_;
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
#line 2218 "vm-configurator.c"
			GVirConfigCapabilitiesGuestDomain* _tmp4_;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp4_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			domain = _tmp4_;
#line 2225 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuestDomain* _tmp5_;
				GVirConfigDomainVirtType _tmp6_ = 0;
#line 338 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = domain;
#line 338 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = gvir_config_capabilities_guest_domain_get_virt_type (_tmp5_);
#line 338 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp6_ == GVIR_CONFIG_DOMAIN_VIRT_QEMU) {
#line 339 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = TRUE;
#line 339 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (domain);
#line 339 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (domain_collection);
#line 339 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (arch);
#line 339 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2245 "vm-configurator.c"
				}
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (domain);
#line 2249 "vm-configurator.c"
			}
		}
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (domain_collection);
#line 2254 "vm-configurator.c"
	}
#line 341 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = FALSE;
#line 341 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (arch);
#line 341 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2262 "vm-configurator.c"
}


static gboolean boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps, const gchar* feature_name) {
	gboolean result = FALSE;
	gboolean supports;
	GVirConfigCapabilitiesGuest* _tmp0_;
	GList* _tmp1_ = NULL;
#line 344 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 344 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (feature_name != NULL, FALSE);
#line 345 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	supports = FALSE;
#line 347 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = guest_caps;
#line 347 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_guest_get_features (_tmp0_);
#line 2281 "vm-configurator.c"
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
#line 347 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		feature_collection = _tmp1_;
#line 347 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
#line 2289 "vm-configurator.c"
			GVirConfigCapabilitiesGuestFeature* _tmp2_;
			GVirConfigCapabilitiesGuestFeature* feature = NULL;
#line 347 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp2_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestFeature*) feature_it->data);
#line 347 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			feature = _tmp2_;
#line 2296 "vm-configurator.c"
			{
				const gchar* _tmp3_;
				GVirConfigCapabilitiesGuestFeature* _tmp4_;
				const gchar* _tmp5_ = NULL;
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp3_ = feature_name;
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = feature;
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = gvir_config_capabilities_guest_feature_get_name (_tmp4_);
#line 348 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
#line 349 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					supports = TRUE;
#line 351 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (feature);
#line 351 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					break;
#line 2315 "vm-configurator.c"
				}
#line 347 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (feature);
#line 2319 "vm-configurator.c"
			}
		}
#line 347 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (feature_collection);
#line 2324 "vm-configurator.c"
	}
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = supports;
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2330 "vm-configurator.c"
}


BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type) {
	BoxesVMConfigurator* self = NULL;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	self = (BoxesVMConfigurator*) g_type_create_instance (object_type);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return self;
#line 2340 "vm-configurator.c"
}


BoxesVMConfigurator* boxes_vm_configurator_new (void) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return boxes_vm_configurator_construct (BOXES_TYPE_VM_CONFIGURATOR);
#line 2347 "vm-configurator.c"
}


static void boxes_value_vm_configurator_init (GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	value->data[0].v_pointer = NULL;
#line 2354 "vm-configurator.c"
}


static void boxes_value_vm_configurator_free_value (GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (value->data[0].v_pointer) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (value->data[0].v_pointer);
#line 2363 "vm-configurator.c"
	}
}


static void boxes_value_vm_configurator_copy_value (const GValue* src_value, GValue* dest_value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (src_value->data[0].v_pointer) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		dest_value->data[0].v_pointer = boxes_vm_configurator_ref (src_value->data[0].v_pointer);
#line 2373 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2377 "vm-configurator.c"
	}
}


static gpointer boxes_value_vm_configurator_peek_pointer (const GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return value->data[0].v_pointer;
#line 2385 "vm-configurator.c"
}


static gchar* boxes_value_vm_configurator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (collect_values[0].v_pointer) {
#line 2392 "vm-configurator.c"
		BoxesVMConfigurator* object;
		object = collect_values[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (object->parent_instance.g_class == NULL) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2399 "vm-configurator.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2403 "vm-configurator.c"
		}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = boxes_vm_configurator_ref (object);
#line 2407 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 2411 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return NULL;
#line 2415 "vm-configurator.c"
}


static gchar* boxes_value_vm_configurator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BoxesVMConfigurator** object_p;
	object_p = collect_values[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (!object_p) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2426 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (!value->data[0].v_pointer) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*object_p = NULL;
#line 2432 "vm-configurator.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*object_p = value->data[0].v_pointer;
#line 2436 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*object_p = boxes_vm_configurator_ref (value->data[0].v_pointer);
#line 2440 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return NULL;
#line 2444 "vm-configurator.c"
}


GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BoxesParamSpecVMConfigurator* spec;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_VM_CONFIGURATOR), NULL);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return G_PARAM_SPEC (spec);
#line 2458 "vm-configurator.c"
}


gpointer boxes_value_get_vm_configurator (const GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR), NULL);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return value->data[0].v_pointer;
#line 2467 "vm-configurator.c"
}


void boxes_value_set_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	old = value->data[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (v_object) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = v_object;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_ref (value->data[0].v_pointer);
#line 2487 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 2491 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (old) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (old);
#line 2497 "vm-configurator.c"
	}
}


void boxes_value_take_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	old = value->data[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (v_object) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = v_object;
#line 2516 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 2520 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (old) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (old);
#line 2526 "vm-configurator.c"
	}
}


static void boxes_vm_configurator_class_init (BoxesVMConfiguratorClass * klass) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_parent_class = g_type_class_peek_parent (klass);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	BOXES_VM_CONFIGURATOR_CLASS (klass)->finalize = boxes_vm_configurator_finalize;
#line 2536 "vm-configurator.c"
}


static void boxes_vm_configurator_instance_init (BoxesVMConfigurator * self) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	self->ref_count = 1;
#line 2543 "vm-configurator.c"
}


static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj) {
	BoxesVMConfigurator * self;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator);
#line 2551 "vm-configurator.c"
}


GType boxes_vm_configurator_get_type (void) {
	static volatile gsize boxes_vm_configurator_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_vm_configurator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_vm_configurator_init, boxes_value_vm_configurator_free_value, boxes_value_vm_configurator_copy_value, boxes_value_vm_configurator_peek_pointer, "p", boxes_value_vm_configurator_collect_value, "p", boxes_value_vm_configurator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesVMConfiguratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_vm_configurator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesVMConfigurator), 0, (GInstanceInitFunc) boxes_vm_configurator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_vm_configurator_type_id;
		boxes_vm_configurator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesVMConfigurator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_vm_configurator_type_id__volatile, boxes_vm_configurator_type_id);
	}
	return boxes_vm_configurator_type_id__volatile;
}


gpointer boxes_vm_configurator_ref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_atomic_int_inc (&self->ref_count);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return instance;
#line 2576 "vm-configurator.c"
}


void boxes_vm_configurator_unref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		BOXES_VM_CONFIGURATOR_GET_CLASS (self)->finalize (self);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2589 "vm-configurator.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 2597 "vm-configurator.c"
		int i;
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
				destroy_func (((gpointer*) array)[i]);
#line 2605 "vm-configurator.c"
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 470 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	g_free (array);
#line 2617 "vm-configurator.c"
}



