/* SqliteUtils.c generated by valac 0.16.0, the Vala compiler
 * generated from SqliteUtils.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



gchar* dvb_database_sqlite_utils_escape (const gchar* text);
gchar* dvb_database_sqlite_utils_unescape (const gchar* text);


/**
     * Replace "'" with "''"
     */
gchar* dvb_database_sqlite_utils_escape (const gchar* text) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	GRegex* regex = NULL;
	gchar* escaped_str = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = text;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	{
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		_tmp2_ = g_regex_new ("'", G_REGEX_MULTILINE, 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (regex);
		regex = _tmp3_;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("SqliteUtils.vala:36: RegexError: %s", _tmp5_);
		_tmp6_ = text;
		_tmp7_ = g_strdup (_tmp6_);
		result = _tmp7_;
		_g_error_free0 (e);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GRegex* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp8_ = regex;
		_tmp9_ = text;
		_tmp10_ = g_regex_replace_literal (_tmp8_, _tmp9_, (gssize) (-1), 0, "''", 0, &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_free0 (escaped_str);
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (escaped_str);
		escaped_str = _tmp11_;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("SqliteUtils.vala:45: RegexError: %s", _tmp13_);
		_tmp14_ = text;
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		_g_error_free0 (e);
		_g_free0 (escaped_str);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (escaped_str);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = escaped_str;
	_g_regex_unref0 (regex);
	return result;
}


/**
     * Replace "''" with "'"
     */
gchar* dvb_database_sqlite_utils_unescape (const gchar* text) {
	gchar* result = NULL;
	GRegex* regex = NULL;
	gchar* new_str = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	{
		GRegex* _tmp0_;
		GRegex* _tmp1_;
		_tmp0_ = g_regex_new ("''", G_REGEX_MULTILINE, 0, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (regex);
		regex = _tmp1_;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("SqliteUtils.vala:62: RegexError: %s", _tmp3_);
		_tmp4_ = text;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_error_free0 (e);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GRegex* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp6_ = regex;
		_tmp7_ = text;
		_tmp8_ = g_regex_replace_literal (_tmp6_, _tmp7_, (gssize) (-1), 0, "'", 0, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			_g_free0 (new_str);
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (new_str);
		new_str = _tmp9_;
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("SqliteUtils.vala:71: RegexError: %s", _tmp11_);
		_tmp12_ = text;
		_tmp13_ = g_strdup (_tmp12_);
		result = _tmp13_;
		_g_error_free0 (e);
		_g_free0 (new_str);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_free0 (new_str);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = new_str;
	_g_regex_unref0 (regex);
	return result;
}



