/* desktop-tracker-query.c generated by valac 0.35.5.22-e5360, the Vala compiler
 * generated from desktop-tracker-query.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_DESKTOP_TRACKER_QUERY (games_desktop_tracker_query_get_type ())
#define GAMES_DESKTOP_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DESKTOP_TRACKER_QUERY, GamesDesktopTrackerQuery))
#define GAMES_DESKTOP_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DESKTOP_TRACKER_QUERY, GamesDesktopTrackerQueryClass))
#define GAMES_IS_DESKTOP_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DESKTOP_TRACKER_QUERY))
#define GAMES_IS_DESKTOP_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DESKTOP_TRACKER_QUERY))
#define GAMES_DESKTOP_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DESKTOP_TRACKER_QUERY, GamesDesktopTrackerQueryClass))

typedef struct _GamesDesktopTrackerQuery GamesDesktopTrackerQuery;
typedef struct _GamesDesktopTrackerQueryClass GamesDesktopTrackerQueryClass;
typedef struct _GamesDesktopTrackerQueryPrivate GamesDesktopTrackerQueryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GAMES_TYPE_DESKTOP_TITLE (games_desktop_title_get_type ())
#define GAMES_DESKTOP_TITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DESKTOP_TITLE, GamesDesktopTitle))
#define GAMES_DESKTOP_TITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DESKTOP_TITLE, GamesDesktopTitleClass))
#define GAMES_IS_DESKTOP_TITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DESKTOP_TITLE))
#define GAMES_IS_DESKTOP_TITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DESKTOP_TITLE))
#define GAMES_DESKTOP_TITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DESKTOP_TITLE, GamesDesktopTitleClass))

typedef struct _GamesDesktopTitle GamesDesktopTitle;
typedef struct _GamesDesktopTitleClass GamesDesktopTitleClass;

#define GAMES_TYPE_DESKTOP_ICON (games_desktop_icon_get_type ())
#define GAMES_DESKTOP_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DESKTOP_ICON, GamesDesktopIcon))
#define GAMES_DESKTOP_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DESKTOP_ICON, GamesDesktopIconClass))
#define GAMES_IS_DESKTOP_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DESKTOP_ICON))
#define GAMES_IS_DESKTOP_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DESKTOP_ICON))
#define GAMES_DESKTOP_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DESKTOP_ICON, GamesDesktopIconClass))

typedef struct _GamesDesktopIcon GamesDesktopIcon;
typedef struct _GamesDesktopIconClass GamesDesktopIconClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GamesDesktopTrackerQueryForeachGameData GamesDesktopTrackerQueryForeachGameData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _GamesDesktopTrackerQuery {
	GObject parent_instance;
	GamesDesktopTrackerQueryPrivate * priv;
};

struct _GamesDesktopTrackerQueryClass {
	GObjectClass parent_class;
};

struct _GamesDesktopTrackerQueryPrivate {
	GamesGame** games;
	gint games_length1;
	gint _games_size_;
};

struct _GamesDesktopTrackerQueryForeachGameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean _task_complete_;
	GamesDesktopTrackerQuery* self;
	GamesGameCallback game_callback;
	gpointer game_callback_target;
	guint handled_games;
	GamesGame** _tmp0_;
	gint _tmp0__length1;
	GamesGame** game_collection;
	gint game_collection_length1;
	gint _game_collection_size_;
	gint game_it;
	GamesGame* _tmp1_;
	GamesGame* game;
	GamesGameCallback _tmp2_;
	void* _tmp2__target;
	GamesGame* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
};

typedef enum  {
	GAMES_DESKTOP_ERROR_INVALID_APPINFO,
	GAMES_DESKTOP_ERROR_BLACKLISTED_GAME
} GamesDesktopError;
#define GAMES_DESKTOP_ERROR games_desktop_error_quark ()

static gpointer games_desktop_tracker_query_parent_class = NULL;
static gchar** games_desktop_tracker_query_categories_black_list;
static gint games_desktop_tracker_query_categories_black_list_length1;
static gchar** games_desktop_tracker_query_categories_black_list = NULL;
static gint games_desktop_tracker_query_categories_black_list_length1 = 0;
static gint _games_desktop_tracker_query_categories_black_list_size_ = 0;
static gchar** games_desktop_tracker_query_executable_black_list;
static gint games_desktop_tracker_query_executable_black_list_length1;
static gchar** games_desktop_tracker_query_executable_black_list = NULL;
static gint games_desktop_tracker_query_executable_black_list_length1 = 0;
static gint _games_desktop_tracker_query_executable_black_list_size_ = 0;
static gchar** games_desktop_tracker_query_base_name_black_list;
static gint games_desktop_tracker_query_base_name_black_list_length1;
static gchar** games_desktop_tracker_query_base_name_black_list = NULL;
static gint games_desktop_tracker_query_base_name_black_list_length1 = 0;
static gint _games_desktop_tracker_query_base_name_black_list_size_ = 0;
static GamesTrackerQueryIface * games_desktop_tracker_query_games_tracker_query_parent_iface = NULL;
static GType games_desktop_tracker_query_type_id = 0;

GType games_desktop_tracker_query_get_type (void) G_GNUC_CONST;
#define GAMES_DESKTOP_TRACKER_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_DESKTOP_TRACKER_QUERY, GamesDesktopTrackerQueryPrivate))
enum  {
	GAMES_DESKTOP_TRACKER_QUERY_DUMMY_PROPERTY
};
#define GAMES_DESKTOP_TRACKER_QUERY_HANDLED_GAMES_PER_CYCLE ((guint) 5)
static gchar* games_desktop_tracker_query_real_get_query (GamesTrackerQuery* base);
static gboolean games_desktop_tracker_query_real_is_cursor_valid (GamesTrackerQuery* base, TrackerSparqlCursor* cursor);
gboolean games_desktop_tracker_query_is_uri_valid (GamesDesktopTrackerQuery* self, const gchar* uri);
static void games_desktop_tracker_query_check_uri (GamesDesktopTrackerQuery* self, const gchar* uri, GError** error);
static void games_desktop_tracker_query_real_process_cursor (GamesTrackerQuery* base, TrackerSparqlCursor* cursor);
void games_desktop_tracker_query_process_uri (GamesDesktopTrackerQuery* self, const gchar* uri, GError** error);
GType games_desktop_title_get_type (void) G_GNUC_CONST;
GamesDesktopTitle* games_desktop_title_new (GDesktopAppInfo* app_info);
GamesDesktopTitle* games_desktop_title_construct (GType object_type, GDesktopAppInfo* app_info);
GType games_desktop_icon_get_type (void) G_GNUC_CONST;
GamesDesktopIcon* games_desktop_icon_new (GDesktopAppInfo* app_info);
GamesDesktopIcon* games_desktop_icon_construct (GType object_type, GDesktopAppInfo* app_info);
static void _vala_array_add1 (GamesGame** * array, int* length, int* size, GamesGame* value);
static void games_desktop_tracker_query_real_foreach_game_data_free (gpointer _data);
static void games_desktop_tracker_query_real_foreach_game (GamesTrackerQuery* base, GamesGameCallback game_callback, void* game_callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean games_desktop_tracker_query_real_foreach_game_co (GamesDesktopTrackerQueryForeachGameData* _data_);
static gboolean _games_desktop_tracker_query_real_foreach_game_co_gsource_func (gpointer self);
GQuark games_desktop_error_quark (void);
static void games_desktop_tracker_query_check_categories (GamesDesktopTrackerQuery* self, GDesktopAppInfo* app_info, GError** error);
static void games_desktop_tracker_query_check_executable (GamesDesktopTrackerQuery* self, GDesktopAppInfo* app_info, GError** error);
static void games_desktop_tracker_query_check_base_name (GamesDesktopTrackerQuery* self, GFile* file, GError** error);
static gchar** games_desktop_tracker_query_get_categories_black_list (int* result_length1, GError** error);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
static gchar** games_desktop_tracker_query_get_executable_black_list (int* result_length1, GError** error);
static gchar** games_desktop_tracker_query_get_base_name_black_list (int* result_length1, GError** error);
static gchar** games_desktop_tracker_query_get_lines_from_resource (const gchar* resource, int* result_length1, GError** error);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value);
GamesDesktopTrackerQuery* games_desktop_tracker_query_new (void);
GamesDesktopTrackerQuery* games_desktop_tracker_query_construct (GType object_type);
static GObject * games_desktop_tracker_query_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void games_desktop_tracker_query_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar* games_desktop_tracker_query_real_get_query (GamesTrackerQuery* base) {
	GamesDesktopTrackerQuery * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (GamesDesktopTrackerQuery*) base;
	_tmp0_ = g_strdup ("SELECT ?soft WHERE { ?soft nie:isLogicalPartOf 'urn:software-category:" \
"Game' . }");
	result = _tmp0_;
	return result;
}


static gboolean games_desktop_tracker_query_real_is_cursor_valid (GamesTrackerQuery* base, TrackerSparqlCursor* cursor) {
	GamesDesktopTrackerQuery * self;
	gboolean result = FALSE;
	gchar* uri;
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	self = (GamesDesktopTrackerQuery*) base;
	g_return_val_if_fail (cursor != NULL, FALSE);
	_tmp0_ = cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, 0, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	uri = _tmp2_;
	_tmp3_ = games_desktop_tracker_query_is_uri_valid (self, uri);
	result = _tmp3_;
	_g_free0 (uri);
	return result;
}


gboolean games_desktop_tracker_query_is_uri_valid (GamesDesktopTrackerQuery* self, const gchar* uri) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	{
		const gchar* _tmp0_;
		_tmp0_ = uri;
		games_desktop_tracker_query_check_uri (self, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp1_;
	}
	result = TRUE;
	return result;
}


static void games_desktop_tracker_query_real_process_cursor (GamesTrackerQuery* base, TrackerSparqlCursor* cursor) {
	GamesDesktopTrackerQuery * self;
	gchar* uri;
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (GamesDesktopTrackerQuery*) base;
	g_return_if_fail (cursor != NULL);
	_tmp0_ = cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, 0, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	uri = _tmp2_;
	{
		games_desktop_tracker_query_process_uri (self, uri, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("desktop-tracker-query.vala:38: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (uri);
}


static void _vala_array_add1 (GamesGame** * array, int* length, int* size, GamesGame* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGame*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void games_desktop_tracker_query_process_uri (GamesDesktopTrackerQuery* self, const gchar* uri, GError** error) {
	const gchar* _tmp0_;
	GFile* file;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* path;
	GFile* _tmp3_;
	gchar* _tmp4_;
	GDesktopAppInfo* app_info;
	const gchar* _tmp5_;
	GDesktopAppInfo* _tmp6_;
	GamesDesktopTitle* title;
	GDesktopAppInfo* _tmp7_;
	GamesDesktopTitle* _tmp8_;
	GamesDesktopIcon* icon;
	GDesktopAppInfo* _tmp9_;
	GamesDesktopIcon* _tmp10_;
	GamesDummyCover* cover;
	GamesDummyCover* _tmp11_;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gchar* command;
	GDesktopAppInfo* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	const gchar* _tmp16_;
	gchar** _tmp17_ = NULL;
	gint _tmp18_;
	gboolean _tmp19_;
	GamesCommandRunner* runner;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GamesCommandRunner* _tmp23_;
	GamesGame** _tmp24_;
	gint _tmp24__length1;
	GamesDesktopTitle* _tmp25_;
	GamesDesktopIcon* _tmp26_;
	GamesDummyCover* _tmp27_;
	GamesCommandRunner* _tmp28_;
	GamesGenericGame* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = uri;
	games_desktop_tracker_query_check_uri (self, _tmp0_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = uri;
	_tmp2_ = g_file_new_for_uri (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = g_file_get_path (_tmp3_);
	path = _tmp4_;
	_tmp5_ = path;
	_tmp6_ = g_desktop_app_info_new_from_filename (_tmp5_);
	app_info = _tmp6_;
	_tmp7_ = app_info;
	_tmp8_ = games_desktop_title_new (_tmp7_);
	title = _tmp8_;
	_tmp9_ = app_info;
	_tmp10_ = games_desktop_icon_new (_tmp9_);
	icon = _tmp10_;
	_tmp11_ = games_dummy_cover_new ();
	cover = _tmp11_;
	_tmp12_ = app_info;
	_tmp13_ = g_app_info_get_commandline ((GAppInfo*) _tmp12_);
	_tmp14_ = g_strdup (_tmp13_);
	command = _tmp14_;
	_tmp16_ = command;
	_tmp19_ = g_shell_parse_argv (_tmp16_, &_tmp18_, &_tmp17_, &_inner_error_);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	args = _tmp17_;
	args_length1 = _tmp18_;
	_args_size_ = args_length1;
	_tmp15_ = _tmp19_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (command);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (cover);
		_g_object_unref0 (icon);
		_g_object_unref0 (title);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	if (!_tmp15_) {
		const gchar* _tmp20_;
		GError* _tmp21_;
		_tmp20_ = command;
		_tmp21_ = g_error_new (GAMES_COMMAND_ERROR, GAMES_COMMAND_ERROR_INVALID_COMMAND, _ ("Invalid command “%s”."), _tmp20_);
		_inner_error_ = _tmp21_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (command);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (cover);
		_g_object_unref0 (icon);
		_g_object_unref0 (title);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_tmp22_ = args;
	_tmp22__length1 = args_length1;
	_tmp23_ = games_command_runner_new (_tmp22_, _tmp22__length1, TRUE);
	runner = _tmp23_;
	_tmp24_ = self->priv->games;
	_tmp24__length1 = self->priv->games_length1;
	_tmp25_ = title;
	_tmp26_ = icon;
	_tmp27_ = cover;
	_tmp28_ = runner;
	_tmp29_ = games_generic_game_new ((GamesTitle*) _tmp25_, (GamesIcon*) _tmp26_, (GamesCover*) _tmp27_, (GamesRunner*) _tmp28_);
	_vala_array_add1 (&self->priv->games, &self->priv->games_length1, &self->priv->_games_size_, (GamesGame*) _tmp29_);
	_g_object_unref0 (runner);
	_g_free0 (command);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (cover);
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (app_info);
	_g_free0 (path);
	_g_object_unref0 (file);
}


static void games_desktop_tracker_query_real_foreach_game_data_free (gpointer _data) {
	GamesDesktopTrackerQueryForeachGameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesDesktopTrackerQueryForeachGameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void games_desktop_tracker_query_real_foreach_game (GamesTrackerQuery* base, GamesGameCallback game_callback, void* game_callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GamesDesktopTrackerQuery * self;
	GamesDesktopTrackerQueryForeachGameData* _data_;
	GamesDesktopTrackerQuery* _tmp0_;
	GamesGameCallback _tmp1_;
	void* _tmp1__target;
	self = (GamesDesktopTrackerQuery*) base;
	_data_ = g_slice_new0 (GamesDesktopTrackerQueryForeachGameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_desktop_tracker_query_real_foreach_game_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = game_callback;
	_tmp1__target = game_callback_target;
	_data_->game_callback = _tmp1_;
	_data_->game_callback_target = _tmp1__target;
	games_desktop_tracker_query_real_foreach_game_co (_data_);
}


static void games_desktop_tracker_query_real_foreach_game_finish (GamesTrackerQuery* base, GAsyncResult* _res_) {
	GamesDesktopTrackerQueryForeachGameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	_data_->_task_complete_ = TRUE;
}


static gboolean _games_desktop_tracker_query_real_foreach_game_co_gsource_func (gpointer self) {
	gboolean result;
	result = games_desktop_tracker_query_real_foreach_game_co (self);
	return result;
}


static gboolean games_desktop_tracker_query_real_foreach_game_co (GamesDesktopTrackerQueryForeachGameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->handled_games = (guint) 0;
	_data_->_tmp0_ = _data_->self->priv->games;
	_data_->_tmp0__length1 = _data_->self->priv->games_length1;
	{
		_data_->game_collection_length1 = 0;
		_data_->_game_collection_size_ = 0;
		_data_->game_collection = _data_->_tmp0_;
		_data_->game_collection_length1 = _data_->_tmp0__length1;
		for (_data_->game_it = 0; _data_->game_it < _data_->_tmp0__length1; _data_->game_it = _data_->game_it + 1) {
			_data_->_tmp1_ = _g_object_ref0 (_data_->game_collection[_data_->game_it]);
			_data_->game = _data_->_tmp1_;
			{
				_data_->_tmp2_ = _data_->game_callback;
				_data_->_tmp2__target = _data_->game_callback_target;
				_data_->_tmp3_ = _data_->game;
				_data_->_tmp2_ (_data_->_tmp3_, _data_->_tmp2__target);
				_data_->_tmp4_ = _data_->handled_games;
				_data_->handled_games = _data_->_tmp4_ + 1;
				_data_->_tmp5_ = _data_->handled_games;
				if (_data_->_tmp5_ >= GAMES_DESKTOP_TRACKER_QUERY_HANDLED_GAMES_PER_CYCLE) {
					_data_->handled_games = (guint) 0;
					g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _games_desktop_tracker_query_real_foreach_game_co_gsource_func, _data_, NULL);
					_data_->_state_ = 1;
					return FALSE;
					_state_1:
					;
				}
				_g_object_unref0 (_data_->game);
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void games_desktop_tracker_query_check_uri (GamesDesktopTrackerQuery* self, const gchar* uri, GError** error) {
	GFile* file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	gchar* path;
	GFile* _tmp6_;
	gchar* _tmp7_;
	GDesktopAppInfo* app_info;
	GDesktopAppInfo* _tmp8_;
	GFile* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		const gchar* _tmp4_;
		GError* _tmp5_;
		_tmp4_ = uri;
		_tmp5_ = g_error_new (TRACKER_ERROR, TRACKER_ERROR_FILE_NOT_FOUND, _ ("Tracker listed file not found: “%s”."), _tmp4_);
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return;
	}
	_tmp6_ = file;
	_tmp7_ = g_file_get_path (_tmp6_);
	path = _tmp7_;
	_tmp8_ = g_desktop_app_info_new_from_filename (path);
	app_info = _tmp8_;
	if (app_info == NULL) {
		GError* _tmp9_;
		_tmp9_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_INVALID_APPINFO, _ ("Couldn’t parse desktop entry “%s”."), path);
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	games_desktop_tracker_query_check_categories (self, app_info, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	games_desktop_tracker_query_check_executable (self, app_info, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_tmp10_ = file;
	games_desktop_tracker_query_check_base_name (self, _tmp10_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_g_object_unref0 (app_info);
	_g_free0 (path);
	_g_object_unref0 (file);
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void games_desktop_tracker_query_check_categories (GamesDesktopTrackerQuery* self, GDesktopAppInfo* app_info, GError** error) {
	gchar* categories_string;
	GDesktopAppInfo* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** categories;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint categories_length1;
	gint _categories_size_;
	gchar** _tmp6_;
	gint _tmp7_;
	gchar** _tmp8_;
	gint _tmp6__length1;
	gint __tmp6__size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_info != NULL);
	_tmp0_ = app_info;
	_tmp1_ = g_desktop_app_info_get_categories (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	categories_string = _tmp2_;
	_tmp3_ = categories_string;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ";", 0);
	categories = _tmp5_;
	categories_length1 = _vala_array_length (_tmp4_);
	_categories_size_ = categories_length1;
	_tmp8_ = games_desktop_tracker_query_get_categories_black_list (&_tmp7_, &_inner_error_);
	_tmp6_ = _tmp8_;
	_tmp6__length1 = _tmp7_;
	__tmp6__size_ = _tmp6__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (categories_string);
		return;
	}
	_tmp9_ = _tmp6_;
	_tmp9__length1 = _tmp6__length1;
	_tmp6_ = NULL;
	_tmp6__length1 = 0;
	{
		gchar** category_collection = NULL;
		gint category_collection_length1 = 0;
		gint _category_collection_size_ = 0;
		gint category_it = 0;
		category_collection = _tmp9_;
		category_collection_length1 = _tmp9__length1;
		for (category_it = 0; category_it < _tmp9__length1; category_it = category_it + 1) {
			gchar* _tmp10_;
			gchar* category = NULL;
			_tmp10_ = g_strdup (category_collection[category_it]);
			category = _tmp10_;
			{
				const gchar* _tmp11_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				_tmp11_ = category;
				_tmp12_ = categories;
				_tmp12__length1 = categories_length1;
				if (_vala_string_array_contains (_tmp12_, _tmp12__length1, _tmp11_)) {
					GDesktopAppInfo* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					GError* _tmp17_;
					_tmp13_ = app_info;
					_tmp14_ = g_desktop_app_info_get_filename (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = category;
					_tmp17_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, _ ("“%s” has blacklisted category “%s”."), _tmp15_, _tmp16_);
					_inner_error_ = _tmp17_;
					g_propagate_error (error, _inner_error_);
					_g_free0 (category);
					category_collection = (_vala_array_free (category_collection, category_collection_length1, (GDestroyNotify) g_free), NULL);
					_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
					categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (categories_string);
					return;
				}
				_g_free0 (category);
			}
		}
		category_collection = (_vala_array_free (category_collection, category_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (categories_string);
}


static void games_desktop_tracker_query_check_executable (GamesDesktopTrackerQuery* self, GDesktopAppInfo* app_info, GError** error) {
	gchar* app_executable;
	GDesktopAppInfo* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gint _tmp3__length1;
	gint __tmp3__size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_info != NULL);
	_tmp0_ = app_info;
	_tmp1_ = g_app_info_get_executable ((GAppInfo*) _tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	app_executable = _tmp2_;
	_tmp5_ = games_desktop_tracker_query_get_executable_black_list (&_tmp4_, &_inner_error_);
	_tmp3_ = _tmp5_;
	_tmp3__length1 = _tmp4_;
	__tmp3__size_ = _tmp3__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (app_executable);
		return;
	}
	_tmp6_ = _tmp3_;
	_tmp6__length1 = _tmp3__length1;
	_tmp3_ = NULL;
	_tmp3__length1 = 0;
	{
		gchar** executable_collection = NULL;
		gint executable_collection_length1 = 0;
		gint _executable_collection_size_ = 0;
		gint executable_it = 0;
		executable_collection = _tmp6_;
		executable_collection_length1 = _tmp6__length1;
		for (executable_it = 0; executable_it < _tmp6__length1; executable_it = executable_it + 1) {
			gchar* _tmp7_;
			gchar* executable = NULL;
			_tmp7_ = g_strdup (executable_collection[executable_it]);
			executable = _tmp7_;
			{
				gboolean _tmp8_ = FALSE;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = app_executable;
				_tmp10_ = executable;
				if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
					_tmp8_ = TRUE;
				} else {
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gboolean _tmp15_;
					_tmp11_ = app_executable;
					_tmp12_ = executable;
					_tmp13_ = g_strconcat ("/", _tmp12_, NULL);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_str_has_suffix (_tmp11_, _tmp14_);
					_tmp8_ = _tmp15_;
					_g_free0 (_tmp14_);
				}
				if (_tmp8_) {
					GDesktopAppInfo* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					GError* _tmp20_;
					_tmp16_ = app_info;
					_tmp17_ = g_desktop_app_info_get_filename (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = executable;
					_tmp20_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, _ ("“%s” has blacklisted executable “%s”."), _tmp18_, _tmp19_);
					_inner_error_ = _tmp20_;
					g_propagate_error (error, _inner_error_);
					_g_free0 (executable);
					executable_collection = (_vala_array_free (executable_collection, executable_collection_length1, (GDestroyNotify) g_free), NULL);
					_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (app_executable);
					return;
				}
				_g_free0 (executable);
			}
		}
		executable_collection = (_vala_array_free (executable_collection, executable_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (app_executable);
}


static void games_desktop_tracker_query_check_base_name (GamesDesktopTrackerQuery* self, GFile* file, GError** error) {
	gchar* base_name;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp3_;
	gchar** _tmp4_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_basename (_tmp0_);
	base_name = _tmp1_;
	_tmp4_ = games_desktop_tracker_query_get_base_name_black_list (&_tmp3_, &_inner_error_);
	_tmp2_ = _tmp4_;
	_tmp2__length1 = _tmp3_;
	__tmp2__size_ = _tmp2__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (base_name);
		return;
	}
	_tmp5_ = base_name;
	_tmp6_ = _tmp2_;
	_tmp6__length1 = _tmp2__length1;
	_tmp2_ = NULL;
	_tmp2__length1 = 0;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	_tmp8_ = _vala_string_array_contains (_tmp7_, _tmp6__length1, _tmp5_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp8_) {
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp9_ = file;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, _ ("“%s” is blacklisted."), _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_inner_error_ = _tmp13_;
		g_propagate_error (error, _inner_error_);
		_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (base_name);
		return;
	}
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (base_name);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** games_desktop_tracker_query_get_categories_black_list (int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = games_desktop_tracker_query_categories_black_list;
	_tmp0__length1 = games_desktop_tracker_query_categories_black_list_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gint _tmp2_;
		gchar** _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = games_desktop_tracker_query_get_lines_from_resource ("plugins/desktop/blacklists/desktop-categories.blacklist", &_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp4__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		games_desktop_tracker_query_categories_black_list = (_vala_array_free (games_desktop_tracker_query_categories_black_list, games_desktop_tracker_query_categories_black_list_length1, (GDestroyNotify) g_free), NULL);
		games_desktop_tracker_query_categories_black_list = _tmp4_;
		games_desktop_tracker_query_categories_black_list_length1 = _tmp4__length1;
		_games_desktop_tracker_query_categories_black_list_size_ = games_desktop_tracker_query_categories_black_list_length1;
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = games_desktop_tracker_query_categories_black_list;
	_tmp5__length1 = games_desktop_tracker_query_categories_black_list_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup1 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** games_desktop_tracker_query_get_executable_black_list (int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = games_desktop_tracker_query_executable_black_list;
	_tmp0__length1 = games_desktop_tracker_query_executable_black_list_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gint _tmp2_;
		gchar** _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = games_desktop_tracker_query_get_lines_from_resource ("plugins/desktop/blacklists/desktop-executable.blacklist", &_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp4__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		games_desktop_tracker_query_executable_black_list = (_vala_array_free (games_desktop_tracker_query_executable_black_list, games_desktop_tracker_query_executable_black_list_length1, (GDestroyNotify) g_free), NULL);
		games_desktop_tracker_query_executable_black_list = _tmp4_;
		games_desktop_tracker_query_executable_black_list_length1 = _tmp4__length1;
		_games_desktop_tracker_query_executable_black_list_size_ = games_desktop_tracker_query_executable_black_list_length1;
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = games_desktop_tracker_query_executable_black_list;
	_tmp5__length1 = games_desktop_tracker_query_executable_black_list_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** games_desktop_tracker_query_get_base_name_black_list (int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = games_desktop_tracker_query_base_name_black_list;
	_tmp0__length1 = games_desktop_tracker_query_base_name_black_list_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gint _tmp2_;
		gchar** _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = games_desktop_tracker_query_get_lines_from_resource ("plugins/desktop/blacklists/desktop-base-name.blacklist", &_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp4__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		games_desktop_tracker_query_base_name_black_list = (_vala_array_free (games_desktop_tracker_query_base_name_black_list, games_desktop_tracker_query_base_name_black_list_length1, (GDestroyNotify) g_free), NULL);
		games_desktop_tracker_query_base_name_black_list = _tmp4_;
		games_desktop_tracker_query_base_name_black_list_length1 = _tmp4__length1;
		_games_desktop_tracker_query_base_name_black_list_size_ = games_desktop_tracker_query_base_name_black_list_length1;
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = games_desktop_tracker_query_base_name_black_list;
	_tmp5__length1 = games_desktop_tracker_query_base_name_black_list_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup3 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** games_desktop_tracker_query_get_lines_from_resource (const gchar* resource, int* result_length1, GError** error) {
	gchar** result = NULL;
	GBytes* bytes;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GBytes* _tmp3_;
	GBytes* _tmp4_;
	gchar* text;
	gsize _tmp5_;
	guint8* _tmp6_;
	gchar* _tmp7_;
	gchar** lines;
	gchar** _tmp8_;
	gint lines_length1;
	gint _lines_size_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (resource != NULL, NULL);
	_tmp0_ = resource;
	_tmp1_ = g_strconcat ("/org/gnome/Games/", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_resources_lookup_data (_tmp2_, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	bytes = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp6_ = g_bytes_get_data (bytes, &_tmp5_);
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
	text = _tmp7_;
	_tmp8_ = g_new0 (gchar*, 0 + 1);
	lines = _tmp8_;
	lines_length1 = 0;
	_lines_size_ = lines_length1;
	_tmp9_ = text;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp11_;
		line_collection_length1 = _vala_array_length (_tmp10_);
		for (line_it = 0; line_it < _vala_array_length (_tmp10_); line_it = line_it + 1) {
			gchar* _tmp12_;
			gchar* line = NULL;
			_tmp12_ = g_strdup (line_collection[line_it]);
			line = _tmp12_;
			{
				const gchar* _tmp13_;
				_tmp13_ = line;
				if (g_strcmp0 (_tmp13_, "") != 0) {
					gchar** _tmp14_;
					gint _tmp14__length1;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = lines;
					_tmp14__length1 = lines_length1;
					_tmp15_ = line;
					_tmp16_ = g_strdup (_tmp15_);
					_vala_array_add2 (&lines, &lines_length1, &_lines_size_, _tmp16_);
				}
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp17_ = lines;
	_tmp17__length1 = lines_length1;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	_g_free0 (text);
	_g_bytes_unref0 (bytes);
	return result;
}


GamesDesktopTrackerQuery* games_desktop_tracker_query_construct (GType object_type) {
	GamesDesktopTrackerQuery * self = NULL;
	self = (GamesDesktopTrackerQuery*) g_object_new (object_type, NULL);
	return self;
}


GamesDesktopTrackerQuery* games_desktop_tracker_query_new (void) {
	return games_desktop_tracker_query_construct (GAMES_TYPE_DESKTOP_TRACKER_QUERY);
}


static GObject * games_desktop_tracker_query_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GamesDesktopTrackerQuery * self;
	GamesGame** _tmp0_;
	parent_class = G_OBJECT_CLASS (games_desktop_tracker_query_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_DESKTOP_TRACKER_QUERY, GamesDesktopTrackerQuery);
	_tmp0_ = g_new0 (GamesGame*, 0 + 1);
	self->priv->games = (_vala_array_free (self->priv->games, self->priv->games_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->games = _tmp0_;
	self->priv->games_length1 = 0;
	self->priv->_games_size_ = self->priv->games_length1;
	return obj;
}


static void games_desktop_tracker_query_class_init (GamesDesktopTrackerQueryClass * klass) {
	games_desktop_tracker_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesDesktopTrackerQueryPrivate));
	G_OBJECT_CLASS (klass)->constructor = games_desktop_tracker_query_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_desktop_tracker_query_finalize;
}


static void games_desktop_tracker_query_games_tracker_query_interface_init (GamesTrackerQueryIface * iface) {
	games_desktop_tracker_query_games_tracker_query_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_query = (gchar* (*) (GamesTrackerQuery *)) games_desktop_tracker_query_real_get_query;
	iface->is_cursor_valid = (gboolean (*) (GamesTrackerQuery *, TrackerSparqlCursor*)) games_desktop_tracker_query_real_is_cursor_valid;
	iface->process_cursor = (void (*) (GamesTrackerQuery *, TrackerSparqlCursor*)) games_desktop_tracker_query_real_process_cursor;
	iface->foreach_game = (void (*) (GamesTrackerQuery *, GamesGameCallback, void*)) games_desktop_tracker_query_real_foreach_game;
	iface->foreach_game_finish = games_desktop_tracker_query_real_foreach_game_finish;
}


static void games_desktop_tracker_query_instance_init (GamesDesktopTrackerQuery * self) {
	self->priv = GAMES_DESKTOP_TRACKER_QUERY_GET_PRIVATE (self);
}


static void games_desktop_tracker_query_finalize (GObject * obj) {
	GamesDesktopTrackerQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_DESKTOP_TRACKER_QUERY, GamesDesktopTrackerQuery);
	self->priv->games = (_vala_array_free (self->priv->games, self->priv->games_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (games_desktop_tracker_query_parent_class)->finalize (obj);
}


GType games_desktop_tracker_query_get_type (void) {
	return games_desktop_tracker_query_type_id;
}


GType games_desktop_tracker_query_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesDesktopTrackerQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_desktop_tracker_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesDesktopTrackerQuery), 0, (GInstanceInitFunc) games_desktop_tracker_query_instance_init, NULL };
	static const GInterfaceInfo games_tracker_query_info = { (GInterfaceInitFunc) games_desktop_tracker_query_games_tracker_query_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_desktop_tracker_query_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesDesktopTrackerQuery", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_desktop_tracker_query_type_id, GAMES_TYPE_TRACKER_QUERY, &games_tracker_query_info);
	return games_desktop_tracker_query_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



