/* grep.c generated by valac 0.35.5.22-e5360, the Vala compiler
 * generated from grep.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



gsize* games_grep_get_offsets (const gchar* filename, const gchar* text, int* result_length1);
static void _vala_array_add17 (gsize* * array, int* length, int* size, gsize value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean uint64_try_parse (const gchar* str, guint64* _result_) {
	guint64 _vala_result = 0ULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	guint64 _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoull (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static void _vala_array_add17 (gsize* * array, int* length, int* size, gsize value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gsize, *array, *size);
	}
	(*array)[(*length)++] = value;
}


gsize* games_grep_get_offsets (const gchar* filename, const gchar* text, int* result_length1) {
	gsize* result = NULL;
	gchar* working_dir;
	gchar* _tmp0_;
	gchar** args;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint args_length1;
	gint _args_size_;
	gchar** env;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint env_length1;
	gint _env_size_;
	gboolean success;
	gchar* output = NULL;
	gboolean _tmp20_;
	gsize* offsets;
	gsize* _tmp23_;
	gint offsets_length1;
	gint _offsets_size_;
	const gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gsize* _tmp41_;
	gint _tmp41__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_get_current_dir ();
	working_dir = _tmp0_;
	_tmp1_ = g_strdup ("grep");
	_tmp2_ = g_strdup ("--byte-offset");
	_tmp3_ = g_strdup ("--only-matching");
	_tmp4_ = g_strdup ("--text");
	_tmp5_ = text;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = filename;
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = g_new0 (gchar*, 6 + 1);
	_tmp9_[0] = _tmp1_;
	_tmp9_[1] = _tmp2_;
	_tmp9_[2] = _tmp3_;
	_tmp9_[3] = _tmp4_;
	_tmp9_[4] = _tmp6_;
	_tmp9_[5] = _tmp8_;
	args = _tmp9_;
	args_length1 = 6;
	_args_size_ = args_length1;
	_tmp11_ = _tmp10_ = g_get_environ ();
	env = _tmp11_;
	env_length1 = _vala_array_length (_tmp10_);
	_env_size_ = env_length1;
	success = FALSE;
	{
		gboolean _tmp12_;
		const gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar* _tmp16_ = NULL;
		gboolean _tmp17_;
		_tmp13_ = working_dir;
		_tmp14_ = args;
		_tmp14__length1 = args_length1;
		_tmp15_ = env;
		_tmp15__length1 = env_length1;
		_tmp17_ = g_spawn_sync (_tmp13_, _tmp14_, _tmp15_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp16_, NULL, NULL, &_inner_error_);
		_g_free0 (output);
		output = _tmp16_;
		_tmp12_ = _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch39_g_spawn_error;
			}
			_g_free0 (output);
			env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (working_dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		success = _tmp12_;
	}
	goto __finally39;
	__catch39_g_spawn_error:
	{
		GError* e = NULL;
		gsize* _tmp18_;
		gsize* _tmp19_;
		gint _tmp19__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = g_new0 (gsize, 0);
		_tmp19_ = _tmp18_;
		_tmp19__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp19__length1;
		}
		result = _tmp19_;
		_g_error_free0 (e);
		_g_free0 (output);
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (working_dir);
		return result;
	}
	__finally39:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (output);
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (working_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp20_ = success;
	if (!_tmp20_) {
		gsize* _tmp21_;
		gsize* _tmp22_;
		gint _tmp22__length1;
		_tmp21_ = g_new0 (gsize, 0);
		_tmp22_ = _tmp21_;
		_tmp22__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp22__length1;
		}
		result = _tmp22_;
		_g_free0 (output);
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (working_dir);
		return result;
	}
	_tmp23_ = g_new0 (gsize, 0);
	offsets = _tmp23_;
	offsets_length1 = 0;
	_offsets_size_ = offsets_length1;
	_tmp24_ = output;
	_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp26_;
		line_collection_length1 = _vala_array_length (_tmp25_);
		for (line_it = 0; line_it < _vala_array_length (_tmp25_); line_it = line_it + 1) {
			gchar* _tmp27_;
			gchar* line = NULL;
			_tmp27_ = g_strdup (line_collection[line_it]);
			line = _tmp27_;
			{
				gchar** splitted_line;
				const gchar* _tmp28_;
				gchar** _tmp29_;
				gchar** _tmp30_;
				gint splitted_line_length1;
				gint _splitted_line_size_;
				gchar** _tmp31_;
				gint _tmp31__length1;
				gchar** _tmp32_;
				gint _tmp32__length1;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				guint64 offset = 0ULL;
				gchar** _tmp35_;
				gint _tmp35__length1;
				const gchar* _tmp36_;
				guint64 _tmp37_ = 0ULL;
				gboolean _tmp38_;
				gsize* _tmp39_;
				gint _tmp39__length1;
				guint64 _tmp40_;
				_tmp28_ = line;
				_tmp30_ = _tmp29_ = g_strsplit (_tmp28_, ":", 0);
				splitted_line = _tmp30_;
				splitted_line_length1 = _vala_array_length (_tmp29_);
				_splitted_line_size_ = splitted_line_length1;
				_tmp31_ = splitted_line;
				_tmp31__length1 = splitted_line_length1;
				if (_tmp31__length1 != 2) {
					splitted_line = (_vala_array_free (splitted_line, splitted_line_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp32_ = splitted_line;
				_tmp32__length1 = splitted_line_length1;
				_tmp33_ = _tmp32_[1];
				_tmp34_ = text;
				if (g_strcmp0 (_tmp33_, _tmp34_) != 0) {
					splitted_line = (_vala_array_free (splitted_line, splitted_line_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp35_ = splitted_line;
				_tmp35__length1 = splitted_line_length1;
				_tmp36_ = _tmp35_[0];
				_tmp38_ = uint64_try_parse (_tmp36_, &_tmp37_);
				offset = _tmp37_;
				if (!_tmp38_) {
					splitted_line = (_vala_array_free (splitted_line, splitted_line_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp39_ = offsets;
				_tmp39__length1 = offsets_length1;
				_tmp40_ = offset;
				_vala_array_add17 (&offsets, &offsets_length1, &_offsets_size_, (gsize) _tmp40_);
				splitted_line = (_vala_array_free (splitted_line, splitted_line_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp41_ = offsets;
	_tmp41__length1 = offsets_length1;
	if (result_length1) {
		*result_length1 = _tmp41__length1;
	}
	result = _tmp41_;
	_g_free0 (output);
	env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (working_dir);
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



