/* gnome-klotski.c generated by valac 0.22.1, the Vala compiler
 * generated from gnome-klotski.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Puzzle Info */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <locale.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>


#define TYPE_LEVEL_INFO (level_info_get_type ())
typedef struct _LevelInfo LevelInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_KLOTSKI (klotski_get_type ())
#define KLOTSKI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KLOTSKI, Klotski))
#define KLOTSKI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KLOTSKI, KlotskiClass))
#define IS_KLOTSKI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KLOTSKI))
#define IS_KLOTSKI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KLOTSKI))
#define KLOTSKI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KLOTSKI, KlotskiClass))

typedef struct _Klotski Klotski;
typedef struct _KlotskiClass KlotskiClass;
typedef struct _KlotskiPrivate KlotskiPrivate;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _puzzle_unref0(var) ((var == NULL) ? NULL : (var = (puzzle_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_CELL_RENDERER_LEVEL (cell_renderer_level_get_type ())
#define CELL_RENDERER_LEVEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CELL_RENDERER_LEVEL, CellRendererLevel))
#define CELL_RENDERER_LEVEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CELL_RENDERER_LEVEL, CellRendererLevelClass))
#define IS_CELL_RENDERER_LEVEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CELL_RENDERER_LEVEL))
#define IS_CELL_RENDERER_LEVEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CELL_RENDERER_LEVEL))
#define CELL_RENDERER_LEVEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CELL_RENDERER_LEVEL, CellRendererLevelClass))

typedef struct _CellRendererLevel CellRendererLevel;
typedef struct _CellRendererLevelClass CellRendererLevelClass;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;
#define _history_entry_unref0(var) ((var == NULL) ? NULL : (var = (history_entry_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
typedef struct _CellRendererLevelPrivate CellRendererLevelPrivate;

struct _LevelInfo {
	gchar* name;
	gint group;
	gint width;
	gint height;
	gchar* data;
};

struct _Klotski {
	GtkApplication parent_instance;
	KlotskiPrivate * priv;
};

struct _KlotskiClass {
	GtkApplicationClass parent_class;
};

struct _KlotskiPrivate {
	GSettings* settings;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_fullscreen;
	gboolean is_maximized;
	GtkBox* puzzles_panel;
	GtkButton* next_button;
	GtkButton* prev_button;
	GSimpleAction* next_level_action;
	GSimpleAction* prev_level_action;
	PuzzleView* view;
	GtkToolButton* fullscreen_button;
	GtkLabel* messagewidget;
	GtkLabel* moves_label;
	Puzzle* puzzle;
	gint current_level;
	History* history;
	GtkTreeStore* puzzles;
	GtkTreeIter* puzzles_items;
	gint puzzles_items_length1;
	gint _puzzles_items_size_;
};

struct _Puzzle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GTypeClass parent_class;
	void (*finalize) (Puzzle *self);
};

struct _CellRendererLevel {
	GtkCellRenderer parent_instance;
	CellRendererLevelPrivate * priv;
};

struct _CellRendererLevelClass {
	GtkCellRendererClass parent_class;
};


static gpointer klotski_parent_class = NULL;
static gpointer cell_renderer_level_parent_class = NULL;

GType level_info_get_type (void) G_GNUC_CONST;
LevelInfo* level_info_dup (const LevelInfo* self);
void level_info_free (LevelInfo* self);
void level_info_copy (const LevelInfo* self, LevelInfo* dest);
void level_info_destroy (LevelInfo* self);
GType klotski_get_type (void) G_GNUC_CONST;
GType puzzle_view_get_type (void) G_GNUC_CONST;
gpointer puzzle_ref (gpointer instance);
void puzzle_unref (gpointer instance);
GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle (GValue* value, gpointer v_object);
void value_take_puzzle (GValue* value, gpointer v_object);
gpointer value_get_puzzle (const GValue* value);
GType puzzle_get_type (void) G_GNUC_CONST;
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
#define KLOTSKI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KLOTSKI, KlotskiPrivate))
enum  {
	KLOTSKI_DUMMY_PROPERTY
};
#define KLOTSKI_MINWIDTH 250
#define KLOTSKI_MINHEIGHT 250
#define KLOTSKI_SPACE_PADDING 5
#define KLOTSKI_KEY_LEVEL "level"
static void klotski_restart_level_cb (Klotski* self);
static void _klotski_restart_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_toggle_puzzles_cb (Klotski* self);
static void _klotski_toggle_puzzles_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_fullscreen_cb (Klotski* self);
static void _klotski_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_next_level_cb (Klotski* self);
static void _klotski_next_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_prev_level_cb (Klotski* self);
static void _klotski_prev_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_scores_cb (Klotski* self);
static void _klotski_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_help_cb (Klotski* self);
static void _klotski_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_about_cb (Klotski* self);
static void _klotski_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_quit_cb (Klotski* self);
static void _klotski_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Klotski* klotski_new (void);
Klotski* klotski_construct (GType object_type);
static void klotski_real_startup (GApplication* base);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_load (History* self);
static gboolean klotski_window_configure_event_cb (Klotski* self, GdkEventConfigure* event);
static gboolean _klotski_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean klotski_window_state_event_cb (Klotski* self, GdkEventWindowState* event);
static gboolean _klotski_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void klotski_render_puzzle_name (GtkCellLayout* cell_layout, GtkCellRendererText* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
CellRendererLevel* cell_renderer_level_new (void);
CellRendererLevel* cell_renderer_level_construct (GType object_type);
GType cell_renderer_level_get_type (void) G_GNUC_CONST;
static void klotski_level_cb (Klotski* self, GtkTreePath* path, GtkTreeViewColumn* column);
static void _klotski_level_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void _klotski_prev_level_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _klotski_next_level_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void klotski_load_solved_state (Klotski* self);
static void klotski_new_game (Klotski* self, gint requested_level);
gpointer history_entry_ref (gpointer instance);
void history_entry_unref (gpointer instance);
GParamSpec* param_spec_history_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history_entry (GValue* value, gpointer v_object);
void value_take_history_entry (GValue* value, gpointer v_object);
gpointer value_get_history_entry (const GValue* value);
GType history_entry_get_type (void) G_GNUC_CONST;
static gint klotski_show_scores (Klotski* self, HistoryEntry* selected_entry, gboolean show_close);
static void klotski_game_score (Klotski* self);
static gchar* klotski_get_level_key (Klotski* self, gint level_number);
HistoryEntry* history_entry_new (GDateTime* date, guint level, guint moves);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, guint level, guint moves);
void history_add (History* self, HistoryEntry* entry);
void history_save (History* self);
GType score_dialog_get_type (void) G_GNUC_CONST;
ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_close);
ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_close);
static void klotski_update_menu_state (Klotski* self);
static void klotski_update_moves_label (Klotski* self);
Puzzle* puzzle_new (gint width, gint height, const gchar* data);
Puzzle* puzzle_construct (GType object_type, gint width, gint height, const gchar* data);
static void klotski_puzzle_moved_cb (Klotski* self);
static void _klotski_puzzle_moved_cb_puzzle_moved (Puzzle* _sender, gpointer self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
gboolean puzzle_game_over (Puzzle* self);
static void klotski_real_shutdown (GApplication* base);
static void klotski_real_activate (GApplication* base);
gint klotski_main (gchar** args, int args_length1);
static void klotski_finalize (GObject* obj);
enum  {
	CELL_RENDERER_LEVEL_DUMMY_PROPERTY
};
#define CELL_RENDERER_LEVEL_icon_size 10
static void cell_renderer_level_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height);
static void cell_renderer_level_real_render (GtkCellRenderer* base, cairo_t* ctx, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags);

const LevelInfo KLOTSKI_level[28] = {{"Only 18 Steps", 0, 6, 9, "######" "#a**b#" "#m**n#" "#cdef#" "#ghij#" "#k  l#" "##--##" "    .." "    .."}, {"Daisy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#zghi#" "#j  k#" "##--##" "    .." "    .."}, {"Violet", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghi#" "#j  k#" "##--##" "    .." "    .."}, {"Poppy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#fghi#" "#j  k#" "##--##" "    .." "    .."}, {"Pansy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghf#" "#i  j#" "##--##" "    .." "    .."}, {"Snowdrop", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfgh#" "#i  j#" "##--##" "    .." "    .."}, {"Red Donkey", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfge#" "#h  i#" "##--##" "    .." "    .."}, {"Trail", 0, 6, 9, "######" "#a**c#" "#a**c#" "#eddg#" "#hffj#" "# ii #" "##--##" "    .." "    .."}, {"Ambush", 0, 6, 9, "######" "#a**c#" "#d**e#" "#dffe#" "#ghhi#" "# jj #" "##--##" "    .." "    .."}, {"Agatka", 1, 7, 7, "..     " ".      " "#####--" "#**aab-" "#*ccde#" "#fgh  #" "#######"}, {"Success", 1, 9, 6, "#######  " "#**bbc#  " "#defgh#  " "#ijkgh-  " "#llk  #  " "#######.."}, {"Bone", 1, 6, 9, "######" "#abc*#" "# dd*#" "# ee*#" "# fgh#" "##-###" "     ." "     ." "     ."}, {"Fortune", 1, 7, 10, "     .." "     . " "####-. " "#ab  - " "#ccd # " "#ccd # " "#**ee# " "#*fgh# " "#*iih# " "###### "}, {"Fool", 1, 10, 6, "  ########" "  -aabc  #" "  #aabdef#" "  #ijggef#" "  #klhh**#" "..########"}, {"Solomon", 1, 7, 9, " .     " "..     " "#--####" "#  aab#" "# cdfb#" "#hcefg#" "#hijk*#" "#hll**#" "#######"}, {"Cleopatra", 1, 6, 8, "######" "#abcd#" "#**ee#" "#f*g #" "#fh i-" "####--" "    .." "     ."}, {"Shark", 1, 11, 8, "########   " "#nrr s #   " "#n*op q#   " "#***jml#   " "#hhijkl#   " "#ffcddg-   " "#abcdde- . " "########..."}, {"Rome", 1, 8, 8, "########" "#abcc**#" "#ddeef*#" "#ddghfi#" "#   jki#" "#--#####" " ..     " "  .     "}, {"Pennant Puzzle", 1, 6, 9, "######" "#**aa#" "#**bb#" "#de  #" "#fghh#" "#fgii#" "#--###" "    .." "    .."}, {"Ithaca", 2, 19, 19, ".aaaaaaaaaaaaaaaaab" "..  cddeffffffffffb" " .. cddeffffffffffb" "  . cddeffffffffffb" "ggg-############hhb" "ggg-  ABCDEFFGH#hhb" "ggg-       FFIJ#hhb" "ggg#       KLMJ#hhb" "ggg#NNNNOOOPQMJ#hhb" "ggg#NNNNOOOP*RS#hhb" "ggg#TTTTTUVW**X#hhb" "ggg#YZ12222W3**#hhb" "ggg#YZ12222W34*#iib" "jjj#YZ155555367#klb" "jjj#############mmb" "jjjnooooooooooppppb" "jjjqooooooooooppppb" "       rrrssssppppb" "ttttttuvvvvvvvwwwwx"}, {"Pelopones", 2, 9, 8, "#########" "#abbb***#" "#abbb*c*#" "#adeefgg#" "#  eefhh#" "#... ihh#" "#. . ihh#" "#########"}, {"Transeuropa", 2, 15, 8, "    ###########" "    -AAAAABBCC#" "    -   DEFGHI#" "    #   DEFGJI#" "    #   KEFGLI#" "    #   KEFG*I#" "  . #   MM****#" "....###########"}, {"Lodzianka", 2, 9, 7, "#########" "#**abbcc#" "#**abbdd#" "#eefgh  #" "#iiijk..#" "#iiijk..#" "#########"}, {"Polonaise", 2, 7, 7, "#######" "#aab**#" "#aabc*#" "#defgg#" "#..fhh#" "# .ihh#" "#######"}, {"Baltic Sea", 2, 6, 8, "######" "#.abc#" "#.dec#" "#fggc#" "#fhhi#" "#fjk*#" "#flk*#" "######"}, {"American Pie", 2, 10, 12, "##########" "#a*bcdefg#" "#**bhhhhg#" "#*iijjkkg#" "#liimnoop#" "#qiirrr  #" "#qstuvv  #" "#qwwxvv  #" "######--##" "         ." "        .." "        . "}, {"Traffic Jam", 2, 10, 7, "########  " "#** ffi#  " "#** fgh#  " "#aacehh#  " "#bbdjlm-  " "#bddklm-.." "########.."}, {"Sunshine", 2, 17, 22, "       ...       " "      .. ..      " "      .   .      " "      .. ..      " "       ...       " "######-----######" "#hh0iilltmmpp;qq#" "#hh,iill mmpp:qq#" "#2y{45v s w89x/z#" "#jj6kkaa nnoo<rr#" "#jj7kkaaunnoo>rr#" "#33333TTJWW11111#" "#33333TTJWW11111#" "#33333GG HH11111#" "#33333YYIgg11111#" "#33333YYIgg11111#" "#ddFeeA***BffOZZ#" "#ddFee** **ffOZZ#" "#MMKQQ*   *PPS^^#" "#VVLXX** **bbRcc#" "#VVLXXD***EbbRcc#" "#################"}};
static const GActionEntry KLOTSKI_action_entries[9] = {{"new-game", _klotski_restart_level_cb_gsimple_action_activate_callback}, {"show-puzzles", _klotski_toggle_puzzles_cb_gsimple_action_activate_callback}, {"fullscreen", _klotski_fullscreen_cb_gsimple_action_activate_callback}, {"next-level", _klotski_next_level_cb_gsimple_action_activate_callback}, {"prev-level", _klotski_prev_level_cb_gsimple_action_activate_callback}, {"scores", _klotski_scores_cb_gsimple_action_activate_callback}, {"help", _klotski_help_cb_gsimple_action_activate_callback}, {"about", _klotski_about_cb_gsimple_action_activate_callback}, {"quit", _klotski_quit_cb_gsimple_action_activate_callback}};

void level_info_copy (const LevelInfo* self, LevelInfo* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).group;
	(*dest).group = _tmp2_;
	_tmp3_ = (*self).width;
	(*dest).width = _tmp3_;
	_tmp4_ = (*self).height;
	(*dest).height = _tmp4_;
	_tmp5_ = (*self).data;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).data);
	(*dest).data = _tmp6_;
}


void level_info_destroy (LevelInfo* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).data);
}


LevelInfo* level_info_dup (const LevelInfo* self) {
	LevelInfo* dup;
	dup = g_new0 (LevelInfo, 1);
	level_info_copy (self, dup);
	return dup;
}


void level_info_free (LevelInfo* self) {
	level_info_destroy (self);
	g_free (self);
}


GType level_info_get_type (void) {
	static volatile gsize level_info_type_id__volatile = 0;
	if (g_once_init_enter (&level_info_type_id__volatile)) {
		GType level_info_type_id;
		level_info_type_id = g_boxed_type_register_static ("LevelInfo", (GBoxedCopyFunc) level_info_dup, (GBoxedFreeFunc) level_info_free);
		g_once_init_leave (&level_info_type_id__volatile, level_info_type_id);
	}
	return level_info_type_id__volatile;
}


static void _klotski_restart_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_restart_level_cb (self);
}


static void _klotski_toggle_puzzles_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_toggle_puzzles_cb (self);
}


static void _klotski_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_fullscreen_cb (self);
}


static void _klotski_next_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_next_level_cb (self);
}


static void _klotski_prev_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_prev_level_cb (self);
}


static void _klotski_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_scores_cb (self);
}


static void _klotski_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_help_cb (self);
}


static void _klotski_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_about_cb (self);
}


static void _klotski_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_quit_cb (self);
}


Klotski* klotski_construct (GType object_type) {
	Klotski * self = NULL;
	self = (Klotski*) g_object_new (object_type, "application-id", "org.gnome.klotski", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Klotski* klotski_new (void) {
	return klotski_construct (TYPE_KLOTSKI);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _klotski_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = klotski_window_configure_event_cb (self, event);
	return result;
}


static gboolean _klotski_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = klotski_window_state_event_cb (self, event);
	return result;
}


static void _klotski_level_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	klotski_level_cb (self, path, column);
}


static void _klotski_prev_level_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	klotski_prev_level_cb (self);
}


static void _klotski_next_level_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	klotski_next_level_cb (self);
}


static void klotski_real_startup (GApplication* base) {
	Klotski * self;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* histfile = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	History* _tmp13_ = NULL;
	History* _tmp14_ = NULL;
	GtkApplicationWindow* _tmp15_ = NULL;
	GtkWindow* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkWindow* _tmp18_ = NULL;
	GtkWindow* _tmp19_ = NULL;
	gint ww = 0;
	GSettings* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint wh = 0;
	GSettings* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GtkWindow* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GSettings* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	GtkBox* vbox = NULL;
	GtkBox* _tmp35_ = NULL;
	GtkWindow* _tmp36_ = NULL;
	gchar* builder_str = NULL;
	gchar* _tmp37_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp38_ = NULL;
	GObject* _tmp41_ = NULL;
	GtkBox* status_box = NULL;
	GtkBox* _tmp42_ = NULL;
	GtkBox* _tmp43_ = NULL;
	GtkLabel* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GtkBox* _tmp46_ = NULL;
	GtkLabel* _tmp47_ = NULL;
	GtkLabel* _tmp48_ = NULL;
	GtkLabel* _tmp49_ = NULL;
	GtkBox* _tmp50_ = NULL;
	GtkLabel* _tmp51_ = NULL;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp52_ = NULL;
	GtkToolbar* _tmp53_ = NULL;
	GtkToolbar* _tmp54_ = NULL;
	GtkToolbar* _tmp55_ = NULL;
	GtkStyleContext* _tmp56_ = NULL;
	GtkToolButton* new_game_button = NULL;
	const gchar* _tmp57_ = NULL;
	GtkToolButton* _tmp58_ = NULL;
	GtkToolButton* _tmp59_ = NULL;
	GtkToolButton* _tmp60_ = NULL;
	GtkToolButton* _tmp61_ = NULL;
	GtkToolButton* _tmp62_ = NULL;
	GtkToolButton* _tmp63_ = NULL;
	GtkToolbar* _tmp64_ = NULL;
	GtkToolButton* _tmp65_ = NULL;
	GtkToggleToolButton* puzzles_button = NULL;
	GtkToggleToolButton* _tmp66_ = NULL;
	GtkToggleToolButton* _tmp67_ = NULL;
	GtkToggleToolButton* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	GtkToggleToolButton* _tmp70_ = NULL;
	GtkToggleToolButton* _tmp71_ = NULL;
	GtkToggleToolButton* _tmp72_ = NULL;
	GtkToolbar* _tmp73_ = NULL;
	GtkToggleToolButton* _tmp74_ = NULL;
	const gchar* _tmp75_ = NULL;
	GtkToolButton* _tmp76_ = NULL;
	GtkToolButton* _tmp77_ = NULL;
	GtkToolButton* _tmp78_ = NULL;
	GtkToolButton* _tmp79_ = NULL;
	GtkToolButton* _tmp80_ = NULL;
	GtkToolbar* _tmp81_ = NULL;
	GtkToolButton* _tmp82_ = NULL;
	GtkAlignment* status_alignment = NULL;
	GtkAlignment* _tmp83_ = NULL;
	GtkAlignment* _tmp84_ = NULL;
	GtkBox* _tmp85_ = NULL;
	GtkAlignment* _tmp86_ = NULL;
	GtkToolItem* status_item = NULL;
	GtkToolItem* _tmp87_ = NULL;
	GtkToolItem* _tmp88_ = NULL;
	GtkToolItem* _tmp89_ = NULL;
	GtkAlignment* _tmp90_ = NULL;
	GtkToolItem* _tmp91_ = NULL;
	GtkToolbar* _tmp92_ = NULL;
	GtkToolItem* _tmp93_ = NULL;
	GtkToolbar* _tmp94_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp95_ = NULL;
	GtkBox* _tmp96_ = NULL;
	GtkTreeStore* _tmp97_ = NULL;
	GtkTreeIter huarong_item = {0};
	GtkTreeStore* _tmp98_ = NULL;
	GtkTreeIter _tmp99_ = {0};
	GtkTreeStore* _tmp100_ = NULL;
	GtkTreeIter _tmp101_ = {0};
	GtkTreeIter challenge_item = {0};
	GtkTreeStore* _tmp102_ = NULL;
	GtkTreeIter _tmp103_ = {0};
	GtkTreeStore* _tmp104_ = NULL;
	GtkTreeIter _tmp105_ = {0};
	GtkTreeIter skill_item = {0};
	GtkTreeStore* _tmp106_ = NULL;
	GtkTreeIter _tmp107_ = {0};
	GtkTreeStore* _tmp108_ = NULL;
	GtkTreeIter _tmp109_ = {0};
	GtkTreeIter* _tmp110_ = NULL;
	GtkBox* _tmp160_ = NULL;
	GtkBox* _tmp161_ = NULL;
	GtkTreeView* puzzles_view = NULL;
	GtkTreeStore* _tmp162_ = NULL;
	GtkTreeView* _tmp163_ = NULL;
	GtkCellRendererText* cell = NULL;
	GtkCellRendererText* _tmp164_ = NULL;
	GtkTreeViewColumn* col = NULL;
	GtkTreeViewColumn* _tmp165_ = NULL;
	Klotski* _tmp166_ = NULL;
	CellRendererLevel* _tmp167_ = NULL;
	CellRendererLevel* _tmp168_ = NULL;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp169_ = NULL;
	GtkBox* _tmp170_ = NULL;
	GtkBox* bbox = NULL;
	GtkBox* _tmp171_ = NULL;
	const gchar* _tmp172_ = NULL;
	GtkButton* _tmp173_ = NULL;
	GtkButton* _tmp174_ = NULL;
	GtkButton* _tmp175_ = NULL;
	gint _tmp176_ = 0;
	GtkButton* _tmp177_ = NULL;
	GtkButton* _tmp178_ = NULL;
	const gchar* _tmp179_ = NULL;
	GtkButton* _tmp180_ = NULL;
	GtkButton* _tmp181_ = NULL;
	GtkButton* _tmp182_ = NULL;
	gint _tmp183_ = 0;
	GtkButton* _tmp184_ = NULL;
	GtkButton* _tmp185_ = NULL;
	GtkBox* _tmp186_ = NULL;
	GtkBox* _tmp187_ = NULL;
	GtkBox* _tmp188_ = NULL;
	PuzzleView* _tmp189_ = NULL;
	PuzzleView* _tmp190_ = NULL;
	PuzzleView* _tmp191_ = NULL;
	GtkBox* _tmp192_ = NULL;
	PuzzleView* _tmp193_ = NULL;
	GtkBox* _tmp194_ = NULL;
	GtkSeparator* _tmp195_ = NULL;
	GtkSeparator* _tmp196_ = NULL;
	gint startup_level = 0;
	GSettings* _tmp197_ = NULL;
	gint _tmp198_ = 0;
	GError * _inner_error_ = NULL;
	self = (Klotski*) base;
	G_APPLICATION_CLASS (klotski_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = _ ("Klotski");
	g_set_application_name (_tmp0_);
	_tmp1_ = g_settings_new ("org.gnome.klotski");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	gtk_window_set_default_icon_name ("gnome-klotski");
	g_action_map_add_action_entries ((GActionMap*) self, KLOTSKI_action_entries, G_N_ELEMENTS (KLOTSKI_action_entries), self);
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "next-level");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	_g_object_unref0 (self->priv->next_level_action);
	self->priv->next_level_action = _tmp3_;
	_tmp4_ = self->priv->next_level_action;
	_tmp5_ = self->priv->current_level;
	g_simple_action_set_enabled (_tmp4_, _tmp5_ < (G_N_ELEMENTS (KLOTSKI_level) - 1));
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) self, "prev-level");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	_g_object_unref0 (self->priv->prev_level_action);
	self->priv->prev_level_action = _tmp7_;
	_tmp8_ = self->priv->prev_level_action;
	_tmp9_ = self->priv->current_level;
	g_simple_action_set_enabled (_tmp8_, _tmp9_ > 0);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>n", "app.new-game", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>q", "app.quit", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "F1", "app.help", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "F11", "app.fullscreen", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "Page_Up", "app.next-level", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "Page_Down", "app.prev-level", NULL);
	_tmp10_ = g_get_user_data_dir ();
	_tmp11_ = g_build_filename (_tmp10_, "gnome-klotski", "history", NULL);
	histfile = _tmp11_;
	_tmp12_ = histfile;
	_tmp13_ = history_new (_tmp12_);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp13_;
	_tmp14_ = self->priv->history;
	history_load (_tmp14_);
	_tmp15_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = (GtkWindow*) _tmp15_;
	_tmp16_ = self->priv->window;
	_tmp17_ = _ ("Klotski");
	gtk_window_set_title (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp18_, "configure-event", (GCallback) _klotski_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp19_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp19_, "window-state-event", (GCallback) _klotski_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp20_ = self->priv->settings;
	_tmp21_ = g_settings_get_int (_tmp20_, "window-width");
	_tmp22_ = MAX (_tmp21_, KLOTSKI_MINWIDTH);
	ww = _tmp22_;
	_tmp23_ = self->priv->settings;
	_tmp24_ = g_settings_get_int (_tmp23_, "window-height");
	_tmp25_ = MAX (_tmp24_, KLOTSKI_MINHEIGHT);
	wh = _tmp25_;
	_tmp26_ = self->priv->window;
	_tmp27_ = ww;
	_tmp28_ = wh;
	gtk_window_set_default_size (_tmp26_, _tmp27_, _tmp28_);
	_tmp29_ = self->priv->settings;
	_tmp30_ = g_settings_get_boolean (_tmp29_, "window-is-fullscreen");
	if (_tmp30_) {
		GtkWindow* _tmp31_ = NULL;
		_tmp31_ = self->priv->window;
		gtk_window_fullscreen (_tmp31_);
	} else {
		GSettings* _tmp32_ = NULL;
		gboolean _tmp33_ = FALSE;
		_tmp32_ = self->priv->settings;
		_tmp33_ = g_settings_get_boolean (_tmp32_, "window-is-maximized");
		if (_tmp33_) {
			GtkWindow* _tmp34_ = NULL;
			_tmp34_ = self->priv->window;
			gtk_window_maximize (_tmp34_);
		}
	}
	_tmp35_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp35_);
	vbox = _tmp35_;
	_tmp36_ = self->priv->window;
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) vbox);
	gtk_widget_show ((GtkWidget*) vbox);
	_tmp37_ = g_strdup ("<interface>" "\n" \
"               <menu id='app-menu'>\n" \
"                  <section>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_New " \
"Game</attribute>\n" \
"                      <attribute name='action'>app.new-game</attribute" \
">\n" \
"                   </item>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Scor" \
"es</attribute>\n" \
"                      <attribute name='action'>app.scores</attribute>\n" \
"                   </item>\n" \
"                  </section>\n" \
"                  <section>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Help" \
"</attribute>\n" \
"                      <attribute name='action'>app.help</attribute>\n" \
"                   </item>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Abou" \
"t</attribute>\n" \
"                      <attribute name='action'>app.about</attribute>\n" \
"                   </item>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Quit" \
"</attribute>\n" \
"                      <attribute name='action'>app.quit</attribute>\n" \
"                   </item>\n" \
"                  </section>\n" \
"                </menu>\n" \
"               </interface>\n" \
"               ");
	builder_str = _tmp37_;
	_tmp38_ = gtk_builder_new ();
	builder = _tmp38_;
	{
		gtk_builder_add_from_string (builder, builder_str, (gsize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp39_ = stderr;
		fprintf (_tmp39_, "%s\n", "Error in gnome-klotski.vala function startup() - builder.add_from_stri" \
"ng failed");
		_tmp40_ = e->message;
		g_error ("gnome-klotski.vala:542: %s", _tmp40_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		_g_free0 (builder_str);
		_g_object_unref0 (vbox);
		_g_free0 (histfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp41_ = gtk_builder_get_object (builder, "app-menu");
	gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp41_) : NULL);
	_tmp42_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp42_);
	status_box = _tmp42_;
	_tmp43_ = status_box;
	gtk_widget_show ((GtkWidget*) _tmp43_);
	_tmp44_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->messagewidget);
	self->priv->messagewidget = _tmp44_;
	_tmp45_ = self->priv->messagewidget;
	gtk_widget_show ((GtkWidget*) _tmp45_);
	_tmp46_ = status_box;
	_tmp47_ = self->priv->messagewidget;
	gtk_box_pack_start (_tmp46_, (GtkWidget*) _tmp47_, FALSE, FALSE, (guint) 0);
	_tmp48_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->moves_label);
	self->priv->moves_label = _tmp48_;
	_tmp49_ = self->priv->moves_label;
	gtk_widget_show ((GtkWidget*) _tmp49_);
	_tmp50_ = status_box;
	_tmp51_ = self->priv->moves_label;
	gtk_box_pack_start (_tmp50_, (GtkWidget*) _tmp51_, FALSE, FALSE, (guint) 0);
	_tmp52_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp52_);
	toolbar = _tmp52_;
	_tmp53_ = toolbar;
	gtk_widget_show ((GtkWidget*) _tmp53_);
	_tmp54_ = toolbar;
	gtk_toolbar_set_show_arrow (_tmp54_, FALSE);
	_tmp55_ = toolbar;
	_tmp56_ = gtk_widget_get_style_context ((GtkWidget*) _tmp55_);
	gtk_style_context_add_class (_tmp56_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	_tmp57_ = _ ("_New");
	_tmp58_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp57_);
	g_object_ref_sink (_tmp58_);
	new_game_button = _tmp58_;
	_tmp59_ = new_game_button;
	gtk_tool_button_set_icon_name (_tmp59_, "document-new");
	_tmp60_ = new_game_button;
	gtk_tool_button_set_use_underline (_tmp60_, TRUE);
	_tmp61_ = new_game_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp61_, "app.new-game");
	_tmp62_ = new_game_button;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp62_, TRUE);
	_tmp63_ = new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp63_);
	_tmp64_ = toolbar;
	_tmp65_ = new_game_button;
	gtk_toolbar_insert (_tmp64_, (GtkToolItem*) _tmp65_, -1);
	_tmp66_ = (GtkToggleToolButton*) gtk_toggle_tool_button_new ();
	g_object_ref_sink (_tmp66_);
	puzzles_button = _tmp66_;
	_tmp67_ = puzzles_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp67_, "app.show-puzzles");
	_tmp68_ = puzzles_button;
	_tmp69_ = _ ("_Puzzles");
	gtk_tool_button_set_label ((GtkToolButton*) _tmp68_, _tmp69_);
	_tmp70_ = puzzles_button;
	gtk_tool_button_set_use_underline ((GtkToolButton*) _tmp70_, TRUE);
	_tmp71_ = puzzles_button;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp71_, TRUE);
	_tmp72_ = puzzles_button;
	gtk_widget_show ((GtkWidget*) _tmp72_);
	_tmp73_ = toolbar;
	_tmp74_ = puzzles_button;
	gtk_toolbar_insert (_tmp73_, (GtkToolItem*) _tmp74_, -1);
	_tmp75_ = _ ("_Fullscreen");
	_tmp76_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp75_);
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (self->priv->fullscreen_button);
	self->priv->fullscreen_button = _tmp76_;
	_tmp77_ = self->priv->fullscreen_button;
	gtk_tool_button_set_icon_name (_tmp77_, "view-fullscreen");
	_tmp78_ = self->priv->fullscreen_button;
	gtk_tool_button_set_use_underline (_tmp78_, TRUE);
	_tmp79_ = self->priv->fullscreen_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp79_, "app.fullscreen");
	_tmp80_ = self->priv->fullscreen_button;
	gtk_widget_show ((GtkWidget*) _tmp80_);
	_tmp81_ = toolbar;
	_tmp82_ = self->priv->fullscreen_button;
	gtk_toolbar_insert (_tmp81_, (GtkToolItem*) _tmp82_, -1);
	_tmp83_ = (GtkAlignment*) gtk_alignment_new (1.0f, 0.5f, 0.0f, 0.0f);
	g_object_ref_sink (_tmp83_);
	status_alignment = _tmp83_;
	_tmp84_ = status_alignment;
	_tmp85_ = status_box;
	gtk_container_add ((GtkContainer*) _tmp84_, (GtkWidget*) _tmp85_);
	_tmp86_ = status_alignment;
	gtk_widget_show ((GtkWidget*) _tmp86_);
	_tmp87_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp87_);
	status_item = _tmp87_;
	_tmp88_ = status_item;
	gtk_tool_item_set_expand (_tmp88_, TRUE);
	_tmp89_ = status_item;
	_tmp90_ = status_alignment;
	gtk_container_add ((GtkContainer*) _tmp89_, (GtkWidget*) _tmp90_);
	_tmp91_ = status_item;
	gtk_widget_show ((GtkWidget*) _tmp91_);
	_tmp92_ = toolbar;
	_tmp93_ = status_item;
	gtk_toolbar_insert (_tmp92_, _tmp93_, -1);
	_tmp94_ = toolbar;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp94_, FALSE, FALSE, (guint) 0);
	_tmp95_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp95_);
	hbox = _tmp95_;
	_tmp96_ = hbox;
	gtk_widget_show ((GtkWidget*) _tmp96_);
	_tmp97_ = gtk_tree_store_new (3, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT);
	_g_object_unref0 (self->priv->puzzles);
	self->priv->puzzles = _tmp97_;
	_tmp98_ = self->priv->puzzles;
	gtk_tree_store_append (_tmp98_, &_tmp99_, NULL);
	huarong_item = _tmp99_;
	_tmp100_ = self->priv->puzzles;
	_tmp101_ = huarong_item;
	gtk_tree_store_set (_tmp100_, &_tmp101_, 0, "HuaRong Trail", 2, -1, -1, -1);
	_tmp102_ = self->priv->puzzles;
	gtk_tree_store_append (_tmp102_, &_tmp103_, NULL);
	challenge_item = _tmp103_;
	_tmp104_ = self->priv->puzzles;
	_tmp105_ = challenge_item;
	gtk_tree_store_set (_tmp104_, &_tmp105_, 0, "Challenge Pack", 2, -1, -1, -1);
	_tmp106_ = self->priv->puzzles;
	gtk_tree_store_append (_tmp106_, &_tmp107_, NULL);
	skill_item = _tmp107_;
	_tmp108_ = self->priv->puzzles;
	_tmp109_ = skill_item;
	gtk_tree_store_set (_tmp108_, &_tmp109_, 0, "Skill Pack", 2, -1, -1, -1);
	_tmp110_ = g_new0 (GtkTreeIter, G_N_ELEMENTS (KLOTSKI_level));
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
	self->priv->puzzles_items = _tmp110_;
	self->priv->puzzles_items_length1 = G_N_ELEMENTS (KLOTSKI_level);
	self->priv->_puzzles_items_size_ = self->priv->puzzles_items_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp111_ = FALSE;
			_tmp111_ = TRUE;
			while (TRUE) {
				gboolean _tmp112_ = FALSE;
				gint _tmp114_ = 0;
				gint _tmp115_ = 0;
				LevelInfo _tmp116_ = {0};
				gint _tmp117_ = 0;
				_tmp112_ = _tmp111_;
				if (!_tmp112_) {
					gint _tmp113_ = 0;
					_tmp113_ = i;
					i = _tmp113_ + 1;
				}
				_tmp111_ = FALSE;
				_tmp114_ = i;
				if (!(_tmp114_ < G_N_ELEMENTS (KLOTSKI_level))) {
					break;
				}
				_tmp115_ = i;
				_tmp116_ = KLOTSKI_level[_tmp115_];
				_tmp117_ = _tmp116_.group;
				switch (_tmp117_) {
					case 0:
					{
						GtkTreeStore* _tmp118_ = NULL;
						GtkTreeIter* _tmp119_ = NULL;
						gint _tmp119__length1 = 0;
						gint _tmp120_ = 0;
						GtkTreeIter _tmp121_ = {0};
						GtkTreeIter _tmp122_ = {0};
						GtkTreeStore* _tmp123_ = NULL;
						GtkTreeIter* _tmp124_ = NULL;
						gint _tmp124__length1 = 0;
						gint _tmp125_ = 0;
						GtkTreeIter _tmp126_ = {0};
						gint _tmp127_ = 0;
						LevelInfo _tmp128_ = {0};
						const gchar* _tmp129_ = NULL;
						const gchar* _tmp130_ = NULL;
						gint _tmp131_ = 0;
						_tmp118_ = self->priv->puzzles;
						_tmp119_ = self->priv->puzzles_items;
						_tmp119__length1 = self->priv->puzzles_items_length1;
						_tmp120_ = i;
						_tmp121_ = huarong_item;
						gtk_tree_store_append (_tmp118_, &_tmp122_, &_tmp121_);
						_tmp119_[_tmp120_] = _tmp122_;
						_tmp123_ = self->priv->puzzles;
						_tmp124_ = self->priv->puzzles_items;
						_tmp124__length1 = self->priv->puzzles_items_length1;
						_tmp125_ = i;
						_tmp126_ = _tmp124_[_tmp125_];
						_tmp127_ = i;
						_tmp128_ = KLOTSKI_level[_tmp127_];
						_tmp129_ = _tmp128_.name;
						_tmp130_ = _ (_tmp129_);
						_tmp131_ = i;
						gtk_tree_store_set (_tmp123_, &_tmp126_, 0, _tmp130_, 1, FALSE, 2, _tmp131_, -1, -1);
						break;
					}
					case 1:
					{
						GtkTreeStore* _tmp132_ = NULL;
						GtkTreeIter* _tmp133_ = NULL;
						gint _tmp133__length1 = 0;
						gint _tmp134_ = 0;
						GtkTreeIter _tmp135_ = {0};
						GtkTreeIter _tmp136_ = {0};
						GtkTreeStore* _tmp137_ = NULL;
						GtkTreeIter* _tmp138_ = NULL;
						gint _tmp138__length1 = 0;
						gint _tmp139_ = 0;
						GtkTreeIter _tmp140_ = {0};
						gint _tmp141_ = 0;
						LevelInfo _tmp142_ = {0};
						const gchar* _tmp143_ = NULL;
						const gchar* _tmp144_ = NULL;
						gint _tmp145_ = 0;
						_tmp132_ = self->priv->puzzles;
						_tmp133_ = self->priv->puzzles_items;
						_tmp133__length1 = self->priv->puzzles_items_length1;
						_tmp134_ = i;
						_tmp135_ = challenge_item;
						gtk_tree_store_append (_tmp132_, &_tmp136_, &_tmp135_);
						_tmp133_[_tmp134_] = _tmp136_;
						_tmp137_ = self->priv->puzzles;
						_tmp138_ = self->priv->puzzles_items;
						_tmp138__length1 = self->priv->puzzles_items_length1;
						_tmp139_ = i;
						_tmp140_ = _tmp138_[_tmp139_];
						_tmp141_ = i;
						_tmp142_ = KLOTSKI_level[_tmp141_];
						_tmp143_ = _tmp142_.name;
						_tmp144_ = _ (_tmp143_);
						_tmp145_ = i;
						gtk_tree_store_set (_tmp137_, &_tmp140_, 0, _tmp144_, 1, FALSE, 2, _tmp145_, -1, -1);
						break;
					}
					case 2:
					{
						GtkTreeStore* _tmp146_ = NULL;
						GtkTreeIter* _tmp147_ = NULL;
						gint _tmp147__length1 = 0;
						gint _tmp148_ = 0;
						GtkTreeIter _tmp149_ = {0};
						GtkTreeIter _tmp150_ = {0};
						GtkTreeStore* _tmp151_ = NULL;
						GtkTreeIter* _tmp152_ = NULL;
						gint _tmp152__length1 = 0;
						gint _tmp153_ = 0;
						GtkTreeIter _tmp154_ = {0};
						gint _tmp155_ = 0;
						LevelInfo _tmp156_ = {0};
						const gchar* _tmp157_ = NULL;
						const gchar* _tmp158_ = NULL;
						gint _tmp159_ = 0;
						_tmp146_ = self->priv->puzzles;
						_tmp147_ = self->priv->puzzles_items;
						_tmp147__length1 = self->priv->puzzles_items_length1;
						_tmp148_ = i;
						_tmp149_ = skill_item;
						gtk_tree_store_append (_tmp146_, &_tmp150_, &_tmp149_);
						_tmp147_[_tmp148_] = _tmp150_;
						_tmp151_ = self->priv->puzzles;
						_tmp152_ = self->priv->puzzles_items;
						_tmp152__length1 = self->priv->puzzles_items_length1;
						_tmp153_ = i;
						_tmp154_ = _tmp152_[_tmp153_];
						_tmp155_ = i;
						_tmp156_ = KLOTSKI_level[_tmp155_];
						_tmp157_ = _tmp156_.name;
						_tmp158_ = _ (_tmp157_);
						_tmp159_ = i;
						gtk_tree_store_set (_tmp151_, &_tmp154_, 0, _tmp158_, 1, FALSE, 2, _tmp159_, -1, -1);
						break;
					}
					default:
					break;
				}
			}
		}
	}
	_tmp160_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp160_);
	_g_object_unref0 (self->priv->puzzles_panel);
	self->priv->puzzles_panel = _tmp160_;
	_tmp161_ = self->priv->puzzles_panel;
	gtk_widget_set_visible ((GtkWidget*) _tmp161_, FALSE);
	_tmp162_ = self->priv->puzzles;
	_tmp163_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp162_);
	g_object_ref_sink (_tmp163_);
	puzzles_view = _tmp163_;
	gtk_tree_view_set_headers_visible (puzzles_view, FALSE);
	_tmp164_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp164_);
	cell = _tmp164_;
	_tmp165_ = gtk_tree_view_column_new_with_attributes ("Puzzle", (GtkCellRenderer*) cell, "text", 0, NULL, NULL);
	g_object_ref_sink (_tmp165_);
	col = _tmp165_;
	_tmp166_ = _g_object_ref0 (self);
	g_object_set_data_full ((GObject*) col, "app", _tmp166_, g_object_unref);
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) col, (GtkCellRenderer*) cell, (GtkCellLayoutDataFunc) klotski_render_puzzle_name, NULL, NULL);
	gtk_tree_view_append_column (puzzles_view, col);
	_tmp167_ = cell_renderer_level_new ();
	g_object_ref_sink (_tmp167_);
	_tmp168_ = _tmp167_;
	gtk_tree_view_insert_column_with_attributes (puzzles_view, -1, "Complete", (GtkCellRenderer*) _tmp168_, "visible", 1, NULL, NULL);
	_g_object_unref0 (_tmp168_);
	g_signal_connect_object (puzzles_view, "row-activated", (GCallback) _klotski_level_cb_gtk_tree_view_row_activated, self, 0);
	gtk_widget_show_all ((GtkWidget*) puzzles_view);
	_tmp169_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp169_);
	scroll = _tmp169_;
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) puzzles_view);
	gtk_widget_show ((GtkWidget*) scroll);
	_tmp170_ = self->priv->puzzles_panel;
	gtk_box_pack_start (_tmp170_, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
	_tmp171_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp171_);
	bbox = _tmp171_;
	gtk_widget_show ((GtkWidget*) bbox);
	_tmp172_ = _ ("Previous Puzzle");
	_tmp173_ = (GtkButton*) gtk_button_new_with_label (_tmp172_);
	g_object_ref_sink (_tmp173_);
	_g_object_unref0 (self->priv->prev_button);
	self->priv->prev_button = _tmp173_;
	_tmp174_ = self->priv->prev_button;
	g_signal_connect_object (_tmp174_, "clicked", (GCallback) _klotski_prev_level_cb_gtk_button_clicked, self, 0);
	_tmp175_ = self->priv->prev_button;
	_tmp176_ = self->priv->current_level;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp175_, _tmp176_ > 0);
	_tmp177_ = self->priv->prev_button;
	gtk_widget_show ((GtkWidget*) _tmp177_);
	_tmp178_ = self->priv->prev_button;
	gtk_container_add ((GtkContainer*) bbox, (GtkWidget*) _tmp178_);
	_tmp179_ = _ ("Next Puzzle");
	_tmp180_ = (GtkButton*) gtk_button_new_with_label (_tmp179_);
	g_object_ref_sink (_tmp180_);
	_g_object_unref0 (self->priv->next_button);
	self->priv->next_button = _tmp180_;
	_tmp181_ = self->priv->next_button;
	g_signal_connect_object (_tmp181_, "clicked", (GCallback) _klotski_next_level_cb_gtk_button_clicked, self, 0);
	_tmp182_ = self->priv->next_button;
	_tmp183_ = self->priv->current_level;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp182_, _tmp183_ < (G_N_ELEMENTS (KLOTSKI_level) - 1));
	_tmp184_ = self->priv->next_button;
	gtk_widget_show ((GtkWidget*) _tmp184_);
	_tmp185_ = self->priv->next_button;
	gtk_container_add ((GtkContainer*) bbox, (GtkWidget*) _tmp185_);
	_tmp186_ = self->priv->puzzles_panel;
	gtk_box_pack_start (_tmp186_, (GtkWidget*) bbox, FALSE, TRUE, (guint) 0);
	_tmp187_ = hbox;
	_tmp188_ = self->priv->puzzles_panel;
	gtk_box_pack_start (_tmp187_, (GtkWidget*) _tmp188_, FALSE, TRUE, (guint) 0);
	_tmp189_ = puzzle_view_new ();
	g_object_ref_sink (_tmp189_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp189_;
	_tmp190_ = self->priv->view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp190_, KLOTSKI_MINWIDTH, KLOTSKI_MINHEIGHT);
	_tmp191_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp191_);
	_tmp192_ = hbox;
	_tmp193_ = self->priv->view;
	gtk_box_pack_start (_tmp192_, (GtkWidget*) _tmp193_, TRUE, TRUE, (guint) 0);
	_tmp194_ = hbox;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp194_, TRUE, TRUE, (guint) 0);
	_tmp195_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp195_);
	_tmp196_ = _tmp195_;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp196_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp196_);
	klotski_load_solved_state (self);
	_tmp197_ = self->priv->settings;
	_tmp198_ = g_settings_get_int (_tmp197_, KLOTSKI_KEY_LEVEL);
	startup_level = _tmp198_;
	klotski_new_game (self, startup_level);
	_g_object_unref0 (bbox);
	_g_object_unref0 (scroll);
	_g_object_unref0 (col);
	_g_object_unref0 (cell);
	_g_object_unref0 (puzzles_view);
	_g_object_unref0 (hbox);
	_g_object_unref0 (status_item);
	_g_object_unref0 (status_alignment);
	_g_object_unref0 (puzzles_button);
	_g_object_unref0 (new_game_button);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (status_box);
	_g_object_unref0 (builder);
	_g_free0 (builder_str);
	_g_object_unref0 (vbox);
	_g_free0 (histfile);
}


static void klotski_render_puzzle_name (GtkCellLayout* cell_layout, GtkCellRendererText* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	GValue val = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GValue _tmp2_ = {0};
	gint selected_level = 0;
	GValue _tmp3_ = {0};
	Klotski* app = NULL;
	GtkCellLayout* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	Klotski* _tmp6_ = NULL;
	Klotski* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = tree_model;
	_tmp1_ = *iter;
	gtk_tree_model_get_value (_tmp0_, &_tmp1_, 2, &_tmp2_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp2_;
	_tmp3_ = val;
	selected_level = g_value_get_int (&_tmp3_);
	_tmp4_ = cell_layout;
	_tmp5_ = g_object_get_data ((GObject*) _tmp4_, "app");
	_tmp6_ = _g_object_ref0 ((Klotski*) _tmp5_);
	app = _tmp6_;
	_tmp7_ = app;
	_tmp8_ = _tmp7_->priv->current_level;
	_tmp9_ = selected_level;
	if (_tmp8_ == _tmp9_) {
		GtkCellRendererText* _tmp10_ = NULL;
		_tmp10_ = cell;
		g_object_set (_tmp10_, "weight", 700, NULL);
	} else {
		GtkCellRendererText* _tmp11_ = NULL;
		_tmp11_ = cell;
		g_object_set (_tmp11_, "weight", 400, NULL);
	}
	_g_object_unref0 (app);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}


static gboolean klotski_window_configure_event_cb (Klotski* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->is_maximized;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->is_fullscreen;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GdkEventConfigure _tmp4_ = {0};
		gint _tmp5_ = 0;
		GdkEventConfigure _tmp6_ = {0};
		gint _tmp7_ = 0;
		_tmp4_ = *event;
		_tmp5_ = _tmp4_.width;
		self->priv->window_width = _tmp5_;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.height;
		self->priv->window_height = _tmp7_;
	}
	result = FALSE;
	return result;
}


static gboolean klotski_window_state_event_cb (Klotski* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_ = {0};
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState _tmp4_ = {0};
	GdkWindowState _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState _tmp2_ = {0};
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		GdkEventWindowState _tmp6_ = {0};
		GdkWindowState _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.new_window_state;
		self->priv->is_fullscreen = (_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
		_tmp8_ = self->priv->is_fullscreen;
		if (_tmp8_) {
			GtkToolButton* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			GtkToolButton* _tmp11_ = NULL;
			_tmp9_ = self->priv->fullscreen_button;
			_tmp10_ = _ ("_Leave Fullscreen");
			gtk_tool_button_set_label (_tmp9_, _tmp10_);
			_tmp11_ = self->priv->fullscreen_button;
			gtk_tool_button_set_icon_name (_tmp11_, "view-restore");
		} else {
			GtkToolButton* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			GtkToolButton* _tmp14_ = NULL;
			_tmp12_ = self->priv->fullscreen_button;
			_tmp13_ = _ ("_Fullscreen");
			gtk_tool_button_set_label (_tmp12_, _tmp13_);
			_tmp14_ = self->priv->fullscreen_button;
			gtk_tool_button_set_icon_name (_tmp14_, "view-fullscreen");
		}
	}
	result = FALSE;
	return result;
}


static void klotski_scores_cb (Klotski* self) {
	g_return_if_fail (self != NULL);
	klotski_show_scores (self, NULL, FALSE);
}


static void klotski_game_score (Klotski* self) {
	gchar* key = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp2_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkTreeStore* _tmp7_ = NULL;
	GtkTreeIter* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp9_ = 0;
	GtkTreeIter _tmp10_ = {0};
	GDateTime* date = NULL;
	GDateTime* _tmp11_ = NULL;
	HistoryEntry* entry = NULL;
	GDateTime* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	Puzzle* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	HistoryEntry* _tmp16_ = NULL;
	History* _tmp17_ = NULL;
	HistoryEntry* _tmp18_ = NULL;
	History* _tmp19_ = NULL;
	HistoryEntry* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	_tmp1_ = klotski_get_level_key (self, _tmp0_);
	key = _tmp1_;
	_tmp2_ = g_key_file_new ();
	keyfile = _tmp2_;
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "gnome-klotski", "levels", NULL);
	filename = _tmp4_;
	{
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		_g_key_file_free0 (keyfile);
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_key_file_set_boolean (keyfile, key, "solved", TRUE);
	{
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = g_key_file_to_data (keyfile, NULL, NULL);
		_tmp6_ = _tmp5_;
		g_file_set_contents (filename, _tmp6_, (gssize) (-1), &_inner_error_);
		_g_free0 (_tmp6_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		_g_key_file_free0 (keyfile);
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = self->priv->puzzles;
	_tmp8_ = self->priv->puzzles_items;
	_tmp8__length1 = self->priv->puzzles_items_length1;
	_tmp9_ = self->priv->current_level;
	_tmp10_ = _tmp8_[_tmp9_];
	gtk_tree_store_set (_tmp7_, &_tmp10_, 1, TRUE, -1, -1);
	_tmp11_ = g_date_time_new_now_local ();
	date = _tmp11_;
	_tmp12_ = date;
	_tmp13_ = self->priv->current_level;
	_tmp14_ = self->priv->puzzle;
	_tmp15_ = _tmp14_->moves;
	_tmp16_ = history_entry_new (_tmp12_, (guint) _tmp13_, (guint) _tmp15_);
	entry = _tmp16_;
	_tmp17_ = self->priv->history;
	_tmp18_ = entry;
	history_add (_tmp17_, _tmp18_);
	_tmp19_ = self->priv->history;
	history_save (_tmp19_);
	_tmp20_ = entry;
	_tmp21_ = klotski_show_scores (self, _tmp20_, TRUE);
	if (_tmp21_ == ((gint) GTK_RESPONSE_OK)) {
		gint _tmp22_ = 0;
		_tmp22_ = self->priv->current_level;
		klotski_new_game (self, _tmp22_);
	}
	_history_entry_unref0 (entry);
	_g_date_time_unref0 (date);
	_g_free0 (filename);
	_g_key_file_free0 (keyfile);
	_g_free0 (key);
}


static gint klotski_show_scores (Klotski* self, HistoryEntry* selected_entry, gboolean show_close) {
	gint result = 0;
	ScoreDialog* dialog = NULL;
	History* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ScoreDialog* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = selected_entry;
	_tmp2_ = show_close;
	_tmp3_ = score_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, _tmp4_);
	_tmp5_ = gtk_dialog_run ((GtkDialog*) dialog);
	_result_ = _tmp5_;
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_;
	_g_object_unref0 (dialog);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* klotski_get_level_key (Klotski* self, gint level_number) {
	gchar* result = NULL;
	guint32 _result_ = 0U;
	gchar* data = NULL;
	gint _tmp0_ = 0;
	LevelInfo _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint32 _tmp23_ = 0U;
	gchar* _tmp24_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = (guint32) 0xFFFFFFFFU;
	_tmp0_ = level_number;
	_tmp1_ = KLOTSKI_level[_tmp0_];
	_tmp2_ = _tmp1_.data;
	_tmp3_ = g_strdup (_tmp2_);
	data = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gchar _tmp9_ = '\0';
				gchar octet = '\0';
				const gchar* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gchar _tmp12_ = '\0';
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = data;
				_tmp8_ = i;
				_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
				if (!(_tmp9_ != '\0')) {
					break;
				}
				_tmp10_ = data;
				_tmp11_ = i;
				_tmp12_ = string_get (_tmp10_, (glong) _tmp11_);
				octet = _tmp12_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							gboolean _tmp14_ = FALSE;
							gint _tmp16_ = 0;
							gchar _tmp17_ = '\0';
							guint32 _tmp18_ = 0U;
							guint32 _tmp21_ = 0U;
							gchar _tmp22_ = '\0';
							_tmp14_ = _tmp13_;
							if (!_tmp14_) {
								gint _tmp15_ = 0;
								_tmp15_ = j;
								j = _tmp15_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp16_ = j;
							if (!(_tmp16_ < 8)) {
								break;
							}
							_tmp17_ = octet;
							_tmp18_ = _result_;
							if (((_tmp17_ >> 7) ^ (_tmp18_ >> 31)) != ((guint32) 0)) {
								guint32 _tmp19_ = 0U;
								_tmp19_ = _result_;
								_result_ = (_tmp19_ << 1) ^ 0x04c11db7;
							} else {
								guint32 _tmp20_ = 0U;
								_tmp20_ = _result_;
								_result_ = _tmp20_ << 1;
							}
							_tmp21_ = _result_;
							_result_ = _tmp21_ & 0xFFFFFFFFLL;
							_tmp22_ = octet;
							octet = (gchar) (_tmp22_ << 1);
						}
					}
				}
			}
		}
	}
	_tmp23_ = _result_;
	_tmp24_ = g_strdup_printf ("%08X", (guint) (~_tmp23_));
	result = _tmp24_;
	_g_free0 (data);
	return result;
}


static void klotski_load_solved_state (Klotski* self) {
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "gnome-klotski", "levels", NULL);
	filename = _tmp2_;
	{
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		_g_key_file_free0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint _tmp6_ = 0;
				gchar* key = NULL;
				gint _tmp7_ = 0;
				gchar* _tmp8_ = NULL;
				gboolean value = FALSE;
				GtkTreeStore* _tmp12_ = NULL;
				GtkTreeIter* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				GtkTreeIter _tmp15_ = {0};
				gboolean _tmp16_ = FALSE;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ < G_N_ELEMENTS (KLOTSKI_level))) {
					break;
				}
				_tmp7_ = i;
				_tmp8_ = klotski_get_level_key (self, _tmp7_);
				key = _tmp8_;
				value = FALSE;
				{
					gboolean _tmp9_ = FALSE;
					const gchar* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					_tmp10_ = key;
					_tmp11_ = g_key_file_get_boolean (keyfile, _tmp10_, "solved", &_inner_error_);
					_tmp9_ = _tmp11_;
					if (_inner_error_ != NULL) {
						goto __catch4_g_error;
					}
					value = _tmp9_;
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally4:
				if (_inner_error_ != NULL) {
					_g_free0 (key);
					_g_free0 (filename);
					_g_key_file_free0 (keyfile);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp12_ = self->priv->puzzles;
				_tmp13_ = self->priv->puzzles_items;
				_tmp13__length1 = self->priv->puzzles_items_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				_tmp16_ = value;
				gtk_tree_store_set (_tmp12_, &_tmp15_, 1, _tmp16_, -1, -1);
				_g_free0 (key);
			}
		}
	}
	_g_free0 (filename);
	_g_key_file_free0 (keyfile);
}


static void klotski_update_menu_state (Klotski* self) {
	GtkBox* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GtkButton* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSimpleAction* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GSimpleAction* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_panel;
	gtk_widget_queue_draw ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->next_button;
	_tmp2_ = self->priv->current_level;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp2_ < (G_N_ELEMENTS (KLOTSKI_level) - 1));
	_tmp3_ = self->priv->prev_button;
	_tmp4_ = self->priv->current_level;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_ > 0);
	_tmp5_ = self->priv->next_level_action;
	_tmp6_ = self->priv->current_level;
	g_simple_action_set_enabled (_tmp5_, _tmp6_ < (G_N_ELEMENTS (KLOTSKI_level) - 1));
	_tmp7_ = self->priv->prev_level_action;
	_tmp8_ = self->priv->current_level;
	g_simple_action_set_enabled (_tmp7_, _tmp8_ > 0);
	klotski_update_moves_label (self);
}


static void _klotski_puzzle_moved_cb_puzzle_moved (Puzzle* _sender, gpointer self) {
	klotski_puzzle_moved_cb (self);
}


static void klotski_new_game (Klotski* self, gint requested_level) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkLabel* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	LevelInfo _tmp7_ = {0};
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	LevelInfo _tmp13_ = {0};
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	LevelInfo _tmp16_ = {0};
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	LevelInfo _tmp19_ = {0};
	const gchar* _tmp20_ = NULL;
	Puzzle* _tmp21_ = NULL;
	Puzzle* _tmp22_ = NULL;
	PuzzleView* _tmp23_ = NULL;
	Puzzle* _tmp24_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = requested_level;
	_tmp1_ = CLAMP (_tmp0_, 0, G_N_ELEMENTS (KLOTSKI_level) - 1);
	self->priv->current_level = _tmp1_;
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->current_level;
	g_settings_set_int (_tmp2_, KLOTSKI_KEY_LEVEL, _tmp3_);
	_tmp4_ = self->priv->messagewidget;
	_tmp5_ = _ ("Puzzle: ");
	_tmp6_ = self->priv->current_level;
	_tmp7_ = KLOTSKI_level[_tmp6_];
	_tmp8_ = _tmp7_.name;
	_tmp9_ = _ (_tmp8_);
	_tmp10_ = g_strconcat (_tmp5_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	gtk_label_set_text (_tmp4_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->current_level;
	_tmp13_ = KLOTSKI_level[_tmp12_];
	_tmp14_ = _tmp13_.width;
	_tmp15_ = self->priv->current_level;
	_tmp16_ = KLOTSKI_level[_tmp15_];
	_tmp17_ = _tmp16_.height;
	_tmp18_ = self->priv->current_level;
	_tmp19_ = KLOTSKI_level[_tmp18_];
	_tmp20_ = _tmp19_.data;
	_tmp21_ = puzzle_new (_tmp14_, _tmp17_, _tmp20_);
	_puzzle_unref0 (self->priv->puzzle);
	self->priv->puzzle = _tmp21_;
	_tmp22_ = self->priv->puzzle;
	g_signal_connect_object (_tmp22_, "moved", (GCallback) _klotski_puzzle_moved_cb_puzzle_moved, self, 0);
	_tmp23_ = self->priv->view;
	_tmp24_ = self->priv->puzzle;
	puzzle_view_set_puzzle (_tmp23_, _tmp24_);
	klotski_update_menu_state (self);
}


static void klotski_puzzle_moved_cb (Klotski* self) {
	g_return_if_fail (self != NULL);
	klotski_update_moves_label (self);
}


static void klotski_update_moves_label (Klotski* self) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Puzzle* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Puzzle* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->moves_label;
	_tmp1_ = _ ("Moves: %d");
	_tmp2_ = self->priv->puzzle;
	_tmp3_ = _tmp2_->moves;
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_text (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->puzzle;
	_tmp7_ = puzzle_game_over (_tmp6_);
	if (_tmp7_) {
		GtkLabel* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = self->priv->messagewidget;
		_tmp9_ = _ ("Level completed.");
		gtk_label_set_text (_tmp8_, _tmp9_);
		klotski_game_score (self);
	}
}


static void klotski_quit_cb (Klotski* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void klotski_level_cb (Klotski* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeIter iter = {0};
	GValue val = {0};
	GtkTreeStore* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	GtkTreeStore* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	GValue _tmp5_ = {0};
	gint requested_level = 0;
	GValue _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = self->priv->puzzles;
	_tmp1_ = path;
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = self->priv->puzzles;
	_tmp4_ = iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp3_, &_tmp4_, 2, &_tmp5_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp5_;
	_tmp6_ = val;
	requested_level = g_value_get_int (&_tmp6_);
	_tmp7_ = requested_level;
	if (_tmp7_ < 0) {
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		return;
	}
	_tmp8_ = self->priv->current_level;
	_tmp9_ = requested_level;
	if (_tmp8_ != _tmp9_) {
		gint _tmp10_ = 0;
		_tmp10_ = requested_level;
		klotski_new_game (self, _tmp10_);
	}
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}


static void klotski_restart_level_cb (Klotski* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	klotski_new_game (self, _tmp0_);
}


static void klotski_toggle_puzzles_cb (Klotski* self) {
	GtkBox* _tmp0_ = NULL;
	GtkBox* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_panel;
	_tmp1_ = self->priv->puzzles_panel;
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, !_tmp3_);
}


static void klotski_next_level_cb (Klotski* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	klotski_new_game (self, _tmp0_ + 1);
}


static void klotski_prev_level_cb (Klotski* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	klotski_new_game (self, _tmp0_ - 1);
}


static void klotski_help_cb (Klotski* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-klotski", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-klotski.vala:931: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void klotski_real_shutdown (GApplication* base) {
	Klotski * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	self = (Klotski*) base;
	G_APPLICATION_CLASS (klotski_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->is_fullscreen;
	g_settings_set_boolean (_tmp6_, "window-is-fullscreen", _tmp7_);
}


static void klotski_real_activate (GApplication* base) {
	Klotski * self;
	GtkWindow* _tmp0_ = NULL;
	self = (Klotski*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present (_tmp0_);
}


static void klotski_fullscreen_cb (Klotski* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_fullscreen;
	if (_tmp0_) {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = self->priv->window;
		gtk_window_unfullscreen (_tmp1_);
	} else {
		GtkWindow* _tmp2_ = NULL;
		_tmp2_ = self->priv->window;
		gtk_window_fullscreen (_tmp2_);
	}
}


static void klotski_about_cb (Klotski* self) {
	static const gchar* authors[] = {"Lars Rydlinge (original author)", "Robert Ancell (port to vala)", "John Cheetham (port to vala)", NULL};
	static const gchar* documenters[] = {"Andrew Sobala", NULL};
	GtkWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = _ ("Klotski");
	_tmp2_ = _ ("Sliding block puzzles\n\nKlotski is a part of GNOME Games.");
	_tmp3_ = _ ("translator-credits");
	gtk_show_about_dialog (_tmp0_, "program-name", _tmp1_, "version", VERSION, "comments", _tmp2_, "copyright", "Copyright © 1999–2008 Lars Rydlinge", "license-type", GTK_LICENSE_GPL_2_0, "authors", authors, "documenters", documenters, "translator-credits", _tmp3_, "logo-icon-name", "gnome-klotski", "website", "https://wiki.gnome.org/Apps/Klotski", NULL, NULL);
}


gint klotski_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionGroup* _tmp1_ = NULL;
	Klotski* app = NULL;
	Klotski* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (NULL);
	context = _tmp0_;
	g_option_context_set_translation_domain (context, GETTEXT_PACKAGE);
	_tmp1_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (context, _tmp1_);
	{
		g_option_context_parse (context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		fprintf (_tmp2_, "%s\n", _tmp4_);
		exit (EXIT_FAILURE);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp5_ = klotski_new ();
	app = _tmp5_;
	_tmp6_ = args;
	_tmp6__length1 = args_length1;
	_tmp7_ = g_application_run ((GApplication*) app, _tmp6__length1, _tmp6_);
	result = _tmp7_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return klotski_main (argv, argc);
}


static void klotski_class_init (KlotskiClass * klass) {
	klotski_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KlotskiPrivate));
	G_APPLICATION_CLASS (klass)->startup = klotski_real_startup;
	G_APPLICATION_CLASS (klass)->shutdown = klotski_real_shutdown;
	G_APPLICATION_CLASS (klass)->activate = klotski_real_activate;
	G_OBJECT_CLASS (klass)->finalize = klotski_finalize;
}


static void klotski_instance_init (Klotski * self) {
	self->priv = KLOTSKI_GET_PRIVATE (self);
	self->priv->current_level = -1;
}


static void klotski_finalize (GObject* obj) {
	Klotski * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KLOTSKI, Klotski);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->puzzles_panel);
	_g_object_unref0 (self->priv->next_button);
	_g_object_unref0 (self->priv->prev_button);
	_g_object_unref0 (self->priv->next_level_action);
	_g_object_unref0 (self->priv->prev_level_action);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->fullscreen_button);
	_g_object_unref0 (self->priv->messagewidget);
	_g_object_unref0 (self->priv->moves_label);
	_puzzle_unref0 (self->priv->puzzle);
	_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->puzzles);
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
	G_OBJECT_CLASS (klotski_parent_class)->finalize (obj);
}


GType klotski_get_type (void) {
	static volatile gsize klotski_type_id__volatile = 0;
	if (g_once_init_enter (&klotski_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KlotskiClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) klotski_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Klotski), 0, (GInstanceInitFunc) klotski_instance_init, NULL };
		GType klotski_type_id;
		klotski_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Klotski", &g_define_type_info, 0);
		g_once_init_leave (&klotski_type_id__volatile, klotski_type_id);
	}
	return klotski_type_id__volatile;
}


CellRendererLevel* cell_renderer_level_construct (GType object_type) {
	CellRendererLevel * self = NULL;
	self = (CellRendererLevel*) g_object_new (object_type, NULL);
	return self;
}


CellRendererLevel* cell_renderer_level_new (void) {
	return cell_renderer_level_construct (TYPE_CELL_RENDERER_LEVEL);
}


static void cell_renderer_level_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height) {
	CellRendererLevel * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	self = (CellRendererLevel*) base;
	g_return_if_fail (widget != NULL);
	_vala_x_offset = 0;
	_vala_y_offset = 0;
	_vala_height = CELL_RENDERER_LEVEL_icon_size;
	_vala_width = _vala_height;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}


static void cell_renderer_level_real_render (GtkCellRenderer* base, cairo_t* ctx, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags) {
	CellRendererLevel * self;
	cairo_t* _tmp0_ = NULL;
	GdkRectangle _tmp1_ = {0};
	cairo_t* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	self = (CellRendererLevel*) base;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = ctx;
	_tmp1_ = *background_area;
	gdk_cairo_rectangle (_tmp0_, &_tmp1_);
	{
		GtkIconTheme* icon_theme = NULL;
		GtkIconTheme* _tmp2_ = NULL;
		GtkIconTheme* _tmp3_ = NULL;
		GdkPixbuf* icon = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		gint x = 0;
		GdkRectangle _tmp5_ = {0};
		gint _tmp6_ = 0;
		GdkRectangle _tmp7_ = {0};
		gint _tmp8_ = 0;
		gint y = 0;
		GdkRectangle _tmp9_ = {0};
		gint _tmp10_ = 0;
		GdkRectangle _tmp11_ = {0};
		gint _tmp12_ = 0;
		cairo_t* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp2_ = gtk_icon_theme_get_default ();
		_tmp3_ = _g_object_ref0 (_tmp2_);
		icon_theme = _tmp3_;
		_tmp4_ = gtk_icon_theme_load_icon (icon_theme, "gtk-yes", CELL_RENDERER_LEVEL_icon_size, 0, &_inner_error_);
		icon = _tmp4_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (icon_theme);
			goto __catch7_g_error;
		}
		_tmp5_ = *background_area;
		_tmp6_ = _tmp5_.x;
		_tmp7_ = *background_area;
		_tmp8_ = _tmp7_.width;
		x = _tmp6_ + ((_tmp8_ - CELL_RENDERER_LEVEL_icon_size) / 2);
		_tmp9_ = *background_area;
		_tmp10_ = _tmp9_.y;
		_tmp11_ = *background_area;
		_tmp12_ = _tmp11_.height;
		y = _tmp10_ + ((_tmp12_ - CELL_RENDERER_LEVEL_icon_size) / 2);
		_tmp13_ = ctx;
		_tmp14_ = x;
		_tmp15_ = y;
		gdk_cairo_set_source_pixbuf (_tmp13_, icon, (gdouble) _tmp14_, (gdouble) _tmp15_);
		_g_object_unref0 (icon);
		_g_object_unref0 (icon_theme);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("gnome-klotski.vala:1046: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp18_ = ctx;
	cairo_fill (_tmp18_);
}


static void cell_renderer_level_class_init (CellRendererLevelClass * klass) {
	cell_renderer_level_parent_class = g_type_class_peek_parent (klass);
	GTK_CELL_RENDERER_CLASS (klass)->get_size = cell_renderer_level_real_get_size;
	GTK_CELL_RENDERER_CLASS (klass)->render = cell_renderer_level_real_render;
}


static void cell_renderer_level_instance_init (CellRendererLevel * self) {
}


GType cell_renderer_level_get_type (void) {
	static volatile gsize cell_renderer_level_type_id__volatile = 0;
	if (g_once_init_enter (&cell_renderer_level_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CellRendererLevelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cell_renderer_level_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CellRendererLevel), 0, (GInstanceInitFunc) cell_renderer_level_instance_init, NULL };
		GType cell_renderer_level_type_id;
		cell_renderer_level_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER, "CellRendererLevel", &g_define_type_info, 0);
		g_once_init_leave (&cell_renderer_level_type_id__volatile, cell_renderer_level_type_id);
	}
	return cell_renderer_level_type_id__volatile;
}



