/* worm.c generated by valac 0.42.3, the Vala compiler
 * generated from worm.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/


#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>


#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;
typedef struct _WormPrivate WormPrivate;
enum  {
	WORM_0_PROPERTY,
	WORM_STARTING_POSITION_PROPERTY,
	WORM_ID_PROPERTY,
	WORM_IS_MATERIALIZED_PROPERTY,
	WORM_LIVES_PROPERTY,
	WORM_SCORE_PROPERTY,
	WORM_LENGTH_PROPERTY,
	WORM_HEAD_PROPERTY,
	WORM_LIST_PROPERTY,
	WORM_NUM_PROPERTIES
};
static GParamSpec* worm_properties[WORM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _position_free0(var) ((var == NULL) ? NULL : (var = (position_free (var), NULL)))

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;
typedef struct _WarpPrivate WarpPrivate;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))

#define TYPE_BONUS_TYPE (bonus_type_get_type ())
enum  {
	WORM_ADDED_SIGNAL,
	WORM_FINISH_ADDED_SIGNAL,
	WORM_MOVED_SIGNAL,
	WORM_RESCALED_SIGNAL,
	WORM_DIED_SIGNAL,
	WORM_TAIL_REDUCED_SIGNAL,
	WORM_REVERSED_SIGNAL,
	WORM_BONUS_FOUND_SIGNAL,
	WORM_WARP_FOUND_SIGNAL,
	WORM_NUM_SIGNALS
};
static guint worm_signals[WORM_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Position {
	gint x;
	gint y;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _WormPrivate {
	Position _starting_position;
	gint _id;
	gboolean _is_materialized;
	gint rounds_dematerialized;
	gint _lives;
	gint _score;
	GeeArrayQueue* key_queue;
	GeeLinkedList* _list;
};

struct _Warp {
	GObject parent_instance;
	WarpPrivate * priv;
	gint x;
	gint y;
	gint wx;
	gint wy;
};

struct _WarpClass {
	GObjectClass parent_class;
};

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;


static gint Worm_private_offset;
static gpointer worm_parent_class = NULL;
static guint* worm_deadend_board;
static gint worm_deadend_board_length1;
static gint worm_deadend_board_length2;
static guint* worm_deadend_board = NULL;
static gint worm_deadend_board_length1 = 0;
static gint worm_deadend_board_length2 = 0;
static guint worm_deadend_runnumber;
static guint worm_deadend_runnumber = (guint) 0;

GType worm_direction_get_type (void) G_GNUC_CONST;
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GType worm_get_type (void) G_GNUC_CONST;
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
#define WORM_STARTING_LENGTH 5
#define WORM_STARTING_LIVES 6
#define WORM_MAX_LIVES 12
#define WORM_GROW_FACTOR 4
Worm* worm_new (gint id);
Worm* worm_construct (GType object_type,
                      gint id);
static void worm_set_id (Worm* self,
                  gint value);
void worm_set_lives (Worm* self,
                     gint value);
void worm_set_score (Worm* self,
                     gint value);
static void worm_set_list (Worm* self,
                    GeeLinkedList* value);
void worm_set_start (Worm* self,
                     gint xhead,
                     gint yhead,
                     WormDirection direction);
GeeLinkedList* worm_get_list (Worm* self);
static void worm_set_starting_position (Worm* self,
                                 Position * value);
void worm_get_starting_position (Worm* self,
                                 Position * result);
void worm_move (Worm* self,
                gint* board,
                int board_length1,
                int board_length2);
void worm_get_head (Worm* self,
                    Position * result);
#define NIBBLES_GAME_WARPCHAR 'W'
#define NIBBLES_GAME_EMPTYCHAR 'a'
gboolean worm_get_is_materialized (Worm* self);
#define NIBBLES_GAME_WORMCHAR 'w'
gint worm_get_id (Worm* self);
void worm_dequeue_keypress (Worm* self);
static void worm_materialize (Worm* self,
                       gint* board,
                       int board_length1,
                       int board_length2);
void worm_reduce_tail (Worm* self,
                       gint* board,
                       int board_length1,
                       int board_length2,
                       gint erase_size);
void worm_reverse (Worm* self,
                   gint* board,
                   int board_length1,
                   int board_length2);
GType warp_get_type (void) G_GNUC_CONST;
void worm_warp (Worm* self,
                Warp* warp);
static void worm_set_head (Worm* self,
                    Position * value);
gboolean worm_can_move_to (Worm* self,
                           gint* board,
                           int board_length1,
                           int board_length2,
                           gint numworms);
static void worm_position_move (Worm* self,
                         Position* result);
gboolean worm_will_collide_with_head (Worm* self,
                                      Worm* other_worm);
static gboolean _position_equal (const Position * s1,
                          const Position * s2);
void worm_spawn (Worm* self,
                 gint* board,
                 int board_length1,
                 int board_length2);
static void worm_set_is_materialized (Worm* self,
                               gboolean value);
void worm_dematerialize (Worm* self,
                         gint* board,
                         int board_length1,
                         int board_length2,
                         gint rounds);
void worm_add_life (Worm* self);
gint worm_get_lives (Worm* self);
static void worm_lose_life (Worm* self);
void worm_reset (Worm* self,
                 gint* board,
                 int board_length1,
                 int board_length2);
static void worm_direction_set (Worm* self,
                         WormDirection dir);
void worm_queue_keypress (Worm* self,
                          WormDirection dir);
static guint worm_upper_key (Worm* self,
                      guint keyval);
void worm_handle_direction (Worm* self,
                            WormDirection dir);
gboolean worm_handle_keypress (Worm* self,
                               guint keyval,
                               GeeHashMap* worm_props);
static gint worm_ai_deadend (gint* board,
                      int board_length1,
                      int board_length2,
                      gint numworms,
                      gint x,
                      gint y,
                      gint length_left);
static gint worm_ai_deadend_after (gint* board,
                            int board_length1,
                            int board_length2,
                            GeeLinkedList* worms,
                            gint numworms,
                            gint x,
                            gint y,
                            gint dir,
                            gint length);
static gboolean worm_ai_too_close (Worm* self,
                            GeeLinkedList* worms,
                            gint numworms);
static gboolean worm_ai_wander (gint* board,
                         int board_length1,
                         int board_length2,
                         gint numworms,
                         gint x,
                         gint y,
                         gint dir,
                         gint ox,
                         gint oy);
GType bonus_type_get_type (void) G_GNUC_CONST;
void worm_ai_move (Worm* self,
                   gint* board,
                   int board_length1,
                   int board_length2,
                   gint numworms,
                   GeeLinkedList* worms);
#define NIBBLES_GAME_CAPACITY (NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT)
gint worm_get_length (Worm* self);
gint worm_get_score (Worm* self);
void worm_set_length (Worm* self,
                      gint value);
static void worm_finalize (GObject * obj);
static void _vala_worm_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_worm_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);


GType
worm_direction_get_type (void)
{
	static volatile gsize worm_direction_type_id__volatile = 0;
	if (g_once_init_enter (&worm_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{WORM_DIRECTION_NONE, "WORM_DIRECTION_NONE", "none"}, {WORM_DIRECTION_RIGHT, "WORM_DIRECTION_RIGHT", "right"}, {WORM_DIRECTION_DOWN, "WORM_DIRECTION_DOWN", "down"}, {WORM_DIRECTION_LEFT, "WORM_DIRECTION_LEFT", "left"}, {WORM_DIRECTION_UP, "WORM_DIRECTION_UP", "up"}, {0, NULL, NULL}};
		GType worm_direction_type_id;
		worm_direction_type_id = g_enum_register_static ("WormDirection", values);
		g_once_init_leave (&worm_direction_type_id__volatile, worm_direction_type_id);
	}
	return worm_direction_type_id__volatile;
}


Position*
position_dup (const Position* self)
{
	Position* dup;
#line 31 "worm.vala"
	dup = g_new0 (Position, 1);
#line 31 "worm.vala"
	memcpy (dup, self, sizeof (Position));
#line 31 "worm.vala"
	return dup;
#line 357 "worm.c"
}


void
position_free (Position* self)
{
#line 31 "worm.vala"
	g_free (self);
#line 366 "worm.c"
}


GType
position_get_type (void)
{
	static volatile gsize position_type_id__volatile = 0;
	if (g_once_init_enter (&position_type_id__volatile)) {
		GType position_type_id;
		position_type_id = g_boxed_type_register_static ("Position", (GBoxedCopyFunc) position_dup, (GBoxedFreeFunc) position_free);
		g_once_init_leave (&position_type_id__volatile, position_type_id);
	}
	return position_type_id__volatile;
}


WormProperties*
worm_properties_dup (const WormProperties* self)
{
	WormProperties* dup;
#line 37 "worm.vala"
	dup = g_new0 (WormProperties, 1);
#line 37 "worm.vala"
	memcpy (dup, self, sizeof (WormProperties));
#line 37 "worm.vala"
	return dup;
#line 393 "worm.c"
}


void
worm_properties_free (WormProperties* self)
{
#line 37 "worm.vala"
	g_free (self);
#line 402 "worm.c"
}


GType
worm_properties_get_type (void)
{
	static volatile gsize worm_properties_type_id__volatile = 0;
	if (g_once_init_enter (&worm_properties_type_id__volatile)) {
		GType worm_properties_type_id;
		worm_properties_type_id = g_boxed_type_register_static ("WormProperties", (GBoxedCopyFunc) worm_properties_dup, (GBoxedFreeFunc) worm_properties_free);
		g_once_init_leave (&worm_properties_type_id__volatile, worm_properties_type_id);
	}
	return worm_properties_type_id__volatile;
}


static inline gpointer
worm_get_instance_private (Worm* self)
{
	return G_STRUCT_MEMBER_P (self, Worm_private_offset);
}


Worm*
worm_construct (GType object_type,
                gint id)
{
	Worm * self = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeArrayQueue* _tmp2_;
#line 106 "worm.vala"
	self = (Worm*) g_object_new (object_type, NULL);
#line 108 "worm.vala"
	worm_set_id (self, id);
#line 109 "worm.vala"
	worm_set_lives (self, WORM_STARTING_LIVES);
#line 110 "worm.vala"
	worm_set_score (self, 0);
#line 111 "worm.vala"
	self->change = 0;
#line 112 "worm.vala"
	_tmp0_ = gee_linked_list_new (TYPE_POSITION, (GBoxedCopyFunc) position_dup, (GDestroyNotify) position_free, NULL, NULL, NULL);
#line 112 "worm.vala"
	_tmp1_ = _tmp0_;
#line 112 "worm.vala"
	worm_set_list (self, _tmp1_);
#line 112 "worm.vala"
	_g_object_unref0 (_tmp1_);
#line 113 "worm.vala"
	_tmp2_ = gee_array_queue_new (TYPE_WORM_DIRECTION, NULL, NULL, NULL, NULL, NULL);
#line 113 "worm.vala"
	_g_object_unref0 (self->priv->key_queue);
#line 113 "worm.vala"
	self->priv->key_queue = _tmp2_;
#line 106 "worm.vala"
	return self;
#line 460 "worm.c"
}


Worm*
worm_new (gint id)
{
#line 106 "worm.vala"
	return worm_construct (TYPE_WORM, id);
#line 469 "worm.c"
}


void
worm_set_start (Worm* self,
                gint xhead,
                gint yhead,
                WormDirection direction)
{
	GeeLinkedList* _tmp0_;
	Position _tmp1_ = {0};
	GeeLinkedList* _tmp2_;
	Position _tmp3_;
	WormDirection _tmp4_;
	GeeArrayQueue* _tmp5_;
#line 116 "worm.vala"
	g_return_if_fail (self != NULL);
#line 118 "worm.vala"
	_tmp0_ = self->priv->_list;
#line 118 "worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 120 "worm.vala"
	memset (&_tmp1_, 0, sizeof (Position));
#line 120 "worm.vala"
	_tmp1_.x = xhead;
#line 120 "worm.vala"
	_tmp1_.y = yhead;
#line 120 "worm.vala"
	worm_set_starting_position (self, &_tmp1_);
#line 125 "worm.vala"
	_tmp2_ = self->priv->_list;
#line 125 "worm.vala"
	_tmp3_ = self->priv->_starting_position;
#line 125 "worm.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, &_tmp3_);
#line 127 "worm.vala"
	self->starting_direction = direction;
#line 128 "worm.vala"
	_tmp4_ = self->starting_direction;
#line 128 "worm.vala"
	self->direction = _tmp4_;
#line 129 "worm.vala"
	self->change = 0;
#line 130 "worm.vala"
	_tmp5_ = self->priv->key_queue;
#line 130 "worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp5_);
#line 517 "worm.c"
}


void
worm_move (Worm* self,
           gint* board,
           int board_length1,
           int board_length2)
{
	gboolean _tmp0_;
	Position position = {0};
	Position _tmp1_ = {0};
	Position _tmp2_;
	WormDirection _tmp3_;
	GeeLinkedList* _tmp36_;
	Position _tmp37_;
	Position _tmp38_ = {0};
	Position _tmp39_;
	gint _tmp40_;
	Position _tmp41_ = {0};
	Position _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	Position _tmp59_ = {0};
	Position _tmp60_;
	gint _tmp61_;
	Position _tmp62_ = {0};
	Position _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gboolean _tmp66_;
	GeeArrayQueue* _tmp76_;
	gboolean _tmp77_;
	gboolean _tmp78_;
	gint _tmp79_;
#line 133 "worm.vala"
	g_return_if_fail (self != NULL);
#line 135 "worm.vala"
	_tmp0_ = self->is_human;
#line 135 "worm.vala"
	if (_tmp0_) {
#line 136 "worm.vala"
		self->keypress = FALSE;
#line 562 "worm.c"
	}
#line 138 "worm.vala"
	worm_get_head (self, &_tmp1_);
#line 138 "worm.vala"
	_tmp2_ = _tmp1_;
#line 138 "worm.vala"
	position = _tmp2_;
#line 139 "worm.vala"
	_tmp3_ = self->direction;
#line 139 "worm.vala"
	switch (_tmp3_) {
#line 139 "worm.vala"
		case WORM_DIRECTION_UP:
#line 576 "worm.c"
		{
			Position _tmp4_ = {0};
			Position _tmp5_;
			Position _tmp6_ = {0};
			Position _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			Position _tmp10_;
			gint _tmp11_;
#line 142 "worm.vala"
			worm_get_head (self, &_tmp4_);
#line 142 "worm.vala"
			_tmp5_ = _tmp4_;
#line 142 "worm.vala"
			worm_get_head (self, &_tmp6_);
#line 142 "worm.vala"
			_tmp7_ = _tmp6_;
#line 142 "worm.vala"
			_tmp8_ = _tmp7_.y;
#line 142 "worm.vala"
			_tmp7_.y = _tmp8_ - 1;
#line 142 "worm.vala"
			_tmp9_ = _tmp7_.y;
#line 142 "worm.vala"
			position.y = _tmp9_;
#line 143 "worm.vala"
			_tmp10_ = position;
#line 143 "worm.vala"
			_tmp11_ = _tmp10_.y;
#line 143 "worm.vala"
			if (_tmp11_ < 0) {
#line 144 "worm.vala"
				position.y = NIBBLES_GAME_HEIGHT - 1;
#line 610 "worm.c"
			}
#line 145 "worm.vala"
			break;
#line 614 "worm.c"
		}
#line 139 "worm.vala"
		case WORM_DIRECTION_DOWN:
#line 618 "worm.c"
		{
			Position _tmp12_ = {0};
			Position _tmp13_;
			Position _tmp14_ = {0};
			Position _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			Position _tmp18_;
			gint _tmp19_;
#line 147 "worm.vala"
			worm_get_head (self, &_tmp12_);
#line 147 "worm.vala"
			_tmp13_ = _tmp12_;
#line 147 "worm.vala"
			worm_get_head (self, &_tmp14_);
#line 147 "worm.vala"
			_tmp15_ = _tmp14_;
#line 147 "worm.vala"
			_tmp16_ = _tmp15_.y;
#line 147 "worm.vala"
			_tmp15_.y = _tmp16_ + 1;
#line 147 "worm.vala"
			_tmp17_ = _tmp15_.y;
#line 147 "worm.vala"
			position.y = _tmp17_;
#line 148 "worm.vala"
			_tmp18_ = position;
#line 148 "worm.vala"
			_tmp19_ = _tmp18_.y;
#line 148 "worm.vala"
			if (_tmp19_ >= NIBBLES_GAME_HEIGHT) {
#line 149 "worm.vala"
				position.y = 0;
#line 652 "worm.c"
			}
#line 150 "worm.vala"
			break;
#line 656 "worm.c"
		}
#line 139 "worm.vala"
		case WORM_DIRECTION_LEFT:
#line 660 "worm.c"
		{
			Position _tmp20_ = {0};
			Position _tmp21_;
			Position _tmp22_ = {0};
			Position _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			Position _tmp26_;
			gint _tmp27_;
#line 152 "worm.vala"
			worm_get_head (self, &_tmp20_);
#line 152 "worm.vala"
			_tmp21_ = _tmp20_;
#line 152 "worm.vala"
			worm_get_head (self, &_tmp22_);
#line 152 "worm.vala"
			_tmp23_ = _tmp22_;
#line 152 "worm.vala"
			_tmp24_ = _tmp23_.x;
#line 152 "worm.vala"
			_tmp23_.x = _tmp24_ - 1;
#line 152 "worm.vala"
			_tmp25_ = _tmp23_.x;
#line 152 "worm.vala"
			position.x = _tmp25_;
#line 153 "worm.vala"
			_tmp26_ = position;
#line 153 "worm.vala"
			_tmp27_ = _tmp26_.x;
#line 153 "worm.vala"
			if (_tmp27_ < 0) {
#line 154 "worm.vala"
				position.x = NIBBLES_GAME_WIDTH - 1;
#line 694 "worm.c"
			}
#line 155 "worm.vala"
			break;
#line 698 "worm.c"
		}
#line 139 "worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 702 "worm.c"
		{
			Position _tmp28_ = {0};
			Position _tmp29_;
			Position _tmp30_ = {0};
			Position _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			Position _tmp34_;
			gint _tmp35_;
#line 157 "worm.vala"
			worm_get_head (self, &_tmp28_);
#line 157 "worm.vala"
			_tmp29_ = _tmp28_;
#line 157 "worm.vala"
			worm_get_head (self, &_tmp30_);
#line 157 "worm.vala"
			_tmp31_ = _tmp30_;
#line 157 "worm.vala"
			_tmp32_ = _tmp31_.x;
#line 157 "worm.vala"
			_tmp31_.x = _tmp32_ + 1;
#line 157 "worm.vala"
			_tmp33_ = _tmp31_.x;
#line 157 "worm.vala"
			position.x = _tmp33_;
#line 158 "worm.vala"
			_tmp34_ = position;
#line 158 "worm.vala"
			_tmp35_ = _tmp34_.x;
#line 158 "worm.vala"
			if (_tmp35_ >= NIBBLES_GAME_WIDTH) {
#line 159 "worm.vala"
				position.x = 0;
#line 736 "worm.c"
			}
#line 160 "worm.vala"
			break;
#line 740 "worm.c"
		}
		default:
		{
#line 162 "worm.vala"
			break;
#line 746 "worm.c"
		}
	}
#line 166 "worm.vala"
	_tmp36_ = self->priv->_list;
#line 166 "worm.vala"
	_tmp37_ = position;
#line 166 "worm.vala"
	gee_deque_offer_head ((GeeDeque*) _tmp36_, &_tmp37_);
#line 168 "worm.vala"
	worm_get_head (self, &_tmp38_);
#line 168 "worm.vala"
	_tmp39_ = _tmp38_;
#line 168 "worm.vala"
	_tmp40_ = _tmp39_.x;
#line 168 "worm.vala"
	worm_get_head (self, &_tmp41_);
#line 168 "worm.vala"
	_tmp42_ = _tmp41_;
#line 168 "worm.vala"
	_tmp43_ = _tmp42_.y;
#line 168 "worm.vala"
	_tmp44_ = board[(_tmp40_ * board_length2) + _tmp43_];
#line 168 "worm.vala"
	if (_tmp44_ == ((gint) NIBBLES_GAME_WARPCHAR)) {
#line 169 "worm.vala"
		g_signal_emit (self, worm_signals[WORM_WARP_FOUND_SIGNAL], 0);
#line 773 "worm.c"
	}
#line 171 "worm.vala"
	_tmp45_ = self->change;
#line 171 "worm.vala"
	if (_tmp45_ > 0) {
#line 779 "worm.c"
		gint _tmp46_;
#line 173 "worm.vala"
		_tmp46_ = self->change;
#line 173 "worm.vala"
		self->change = _tmp46_ - 1;
#line 174 "worm.vala"
		g_signal_emit (self, worm_signals[WORM_ADDED_SIGNAL], 0);
#line 787 "worm.c"
	} else {
		GeeLinkedList* _tmp47_;
		gpointer _tmp48_;
		Position* _tmp49_;
		gint _tmp50_;
		GeeLinkedList* _tmp51_;
		gpointer _tmp52_;
		Position* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		GeeLinkedList* _tmp56_;
		gpointer _tmp57_;
		Position* _tmp58_;
#line 178 "worm.vala"
		_tmp47_ = self->priv->_list;
#line 178 "worm.vala"
		_tmp48_ = gee_linked_list_last (_tmp47_);
#line 178 "worm.vala"
		_tmp49_ = (Position*) _tmp48_;
#line 178 "worm.vala"
		_tmp50_ = (*_tmp49_).x;
#line 178 "worm.vala"
		_tmp51_ = self->priv->_list;
#line 178 "worm.vala"
		_tmp52_ = gee_linked_list_last (_tmp51_);
#line 178 "worm.vala"
		_tmp53_ = (Position*) _tmp52_;
#line 178 "worm.vala"
		_tmp54_ = (*_tmp53_).y;
#line 178 "worm.vala"
		board[(_tmp50_ * board_length2) + _tmp54_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 178 "worm.vala"
		_tmp55_ = board[(_tmp50_ * board_length2) + _tmp54_];
#line 178 "worm.vala"
		_position_free0 (_tmp53_);
#line 178 "worm.vala"
		_position_free0 (_tmp49_);
#line 179 "worm.vala"
		_tmp56_ = self->priv->_list;
#line 179 "worm.vala"
		_tmp57_ = gee_deque_poll_tail ((GeeDeque*) _tmp56_);
#line 179 "worm.vala"
		_tmp58_ = (Position*) _tmp57_;
#line 179 "worm.vala"
		_position_free0 (_tmp58_);
#line 180 "worm.vala"
		g_signal_emit (self, worm_signals[WORM_MOVED_SIGNAL], 0);
#line 835 "worm.c"
	}
#line 184 "worm.vala"
	worm_get_head (self, &_tmp59_);
#line 184 "worm.vala"
	_tmp60_ = _tmp59_;
#line 184 "worm.vala"
	_tmp61_ = _tmp60_.x;
#line 184 "worm.vala"
	worm_get_head (self, &_tmp62_);
#line 184 "worm.vala"
	_tmp63_ = _tmp62_;
#line 184 "worm.vala"
	_tmp64_ = _tmp63_.y;
#line 184 "worm.vala"
	_tmp65_ = board[(_tmp61_ * board_length2) + _tmp64_];
#line 184 "worm.vala"
	if (_tmp65_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 185 "worm.vala"
		g_signal_emit (self, worm_signals[WORM_BONUS_FOUND_SIGNAL], 0);
#line 855 "worm.c"
	}
#line 188 "worm.vala"
	_tmp66_ = self->priv->_is_materialized;
#line 188 "worm.vala"
	if (_tmp66_) {
#line 861 "worm.c"
		Position _tmp67_ = {0};
		Position _tmp68_;
		gint _tmp69_;
		Position _tmp70_ = {0};
		Position _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
#line 189 "worm.vala"
		worm_get_head (self, &_tmp67_);
#line 189 "worm.vala"
		_tmp68_ = _tmp67_;
#line 189 "worm.vala"
		_tmp69_ = _tmp68_.x;
#line 189 "worm.vala"
		worm_get_head (self, &_tmp70_);
#line 189 "worm.vala"
		_tmp71_ = _tmp70_;
#line 189 "worm.vala"
		_tmp72_ = _tmp71_.y;
#line 189 "worm.vala"
		_tmp73_ = self->priv->_id;
#line 189 "worm.vala"
		board[(_tmp69_ * board_length2) + _tmp72_] = NIBBLES_GAME_WORMCHAR + _tmp73_;
#line 189 "worm.vala"
		_tmp74_ = board[(_tmp69_ * board_length2) + _tmp72_];
#line 888 "worm.c"
	} else {
		gint _tmp75_;
#line 191 "worm.vala"
		_tmp75_ = self->priv->rounds_dematerialized;
#line 191 "worm.vala"
		self->priv->rounds_dematerialized = _tmp75_ - 1;
#line 895 "worm.c"
	}
#line 193 "worm.vala"
	_tmp76_ = self->priv->key_queue;
#line 193 "worm.vala"
	_tmp77_ = gee_array_queue_get_is_empty (_tmp76_);
#line 193 "worm.vala"
	_tmp78_ = _tmp77_;
#line 193 "worm.vala"
	if (!_tmp78_) {
#line 194 "worm.vala"
		worm_dequeue_keypress (self);
#line 907 "worm.c"
	}
#line 196 "worm.vala"
	_tmp79_ = self->priv->rounds_dematerialized;
#line 196 "worm.vala"
	if (_tmp79_ == 1) {
#line 197 "worm.vala"
		worm_materialize (self, board, board_length1, board_length2);
#line 915 "worm.c"
	}
}


void
worm_reduce_tail (Worm* self,
                  gint* board,
                  int board_length1,
                  int board_length2,
                  gint erase_size)
{
#line 200 "worm.vala"
	g_return_if_fail (self != NULL);
#line 202 "worm.vala"
	if (erase_size > 0) {
#line 931 "worm.c"
		{
			gint i = 0;
#line 204 "worm.vala"
			i = 0;
#line 936 "worm.c"
			{
				gboolean _tmp0_ = FALSE;
#line 204 "worm.vala"
				_tmp0_ = TRUE;
#line 204 "worm.vala"
				while (TRUE) {
#line 943 "worm.c"
					gint _tmp2_;
					GeeLinkedList* _tmp3_;
					gpointer _tmp4_;
					Position* _tmp5_;
					gint _tmp6_;
					GeeLinkedList* _tmp7_;
					gpointer _tmp8_;
					Position* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					GeeLinkedList* _tmp12_;
					gpointer _tmp13_;
					Position* _tmp14_;
#line 204 "worm.vala"
					if (!_tmp0_) {
#line 959 "worm.c"
						gint _tmp1_;
#line 204 "worm.vala"
						_tmp1_ = i;
#line 204 "worm.vala"
						i = _tmp1_ + 1;
#line 965 "worm.c"
					}
#line 204 "worm.vala"
					_tmp0_ = FALSE;
#line 204 "worm.vala"
					_tmp2_ = i;
#line 204 "worm.vala"
					if (!(_tmp2_ < erase_size)) {
#line 204 "worm.vala"
						break;
#line 975 "worm.c"
					}
#line 206 "worm.vala"
					_tmp3_ = self->priv->_list;
#line 206 "worm.vala"
					_tmp4_ = gee_linked_list_last (_tmp3_);
#line 206 "worm.vala"
					_tmp5_ = (Position*) _tmp4_;
#line 206 "worm.vala"
					_tmp6_ = (*_tmp5_).x;
#line 206 "worm.vala"
					_tmp7_ = self->priv->_list;
#line 206 "worm.vala"
					_tmp8_ = gee_linked_list_last (_tmp7_);
#line 206 "worm.vala"
					_tmp9_ = (Position*) _tmp8_;
#line 206 "worm.vala"
					_tmp10_ = (*_tmp9_).y;
#line 206 "worm.vala"
					board[(_tmp6_ * board_length2) + _tmp10_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 206 "worm.vala"
					_tmp11_ = board[(_tmp6_ * board_length2) + _tmp10_];
#line 206 "worm.vala"
					_position_free0 (_tmp9_);
#line 206 "worm.vala"
					_position_free0 (_tmp5_);
#line 207 "worm.vala"
					_tmp12_ = self->priv->_list;
#line 207 "worm.vala"
					_tmp13_ = gee_deque_poll_tail ((GeeDeque*) _tmp12_);
#line 207 "worm.vala"
					_tmp14_ = (Position*) _tmp13_;
#line 207 "worm.vala"
					_position_free0 (_tmp14_);
#line 1009 "worm.c"
				}
			}
		}
#line 209 "worm.vala"
		g_signal_emit (self, worm_signals[WORM_TAIL_REDUCED_SIGNAL], 0, erase_size);
#line 1015 "worm.c"
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 216 "worm.vala"
	return self ? g_object_ref (self) : NULL;
#line 1025 "worm.c"
}


void
worm_reverse (Worm* self,
              gint* board,
              int board_length1,
              int board_length2)
{
	GeeLinkedList* reversed_list = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp14_;
	GeeLinkedList* _tmp15_;
	gpointer _tmp16_;
	Position* _tmp17_;
	gint _tmp18_;
	GeeLinkedList* _tmp19_;
	gpointer _tmp20_;
	Position* _tmp21_;
	gint _tmp22_;
	gboolean _tmp23_;
#line 213 "worm.vala"
	g_return_if_fail (self != NULL);
#line 215 "worm.vala"
	_tmp0_ = gee_linked_list_new (TYPE_POSITION, (GBoxedCopyFunc) position_dup, (GDestroyNotify) position_free, NULL, NULL, NULL);
#line 215 "worm.vala"
	reversed_list = _tmp0_;
#line 1053 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pos_index = 0;
#line 216 "worm.vala"
		_tmp1_ = self->priv->_list;
#line 216 "worm.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 216 "worm.vala"
		_pos_list = _tmp2_;
#line 216 "worm.vala"
		_tmp3_ = _pos_list;
#line 216 "worm.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 216 "worm.vala"
		_tmp5_ = _tmp4_;
#line 216 "worm.vala"
		_pos_size = _tmp5_;
#line 216 "worm.vala"
		_pos_index = -1;
#line 216 "worm.vala"
		while (TRUE) {
#line 1081 "worm.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Position* pos = NULL;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			GeeLinkedList* _tmp12_;
			Position* _tmp13_;
#line 216 "worm.vala"
			_tmp6_ = _pos_index;
#line 216 "worm.vala"
			_pos_index = _tmp6_ + 1;
#line 216 "worm.vala"
			_tmp7_ = _pos_index;
#line 216 "worm.vala"
			_tmp8_ = _pos_size;
#line 216 "worm.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 216 "worm.vala"
				break;
#line 1103 "worm.c"
			}
#line 216 "worm.vala"
			_tmp9_ = _pos_list;
#line 216 "worm.vala"
			_tmp10_ = _pos_index;
#line 216 "worm.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 216 "worm.vala"
			pos = (Position*) _tmp11_;
#line 217 "worm.vala"
			_tmp12_ = reversed_list;
#line 217 "worm.vala"
			_tmp13_ = pos;
#line 217 "worm.vala"
			gee_deque_offer_head ((GeeDeque*) _tmp12_, _tmp13_);
#line 216 "worm.vala"
			_position_free0 (pos);
#line 1121 "worm.c"
		}
#line 216 "worm.vala"
		_g_object_unref0 (_pos_list);
#line 1125 "worm.c"
	}
#line 219 "worm.vala"
	g_signal_emit (self, worm_signals[WORM_REVERSED_SIGNAL], 0);
#line 220 "worm.vala"
	_tmp14_ = reversed_list;
#line 220 "worm.vala"
	worm_set_list (self, _tmp14_);
#line 223 "worm.vala"
	_tmp15_ = self->priv->_list;
#line 223 "worm.vala"
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, 0);
#line 223 "worm.vala"
	_tmp17_ = (Position*) _tmp16_;
#line 223 "worm.vala"
	_tmp18_ = (*_tmp17_).y;
#line 223 "worm.vala"
	_tmp19_ = self->priv->_list;
#line 223 "worm.vala"
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, 1);
#line 223 "worm.vala"
	_tmp21_ = (Position*) _tmp20_;
#line 223 "worm.vala"
	_tmp22_ = (*_tmp21_).y;
#line 223 "worm.vala"
	_tmp23_ = _tmp18_ == _tmp22_;
#line 223 "worm.vala"
	_position_free0 (_tmp21_);
#line 223 "worm.vala"
	_position_free0 (_tmp17_);
#line 223 "worm.vala"
	if (_tmp23_) {
#line 1157 "worm.c"
		WormDirection _tmp24_ = 0;
		GeeLinkedList* _tmp25_;
		gpointer _tmp26_;
		Position* _tmp27_;
		gint _tmp28_;
		GeeLinkedList* _tmp29_;
		gpointer _tmp30_;
		Position* _tmp31_;
		gint _tmp32_;
		gboolean _tmp33_;
#line 224 "worm.vala"
		_tmp25_ = self->priv->_list;
#line 224 "worm.vala"
		_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
#line 224 "worm.vala"
		_tmp27_ = (Position*) _tmp26_;
#line 224 "worm.vala"
		_tmp28_ = (*_tmp27_).x;
#line 224 "worm.vala"
		_tmp29_ = self->priv->_list;
#line 224 "worm.vala"
		_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, 1);
#line 224 "worm.vala"
		_tmp31_ = (Position*) _tmp30_;
#line 224 "worm.vala"
		_tmp32_ = (*_tmp31_).x;
#line 224 "worm.vala"
		_tmp33_ = _tmp28_ > _tmp32_;
#line 224 "worm.vala"
		_position_free0 (_tmp31_);
#line 224 "worm.vala"
		_position_free0 (_tmp27_);
#line 224 "worm.vala"
		if (_tmp33_) {
#line 224 "worm.vala"
			_tmp24_ = WORM_DIRECTION_RIGHT;
#line 1194 "worm.c"
		} else {
#line 224 "worm.vala"
			_tmp24_ = WORM_DIRECTION_LEFT;
#line 1198 "worm.c"
		}
#line 224 "worm.vala"
		self->direction = _tmp24_;
#line 1202 "worm.c"
	} else {
		WormDirection _tmp34_ = 0;
		GeeLinkedList* _tmp35_;
		gpointer _tmp36_;
		Position* _tmp37_;
		gint _tmp38_;
		GeeLinkedList* _tmp39_;
		gpointer _tmp40_;
		Position* _tmp41_;
		gint _tmp42_;
		gboolean _tmp43_;
#line 226 "worm.vala"
		_tmp35_ = self->priv->_list;
#line 226 "worm.vala"
		_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, 0);
#line 226 "worm.vala"
		_tmp37_ = (Position*) _tmp36_;
#line 226 "worm.vala"
		_tmp38_ = (*_tmp37_).y;
#line 226 "worm.vala"
		_tmp39_ = self->priv->_list;
#line 226 "worm.vala"
		_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, 1);
#line 226 "worm.vala"
		_tmp41_ = (Position*) _tmp40_;
#line 226 "worm.vala"
		_tmp42_ = (*_tmp41_).y;
#line 226 "worm.vala"
		_tmp43_ = _tmp38_ > _tmp42_;
#line 226 "worm.vala"
		_position_free0 (_tmp41_);
#line 226 "worm.vala"
		_position_free0 (_tmp37_);
#line 226 "worm.vala"
		if (_tmp43_) {
#line 226 "worm.vala"
			_tmp34_ = WORM_DIRECTION_DOWN;
#line 1240 "worm.c"
		} else {
#line 226 "worm.vala"
			_tmp34_ = WORM_DIRECTION_UP;
#line 1244 "worm.c"
		}
#line 226 "worm.vala"
		self->direction = _tmp34_;
#line 1248 "worm.c"
	}
#line 213 "worm.vala"
	_g_object_unref0 (reversed_list);
#line 1252 "worm.c"
}


void
worm_warp (Worm* self,
           Warp* warp)
{
	gint _tmp0_;
	gint _tmp1_;
	Position _tmp2_ = {0};
#line 229 "worm.vala"
	g_return_if_fail (self != NULL);
#line 229 "worm.vala"
	g_return_if_fail (warp != NULL);
#line 231 "worm.vala"
	_tmp0_ = warp->wx;
#line 231 "worm.vala"
	_tmp1_ = warp->wy;
#line 231 "worm.vala"
	memset (&_tmp2_, 0, sizeof (Position));
#line 231 "worm.vala"
	_tmp2_.x = _tmp0_;
#line 231 "worm.vala"
	_tmp2_.y = _tmp1_;
#line 231 "worm.vala"
	worm_set_head (self, &_tmp2_);
#line 1279 "worm.c"
}


gboolean
worm_can_move_to (Worm* self,
                  gint* board,
                  int board_length1,
                  int board_length2,
                  gint numworms)
{
	gboolean result = FALSE;
	Position position = {0};
	Position _tmp0_ = {0};
	gint next_position = 0;
	Position _tmp1_;
	gint _tmp2_;
	Position _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
#line 234 "worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 236 "worm.vala"
	worm_position_move (self, &_tmp0_);
#line 236 "worm.vala"
	position = _tmp0_;
#line 237 "worm.vala"
	_tmp1_ = position;
#line 237 "worm.vala"
	_tmp2_ = _tmp1_.x;
#line 237 "worm.vala"
	_tmp3_ = position;
#line 237 "worm.vala"
	_tmp4_ = _tmp3_.y;
#line 237 "worm.vala"
	_tmp5_ = board[(_tmp2_ * board_length2) + _tmp4_];
#line 237 "worm.vala"
	next_position = _tmp5_;
#line 239 "worm.vala"
	_tmp7_ = next_position;
#line 239 "worm.vala"
	if (_tmp7_ > ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 1325 "worm.c"
		gint _tmp8_;
#line 240 "worm.vala"
		_tmp8_ = next_position;
#line 240 "worm.vala"
		_tmp6_ = _tmp8_ < ((gint) NIBBLES_GAME_WORMCHAR);
#line 1331 "worm.c"
	} else {
#line 239 "worm.vala"
		_tmp6_ = FALSE;
#line 1335 "worm.c"
	}
#line 239 "worm.vala"
	if (_tmp6_) {
#line 241 "worm.vala"
		result = FALSE;
#line 241 "worm.vala"
		return result;
#line 1343 "worm.c"
	}
#line 243 "worm.vala"
	_tmp10_ = next_position;
#line 243 "worm.vala"
	if (_tmp10_ >= ((gint) NIBBLES_GAME_WORMCHAR)) {
#line 1349 "worm.c"
		gint _tmp11_;
#line 244 "worm.vala"
		_tmp11_ = next_position;
#line 244 "worm.vala"
		_tmp9_ = _tmp11_ < (NIBBLES_GAME_WORMCHAR + numworms);
#line 1355 "worm.c"
	} else {
#line 243 "worm.vala"
		_tmp9_ = FALSE;
#line 1359 "worm.c"
	}
#line 243 "worm.vala"
	if (_tmp9_) {
#line 1363 "worm.c"
		gboolean _tmp12_;
#line 245 "worm.vala"
		_tmp12_ = self->priv->_is_materialized;
#line 245 "worm.vala"
		result = !_tmp12_;
#line 245 "worm.vala"
		return result;
#line 1371 "worm.c"
	}
#line 247 "worm.vala"
	result = TRUE;
#line 247 "worm.vala"
	return result;
#line 1377 "worm.c"
}


static gboolean
_position_equal (const Position * s1,
                 const Position * s2)
{
#line 258 "worm.vala"
	if (s1 == s2) {
#line 258 "worm.vala"
		return TRUE;
#line 1389 "worm.c"
	}
#line 258 "worm.vala"
	if (s1 == NULL) {
#line 258 "worm.vala"
		return FALSE;
#line 1395 "worm.c"
	}
#line 258 "worm.vala"
	if (s2 == NULL) {
#line 258 "worm.vala"
		return FALSE;
#line 1401 "worm.c"
	}
#line 258 "worm.vala"
	if (s1->x != s2->x) {
#line 258 "worm.vala"
		return FALSE;
#line 1407 "worm.c"
	}
#line 258 "worm.vala"
	if (s1->y != s2->y) {
#line 258 "worm.vala"
		return FALSE;
#line 1413 "worm.c"
	}
#line 258 "worm.vala"
	return TRUE;
#line 1417 "worm.c"
}


gboolean
worm_will_collide_with_head (Worm* self,
                             Worm* other_worm)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	Position worm_pos = {0};
	Position _tmp3_ = {0};
	Position other_worm_pos = {0};
	Position _tmp4_ = {0};
	Position _tmp5_;
	Position _tmp6_;
#line 250 "worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 250 "worm.vala"
	g_return_val_if_fail (other_worm != NULL, FALSE);
#line 252 "worm.vala"
	_tmp1_ = self->priv->_is_materialized;
#line 252 "worm.vala"
	if (!_tmp1_) {
#line 252 "worm.vala"
		_tmp0_ = TRUE;
#line 1444 "worm.c"
	} else {
		gboolean _tmp2_;
#line 252 "worm.vala"
		_tmp2_ = other_worm->priv->_is_materialized;
#line 252 "worm.vala"
		_tmp0_ = !_tmp2_;
#line 1451 "worm.c"
	}
#line 252 "worm.vala"
	if (_tmp0_) {
#line 253 "worm.vala"
		result = FALSE;
#line 253 "worm.vala"
		return result;
#line 1459 "worm.c"
	}
#line 255 "worm.vala"
	worm_position_move (self, &_tmp3_);
#line 255 "worm.vala"
	worm_pos = _tmp3_;
#line 256 "worm.vala"
	worm_position_move (other_worm, &_tmp4_);
#line 256 "worm.vala"
	other_worm_pos = _tmp4_;
#line 258 "worm.vala"
	_tmp5_ = worm_pos;
#line 258 "worm.vala"
	_tmp6_ = other_worm_pos;
#line 258 "worm.vala"
	if (_position_equal (&_tmp5_, &_tmp6_) == TRUE) {
#line 259 "worm.vala"
		result = TRUE;
#line 259 "worm.vala"
		return result;
#line 1479 "worm.c"
	}
#line 261 "worm.vala"
	result = FALSE;
#line 261 "worm.vala"
	return result;
#line 1485 "worm.c"
}


void
worm_spawn (Worm* self,
            gint* board,
            int board_length1,
            int board_length2)
{
#line 264 "worm.vala"
	g_return_if_fail (self != NULL);
#line 266 "worm.vala"
	self->change = WORM_STARTING_LENGTH - 1;
#line 1499 "worm.c"
	{
		gint i = 0;
#line 267 "worm.vala"
		i = 0;
#line 1504 "worm.c"
		{
			gboolean _tmp0_ = FALSE;
#line 267 "worm.vala"
			_tmp0_ = TRUE;
#line 267 "worm.vala"
			while (TRUE) {
#line 1511 "worm.c"
				gint _tmp2_;
#line 267 "worm.vala"
				if (!_tmp0_) {
#line 1515 "worm.c"
					gint _tmp1_;
#line 267 "worm.vala"
					_tmp1_ = i;
#line 267 "worm.vala"
					i = _tmp1_ + 1;
#line 1521 "worm.c"
				}
#line 267 "worm.vala"
				_tmp0_ = FALSE;
#line 267 "worm.vala"
				_tmp2_ = i;
#line 267 "worm.vala"
				if (!(_tmp2_ < WORM_STARTING_LENGTH)) {
#line 267 "worm.vala"
					break;
#line 1531 "worm.c"
				}
#line 268 "worm.vala"
				worm_move (self, board, board_length1, board_length2);
#line 1535 "worm.c"
			}
		}
	}
}


static void
worm_materialize (Worm* self,
                  gint* board,
                  int board_length1,
                  int board_length2)
{
#line 271 "worm.vala"
	g_return_if_fail (self != NULL);
#line 1550 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pos_index = 0;
#line 273 "worm.vala"
		_tmp0_ = self->priv->_list;
#line 273 "worm.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 273 "worm.vala"
		_pos_list = _tmp1_;
#line 273 "worm.vala"
		_tmp2_ = _pos_list;
#line 273 "worm.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 273 "worm.vala"
		_tmp4_ = _tmp3_;
#line 273 "worm.vala"
		_pos_size = _tmp4_;
#line 273 "worm.vala"
		_pos_index = -1;
#line 273 "worm.vala"
		while (TRUE) {
#line 1578 "worm.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Position* pos = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Position* _tmp11_;
			gint _tmp12_;
			Position* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
#line 273 "worm.vala"
			_tmp5_ = _pos_index;
#line 273 "worm.vala"
			_pos_index = _tmp5_ + 1;
#line 273 "worm.vala"
			_tmp6_ = _pos_index;
#line 273 "worm.vala"
			_tmp7_ = _pos_size;
#line 273 "worm.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 273 "worm.vala"
				break;
#line 1603 "worm.c"
			}
#line 273 "worm.vala"
			_tmp8_ = _pos_list;
#line 273 "worm.vala"
			_tmp9_ = _pos_index;
#line 273 "worm.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 273 "worm.vala"
			pos = (Position*) _tmp10_;
#line 275 "worm.vala"
			_tmp11_ = pos;
#line 275 "worm.vala"
			_tmp12_ = (*_tmp11_).x;
#line 275 "worm.vala"
			_tmp13_ = pos;
#line 275 "worm.vala"
			_tmp14_ = (*_tmp13_).y;
#line 275 "worm.vala"
			_tmp15_ = board[(_tmp12_ * board_length2) + _tmp14_];
#line 275 "worm.vala"
			if (_tmp15_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 1625 "worm.c"
				gint _tmp16_;
#line 277 "worm.vala"
				_tmp16_ = self->priv->rounds_dematerialized;
#line 277 "worm.vala"
				self->priv->rounds_dematerialized = _tmp16_ + 1;
#line 278 "worm.vala"
				_position_free0 (pos);
#line 278 "worm.vala"
				_g_object_unref0 (_pos_list);
#line 278 "worm.vala"
				return;
#line 1637 "worm.c"
			}
#line 273 "worm.vala"
			_position_free0 (pos);
#line 1641 "worm.c"
		}
#line 273 "worm.vala"
		_g_object_unref0 (_pos_list);
#line 1645 "worm.c"
	}
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp17_;
		GeeLinkedList* _tmp18_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _pos_index = 0;
#line 281 "worm.vala"
		_tmp17_ = self->priv->_list;
#line 281 "worm.vala"
		_tmp18_ = _g_object_ref0 (_tmp17_);
#line 281 "worm.vala"
		_pos_list = _tmp18_;
#line 281 "worm.vala"
		_tmp19_ = _pos_list;
#line 281 "worm.vala"
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
#line 281 "worm.vala"
		_tmp21_ = _tmp20_;
#line 281 "worm.vala"
		_pos_size = _tmp21_;
#line 281 "worm.vala"
		_pos_index = -1;
#line 281 "worm.vala"
		while (TRUE) {
#line 1674 "worm.c"
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			Position* pos = NULL;
			GeeLinkedList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			Position* _tmp28_;
			gint _tmp29_;
			Position* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
#line 281 "worm.vala"
			_tmp22_ = _pos_index;
#line 281 "worm.vala"
			_pos_index = _tmp22_ + 1;
#line 281 "worm.vala"
			_tmp23_ = _pos_index;
#line 281 "worm.vala"
			_tmp24_ = _pos_size;
#line 281 "worm.vala"
			if (!(_tmp23_ < _tmp24_)) {
#line 281 "worm.vala"
				break;
#line 1700 "worm.c"
			}
#line 281 "worm.vala"
			_tmp25_ = _pos_list;
#line 281 "worm.vala"
			_tmp26_ = _pos_index;
#line 281 "worm.vala"
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_);
#line 281 "worm.vala"
			pos = (Position*) _tmp27_;
#line 282 "worm.vala"
			_tmp28_ = pos;
#line 282 "worm.vala"
			_tmp29_ = (*_tmp28_).x;
#line 282 "worm.vala"
			_tmp30_ = pos;
#line 282 "worm.vala"
			_tmp31_ = (*_tmp30_).y;
#line 282 "worm.vala"
			_tmp32_ = self->priv->_id;
#line 282 "worm.vala"
			board[(_tmp29_ * board_length2) + _tmp31_] = NIBBLES_GAME_WORMCHAR + _tmp32_;
#line 282 "worm.vala"
			_tmp33_ = board[(_tmp29_ * board_length2) + _tmp31_];
#line 281 "worm.vala"
			_position_free0 (pos);
#line 1726 "worm.c"
		}
#line 281 "worm.vala"
		_g_object_unref0 (_pos_list);
#line 1730 "worm.c"
	}
#line 283 "worm.vala"
	worm_set_is_materialized (self, TRUE);
#line 284 "worm.vala"
	self->priv->rounds_dematerialized = 0;
#line 1736 "worm.c"
}


void
worm_dematerialize (Worm* self,
                    gint* board,
                    int board_length1,
                    int board_length2,
                    gint rounds)
{
#line 287 "worm.vala"
	g_return_if_fail (self != NULL);
#line 289 "worm.vala"
	self->priv->rounds_dematerialized = rounds;
#line 290 "worm.vala"
	worm_set_is_materialized (self, FALSE);
#line 1753 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pos_index = 0;
#line 291 "worm.vala"
		_tmp0_ = self->priv->_list;
#line 291 "worm.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 291 "worm.vala"
		_pos_list = _tmp1_;
#line 291 "worm.vala"
		_tmp2_ = _pos_list;
#line 291 "worm.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 291 "worm.vala"
		_tmp4_ = _tmp3_;
#line 291 "worm.vala"
		_pos_size = _tmp4_;
#line 291 "worm.vala"
		_pos_index = -1;
#line 291 "worm.vala"
		while (TRUE) {
#line 1781 "worm.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Position* pos = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Position* _tmp11_;
			gint _tmp12_;
			Position* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
#line 291 "worm.vala"
			_tmp5_ = _pos_index;
#line 291 "worm.vala"
			_pos_index = _tmp5_ + 1;
#line 291 "worm.vala"
			_tmp6_ = _pos_index;
#line 291 "worm.vala"
			_tmp7_ = _pos_size;
#line 291 "worm.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 291 "worm.vala"
				break;
#line 1807 "worm.c"
			}
#line 291 "worm.vala"
			_tmp8_ = _pos_list;
#line 291 "worm.vala"
			_tmp9_ = _pos_index;
#line 291 "worm.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 291 "worm.vala"
			pos = (Position*) _tmp10_;
#line 293 "worm.vala"
			_tmp11_ = pos;
#line 293 "worm.vala"
			_tmp12_ = (*_tmp11_).x;
#line 293 "worm.vala"
			_tmp13_ = pos;
#line 293 "worm.vala"
			_tmp14_ = (*_tmp13_).y;
#line 293 "worm.vala"
			_tmp15_ = board[(_tmp12_ * board_length2) + _tmp14_];
#line 293 "worm.vala"
			_tmp16_ = self->priv->_id;
#line 293 "worm.vala"
			if (_tmp15_ == (NIBBLES_GAME_WORMCHAR + _tmp16_)) {
#line 1831 "worm.c"
				Position* _tmp17_;
				gint _tmp18_;
				Position* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
#line 294 "worm.vala"
				_tmp17_ = pos;
#line 294 "worm.vala"
				_tmp18_ = (*_tmp17_).x;
#line 294 "worm.vala"
				_tmp19_ = pos;
#line 294 "worm.vala"
				_tmp20_ = (*_tmp19_).y;
#line 294 "worm.vala"
				board[(_tmp18_ * board_length2) + _tmp20_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 294 "worm.vala"
				_tmp21_ = board[(_tmp18_ * board_length2) + _tmp20_];
#line 1849 "worm.c"
			}
#line 291 "worm.vala"
			_position_free0 (pos);
#line 1853 "worm.c"
		}
#line 291 "worm.vala"
		_g_object_unref0 (_pos_list);
#line 1857 "worm.c"
	}
}


void
worm_add_life (Worm* self)
{
	gint _tmp0_;
	gint _tmp1_;
#line 298 "worm.vala"
	g_return_if_fail (self != NULL);
#line 300 "worm.vala"
	_tmp0_ = self->priv->_lives;
#line 300 "worm.vala"
	if (_tmp0_ > WORM_MAX_LIVES) {
#line 301 "worm.vala"
		return;
#line 1875 "worm.c"
	}
#line 303 "worm.vala"
	_tmp1_ = self->priv->_lives;
#line 303 "worm.vala"
	worm_set_lives (self, _tmp1_ + 1);
#line 1881 "worm.c"
}


static void
worm_lose_life (Worm* self)
{
	gint _tmp0_;
#line 306 "worm.vala"
	g_return_if_fail (self != NULL);
#line 308 "worm.vala"
	_tmp0_ = self->priv->_lives;
#line 308 "worm.vala"
	worm_set_lives (self, _tmp0_ - 1);
#line 1895 "worm.c"
}


void
worm_reset (Worm* self,
            gint* board,
            int board_length1,
            int board_length2)
{
	GeeArrayQueue* _tmp0_;
	GeeLinkedList* _tmp17_;
	GeeLinkedList* _tmp18_;
	Position _tmp19_;
	WormDirection _tmp20_;
#line 311 "worm.vala"
	g_return_if_fail (self != NULL);
#line 313 "worm.vala"
	self->is_stopped = TRUE;
#line 314 "worm.vala"
	worm_set_is_materialized (self, FALSE);
#line 315 "worm.vala"
	self->priv->rounds_dematerialized = 0;
#line 317 "worm.vala"
	_tmp0_ = self->priv->key_queue;
#line 317 "worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 319 "worm.vala"
	worm_lose_life (self);
#line 321 "worm.vala"
	g_signal_emit (self, worm_signals[WORM_DIED_SIGNAL], 0);
#line 1926 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pos_index = 0;
#line 322 "worm.vala"
		_tmp1_ = self->priv->_list;
#line 322 "worm.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 322 "worm.vala"
		_pos_list = _tmp2_;
#line 322 "worm.vala"
		_tmp3_ = _pos_list;
#line 322 "worm.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 322 "worm.vala"
		_tmp5_ = _tmp4_;
#line 322 "worm.vala"
		_pos_size = _tmp5_;
#line 322 "worm.vala"
		_pos_index = -1;
#line 322 "worm.vala"
		while (TRUE) {
#line 1954 "worm.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Position* pos = NULL;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			Position* _tmp12_;
			gint _tmp13_;
			Position* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
#line 322 "worm.vala"
			_tmp6_ = _pos_index;
#line 322 "worm.vala"
			_pos_index = _tmp6_ + 1;
#line 322 "worm.vala"
			_tmp7_ = _pos_index;
#line 322 "worm.vala"
			_tmp8_ = _pos_size;
#line 322 "worm.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 322 "worm.vala"
				break;
#line 1979 "worm.c"
			}
#line 322 "worm.vala"
			_tmp9_ = _pos_list;
#line 322 "worm.vala"
			_tmp10_ = _pos_index;
#line 322 "worm.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 322 "worm.vala"
			pos = (Position*) _tmp11_;
#line 323 "worm.vala"
			_tmp12_ = pos;
#line 323 "worm.vala"
			_tmp13_ = (*_tmp12_).x;
#line 323 "worm.vala"
			_tmp14_ = pos;
#line 323 "worm.vala"
			_tmp15_ = (*_tmp14_).y;
#line 323 "worm.vala"
			board[(_tmp13_ * board_length2) + _tmp15_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 323 "worm.vala"
			_tmp16_ = board[(_tmp13_ * board_length2) + _tmp15_];
#line 322 "worm.vala"
			_position_free0 (pos);
#line 2003 "worm.c"
		}
#line 322 "worm.vala"
		_g_object_unref0 (_pos_list);
#line 2007 "worm.c"
	}
#line 325 "worm.vala"
	_tmp17_ = self->priv->_list;
#line 325 "worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp17_);
#line 326 "worm.vala"
	_tmp18_ = self->priv->_list;
#line 326 "worm.vala"
	_tmp19_ = self->priv->_starting_position;
#line 326 "worm.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, &_tmp19_);
#line 327 "worm.vala"
	g_signal_emit (self, worm_signals[WORM_ADDED_SIGNAL], 0);
#line 329 "worm.vala"
	_tmp20_ = self->starting_direction;
#line 329 "worm.vala"
	self->direction = _tmp20_;
#line 330 "worm.vala"
	self->change = 0;
#line 331 "worm.vala"
	worm_spawn (self, board, board_length1, board_length2);
#line 333 "worm.vala"
	g_signal_emit (self, worm_signals[WORM_FINISH_ADDED_SIGNAL], 0);
#line 2031 "worm.c"
}


static void
worm_position_move (Worm* self,
                    Position* result)
{
	Position position = {0};
	Position _tmp0_ = {0};
	Position _tmp1_;
	WormDirection _tmp2_;
#line 336 "worm.vala"
	g_return_if_fail (self != NULL);
#line 338 "worm.vala"
	worm_get_head (self, &_tmp0_);
#line 338 "worm.vala"
	_tmp1_ = _tmp0_;
#line 338 "worm.vala"
	position = _tmp1_;
#line 340 "worm.vala"
	_tmp2_ = self->direction;
#line 340 "worm.vala"
	switch (_tmp2_) {
#line 340 "worm.vala"
		case WORM_DIRECTION_UP:
#line 2057 "worm.c"
		{
			Position _tmp3_ = {0};
			Position _tmp4_;
			Position _tmp5_ = {0};
			Position _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Position _tmp9_;
			gint _tmp10_;
#line 343 "worm.vala"
			worm_get_head (self, &_tmp3_);
#line 343 "worm.vala"
			_tmp4_ = _tmp3_;
#line 343 "worm.vala"
			worm_get_head (self, &_tmp5_);
#line 343 "worm.vala"
			_tmp6_ = _tmp5_;
#line 343 "worm.vala"
			_tmp7_ = _tmp6_.y;
#line 343 "worm.vala"
			_tmp6_.y = _tmp7_ - 1;
#line 343 "worm.vala"
			_tmp8_ = _tmp6_.y;
#line 343 "worm.vala"
			position.y = _tmp8_;
#line 344 "worm.vala"
			_tmp9_ = position;
#line 344 "worm.vala"
			_tmp10_ = _tmp9_.y;
#line 344 "worm.vala"
			if (_tmp10_ < 0) {
#line 345 "worm.vala"
				position.y = NIBBLES_GAME_HEIGHT - 1;
#line 2091 "worm.c"
			}
#line 346 "worm.vala"
			break;
#line 2095 "worm.c"
		}
#line 340 "worm.vala"
		case WORM_DIRECTION_DOWN:
#line 2099 "worm.c"
		{
			Position _tmp11_ = {0};
			Position _tmp12_;
			Position _tmp13_ = {0};
			Position _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			Position _tmp17_;
			gint _tmp18_;
#line 348 "worm.vala"
			worm_get_head (self, &_tmp11_);
#line 348 "worm.vala"
			_tmp12_ = _tmp11_;
#line 348 "worm.vala"
			worm_get_head (self, &_tmp13_);
#line 348 "worm.vala"
			_tmp14_ = _tmp13_;
#line 348 "worm.vala"
			_tmp15_ = _tmp14_.y;
#line 348 "worm.vala"
			_tmp14_.y = _tmp15_ + 1;
#line 348 "worm.vala"
			_tmp16_ = _tmp14_.y;
#line 348 "worm.vala"
			position.y = _tmp16_;
#line 349 "worm.vala"
			_tmp17_ = position;
#line 349 "worm.vala"
			_tmp18_ = _tmp17_.y;
#line 349 "worm.vala"
			if (_tmp18_ >= NIBBLES_GAME_HEIGHT) {
#line 350 "worm.vala"
				position.y = 0;
#line 2133 "worm.c"
			}
#line 351 "worm.vala"
			break;
#line 2137 "worm.c"
		}
#line 340 "worm.vala"
		case WORM_DIRECTION_LEFT:
#line 2141 "worm.c"
		{
			Position _tmp19_ = {0};
			Position _tmp20_;
			Position _tmp21_ = {0};
			Position _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			Position _tmp25_;
			gint _tmp26_;
#line 353 "worm.vala"
			worm_get_head (self, &_tmp19_);
#line 353 "worm.vala"
			_tmp20_ = _tmp19_;
#line 353 "worm.vala"
			worm_get_head (self, &_tmp21_);
#line 353 "worm.vala"
			_tmp22_ = _tmp21_;
#line 353 "worm.vala"
			_tmp23_ = _tmp22_.x;
#line 353 "worm.vala"
			_tmp22_.x = _tmp23_ - 1;
#line 353 "worm.vala"
			_tmp24_ = _tmp22_.x;
#line 353 "worm.vala"
			position.x = _tmp24_;
#line 354 "worm.vala"
			_tmp25_ = position;
#line 354 "worm.vala"
			_tmp26_ = _tmp25_.x;
#line 354 "worm.vala"
			if (_tmp26_ < 0) {
#line 355 "worm.vala"
				position.x = NIBBLES_GAME_WIDTH - 1;
#line 2175 "worm.c"
			}
#line 356 "worm.vala"
			break;
#line 2179 "worm.c"
		}
#line 340 "worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 2183 "worm.c"
		{
			Position _tmp27_ = {0};
			Position _tmp28_;
			Position _tmp29_ = {0};
			Position _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			Position _tmp33_;
			gint _tmp34_;
#line 358 "worm.vala"
			worm_get_head (self, &_tmp27_);
#line 358 "worm.vala"
			_tmp28_ = _tmp27_;
#line 358 "worm.vala"
			worm_get_head (self, &_tmp29_);
#line 358 "worm.vala"
			_tmp30_ = _tmp29_;
#line 358 "worm.vala"
			_tmp31_ = _tmp30_.x;
#line 358 "worm.vala"
			_tmp30_.x = _tmp31_ + 1;
#line 358 "worm.vala"
			_tmp32_ = _tmp30_.x;
#line 358 "worm.vala"
			position.x = _tmp32_;
#line 359 "worm.vala"
			_tmp33_ = position;
#line 359 "worm.vala"
			_tmp34_ = _tmp33_.x;
#line 359 "worm.vala"
			if (_tmp34_ >= NIBBLES_GAME_WIDTH) {
#line 360 "worm.vala"
				position.x = 0;
#line 2217 "worm.c"
			}
#line 361 "worm.vala"
			break;
#line 2221 "worm.c"
		}
		default:
		{
#line 363 "worm.vala"
			break;
#line 2227 "worm.c"
		}
	}
#line 366 "worm.vala"
	*result = position;
#line 366 "worm.vala"
	return;
#line 2234 "worm.c"
}


static void
worm_direction_set (Worm* self,
                    WormDirection dir)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 369 "worm.vala"
	g_return_if_fail (self != NULL);
#line 371 "worm.vala"
	_tmp0_ = self->is_human;
#line 371 "worm.vala"
	if (!_tmp0_) {
#line 372 "worm.vala"
		return;
#line 2252 "worm.c"
	}
#line 374 "worm.vala"
	if (dir > 4) {
#line 375 "worm.vala"
		dir = (WormDirection) 1;
#line 2258 "worm.c"
	}
#line 376 "worm.vala"
	if (dir < 1) {
#line 377 "worm.vala"
		dir = (WormDirection) 4;
#line 2264 "worm.c"
	}
#line 379 "worm.vala"
	_tmp1_ = self->keypress;
#line 379 "worm.vala"
	if (_tmp1_) {
#line 381 "worm.vala"
		worm_queue_keypress (self, dir);
#line 382 "worm.vala"
		return;
#line 2274 "worm.c"
	}
#line 385 "worm.vala"
	self->direction = (WormDirection) dir;
#line 386 "worm.vala"
	self->keypress = TRUE;
#line 2280 "worm.c"
}


static guint
worm_upper_key (Worm* self,
                guint keyval)
{
	guint result = 0U;
#line 392 "worm.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 394 "worm.vala"
	if (keyval > ((guint) 255)) {
#line 395 "worm.vala"
		result = keyval;
#line 395 "worm.vala"
		return result;
#line 2297 "worm.c"
	}
#line 396 "worm.vala"
	result = (guint) g_ascii_toupper ((gchar) keyval);
#line 396 "worm.vala"
	return result;
#line 2303 "worm.c"
}


void
worm_handle_direction (Worm* self,
                       WormDirection dir)
{
#line 399 "worm.vala"
	g_return_if_fail (self != NULL);
#line 401 "worm.vala"
	worm_direction_set (self, dir);
#line 2315 "worm.c"
}


gboolean
worm_handle_keypress (Worm* self,
                      guint keyval,
                      GeeHashMap* worm_props)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	WormProperties properties = {0};
	guint propsUp = 0U;
	guint propsDown = 0U;
	guint propsLeft = 0U;
	guint propsRight = 0U;
	guint keyvalUpper = 0U;
	gpointer _tmp3_;
	WormProperties* _tmp4_;
	WormProperties _tmp5_;
	guint _tmp6_;
	WormProperties _tmp7_;
	guint _tmp8_;
	WormProperties _tmp9_;
	guint _tmp10_;
	WormProperties _tmp11_;
	guint _tmp12_;
	gboolean _tmp13_ = FALSE;
	guint _tmp14_;
	guint _tmp15_;
	gboolean _tmp17_ = FALSE;
	guint _tmp18_;
	guint _tmp19_;
	gboolean _tmp21_ = FALSE;
	guint _tmp22_;
	guint _tmp23_;
	gboolean _tmp25_ = FALSE;
	guint _tmp26_;
	guint _tmp27_;
#line 404 "worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 404 "worm.vala"
	g_return_val_if_fail (worm_props != NULL, FALSE);
#line 406 "worm.vala"
	_tmp1_ = self->priv->_lives;
#line 406 "worm.vala"
	if (_tmp1_ <= 0) {
#line 406 "worm.vala"
		_tmp0_ = TRUE;
#line 2365 "worm.c"
	} else {
		gboolean _tmp2_;
#line 406 "worm.vala"
		_tmp2_ = self->is_stopped;
#line 406 "worm.vala"
		_tmp0_ = _tmp2_;
#line 2372 "worm.c"
	}
#line 406 "worm.vala"
	if (_tmp0_) {
#line 407 "worm.vala"
		result = FALSE;
#line 407 "worm.vala"
		return result;
#line 2380 "worm.c"
	}
#line 412 "worm.vala"
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) worm_props, self);
#line 412 "worm.vala"
	_tmp4_ = (WormProperties*) _tmp3_;
#line 412 "worm.vala"
	properties = *_tmp4_;
#line 412 "worm.vala"
	_worm_properties_free0 (_tmp4_);
#line 413 "worm.vala"
	_tmp5_ = properties;
#line 413 "worm.vala"
	_tmp6_ = _tmp5_.up;
#line 413 "worm.vala"
	propsUp = worm_upper_key (self, _tmp6_);
#line 414 "worm.vala"
	_tmp7_ = properties;
#line 414 "worm.vala"
	_tmp8_ = _tmp7_.left;
#line 414 "worm.vala"
	propsLeft = worm_upper_key (self, _tmp8_);
#line 415 "worm.vala"
	_tmp9_ = properties;
#line 415 "worm.vala"
	_tmp10_ = _tmp9_.down;
#line 415 "worm.vala"
	propsDown = worm_upper_key (self, _tmp10_);
#line 416 "worm.vala"
	_tmp11_ = properties;
#line 416 "worm.vala"
	_tmp12_ = _tmp11_.right;
#line 416 "worm.vala"
	propsRight = worm_upper_key (self, _tmp12_);
#line 417 "worm.vala"
	keyvalUpper = worm_upper_key (self, keyval);
#line 419 "worm.vala"
	_tmp14_ = keyvalUpper;
#line 419 "worm.vala"
	_tmp15_ = propsUp;
#line 419 "worm.vala"
	if (_tmp14_ == _tmp15_) {
#line 2422 "worm.c"
		WormDirection _tmp16_;
#line 419 "worm.vala"
		_tmp16_ = self->direction;
#line 419 "worm.vala"
		_tmp13_ = _tmp16_ != WORM_DIRECTION_DOWN;
#line 2428 "worm.c"
	} else {
#line 419 "worm.vala"
		_tmp13_ = FALSE;
#line 2432 "worm.c"
	}
#line 419 "worm.vala"
	if (_tmp13_) {
#line 421 "worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_UP);
#line 422 "worm.vala"
		result = TRUE;
#line 422 "worm.vala"
		return result;
#line 2442 "worm.c"
	}
#line 424 "worm.vala"
	_tmp18_ = keyvalUpper;
#line 424 "worm.vala"
	_tmp19_ = propsDown;
#line 424 "worm.vala"
	if (_tmp18_ == _tmp19_) {
#line 2450 "worm.c"
		WormDirection _tmp20_;
#line 424 "worm.vala"
		_tmp20_ = self->direction;
#line 424 "worm.vala"
		_tmp17_ = _tmp20_ != WORM_DIRECTION_UP;
#line 2456 "worm.c"
	} else {
#line 424 "worm.vala"
		_tmp17_ = FALSE;
#line 2460 "worm.c"
	}
#line 424 "worm.vala"
	if (_tmp17_) {
#line 426 "worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_DOWN);
#line 427 "worm.vala"
		result = TRUE;
#line 427 "worm.vala"
		return result;
#line 2470 "worm.c"
	}
#line 429 "worm.vala"
	_tmp22_ = keyvalUpper;
#line 429 "worm.vala"
	_tmp23_ = propsRight;
#line 429 "worm.vala"
	if (_tmp22_ == _tmp23_) {
#line 2478 "worm.c"
		WormDirection _tmp24_;
#line 429 "worm.vala"
		_tmp24_ = self->direction;
#line 429 "worm.vala"
		_tmp21_ = _tmp24_ != WORM_DIRECTION_LEFT;
#line 2484 "worm.c"
	} else {
#line 429 "worm.vala"
		_tmp21_ = FALSE;
#line 2488 "worm.c"
	}
#line 429 "worm.vala"
	if (_tmp21_) {
#line 431 "worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_RIGHT);
#line 432 "worm.vala"
		result = TRUE;
#line 432 "worm.vala"
		return result;
#line 2498 "worm.c"
	}
#line 434 "worm.vala"
	_tmp26_ = keyvalUpper;
#line 434 "worm.vala"
	_tmp27_ = propsLeft;
#line 434 "worm.vala"
	if (_tmp26_ == _tmp27_) {
#line 2506 "worm.c"
		WormDirection _tmp28_;
#line 434 "worm.vala"
		_tmp28_ = self->direction;
#line 434 "worm.vala"
		_tmp25_ = _tmp28_ != WORM_DIRECTION_RIGHT;
#line 2512 "worm.c"
	} else {
#line 434 "worm.vala"
		_tmp25_ = FALSE;
#line 2516 "worm.c"
	}
#line 434 "worm.vala"
	if (_tmp25_) {
#line 436 "worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_LEFT);
#line 437 "worm.vala"
		result = TRUE;
#line 437 "worm.vala"
		return result;
#line 2526 "worm.c"
	}
#line 440 "worm.vala"
	result = FALSE;
#line 440 "worm.vala"
	return result;
#line 2532 "worm.c"
}


void
worm_queue_keypress (Worm* self,
                     WormDirection dir)
{
	gboolean _tmp0_ = FALSE;
	GeeArrayQueue* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeArrayQueue* _tmp6_;
#line 443 "worm.vala"
	g_return_if_fail (self != NULL);
#line 448 "worm.vala"
	_tmp1_ = self->priv->key_queue;
#line 448 "worm.vala"
	_tmp2_ = gee_array_queue_get_is_empty (_tmp1_);
#line 448 "worm.vala"
	_tmp3_ = _tmp2_;
#line 448 "worm.vala"
	if (!_tmp3_) {
#line 2555 "worm.c"
		GeeArrayQueue* _tmp4_;
		gpointer _tmp5_;
#line 448 "worm.vala"
		_tmp4_ = self->priv->key_queue;
#line 448 "worm.vala"
		_tmp5_ = gee_abstract_queue_peek ((GeeAbstractQueue*) _tmp4_);
#line 448 "worm.vala"
		_tmp0_ = dir == ((WormDirection) ((gintptr) _tmp5_));
#line 2564 "worm.c"
	} else {
#line 448 "worm.vala"
		_tmp0_ = FALSE;
#line 2568 "worm.c"
	}
#line 448 "worm.vala"
	if (_tmp0_) {
#line 449 "worm.vala"
		return;
#line 2574 "worm.c"
	}
#line 451 "worm.vala"
	_tmp6_ = self->priv->key_queue;
#line 451 "worm.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((gintptr) dir));
#line 2580 "worm.c"
}


void
worm_dequeue_keypress (Worm* self)
{
	GeeArrayQueue* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeArrayQueue* _tmp3_;
	gpointer _tmp4_;
#line 454 "worm.vala"
	g_return_if_fail (self != NULL);
#line 454 "worm.vala"
	_tmp0_ = self->priv->key_queue;
#line 454 "worm.vala"
	_tmp1_ = gee_array_queue_get_is_empty (_tmp0_);
#line 454 "worm.vala"
	_tmp2_ = _tmp1_;
#line 454 "worm.vala"
	_vala_return_if_fail (!_tmp2_, "!key_queue.is_empty");
#line 457 "worm.vala"
	_tmp3_ = self->priv->key_queue;
#line 457 "worm.vala"
	_tmp4_ = gee_abstract_queue_poll ((GeeAbstractQueue*) _tmp3_);
#line 457 "worm.vala"
	worm_direction_set (self, (WormDirection) ((gintptr) _tmp4_));
#line 2608 "worm.c"
}


static gint
worm_ai_deadend (gint* board,
                 int board_length1,
                 int board_length2,
                 gint numworms,
                 gint x,
                 gint y,
                 gint length_left)
{
	gint result = 0;
	gint cdir = 0;
	gint cx = 0;
	gint cy = 0;
#line 484 "worm.vala"
	if (x >= NIBBLES_GAME_WIDTH) {
#line 485 "worm.vala"
		x = 0;
#line 2629 "worm.c"
	}
#line 486 "worm.vala"
	if (x < 0) {
#line 487 "worm.vala"
		x = NIBBLES_GAME_WIDTH - 1;
#line 2635 "worm.c"
	}
#line 488 "worm.vala"
	if (y >= NIBBLES_GAME_HEIGHT) {
#line 489 "worm.vala"
		y = 0;
#line 2641 "worm.c"
	}
#line 490 "worm.vala"
	if (y < 0) {
#line 491 "worm.vala"
		y = NIBBLES_GAME_HEIGHT - 1;
#line 2647 "worm.c"
	}
#line 493 "worm.vala"
	if (length_left <= 0) {
#line 494 "worm.vala"
		result = 0;
#line 494 "worm.vala"
		return result;
#line 2655 "worm.c"
	}
#line 496 "worm.vala"
	cdir = 5;
#line 497 "worm.vala"
	while (TRUE) {
#line 2661 "worm.c"
		gint _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
#line 497 "worm.vala"
		_tmp0_ = cdir;
#line 497 "worm.vala"
		cdir = _tmp0_ - 1;
#line 497 "worm.vala"
		_tmp1_ = cdir;
#line 497 "worm.vala"
		if (!(_tmp1_ > 0)) {
#line 497 "worm.vala"
			break;
#line 2684 "worm.c"
		}
#line 499 "worm.vala"
		cx = x;
#line 500 "worm.vala"
		cy = y;
#line 501 "worm.vala"
		_tmp2_ = cdir;
#line 501 "worm.vala"
		switch (_tmp2_) {
#line 501 "worm.vala"
			case WORM_DIRECTION_UP:
#line 2696 "worm.c"
			{
				gint _tmp3_;
#line 504 "worm.vala"
				_tmp3_ = cy;
#line 504 "worm.vala"
				cy = _tmp3_ - 1;
#line 505 "worm.vala"
				break;
#line 2705 "worm.c"
			}
#line 501 "worm.vala"
			case WORM_DIRECTION_DOWN:
#line 2709 "worm.c"
			{
				gint _tmp4_;
#line 507 "worm.vala"
				_tmp4_ = cy;
#line 507 "worm.vala"
				cy = _tmp4_ + 1;
#line 508 "worm.vala"
				break;
#line 2718 "worm.c"
			}
#line 501 "worm.vala"
			case WORM_DIRECTION_LEFT:
#line 2722 "worm.c"
			{
				gint _tmp5_;
#line 510 "worm.vala"
				_tmp5_ = cx;
#line 510 "worm.vala"
				cx = _tmp5_ - 1;
#line 511 "worm.vala"
				break;
#line 2731 "worm.c"
			}
#line 501 "worm.vala"
			case WORM_DIRECTION_RIGHT:
#line 2735 "worm.c"
			{
				gint _tmp6_;
#line 513 "worm.vala"
				_tmp6_ = cx;
#line 513 "worm.vala"
				cx = _tmp6_ + 1;
#line 514 "worm.vala"
				break;
#line 2744 "worm.c"
			}
			default:
#line 501 "worm.vala"
			break;
#line 2749 "worm.c"
		}
#line 517 "worm.vala"
		_tmp7_ = cx;
#line 517 "worm.vala"
		if (_tmp7_ >= NIBBLES_GAME_WIDTH) {
#line 518 "worm.vala"
			cx = 0;
#line 2757 "worm.c"
		}
#line 519 "worm.vala"
		_tmp8_ = cx;
#line 519 "worm.vala"
		if (_tmp8_ < 0) {
#line 520 "worm.vala"
			cx = NIBBLES_GAME_WIDTH - 1;
#line 2765 "worm.c"
		}
#line 521 "worm.vala"
		_tmp9_ = cy;
#line 521 "worm.vala"
		if (_tmp9_ >= NIBBLES_GAME_HEIGHT) {
#line 522 "worm.vala"
			cy = 0;
#line 2773 "worm.c"
		}
#line 523 "worm.vala"
		_tmp10_ = cy;
#line 523 "worm.vala"
		if (_tmp10_ < 0) {
#line 524 "worm.vala"
			cy = NIBBLES_GAME_HEIGHT - 1;
#line 2781 "worm.c"
		}
#line 526 "worm.vala"
		_tmp13_ = cx;
#line 526 "worm.vala"
		_tmp14_ = cy;
#line 526 "worm.vala"
		_tmp15_ = board[(_tmp13_ * board_length2) + _tmp14_];
#line 526 "worm.vala"
		if (_tmp15_ <= ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 526 "worm.vala"
			_tmp12_ = TRUE;
#line 2793 "worm.c"
		} else {
			gint _tmp16_;
#line 527 "worm.vala"
			_tmp16_ = board[(x * board_length2) + y];
#line 527 "worm.vala"
			_tmp12_ = _tmp16_ >= ('z' + numworms);
#line 2800 "worm.c"
		}
#line 526 "worm.vala"
		if (_tmp12_) {
#line 2804 "worm.c"
			guint* _tmp17_;
			gint _tmp17__length1;
			gint _tmp17__length2;
			gint _tmp18_;
			gint _tmp19_;
			guint _tmp20_;
			guint _tmp21_;
#line 528 "worm.vala"
			_tmp17_ = worm_deadend_board;
#line 528 "worm.vala"
			_tmp17__length1 = worm_deadend_board_length1;
#line 528 "worm.vala"
			_tmp17__length2 = worm_deadend_board_length2;
#line 528 "worm.vala"
			_tmp18_ = cx;
#line 528 "worm.vala"
			_tmp19_ = cy;
#line 528 "worm.vala"
			_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
#line 528 "worm.vala"
			_tmp21_ = worm_deadend_runnumber;
#line 528 "worm.vala"
			_tmp11_ = _tmp20_ != _tmp21_;
#line 2828 "worm.c"
		} else {
#line 526 "worm.vala"
			_tmp11_ = FALSE;
#line 2832 "worm.c"
		}
#line 526 "worm.vala"
		if (_tmp11_) {
#line 2836 "worm.c"
			guint* _tmp22_;
			gint _tmp22__length1;
			gint _tmp22__length2;
			gint _tmp23_;
			gint _tmp24_;
			guint _tmp25_;
			guint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
#line 530 "worm.vala"
			_tmp22_ = worm_deadend_board;
#line 530 "worm.vala"
			_tmp22__length1 = worm_deadend_board_length1;
#line 530 "worm.vala"
			_tmp22__length2 = worm_deadend_board_length2;
#line 530 "worm.vala"
			_tmp23_ = cx;
#line 530 "worm.vala"
			_tmp24_ = cy;
#line 530 "worm.vala"
			_tmp25_ = worm_deadend_runnumber;
#line 530 "worm.vala"
			_tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_] = _tmp25_;
#line 530 "worm.vala"
			_tmp26_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
#line 531 "worm.vala"
			_tmp27_ = cx;
#line 531 "worm.vala"
			_tmp28_ = cy;
#line 531 "worm.vala"
			length_left = worm_ai_deadend (board, board_length1, board_length2, numworms, _tmp27_, _tmp28_, length_left - 1);
#line 532 "worm.vala"
			if (length_left <= 0) {
#line 533 "worm.vala"
				result = 0;
#line 533 "worm.vala"
				return result;
#line 2874 "worm.c"
			}
		}
	}
#line 537 "worm.vala"
	result = length_left;
#line 537 "worm.vala"
	return result;
#line 2882 "worm.c"
}


static gint
worm_ai_deadend_after (gint* board,
                       int board_length1,
                       int board_length2,
                       GeeLinkedList* worms,
                       gint numworms,
                       gint x,
                       gint y,
                       gint dir,
                       gint length)
{
	gint result = 0;
	gint cx = 0;
	gint cy = 0;
	gint cl = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	guint _tmp3_;
	gint _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	guint* _tmp52_;
	gint _tmp52__length1;
	gint _tmp52__length2;
	guint _tmp53_;
	guint _tmp54_;
	guint* _tmp55_;
	gint _tmp55__length1;
	gint _tmp55__length2;
	gint _tmp56_;
	gint _tmp57_;
	guint _tmp58_;
	guint _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
#line 549 "worm.vala"
	g_return_val_if_fail (worms != NULL, 0);
#line 553 "worm.vala"
	if (x < 0) {
#line 553 "worm.vala"
		_tmp2_ = TRUE;
#line 2932 "worm.c"
	} else {
#line 553 "worm.vala"
		_tmp2_ = x >= NIBBLES_GAME_WIDTH;
#line 2936 "worm.c"
	}
#line 553 "worm.vala"
	if (_tmp2_) {
#line 553 "worm.vala"
		_tmp1_ = TRUE;
#line 2942 "worm.c"
	} else {
#line 553 "worm.vala"
		_tmp1_ = y < 0;
#line 2946 "worm.c"
	}
#line 553 "worm.vala"
	if (_tmp1_) {
#line 553 "worm.vala"
		_tmp0_ = TRUE;
#line 2952 "worm.c"
	} else {
#line 553 "worm.vala"
		_tmp0_ = y >= NIBBLES_GAME_HEIGHT;
#line 2956 "worm.c"
	}
#line 553 "worm.vala"
	if (_tmp0_) {
#line 554 "worm.vala"
		result = 0;
#line 554 "worm.vala"
		return result;
#line 2964 "worm.c"
	}
#line 556 "worm.vala"
	_tmp3_ = worm_deadend_runnumber;
#line 556 "worm.vala"
	worm_deadend_runnumber = _tmp3_ + 1;
#line 558 "worm.vala"
	if (dir > 4) {
#line 559 "worm.vala"
		dir = 1;
#line 2974 "worm.c"
	}
#line 560 "worm.vala"
	if (dir < 1) {
#line 561 "worm.vala"
		dir = 4;
#line 2980 "worm.c"
	}
#line 563 "worm.vala"
	i = numworms;
#line 564 "worm.vala"
	while (TRUE) {
#line 2986 "worm.c"
		gint _tmp4_;
		gint _tmp5_;
		gpointer _tmp6_;
		Worm* _tmp7_;
		Position _tmp8_ = {0};
		Position _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gpointer _tmp12_;
		Worm* _tmp13_;
		Position _tmp14_ = {0};
		Position _tmp15_;
		gint _tmp16_;
		gboolean _tmp17_ = FALSE;
		gint _tmp18_;
#line 564 "worm.vala"
		_tmp4_ = i;
#line 564 "worm.vala"
		i = _tmp4_ - 1;
#line 564 "worm.vala"
		if (!(_tmp4_ > 0)) {
#line 564 "worm.vala"
			break;
#line 3010 "worm.c"
		}
#line 566 "worm.vala"
		_tmp5_ = i;
#line 566 "worm.vala"
		_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) worms, _tmp5_);
#line 566 "worm.vala"
		_tmp7_ = (Worm*) _tmp6_;
#line 566 "worm.vala"
		worm_get_head (_tmp7_, &_tmp8_);
#line 566 "worm.vala"
		_tmp9_ = _tmp8_;
#line 566 "worm.vala"
		_tmp10_ = _tmp9_.x;
#line 566 "worm.vala"
		cx = _tmp10_;
#line 566 "worm.vala"
		_g_object_unref0 (_tmp7_);
#line 567 "worm.vala"
		_tmp11_ = i;
#line 567 "worm.vala"
		_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) worms, _tmp11_);
#line 567 "worm.vala"
		_tmp13_ = (Worm*) _tmp12_;
#line 567 "worm.vala"
		worm_get_head (_tmp13_, &_tmp14_);
#line 567 "worm.vala"
		_tmp15_ = _tmp14_;
#line 567 "worm.vala"
		_tmp16_ = _tmp15_.y;
#line 567 "worm.vala"
		cy = _tmp16_;
#line 567 "worm.vala"
		_g_object_unref0 (_tmp13_);
#line 568 "worm.vala"
		_tmp18_ = cx;
#line 568 "worm.vala"
		if (_tmp18_ != x) {
#line 568 "worm.vala"
			_tmp17_ = TRUE;
#line 3050 "worm.c"
		} else {
			gint _tmp19_;
#line 568 "worm.vala"
			_tmp19_ = cy;
#line 568 "worm.vala"
			_tmp17_ = _tmp19_ != y;
#line 3057 "worm.c"
		}
#line 568 "worm.vala"
		if (_tmp17_) {
#line 3061 "worm.c"
			gint _tmp20_;
			gint _tmp26_;
			gint _tmp32_;
			gint _tmp38_;
#line 569 "worm.vala"
			_tmp20_ = cx;
#line 569 "worm.vala"
			if (_tmp20_ > 0) {
#line 3070 "worm.c"
				guint* _tmp21_;
				gint _tmp21__length1;
				gint _tmp21__length2;
				gint _tmp22_;
				gint _tmp23_;
				guint _tmp24_;
				guint _tmp25_;
#line 570 "worm.vala"
				_tmp21_ = worm_deadend_board;
#line 570 "worm.vala"
				_tmp21__length1 = worm_deadend_board_length1;
#line 570 "worm.vala"
				_tmp21__length2 = worm_deadend_board_length2;
#line 570 "worm.vala"
				_tmp22_ = cx;
#line 570 "worm.vala"
				_tmp23_ = cy;
#line 570 "worm.vala"
				_tmp24_ = worm_deadend_runnumber;
#line 570 "worm.vala"
				_tmp21_[((_tmp22_ - 1) * _tmp21__length2) + _tmp23_] = _tmp24_;
#line 570 "worm.vala"
				_tmp25_ = _tmp21_[((_tmp22_ - 1) * _tmp21__length2) + _tmp23_];
#line 3094 "worm.c"
			}
#line 571 "worm.vala"
			_tmp26_ = cy;
#line 571 "worm.vala"
			if (_tmp26_ > 0) {
#line 3100 "worm.c"
				guint* _tmp27_;
				gint _tmp27__length1;
				gint _tmp27__length2;
				gint _tmp28_;
				gint _tmp29_;
				guint _tmp30_;
				guint _tmp31_;
#line 572 "worm.vala"
				_tmp27_ = worm_deadend_board;
#line 572 "worm.vala"
				_tmp27__length1 = worm_deadend_board_length1;
#line 572 "worm.vala"
				_tmp27__length2 = worm_deadend_board_length2;
#line 572 "worm.vala"
				_tmp28_ = cx;
#line 572 "worm.vala"
				_tmp29_ = cy;
#line 572 "worm.vala"
				_tmp30_ = worm_deadend_runnumber;
#line 572 "worm.vala"
				_tmp27_[(_tmp28_ * _tmp27__length2) + (_tmp29_ - 1)] = _tmp30_;
#line 572 "worm.vala"
				_tmp31_ = _tmp27_[(_tmp28_ * _tmp27__length2) + (_tmp29_ - 1)];
#line 3124 "worm.c"
			}
#line 573 "worm.vala"
			_tmp32_ = cx;
#line 573 "worm.vala"
			if (_tmp32_ < (NIBBLES_GAME_WIDTH - 1)) {
#line 3130 "worm.c"
				guint* _tmp33_;
				gint _tmp33__length1;
				gint _tmp33__length2;
				gint _tmp34_;
				gint _tmp35_;
				guint _tmp36_;
				guint _tmp37_;
#line 574 "worm.vala"
				_tmp33_ = worm_deadend_board;
#line 574 "worm.vala"
				_tmp33__length1 = worm_deadend_board_length1;
#line 574 "worm.vala"
				_tmp33__length2 = worm_deadend_board_length2;
#line 574 "worm.vala"
				_tmp34_ = cx;
#line 574 "worm.vala"
				_tmp35_ = cy;
#line 574 "worm.vala"
				_tmp36_ = worm_deadend_runnumber;
#line 574 "worm.vala"
				_tmp33_[((_tmp34_ + 1) * _tmp33__length2) + _tmp35_] = _tmp36_;
#line 574 "worm.vala"
				_tmp37_ = _tmp33_[((_tmp34_ + 1) * _tmp33__length2) + _tmp35_];
#line 3154 "worm.c"
			}
#line 575 "worm.vala"
			_tmp38_ = cy;
#line 575 "worm.vala"
			if (_tmp38_ < (NIBBLES_GAME_HEIGHT - 1)) {
#line 3160 "worm.c"
				guint* _tmp39_;
				gint _tmp39__length1;
				gint _tmp39__length2;
				gint _tmp40_;
				gint _tmp41_;
				guint _tmp42_;
				guint _tmp43_;
#line 576 "worm.vala"
				_tmp39_ = worm_deadend_board;
#line 576 "worm.vala"
				_tmp39__length1 = worm_deadend_board_length1;
#line 576 "worm.vala"
				_tmp39__length2 = worm_deadend_board_length2;
#line 576 "worm.vala"
				_tmp40_ = cx;
#line 576 "worm.vala"
				_tmp41_ = cy;
#line 576 "worm.vala"
				_tmp42_ = worm_deadend_runnumber;
#line 576 "worm.vala"
				_tmp39_[(_tmp40_ * _tmp39__length2) + (_tmp41_ + 1)] = _tmp42_;
#line 576 "worm.vala"
				_tmp43_ = _tmp39_[(_tmp40_ * _tmp39__length2) + (_tmp41_ + 1)];
#line 3184 "worm.c"
			}
		}
	}
#line 580 "worm.vala"
	cx = x;
#line 581 "worm.vala"
	cy = y;
#line 582 "worm.vala"
	switch (dir) {
#line 582 "worm.vala"
		case WORM_DIRECTION_UP:
#line 3196 "worm.c"
		{
			gint _tmp44_;
#line 585 "worm.vala"
			_tmp44_ = cy;
#line 585 "worm.vala"
			cy = _tmp44_ - 1;
#line 586 "worm.vala"
			break;
#line 3205 "worm.c"
		}
#line 582 "worm.vala"
		case WORM_DIRECTION_DOWN:
#line 3209 "worm.c"
		{
			gint _tmp45_;
#line 588 "worm.vala"
			_tmp45_ = cy;
#line 588 "worm.vala"
			cy = _tmp45_ + 1;
#line 589 "worm.vala"
			break;
#line 3218 "worm.c"
		}
#line 582 "worm.vala"
		case WORM_DIRECTION_LEFT:
#line 3222 "worm.c"
		{
			gint _tmp46_;
#line 591 "worm.vala"
			_tmp46_ = cx;
#line 591 "worm.vala"
			cx = _tmp46_ - 1;
#line 592 "worm.vala"
			break;
#line 3231 "worm.c"
		}
#line 582 "worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 3235 "worm.c"
		{
			gint _tmp47_;
#line 594 "worm.vala"
			_tmp47_ = cx;
#line 594 "worm.vala"
			cx = _tmp47_ + 1;
#line 595 "worm.vala"
			break;
#line 3244 "worm.c"
		}
		default:
#line 582 "worm.vala"
		break;
#line 3249 "worm.c"
	}
#line 598 "worm.vala"
	_tmp48_ = cx;
#line 598 "worm.vala"
	if (_tmp48_ >= NIBBLES_GAME_WIDTH) {
#line 599 "worm.vala"
		cx = 0;
#line 3257 "worm.c"
	}
#line 600 "worm.vala"
	_tmp49_ = cx;
#line 600 "worm.vala"
	if (_tmp49_ < 0) {
#line 601 "worm.vala"
		cx = NIBBLES_GAME_WIDTH - 1;
#line 3265 "worm.c"
	}
#line 602 "worm.vala"
	_tmp50_ = cy;
#line 602 "worm.vala"
	if (_tmp50_ >= NIBBLES_GAME_HEIGHT) {
#line 603 "worm.vala"
		cy = 0;
#line 3273 "worm.c"
	}
#line 604 "worm.vala"
	_tmp51_ = cy;
#line 604 "worm.vala"
	if (_tmp51_ < 0) {
#line 605 "worm.vala"
		cy = NIBBLES_GAME_HEIGHT - 1;
#line 3281 "worm.c"
	}
#line 607 "worm.vala"
	_tmp52_ = worm_deadend_board;
#line 607 "worm.vala"
	_tmp52__length1 = worm_deadend_board_length1;
#line 607 "worm.vala"
	_tmp52__length2 = worm_deadend_board_length2;
#line 607 "worm.vala"
	_tmp53_ = worm_deadend_runnumber;
#line 607 "worm.vala"
	_tmp52_[(x * _tmp52__length2) + y] = _tmp53_;
#line 607 "worm.vala"
	_tmp54_ = _tmp52_[(x * _tmp52__length2) + y];
#line 608 "worm.vala"
	_tmp55_ = worm_deadend_board;
#line 608 "worm.vala"
	_tmp55__length1 = worm_deadend_board_length1;
#line 608 "worm.vala"
	_tmp55__length2 = worm_deadend_board_length2;
#line 608 "worm.vala"
	_tmp56_ = cx;
#line 608 "worm.vala"
	_tmp57_ = cy;
#line 608 "worm.vala"
	_tmp58_ = worm_deadend_runnumber;
#line 608 "worm.vala"
	_tmp55_[(_tmp56_ * _tmp55__length2) + _tmp57_] = _tmp58_;
#line 608 "worm.vala"
	_tmp59_ = _tmp55_[(_tmp56_ * _tmp55__length2) + _tmp57_];
#line 610 "worm.vala"
	cl = (length * length) / 16;
#line 611 "worm.vala"
	_tmp60_ = cl;
#line 611 "worm.vala"
	if (_tmp60_ < NIBBLES_GAME_WIDTH) {
#line 612 "worm.vala"
		cl = NIBBLES_GAME_WIDTH;
#line 3319 "worm.c"
	}
#line 613 "worm.vala"
	_tmp61_ = cx;
#line 613 "worm.vala"
	_tmp62_ = cy;
#line 613 "worm.vala"
	_tmp63_ = cl;
#line 613 "worm.vala"
	result = worm_ai_deadend (board, board_length1, board_length2, numworms, _tmp61_, _tmp62_, _tmp63_);
#line 613 "worm.vala"
	return result;
#line 3331 "worm.c"
}


static gboolean
worm_ai_too_close (Worm* self,
                   GeeLinkedList* worms,
                   gint numworms)
{
	gboolean result = FALSE;
	gint i = 0;
	gint dx = 0;
	gint dy = 0;
#line 620 "worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 620 "worm.vala"
	g_return_val_if_fail (worms != NULL, FALSE);
#line 622 "worm.vala"
	i = numworms;
#line 625 "worm.vala"
	while (TRUE) {
#line 3352 "worm.c"
		gint _tmp0_;
		Position _tmp1_ = {0};
		Position _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gpointer _tmp5_;
		Worm* _tmp6_;
		Position _tmp7_ = {0};
		Position _tmp8_;
		gint _tmp9_;
		Position _tmp10_ = {0};
		Position _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gpointer _tmp14_;
		Worm* _tmp15_;
		Position _tmp16_ = {0};
		Position _tmp17_;
		gint _tmp18_;
		WormDirection _tmp19_;
#line 625 "worm.vala"
		_tmp0_ = i;
#line 625 "worm.vala"
		i = _tmp0_ - 1;
#line 625 "worm.vala"
		if (!(_tmp0_ > 0)) {
#line 625 "worm.vala"
			break;
#line 3381 "worm.c"
		}
#line 627 "worm.vala"
		worm_get_head (self, &_tmp1_);
#line 627 "worm.vala"
		_tmp2_ = _tmp1_;
#line 627 "worm.vala"
		_tmp3_ = _tmp2_.x;
#line 627 "worm.vala"
		_tmp4_ = i;
#line 627 "worm.vala"
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) worms, _tmp4_);
#line 627 "worm.vala"
		_tmp6_ = (Worm*) _tmp5_;
#line 627 "worm.vala"
		worm_get_head (_tmp6_, &_tmp7_);
#line 627 "worm.vala"
		_tmp8_ = _tmp7_;
#line 627 "worm.vala"
		_tmp9_ = _tmp8_.x;
#line 627 "worm.vala"
		dx = _tmp3_ - _tmp9_;
#line 627 "worm.vala"
		_g_object_unref0 (_tmp6_);
#line 628 "worm.vala"
		worm_get_head (self, &_tmp10_);
#line 628 "worm.vala"
		_tmp11_ = _tmp10_;
#line 628 "worm.vala"
		_tmp12_ = _tmp11_.y;
#line 628 "worm.vala"
		_tmp13_ = i;
#line 628 "worm.vala"
		_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) worms, _tmp13_);
#line 628 "worm.vala"
		_tmp15_ = (Worm*) _tmp14_;
#line 628 "worm.vala"
		worm_get_head (_tmp15_, &_tmp16_);
#line 628 "worm.vala"
		_tmp17_ = _tmp16_;
#line 628 "worm.vala"
		_tmp18_ = _tmp17_.y;
#line 628 "worm.vala"
		dy = _tmp12_ - _tmp18_;
#line 628 "worm.vala"
		_g_object_unref0 (_tmp15_);
#line 629 "worm.vala"
		_tmp19_ = self->direction;
#line 629 "worm.vala"
		switch (_tmp19_) {
#line 629 "worm.vala"
			case WORM_DIRECTION_UP:
#line 3433 "worm.c"
			{
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_;
#line 632 "worm.vala"
				_tmp23_ = dy;
#line 632 "worm.vala"
				if (_tmp23_ > 0) {
#line 3443 "worm.c"
					gint _tmp24_;
#line 632 "worm.vala"
					_tmp24_ = dy;
#line 632 "worm.vala"
					_tmp22_ = _tmp24_ <= 3;
#line 3449 "worm.c"
				} else {
#line 632 "worm.vala"
					_tmp22_ = FALSE;
#line 3453 "worm.c"
				}
#line 632 "worm.vala"
				if (_tmp22_) {
#line 3457 "worm.c"
					gint _tmp25_;
#line 632 "worm.vala"
					_tmp25_ = dx;
#line 632 "worm.vala"
					_tmp21_ = _tmp25_ >= -1;
#line 3463 "worm.c"
				} else {
#line 632 "worm.vala"
					_tmp21_ = FALSE;
#line 3467 "worm.c"
				}
#line 632 "worm.vala"
				if (_tmp21_) {
#line 3471 "worm.c"
					gint _tmp26_;
#line 632 "worm.vala"
					_tmp26_ = dx;
#line 632 "worm.vala"
					_tmp20_ = _tmp26_ <= 1;
#line 3477 "worm.c"
				} else {
#line 632 "worm.vala"
					_tmp20_ = FALSE;
#line 3481 "worm.c"
				}
#line 632 "worm.vala"
				if (_tmp20_) {
#line 633 "worm.vala"
					result = TRUE;
#line 633 "worm.vala"
					return result;
#line 3489 "worm.c"
				}
#line 634 "worm.vala"
				break;
#line 3493 "worm.c"
			}
#line 629 "worm.vala"
			case WORM_DIRECTION_DOWN:
#line 3497 "worm.c"
			{
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				gint _tmp30_;
#line 636 "worm.vala"
				_tmp30_ = dy;
#line 636 "worm.vala"
				if (_tmp30_ < 0) {
#line 3507 "worm.c"
					gint _tmp31_;
#line 636 "worm.vala"
					_tmp31_ = dy;
#line 636 "worm.vala"
					_tmp29_ = _tmp31_ >= -3;
#line 3513 "worm.c"
				} else {
#line 636 "worm.vala"
					_tmp29_ = FALSE;
#line 3517 "worm.c"
				}
#line 636 "worm.vala"
				if (_tmp29_) {
#line 3521 "worm.c"
					gint _tmp32_;
#line 636 "worm.vala"
					_tmp32_ = dx;
#line 636 "worm.vala"
					_tmp28_ = _tmp32_ >= -1;
#line 3527 "worm.c"
				} else {
#line 636 "worm.vala"
					_tmp28_ = FALSE;
#line 3531 "worm.c"
				}
#line 636 "worm.vala"
				if (_tmp28_) {
#line 3535 "worm.c"
					gint _tmp33_;
#line 636 "worm.vala"
					_tmp33_ = dx;
#line 636 "worm.vala"
					_tmp27_ = _tmp33_ <= 1;
#line 3541 "worm.c"
				} else {
#line 636 "worm.vala"
					_tmp27_ = FALSE;
#line 3545 "worm.c"
				}
#line 636 "worm.vala"
				if (_tmp27_) {
#line 637 "worm.vala"
					result = TRUE;
#line 637 "worm.vala"
					return result;
#line 3553 "worm.c"
				}
#line 638 "worm.vala"
				break;
#line 3557 "worm.c"
			}
#line 629 "worm.vala"
			case WORM_DIRECTION_LEFT:
#line 3561 "worm.c"
			{
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_;
#line 640 "worm.vala"
				_tmp37_ = dx;
#line 640 "worm.vala"
				if (_tmp37_ > 0) {
#line 3571 "worm.c"
					gint _tmp38_;
#line 640 "worm.vala"
					_tmp38_ = dx;
#line 640 "worm.vala"
					_tmp36_ = _tmp38_ <= 3;
#line 3577 "worm.c"
				} else {
#line 640 "worm.vala"
					_tmp36_ = FALSE;
#line 3581 "worm.c"
				}
#line 640 "worm.vala"
				if (_tmp36_) {
#line 3585 "worm.c"
					gint _tmp39_;
#line 640 "worm.vala"
					_tmp39_ = dy;
#line 640 "worm.vala"
					_tmp35_ = _tmp39_ >= -1;
#line 3591 "worm.c"
				} else {
#line 640 "worm.vala"
					_tmp35_ = FALSE;
#line 3595 "worm.c"
				}
#line 640 "worm.vala"
				if (_tmp35_) {
#line 3599 "worm.c"
					gint _tmp40_;
#line 640 "worm.vala"
					_tmp40_ = dy;
#line 640 "worm.vala"
					_tmp34_ = _tmp40_ <= 1;
#line 3605 "worm.c"
				} else {
#line 640 "worm.vala"
					_tmp34_ = FALSE;
#line 3609 "worm.c"
				}
#line 640 "worm.vala"
				if (_tmp34_) {
#line 641 "worm.vala"
					result = TRUE;
#line 641 "worm.vala"
					return result;
#line 3617 "worm.c"
				}
#line 642 "worm.vala"
				break;
#line 3621 "worm.c"
			}
#line 629 "worm.vala"
			case WORM_DIRECTION_RIGHT:
#line 3625 "worm.c"
			{
				gboolean _tmp41_ = FALSE;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_ = FALSE;
				gint _tmp44_;
#line 644 "worm.vala"
				_tmp44_ = dx;
#line 644 "worm.vala"
				if (_tmp44_ < 0) {
#line 3635 "worm.c"
					gint _tmp45_;
#line 644 "worm.vala"
					_tmp45_ = dx;
#line 644 "worm.vala"
					_tmp43_ = _tmp45_ >= -3;
#line 3641 "worm.c"
				} else {
#line 644 "worm.vala"
					_tmp43_ = FALSE;
#line 3645 "worm.c"
				}
#line 644 "worm.vala"
				if (_tmp43_) {
#line 3649 "worm.c"
					gint _tmp46_;
#line 644 "worm.vala"
					_tmp46_ = dy;
#line 644 "worm.vala"
					_tmp42_ = _tmp46_ >= -1;
#line 3655 "worm.c"
				} else {
#line 644 "worm.vala"
					_tmp42_ = FALSE;
#line 3659 "worm.c"
				}
#line 644 "worm.vala"
				if (_tmp42_) {
#line 3663 "worm.c"
					gint _tmp47_;
#line 644 "worm.vala"
					_tmp47_ = dy;
#line 644 "worm.vala"
					_tmp41_ = _tmp47_ <= 1;
#line 3669 "worm.c"
				} else {
#line 644 "worm.vala"
					_tmp41_ = FALSE;
#line 3673 "worm.c"
				}
#line 644 "worm.vala"
				if (_tmp41_) {
#line 645 "worm.vala"
					result = TRUE;
#line 645 "worm.vala"
					return result;
#line 3681 "worm.c"
				}
#line 646 "worm.vala"
				break;
#line 3685 "worm.c"
			}
			default:
#line 629 "worm.vala"
			break;
#line 3690 "worm.c"
		}
	}
#line 650 "worm.vala"
	result = FALSE;
#line 650 "worm.vala"
	return result;
#line 3697 "worm.c"
}


static gboolean
worm_ai_wander (gint* board,
                int board_length1,
                int board_length2,
                gint numworms,
                gint x,
                gint y,
                gint dir,
                gint ox,
                gint oy)
{
	gboolean result = FALSE;
	gint _tmp0_;
#line 655 "worm.vala"
	if (dir > 4) {
#line 656 "worm.vala"
		dir = 1;
#line 3718 "worm.c"
	}
#line 657 "worm.vala"
	if (dir < 1) {
#line 658 "worm.vala"
		dir = 4;
#line 3724 "worm.c"
	}
#line 660 "worm.vala"
	switch (dir) {
#line 660 "worm.vala"
		case WORM_DIRECTION_UP:
#line 3730 "worm.c"
		{
#line 663 "worm.vala"
			y = y - 1;
#line 664 "worm.vala"
			break;
#line 3736 "worm.c"
		}
#line 660 "worm.vala"
		case WORM_DIRECTION_DOWN:
#line 3740 "worm.c"
		{
#line 666 "worm.vala"
			y = y + 1;
#line 667 "worm.vala"
			break;
#line 3746 "worm.c"
		}
#line 660 "worm.vala"
		case WORM_DIRECTION_LEFT:
#line 3750 "worm.c"
		{
#line 669 "worm.vala"
			x = x - 1;
#line 670 "worm.vala"
			break;
#line 3756 "worm.c"
		}
#line 660 "worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 3760 "worm.c"
		{
#line 672 "worm.vala"
			x = x + 1;
#line 673 "worm.vala"
			break;
#line 3766 "worm.c"
		}
		default:
#line 660 "worm.vala"
		break;
#line 3771 "worm.c"
	}
#line 676 "worm.vala"
	if (x >= NIBBLES_GAME_WIDTH) {
#line 677 "worm.vala"
		x = 0;
#line 3777 "worm.c"
	}
#line 678 "worm.vala"
	if (x < 0) {
#line 679 "worm.vala"
		x = NIBBLES_GAME_WIDTH - 1;
#line 3783 "worm.c"
	}
#line 680 "worm.vala"
	if (y >= NIBBLES_GAME_HEIGHT) {
#line 681 "worm.vala"
		y = 0;
#line 3789 "worm.c"
	}
#line 682 "worm.vala"
	if (y < 0) {
#line 683 "worm.vala"
		y = NIBBLES_GAME_HEIGHT - 1;
#line 3795 "worm.c"
	}
#line 685 "worm.vala"
	_tmp0_ = board[(x * board_length2) + y];
#line 685 "worm.vala"
	switch (_tmp0_ - 'A') {
#line 685 "worm.vala"
		case BONUS_TYPE_REGULAR:
#line 3803 "worm.c"
		{
#line 688 "worm.vala"
			result = TRUE;
#line 688 "worm.vala"
			return result;
#line 3809 "worm.c"
		}
#line 685 "worm.vala"
		case BONUS_TYPE_DOUBLE:
#line 3813 "worm.c"
		{
#line 690 "worm.vala"
			result = TRUE;
#line 690 "worm.vala"
			return result;
#line 3819 "worm.c"
		}
#line 685 "worm.vala"
		case BONUS_TYPE_LIFE:
#line 3823 "worm.c"
		{
#line 692 "worm.vala"
			result = TRUE;
#line 692 "worm.vala"
			return result;
#line 3829 "worm.c"
		}
#line 685 "worm.vala"
		case BONUS_TYPE_REVERSE:
#line 3833 "worm.c"
		{
#line 694 "worm.vala"
			result = TRUE;
#line 694 "worm.vala"
			return result;
#line 3839 "worm.c"
		}
#line 685 "worm.vala"
		case BONUS_TYPE_HALF:
#line 3843 "worm.c"
		{
#line 696 "worm.vala"
			result = FALSE;
#line 696 "worm.vala"
			return result;
#line 3849 "worm.c"
		}
		default:
		{
			gboolean _tmp1_ = FALSE;
			gint _tmp2_;
#line 698 "worm.vala"
			_tmp2_ = board[(x * board_length2) + y];
#line 698 "worm.vala"
			if (_tmp2_ > ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 3859 "worm.c"
				gint _tmp3_;
#line 699 "worm.vala"
				_tmp3_ = board[(x * board_length2) + y];
#line 699 "worm.vala"
				_tmp1_ = _tmp3_ < ('z' + numworms);
#line 3865 "worm.c"
			} else {
#line 698 "worm.vala"
				_tmp1_ = FALSE;
#line 3869 "worm.c"
			}
#line 698 "worm.vala"
			if (_tmp1_) {
#line 701 "worm.vala"
				result = FALSE;
#line 701 "worm.vala"
				return result;
#line 3877 "worm.c"
			} else {
				gboolean _tmp4_ = FALSE;
#line 705 "worm.vala"
				if (ox == x) {
#line 705 "worm.vala"
					_tmp4_ = oy == y;
#line 3884 "worm.c"
				} else {
#line 705 "worm.vala"
					_tmp4_ = FALSE;
#line 3888 "worm.c"
				}
#line 705 "worm.vala"
				if (_tmp4_) {
#line 706 "worm.vala"
					result = FALSE;
#line 706 "worm.vala"
					return result;
#line 3896 "worm.c"
				}
#line 708 "worm.vala"
				result = worm_ai_wander (board, board_length1, board_length2, numworms, x, y, dir, ox, oy);
#line 708 "worm.vala"
				return result;
#line 3902 "worm.c"
			}
		}
	}
}


void
worm_ai_move (Worm* self,
              gint* board,
              int board_length1,
              int board_length2,
              gint numworms,
              GeeLinkedList* worms)
{
	WormDirection opposite = 0;
	WormDirection _tmp0_;
	gboolean front = FALSE;
	Position _tmp1_ = {0};
	Position _tmp2_;
	gint _tmp3_;
	Position _tmp4_ = {0};
	Position _tmp5_;
	gint _tmp6_;
	WormDirection _tmp7_;
	Position _tmp8_ = {0};
	Position _tmp9_;
	gint _tmp10_;
	Position _tmp11_ = {0};
	Position _tmp12_;
	gint _tmp13_;
	gboolean left = FALSE;
	Position _tmp14_ = {0};
	Position _tmp15_;
	gint _tmp16_;
	Position _tmp17_ = {0};
	Position _tmp18_;
	gint _tmp19_;
	WormDirection _tmp20_;
	Position _tmp21_ = {0};
	Position _tmp22_;
	gint _tmp23_;
	Position _tmp24_ = {0};
	Position _tmp25_;
	gint _tmp26_;
	gboolean right = FALSE;
	Position _tmp27_ = {0};
	Position _tmp28_;
	gint _tmp29_;
	Position _tmp30_ = {0};
	Position _tmp31_;
	gint _tmp32_;
	WormDirection _tmp33_;
	Position _tmp34_ = {0};
	Position _tmp35_;
	gint _tmp36_;
	Position _tmp37_ = {0};
	Position _tmp38_;
	gint _tmp39_;
	gint dir = 0;
	gboolean _tmp40_;
	WormDirection old_dir = 0;
	WormDirection _tmp56_;
	gint best_yet = 0;
	gint best_dir = 0;
	gint this_len = 0;
	gint _tmp87_;
#line 714 "worm.vala"
	g_return_if_fail (self != NULL);
#line 714 "worm.vala"
	g_return_if_fail (worms != NULL);
#line 716 "worm.vala"
	_tmp0_ = self->direction;
#line 716 "worm.vala"
	opposite = ((_tmp0_ + 1) % 4) + 1;
#line 718 "worm.vala"
	worm_get_head (self, &_tmp1_);
#line 718 "worm.vala"
	_tmp2_ = _tmp1_;
#line 718 "worm.vala"
	_tmp3_ = _tmp2_.x;
#line 718 "worm.vala"
	worm_get_head (self, &_tmp4_);
#line 718 "worm.vala"
	_tmp5_ = _tmp4_;
#line 718 "worm.vala"
	_tmp6_ = _tmp5_.y;
#line 718 "worm.vala"
	_tmp7_ = self->direction;
#line 718 "worm.vala"
	worm_get_head (self, &_tmp8_);
#line 718 "worm.vala"
	_tmp9_ = _tmp8_;
#line 718 "worm.vala"
	_tmp10_ = _tmp9_.x;
#line 718 "worm.vala"
	worm_get_head (self, &_tmp11_);
#line 718 "worm.vala"
	_tmp12_ = _tmp11_;
#line 718 "worm.vala"
	_tmp13_ = _tmp12_.y;
#line 718 "worm.vala"
	front = worm_ai_wander (board, board_length1, board_length2, numworms, _tmp3_, _tmp6_, (gint) _tmp7_, _tmp10_, _tmp13_);
#line 719 "worm.vala"
	worm_get_head (self, &_tmp14_);
#line 719 "worm.vala"
	_tmp15_ = _tmp14_;
#line 719 "worm.vala"
	_tmp16_ = _tmp15_.x;
#line 719 "worm.vala"
	worm_get_head (self, &_tmp17_);
#line 719 "worm.vala"
	_tmp18_ = _tmp17_;
#line 719 "worm.vala"
	_tmp19_ = _tmp18_.y;
#line 719 "worm.vala"
	_tmp20_ = self->direction;
#line 719 "worm.vala"
	worm_get_head (self, &_tmp21_);
#line 719 "worm.vala"
	_tmp22_ = _tmp21_;
#line 719 "worm.vala"
	_tmp23_ = _tmp22_.x;
#line 719 "worm.vala"
	worm_get_head (self, &_tmp24_);
#line 719 "worm.vala"
	_tmp25_ = _tmp24_;
#line 719 "worm.vala"
	_tmp26_ = _tmp25_.y;
#line 719 "worm.vala"
	left = worm_ai_wander (board, board_length1, board_length2, numworms, _tmp16_, _tmp19_, (gint) (_tmp20_ - 1), _tmp23_, _tmp26_);
#line 720 "worm.vala"
	worm_get_head (self, &_tmp27_);
#line 720 "worm.vala"
	_tmp28_ = _tmp27_;
#line 720 "worm.vala"
	_tmp29_ = _tmp28_.x;
#line 720 "worm.vala"
	worm_get_head (self, &_tmp30_);
#line 720 "worm.vala"
	_tmp31_ = _tmp30_;
#line 720 "worm.vala"
	_tmp32_ = _tmp31_.y;
#line 720 "worm.vala"
	_tmp33_ = self->direction;
#line 720 "worm.vala"
	worm_get_head (self, &_tmp34_);
#line 720 "worm.vala"
	_tmp35_ = _tmp34_;
#line 720 "worm.vala"
	_tmp36_ = _tmp35_.x;
#line 720 "worm.vala"
	worm_get_head (self, &_tmp37_);
#line 720 "worm.vala"
	_tmp38_ = _tmp37_;
#line 720 "worm.vala"
	_tmp39_ = _tmp38_.y;
#line 720 "worm.vala"
	right = worm_ai_wander (board, board_length1, board_length2, numworms, _tmp29_, _tmp32_, (gint) (_tmp33_ + 1), _tmp36_, _tmp39_);
#line 723 "worm.vala"
	_tmp40_ = front;
#line 723 "worm.vala"
	if (!_tmp40_) {
#line 4065 "worm.c"
		gboolean _tmp41_;
#line 725 "worm.vala"
		_tmp41_ = left;
#line 725 "worm.vala"
		if (_tmp41_) {
#line 4071 "worm.c"
			WormDirection _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
#line 728 "worm.vala"
			_tmp42_ = self->direction;
#line 728 "worm.vala"
			dir = (gint) (_tmp42_ - 1);
#line 729 "worm.vala"
			_tmp43_ = dir;
#line 729 "worm.vala"
			if (_tmp43_ < 1) {
#line 730 "worm.vala"
				dir = 4;
#line 4085 "worm.c"
			}
#line 732 "worm.vala"
			_tmp44_ = dir;
#line 732 "worm.vala"
			self->direction = (WormDirection) _tmp44_;
#line 4091 "worm.c"
		} else {
			gboolean _tmp45_;
#line 734 "worm.vala"
			_tmp45_ = right;
#line 734 "worm.vala"
			if (_tmp45_) {
#line 4098 "worm.c"
				WormDirection _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
#line 737 "worm.vala"
				_tmp46_ = self->direction;
#line 737 "worm.vala"
				dir = (gint) (_tmp46_ + 1);
#line 738 "worm.vala"
				_tmp47_ = dir;
#line 738 "worm.vala"
				if (_tmp47_ > 4) {
#line 739 "worm.vala"
					dir = 1;
#line 4112 "worm.c"
				}
#line 741 "worm.vala"
				_tmp48_ = dir;
#line 741 "worm.vala"
				self->direction = (WormDirection) _tmp48_;
#line 4118 "worm.c"
			} else {
#line 746 "worm.vala"
				if (g_random_int_range ((gint32) 0, (gint32) 30) == ((gint32) 1)) {
#line 4122 "worm.c"
					gint _tmp49_ = 0;
					WormDirection _tmp50_;
					gint _tmp51_;
					WormDirection _tmp52_;
#line 748 "worm.vala"
					if (g_random_boolean ()) {
#line 748 "worm.vala"
						_tmp49_ = 1;
#line 4131 "worm.c"
					} else {
#line 748 "worm.vala"
						_tmp49_ = -1;
#line 4135 "worm.c"
					}
#line 748 "worm.vala"
					_tmp50_ = self->direction;
#line 748 "worm.vala"
					dir = (gint) (_tmp50_ + _tmp49_);
#line 749 "worm.vala"
					_tmp51_ = dir;
#line 749 "worm.vala"
					_tmp52_ = opposite;
#line 749 "worm.vala"
					if (_tmp51_ != ((gint) _tmp52_)) {
#line 4147 "worm.c"
						gint _tmp53_;
						gint _tmp54_;
						gint _tmp55_;
#line 751 "worm.vala"
						_tmp53_ = dir;
#line 751 "worm.vala"
						if (_tmp53_ > 4) {
#line 752 "worm.vala"
							dir = 1;
#line 4157 "worm.c"
						}
#line 753 "worm.vala"
						_tmp54_ = dir;
#line 753 "worm.vala"
						if (_tmp54_ < 1) {
#line 754 "worm.vala"
							dir = 4;
#line 4165 "worm.c"
						}
#line 756 "worm.vala"
						_tmp55_ = dir;
#line 756 "worm.vala"
						self->direction = (WormDirection) _tmp55_;
#line 4171 "worm.c"
					}
				}
			}
		}
	}
#line 773 "worm.vala"
	_tmp56_ = self->direction;
#line 773 "worm.vala"
	old_dir = _tmp56_;
#line 774 "worm.vala"
	best_yet = NIBBLES_GAME_CAPACITY * 2;
#line 775 "worm.vala"
	best_dir = -1;
#line 4185 "worm.c"
	{
		gboolean _tmp57_ = FALSE;
#line 778 "worm.vala"
		dir = 1;
#line 778 "worm.vala"
		_tmp57_ = TRUE;
#line 778 "worm.vala"
		while (TRUE) {
#line 4194 "worm.c"
			gint _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			WormDirection _tmp62_;
			gint _tmp65_;
			Position _tmp66_ = {0};
			Position _tmp67_;
			gint _tmp68_;
			Position _tmp69_ = {0};
			Position _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			gint _tmp74_;
			gint _tmp75_;
			gboolean _tmp76_ = FALSE;
			gint _tmp77_;
			WormDirection _tmp78_;
			gint _tmp81_;
			gint _tmp83_;
			gint _tmp84_;
#line 778 "worm.vala"
			if (!_tmp57_) {
#line 4218 "worm.c"
				gint _tmp58_;
#line 778 "worm.vala"
				_tmp58_ = dir;
#line 778 "worm.vala"
				dir = _tmp58_ + 1;
#line 4224 "worm.c"
			}
#line 778 "worm.vala"
			_tmp57_ = FALSE;
#line 778 "worm.vala"
			_tmp59_ = dir;
#line 778 "worm.vala"
			if (!(_tmp59_ <= 4)) {
#line 778 "worm.vala"
				break;
#line 4234 "worm.c"
			}
#line 780 "worm.vala"
			_tmp60_ = dir;
#line 780 "worm.vala"
			self->direction = (WormDirection) _tmp60_;
#line 782 "worm.vala"
			_tmp61_ = dir;
#line 782 "worm.vala"
			_tmp62_ = opposite;
#line 782 "worm.vala"
			if (_tmp61_ == ((gint) _tmp62_)) {
#line 783 "worm.vala"
				continue;
#line 4248 "worm.c"
			}
#line 784 "worm.vala"
			this_len = 0;
#line 786 "worm.vala"
			if (!worm_can_move_to (self, board, board_length1, board_length2, numworms)) {
#line 4254 "worm.c"
				gint _tmp63_;
#line 787 "worm.vala"
				_tmp63_ = this_len;
#line 787 "worm.vala"
				this_len = _tmp63_ + NIBBLES_GAME_CAPACITY;
#line 4260 "worm.c"
			}
#line 789 "worm.vala"
			if (worm_ai_too_close (self, worms, numworms)) {
#line 4264 "worm.c"
				gint _tmp64_;
#line 790 "worm.vala"
				_tmp64_ = this_len;
#line 790 "worm.vala"
				this_len = _tmp64_ + 4;
#line 4270 "worm.c"
			}
#line 792 "worm.vala"
			_tmp65_ = this_len;
#line 792 "worm.vala"
			worm_get_head (self, &_tmp66_);
#line 792 "worm.vala"
			_tmp67_ = _tmp66_;
#line 792 "worm.vala"
			_tmp68_ = _tmp67_.x;
#line 792 "worm.vala"
			worm_get_head (self, &_tmp69_);
#line 792 "worm.vala"
			_tmp70_ = _tmp69_;
#line 792 "worm.vala"
			_tmp71_ = _tmp70_.y;
#line 792 "worm.vala"
			_tmp72_ = dir;
#line 792 "worm.vala"
			_tmp73_ = worm_get_length (self);
#line 792 "worm.vala"
			_tmp74_ = _tmp73_;
#line 792 "worm.vala"
			_tmp75_ = self->change;
#line 792 "worm.vala"
			this_len = _tmp65_ + worm_ai_deadend_after (board, board_length1, board_length2, worms, numworms, _tmp68_, _tmp71_, _tmp72_, _tmp74_ + _tmp75_);
#line 794 "worm.vala"
			_tmp77_ = dir;
#line 794 "worm.vala"
			_tmp78_ = old_dir;
#line 794 "worm.vala"
			if (_tmp77_ == ((gint) _tmp78_)) {
#line 4302 "worm.c"
				gint _tmp79_;
#line 794 "worm.vala"
				_tmp79_ = this_len;
#line 794 "worm.vala"
				_tmp76_ = _tmp79_ <= 0;
#line 4308 "worm.c"
			} else {
#line 794 "worm.vala"
				_tmp76_ = FALSE;
#line 4312 "worm.c"
			}
#line 794 "worm.vala"
			if (_tmp76_) {
#line 4316 "worm.c"
				gint _tmp80_;
#line 795 "worm.vala"
				_tmp80_ = this_len;
#line 795 "worm.vala"
				this_len = _tmp80_ - 100;
#line 4322 "worm.c"
			}
#line 802 "worm.vala"
			_tmp81_ = this_len;
#line 802 "worm.vala"
			if (_tmp81_ <= 0) {
#line 4328 "worm.c"
				gint _tmp82_;
#line 803 "worm.vala"
				_tmp82_ = this_len;
#line 803 "worm.vala"
				this_len = _tmp82_ - g_random_int_range ((gint32) 0, (gint32) 100);
#line 4334 "worm.c"
			}
#line 804 "worm.vala"
			_tmp83_ = this_len;
#line 804 "worm.vala"
			_tmp84_ = best_yet;
#line 804 "worm.vala"
			if (_tmp83_ < _tmp84_) {
#line 4342 "worm.c"
				gint _tmp85_;
				gint _tmp86_;
#line 806 "worm.vala"
				_tmp85_ = this_len;
#line 806 "worm.vala"
				best_yet = _tmp85_;
#line 807 "worm.vala"
				_tmp86_ = dir;
#line 807 "worm.vala"
				best_dir = _tmp86_;
#line 4353 "worm.c"
			}
		}
	}
#line 811 "worm.vala"
	_tmp87_ = best_dir;
#line 811 "worm.vala"
	self->direction = (WormDirection) _tmp87_;
#line 4361 "worm.c"
	{
		gboolean _tmp88_ = FALSE;
#line 816 "worm.vala"
		dir = 1;
#line 816 "worm.vala"
		_tmp88_ = TRUE;
#line 816 "worm.vala"
		while (TRUE) {
#line 4370 "worm.c"
			gint _tmp90_;
			gint _tmp91_;
			WormDirection _tmp92_;
#line 816 "worm.vala"
			if (!_tmp88_) {
#line 4376 "worm.c"
				gint _tmp89_;
#line 816 "worm.vala"
				_tmp89_ = dir;
#line 816 "worm.vala"
				dir = _tmp89_ + 1;
#line 4382 "worm.c"
			}
#line 816 "worm.vala"
			_tmp88_ = FALSE;
#line 816 "worm.vala"
			_tmp90_ = dir;
#line 816 "worm.vala"
			if (!(_tmp90_ <= 4)) {
#line 816 "worm.vala"
				break;
#line 4392 "worm.c"
			}
#line 818 "worm.vala"
			_tmp91_ = dir;
#line 818 "worm.vala"
			_tmp92_ = opposite;
#line 818 "worm.vala"
			if (_tmp91_ == ((gint) _tmp92_)) {
#line 819 "worm.vala"
				continue;
#line 4402 "worm.c"
			}
#line 821 "worm.vala"
			if (!worm_can_move_to (self, board, board_length1, board_length2, numworms)) {
#line 4406 "worm.c"
				gint _tmp93_;
#line 822 "worm.vala"
				_tmp93_ = dir;
#line 822 "worm.vala"
				self->direction = (WormDirection) _tmp93_;
#line 4412 "worm.c"
			} else {
#line 824 "worm.vala"
				continue;
#line 4416 "worm.c"
			}
		}
	}
}


void
worm_get_starting_position (Worm* self,
                            Position * result)
{
	Position _tmp0_;
#line 54 "worm.vala"
	g_return_if_fail (self != NULL);
#line 54 "worm.vala"
	_tmp0_ = self->priv->_starting_position;
#line 54 "worm.vala"
	*result = _tmp0_;
#line 54 "worm.vala"
	return;
#line 4436 "worm.c"
}


static void
worm_set_starting_position (Worm* self,
                            Position * value)
{
	Position old_value;
#line 54 "worm.vala"
	g_return_if_fail (self != NULL);
#line 54 "worm.vala"
	if (_position_equal (value, (worm_get_starting_position (self, &old_value), &old_value)) != TRUE) {
#line 4449 "worm.c"
		Position _tmp0_;
#line 54 "worm.vala"
		_tmp0_ = *value;
#line 54 "worm.vala"
		self->priv->_starting_position = _tmp0_;
#line 54 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_STARTING_POSITION_PROPERTY]);
#line 4457 "worm.c"
	}
}


gint
worm_get_id (Worm* self)
{
	gint result;
	gint _tmp0_;
#line 56 "worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 56 "worm.vala"
	_tmp0_ = self->priv->_id;
#line 56 "worm.vala"
	result = _tmp0_;
#line 56 "worm.vala"
	return result;
#line 4475 "worm.c"
}


static void
worm_set_id (Worm* self,
             gint value)
{
#line 56 "worm.vala"
	g_return_if_fail (self != NULL);
#line 56 "worm.vala"
	if (worm_get_id (self) != value) {
#line 56 "worm.vala"
		self->priv->_id = value;
#line 56 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_ID_PROPERTY]);
#line 4491 "worm.c"
	}
}


gboolean
worm_get_is_materialized (Worm* self)
{
	gboolean result;
	gboolean _tmp0_;
#line 61 "worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "worm.vala"
	_tmp0_ = self->priv->_is_materialized;
#line 61 "worm.vala"
	result = _tmp0_;
#line 61 "worm.vala"
	return result;
#line 4509 "worm.c"
}


static void
worm_set_is_materialized (Worm* self,
                          gboolean value)
{
#line 61 "worm.vala"
	g_return_if_fail (self != NULL);
#line 61 "worm.vala"
	if (worm_get_is_materialized (self) != value) {
#line 61 "worm.vala"
		self->priv->_is_materialized = value;
#line 61 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_IS_MATERIALIZED_PROPERTY]);
#line 4525 "worm.c"
	}
}


gint
worm_get_lives (Worm* self)
{
	gint result;
	gint _tmp0_;
#line 64 "worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 64 "worm.vala"
	_tmp0_ = self->priv->_lives;
#line 64 "worm.vala"
	result = _tmp0_;
#line 64 "worm.vala"
	return result;
#line 4543 "worm.c"
}


void
worm_set_lives (Worm* self,
                gint value)
{
#line 64 "worm.vala"
	g_return_if_fail (self != NULL);
#line 64 "worm.vala"
	if (worm_get_lives (self) != value) {
#line 64 "worm.vala"
		self->priv->_lives = value;
#line 64 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_LIVES_PROPERTY]);
#line 4559 "worm.c"
	}
}


gint
worm_get_score (Worm* self)
{
	gint result;
	gint _tmp0_;
#line 66 "worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 66 "worm.vala"
	_tmp0_ = self->priv->_score;
#line 66 "worm.vala"
	result = _tmp0_;
#line 66 "worm.vala"
	return result;
#line 4577 "worm.c"
}


void
worm_set_score (Worm* self,
                gint value)
{
#line 66 "worm.vala"
	g_return_if_fail (self != NULL);
#line 66 "worm.vala"
	if (worm_get_score (self) != value) {
#line 66 "worm.vala"
		self->priv->_score = value;
#line 66 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_SCORE_PROPERTY]);
#line 4593 "worm.c"
	}
}


gint
worm_get_length (Worm* self)
{
	gint result;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 70 "worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 70 "worm.vala"
	_tmp0_ = self->priv->_list;
#line 70 "worm.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
#line 70 "worm.vala"
	_tmp2_ = _tmp1_;
#line 70 "worm.vala"
	result = _tmp2_;
#line 70 "worm.vala"
	return result;
#line 4617 "worm.c"
}


void
worm_set_length (Worm* self,
                 gint value)
{
#line 71 "worm.vala"
	g_return_if_fail (self != NULL);
#line 71 "worm.vala"
	g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_LENGTH_PROPERTY]);
#line 4629 "worm.c"
}


void
worm_get_head (Worm* self,
               Position * result)
{
	Position head = {0};
	GeeLinkedList* _tmp0_;
	gpointer _tmp1_;
	Position* _tmp2_;
	Position _tmp3_;
	Position _tmp4_;
#line 76 "worm.vala"
	g_return_if_fail (self != NULL);
#line 78 "worm.vala"
	_tmp0_ = self->priv->_list;
#line 78 "worm.vala"
	_tmp1_ = gee_linked_list_first (_tmp0_);
#line 78 "worm.vala"
	_tmp2_ = (Position*) _tmp1_;
#line 78 "worm.vala"
	_tmp3_ = *_tmp2_;
#line 78 "worm.vala"
	_position_free0 (_tmp2_);
#line 78 "worm.vala"
	head = _tmp3_;
#line 79 "worm.vala"
	_tmp4_ = head;
#line 79 "worm.vala"
	*result = _tmp4_;
#line 79 "worm.vala"
	return;
#line 4663 "worm.c"
}


static void
worm_set_head (Worm* self,
               Position * value)
{
	GeeLinkedList* _tmp0_;
	Position _tmp1_;
#line 81 "worm.vala"
	g_return_if_fail (self != NULL);
#line 83 "worm.vala"
	_tmp0_ = self->priv->_list;
#line 83 "worm.vala"
	_tmp1_ = *value;
#line 83 "worm.vala"
	gee_abstract_list_set ((GeeAbstractList*) _tmp0_, 0, &_tmp1_);
#line 81 "worm.vala"
	g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_HEAD_PROPERTY]);
#line 4683 "worm.c"
}


GeeLinkedList*
worm_get_list (Worm* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
#line 93 "worm.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "worm.vala"
	_tmp0_ = self->priv->_list;
#line 93 "worm.vala"
	result = _tmp0_;
#line 93 "worm.vala"
	return result;
#line 4700 "worm.c"
}


static void
worm_set_list (Worm* self,
               GeeLinkedList* value)
{
#line 93 "worm.vala"
	g_return_if_fail (self != NULL);
#line 93 "worm.vala"
	if (worm_get_list (self) != value) {
#line 4712 "worm.c"
		GeeLinkedList* _tmp0_;
#line 93 "worm.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 93 "worm.vala"
		_g_object_unref0 (self->priv->_list);
#line 93 "worm.vala"
		self->priv->_list = _tmp0_;
#line 93 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_LIST_PROPERTY]);
#line 4722 "worm.c"
	}
}


static void
worm_class_init (WormClass * klass)
{
	guint* _tmp0_;
#line 46 "worm.vala"
	worm_parent_class = g_type_class_peek_parent (klass);
#line 46 "worm.vala"
	g_type_class_adjust_private_offset (klass, &Worm_private_offset);
#line 46 "worm.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_worm_get_property;
#line 46 "worm.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_worm_set_property;
#line 46 "worm.vala"
	G_OBJECT_CLASS (klass)->finalize = worm_finalize;
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_STARTING_POSITION_PROPERTY, worm_properties[WORM_STARTING_POSITION_PROPERTY] = g_param_spec_boxed ("starting-position", "starting-position", "starting-position", TYPE_POSITION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_ID_PROPERTY, worm_properties[WORM_ID_PROPERTY] = g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_IS_MATERIALIZED_PROPERTY, worm_properties[WORM_IS_MATERIALIZED_PROPERTY] = g_param_spec_boolean ("is-materialized", "is-materialized", "is-materialized", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LIVES_PROPERTY, worm_properties[WORM_LIVES_PROPERTY] = g_param_spec_int ("lives", "lives", "lives", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_SCORE_PROPERTY, worm_properties[WORM_SCORE_PROPERTY] = g_param_spec_int ("score", "score", "score", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LENGTH_PROPERTY, worm_properties[WORM_LENGTH_PROPERTY] = g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_HEAD_PROPERTY, worm_properties[WORM_HEAD_PROPERTY] = g_param_spec_boxed ("head", "head", "head", TYPE_POSITION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LIST_PROPERTY, worm_properties[WORM_LIST_PROPERTY] = g_param_spec_object ("list", "list", "list", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 46 "worm.vala"
	worm_signals[WORM_ADDED_SIGNAL] = g_signal_new ("added", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_FINISH_ADDED_SIGNAL] = g_signal_new ("finish-added", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_RESCALED_SIGNAL] = g_signal_new ("rescaled", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 46 "worm.vala"
	worm_signals[WORM_DIED_SIGNAL] = g_signal_new ("died", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_TAIL_REDUCED_SIGNAL] = g_signal_new ("tail-reduced", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 46 "worm.vala"
	worm_signals[WORM_REVERSED_SIGNAL] = g_signal_new ("reversed", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_BONUS_FOUND_SIGNAL] = g_signal_new ("bonus-found", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_WARP_FOUND_SIGNAL] = g_signal_new ("warp-found", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 477 "worm.vala"
	_tmp0_ = g_new0 (guint, NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT);
#line 477 "worm.vala"
	worm_deadend_board = _tmp0_;
#line 477 "worm.vala"
	worm_deadend_board_length1 = NIBBLES_GAME_WIDTH;
#line 477 "worm.vala"
	worm_deadend_board_length2 = NIBBLES_GAME_HEIGHT;
#line 4783 "worm.c"
}


static void
worm_instance_init (Worm * self)
{
#line 46 "worm.vala"
	self->priv = worm_get_instance_private (self);
#line 59 "worm.vala"
	self->keypress = FALSE;
#line 60 "worm.vala"
	self->is_stopped = FALSE;
#line 61 "worm.vala"
	self->priv->_is_materialized = TRUE;
#line 4798 "worm.c"
}


static void
worm_finalize (GObject * obj)
{
	Worm * self;
#line 46 "worm.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WORM, Worm);
#line 91 "worm.vala"
	_g_object_unref0 (self->priv->key_queue);
#line 93 "worm.vala"
	_g_object_unref0 (self->priv->_list);
#line 46 "worm.vala"
	G_OBJECT_CLASS (worm_parent_class)->finalize (obj);
#line 4814 "worm.c"
}


GType
worm_get_type (void)
{
	static volatile gsize worm_type_id__volatile = 0;
	if (g_once_init_enter (&worm_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WormClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) worm_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Worm), 0, (GInstanceInitFunc) worm_instance_init, NULL };
		GType worm_type_id;
		worm_type_id = g_type_register_static (G_TYPE_OBJECT, "Worm", &g_define_type_info, 0);
		Worm_private_offset = g_type_add_instance_private (worm_type_id, sizeof (WormPrivate));
		g_once_init_leave (&worm_type_id__volatile, worm_type_id);
	}
	return worm_type_id__volatile;
}


static void
_vala_worm_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WORM, Worm);
#line 46 "worm.vala"
	switch (property_id) {
#line 46 "worm.vala"
		case WORM_STARTING_POSITION_PROPERTY:
#line 4845 "worm.c"
		{
			Position boxed;
#line 46 "worm.vala"
			worm_get_starting_position (self, &boxed);
#line 46 "worm.vala"
			g_value_set_boxed (value, &boxed);
#line 4852 "worm.c"
		}
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_ID_PROPERTY:
#line 46 "worm.vala"
		g_value_set_int (value, worm_get_id (self));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_IS_MATERIALIZED_PROPERTY:
#line 46 "worm.vala"
		g_value_set_boolean (value, worm_get_is_materialized (self));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LIVES_PROPERTY:
#line 46 "worm.vala"
		g_value_set_int (value, worm_get_lives (self));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_SCORE_PROPERTY:
#line 46 "worm.vala"
		g_value_set_int (value, worm_get_score (self));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LENGTH_PROPERTY:
#line 46 "worm.vala"
		g_value_set_int (value, worm_get_length (self));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_HEAD_PROPERTY:
#line 4888 "worm.c"
		{
			Position boxed;
#line 46 "worm.vala"
			worm_get_head (self, &boxed);
#line 46 "worm.vala"
			g_value_set_boxed (value, &boxed);
#line 4895 "worm.c"
		}
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LIST_PROPERTY:
#line 46 "worm.vala"
		g_value_set_object (value, worm_get_list (self));
#line 46 "worm.vala"
		break;
#line 4905 "worm.c"
		default:
#line 46 "worm.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 46 "worm.vala"
		break;
#line 4911 "worm.c"
	}
}


static void
_vala_worm_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WORM, Worm);
#line 46 "worm.vala"
	switch (property_id) {
#line 46 "worm.vala"
		case WORM_STARTING_POSITION_PROPERTY:
#line 46 "worm.vala"
		worm_set_starting_position (self, g_value_get_boxed (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_ID_PROPERTY:
#line 46 "worm.vala"
		worm_set_id (self, g_value_get_int (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_IS_MATERIALIZED_PROPERTY:
#line 46 "worm.vala"
		worm_set_is_materialized (self, g_value_get_boolean (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LIVES_PROPERTY:
#line 46 "worm.vala"
		worm_set_lives (self, g_value_get_int (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_SCORE_PROPERTY:
#line 46 "worm.vala"
		worm_set_score (self, g_value_get_int (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LENGTH_PROPERTY:
#line 46 "worm.vala"
		worm_set_length (self, g_value_get_int (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_HEAD_PROPERTY:
#line 46 "worm.vala"
		worm_set_head (self, g_value_get_boxed (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LIST_PROPERTY:
#line 46 "worm.vala"
		worm_set_list (self, g_value_get_object (value));
#line 46 "worm.vala"
		break;
#line 4974 "worm.c"
		default:
#line 46 "worm.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 46 "worm.vala"
		break;
#line 4980 "worm.c"
	}
}



