gopls/v0.16.0

```
go install golang.org/x/tools/gopls@v0.16.0
```

## Configuration Changes

- The experimental "allowImplicitNetworkAccess" setting is deprecated (but not
  yet removed). Please comment on https://go.dev/issue/66861 if you use this
  setting and would be impacted by its removal.

## New features

### Integrated documentation viewer

Gopls now offers a "View package documentation" code action that opens
a local web page displaying the generated documentation for the
current Go package in a form similar to https://pkg.go.dev.
The page will be initially scrolled to the documentation for the
declaration containing the cursor.
Use this feature to preview the marked-up documentation as you prepare API
changes, or to read the documentation for locally edited packages,
even ones that have not yet been saved. Reload the page after an edit
to see updated documentation.

TODO: demo in VS Code.

Clicking on the source-code link associated with a declaration will
cause your editor to navigate to the declaration.

TODO: demo of source linking.

Editor support:

- VS Code: use the `Source action > View package documentation` menu item.
  Note: source links navigate the editor but don't yet raise the window yet.
  Please upvote https://github.com/microsoft/vscode/issues/208093 and
  https://github.com/microsoft/vscode/issues/207634 (temporarily closed).

- Emacs: requires eglot v1.17. You may find this `go-doc` function a
  useful shortcut:

```lisp
(eglot--code-action eglot-code-action-doc "source.doc")

(defalias 'go-doc #'eglot-code-action-doc
  "View documentation for the current Go package.")
```

- TODO: test in vim, neovim, sublime, helix.

### Free symbols

Gopls offers another web-based code action, "Show free symbols",
which displays the free symbols referenced by the selected code.

A symbol is "free" if it is referenced within the selection but
declared outside of it. The free symbols that are variables are, in
effect, the set of parameters that would be needed if the block were
extracted into its own function in the same package.

Even when you don't intend to extract a block into a new function,
this information can help you to tell at a glance what names a block
of code depends on.

Each dotted path of identifiers (such as `file.Name.Pos`) is reported
as a separate item, so that you can see which parts of a complex
type are actually needed.

Viewing the free symbols of the body of a function may reveal that
only a small part (a single field of a struct, say) of one of the
function's parameters is used, allowing you to simplify and generalize
the function by choosing a different type for that parameter.

- TODO screenshot

- VS Code: use the `Source action > View free symbols` menu item.

- Emacs: requires eglot v1.17. You may find this `go-doc` function a
  useful shortcut:

```lisp
(eglot--code-action eglot-code-action-freesymbols "source.freesymbols")

(defalias 'go-freesymbols #'eglot-code-action-freesymbols
  "View free symbols referred to by the current selection.")
```
TODO(dominikh/go-mode.el#436): add both of these to go-mode.el.

### `unusedwrite` analyzer

The new
[unusedwrite](https://pkg.go.dev/golang.org/x/tools/go/analysis/passes/unusedwrite)
analyzer reports assignments, often to fields of structs, that have no
effect because, for example, the struct is never used again:

```go
func scheme(host string) string {
	u := &url.URL{
		Host:   host, // "unused write to field Host" (no need to construct a URL)
		Scheme: "https:",
	}
	return u.Scheme
}
```

This is at best an indication that the code is unnecessarily complex
(for instance, some dead code could be removed), but often indicates a
bug, as in this example:

```go
type S struct { x int }

func (s S) set(x int) {
	s.x = x // "unused write to field x" (s should be a *S pointer)
}
```

### Two more vet analyzers

The [framepointer](https://pkg.go.dev/golang.org/x/tools/go/analysis/passes/framepointer)
and [sigchanyzer](https://pkg.go.dev/golang.org/x/tools/go/analysis/passes/sigchanyzer)
analyzers have long been part of go vet's suite,
but had been overlooked in previous versions of gopls.

Henceforth, gopls will always include any analyzers run by vet.

### Hover shows size/offset info, and struct tags

TODO: consolidate release notes related to Hover improvements.

Hovering over the identifier that declares a type or struct field now
displays the size information for the type, and the offset information
for the field. In addition, it reports the percentage of wasted space
due to suboptimal ordering of struct fields, if this figure is 20% or
higher. This information may be helpful when making space
optimizations to your data structures, or when reading assembly code.

TODO: example hover image.

Hovering over a field with struct tags now also includes those tags.

TODO: example hover image

### Hover and definition on doc links

Go 1.19 added support for [links in doc
comments](https://go.dev/doc/comment#links), allowing the
documentation for one symbol to reference another:

TODO: turn the code below into a VS Code screenshot of hover.

```go
// Logf logs a message formatted in the manner of [fmt.Printf].
func Logf(format string, args ...any)
```

Gopls's Hover and Definition operations now treat these links just
like identifiers, so hovering over one will display information about
the symbol, and "Go to definition" will navigate to its declaration.
Thanks to @rogeryk for contributing this feature.


## Bugs fixed

## Thank you to our contributors!

@guodongli-google for the `unusedwrite` analyzer.
TODO: they're a xoogler; is there a more current GH account?

@rogeryk
