// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/tasks/v2beta2/target.proto

package tasks

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The HTTP method used to execute the task.
type HttpMethod int32

const (
	// HTTP method unspecified
	HttpMethod_HTTP_METHOD_UNSPECIFIED HttpMethod = 0
	// HTTP POST
	HttpMethod_POST HttpMethod = 1
	// HTTP GET
	HttpMethod_GET HttpMethod = 2
	// HTTP HEAD
	HttpMethod_HEAD HttpMethod = 3
	// HTTP PUT
	HttpMethod_PUT HttpMethod = 4
	// HTTP DELETE
	HttpMethod_DELETE HttpMethod = 5
)

var HttpMethod_name = map[int32]string{
	0: "HTTP_METHOD_UNSPECIFIED",
	1: "POST",
	2: "GET",
	3: "HEAD",
	4: "PUT",
	5: "DELETE",
}

var HttpMethod_value = map[string]int32{
	"HTTP_METHOD_UNSPECIFIED": 0,
	"POST":                    1,
	"GET":                     2,
	"HEAD":                    3,
	"PUT":                     4,
	"DELETE":                  5,
}

func (x HttpMethod) String() string {
	return proto.EnumName(HttpMethod_name, int32(x))
}

func (HttpMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ad20693261d55153, []int{0}
}

// Pull target.
type PullTarget struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PullTarget) Reset()         { *m = PullTarget{} }
func (m *PullTarget) String() string { return proto.CompactTextString(m) }
func (*PullTarget) ProtoMessage()    {}
func (*PullTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad20693261d55153, []int{0}
}

func (m *PullTarget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PullTarget.Unmarshal(m, b)
}
func (m *PullTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PullTarget.Marshal(b, m, deterministic)
}
func (m *PullTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PullTarget.Merge(m, src)
}
func (m *PullTarget) XXX_Size() int {
	return xxx_messageInfo_PullTarget.Size(m)
}
func (m *PullTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_PullTarget.DiscardUnknown(m)
}

var xxx_messageInfo_PullTarget proto.InternalMessageInfo

// The pull message contains data that can be used by the caller of
// [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] to process the task.
//
// This proto can only be used for tasks in a queue which has
// [pull_target][google.cloud.tasks.v2beta2.Queue.pull_target] set.
type PullMessage struct {
	// A data payload consumed by the worker to execute the task.
	Payload []byte `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	// The task's tag.
	//
	// Tags allow similar tasks to be processed in a batch. If you label
	// tasks with a tag, your worker can
	// [lease tasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] with the same tag using
	// [filter][google.cloud.tasks.v2beta2.LeaseTasksRequest.filter]. For example, if you want to
	// aggregate the events associated with a specific user once a day,
	// you could tag tasks with the user ID.
	//
	// The task's tag can only be set when the
	// [task is created][google.cloud.tasks.v2beta2.CloudTasks.CreateTask].
	//
	// The tag must be less than 500 characters.
	//
	// SDK compatibility: Although the SDK allows tags to be either
	// string or
	// [bytes](https://cloud.google.com/appengine/docs/standard/java/javadoc/com/google/appengine/api/taskqueue/TaskOptions.html#tag-byte:A-),
	// only UTF-8 encoded tags can be used in Cloud Tasks. If a tag isn't UTF-8
	// encoded, the tag will be empty when the task is returned by Cloud Tasks.
	Tag                  string   `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PullMessage) Reset()         { *m = PullMessage{} }
func (m *PullMessage) String() string { return proto.CompactTextString(m) }
func (*PullMessage) ProtoMessage()    {}
func (*PullMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad20693261d55153, []int{1}
}

func (m *PullMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PullMessage.Unmarshal(m, b)
}
func (m *PullMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PullMessage.Marshal(b, m, deterministic)
}
func (m *PullMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PullMessage.Merge(m, src)
}
func (m *PullMessage) XXX_Size() int {
	return xxx_messageInfo_PullMessage.Size(m)
}
func (m *PullMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_PullMessage.DiscardUnknown(m)
}

var xxx_messageInfo_PullMessage proto.InternalMessageInfo

func (m *PullMessage) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *PullMessage) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

// App Engine HTTP target.
//
// The task will be delivered to the App Engine application hostname
// specified by its [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget] and [AppEngineHttpRequest][google.cloud.tasks.v2beta2.AppEngineHttpRequest].
// The documentation for [AppEngineHttpRequest][google.cloud.tasks.v2beta2.AppEngineHttpRequest] explains how the
// task's host URL is constructed.
//
// Using [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget] requires
// [`appengine.applications.get`](https://cloud.google.com/appengine/docs/admin-api/access-control)
// Google IAM permission for the project
// and the following scope:
//
// `https://www.googleapis.com/auth/cloud-platform`
type AppEngineHttpTarget struct {
	// Overrides for the
	// [task-level app_engine_routing][google.cloud.tasks.v2beta2.AppEngineHttpRequest.app_engine_routing].
	//
	// If set, `app_engine_routing_override` is used for all tasks in
	// the queue, no matter what the setting is for the
	// [task-level app_engine_routing][google.cloud.tasks.v2beta2.AppEngineHttpRequest.app_engine_routing].
	AppEngineRoutingOverride *AppEngineRouting `protobuf:"bytes,1,opt,name=app_engine_routing_override,json=appEngineRoutingOverride,proto3" json:"app_engine_routing_override,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}          `json:"-"`
	XXX_unrecognized         []byte            `json:"-"`
	XXX_sizecache            int32             `json:"-"`
}

func (m *AppEngineHttpTarget) Reset()         { *m = AppEngineHttpTarget{} }
func (m *AppEngineHttpTarget) String() string { return proto.CompactTextString(m) }
func (*AppEngineHttpTarget) ProtoMessage()    {}
func (*AppEngineHttpTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad20693261d55153, []int{2}
}

func (m *AppEngineHttpTarget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppEngineHttpTarget.Unmarshal(m, b)
}
func (m *AppEngineHttpTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppEngineHttpTarget.Marshal(b, m, deterministic)
}
func (m *AppEngineHttpTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppEngineHttpTarget.Merge(m, src)
}
func (m *AppEngineHttpTarget) XXX_Size() int {
	return xxx_messageInfo_AppEngineHttpTarget.Size(m)
}
func (m *AppEngineHttpTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_AppEngineHttpTarget.DiscardUnknown(m)
}

var xxx_messageInfo_AppEngineHttpTarget proto.InternalMessageInfo

func (m *AppEngineHttpTarget) GetAppEngineRoutingOverride() *AppEngineRouting {
	if m != nil {
		return m.AppEngineRoutingOverride
	}
	return nil
}

// App Engine HTTP request.
//
// The message defines the HTTP request that is sent to an App Engine app when
// the task is dispatched.
//
// This proto can only be used for tasks in a queue which has
// [app_engine_http_target][google.cloud.tasks.v2beta2.Queue.app_engine_http_target] set.
//
// Using [AppEngineHttpRequest][google.cloud.tasks.v2beta2.AppEngineHttpRequest] requires
// [`appengine.applications.get`](https://cloud.google.com/appengine/docs/admin-api/access-control)
// Google IAM permission for the project
// and the following scope:
//
// `https://www.googleapis.com/auth/cloud-platform`
//
// The task will be delivered to the App Engine app which belongs to the same
// project as the queue. For more information, see
// [How Requests are
// Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
// and how routing is affected by
// [dispatch
// files](https://cloud.google.com/appengine/docs/python/config/dispatchref).
// Traffic is encrypted during transport and never leaves Google datacenters.
// Because this traffic is carried over a communication mechanism internal to
// Google, you cannot explicitly set the protocol (for example, HTTP or HTTPS).
// The request to the handler, however, will appear to have used the HTTP
// protocol.
//
// The [AppEngineRouting][google.cloud.tasks.v2beta2.AppEngineRouting] used to construct the URL that the task is
// delivered to can be set at the queue-level or task-level:
//
// * If set,
//    [app_engine_routing_override][google.cloud.tasks.v2beta2.AppEngineHttpTarget.app_engine_routing_override]
//    is used for all tasks in the queue, no matter what the setting
//    is for the
//    [task-level app_engine_routing][google.cloud.tasks.v2beta2.AppEngineHttpRequest.app_engine_routing].
//
//
// The `url` that the task will be sent to is:
//
// * `url =` [host][google.cloud.tasks.v2beta2.AppEngineRouting.host] `+`
//   [relative_url][google.cloud.tasks.v2beta2.AppEngineHttpRequest.relative_url]
//
// Tasks can be dispatched to secure app handlers, unsecure app handlers, and
// URIs restricted with
// [`login:
// admin`](https://cloud.google.com/appengine/docs/standard/python/config/appref).
// Because tasks are not run as any user, they cannot be dispatched to URIs
// restricted with
// [`login:
// required`](https://cloud.google.com/appengine/docs/standard/python/config/appref)
// Task dispatches also do not follow redirects.
//
// The task attempt has succeeded if the app's request handler returns an HTTP
// response code in the range [`200` - `299`]. The task attempt has failed if
// the app's handler returns a non-2xx response code or Cloud Tasks does
// not receive response before the [deadline][Task.dispatch_deadline]. Failed
// tasks will be retried according to the
// [retry configuration][google.cloud.tasks.v2beta2.Queue.retry_config]. `503` (Service Unavailable) is
// considered an App Engine system error instead of an application error and
// will cause Cloud Tasks' traffic congestion control to temporarily throttle
// the queue's dispatches. Unlike other types of task targets, a `429` (Too Many
// Requests) response from an app handler does not cause traffic congestion
// control to throttle the queue.
type AppEngineHttpRequest struct {
	// The HTTP method to use for the request. The default is POST.
	//
	// The app's request handler for the task's target URL must be able to handle
	// HTTP requests with this http_method, otherwise the task attempt will fail
	// with error code 405 (Method Not Allowed). See
	// [Writing a push task request
	// handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
	// and the documentation for the request handlers in the language your app is
	// written in e.g.
	// [Python Request
	// Handler](https://cloud.google.com/appengine/docs/python/tools/webapp/requesthandlerclass).
	HttpMethod HttpMethod `protobuf:"varint,1,opt,name=http_method,json=httpMethod,proto3,enum=google.cloud.tasks.v2beta2.HttpMethod" json:"http_method,omitempty"`
	// Task-level setting for App Engine routing.
	//
	// If set,
	// [app_engine_routing_override][google.cloud.tasks.v2beta2.AppEngineHttpTarget.app_engine_routing_override]
	// is used for all tasks in the queue, no matter what the setting is for the
	// [task-level app_engine_routing][google.cloud.tasks.v2beta2.AppEngineHttpRequest.app_engine_routing].
	AppEngineRouting *AppEngineRouting `protobuf:"bytes,2,opt,name=app_engine_routing,json=appEngineRouting,proto3" json:"app_engine_routing,omitempty"`
	// The relative URL.
	//
	// The relative URL must begin with "/" and must be a valid HTTP relative URL.
	// It can contain a path and query string arguments.
	// If the relative URL is empty, then the root path "/" will be used.
	// No spaces are allowed, and the maximum length allowed is 2083 characters.
	RelativeUrl string `protobuf:"bytes,3,opt,name=relative_url,json=relativeUrl,proto3" json:"relative_url,omitempty"`
	// HTTP request headers.
	//
	// This map contains the header field names and values.
	// Headers can be set when the
	// [task is created][google.cloud.tasks.v2beta2.CloudTasks.CreateTask].
	// Repeated headers are not supported but a header value can contain commas.
	//
	// Cloud Tasks sets some headers to default values:
	//
	// * `User-Agent`: By default, this header is
	//   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
	//   This header can be modified, but Cloud Tasks will append
	//   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
	//   modified `User-Agent`.
	//
	// If the task has a [payload][google.cloud.tasks.v2beta2.AppEngineHttpRequest.payload], Cloud
	// Tasks sets the following headers:
	//
	// * `Content-Type`: By default, the `Content-Type` header is set to
	//   `"application/octet-stream"`. The default can be overridden by explicitly
	//   setting `Content-Type` to a particular media type when the
	//   [task is created][google.cloud.tasks.v2beta2.CloudTasks.CreateTask].
	//   For example, `Content-Type` can be set to `"application/json"`.
	// * `Content-Length`: This is computed by Cloud Tasks. This value is
	//   output only.   It cannot be changed.
	//
	// The headers below cannot be set or overridden:
	//
	// * `Host`
	// * `X-Google-*`
	// * `X-AppEngine-*`
	//
	// In addition, Cloud Tasks sets some headers when the task is dispatched,
	// such as headers containing information about the task; see
	// [request
	// headers](https://cloud.google.com/appengine/docs/python/taskqueue/push/creating-handlers#reading_request_headers).
	// These headers are set only when the task is dispatched, so they are not
	// visible when the task is returned in a Cloud Tasks response.
	//
	// Although there is no specific limit for the maximum number of headers or
	// the size, there is a limit on the maximum size of the [Task][google.cloud.tasks.v2beta2.Task]. For more
	// information, see the [CreateTask][google.cloud.tasks.v2beta2.CloudTasks.CreateTask] documentation.
	Headers map[string]string `protobuf:"bytes,4,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Payload.
	//
	// The payload will be sent as the HTTP message body. A message
	// body, and thus a payload, is allowed only if the HTTP method is
	// POST or PUT. It is an error to set a data payload on a task with
	// an incompatible [HttpMethod][google.cloud.tasks.v2beta2.HttpMethod].
	Payload              []byte   `protobuf:"bytes,5,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppEngineHttpRequest) Reset()         { *m = AppEngineHttpRequest{} }
func (m *AppEngineHttpRequest) String() string { return proto.CompactTextString(m) }
func (*AppEngineHttpRequest) ProtoMessage()    {}
func (*AppEngineHttpRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad20693261d55153, []int{3}
}

func (m *AppEngineHttpRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppEngineHttpRequest.Unmarshal(m, b)
}
func (m *AppEngineHttpRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppEngineHttpRequest.Marshal(b, m, deterministic)
}
func (m *AppEngineHttpRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppEngineHttpRequest.Merge(m, src)
}
func (m *AppEngineHttpRequest) XXX_Size() int {
	return xxx_messageInfo_AppEngineHttpRequest.Size(m)
}
func (m *AppEngineHttpRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AppEngineHttpRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AppEngineHttpRequest proto.InternalMessageInfo

func (m *AppEngineHttpRequest) GetHttpMethod() HttpMethod {
	if m != nil {
		return m.HttpMethod
	}
	return HttpMethod_HTTP_METHOD_UNSPECIFIED
}

func (m *AppEngineHttpRequest) GetAppEngineRouting() *AppEngineRouting {
	if m != nil {
		return m.AppEngineRouting
	}
	return nil
}

func (m *AppEngineHttpRequest) GetRelativeUrl() string {
	if m != nil {
		return m.RelativeUrl
	}
	return ""
}

func (m *AppEngineHttpRequest) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *AppEngineHttpRequest) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

// App Engine Routing.
//
// Defines routing characteristics specific to App Engine - service, version,
// and instance.
//
// For more information about services, versions, and instances see
// [An Overview of App
// Engine](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine),
// [Microservices Architecture on Google App
// Engine](https://cloud.google.com/appengine/docs/python/microservices-on-app-engine),
// [App Engine Standard request
// routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed),
// and [App Engine Flex request
// routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
type AppEngineRouting struct {
	// App service.
	//
	// By default, the task is sent to the service which is the default
	// service when the task is attempted.
	//
	// For some queues or tasks which were created using the App Engine
	// Task Queue API, [host][google.cloud.tasks.v2beta2.AppEngineRouting.host] is not parsable
	// into [service][google.cloud.tasks.v2beta2.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2beta2.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2beta2.AppEngineRouting.instance]. For example, some tasks
	// which were created using the App Engine SDK use a custom domain
	// name; custom domains are not parsed by Cloud Tasks. If
	// [host][google.cloud.tasks.v2beta2.AppEngineRouting.host] is not parsable, then
	// [service][google.cloud.tasks.v2beta2.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2beta2.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2beta2.AppEngineRouting.instance] are the empty string.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// App version.
	//
	// By default, the task is sent to the version which is the default
	// version when the task is attempted.
	//
	// For some queues or tasks which were created using the App Engine
	// Task Queue API, [host][google.cloud.tasks.v2beta2.AppEngineRouting.host] is not parsable
	// into [service][google.cloud.tasks.v2beta2.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2beta2.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2beta2.AppEngineRouting.instance]. For example, some tasks
	// which were created using the App Engine SDK use a custom domain
	// name; custom domains are not parsed by Cloud Tasks. If
	// [host][google.cloud.tasks.v2beta2.AppEngineRouting.host] is not parsable, then
	// [service][google.cloud.tasks.v2beta2.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2beta2.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2beta2.AppEngineRouting.instance] are the empty string.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// App instance.
	//
	// By default, the task is sent to an instance which is available when
	// the task is attempted.
	//
	// Requests can only be sent to a specific instance if
	// [manual scaling is used in App Engine
	// Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
	// App Engine Flex does not support instances. For more information, see
	// [App Engine Standard request
	// routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
	// and [App Engine Flex request
	// routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
	Instance string `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	// Output only. The host that the task is sent to.
	//
	// For more information, see
	// [How Requests are
	// Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
	//
	// The host is constructed as:
	//
	//
	// * `host = [application_domain_name]`</br>
	//   `| [service] + '.' + [application_domain_name]`</br>
	//   `| [version] + '.' + [application_domain_name]`</br>
	//   `| [version_dot_service]+ '.' + [application_domain_name]`</br>
	//   `| [instance] + '.' + [application_domain_name]`</br>
	//   `| [instance_dot_service] + '.' + [application_domain_name]`</br>
	//   `| [instance_dot_version] + '.' + [application_domain_name]`</br>
	//   `| [instance_dot_version_dot_service] + '.' + [application_domain_name]`
	//
	// * `application_domain_name` = The domain name of the app, for
	//   example <app-id>.appspot.com, which is associated with the
	//   queue's project ID. Some tasks which were created using the App Engine
	//   SDK use a custom domain name.
	//
	// * `service =` [service][google.cloud.tasks.v2beta2.AppEngineRouting.service]
	//
	// * `version =` [version][google.cloud.tasks.v2beta2.AppEngineRouting.version]
	//
	// * `version_dot_service =`
	//   [version][google.cloud.tasks.v2beta2.AppEngineRouting.version] `+ '.' +`
	//   [service][google.cloud.tasks.v2beta2.AppEngineRouting.service]
	//
	// * `instance =` [instance][google.cloud.tasks.v2beta2.AppEngineRouting.instance]
	//
	// * `instance_dot_service =`
	//   [instance][google.cloud.tasks.v2beta2.AppEngineRouting.instance] `+ '.' +`
	//   [service][google.cloud.tasks.v2beta2.AppEngineRouting.service]
	//
	// * `instance_dot_version =`
	//   [instance][google.cloud.tasks.v2beta2.AppEngineRouting.instance] `+ '.' +`
	//   [version][google.cloud.tasks.v2beta2.AppEngineRouting.version]
	//
	// * `instance_dot_version_dot_service =`
	//   [instance][google.cloud.tasks.v2beta2.AppEngineRouting.instance] `+ '.' +`
	//   [version][google.cloud.tasks.v2beta2.AppEngineRouting.version] `+ '.' +`
	//   [service][google.cloud.tasks.v2beta2.AppEngineRouting.service]
	//
	// If [service][google.cloud.tasks.v2beta2.AppEngineRouting.service] is empty, then the task will be sent
	// to the service which is the default service when the task is attempted.
	//
	// If [version][google.cloud.tasks.v2beta2.AppEngineRouting.version] is empty, then the task will be sent
	// to the version which is the default version when the task is attempted.
	//
	// If [instance][google.cloud.tasks.v2beta2.AppEngineRouting.instance] is empty, then the task
	// will be sent to an instance which is available when the task is
	// attempted.
	//
	// If [service][google.cloud.tasks.v2beta2.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2beta2.AppEngineRouting.version], or
	// [instance][google.cloud.tasks.v2beta2.AppEngineRouting.instance] is invalid, then the task
	// will be sent to the default version of the default service when
	// the task is attempted.
	Host                 string   `protobuf:"bytes,4,opt,name=host,proto3" json:"host,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppEngineRouting) Reset()         { *m = AppEngineRouting{} }
func (m *AppEngineRouting) String() string { return proto.CompactTextString(m) }
func (*AppEngineRouting) ProtoMessage()    {}
func (*AppEngineRouting) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad20693261d55153, []int{4}
}

func (m *AppEngineRouting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppEngineRouting.Unmarshal(m, b)
}
func (m *AppEngineRouting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppEngineRouting.Marshal(b, m, deterministic)
}
func (m *AppEngineRouting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppEngineRouting.Merge(m, src)
}
func (m *AppEngineRouting) XXX_Size() int {
	return xxx_messageInfo_AppEngineRouting.Size(m)
}
func (m *AppEngineRouting) XXX_DiscardUnknown() {
	xxx_messageInfo_AppEngineRouting.DiscardUnknown(m)
}

var xxx_messageInfo_AppEngineRouting proto.InternalMessageInfo

func (m *AppEngineRouting) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *AppEngineRouting) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *AppEngineRouting) GetInstance() string {
	if m != nil {
		return m.Instance
	}
	return ""
}

func (m *AppEngineRouting) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.tasks.v2beta2.HttpMethod", HttpMethod_name, HttpMethod_value)
	proto.RegisterType((*PullTarget)(nil), "google.cloud.tasks.v2beta2.PullTarget")
	proto.RegisterType((*PullMessage)(nil), "google.cloud.tasks.v2beta2.PullMessage")
	proto.RegisterType((*AppEngineHttpTarget)(nil), "google.cloud.tasks.v2beta2.AppEngineHttpTarget")
	proto.RegisterType((*AppEngineHttpRequest)(nil), "google.cloud.tasks.v2beta2.AppEngineHttpRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.tasks.v2beta2.AppEngineHttpRequest.HeadersEntry")
	proto.RegisterType((*AppEngineRouting)(nil), "google.cloud.tasks.v2beta2.AppEngineRouting")
}

func init() {
	proto.RegisterFile("google/cloud/tasks/v2beta2/target.proto", fileDescriptor_ad20693261d55153)
}

var fileDescriptor_ad20693261d55153 = []byte{
	// 541 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x53, 0xdf, 0x8b, 0xd3, 0x4c,
	0x14, 0xfd, 0xb2, 0xe9, 0xfe, 0xba, 0x29, 0x1f, 0x61, 0x5c, 0x30, 0x74, 0x45, 0xd6, 0x3e, 0x68,
	0x11, 0x49, 0xa0, 0xbe, 0xe8, 0x8a, 0xc8, 0xae, 0x8d, 0xdb, 0x05, 0x6b, 0x43, 0x36, 0x45, 0x58,
	0x1f, 0xc2, 0x6c, 0x7b, 0x49, 0x43, 0xb3, 0x33, 0x71, 0x66, 0x12, 0xe8, 0xab, 0xef, 0xfe, 0xcf,
	0x92, 0x49, 0x5a, 0xbb, 0x55, 0x17, 0x7d, 0xbb, 0xe7, 0xe6, 0xdc, 0x33, 0x39, 0xe7, 0xce, 0xc0,
	0xb3, 0x84, 0xf3, 0x24, 0x43, 0x6f, 0x9a, 0xf1, 0x62, 0xe6, 0x29, 0x2a, 0x17, 0xd2, 0x2b, 0xfb,
	0x37, 0xa8, 0x68, 0xdf, 0x53, 0x54, 0x24, 0xa8, 0xdc, 0x5c, 0x70, 0xc5, 0x49, 0xa7, 0x26, 0xba,
	0x9a, 0xe8, 0x6a, 0xa2, 0xdb, 0x10, 0x3b, 0x8f, 0x1a, 0x11, 0x9a, 0xa7, 0x1e, 0x65, 0x8c, 0x2b,
	0xaa, 0x52, 0xce, 0x64, 0x3d, 0xd9, 0x6d, 0x03, 0x04, 0x45, 0x96, 0x45, 0x5a, 0xad, 0xfb, 0x1a,
	0xac, 0x0a, 0x8d, 0x50, 0x4a, 0x9a, 0x20, 0x71, 0x60, 0x3f, 0xa7, 0xcb, 0x8c, 0xd3, 0x99, 0x63,
	0x9c, 0x18, 0xbd, 0x76, 0xb8, 0x82, 0xc4, 0x06, 0x53, 0xd1, 0xc4, 0xd9, 0x39, 0x31, 0x7a, 0x87,
	0x61, 0x55, 0x76, 0xbf, 0x19, 0xf0, 0xe0, 0x2c, 0xcf, 0x7d, 0x96, 0xa4, 0x0c, 0x87, 0x4a, 0xe5,
	0xb5, 0x24, 0x59, 0xc0, 0x31, 0xcd, 0xf3, 0x18, 0x75, 0x3f, 0x16, 0xbc, 0x50, 0x29, 0x4b, 0x62,
	0x5e, 0xa2, 0x10, 0xe9, 0x0c, 0xb5, 0xae, 0xd5, 0x7f, 0xe1, 0xfe, 0xd9, 0x80, 0xbb, 0x56, 0x0d,
	0xeb, 0xe1, 0xd0, 0xa1, 0x5b, 0x9d, 0x71, 0xa3, 0xd6, 0xfd, 0x6e, 0xc2, 0xd1, 0x9d, 0x9f, 0x08,
	0xf1, 0x6b, 0x81, 0x52, 0x91, 0x0b, 0xb0, 0xe6, 0x4a, 0xe5, 0xf1, 0x2d, 0xaa, 0x39, 0xaf, 0xdd,
	0xfc, 0xdf, 0x7f, 0x7a, 0xdf, 0xa9, 0xd5, 0xf4, 0x48, 0xb3, 0x43, 0x98, 0xaf, 0x6b, 0x72, 0x0d,
	0xe4, 0x57, 0x3b, 0x3a, 0x87, 0x7f, 0x75, 0x61, 0x6f, 0xbb, 0x20, 0x4f, 0xa0, 0x2d, 0x30, 0xa3,
	0x2a, 0x2d, 0x31, 0x2e, 0x44, 0xe6, 0x98, 0x3a, 0x5d, 0x6b, 0xd5, 0x9b, 0x88, 0x8c, 0x7c, 0x86,
	0xfd, 0x39, 0xd2, 0x19, 0x0a, 0xe9, 0xb4, 0x4e, 0xcc, 0x9e, 0xd5, 0x7f, 0xfb, 0x57, 0x67, 0x6e,
	0x44, 0xe1, 0x0e, 0xeb, 0x79, 0x9f, 0x29, 0xb1, 0x0c, 0x57, 0x6a, 0x9b, 0xab, 0xde, 0xbd, 0xb3,
	0xea, 0xce, 0x29, 0xb4, 0x37, 0x47, 0xaa, 0xd5, 0x2f, 0x70, 0xa9, 0x23, 0x3c, 0x0c, 0xab, 0x92,
	0x1c, 0xc1, 0x6e, 0x49, 0xb3, 0x02, 0x9b, 0xeb, 0x50, 0x83, 0xd3, 0x9d, 0x57, 0x46, 0xb7, 0x04,
	0x7b, 0xdb, 0x77, 0x75, 0x92, 0x44, 0x51, 0xa6, 0x53, 0x6c, 0x34, 0x56, 0xb0, 0xfa, 0x52, 0xa2,
	0x90, 0x29, 0x67, 0x8d, 0xd2, 0x0a, 0x92, 0x0e, 0x1c, 0xa4, 0x4c, 0x2a, 0xca, 0xa6, 0xd8, 0xa4,
	0xb2, 0xc6, 0x84, 0x40, 0x6b, 0xce, 0xa5, 0x72, 0x5a, 0xba, 0xaf, 0xeb, 0xe7, 0x5f, 0x00, 0x7e,
	0xee, 0x8f, 0x1c, 0xc3, 0xc3, 0x61, 0x14, 0x05, 0xf1, 0xc8, 0x8f, 0x86, 0xe3, 0x41, 0x3c, 0xf9,
	0x74, 0x15, 0xf8, 0xef, 0x2f, 0x3f, 0x5c, 0xfa, 0x03, 0xfb, 0x3f, 0x72, 0x00, 0xad, 0x60, 0x7c,
	0x15, 0xd9, 0x06, 0xd9, 0x07, 0xf3, 0xc2, 0x8f, 0xec, 0x9d, 0xaa, 0x35, 0xf4, 0xcf, 0x06, 0xb6,
	0x59, 0xb5, 0x82, 0x49, 0x64, 0xb7, 0x08, 0xc0, 0xde, 0xc0, 0xff, 0xe8, 0x47, 0xbe, 0xbd, 0x7b,
	0x9e, 0xc3, 0xe3, 0x29, 0xbf, 0xbd, 0x27, 0xf7, 0x73, 0xab, 0xbe, 0xfb, 0x41, 0xf5, 0xc2, 0x02,
	0xe3, 0xfa, 0x5d, 0x43, 0x4d, 0x78, 0x46, 0x59, 0xe2, 0x72, 0x91, 0x78, 0x09, 0x32, 0xfd, 0xfe,
	0xbc, 0xfa, 0x13, 0xcd, 0x53, 0xf9, 0xbb, 0x57, 0xfe, 0x46, 0xa3, 0x9b, 0x3d, 0xcd, 0x7d, 0xf9,
	0x23, 0x00, 0x00, 0xff, 0xff, 0x7c, 0x8f, 0x47, 0xe7, 0x10, 0x04, 0x00, 0x00,
}
