/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 34 "../harp/libharp/harp-operation-parser.y" /* yacc.c:339  */


/* *INDENT-ON* */

/* Make parser independent from other parsers */
#define yyerror harp_operation_parser_error
#define yylex   harp_operation_parser_lex
#define yyparse harp_operation_parser_parse

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "harp-operation.h"
#include "harp-program.h"

static harp_program *parsed_program;

/* tokenizer declarations */
int harp_operation_parser_lex(void);
void *harp_operation_parser__scan_string(const char *yy_str);
void harp_operation_parser__delete_buffer(void *);

typedef struct harp_sized_array_struct
{
    harp_data_type data_type;
    int num_elements;
    harp_array array;
} harp_sized_array;

static void harp_operation_parser_error(const char *error)
{
    harp_set_error(HARP_ERROR_OPERATION_SYNTAX, "%s", error);
}

int harp_sized_array_new(harp_data_type data_type, harp_sized_array **new_array)
{
    harp_sized_array *sized_array;

    sized_array = (harp_sized_array *)malloc(sizeof(harp_sized_array));
    if (sized_array == NULL)
    {
        harp_set_error(HARP_ERROR_OUT_OF_MEMORY, "out of memory (could not allocate %lu bytes) (%s:%u)",
                       sizeof(harp_sized_array), __FILE__, __LINE__);
        return -1;
    }

    sized_array->data_type = data_type;
    sized_array->num_elements = 0;
    sized_array->array.ptr = NULL;

    *new_array = sized_array;

    return 0;
}

void harp_sized_array_delete(harp_sized_array *sized_array)
{
    if (sized_array->array.ptr != NULL)
    {
        if (sized_array->data_type == harp_type_string)
        {
            long i;

            for (i = 0; i < sized_array->num_elements; i++)
            {
                if (sized_array->array.string_data[i] != NULL)
                {
                    free(sized_array->array.string_data[i]);
                }
            }
        }
        free(sized_array->array.ptr);
    }
    free(sized_array);
}

int harp_sized_array_add_string(harp_sized_array *sized_array, const char *str)
{
    assert(sized_array->data_type == harp_type_string);

    if (sized_array->num_elements % BLOCK_SIZE == 0)
    {
        char **string_data;
        int new_num = (sized_array->num_elements + BLOCK_SIZE);

        string_data = (char **)realloc(sized_array->array.string_data, new_num * sizeof(char *));
        if (string_data == NULL)
        {
            harp_set_error(HARP_ERROR_OUT_OF_MEMORY, "out of memory (could not allocate %lu bytes) (%s:%u)",
                           new_num * sizeof(char *), __FILE__, __LINE__);
            return -1;
        }

        sized_array->array.string_data = string_data;
    }

    sized_array->array.string_data[sized_array->num_elements] = strdup(str);
    sized_array->num_elements++;

    return 0;
}

int harp_sized_array_add_double(harp_sized_array *sized_array, double value)
{
    assert(sized_array->data_type == harp_type_double);

    if (sized_array->num_elements % BLOCK_SIZE == 0)
    {
        double *double_data;
        int new_num = (sized_array->num_elements + BLOCK_SIZE);

        double_data = (double *)realloc(sized_array->array.double_data, new_num * sizeof(double));
        if (double_data == NULL)
        {
            harp_set_error(HARP_ERROR_OUT_OF_MEMORY, "out of memory (could not allocate %lu bytes) (%s:%u)",
                           new_num * sizeof(double), __FILE__, __LINE__);
            return -1;
        }

        sized_array->array.double_data = double_data;
    }

    sized_array->array.double_data[sized_array->num_elements] = value;
    sized_array->num_elements++;

    return 0;
}

int harp_sized_array_add_int32(harp_sized_array *sized_array, int32_t value)
{
    assert(sized_array->data_type == harp_type_int32);

    if (sized_array->num_elements % BLOCK_SIZE == 0)
    {
        int32_t *int32_data;
        int new_num = (sized_array->num_elements + BLOCK_SIZE);

        int32_data = (int32_t *)realloc(sized_array->array.int32_data, new_num * sizeof(int32_t));
        if (int32_data == NULL)
        {
            harp_set_error(HARP_ERROR_OUT_OF_MEMORY, "out of memory (could not allocate %lu bytes) (%s:%u)",
                           new_num * sizeof(int32_t), __FILE__, __LINE__);
            return -1;
        }

        sized_array->array.int32_data = int32_data;
    }

    sized_array->array.int32_data[sized_array->num_elements] = value;
    sized_array->num_elements++;

    return 0;
}

/* *INDENT-OFF* */


#line 229 "libharp/harp-operation-parser.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_LIBHARP_HARP_OPERATION_PARSER_H_INCLUDED
# define YY_YY_LIBHARP_HARP_OPERATION_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    NAME = 258,
    STRING_VALUE = 259,
    INTEGER_VALUE = 260,
    DOUBLE_VALUE = 261,
    DATATYPE = 262,
    DIMENSION = 263,
    UNIT = 264,
    ID_A = 265,
    ID_B = 266,
    FUNC_AREA_COVERS_AREA = 267,
    FUNC_AREA_COVERS_POINT = 268,
    FUNC_AREA_INSIDE_AREA = 269,
    FUNC_AREA_INTERSECTS_AREA = 270,
    FUNC_BIN = 271,
    FUNC_BIN_SPATIAL = 272,
    FUNC_CLAMP = 273,
    FUNC_COLLOCATE_LEFT = 274,
    FUNC_COLLOCATE_RIGHT = 275,
    FUNC_DERIVE = 276,
    FUNC_DERIVE_SMOOTHED_COLUMN = 277,
    FUNC_EXCLUDE = 278,
    FUNC_FLATTEN = 279,
    FUNC_KEEP = 280,
    FUNC_LONGITUDE_RANGE = 281,
    FUNC_POINT_DISTANCE = 282,
    FUNC_POINT_IN_AREA = 283,
    FUNC_REGRID = 284,
    FUNC_RENAME = 285,
    FUNC_SET = 286,
    FUNC_SMOOTH = 287,
    FUNC_SORT = 288,
    FUNC_SQUASH = 289,
    FUNC_VALID = 290,
    FUNC_WRAP = 291,
    NAN = 292,
    INF = 293,
    IN = 294,
    EQUAL = 295,
    NOT_EQUAL = 296,
    GREATER_EQUAL = 297,
    LESS_EQUAL = 298,
    BIT_NAND = 299,
    BIT_AND = 300,
    NOT = 301
  };
#endif
/* Tokens.  */
#define NAME 258
#define STRING_VALUE 259
#define INTEGER_VALUE 260
#define DOUBLE_VALUE 261
#define DATATYPE 262
#define DIMENSION 263
#define UNIT 264
#define ID_A 265
#define ID_B 266
#define FUNC_AREA_COVERS_AREA 267
#define FUNC_AREA_COVERS_POINT 268
#define FUNC_AREA_INSIDE_AREA 269
#define FUNC_AREA_INTERSECTS_AREA 270
#define FUNC_BIN 271
#define FUNC_BIN_SPATIAL 272
#define FUNC_CLAMP 273
#define FUNC_COLLOCATE_LEFT 274
#define FUNC_COLLOCATE_RIGHT 275
#define FUNC_DERIVE 276
#define FUNC_DERIVE_SMOOTHED_COLUMN 277
#define FUNC_EXCLUDE 278
#define FUNC_FLATTEN 279
#define FUNC_KEEP 280
#define FUNC_LONGITUDE_RANGE 281
#define FUNC_POINT_DISTANCE 282
#define FUNC_POINT_IN_AREA 283
#define FUNC_REGRID 284
#define FUNC_RENAME 285
#define FUNC_SET 286
#define FUNC_SMOOTH 287
#define FUNC_SORT 288
#define FUNC_SQUASH 289
#define FUNC_VALID 290
#define FUNC_WRAP 291
#define NAN 292
#define INF 293
#define IN 294
#define EQUAL 295
#define NOT_EQUAL 296
#define GREATER_EQUAL 297
#define LESS_EQUAL 298
#define BIT_NAND 299
#define BIT_AND 300
#define NOT 301

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 197 "../harp/libharp/harp-operation-parser.y" /* yacc.c:355  */

    double double_val;
    int32_t int32_val;
    char *string_val;
    const char *const_string_val;
    harp_operation *operation;
    harp_sized_array *array;
    harp_program *program;

    harp_comparison_operator_type comparison_operator;
    harp_bit_mask_operator_type bit_mask_operator;
    harp_membership_operator_type membership_operator;

#line 375 "libharp/harp-operation-parser.c" /* yacc.c:355  */
};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_LIBHARP_HARP_OPERATION_PARSER_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 390 "libharp/harp-operation-parser.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  65
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   677

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  57
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  16
/* YYNRULES -- Number of rules.  */
#define YYNRULES  170
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  501

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   301

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      55,    56,     2,    48,    50,    49,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    47,
      54,     2,    53,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    51,     2,    52,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   273,   273,   274,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   314,   315,   319,
     328,   337,   347,   348,   349,   350,   351,   352,   356,   357,
     358,   362,   366,   373,   383,   400,   410,   427,   435,   446,
     447,   451,   452,   453,   454,   455,   456,   460,   461,   465,
     466,   470,   478,   486,   496,   506,   518,   528,   539,   550,
     563,   576,   591,   599,   602,   610,   618,   628,   639,   652,
     665,   680,   688,   700,   714,   728,   744,   752,   766,   782,
     798,   816,   827,   833,   841,   849,   857,   865,   876,   918,
     928,   936,   944,   952,   960,   968,   976,   987,   997,  1007,
    1019,  1030,  1043,  1056,  1071,  1093,  1115,  1134,  1142,  1145,
    1153,  1156,  1164,  1172,  1182,  1185,  1193,  1201,  1211,  1219,
    1229,  1239,  1251,  1262,  1275,  1288,  1303,  1311,  1323,  1336,
    1367,  1381,  1395,  1407,  1417,  1427,  1444,  1461,  1475,  1493,
    1511,  1526,  1534,  1542,  1550,  1558,  1566,  1574,  1587,  1596,
    1609
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "NAME", "STRING_VALUE", "INTEGER_VALUE",
  "DOUBLE_VALUE", "DATATYPE", "DIMENSION", "UNIT", "ID_A", "ID_B",
  "FUNC_AREA_COVERS_AREA", "FUNC_AREA_COVERS_POINT",
  "FUNC_AREA_INSIDE_AREA", "FUNC_AREA_INTERSECTS_AREA", "FUNC_BIN",
  "FUNC_BIN_SPATIAL", "FUNC_CLAMP", "FUNC_COLLOCATE_LEFT",
  "FUNC_COLLOCATE_RIGHT", "FUNC_DERIVE", "FUNC_DERIVE_SMOOTHED_COLUMN",
  "FUNC_EXCLUDE", "FUNC_FLATTEN", "FUNC_KEEP", "FUNC_LONGITUDE_RANGE",
  "FUNC_POINT_DISTANCE", "FUNC_POINT_IN_AREA", "FUNC_REGRID",
  "FUNC_RENAME", "FUNC_SET", "FUNC_SMOOTH", "FUNC_SORT", "FUNC_SQUASH",
  "FUNC_VALID", "FUNC_WRAP", "NAN", "INF", "IN", "EQUAL", "NOT_EQUAL",
  "GREATER_EQUAL", "LESS_EQUAL", "BIT_NAND", "BIT_AND", "NOT", "';'",
  "'+'", "'-'", "','", "'{'", "'}'", "'>'", "'<'", "'('", "')'", "$accept",
  "input", "reserved_identifier", "identifier", "double_value",
  "int32_value", "double_array", "string_array", "identifier_array",
  "dimension_array", "dimensionspec", "comparison_operator",
  "bit_mask_operator", "membership_operator", "operation", "program", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,    59,    43,    45,
      44,   123,   125,    62,    60,    40,    41
};
# endif

#define YYPACT_NINF -129

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-129)))

#define YYTABLE_NINF -1

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     542,  -129,  -129,  -129,  -129,  -129,   -19,    56,    63,    72,
      79,    86,   103,   106,   110,   115,   154,   159,   164,   171,
     175,   190,   212,   225,   228,   237,   243,   244,   245,   246,
     248,  -129,  -129,  -129,  -129,   167,  -129,   -24,  -129,   105,
      -3,   102,     5,     6,   305,    23,   146,   277,   292,   579,
     579,   579,   169,   579,   102,   102,     8,   296,   579,   301,
     404,   450,   302,   579,   579,  -129,  -129,  -129,  -129,  -129,
    -129,  -129,  -129,   275,  -129,  -129,   108,    74,   290,   542,
     293,   102,  -129,  -129,  -129,   158,   178,    -1,  -129,   294,
     102,    45,   102,   298,  -129,  -129,  -129,  -129,  -129,  -129,
    -129,  -129,  -129,  -129,  -129,  -129,  -129,  -129,  -129,  -129,
    -129,  -129,  -129,  -129,  -129,  -129,  -129,  -129,  -129,   579,
    -129,   297,   341,   347,   102,   304,   306,    88,   129,    24,
     307,  -129,   130,   299,   131,    93,   112,   308,   102,   315,
     317,   318,   579,   319,   579,   314,   321,   316,   116,  -129,
    -129,   348,  -129,   111,  -129,  -129,  -129,   138,  -129,  -129,
    -129,  -129,  -129,  -129,  -129,  -129,   323,   102,  -129,   141,
     102,  -129,   142,    13,   150,  -129,   152,   102,   579,    74,
    -129,    74,  -129,    30,   320,    97,  -129,     2,   366,   579,
    -129,  -129,  -129,   327,   102,   328,   102,  -129,   157,   579,
     579,   375,   161,   372,   168,  -129,   496,  -129,   331,   102,
    -129,  -129,   173,   181,   102,   119,   102,    18,   121,   326,
     122,   330,   332,   333,   334,   340,   374,   183,   184,   335,
    -129,    31,  -129,  -129,  -129,   -18,   336,  -129,   343,  -129,
     102,    33,   102,   124,   126,   385,   339,   342,   346,   349,
     344,   579,   345,   102,   353,   388,   400,  -129,  -129,   355,
     351,    35,   354,  -129,   359,   389,  -129,   395,   391,  -129,
    -129,  -129,   392,   102,   398,    74,  -129,    74,  -129,  -129,
     393,  -129,   443,  -129,  -129,   579,    36,   396,  -129,   128,
     405,   102,   406,   399,   440,  -129,  -129,   483,   579,  -129,
     185,  -129,   442,   102,  -129,  -129,   438,   102,   439,  -129,
    -129,   445,   102,   446,   102,   102,   444,   447,   441,   480,
    -129,  -129,   489,   481,  -129,  -129,   488,   102,   102,    37,
     484,   102,    21,   490,   532,   487,   102,   491,   102,   192,
    -129,   102,   193,   102,   196,   197,    74,   102,  -129,  -129,
     494,  -129,   102,    38,    41,   492,  -129,   102,   205,   207,
     102,   533,   579,   534,  -129,   529,  -129,   208,    47,   209,
      48,   210,    32,   563,   570,   571,   618,    50,   567,  -129,
     568,  -129,  -129,   218,    68,    99,  -129,   219,   102,   537,
     622,  -129,    76,   572,  -129,    90,   573,  -129,    34,   221,
     102,  -129,  -129,   102,   102,   222,   574,  -129,  -129,  -129,
      91,   575,  -129,   577,   582,   226,   583,   584,   229,   580,
    -129,  -129,   581,  -129,  -129,   234,   102,  -129,   102,  -129,
     585,   588,   586,   109,  -129,  -129,   587,  -129,  -129,   631,
     635,   589,  -129,   102,   636,   179,  -129,  -129,  -129,   102,
    -129,   590,   591,  -129,   102,   592,   595,   599,  -129,   594,
     596,   102,   597,   238,   601,   604,   600,  -129,  -129,   602,
    -129,   651,   653,  -129,  -129,   241,  -129,   211,  -129,   655,
     656,  -129,  -129,   605,   606,   607,   614,   615,   610,   611,
    -129,  -129,  -129,   664,   665,  -129,  -129,   616,   617,  -129,
    -129
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
     170,    37,     9,     8,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,     4,     5,     7,     6,     0,    38,     0,   169,     3,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     1,    70,    61,    62,    63,
      64,    67,    68,     0,    65,    66,     0,     0,     0,     2,
       0,     0,    48,    39,    43,     0,     0,     0,    42,     0,
       0,     0,     0,     0,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,     0,
     102,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    56,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    69,
      74,    72,    71,     0,   168,    82,    52,     0,    49,    40,
      44,    46,    50,    41,    45,    47,     0,     0,    91,     0,
       0,    96,     0,     0,     0,   103,     0,     0,     0,     0,
     110,     0,   113,     0,     0,     0,   116,     0,     0,     0,
     127,   128,   129,     0,     0,     0,     0,   146,     0,     0,
       0,     0,     0,     0,     0,   161,     0,   165,     0,     0,
      73,    54,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     118,     0,   117,    58,    60,     0,     0,   120,     0,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,     0,    77,    51,     0,
       0,     0,     0,    83,     0,     0,   101,     0,     0,   105,
     106,   104,     0,     0,     0,     0,   111,     0,   114,   119,
       0,   122,     0,    59,   121,     0,     0,     0,   130,     0,
       0,     0,     0,     0,     0,   153,   154,     0,     0,   162,
       0,   163,     0,     0,    75,    53,     0,     0,     0,    85,
      84,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     123,    57,     0,     0,   132,   131,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      86,     0,     0,     0,     0,     0,     0,     0,   112,   115,
       0,   133,     0,     0,     0,     0,   134,     0,     0,     0,
       0,     0,     0,     0,   164,     0,   166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   138,
       0,   136,   135,     0,     0,     0,   152,     0,     0,     0,
       0,   167,     0,     0,    78,     0,     0,    87,     0,     0,
       0,    92,   107,     0,     0,     0,     0,   140,   139,   137,
       0,     0,   142,     0,     0,     0,     0,     0,     0,     0,
      80,    79,     0,    89,    88,     0,     0,    94,     0,    93,
       0,     0,     0,     0,   126,   141,     0,   144,   143,     0,
       0,     0,   147,     0,     0,     0,   157,    81,    90,     0,
      95,     0,     0,    97,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,    99,    98,     0,
     109,     0,     0,   150,   151,     0,   149,     0,   160,     0,
       0,   100,   108,     0,     0,     0,     0,     0,     0,     0,
     124,   125,   148,     0,     0,   155,   156,     0,     0,   158,
     159
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -129,  -129,  -129,     4,   -41,   -39,   -87,  -129,   -46,  -129,
    -128,  -129,  -129,  -129,   598,  -129
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    35,    36,   131,   156,    88,   157,   213,   132,   235,
     187,    76,    77,    78,    38,    39
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_uint16 yytable[] =
{
      87,    80,   188,   169,    37,   172,   125,   134,   166,    89,
      91,   236,   137,   135,   136,    66,    67,    68,    69,    70,
      71,    72,    73,   221,   222,   359,    82,   262,    82,    74,
      75,   183,   282,   184,   283,   151,    40,   176,   152,   229,
     280,   399,   287,   425,   308,   323,   355,   378,   121,   167,
     380,   198,    81,   129,   130,   231,   393,   396,   237,   406,
      90,    92,   140,   138,   143,   145,   212,   147,   148,   122,
     123,   122,   123,   174,   263,   185,   360,   411,   124,    82,
     186,   185,   400,    37,   426,   419,   230,   281,   401,   288,
     427,   309,   324,   356,   379,   170,   202,   381,   204,   422,
     436,   171,   193,   394,   397,   233,   407,    82,    83,   413,
     414,    41,   150,    82,    83,   211,    82,    83,    42,   456,
     457,   195,   122,   123,   412,   208,   217,    43,   259,   219,
     264,   267,   420,   290,    44,   292,   225,   326,   179,    84,
     227,    45,   228,   194,   180,    84,   423,   437,    84,   234,
      85,    86,    79,   241,   126,   243,    85,    86,    46,    85,
      86,    47,   196,   158,   159,    48,   209,    65,   254,   260,
      49,   265,   268,   258,   291,   261,   293,   133,   327,   181,
     189,   189,   226,   162,   163,   182,   190,   192,   214,   464,
     465,   214,   214,   239,   215,   160,   161,   218,   220,   286,
     189,   289,   214,   245,   246,   300,   223,   214,   224,    50,
     252,   189,   302,   244,    51,   164,   165,   248,   189,    52,
     339,   486,   487,   214,   250,   342,    53,   344,   345,   255,
      54,   256,   316,   275,   277,   189,   318,   257,   319,   276,
     278,   335,   214,   214,   358,    55,   214,   214,   368,   370,
     329,   367,   372,   373,   369,   214,   371,   385,   214,   214,
     214,   384,   337,   386,   392,   395,   398,    56,   214,   214,
     383,   428,   433,   387,   410,   415,   441,   429,   434,   445,
      57,   127,   442,    58,   449,   446,   353,   354,   477,   322,
     450,   214,    59,   361,   478,   365,   128,   485,    60,    61,
      62,    63,   334,    64,   139,   141,   375,   374,     1,    93,
     146,   377,     2,     3,   149,     4,     5,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    31,    32,    33,   153,   158,   416,   173,   155,
     168,    34,   162,   175,   177,   191,   178,   210,   185,   430,
     119,   120,   431,   432,   197,   199,   389,   200,   201,   203,
     205,   206,   207,   216,   475,   238,   232,   240,   242,   247,
     249,   253,   266,   274,   272,   451,   269,   452,   270,   271,
     273,   279,   284,   285,   294,   295,   297,   304,   296,   298,
     299,   301,   462,   303,   305,   306,   307,     1,   466,   311,
     310,     2,     3,   469,     4,     5,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    31,    32,    33,   312,   313,   314,   315,   317,   320,
      34,   321,   325,     1,   331,   328,   330,     2,     3,   142,
       4,     5,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    31,    32,    33,
     332,   333,   336,   338,   346,   340,    34,   348,   350,     1,
     341,   343,   347,     2,     3,   144,     4,     5,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    31,    32,    33,   349,   351,   352,   357,
     362,   363,    34,   364,   376,     1,   417,   366,   382,     2,
       3,   251,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,     1,   388,   390,   391,     2,     3,    34,     4,
       5,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    31,    32,    33,   402,
     403,   404,   405,   408,   409,    34,   418,   439,   421,   424,
     435,   438,   440,   443,   444,   459,   447,   448,   454,   460,
     463,   453,   455,   458,   461,   471,   467,   468,   470,   472,
     473,   479,   474,   476,   480,   483,   481,   484,   482,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,   498,
       0,     0,   499,   500,     0,     0,     0,   154
};

static const yytype_int16 yycheck[] =
{
      41,     4,   130,    90,     0,    92,    45,    53,     9,     4,
       4,     9,     4,    54,    55,    39,    40,    41,    42,    43,
      44,    45,    46,    10,    11,     4,     5,     9,     5,    53,
      54,     7,    50,     9,    52,    76,    55,   124,    77,     9,
       9,     9,     9,     9,     9,     9,     9,     9,    44,    50,
       9,   138,    55,    49,    50,   183,     9,     9,    56,     9,
      55,    55,    58,    55,    60,    61,   153,    63,    64,    48,
      49,    48,    49,   119,    56,    51,    55,     9,    55,     5,
      56,    51,    50,    79,    50,     9,    56,    56,    56,    56,
      56,    56,    56,    56,    56,    50,   142,    56,   144,     9,
       9,    56,     9,    56,    56,     8,    56,     5,     6,    10,
      11,    55,     4,     5,     6,     4,     5,     6,    55,    10,
      11,     9,    48,    49,    56,     9,   167,    55,     9,   170,
       9,     9,    56,     9,    55,     9,   177,     9,    50,    37,
     179,    55,   181,    50,    56,    37,    56,    56,    37,    52,
      48,    49,    47,   194,     8,   196,    48,    49,    55,    48,
      49,    55,    50,     5,     6,    55,    50,     0,   209,    50,
      55,    50,    50,   214,    50,   216,    50,     8,    50,    50,
      50,    50,   178,     5,     6,    56,    56,    56,    50,    10,
      11,    50,    50,   189,    56,    37,    38,    56,    56,   240,
      50,   242,    50,   199,   200,   251,    56,    50,    56,    55,
     206,    50,   253,    56,    55,    37,    38,    56,    50,    55,
     307,    10,    11,    50,    56,   312,    55,   314,   315,    56,
      55,    50,   273,    50,    50,    50,   275,    56,   277,    56,
      56,    56,    50,    50,   331,    55,    50,    50,    56,    56,
     291,   338,    56,    56,   341,    50,   343,    50,    50,    50,
      50,    56,   303,    56,    56,    56,    56,    55,    50,    50,
     357,    50,    50,   360,    56,    56,    50,    56,    56,    50,
      55,     4,    56,    55,    50,    56,   327,   328,    50,   285,
      56,    50,    55,   332,    56,   336,     4,    56,    55,    55,
      55,    55,   298,    55,     8,     4,   347,   346,     3,     4,
       8,   352,     7,     8,    39,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    55,     5,   388,    50,    56,
      56,    46,     5,    56,    50,    56,    50,     9,    51,   400,
      55,    56,   403,   404,    56,    50,   362,    50,    50,    50,
      56,    50,    56,    50,   461,     9,    56,    50,    50,     4,
       8,    50,    56,     9,    50,   426,    56,   428,    56,    56,
      50,    56,    56,    50,     9,    56,    50,     9,    56,    50,
      56,    56,   443,    50,     4,    50,    55,     3,   449,    50,
      56,     7,     8,   454,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    55,    50,    55,    55,    50,    56,
      46,     8,    56,     3,    55,    50,    50,     7,     8,    55,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      50,     8,    50,    55,    50,    56,    46,    56,     9,     3,
      55,    55,    55,     7,     8,    55,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    56,    56,    50,    55,
      50,     9,    46,    56,    50,     3,     9,    56,    56,     7,
       8,    55,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,     3,    50,    50,    56,     7,     8,    46,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    56,
      50,    50,     4,    56,    56,    46,     4,    50,    56,    56,
      56,    56,    50,    50,    50,     4,    56,    56,    50,     4,
       4,    56,    56,    56,    55,    50,    56,    56,    56,    50,
      56,    50,    56,    56,    50,     4,    56,     4,    56,     4,
       4,    56,    56,    56,    50,    50,    56,    56,     4,     4,
      -1,    -1,    56,    56,    -1,    -1,    -1,    79
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     3,     7,     8,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    46,    58,    59,    60,    71,    72,
      55,    55,    55,    55,    55,    55,    55,    55,    55,    55,
      55,    55,    55,    55,    55,    55,    55,    55,    55,    55,
      55,    55,    55,    55,    55,     0,    39,    40,    41,    42,
      43,    44,    45,    46,    53,    54,    68,    69,    70,    47,
       4,    55,     5,     6,    37,    48,    49,    61,    62,     4,
      55,     4,    55,     4,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    55,
      56,    60,    48,    49,    55,    62,     8,     4,     4,    60,
      60,    60,    65,     8,    65,    61,    61,     4,    55,     8,
      60,     4,    55,    60,    55,    60,     8,    60,    60,    39,
       4,    61,    62,    55,    71,    56,    61,    63,     5,     6,
      37,    38,     5,     6,    37,    38,     9,    50,    56,    63,
      50,    56,    63,    50,    65,    56,    63,    50,    50,    50,
      56,    50,    56,     7,     9,    51,    56,    67,    67,    50,
      56,    56,    56,     9,    50,     9,    50,    56,    63,    50,
      50,    50,    65,    50,    65,    56,    50,    56,     9,    50,
       9,     4,    63,    64,    50,    56,    50,    61,    56,    61,
      56,    10,    11,    56,    56,    61,    60,    62,    62,     9,
      56,    67,    56,     8,    52,    66,     9,    56,     9,    60,
      50,    61,    50,    61,    56,    60,    60,     4,    56,     8,
      56,    55,    60,    50,    61,    56,    50,    56,    61,     9,
      50,    61,     9,    56,     9,    50,    56,     9,    50,    56,
      56,    56,    50,    50,     9,    50,    56,    50,    56,    56,
       9,    56,    50,    52,    56,    50,    61,     9,    56,    61,
       9,    50,     9,    50,     9,    56,    56,    50,    50,    56,
      65,    56,    61,    50,     9,     4,    50,    55,     9,    56,
      56,    50,    55,    50,    55,    55,    61,    50,    62,    62,
      56,     8,    60,     9,    56,    56,     9,    50,    50,    61,
      50,    55,    50,     8,    60,    56,    50,    61,    55,    63,
      56,    55,    63,    55,    63,    63,    50,    55,    56,    56,
       9,    56,    50,    61,    61,     9,    56,    55,    63,     4,
      55,    62,    50,     9,    56,    61,    56,    63,    56,    63,
      56,    63,    56,    56,    62,    61,    50,    61,     9,    56,
       9,    56,    56,    63,    56,    50,    56,    63,    50,    60,
      50,    56,    56,     9,    56,    56,     9,    56,    56,     9,
      50,    56,    56,    50,    50,     4,     9,    56,    56,    56,
      56,     9,    56,    10,    11,    56,    61,     9,     4,     9,
      56,    56,     9,    56,    56,     9,    50,    56,    50,    56,
      61,    61,    61,    50,    56,    56,     9,    56,    56,    50,
      50,    50,    56,    50,    50,    50,    56,    56,    56,    50,
      56,    61,    61,    56,    50,    56,    10,    11,    56,     4,
       4,    55,    61,     4,    10,    11,    61,    56,    56,    61,
      56,    50,    50,    56,    56,    63,    56,    50,    56,    50,
      50,    56,    56,     4,     4,    56,    10,    11,     4,     4,
      56,    56,    56,    50,    50,    56,    56,     4,     4,    56,
      56
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    57,    58,    58,    59,    59,    59,    59,    59,    59,
      59,    59,    59,    59,    59,    59,    59,    59,    59,    59,
      59,    59,    59,    59,    59,    59,    59,    59,    59,    59,
      59,    59,    59,    59,    59,    59,    59,    60,    60,    61,
      61,    61,    61,    61,    61,    61,    61,    61,    62,    62,
      62,    63,    63,    64,    64,    65,    65,    66,    66,    67,
      67,    68,    68,    68,    68,    68,    68,    69,    69,    70,
      70,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    72,    72,
      72
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     1,     1,     2,     2,     2,     2,     1,     2,
       2,     3,     1,     3,     1,     3,     1,     3,     1,     3,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     3,     3,     4,     3,     6,     5,     5,    10,    11,
      11,    12,     4,     6,     7,     7,     8,    10,    11,    11,
      12,     4,    10,    11,    11,    12,     4,    12,    13,    13,
      14,     6,     3,     4,     6,     6,     6,    10,    14,    13,
       4,     6,     8,     4,     6,     8,     4,     5,     5,     6,
       5,     6,     6,     7,    15,    15,    11,     4,     4,     4,
       6,     7,     7,     8,     8,     9,     9,    10,     9,    10,
      10,    11,    10,    11,    11,    12,     4,    11,    15,    13,
      13,    13,     9,     6,     6,    15,    15,    11,    17,    17,
      13,     4,     6,     6,     8,     4,     8,     9,     3,     1,
       0
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yytype)
    {
          case 3: /* NAME  */
#line 266 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { free(((*yyvaluep).string_val)); }
#line 1563 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 4: /* STRING_VALUE  */
#line 266 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { free(((*yyvaluep).string_val)); }
#line 1569 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 5: /* INTEGER_VALUE  */
#line 266 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { free(((*yyvaluep).string_val)); }
#line 1575 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 6: /* DOUBLE_VALUE  */
#line 266 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { free(((*yyvaluep).string_val)); }
#line 1581 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 9: /* UNIT  */
#line 266 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { free(((*yyvaluep).string_val)); }
#line 1587 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 60: /* identifier  */
#line 266 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { free(((*yyvaluep).string_val)); }
#line 1593 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 63: /* double_array  */
#line 263 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { harp_sized_array_delete(((*yyvaluep).array)); }
#line 1599 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 64: /* string_array  */
#line 263 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { harp_sized_array_delete(((*yyvaluep).array)); }
#line 1605 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 65: /* identifier_array  */
#line 263 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { harp_sized_array_delete(((*yyvaluep).array)); }
#line 1611 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 66: /* dimension_array  */
#line 263 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { harp_sized_array_delete(((*yyvaluep).array)); }
#line 1617 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 67: /* dimensionspec  */
#line 263 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { harp_sized_array_delete(((*yyvaluep).array)); }
#line 1623 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 71: /* operation  */
#line 264 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { harp_operation_delete(((*yyvaluep).operation)); }
#line 1629 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;

    case 72: /* program  */
#line 265 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1257  */
      { harp_program_delete(((*yyvaluep).program)); }
#line 1635 "libharp/harp-operation-parser.c" /* yacc.c:1257  */
        break;


      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 273 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { parsed_program = (yyvsp[-1].program); }
#line 1899 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 3:
#line 274 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { parsed_program = (yyvsp[0].program); }
#line 1905 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 4:
#line 278 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "nan"; }
#line 1911 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 5:
#line 279 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "inf"; }
#line 1917 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 6:
#line 280 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "not"; }
#line 1923 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 7:
#line 281 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "in"; }
#line 1929 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 8:
#line 282 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = harp_get_dimension_type_name((yyvsp[0].int32_val)); }
#line 1935 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 9:
#line 283 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = harp_get_data_type_name((yyvsp[0].int32_val)); }
#line 1941 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 10:
#line 284 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "a"; }
#line 1947 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 11:
#line 285 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "b"; }
#line 1953 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 12:
#line 286 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "area_covers_area"; }
#line 1959 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 13:
#line 287 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "area_covers_point"; }
#line 1965 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 14:
#line 288 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "area_inside_area"; }
#line 1971 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 15:
#line 289 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "area_intersects_area"; }
#line 1977 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 16:
#line 290 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "bin"; }
#line 1983 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 17:
#line 291 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "bin_spatial"; }
#line 1989 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 18:
#line 292 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "clamp"; }
#line 1995 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 19:
#line 293 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "collocate_left"; }
#line 2001 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 20:
#line 294 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "collocate_right"; }
#line 2007 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 21:
#line 295 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "derive"; }
#line 2013 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 22:
#line 296 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "derive_smoothed_column"; }
#line 2019 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 23:
#line 297 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "exclude"; }
#line 2025 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 24:
#line 298 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "flatten"; }
#line 2031 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 25:
#line 299 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "keep"; }
#line 2037 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 26:
#line 300 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "longitude_range"; }
#line 2043 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 27:
#line 301 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "point_distance"; }
#line 2049 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 28:
#line 302 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "point_in_area"; }
#line 2055 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 29:
#line 303 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "regrid"; }
#line 2061 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 30:
#line 304 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "rename"; }
#line 2067 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 31:
#line 305 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "set"; }
#line 2073 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 32:
#line 306 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "smooth"; }
#line 2079 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 33:
#line 307 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "sort"; }
#line 2085 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 34:
#line 308 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "squash"; }
#line 2091 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 35:
#line 309 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "valid"; }
#line 2097 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 36:
#line 310 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.const_string_val) = "wrap"; }
#line 2103 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 38:
#line 315 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.string_val) = strdup((yyvsp[0].const_string_val)); }
#line 2109 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 39:
#line 319 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            long length = (long)strlen((yyvsp[0].string_val));
            if (harp_parse_double((yyvsp[0].string_val), length, &(yyval.double_val), 0) != length)
            {
                free((yyvsp[0].string_val));
                YYERROR;
            }
            free((yyvsp[0].string_val));
        }
#line 2123 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 40:
#line 328 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            long length = (long)strlen((yyvsp[0].string_val));
            if (harp_parse_double((yyvsp[0].string_val), length, &(yyval.double_val), 0) != length)
            {
                free((yyvsp[0].string_val));
                YYERROR;
            }
            free((yyvsp[0].string_val));
        }
#line 2137 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 41:
#line 337 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            long length = (long)strlen((yyvsp[0].string_val));
            if (harp_parse_double((yyvsp[0].string_val), length, &(yyval.double_val), 0) != length)
            {
                free((yyvsp[0].string_val));
                YYERROR;
            }
            free((yyvsp[0].string_val));
            (yyval.double_val) = -(yyval.double_val);
        }
#line 2152 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 42:
#line 347 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.double_val) = (double)(yyvsp[0].int32_val); }
#line 2158 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 43:
#line 348 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.double_val) = harp_nan(); }
#line 2164 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 44:
#line 349 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.double_val) = harp_nan(); }
#line 2170 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 45:
#line 350 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.double_val) = harp_nan(); }
#line 2176 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 46:
#line 351 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.double_val) = harp_plusinf(); }
#line 2182 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 47:
#line 352 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.double_val) = harp_mininf(); }
#line 2188 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 48:
#line 356 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.int32_val) = (int32_t)atol((yyvsp[0].string_val)); free((yyvsp[0].string_val)); }
#line 2194 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 49:
#line 357 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.int32_val) = (int32_t)atol((yyvsp[0].string_val)); free((yyvsp[0].string_val)); }
#line 2200 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 50:
#line 358 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.int32_val) = -(int32_t)atol((yyvsp[0].string_val)); free((yyvsp[0].string_val)); }
#line 2206 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 51:
#line 362 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_sized_array_add_double((yyvsp[-2].array), (yyvsp[0].double_val)) != 0) YYERROR;
            (yyval.array) = (yyvsp[-2].array);
        }
#line 2215 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 52:
#line 366 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_sized_array_new(harp_type_double, &(yyval.array)) != 0) YYERROR;
            if (harp_sized_array_add_double((yyval.array), (yyvsp[0].double_val)) != 0) YYERROR;
        }
#line 2224 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 53:
#line 373 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_sized_array_add_string((yyvsp[-2].array), (yyvsp[0].string_val)) != 0)
            {
                harp_sized_array_delete((yyvsp[-2].array));
                free((yyvsp[0].string_val));
                YYERROR;
            }
            (yyval.array) = (yyvsp[-2].array);
            free((yyvsp[0].string_val));
        }
#line 2239 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 54:
#line 383 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_sized_array_new(harp_type_string, &(yyval.array)) != 0)
            {
                free((yyvsp[0].string_val));
                YYERROR;
            }
            if (harp_sized_array_add_string((yyval.array), (yyvsp[0].string_val)) != 0)
            {
                harp_sized_array_delete((yyval.array));
                free((yyvsp[0].string_val));
                YYERROR;
            }
            free((yyvsp[0].string_val));
        }
#line 2258 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 55:
#line 400 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_sized_array_add_string((yyvsp[-2].array), (yyvsp[0].string_val)) != 0)
            {
                harp_sized_array_delete((yyvsp[-2].array));
                free((yyvsp[0].string_val));
                YYERROR;
            }
            (yyval.array) = (yyvsp[-2].array);
            free((yyvsp[0].string_val));
        }
#line 2273 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 56:
#line 410 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_sized_array_new(harp_type_string, &(yyval.array)) != 0)
            {
                free((yyvsp[0].string_val));
                YYERROR;
            }
            if (harp_sized_array_add_string((yyval.array), (yyvsp[0].string_val)) != 0)
            {
                harp_sized_array_delete((yyval.array));
                free((yyvsp[0].string_val));
                YYERROR;
            }
            free((yyvsp[0].string_val));
        }
#line 2292 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 57:
#line 427 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_sized_array_add_int32((yyvsp[-2].array), (yyvsp[0].int32_val)) != 0)
            {
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            (yyval.array) = (yyvsp[-2].array);
        }
#line 2305 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 58:
#line 435 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_sized_array_new(harp_type_int32, &(yyval.array)) != 0) YYERROR;
            if (harp_sized_array_add_int32((yyval.array), (yyvsp[0].int32_val)) != 0)
            {
                harp_sized_array_delete((yyval.array));
                YYERROR;
            }
        }
#line 2318 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 59:
#line 446 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.array) = (yyvsp[-1].array); }
#line 2324 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 60:
#line 447 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { if (harp_sized_array_new(harp_type_int32, &(yyval.array)) != 0) YYERROR; }
#line 2330 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 61:
#line 451 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.comparison_operator) = operator_eq; }
#line 2336 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 62:
#line 452 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.comparison_operator) = operator_ne; }
#line 2342 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 63:
#line 453 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.comparison_operator) = operator_ge; }
#line 2348 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 64:
#line 454 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.comparison_operator) = operator_le; }
#line 2354 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 65:
#line 455 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.comparison_operator) = operator_gt; }
#line 2360 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 66:
#line 456 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.comparison_operator) = operator_lt; }
#line 2366 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 67:
#line 460 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.bit_mask_operator) = operator_bit_mask_none; }
#line 2372 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 68:
#line 461 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.bit_mask_operator) = operator_bit_mask_any; }
#line 2378 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 69:
#line 465 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.membership_operator) = operator_not_in; }
#line 2384 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 70:
#line 466 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    { (yyval.membership_operator) = operator_in; }
#line 2390 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 71:
#line 470 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_bit_mask_filter_new((yyvsp[-2].string_val), (yyvsp[-1].bit_mask_operator), (yyvsp[0].int32_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-2].string_val));
                YYERROR;
            }
            free((yyvsp[-2].string_val));
        }
#line 2403 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 72:
#line 478 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_comparison_filter_new((yyvsp[-2].string_val), (yyvsp[-1].comparison_operator), (yyvsp[0].double_val), NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-2].string_val));
                YYERROR;
            }
            free((yyvsp[-2].string_val));
        }
#line 2416 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 73:
#line 486 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_comparison_filter_new((yyvsp[-3].string_val), (yyvsp[-2].comparison_operator), (yyvsp[-1].double_val), (yyvsp[0].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                free((yyvsp[0].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
            free((yyvsp[0].string_val));
        }
#line 2431 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 74:
#line 496 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_string_comparison_filter_new((yyvsp[-2].string_val), (yyvsp[-1].comparison_operator), (yyvsp[0].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-2].string_val));
                free((yyvsp[0].string_val));
                YYERROR;
            }
            free((yyvsp[-2].string_val));
            free((yyvsp[0].string_val));
        }
#line 2446 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 75:
#line 506 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_membership_filter_new((yyvsp[-5].string_val), (yyvsp[-4].membership_operator), (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.double_data, (yyvsp[0].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-5].string_val));
                harp_sized_array_delete((yyvsp[-2].array));
                free((yyvsp[0].string_val));
                YYERROR;
            }
            free((yyvsp[-5].string_val));
            harp_sized_array_delete((yyvsp[-2].array));
            free((yyvsp[0].string_val));
        }
#line 2463 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 76:
#line 518 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_membership_filter_new((yyvsp[-4].string_val), (yyvsp[-3].membership_operator), (yyvsp[-1].array)->num_elements, (yyvsp[-1].array)->array.double_data, NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-4].string_val));
                harp_sized_array_delete((yyvsp[-1].array));
                YYERROR;
            }
            free((yyvsp[-4].string_val));
            harp_sized_array_delete((yyvsp[-1].array));
        }
#line 2478 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 77:
#line 528 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_string_membership_filter_new((yyvsp[-4].string_val), (yyvsp[-3].membership_operator), (yyvsp[-1].array)->num_elements,
                                                            (const char **)(yyvsp[-1].array)->array.string_data, &(yyval.operation)) != 0)
            {
                free((yyvsp[-4].string_val));
                harp_sized_array_delete((yyvsp[-1].array));
                YYERROR;
            }
            free((yyvsp[-4].string_val));
            harp_sized_array_delete((yyvsp[-1].array));
        }
#line 2494 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 78:
#line 539 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_covers_area_filter_new(NULL, (yyvsp[-6].array)->num_elements, (yyvsp[-6].array)->array.double_data, NULL,
                                                           (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.double_data, NULL, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-6].array));
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-6].array));
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 2510 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 79:
#line 550 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_covers_area_filter_new(NULL, (yyvsp[-7].array)->num_elements, (yyvsp[-7].array)->array.double_data, NULL,
                                                           (yyvsp[-3].array)->num_elements, (yyvsp[-3].array)->array.double_data, (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-7].array));
                harp_sized_array_delete((yyvsp[-3].array));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-7].array));
            harp_sized_array_delete((yyvsp[-3].array));
            free((yyvsp[-1].string_val));
        }
#line 2528 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 80:
#line 563 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_covers_area_filter_new(NULL, (yyvsp[-7].array)->num_elements, (yyvsp[-7].array)->array.double_data, (yyvsp[-5].string_val),
                                                           (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.double_data, NULL, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-7].array));
                free((yyvsp[-5].string_val));
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-7].array));
            free((yyvsp[-5].string_val));
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 2546 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 81:
#line 576 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_covers_area_filter_new(NULL, (yyvsp[-8].array)->num_elements, (yyvsp[-8].array)->array.double_data, (yyvsp[-6].string_val),
                                                           (yyvsp[-3].array)->num_elements, (yyvsp[-3].array)->array.double_data, (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-8].array));
                free((yyvsp[-6].string_val));
                harp_sized_array_delete((yyvsp[-3].array));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-8].array));
            free((yyvsp[-6].string_val));
            harp_sized_array_delete((yyvsp[-3].array));
            free((yyvsp[-1].string_val));
        }
#line 2566 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 82:
#line 591 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_covers_area_filter_new((yyvsp[-1].string_val), 0, NULL, NULL, 0, NULL, NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 2579 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 83:
#line 599 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_covers_point_filter_new((yyvsp[-3].double_val), NULL, (yyvsp[-1].double_val), NULL, &(yyval.operation)) != 0) YYERROR;
        }
#line 2587 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 84:
#line 602 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_covers_point_filter_new((yyvsp[-4].double_val), NULL, (yyvsp[-2].double_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 2600 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 85:
#line 610 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_covers_point_filter_new((yyvsp[-4].double_val), (yyvsp[-3].string_val), (yyvsp[-1].double_val), NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
        }
#line 2613 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 86:
#line 618 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_covers_point_filter_new((yyvsp[-5].double_val), (yyvsp[-4].string_val), (yyvsp[-2].double_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-4].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-4].string_val));
            free((yyvsp[-1].string_val));
        }
#line 2628 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 87:
#line 628 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_inside_area_filter_new(NULL, (yyvsp[-6].array)->num_elements, (yyvsp[-6].array)->array.double_data, NULL,
                                                           (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.double_data, NULL, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-6].array));
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-6].array));
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 2644 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 88:
#line 639 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_inside_area_filter_new(NULL, (yyvsp[-7].array)->num_elements, (yyvsp[-7].array)->array.double_data, NULL,
                                                           (yyvsp[-3].array)->num_elements, (yyvsp[-3].array)->array.double_data, (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-7].array));
                harp_sized_array_delete((yyvsp[-3].array));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-7].array));
            harp_sized_array_delete((yyvsp[-3].array));
            free((yyvsp[-1].string_val));
        }
#line 2662 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 89:
#line 652 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_inside_area_filter_new(NULL, (yyvsp[-7].array)->num_elements, (yyvsp[-7].array)->array.double_data, (yyvsp[-5].string_val),
                                                           (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.double_data, NULL, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-7].array));
                free((yyvsp[-5].string_val));
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-7].array));
            free((yyvsp[-5].string_val));
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 2680 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 90:
#line 665 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_inside_area_filter_new(NULL, (yyvsp[-8].array)->num_elements, (yyvsp[-8].array)->array.double_data, (yyvsp[-6].string_val),
                                                           (yyvsp[-3].array)->num_elements, (yyvsp[-3].array)->array.double_data, (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-8].array));
                free((yyvsp[-6].string_val));
                harp_sized_array_delete((yyvsp[-3].array));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-8].array));
            free((yyvsp[-6].string_val));
            harp_sized_array_delete((yyvsp[-3].array));
            free((yyvsp[-1].string_val));
        }
#line 2700 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 91:
#line 680 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_inside_area_filter_new((yyvsp[-1].string_val), 0, NULL, NULL, 0, NULL, NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 2713 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 92:
#line 688 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_intersects_area_filter_new(NULL, (yyvsp[-6].array)->num_elements, (yyvsp[-6].array)->array.double_data, NULL,
                                                               (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.double_data, NULL, NULL, &(yyval.operation))
                != 0)
            {
                harp_sized_array_delete((yyvsp[-6].array));
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-6].array));
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 2730 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 93:
#line 700 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_intersects_area_filter_new(NULL, (yyvsp[-7].array)->num_elements, (yyvsp[-7].array)->array.double_data, NULL,
                                                               (yyvsp[-3].array)->num_elements, (yyvsp[-3].array)->array.double_data, (yyvsp[-1].string_val), NULL, &(yyval.operation))
                != 0)
            {
                harp_sized_array_delete((yyvsp[-7].array));
                harp_sized_array_delete((yyvsp[-3].array));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-7].array));
            harp_sized_array_delete((yyvsp[-3].array));
            free((yyvsp[-1].string_val));
        }
#line 2749 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 94:
#line 714 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_intersects_area_filter_new(NULL, (yyvsp[-7].array)->num_elements, (yyvsp[-7].array)->array.double_data, (yyvsp[-5].string_val),
                                                               (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.double_data, NULL, NULL, &(yyval.operation))
                != 0)
            {
                harp_sized_array_delete((yyvsp[-7].array));
                free((yyvsp[-5].string_val));
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-7].array));
            free((yyvsp[-5].string_val));
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 2768 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 95:
#line 728 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_intersects_area_filter_new(NULL, (yyvsp[-8].array)->num_elements, (yyvsp[-8].array)->array.double_data, (yyvsp[-6].string_val),
                                                               (yyvsp[-3].array)->num_elements, (yyvsp[-3].array)->array.double_data, (yyvsp[-1].string_val), NULL, &(yyval.operation))
                != 0)
            {
                harp_sized_array_delete((yyvsp[-8].array));
                free((yyvsp[-6].string_val));
                harp_sized_array_delete((yyvsp[-3].array));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-8].array));
            free((yyvsp[-6].string_val));
            harp_sized_array_delete((yyvsp[-3].array));
            free((yyvsp[-1].string_val));
        }
#line 2789 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 96:
#line 744 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_area_intersects_area_filter_new((yyvsp[-1].string_val), 0, NULL, NULL, 0, NULL, NULL, NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 2802 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 97:
#line 752 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            double min_fraction = (yyvsp[-1].double_val);

            if (harp_operation_area_intersects_area_filter_new(NULL, (yyvsp[-8].array)->num_elements, (yyvsp[-8].array)->array.double_data, NULL,
                                                               (yyvsp[-4].array)->num_elements, (yyvsp[-4].array)->array.double_data, NULL,
                                                               &min_fraction, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-8].array));
                harp_sized_array_delete((yyvsp[-4].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-8].array));
            harp_sized_array_delete((yyvsp[-4].array));
        }
#line 2821 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 98:
#line 766 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            double min_fraction = (yyvsp[-1].double_val);

            if (harp_operation_area_intersects_area_filter_new(NULL, (yyvsp[-9].array)->num_elements, (yyvsp[-9].array)->array.double_data, NULL,
                                                               (yyvsp[-5].array)->num_elements, (yyvsp[-5].array)->array.double_data, (yyvsp[-3].string_val),
                                                               &min_fraction, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-9].array));
                harp_sized_array_delete((yyvsp[-5].array));
                free((yyvsp[-3].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-9].array));
            harp_sized_array_delete((yyvsp[-5].array));
            free((yyvsp[-3].string_val));
        }
#line 2842 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 99:
#line 782 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            double min_fraction = (yyvsp[-1].double_val);

            if (harp_operation_area_intersects_area_filter_new(NULL, (yyvsp[-9].array)->num_elements, (yyvsp[-9].array)->array.double_data, (yyvsp[-7].string_val),
                                                               (yyvsp[-4].array)->num_elements, (yyvsp[-4].array)->array.double_data, NULL,
                                                               &min_fraction, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-9].array));
                free((yyvsp[-7].string_val));
                harp_sized_array_delete((yyvsp[-4].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-9].array));
            free((yyvsp[-7].string_val));
            harp_sized_array_delete((yyvsp[-4].array));
        }
#line 2863 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 100:
#line 798 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            double min_fraction = (yyvsp[-1].double_val);

            if (harp_operation_area_intersects_area_filter_new(NULL, (yyvsp[-10].array)->num_elements, (yyvsp[-10].array)->array.double_data, (yyvsp[-8].string_val),
                                                               (yyvsp[-5].array)->num_elements, (yyvsp[-5].array)->array.double_data, (yyvsp[-3].string_val),
                                                               &min_fraction, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-10].array));
                free((yyvsp[-8].string_val));
                harp_sized_array_delete((yyvsp[-5].array));
                free((yyvsp[-3].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-10].array));
            free((yyvsp[-8].string_val));
            harp_sized_array_delete((yyvsp[-5].array));
            free((yyvsp[-3].string_val));
        }
#line 2886 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 101:
#line 816 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            double min_fraction = (yyvsp[-1].double_val);

            if (harp_operation_area_intersects_area_filter_new((yyvsp[-3].string_val), 0, NULL, NULL, 0, NULL, NULL, &min_fraction, &(yyval.operation)) !=
                0)
            {
                free((yyvsp[-3].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
        }
#line 2902 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 102:
#line 827 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_bin_full_new(&(yyval.operation)) != 0)
            {
                YYERROR;
            }
        }
#line 2913 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 103:
#line 833 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_bin_with_variables_new(1, (const char **)&(yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 2926 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 104:
#line 841 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_bin_with_variables_new((yyvsp[-2].array)->num_elements, (const char **)(yyvsp[-2].array)->array.string_data, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 2939 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 105:
#line 849 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_bin_collocated_new((yyvsp[-3].string_val), 'a', &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
        }
#line 2952 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 106:
#line 857 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_bin_collocated_new((yyvsp[-3].string_val), 'b', &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
        }
#line 2965 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 107:
#line 865 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_bin_spatial_new((yyvsp[-6].array)->num_elements, (yyvsp[-6].array)->array.double_data,
                                               (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.double_data, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-6].array));
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-6].array));
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 2981 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 108:
#line 877 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            harp_sized_array *lat_array;
            harp_sized_array *lon_array;
            long i;

            if (harp_sized_array_new(harp_type_double, &lat_array) != 0)
            {
                YYERROR;
            }
            for (i = 0; i < (yyvsp[-11].int32_val); i++)
            {
                if (harp_sized_array_add_double(lat_array, (yyvsp[-9].double_val) + i * (yyvsp[-7].double_val)) != 0)
                {
                    harp_sized_array_delete(lat_array);
                    YYERROR;
                }
            }
            if (harp_sized_array_new(harp_type_double, &lon_array) != 0)
            {
                harp_sized_array_delete(lat_array);
                YYERROR;
            }
            for (i = 0; i < (yyvsp[-5].int32_val); i++)
            {
                if (harp_sized_array_add_double(lon_array, (yyvsp[-3].double_val) + i * (yyvsp[-1].double_val)) != 0)
                {
                    harp_sized_array_delete(lat_array);
                    harp_sized_array_delete(lon_array);
                    YYERROR;
                }
            }
            if (harp_operation_bin_spatial_new(lat_array->num_elements, lat_array->array.double_data,
                                               lon_array->num_elements, lon_array->array.double_data, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete(lat_array);
                harp_sized_array_delete(lon_array);
                YYERROR;
            }
            harp_sized_array_delete(lat_array);
            harp_sized_array_delete(lon_array);
        }
#line 3027 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 109:
#line 918 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_clamp_new((yyvsp[-10].int32_val), (yyvsp[-8].string_val), (yyvsp[-7].string_val), (yyvsp[-4].double_val), (yyvsp[-2].double_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-8].string_val));
                free((yyvsp[-7].string_val));
                YYERROR;
            }
            free((yyvsp[-8].string_val));
            free((yyvsp[-7].string_val));
        }
#line 3042 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 110:
#line 928 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_collocation_filter_new((yyvsp[-1].string_val), harp_collocation_left, -1, -1, &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 3055 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 111:
#line 936 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_collocation_filter_new((yyvsp[-3].string_val), harp_collocation_left, (yyvsp[-1].int32_val), -1, &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
        }
#line 3068 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 112:
#line 944 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_collocation_filter_new((yyvsp[-5].string_val), harp_collocation_left, (yyvsp[-3].int32_val), (yyvsp[-1].int32_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-5].string_val));
                YYERROR;
            }
            free((yyvsp[-5].string_val));
        }
#line 3081 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 113:
#line 952 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_collocation_filter_new((yyvsp[-1].string_val), harp_collocation_right, -1, -1, &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 3094 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 114:
#line 960 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_collocation_filter_new((yyvsp[-3].string_val), harp_collocation_right, (yyvsp[-1].int32_val), -1, &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
        }
#line 3107 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 115:
#line 968 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_collocation_filter_new((yyvsp[-5].string_val), harp_collocation_right, (yyvsp[-3].int32_val), (yyvsp[-1].int32_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-5].string_val));
                YYERROR;
            }
            free((yyvsp[-5].string_val));
        }
#line 3120 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 116:
#line 976 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            /* even though it does nothing, we don't want this case to throw errors */
            /* it can also be used to perform an assert that a certain variable is available
             * (without having to perform a keep() with the full set of variables */
            if (harp_operation_derive_variable_new((yyvsp[-1].string_val), NULL, -1, NULL, NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 3136 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 117:
#line 987 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_derive_variable_new((yyvsp[-2].string_val), NULL, -1, NULL, (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-2].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-2].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3151 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 118:
#line 997 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            harp_data_type data_type = (yyvsp[-1].int32_val);

            if (harp_operation_derive_variable_new((yyvsp[-2].string_val), &data_type, -1, NULL, NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-2].string_val));
                YYERROR;
            }
            free((yyvsp[-2].string_val));
        }
#line 3166 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 119:
#line 1007 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            harp_data_type data_type = (yyvsp[-2].int32_val);

            if (harp_operation_derive_variable_new((yyvsp[-3].string_val), &data_type, -1, NULL, (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3183 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 120:
#line 1019 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_derive_variable_new((yyvsp[-2].string_val), NULL, (yyvsp[-1].array)->num_elements, (yyvsp[-1].array)->array.int32_data, NULL,
                                                   &(yyval.operation)) != 0)
            {
                free((yyvsp[-2].string_val));
                harp_sized_array_delete((yyvsp[-1].array));
                YYERROR;
            }
            free((yyvsp[-2].string_val));
            harp_sized_array_delete((yyvsp[-1].array));
        }
#line 3199 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 121:
#line 1030 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_derive_variable_new((yyvsp[-3].string_val), NULL, (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.int32_data, (yyvsp[-1].string_val),
                                                   &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                harp_sized_array_delete((yyvsp[-2].array));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
            harp_sized_array_delete((yyvsp[-2].array));
            free((yyvsp[-1].string_val));
        }
#line 3217 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 122:
#line 1043 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            harp_data_type data_type = (yyvsp[-2].int32_val);

            if (harp_operation_derive_variable_new((yyvsp[-3].string_val), &data_type, (yyvsp[-1].array)->num_elements, (yyvsp[-1].array)->array.int32_data, NULL, &(yyval.operation)) !=
                0)
            {
                free((yyvsp[-3].string_val));
                harp_sized_array_delete((yyvsp[-1].array));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
            harp_sized_array_delete((yyvsp[-1].array));
        }
#line 3235 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 123:
#line 1056 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            harp_data_type data_type = (yyvsp[-3].int32_val);

            if (harp_operation_derive_variable_new((yyvsp[-4].string_val), &data_type, (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.int32_data, (yyvsp[-1].string_val), &(yyval.operation)) !=
                0)
            {
                free((yyvsp[-4].string_val));
                harp_sized_array_delete((yyvsp[-2].array));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-4].string_val));
            harp_sized_array_delete((yyvsp[-2].array));
            free((yyvsp[-1].string_val));
        }
#line 3255 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 124:
#line 1072 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_derive_smoothed_column_collocated_dataset_new((yyvsp[-12].string_val), (yyvsp[-11].array)->num_elements, (yyvsp[-11].array)->array.int32_data,
                                                                             (yyvsp[-10].string_val), (yyvsp[-8].string_val), (yyvsp[-7].string_val), (yyvsp[-5].string_val), 'a', (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-12].string_val));
                harp_sized_array_delete((yyvsp[-11].array));
                free((yyvsp[-10].string_val));
                free((yyvsp[-8].string_val));
                free((yyvsp[-7].string_val));
                free((yyvsp[-5].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-12].string_val));
            harp_sized_array_delete((yyvsp[-11].array));
            free((yyvsp[-10].string_val));
            free((yyvsp[-8].string_val));
            free((yyvsp[-7].string_val));
            free((yyvsp[-5].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3281 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 125:
#line 1094 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_derive_smoothed_column_collocated_dataset_new((yyvsp[-12].string_val), (yyvsp[-11].array)->num_elements, (yyvsp[-11].array)->array.int32_data,
                                                                             (yyvsp[-10].string_val), (yyvsp[-8].string_val), (yyvsp[-7].string_val), (yyvsp[-5].string_val), 'b', (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-12].string_val));
                harp_sized_array_delete((yyvsp[-11].array));
                free((yyvsp[-10].string_val));
                free((yyvsp[-8].string_val));
                free((yyvsp[-7].string_val));
                free((yyvsp[-5].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-12].string_val));
            harp_sized_array_delete((yyvsp[-11].array));
            free((yyvsp[-10].string_val));
            free((yyvsp[-8].string_val));
            free((yyvsp[-7].string_val));
            free((yyvsp[-5].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3307 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 126:
#line 1115 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_derive_smoothed_column_collocated_product_new((yyvsp[-8].string_val), (yyvsp[-7].array)->num_elements, (yyvsp[-7].array)->array.int32_data,
                                                                             (yyvsp[-6].string_val), (yyvsp[-4].string_val), (yyvsp[-3].string_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-8].string_val));
                harp_sized_array_delete((yyvsp[-7].array));
                free((yyvsp[-6].string_val));
                free((yyvsp[-4].string_val));
                free((yyvsp[-3].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-8].string_val));
            harp_sized_array_delete((yyvsp[-7].array));
            free((yyvsp[-6].string_val));
            free((yyvsp[-4].string_val));
            free((yyvsp[-3].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3331 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 127:
#line 1134 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_exclude_variable_new((yyvsp[-1].array)->num_elements, (const char **)(yyvsp[-1].array)->array.string_data, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-1].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-1].array));
        }
#line 3344 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 128:
#line 1142 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_flatten_new((yyvsp[-1].int32_val), &(yyval.operation)) != 0) YYERROR;
        }
#line 3352 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 129:
#line 1145 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_keep_variable_new((yyvsp[-1].array)->num_elements, (const char **)(yyvsp[-1].array)->array.string_data, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-1].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-1].array));
        }
#line 3365 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 130:
#line 1153 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_longitude_range_filter_new((yyvsp[-3].double_val), NULL, (yyvsp[-1].double_val), NULL, &(yyval.operation)) != 0) YYERROR;
        }
#line 3373 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 131:
#line 1156 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_longitude_range_filter_new((yyvsp[-4].double_val), NULL, (yyvsp[-2].double_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 3386 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 132:
#line 1164 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_longitude_range_filter_new((yyvsp[-4].double_val), (yyvsp[-3].string_val), (yyvsp[-1].double_val), NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
        }
#line 3399 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 133:
#line 1172 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_longitude_range_filter_new((yyvsp[-5].double_val), (yyvsp[-4].string_val), (yyvsp[-2].double_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-4].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-4].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3414 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 134:
#line 1182 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_distance_filter_new((yyvsp[-5].double_val), NULL, (yyvsp[-3].double_val), NULL, (yyvsp[-1].double_val), NULL, &(yyval.operation)) != 0) YYERROR;
        }
#line 3422 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 135:
#line 1185 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_distance_filter_new((yyvsp[-6].double_val), NULL, (yyvsp[-4].double_val), NULL, (yyvsp[-2].double_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 3435 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 136:
#line 1193 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_distance_filter_new((yyvsp[-6].double_val), NULL, (yyvsp[-4].double_val), (yyvsp[-3].string_val), (yyvsp[-1].double_val), NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
        }
#line 3448 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 137:
#line 1201 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_distance_filter_new((yyvsp[-7].double_val), NULL, (yyvsp[-5].double_val), (yyvsp[-4].string_val), (yyvsp[-2].double_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-4].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-4].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3463 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 138:
#line 1211 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_distance_filter_new((yyvsp[-6].double_val), (yyvsp[-5].string_val), (yyvsp[-3].double_val), NULL, (yyvsp[-1].double_val), NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-5].string_val));
                YYERROR;
            }
            free((yyvsp[-5].string_val));
        }
#line 3476 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 139:
#line 1219 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_distance_filter_new((yyvsp[-7].double_val), (yyvsp[-6].string_val), (yyvsp[-4].double_val), NULL, (yyvsp[-2].double_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-6].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-6].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3491 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 140:
#line 1229 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_distance_filter_new((yyvsp[-7].double_val), (yyvsp[-6].string_val), (yyvsp[-4].double_val), (yyvsp[-3].string_val), (yyvsp[-1].double_val), NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-6].string_val));
                free((yyvsp[-3].string_val));
                YYERROR;
            }
            free((yyvsp[-6].string_val));
            free((yyvsp[-3].string_val));
        }
#line 3506 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 141:
#line 1239 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_distance_filter_new((yyvsp[-8].double_val), (yyvsp[-7].string_val), (yyvsp[-5].double_val), (yyvsp[-4].string_val), (yyvsp[-2].double_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-7].string_val));
                free((yyvsp[-4].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-7].string_val));
            free((yyvsp[-4].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3523 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 142:
#line 1251 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_in_area_filter_new(NULL, (yyvsp[-6].array)->num_elements, (yyvsp[-6].array)->array.double_data, NULL,
                                                        (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.double_data, NULL, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-6].array));
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-6].array));
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 3539 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 143:
#line 1262 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_in_area_filter_new(NULL, (yyvsp[-7].array)->num_elements, (yyvsp[-7].array)->array.double_data, NULL,
                                                        (yyvsp[-3].array)->num_elements, (yyvsp[-3].array)->array.double_data, (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-7].array));
                harp_sized_array_delete((yyvsp[-3].array));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-7].array));
            harp_sized_array_delete((yyvsp[-3].array));
            free((yyvsp[-1].string_val));
        }
#line 3557 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 144:
#line 1275 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_in_area_filter_new(NULL, (yyvsp[-7].array)->num_elements, (yyvsp[-7].array)->array.double_data, (yyvsp[-5].string_val),
                                                        (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.double_data, NULL, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-7].array));
                free((yyvsp[-5].string_val));
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-7].array));
            free((yyvsp[-5].string_val));
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 3575 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 145:
#line 1288 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_in_area_filter_new(NULL, (yyvsp[-8].array)->num_elements, (yyvsp[-8].array)->array.double_data, (yyvsp[-6].string_val),
                                                        (yyvsp[-3].array)->num_elements, (yyvsp[-3].array)->array.double_data, (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-8].array));
                free((yyvsp[-6].string_val));
                harp_sized_array_delete((yyvsp[-3].array));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-8].array));
            free((yyvsp[-6].string_val));
            harp_sized_array_delete((yyvsp[-3].array));
            free((yyvsp[-1].string_val));
        }
#line 3595 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 146:
#line 1303 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_point_in_area_filter_new((yyvsp[-1].string_val), 0, NULL, NULL, 0, NULL, NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 3608 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 147:
#line 1311 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_regrid_new((yyvsp[-8].int32_val), (yyvsp[-6].string_val), (yyvsp[-5].string_val), (yyvsp[-2].array)->num_elements, (yyvsp[-2].array)->array.double_data, 0, NULL, &(yyval.operation)) != 0)
            {
                free((yyvsp[-6].string_val));
                free((yyvsp[-5].string_val));
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            free((yyvsp[-6].string_val));
            free((yyvsp[-5].string_val));
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 3625 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 148:
#line 1323 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_regrid_new((yyvsp[-12].int32_val), (yyvsp[-10].string_val), (yyvsp[-9].string_val), (yyvsp[-6].array)->num_elements, (yyvsp[-6].array)->array.double_data, (yyvsp[-2].array)->num_elements,
                                          (yyvsp[-2].array)->array.double_data, &(yyval.operation)) != 0)
            {
                free((yyvsp[-10].string_val));
                free((yyvsp[-9].string_val));
                harp_sized_array_delete((yyvsp[-6].array));
                YYERROR;
            }
            free((yyvsp[-10].string_val));
            free((yyvsp[-9].string_val));
            harp_sized_array_delete((yyvsp[-6].array));
        }
#line 3643 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 149:
#line 1336 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            harp_sized_array *array;
            long i;

            if (harp_sized_array_new(harp_type_double, &array) != 0)
            {
                free((yyvsp[-8].string_val));
                free((yyvsp[-7].string_val));
                YYERROR;
            }
            for (i = 0; i < (yyvsp[-5].int32_val); i++)
            {
                if (harp_sized_array_add_double(array, (yyvsp[-3].double_val) + i * (yyvsp[-1].double_val)) != 0)
                {
                    harp_sized_array_delete(array);
                    free((yyvsp[-8].string_val));
                    free((yyvsp[-7].string_val));
                    YYERROR;
                }
            }
            if (harp_operation_regrid_new((yyvsp[-10].int32_val), (yyvsp[-8].string_val), (yyvsp[-7].string_val), array->num_elements, array->array.double_data, 0, NULL, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete(array);
                free((yyvsp[-8].string_val));
                free((yyvsp[-7].string_val));
                YYERROR;
            }
            harp_sized_array_delete(array);
            free((yyvsp[-8].string_val));
            free((yyvsp[-7].string_val));
        }
#line 3679 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 150:
#line 1367 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_regrid_collocated_dataset_new((yyvsp[-10].int32_val), (yyvsp[-8].string_val), (yyvsp[-7].string_val), (yyvsp[-5].string_val), 'a', (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-8].string_val));
                free((yyvsp[-7].string_val));
                free((yyvsp[-5].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-8].string_val));
            free((yyvsp[-7].string_val));
            free((yyvsp[-5].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3698 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 151:
#line 1381 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_regrid_collocated_dataset_new((yyvsp[-10].int32_val), (yyvsp[-8].string_val), (yyvsp[-7].string_val), (yyvsp[-5].string_val), 'b', (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-8].string_val));
                free((yyvsp[-7].string_val));
                free((yyvsp[-5].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-8].string_val));
            free((yyvsp[-7].string_val));
            free((yyvsp[-5].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3717 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 152:
#line 1395 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_regrid_collocated_product_new((yyvsp[-6].int32_val), (yyvsp[-4].string_val), (yyvsp[-3].string_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-4].string_val));
                free((yyvsp[-3].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-4].string_val));
            free((yyvsp[-3].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3734 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 153:
#line 1407 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_rename_new((yyvsp[-3].string_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3749 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 154:
#line 1417 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_set_new((yyvsp[-3].string_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-3].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-3].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3764 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 155:
#line 1427 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_smooth_collocated_dataset_new(1, (const char **)&(yyvsp[-12].string_val), (yyvsp[-10].int32_val), (yyvsp[-8].string_val), (yyvsp[-7].string_val), (yyvsp[-5].string_val), 'a', (yyvsp[-1].string_val), &(yyval.operation)) !=
                0)
            {
                free((yyvsp[-12].string_val));
                free((yyvsp[-8].string_val));
                free((yyvsp[-7].string_val));
                free((yyvsp[-5].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-12].string_val));
            free((yyvsp[-8].string_val));
            free((yyvsp[-7].string_val));
            free((yyvsp[-5].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3786 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 156:
#line 1444 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_smooth_collocated_dataset_new(1, (const char **)&(yyvsp[-12].string_val), (yyvsp[-10].int32_val), (yyvsp[-8].string_val), (yyvsp[-7].string_val), (yyvsp[-5].string_val), 'b', (yyvsp[-1].string_val), &(yyval.operation)) !=
                0)
            {
                free((yyvsp[-12].string_val));
                free((yyvsp[-8].string_val));
                free((yyvsp[-7].string_val));
                free((yyvsp[-5].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-12].string_val));
            free((yyvsp[-8].string_val));
            free((yyvsp[-7].string_val));
            free((yyvsp[-5].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3808 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 157:
#line 1461 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_smooth_collocated_product_new(1, (const char **)&(yyvsp[-8].string_val), (yyvsp[-6].int32_val), (yyvsp[-4].string_val), (yyvsp[-3].string_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-8].string_val));
                free((yyvsp[-4].string_val));
                free((yyvsp[-3].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-8].string_val));
            free((yyvsp[-4].string_val));
            free((yyvsp[-3].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3827 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 158:
#line 1476 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_smooth_collocated_dataset_new((yyvsp[-13].array)->num_elements, (const char **)(yyvsp[-13].array)->array.string_data,
                                                     (yyvsp[-10].int32_val), (yyvsp[-8].string_val), (yyvsp[-7].string_val), (yyvsp[-5].string_val), 'a', (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-13].array));
                free((yyvsp[-8].string_val));
                free((yyvsp[-7].string_val));
                free((yyvsp[-5].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-13].array));
            free((yyvsp[-8].string_val));
            free((yyvsp[-7].string_val));
            free((yyvsp[-5].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3849 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 159:
#line 1494 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_smooth_collocated_dataset_new((yyvsp[-13].array)->num_elements, (const char **)(yyvsp[-13].array)->array.string_data,
                                                     (yyvsp[-10].int32_val), (yyvsp[-8].string_val), (yyvsp[-7].string_val), (yyvsp[-5].string_val), 'b', (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-13].array));
                free((yyvsp[-8].string_val));
                free((yyvsp[-7].string_val));
                free((yyvsp[-5].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-13].array));
            free((yyvsp[-8].string_val));
            free((yyvsp[-7].string_val));
            free((yyvsp[-5].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3871 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 160:
#line 1511 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_smooth_collocated_product_new((yyvsp[-9].array)->num_elements, (const char **)(yyvsp[-9].array)->array.string_data,
                                                             (yyvsp[-6].int32_val), (yyvsp[-4].string_val), (yyvsp[-3].string_val), (yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-9].array));
                free((yyvsp[-4].string_val));
                free((yyvsp[-3].string_val));
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-9].array));
            free((yyvsp[-4].string_val));
            free((yyvsp[-3].string_val));
            free((yyvsp[-1].string_val));
        }
#line 3891 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 161:
#line 1526 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_sort_new(1, (const char **)&(yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 3904 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 162:
#line 1534 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_sort_new((yyvsp[-2].array)->num_elements, (const char **)(yyvsp[-2].array)->array.string_data, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 3917 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 163:
#line 1542 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_squash_new((yyvsp[-3].int32_val), 1, (const char **)&(yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 3930 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 164:
#line 1550 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_squash_new((yyvsp[-5].int32_val), (yyvsp[-2].array)->num_elements, (const char **)(yyvsp[-2].array)->array.string_data, &(yyval.operation)) != 0)
            {
                harp_sized_array_delete((yyvsp[-2].array));
                YYERROR;
            }
            harp_sized_array_delete((yyvsp[-2].array));
        }
#line 3943 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 165:
#line 1558 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_valid_range_filter_new((yyvsp[-1].string_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-1].string_val));
                YYERROR;
            }
            free((yyvsp[-1].string_val));
        }
#line 3956 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 166:
#line 1566 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_wrap_new((yyvsp[-5].string_val), NULL, (yyvsp[-3].double_val), (yyvsp[-1].double_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-5].string_val));
                YYERROR;
            }
            free((yyvsp[-5].string_val));
        }
#line 3969 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 167:
#line 1574 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_operation_wrap_new((yyvsp[-6].string_val), (yyvsp[-5].string_val), (yyvsp[-3].double_val), (yyvsp[-1].double_val), &(yyval.operation)) != 0)
            {
                free((yyvsp[-6].string_val));
                free((yyvsp[-5].string_val));
                YYERROR;
            }
            free((yyvsp[-6].string_val));
            free((yyvsp[-5].string_val));
        }
#line 3984 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 168:
#line 1587 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_program_add_operation((yyvsp[-2].program), (yyvsp[0].operation)) != 0)
            {
                harp_program_delete((yyvsp[-2].program));
                harp_operation_delete((yyvsp[0].operation));
                YYERROR;
            }
            (yyval.program) = (yyvsp[-2].program);
        }
#line 3998 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 169:
#line 1596 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_program_new(&(yyval.program)) != 0)
            {
                harp_operation_delete((yyvsp[0].operation));
                YYERROR;
            }
            if (harp_program_add_operation((yyval.program), (yyvsp[0].operation)) != 0)
            {
                harp_operation_delete((yyvsp[0].operation));
                harp_program_delete((yyval.program));
                YYERROR;
            }
        }
#line 4016 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;

  case 170:
#line 1609 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1646  */
    {
            if (harp_program_new(&(yyval.program)) != 0) YYERROR;
        }
#line 4024 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
    break;


#line 4028 "libharp/harp-operation-parser.c" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 1614 "../harp/libharp/harp-operation-parser.y" /* yacc.c:1906  */


/* *INDENT-ON* */

int harp_program_from_string(const char *str, harp_program **program)
{
    void *bufstate;

    /* if this doesn't hold we need to introduce a separate harp_sized_array for enums */
    assert(sizeof(int32_t) == sizeof(harp_dimension_type));

    harp_errno = 0;
    parsed_program = NULL;
    bufstate = (void *)harp_operation_parser__scan_string(str);
    if (harp_operation_parser_parse() != 0)
    {
        if (harp_errno == 0)
        {
            harp_set_error(HARP_ERROR_OPERATION_SYNTAX, NULL);
        }
        harp_operation_parser__delete_buffer(bufstate);
        return -1;
    }
    harp_operation_parser__delete_buffer(bufstate);
    *program = parsed_program;

    return 0;
}
