/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider.param.api;

import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardBuilder;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.compression.provider.param.api.IHeaderAccess;
import nom.tam.fits.header.IFitsHeader;

public class HeaderAccess
implements IHeaderAccess {
    private final Header header;
    private HeaderCardBuilder builder;

    public HeaderAccess(Header header) {
        this.header = header;
    }

    @Override
    public void addValue(IFitsHeader key, int value) {
        try {
            this.card(key).value(value);
        }
        catch (HeaderCardException e) {
            throw new IllegalArgumentException("header card could not be created");
        }
    }

    @Override
    public void addValue(IFitsHeader key, String value) {
        try {
            this.card(key).value(value);
        }
        catch (HeaderCardException e) {
            throw new IllegalArgumentException("header card could not be created");
        }
    }

    @Override
    public HeaderCard findCard(IFitsHeader key) {
        return this.header.findCard(key);
    }

    @Override
    public HeaderCard findCard(String key) {
        return this.header.findCard(key);
    }

    private HeaderCardBuilder card(IFitsHeader key) {
        if (this.builder == null) {
            this.builder = this.header.card(key);
            return this.builder;
        }
        return this.builder.card(key);
    }
}

