/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider.param.base;

import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.compression.provider.param.api.ICompressColumnParameter;
import nom.tam.fits.compression.provider.param.api.ICompressHeaderParameter;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;
import nom.tam.fits.compression.provider.param.api.IHeaderAccess;
import nom.tam.fits.header.Standard;

public abstract class CompressParameters
implements ICompressParameters {
    @Override
    public void addColumnsToTable(BinaryTableHDU hdu) throws FitsException {
        for (ICompressColumnParameter parameter : this.columnParameters()) {
            Object column = parameter.column();
            if (column == null) continue;
            hdu.setColumnName(hdu.addColumn(column) - 1, parameter.getName(), null);
        }
    }

    @Override
    public void getValuesFromColumn(int index) {
        for (ICompressColumnParameter parameter : this.columnParameters()) {
            parameter.getValueFromColumn(index);
        }
    }

    @Override
    public void getValuesFromHeader(IHeaderAccess header) {
        for (ICompressHeaderParameter compressionParameter : this.headerParameters()) {
            compressionParameter.getValueFromHeader(header);
        }
    }

    @Override
    public void initializeColumns(IHeaderAccess header, BinaryTable binaryTable, int size) throws FitsException {
        for (ICompressColumnParameter parameter : this.columnParameters()) {
            parameter.column(this.getNullableColumn(header, binaryTable, parameter.getName()), size);
        }
    }

    @Override
    public void initializeColumns(int size) {
        for (ICompressColumnParameter parameter : this.columnParameters()) {
            parameter.column(null, size);
        }
    }

    @Override
    public void setValueFromColumn(int index) {
        for (ICompressColumnParameter parameter : this.columnParameters()) {
            parameter.setValueInColumn(index);
        }
    }

    @Override
    public void setValuesInHeader(IHeaderAccess header) throws HeaderCardException {
        for (ICompressHeaderParameter parameter : this.headerParameters()) {
            parameter.setValueInHeader(header);
        }
    }

    private Object getNullableColumn(IHeaderAccess header, BinaryTable binaryTable, String columnName) throws FitsException {
        for (int i = 1; i <= binaryTable.getNCols(); ++i) {
            HeaderCard card = header.findCard(Standard.TTYPEn.n(i));
            if (card == null || !card.getValue().trim().equals(columnName)) continue;
            return binaryTable.getColumn(i - 1);
        }
        return null;
    }

    protected ICompressColumnParameter[] columnParameters() {
        return new ICompressColumnParameter[0];
    }

    protected abstract ICompressHeaderParameter[] headerParameters();
}

