/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile.mask;

import java.nio.ByteBuffer;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.fits.compression.provider.CompressorProvider;
import nom.tam.image.compression.tile.mask.AbstractNullPixelMask;
import nom.tam.image.compression.tile.mask.NullPixelMaskPreserver;
import nom.tam.image.compression.tile.mask.NullPixelMaskRestorer;
import nom.tam.image.tile.operation.buffer.TileBuffer;

public class ImageNullPixelMask {
    private final AbstractNullPixelMask[] nullPixelMasks;
    private final long nullValue;
    private final ICompressorControl compressorControl;
    private final String compressAlgorithm;

    public ImageNullPixelMask(int tileCount, long nullValue, String compressAlgorithm) {
        this.nullPixelMasks = new AbstractNullPixelMask[tileCount];
        this.nullValue = nullValue;
        this.compressAlgorithm = compressAlgorithm;
        this.compressorControl = CompressorProvider.findCompressorControl(null, this.compressAlgorithm, Byte.TYPE);
    }

    public NullPixelMaskPreserver createTilePreserver(TileBuffer tileBuffer, int tileIndex) {
        return this.add(new NullPixelMaskPreserver(tileBuffer, tileIndex, this.nullValue, this.compressorControl));
    }

    public NullPixelMaskRestorer createTileRestorer(TileBuffer tileBuffer, int tileIndex) {
        return this.add(new NullPixelMaskRestorer(tileBuffer, tileIndex, this.nullValue, this.compressorControl));
    }

    public byte[][] getColumn() {
        byte[][] column = new byte[this.nullPixelMasks.length][];
        for (AbstractNullPixelMask tileMask : this.nullPixelMasks) {
            column[tileMask.getTileIndex()] = tileMask.getMaskBytes();
        }
        return column;
    }

    public String getCompressAlgorithm() {
        return this.compressAlgorithm;
    }

    public void setColumn(byte[][] nullPixels) {
        for (AbstractNullPixelMask tileMask : this.nullPixelMasks) {
            byte[] tileMaskBytes = nullPixels[tileMask.getTileIndex()];
            if (tileMaskBytes == null || tileMaskBytes.length <= 0) continue;
            tileMask.setMask(ByteBuffer.wrap(tileMaskBytes));
        }
    }

    private <T extends AbstractNullPixelMask> T add(T nullPixelMask) {
        this.nullPixelMasks[nullPixelMask.getTileIndex()] = nullPixelMask;
        return nullPixelMask;
    }
}

