/* computer-player.c generated by valac 0.26.0.30-a52f5a, the Vala compiler
 * generated from computer-player.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;
typedef struct _ComputerPlayerPrivate ComputerPlayerPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define COMPUTER_PLAYER_TYPE_STRATEGY (computer_player_strategy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PLAYER (player_get_type ())

#define COMPUTER_PLAYER_TYPE_POSSIBLE_MOVE (computer_player_possible_move_get_type ())
typedef struct _ComputerPlayerPossibleMove ComputerPlayerPossibleMove;
#define _computer_player_possible_move_free0(var) ((var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL)))
#define __g_list_free__computer_player_possible_move_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__computer_player_possible_move_free0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ComputerPlayer {
	GObject parent_instance;
	ComputerPlayerPrivate * priv;
};

struct _ComputerPlayerClass {
	GObjectClass parent_class;
};

struct _ComputerPlayerPrivate {
	Game* game;
	gint _level;
};

typedef enum  {
	COMPUTER_PLAYER_STRATEGY_PERFECT,
	COMPUTER_PLAYER_STRATEGY_VICTORY,
	COMPUTER_PLAYER_STRATEGY_BEST,
	COMPUTER_PLAYER_STRATEGY_WORST
} ComputerPlayerStrategy;

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _ComputerPlayerPossibleMove {
	gint x;
	gint y;
	gint n_tiles;
};


static gpointer computer_player_parent_class = NULL;

GType computer_player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define COMPUTER_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPUTER_PLAYER, ComputerPlayerPrivate))
enum  {
	COMPUTER_PLAYER_DUMMY_PROPERTY,
	COMPUTER_PLAYER_LEVEL
};
static GType computer_player_strategy_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define COMPUTER_PLAYER_POSITIVE_INFINITY 10000
#define COMPUTER_PLAYER_NEGATIVE_INFINITY (-10000)
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void computer_player_set_level (ComputerPlayer* self, gint value);
void computer_player_move (ComputerPlayer* self);
GType player_get_type (void) G_GNUC_CONST;
gboolean game_can_move (Game* self, Player color);
Player game_get_current_color (Game* self);
gint game_get_n_tiles (Game* self);
static void computer_player_random_select (Game* g, gint* move_x, gint* move_y);
gint game_place_tile (Game* self, gint x, gint y);
gint computer_player_get_level (ComputerPlayer* self);
static gint computer_player_search (Game* g, ComputerPlayerStrategy strategy, gint depth, gint a, gint b, gint* move_x, gint* move_y);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type, Game* game);
gboolean game_is_complete (Game* self);
gint game_count_tiles (Game* self, Player color);
Player player_flip_color (Player p);
static gint computer_player_calculate_heuristic (Game* g, ComputerPlayerStrategy strategy);
static GType computer_player_possible_move_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self);
static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self);
static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles);
static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b);
static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b);
void game_undo (Game* self, gint count);
void game_pass (Game* self);
static void _computer_player_possible_move_free0_ (gpointer var);
static void _g_list_free__computer_player_possible_move_free0_ (GList* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
static gint computer_player_eval_heuristic (Game* g);
static gint computer_player_around (Game* g);
Player game_get_owner (Game* self, gint x, gint y);
static gint computer_player_is_empty (Game* g, gint x, gint y);
gboolean game_can_place (Game* self, gint x, gint y, Player color);
static void computer_player_finalize (GObject* obj);
static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gint COMPUTER_PLAYER_heuristic[64] = {65, -3, 6, 4, 4, 6, -3, 65, -3, -29, 3, 1, 1, 3, -29, -3, 6, 3, 5, 3, 3, 5, 3, 6, 4, 1, 3, 1, 1, 3, 1, 4, 4, 1, 3, 1, 1, 3, 1, 4, 6, 3, 5, 3, 3, 5, 3, 6, -3, -29, 3, 1, 1, 3, -29, -3, 65, -3, 6, 4, 4, 6, -3, 65};

static GType computer_player_strategy_get_type (void) {
	static volatile gsize computer_player_strategy_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_strategy_type_id__volatile)) {
		static const GEnumValue values[] = {{COMPUTER_PLAYER_STRATEGY_PERFECT, "COMPUTER_PLAYER_STRATEGY_PERFECT", "perfect"}, {COMPUTER_PLAYER_STRATEGY_VICTORY, "COMPUTER_PLAYER_STRATEGY_VICTORY", "victory"}, {COMPUTER_PLAYER_STRATEGY_BEST, "COMPUTER_PLAYER_STRATEGY_BEST", "best"}, {COMPUTER_PLAYER_STRATEGY_WORST, "COMPUTER_PLAYER_STRATEGY_WORST", "worst"}, {0, NULL, NULL}};
		GType computer_player_strategy_type_id;
		computer_player_strategy_type_id = g_enum_register_static ("ComputerPlayerStrategy", values);
		g_once_init_leave (&computer_player_strategy_type_id__volatile, computer_player_strategy_type_id);
	}
	return computer_player_strategy_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 61 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return self ? g_object_ref (self) : NULL;
#line 155 "computer-player.c"
}


ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level) {
	ComputerPlayer * self = NULL;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 59 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 59 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self = (ComputerPlayer*) g_object_new (object_type, NULL);
#line 61 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = game;
#line 61 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 61 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_g_object_unref0 (self->priv->game);
#line 61 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self->priv->game = _tmp1_;
#line 62 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = level;
#line 62 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_set_level (self, _tmp2_);
#line 59 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return self;
#line 182 "computer-player.c"
}


ComputerPlayer* computer_player_new (Game* game, gint level) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return computer_player_construct (TYPE_COMPUTER_PLAYER, game, level);
#line 189 "computer-player.c"
}


void computer_player_move (ComputerPlayer* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	Game* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint depth = 0;
	gint _tmp14_ = 0;
	gint tiles_remaining = 0;
	Game* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	ComputerPlayerStrategy strategy = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp22_ = 0;
	gint x = 0;
	gint y = 0;
	Game* _tmp23_ = NULL;
	Game* _tmp24_ = NULL;
	Game* _tmp25_ = NULL;
	ComputerPlayerStrategy _tmp26_ = 0;
	gint _tmp27_ = 0;
	Game* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
#line 65 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->game;
#line 65 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = self->priv->game;
#line 65 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = game_get_current_color (_tmp1_);
#line 65 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp3_ = _tmp2_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp4_ = game_can_move (_tmp0_, _tmp3_);
#line 65 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (_tmp4_);
#line 69 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp5_ = self->priv->game;
#line 69 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp6_ = game_get_n_tiles (_tmp5_);
#line 69 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp7_ = _tmp6_;
#line 69 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp7_ < 8) {
#line 245 "computer-player.c"
		gint x = 0;
		gint y = 0;
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 72 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp8_ = self->priv->game;
#line 72 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		computer_player_random_select (_tmp8_, &_tmp9_, &_tmp10_);
#line 72 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		x = _tmp9_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		y = _tmp10_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp11_ = self->priv->game;
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp12_ = x;
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp13_ = y;
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		game_place_tile (_tmp11_, _tmp12_, _tmp13_);
#line 74 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return;
#line 272 "computer-player.c"
	}
#line 77 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp14_ = self->priv->_level;
#line 77 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	depth = (_tmp14_ * 2) + 1;
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp15_ = self->priv->game;
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp16_ = game_get_n_tiles (_tmp15_);
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp17_ = _tmp16_;
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	tiles_remaining = 64 - _tmp17_;
#line 86 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	strategy = COMPUTER_PLAYER_STRATEGY_BEST;
#line 87 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp18_ = tiles_remaining;
#line 87 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp19_ = depth;
#line 87 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp18_ <= (_tmp19_ + 10)) {
#line 88 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		strategy = COMPUTER_PLAYER_STRATEGY_PERFECT;
#line 296 "computer-player.c"
	} else {
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
#line 89 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp20_ = tiles_remaining;
#line 89 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp21_ = depth;
#line 89 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		if (_tmp20_ <= (_tmp21_ + 12)) {
#line 90 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			strategy = COMPUTER_PLAYER_STRATEGY_VICTORY;
#line 308 "computer-player.c"
		}
	}
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp22_ = self->priv->_level;
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp22_ == 1) {
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		strategy = COMPUTER_PLAYER_STRATEGY_WORST;
#line 317 "computer-player.c"
	}
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	x = 0;
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	y = 0;
#line 99 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp23_ = self->priv->game;
#line 99 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp24_ = game_new_copy (_tmp23_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp25_ = _tmp24_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp26_ = strategy;
#line 99 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp27_ = depth;
#line 99 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_search (_tmp25_, _tmp26_, _tmp27_, COMPUTER_PLAYER_NEGATIVE_INFINITY, COMPUTER_PLAYER_POSITIVE_INFINITY, &x, &y);
#line 99 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_g_object_unref0 (_tmp25_);
#line 100 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp28_ = self->priv->game;
#line 100 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp29_ = x;
#line 100 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp30_ = y;
#line 100 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp31_ = game_place_tile (_tmp28_, _tmp29_, _tmp30_);
#line 100 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp31_ == 0) {
#line 347 "computer-player.c"
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp32_ = x;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp33_ = y;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_critical ("computer-player.vala:101: Computer chose an invalid move: %d,%d", _tmp32_, _tmp33_);
#line 356 "computer-player.c"
	}
}


static gpointer _computer_player_possible_move_dup0 (gpointer self) {
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return self ? computer_player_possible_move_dup (self) : NULL;
#line 364 "computer-player.c"
}


static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = computer_player_compare_move ((ComputerPlayerPossibleMove*) a, (ComputerPlayerPossibleMove*) b);
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 373 "computer-player.c"
}


static void _computer_player_possible_move_free0_ (gpointer var) {
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	(var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL));
#line 380 "computer-player.c"
}


static void _g_list_free__computer_player_possible_move_free0_ (GList* self) {
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_list_foreach (self, (GFunc) _computer_player_possible_move_free0_, NULL);
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_list_free (self);
#line 389 "computer-player.c"
}


static gint computer_player_search (Game* g, ComputerPlayerStrategy strategy, gint depth, gint a, gint b, gint* move_x, gint* move_y) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Game* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gint _tmp20_ = 0;
	GList* moves = NULL;
	GList* _tmp41_ = NULL;
	GList* _tmp51_ = NULL;
	gint _tmp85_ = 0;
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = a;
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = b;
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (_tmp0_ <= _tmp1_, 0);
#line 108 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = g;
#line 108 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp3_ = game_is_complete (_tmp2_);
#line 108 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp3_) {
#line 418 "computer-player.c"
		gint n_current_tiles = 0;
		Game* _tmp4_ = NULL;
		Game* _tmp5_ = NULL;
		Player _tmp6_ = 0;
		Player _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint n_enemy_tiles = 0;
		Game* _tmp9_ = NULL;
		Game* _tmp10_ = NULL;
		Player _tmp11_ = 0;
		Player _tmp12_ = 0;
		Player _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
#line 110 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp4_ = g;
#line 110 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp5_ = g;
#line 110 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp6_ = game_get_current_color (_tmp5_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp7_ = _tmp6_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp8_ = game_count_tiles (_tmp4_, _tmp7_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		n_current_tiles = _tmp8_;
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp9_ = g;
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp10_ = g;
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp11_ = game_get_current_color (_tmp10_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp12_ = _tmp11_;
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp13_ = player_flip_color (_tmp12_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp14_ = game_count_tiles (_tmp9_, _tmp13_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		n_enemy_tiles = _tmp14_;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp16_ = n_current_tiles;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp17_ = n_enemy_tiles;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		if (_tmp16_ > _tmp17_) {
#line 467 "computer-player.c"
			gint _tmp18_ = 0;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp18_ = n_enemy_tiles;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp15_ = COMPUTER_PLAYER_POSITIVE_INFINITY - _tmp18_;
#line 473 "computer-player.c"
		} else {
			gint _tmp19_ = 0;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp19_ = n_current_tiles;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp15_ = COMPUTER_PLAYER_NEGATIVE_INFINITY + _tmp19_;
#line 480 "computer-player.c"
		}
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		result = _tmp15_;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return result;
#line 486 "computer-player.c"
	}
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp20_ = depth;
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp20_ == 0) {
#line 492 "computer-player.c"
		Game* _tmp21_ = NULL;
		ComputerPlayerStrategy _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 117 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp21_ = g;
#line 117 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp22_ = strategy;
#line 117 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp23_ = computer_player_calculate_heuristic (_tmp21_, _tmp22_);
#line 117 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		result = _tmp23_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return result;
#line 506 "computer-player.c"
	}
#line 120 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	moves = NULL;
#line 510 "computer-player.c"
	{
		gint x = 0;
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		x = 0;
#line 515 "computer-player.c"
		{
			gboolean _tmp24_ = FALSE;
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp24_ = TRUE;
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			while (TRUE) {
#line 522 "computer-player.c"
				gint _tmp26_ = 0;
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!_tmp24_) {
#line 526 "computer-player.c"
					gint _tmp25_ = 0;
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp25_ = x;
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					x = _tmp25_ + 1;
#line 532 "computer-player.c"
				}
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp24_ = FALSE;
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp26_ = x;
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!(_tmp26_ < 8)) {
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					break;
#line 542 "computer-player.c"
				}
				{
					gint y = 0;
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					y = 0;
#line 548 "computer-player.c"
					{
						gboolean _tmp27_ = FALSE;
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp27_ = TRUE;
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						while (TRUE) {
#line 555 "computer-player.c"
							gint _tmp29_ = 0;
							gint n_tiles = 0;
							Game* _tmp30_ = NULL;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							ComputerPlayerPossibleMove move = {0};
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							ComputerPlayerPossibleMove _tmp38_ = {0};
							ComputerPlayerPossibleMove* _tmp39_ = NULL;
							Game* _tmp40_ = NULL;
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!_tmp27_) {
#line 572 "computer-player.c"
								gint _tmp28_ = 0;
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp28_ = y;
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								y = _tmp28_ + 1;
#line 578 "computer-player.c"
							}
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp27_ = FALSE;
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp29_ = y;
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!(_tmp29_ < 8)) {
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								break;
#line 588 "computer-player.c"
							}
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp30_ = g;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp31_ = x;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp32_ = y;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp33_ = game_place_tile (_tmp30_, _tmp31_, _tmp32_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							n_tiles = _tmp33_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp34_ = n_tiles;
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (_tmp34_ <= 0) {
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								continue;
#line 606 "computer-player.c"
							}
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp35_ = x;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp36_ = y;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp37_ = n_tiles;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							computer_player_possible_move_init (&move, _tmp35_, _tmp36_, _tmp37_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp38_ = move;
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp39_ = _computer_player_possible_move_dup0 (&_tmp38_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							moves = g_list_insert_sorted (moves, _tmp39_, _computer_player_compare_move_gcompare_func);
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp40_ = g;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							game_undo (_tmp40_, 1);
#line 626 "computer-player.c"
						}
					}
				}
			}
		}
	}
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp41_ = moves;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp41_ == NULL) {
#line 637 "computer-player.c"
		ComputerPlayerPossibleMove move = {0};
		ComputerPlayerPossibleMove _tmp42_ = {0};
		ComputerPlayerPossibleMove* _tmp43_ = NULL;
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		computer_player_possible_move_init (&move, 0, 0, 0);
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp42_ = move;
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp43_ = _computer_player_possible_move_dup0 (&_tmp42_);
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		moves = g_list_append (moves, _tmp43_);
#line 649 "computer-player.c"
	} else {
		ComputerPlayerPossibleMove* move = NULL;
		GList* _tmp44_ = NULL;
		gconstpointer _tmp45_ = NULL;
		ComputerPlayerPossibleMove* _tmp46_ = NULL;
		ComputerPlayerPossibleMove* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		ComputerPlayerPossibleMove* _tmp49_ = NULL;
		gint _tmp50_ = 0;
#line 149 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp44_ = moves;
#line 149 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp45_ = g_list_nth_data (_tmp44_, (guint) 0);
#line 149 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp46_ = _computer_player_possible_move_dup0 ((ComputerPlayerPossibleMove*) _tmp45_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		move = _tmp46_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp47_ = move;
#line 150 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp48_ = (*_tmp47_).x;
#line 150 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		*move_x = _tmp48_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp49_ = move;
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp50_ = (*_tmp49_).y;
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		*move_y = _tmp50_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_computer_player_possible_move_free0 (move);
#line 681 "computer-player.c"
	}
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp51_ = moves;
#line 685 "computer-player.c"
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		move_collection = _tmp51_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
#line 693 "computer-player.c"
			ComputerPlayerPossibleMove* _tmp52_ = NULL;
			ComputerPlayerPossibleMove* move = NULL;
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp52_ = _computer_player_possible_move_dup0 ((ComputerPlayerPossibleMove*) move_it->data);
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			move = _tmp52_;
#line 700 "computer-player.c"
			{
				ComputerPlayerPossibleMove* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gint next_x_move = 0;
				gint next_y_move = 0;
				gint a_new = 0;
				Game* _tmp69_ = NULL;
				ComputerPlayerStrategy _tmp70_ = 0;
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				Game* _tmp82_ = NULL;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp53_ = move;
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp54_ = (*_tmp53_).n_tiles;
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (_tmp54_ == 0) {
#line 724 "computer-player.c"
					Game* _tmp55_ = NULL;
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp55_ = g;
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					game_pass (_tmp55_);
#line 730 "computer-player.c"
				} else {
					Game* _tmp56_ = NULL;
					ComputerPlayerPossibleMove* _tmp57_ = NULL;
					gint _tmp58_ = 0;
					ComputerPlayerPossibleMove* _tmp59_ = NULL;
					gint _tmp60_ = 0;
					gint _tmp61_ = 0;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp56_ = g;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp57_ = move;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp58_ = (*_tmp57_).x;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp59_ = move;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp60_ = (*_tmp59_).y;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp61_ = game_place_tile (_tmp56_, _tmp58_, _tmp60_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					if (_tmp61_ == 0) {
#line 752 "computer-player.c"
						gint _tmp62_ = 0;
						ComputerPlayerPossibleMove* _tmp63_ = NULL;
						gint _tmp64_ = 0;
						ComputerPlayerPossibleMove* _tmp65_ = NULL;
						gint _tmp66_ = 0;
						ComputerPlayerPossibleMove* _tmp67_ = NULL;
						gint _tmp68_ = 0;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp62_ = depth;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp63_ = move;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp64_ = (*_tmp63_).x;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp65_ = move;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp66_ = (*_tmp65_).y;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp67_ = move;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp68_ = (*_tmp67_).n_tiles;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						g_critical ("computer-player.vala:160: Computer marked move (depth %d, %d,%d, %d fl" \
"ips) as valid, but is invalid when checking", _tmp62_, _tmp64_, _tmp66_, _tmp68_);
#line 776 "computer-player.c"
					}
				}
#line 162 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				next_x_move = 0;
#line 162 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				next_y_move = 0;
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp69_ = g;
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp70_ = strategy;
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp71_ = depth;
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp72_ = b;
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp73_ = a;
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp74_ = computer_player_search (_tmp69_, _tmp70_, _tmp71_ - 1, -_tmp72_, -_tmp73_, &next_x_move, &next_y_move);
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				a_new = (-1) * _tmp74_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp75_ = a_new;
#line 164 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp76_ = a;
#line 164 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (_tmp75_ > _tmp76_) {
#line 803 "computer-player.c"
					gint _tmp77_ = 0;
					ComputerPlayerPossibleMove* _tmp78_ = NULL;
					gint _tmp79_ = 0;
					ComputerPlayerPossibleMove* _tmp80_ = NULL;
					gint _tmp81_ = 0;
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp77_ = a_new;
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					a = _tmp77_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp78_ = move;
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp79_ = (*_tmp78_).x;
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					*move_x = _tmp79_;
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp80_ = move;
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp81_ = (*_tmp80_).y;
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					*move_y = _tmp81_;
#line 825 "computer-player.c"
				}
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp82_ = g;
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				game_undo (_tmp82_, 1);
#line 174 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp83_ = b;
#line 174 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp84_ = a;
#line 174 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (_tmp83_ <= _tmp84_) {
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_computer_player_possible_move_free0 (move);
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					break;
#line 841 "computer-player.c"
				}
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_computer_player_possible_move_free0 (move);
#line 845 "computer-player.c"
			}
		}
	}
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp85_ = a;
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = _tmp85_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 857 "computer-player.c"
}


static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b) {
	gint result = 0;
	ComputerPlayerPossibleMove* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ComputerPlayerPossibleMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = b;
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = (*_tmp0_).n_tiles;
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = a;
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp3_ = (*_tmp2_).n_tiles;
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = _tmp1_ - _tmp3_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 879 "computer-player.c"
}


static gint computer_player_calculate_heuristic (Game* g, ComputerPlayerStrategy strategy) {
	gint result = 0;
	gint _tmp0_ = 0;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gint tile_difference = 0;
	ComputerPlayerStrategy _tmp16_ = 0;
#line 185 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = g;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = game_get_current_color (_tmp1_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp3_ = _tmp2_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp3_ == PLAYER_DARK) {
#line 901 "computer-player.c"
		Game* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		Game* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp4_ = g;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp5_ = game_get_n_dark_tiles (_tmp4_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp6_ = _tmp5_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp7_ = g;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp8_ = game_get_n_light_tiles (_tmp7_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp9_ = _tmp8_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp0_ = _tmp6_ - _tmp9_;
#line 922 "computer-player.c"
	} else {
		Game* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		Game* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp10_ = g;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp11_ = game_get_n_light_tiles (_tmp10_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp12_ = _tmp11_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp13_ = g;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp14_ = game_get_n_dark_tiles (_tmp13_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp15_ = _tmp14_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp0_ = _tmp12_ - _tmp15_;
#line 944 "computer-player.c"
	}
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	tile_difference = _tmp0_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp16_ = strategy;
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	switch (_tmp16_) {
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_STRATEGY_PERFECT:
#line 954 "computer-player.c"
		{
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			result = tile_difference;
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			return result;
#line 960 "computer-player.c"
		}
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_STRATEGY_VICTORY:
#line 964 "computer-player.c"
		{
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp17_ = tile_difference;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp18_ = CLAMP (_tmp17_, -1, 1);
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			result = _tmp18_;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			return result;
#line 976 "computer-player.c"
		}
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_STRATEGY_WORST:
#line 980 "computer-player.c"
		{
			gint _tmp19_ = 0;
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp19_ = tile_difference;
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			result = -_tmp19_;
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			return result;
#line 989 "computer-player.c"
		}
		default:
		{
			gint _tmp20_ = 0;
			Game* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			Game* _tmp23_ = NULL;
			gint _tmp24_ = 0;
#line 205 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp20_ = tile_difference;
#line 205 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp21_ = g;
#line 205 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp22_ = computer_player_eval_heuristic (_tmp21_);
#line 205 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp23_ = g;
#line 205 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp24_ = computer_player_around (_tmp23_);
#line 205 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			result = (_tmp20_ + _tmp22_) + _tmp24_;
#line 205 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			return result;
#line 1012 "computer-player.c"
		}
	}
}


static gint computer_player_eval_heuristic (Game* g) {
	gint result = 0;
	gint count = 0;
#line 209 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	count = 0;
#line 1025 "computer-player.c"
	{
		gint x = 0;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		x = 0;
#line 1030 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1037 "computer-player.c"
				gint _tmp2_ = 0;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 1041 "computer-player.c"
					gint _tmp1_ = 0;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 1047 "computer-player.c"
				}
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!(_tmp2_ < 8)) {
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					break;
#line 1057 "computer-player.c"
				}
				{
					gint y = 0;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					y = 0;
#line 1063 "computer-player.c"
					{
						gboolean _tmp3_ = FALSE;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp3_ = TRUE;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1070 "computer-player.c"
							gint _tmp5_ = 0;
							gint h = 0;
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							Player _tmp12_ = 0;
							Game* _tmp13_ = NULL;
							Player _tmp14_ = 0;
							Player _tmp15_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!_tmp3_) {
#line 1087 "computer-player.c"
								gint _tmp4_ = 0;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp4_ = y;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								y = _tmp4_ + 1;
#line 1093 "computer-player.c"
							}
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp3_ = FALSE;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp5_ = y;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!(_tmp5_ < 8)) {
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								break;
#line 1103 "computer-player.c"
							}
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp6_ = y;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp7_ = x;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp8_ = COMPUTER_PLAYER_heuristic[(_tmp6_ * 8) + _tmp7_];
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							h = _tmp8_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp9_ = g;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp10_ = x;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp11_ = y;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp12_ = game_get_owner (_tmp9_, _tmp10_, _tmp11_);
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp13_ = g;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp14_ = game_get_current_color (_tmp13_);
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp15_ = _tmp14_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (_tmp12_ != _tmp15_) {
#line 1129 "computer-player.c"
								gint _tmp16_ = 0;
#line 218 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp16_ = h;
#line 218 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								h = -_tmp16_;
#line 1135 "computer-player.c"
							}
#line 219 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp17_ = count;
#line 219 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp18_ = h;
#line 219 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							count = _tmp17_ + _tmp18_;
#line 1143 "computer-player.c"
						}
					}
				}
			}
		}
	}
#line 223 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = count;
#line 223 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 1154 "computer-player.c"
}


static gint computer_player_around (Game* g) {
	gint result = 0;
	gint count = 0;
#line 226 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 228 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	count = 0;
#line 1165 "computer-player.c"
	{
		gint x = 0;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		x = 0;
#line 1170 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1177 "computer-player.c"
				gint _tmp2_ = 0;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 1181 "computer-player.c"
					gint _tmp1_ = 0;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 1187 "computer-player.c"
				}
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!(_tmp2_ < 8)) {
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					break;
#line 1197 "computer-player.c"
				}
				{
					gint y = 0;
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					y = 0;
#line 1203 "computer-player.c"
					{
						gboolean _tmp3_ = FALSE;
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp3_ = TRUE;
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1210 "computer-player.c"
							gint _tmp5_ = 0;
							gint a = 0;
							gint _tmp6_ = 0;
							Game* _tmp7_ = NULL;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							Game* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							Game* _tmp17_ = NULL;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							Game* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							Game* _tmp27_ = NULL;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							Game* _tmp32_ = NULL;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							Game* _tmp37_ = NULL;
							gint _tmp38_ = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							Game* _tmp42_ = NULL;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							Game* _tmp48_ = NULL;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							Player _tmp51_ = 0;
							Game* _tmp52_ = NULL;
							Player _tmp53_ = 0;
							Player _tmp54_ = 0;
							gint _tmp57_ = 0;
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!_tmp3_) {
#line 1265 "computer-player.c"
								gint _tmp4_ = 0;
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp4_ = y;
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								y = _tmp4_ + 1;
#line 1271 "computer-player.c"
							}
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp3_ = FALSE;
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp5_ = y;
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!(_tmp5_ < 8)) {
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								break;
#line 1281 "computer-player.c"
							}
#line 233 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = 0;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp6_ = a;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp7_ = g;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp8_ = x;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp9_ = y;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp10_ = computer_player_is_empty (_tmp7_, _tmp8_ + 1, _tmp9_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp6_ - _tmp10_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp11_ = a;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp12_ = g;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp13_ = x;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp14_ = y;
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp15_ = computer_player_is_empty (_tmp12_, _tmp13_ + 1, _tmp14_ + 1);
#line 235 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp11_ - _tmp15_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp16_ = a;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp17_ = g;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp18_ = x;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp19_ = y;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp20_ = computer_player_is_empty (_tmp17_, _tmp18_, _tmp19_ + 1);
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp16_ - _tmp20_;
#line 237 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp21_ = a;
#line 237 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp22_ = g;
#line 237 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp23_ = x;
#line 237 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp24_ = y;
#line 237 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp25_ = computer_player_is_empty (_tmp22_, _tmp23_ - 1, _tmp24_ + 1);
#line 237 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp21_ - _tmp25_;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp26_ = a;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp27_ = g;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp28_ = x;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp29_ = y;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp30_ = computer_player_is_empty (_tmp27_, _tmp28_ - 1, _tmp29_);
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp26_ - _tmp30_;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp31_ = a;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp32_ = g;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp33_ = x;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp34_ = y;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp35_ = computer_player_is_empty (_tmp32_, _tmp33_ - 1, _tmp34_ - 1);
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp31_ - _tmp35_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp36_ = a;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp37_ = g;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp38_ = x;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp39_ = y;
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp40_ = computer_player_is_empty (_tmp37_, _tmp38_, _tmp39_ - 1);
#line 240 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp36_ - _tmp40_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp41_ = a;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp42_ = g;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp43_ = x;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp44_ = y;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp45_ = computer_player_is_empty (_tmp42_, _tmp43_ + 1, _tmp44_ - 1);
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							a = _tmp41_ - _tmp45_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp46_ = a;
#line 244 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (_tmp46_ == 0) {
#line 245 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								a = 2;
#line 1387 "computer-player.c"
							}
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp48_ = g;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp49_ = x;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp50_ = y;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp51_ = game_get_owner (_tmp48_, _tmp49_, _tmp50_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp52_ = g;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp53_ = game_get_current_color (_tmp52_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp54_ = _tmp53_;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (_tmp51_ == _tmp54_) {
#line 1405 "computer-player.c"
								gint _tmp55_ = 0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp55_ = a;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp47_ = _tmp55_;
#line 1411 "computer-player.c"
							} else {
								gint _tmp56_ = 0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp56_ = a;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp47_ = -_tmp56_;
#line 1418 "computer-player.c"
							}
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp57_ = count;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							count = _tmp57_ + _tmp47_;
#line 1424 "computer-player.c"
						}
					}
				}
			}
		}
	}
#line 251 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = count;
#line 251 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 1435 "computer-player.c"
}


static gint computer_player_is_empty (Game* g, gint x, gint y) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
#line 254 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp4_ = x;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp4_ < 0) {
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp3_ = TRUE;
#line 1454 "computer-player.c"
	} else {
		gint _tmp5_ = 0;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp5_ = x;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp3_ = _tmp5_ >= 8;
#line 1461 "computer-player.c"
	}
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp3_) {
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp2_ = TRUE;
#line 1467 "computer-player.c"
	} else {
		gint _tmp6_ = 0;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp6_ = y;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp2_ = _tmp6_ < 0;
#line 1474 "computer-player.c"
	}
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp2_) {
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp1_ = TRUE;
#line 1480 "computer-player.c"
	} else {
		gint _tmp7_ = 0;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp7_ = y;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp1_ = _tmp7_ >= 8;
#line 1487 "computer-player.c"
	}
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp1_) {
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp0_ = TRUE;
#line 1493 "computer-player.c"
	} else {
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Player _tmp11_ = 0;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp8_ = g;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp9_ = x;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp10_ = y;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp11_ = game_get_owner (_tmp8_, _tmp9_, _tmp10_);
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp0_ = _tmp11_ != PLAYER_NONE;
#line 1509 "computer-player.c"
	}
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp0_) {
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		result = 0;
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		return result;
#line 1517 "computer-player.c"
	}
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = 1;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 1523 "computer-player.c"
}


static void computer_player_random_select (Game* g, gint* move_x, gint* move_y) {
	gint _vala_move_x = 0;
	gint _vala_move_y = 0;
	GList* moves = NULL;
	GList* _tmp15_ = NULL;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (g != NULL);
#line 264 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	moves = NULL;
#line 1536 "computer-player.c"
	{
		gint x = 0;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		x = 0;
#line 1541 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1548 "computer-player.c"
				gint _tmp2_ = 0;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 1552 "computer-player.c"
					gint _tmp1_ = 0;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 1558 "computer-player.c"
				}
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
				if (!(_tmp2_ < 8)) {
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					break;
#line 1568 "computer-player.c"
				}
				{
					gint y = 0;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
					y = 0;
#line 1574 "computer-player.c"
					{
						gboolean _tmp3_ = FALSE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						_tmp3_ = TRUE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1581 "computer-player.c"
							gint _tmp5_ = 0;
							Game* _tmp6_ = NULL;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							Player _tmp10_ = 0;
							Player _tmp11_ = 0;
							gboolean _tmp12_ = FALSE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!_tmp3_) {
#line 1592 "computer-player.c"
								gint _tmp4_ = 0;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp4_ = y;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								y = _tmp4_ + 1;
#line 1598 "computer-player.c"
							}
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp3_ = FALSE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp5_ = y;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (!(_tmp5_ < 8)) {
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								break;
#line 1608 "computer-player.c"
							}
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp6_ = g;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp7_ = x;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp8_ = y;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp9_ = g;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp10_ = game_get_current_color (_tmp9_);
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp11_ = _tmp10_;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							_tmp12_ = game_can_place (_tmp6_, _tmp7_, _tmp8_, _tmp11_);
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
							if (_tmp12_) {
#line 1626 "computer-player.c"
								gint _tmp13_ = 0;
								gint _tmp14_ = 0;
#line 270 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp13_ = x;
#line 270 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								_tmp14_ = y;
#line 270 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
								moves = g_list_append (moves, (gpointer) ((gintptr) ((_tmp13_ * 8) + _tmp14_)));
#line 1635 "computer-player.c"
							}
						}
					}
				}
			}
		}
	}
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp15_ = moves;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (_tmp15_ != NULL) {
#line 1647 "computer-player.c"
		gint32 i = 0;
		GList* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		gint32 _tmp18_ = 0;
		gint xy = 0;
		GList* _tmp19_ = NULL;
		gint32 _tmp20_ = 0;
		gconstpointer _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp16_ = moves;
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp17_ = g_list_length (_tmp16_);
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp18_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp17_));
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		i = _tmp18_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp19_ = moves;
#line 276 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp20_ = i;
#line 276 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp21_ = g_list_nth_data (_tmp19_, (guint) _tmp20_);
#line 276 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		xy = (gint) ((gintptr) _tmp21_);
#line 277 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp22_ = xy;
#line 277 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_vala_move_x = _tmp22_ / 8;
#line 278 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp23_ = xy;
#line 278 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_vala_move_y = _tmp23_ % 8;
#line 1682 "computer-player.c"
	} else {
		gint _tmp24_ = 0;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_vala_move_y = 0;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_tmp24_ = _vala_move_y;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		_vala_move_x = _tmp24_;
#line 1691 "computer-player.c"
	}
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_g_list_free0 (moves);
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (move_x) {
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		*move_x = _vala_move_x;
#line 1699 "computer-player.c"
	}
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	if (move_y) {
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		*move_y = _vala_move_y;
#line 1705 "computer-player.c"
	}
}


gint computer_player_get_level (ComputerPlayer* self) {
	gint result;
	gint _tmp0_ = 0;
#line 44 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 44 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->_level;
#line 44 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	result = _tmp0_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return result;
#line 1721 "computer-player.c"
}


static void computer_player_set_level (ComputerPlayer* self, gint value) {
	gint _tmp0_ = 0;
#line 44 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = value;
#line 44 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self->priv->_level = _tmp0_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_object_notify ((GObject *) self, "level");
#line 1735 "computer-player.c"
}


static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 28 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	memset (self, 0, sizeof (ComputerPlayerPossibleMove));
#line 30 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp0_ = x;
#line 30 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	(*self).x = _tmp0_;
#line 31 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp1_ = y;
#line 31 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	(*self).y = _tmp1_;
#line 32 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_tmp2_ = n_tiles;
#line 32 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	(*self).n_tiles = _tmp2_;
#line 1757 "computer-player.c"
}


static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self) {
	ComputerPlayerPossibleMove* dup;
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	dup = g_new0 (ComputerPlayerPossibleMove, 1);
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	memcpy (dup, self, sizeof (ComputerPlayerPossibleMove));
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	return dup;
#line 1769 "computer-player.c"
}


static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self) {
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_free (self);
#line 1776 "computer-player.c"
}


static GType computer_player_possible_move_get_type (void) {
	static volatile gsize computer_player_possible_move_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_possible_move_type_id__volatile)) {
		GType computer_player_possible_move_type_id;
		computer_player_possible_move_type_id = g_boxed_type_register_static ("ComputerPlayerPossibleMove", (GBoxedCopyFunc) computer_player_possible_move_dup, (GBoxedFreeFunc) computer_player_possible_move_free);
		g_once_init_leave (&computer_player_possible_move_type_id__volatile, computer_player_possible_move_type_id);
	}
	return computer_player_possible_move_type_id__volatile;
}


static void computer_player_class_init (ComputerPlayerClass * klass) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	computer_player_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_type_class_add_private (klass, sizeof (ComputerPlayerPrivate));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_computer_player_get_property;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_computer_player_set_property;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->finalize = computer_player_finalize;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPUTER_PLAYER_LEVEL, g_param_spec_int ("level", "level", "level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1804 "computer-player.c"
}


static void computer_player_instance_init (ComputerPlayer * self) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self->priv = COMPUTER_PLAYER_GET_PRIVATE (self);
#line 1811 "computer-player.c"
}


static void computer_player_finalize (GObject* obj) {
	ComputerPlayer * self;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 41 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	_g_object_unref0 (self->priv->game);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (computer_player_parent_class)->finalize (obj);
#line 1823 "computer-player.c"
}


GType computer_player_get_type (void) {
	static volatile gsize computer_player_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComputerPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) computer_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComputerPlayer), 0, (GInstanceInitFunc) computer_player_instance_init, NULL };
		GType computer_player_type_id;
		computer_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ComputerPlayer", &g_define_type_info, 0);
		g_once_init_leave (&computer_player_type_id__volatile, computer_player_type_id);
	}
	return computer_player_type_id__volatile;
}


static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	switch (property_id) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_LEVEL:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		g_value_set_int (value, computer_player_get_level (self));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		break;
#line 1850 "computer-player.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		break;
#line 1856 "computer-player.c"
	}
}


static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
	switch (property_id) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_LEVEL:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		computer_player_set_level (self, g_value_get_int (value));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		break;
#line 1872 "computer-player.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/computer-player.vala"
		break;
#line 1878 "computer-player.c"
	}
}



