# Security Policy

## Supported Versions

Versions of the library that are currently being supported with security updates.

| Version | Supported          | Frameworks using this version       |
| ------- | ------------------ | ----------------------------------- |
| 1.4     | :white_check_mark: | DPDK 23.07                          |
| 1.3     | :white_check_mark: | DPDK 22.11, OpenSSL QAT Engine, VPP |
| 1.2     | :x:                | -                                   |
| 1.1     | :x:                | -                                   |
| 1.0     | :white_check_mark: | DPDK 21.11                          |
| < 1.0   | :x:                | -                                   |

## Reporting a Vulnerability

For reporting a vulnerability please follow steps from [Vulnerability Handling Guidelines](https://www.intel.com/content/www/us/en/security-center/vulnerability-handling-guidelines.html).

If the vulnerability is accepted then an update will be developed and provided against reported library version.
Timeline for providing an update depends on development complexity.

## Security Considerations & Options for Increased Security

Please refer to [Section of README](https://github.com/intel/intel-ipsec-mb#7-security-considerations--options-for-increased-security) for the details on this topic.


