#!/bin/python3

import pymongo, urllib, datetime, json, http.client

mongoHost = "127.0.0.1"
mongoPort = 27017
mongoDB = "hostdb"
mongoUsername = "ivulncheck"
mongoPassword = "ivulncheck"
mongoAuthSource = "admin"

mongoUsername = urllib.parse.quote( mongoUsername )
mongoPassword = urllib.parse.quote( mongoPassword )

if mongoUsername and mongoPassword:
    mongoURI = "mongodb://{username}:{password}@{host}:{port}/{db}?authSource={authsource}".format(
        username = mongoUsername, password = mongoPassword,
        host = mongoHost, port = mongoPort,
        db = mongoDB, authsource = mongoAuthSource
    )
    connect = pymongo.MongoClient(mongoURI, connect=False, serverSelectionTimeoutMS=10000)

date = connect["hostdb"]["hosts"].find()[0]['last_modified']

isodate = datetime.datetime.strptime(date, "%Y-%m-%dT%H:%M:%S.%f")

print(isodate.isoformat())

id = "CVE-2018-1111"
conn = http.client.HTTPConnection("int-domu-113", 5000)
conn.request('GET', "/api/cve/" + id)
rsp = conn.getresponse()
rsp_str = str(rsp.read().decode("utf-8"))
data =  json.loads(rsp_str)

isodate2 = datetime.datetime.strptime(data['Published'], "%Y-%m-%dT%H:%M:%S.%f")

print(isodate2.isoformat())

