/*
 * Copyright (c) 1997, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package jakarta.mail.search;

import jakarta.mail.MessagingException;


/**
 * The exception thrown when a Search expression could not be handled.
 *
 * @author John Mani
 */

public class SearchException extends MessagingException {

    private static final long serialVersionUID = -7092886778226268686L;

    /**
     * Constructs a SearchException with no detail message.
     */
    public SearchException() {
	super();
    }

    /**
     * Constructs a SearchException with the specified detail message.
     * @param s		the detail message
     */
    public SearchException(String s) {
	super(s);
    }
}
