#ifndef LAYOUT_H
#define LAYOUT_H

#include <QPainter>
#include <QList>
#include <poppler/qt4/poppler-qt4.h>
#include <map>
#include "../selection.h"


class Viewer;
class ResourceManager;
class Grid;
namespace Poppler {
	class LinkDestination;
}


class Layout {
public:
	Layout(Viewer *v, int _page = 0);
	virtual ~Layout();

	virtual int get_page() const;
	virtual void activate(const Layout *old_layout);
	virtual void rebuild(bool clamp = true);
	virtual void resize(int w, int h);
	virtual bool set_zoom(int new_zoom, bool relative = true);
	virtual bool set_columns(int new_columns, bool relative = true);
	virtual bool set_offset(int new_offset, bool relative = true);

	virtual bool supports_smooth_scrolling() const;
	virtual bool scroll_smooth(int dx, int dy);
	virtual bool scroll_page(int new_page, bool relative = true);
	virtual void render(QPainter *painter) = 0;

	virtual bool update_search();
	virtual void set_search_visible(bool visible);
	virtual bool advance_hit(bool forward = true);
	virtual bool advance_invisible_hit(bool forward = true) = 0;

	virtual std::pair<int, QPointF> get_location_at(int px, int py) = 0;
	virtual bool goto_link_destination(const Poppler::LinkDestination &link);
	virtual bool goto_page_at(int mx, int my);

	virtual bool activate_link(int page, float x, float y);

	virtual bool get_search_visible() const;
	virtual bool page_visible(int p) const = 0;

	bool select(int px, int py, enum Selection::Mode mode);
	void copy_selection_text();
	void clear_selection();

protected:
	void render_search_rects(QPainter *painter, int cur_page, QPoint offset, float size);
	void render_selection(QPainter *painter, int cur_page, QPoint offset, float size);
	virtual bool view_hit() = 0;

	Viewer *viewer;
	ResourceManager *res;
	int page;
	int width, height;

	// search results
	bool search_visible;
	int hit_page;
	QList<QRectF>::const_iterator hit_it;

	// config options
	int useless_gap;
	int min_page_width;
	int min_zoom;
	int max_zoom;
	float zoom_factor;
	int prefetch_count;
	float search_padding;

	MouseSelection selection;
};


#endif

