/*  This file is part of the KDE libraries
 *  Copyright 2010 John Layt <john@layt.net>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef KLOCALE_UNIX_P_H
#define KLOCALE_UNIX_P_H

#include "klocale_p.h"

class KLocaleUnixPrivate : public KLocalePrivate
{
public:
    KLocaleUnixPrivate( KLocale *q, const QString &catalog, KSharedConfig::Ptr config );

    KLocaleUnixPrivate(KLocale *q, const QString& catalog, const QString &language,
                       const QString &country, KConfig *config);

    KLocaleUnixPrivate( const KLocaleUnixPrivate &rhs );

    KLocaleUnixPrivate &operator=( const KLocaleUnixPrivate &rhs );

    virtual ~KLocaleUnixPrivate();
};

#endif // KLOCALE_UNIX_P_H
