"""ResNeXt models for Keras.

# Reference paper

- [Aggregated Residual Transformations for Deep Neural Networks]
  (https://arxiv.org/abs/1611.05431) (CVPR 2017)

# Reference implementations

- [TensorNets]
  (https://github.com/taehoonlee/tensornets/blob/master/tensornets/resnets.py)
- [Torch ResNeXt]
  (https://github.com/facebookresearch/ResNeXt/blob/master/models/resnext.lua)

"""
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import os

from . import imagenet_utils
from .imagenet_utils import decode_predictions
from .resnet_common import ResNeXt50
from .resnet_common import ResNeXt101


def preprocess_input(x, **kwargs):
    """Preprocesses a numpy array encoding a batch of images.

    # Arguments
        x: a 4D numpy array consists of RGB values within [0, 255].
        data_format: data format of the image tensor.

    # Returns
        Preprocessed array.
    """
    return imagenet_utils.preprocess_input(x, mode='torch', **kwargs)
