## Check_GNU_CXX.cmake

# get the gcc version
EXECUTE_PROCESS (COMMAND ${CMAKE_C_COMPILER} -dumpversion OUTPUT_VARIABLE _gcc_version_info)

STRING (REGEX MATCH "[345]\\.[0-9]\\.[0-9]" _gcc_version "${_gcc_version_info}")
# gcc on mac just reports: "gcc (GCC) 3.3 20030304 ..." without the patch level, handle this here:
IF (NOT _gcc_version)
  STRING (REGEX REPLACE ".*\\(GCC\\).* ([34]\\.[0-9]) .*" "\\1.0" _gcc_version "${_gcc_version_info}")
ENDIF (NOT _gcc_version)

MESSAGE (STATUS "Found GCC Version \"${_gcc_version}\" start performing tests...")
MACRO_ENSURE_VERSION ("4.1.0" "${_gcc_version}" GCC_IS_NEWER_THAN_4_1)
MACRO_ENSURE_VERSION ("4.2.0" "${_gcc_version}" GCC_IS_NEWER_THAN_4_2)
MACRO_ENSURE_VERSION ("4.5.0" "${_gcc_version}" GCC_IS_NEWER_THAN_4_5)
MACRO_ENSURE_VERSION ("4.6.0" "${_gcc_version}" GCC_IS_NEWER_THAN_4_6)

IF (CMAKE_SYSTEM_NAME MATCHES Linux)
  SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -Wnon-virtual-dtor -Wundef -Wcast-align -Wchar-subscripts -Wpointer-arith")
  SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -Wformat-security -Wctor-dtor-privacy -fno-exceptions")
  ADD_DEFINITIONS (-D_BSD_SOURCE -DQT_NO_EXCEPTIONS)
ENDIF (CMAKE_SYSTEM_NAME MATCHES Linux)

# gcc under Windows
IF (MINGW)
  SET (CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} -Wl,--export-all-symbols -Wl,--disable-auto-import")
  SET (CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} -Wl,--export-all-symbols -Wl,--disable-auto-import")
  ADD_DEFINITIONS(-DQT_NO_DEBUG)
ENDIF (MINGW)

# VISIBILITY SUPPORT http://gcc.gnu.org/wiki/Visibility
IF (GCC_IS_NEWER_THAN_4_1)
  CHECK_CXX_COMPILER_FLAG (-fvisibility=hidden __CHECK_GCC_VISIBILITY)
  SET (__CHECK_GCC_VISIBILITY ${__CHECK_GCC_VISIBILITY} CACHE BOOL "GCC support for hidden visibility")
  IF (__CHECK_GCC_VISIBILITY)
    SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fvisibility=hidden")
    IF (GCC_IS_NEWER_THAN_4_2)
      SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -DHAVE_VISIBILITY -fvisibility-inlines-hidden")
      ## Bugfix gcc-4.3 need explicit definition
      ADD_DEFINITIONS (-DHAVE_VISIBILITY)
    ENDIF (GCC_IS_NEWER_THAN_4_2)
  ENDIF (__CHECK_GCC_VISIBILITY)
ENDIF (GCC_IS_NEWER_THAN_4_1)

# STACK-PROTECTOR SUPPORT
IF (GCC_IS_NEWER_THAN_4_1)
  CHECK_CXX_COMPILER_FLAG(-fstack-protector __CHECK_GCC_STACK_PROTECTOR)
  SET (__CHECK_GCC_STACK_PROTECTOR ${__CHECK_GCC_STACK_PROTECTOR} CACHE BOOL "GCC support for stack-protector")
  IF (__CHECK_GCC_STACK_PROTECTOR)
    SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fstack-protector -Wstack-protector")
  ENDIF (__CHECK_GCC_STACK_PROTECTOR)
  # BUFFER CHECKS
  CHECK_CXX_COMPILER_FLAG(-D_FORTIFY_SOURCE=2 __CHECK_GCC_FORTIFY_SOURCE)
  SET (__CHECK_GCC_FORTIFY_SOURCE ${__CHECK_GCC_FORTIFY_SOURCE} CACHE BOOL "GCC support for -DFORTIFY_SOURCE")
  IF(__CHECK_GCC_FORTIFY_SOURCE)
    SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -D_FORTIFY_SOURCE=2")
  ENDIF(__CHECK_GCC_FORTIFY_SOURCE)
ENDIF (GCC_IS_NEWER_THAN_4_1)

# EMIT POSITION-INDEPENDENT CODE
CHECK_CXX_COMPILER_FLAG(-fPIC __CHECK_GCC_FPIC)
SET (__CHECK_GCC_FPIC ${__CHECK_GCC_FPIC} CACHE BOOL "GCC support for -fPIC")
IF (__CHECK_GCC_FPIC)
  SET (LIB_FPIC_CXXFLAGS "-fPIC")
ELSE (__CHECK_GCC_FPIC)
  SET (LIB_FPIC_CXXFLAGS "${CMAKE_SHARED_LIBRARY_CXX_FLAGS}")
ENDIF (__CHECK_GCC_FPIC)

# GIVES SOME ADVANTAGES OVER PIE
CHECK_CXX_COMPILER_FLAG(-pie __CHECK_GCC_FPIE)
SET (__CHECK_GCC_FPIE ${__CHECK_GCC_FPIE} CACHE BOOL "GCC support for -pie")
IF (__CHECK_GCC_FPIE)
  SET (APP_PIE_CXXFLAGS "-fPIE")
  SET (APP_PIE_LDFLAGS "-pie")
ELSE (__CHECK_GCC_FPIE)
  SET (APP_PIE_CXXFLAGS "")
  SET (APP_PIE_LDFLAGS "")
ENDIF (__CHECK_GCC_FPIE)

# PASS THE FLAG -EXPORT-DYNAMIC TO THE ELF LINKER, ON TARGETS THAT SUPPORT IT.
CHECK_CXX_COMPILER_FLAG(-rdynamic __CHECK_LINK_RDYNAMIC)
SET (__CHECK_LINK_RDYNAMIC ${__CHECK_LINK_RDYNAMIC} CACHE BOOL "compiler support for -rdynamic")
IF (__CHECK_LINK_RDYNAMIC)
  SET (LIB_RDYNAMIC_CXXFLAGS "-rdynamic")
ELSE (__CHECK_LINK_RDYNAMIC)
  SET (LIB_RDYNAMIC_CXXFLAGS "")
ENDIF (__CHECK_LINK_RDYNAMIC)

IF (GCC_IS_NEWER_THAN_4_5)
  CHECK_CXX_COMPILER_FLAG(-funwind-tables __CHECK_GCC_UNWIND_TABLES)
  SET (__CHECK_GCC_UNWIND_TABLES ${__CHECK_GCC_FPIE} CACHE BOOL "GCC support for -funwind-tables")
  IF (__CHECK_GCC_UNWIND_TABLES)
    SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -funwind-tables")
    IF (GCC_IS_NEWER_THAN_4_6)
      SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fasynchronous-unwind-tables")
    ENDIF (GCC_IS_NEWER_THAN_4_6)
  ENDIF (__CHECK_GCC_UNWIND_TABLES)
ENDIF (GCC_IS_NEWER_THAN_4_5)

IF (CMAKE_BUILD_TYPE STREQUAL "Debug")
  MESSAGE (STATUS "Performing CMAKE_CXX_FLAGS_DEBUG")
  IF (GCC_IS_NEWER_THAN_4_5 AND __CHECK_GCC_STACK_PROTECTOR)
    SET (CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} -fstack-check")
  ENDIF (GCC_IS_NEWER_THAN_4_5 AND __CHECK_GCC_STACK_PROTECTOR)
  SET (CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} -Wall -W -Wabi -Wextra -Wvla -Wno-long-long -Wunused -Wold-style-cast -Woverloaded-virtual -Wmissing-include-dirs -Wwrite-strings")
  IF (GCC_IS_NEWER_THAN_4_6)
    SET (CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} -fverbose-asm")
  ENDIF (GCC_IS_NEWER_THAN_4_6)
ELSE (CMAKE_BUILD_TYPE STREQUAL "Debug")
  SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -Wall -W -Wno-long-long")
  IF (GCC_IS_NEWER_THAN_4_6)
    SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -Wno-missing-declarations -Wno-old-style-cast")
  ENDIF (GCC_IS_NEWER_THAN_4_6)
ENDIF (CMAKE_BUILD_TYPE STREQUAL "Debug")
