/* post_processors.c generated by valac 0.18.0.41-7575d, the Vala compiler
 * generated from post_processors.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define TYPE_POST_PROCESSOR (post_processor_get_type ())
#define POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POST_PROCESSOR, PostProcessor))
#define POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POST_PROCESSOR, PostProcessorClass))
#define IS_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POST_PROCESSOR))
#define IS_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POST_PROCESSOR))
#define POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POST_PROCESSOR, PostProcessorClass))

typedef struct _PostProcessor PostProcessor;
typedef struct _PostProcessorClass PostProcessorClass;
typedef struct _PostProcessorPrivate PostProcessorPrivate;

#define TYPE_BUILD_MSG (build_msg_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())
typedef struct _BuildMsg BuildMsg;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NO_OUTPUT_POST_PROCESSOR (no_output_post_processor_get_type ())
#define NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessor))
#define NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))
#define IS_NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define IS_NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define NO_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))

typedef struct _NoOutputPostProcessor NoOutputPostProcessor;
typedef struct _NoOutputPostProcessorClass NoOutputPostProcessorClass;
typedef struct _NoOutputPostProcessorPrivate NoOutputPostProcessorPrivate;

#define TYPE_ALL_OUTPUT_POST_PROCESSOR (all_output_post_processor_get_type ())
#define ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessor))
#define ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))
#define IS_ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define IS_ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define ALL_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))

typedef struct _AllOutputPostProcessor AllOutputPostProcessor;
typedef struct _AllOutputPostProcessorClass AllOutputPostProcessorClass;
typedef struct _AllOutputPostProcessorPrivate AllOutputPostProcessorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RUBBER_POST_PROCESSOR (rubber_post_processor_get_type ())
#define RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessor))
#define RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))
#define IS_RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RUBBER_POST_PROCESSOR))
#define IS_RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RUBBER_POST_PROCESSOR))
#define RUBBER_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))

typedef struct _RubberPostProcessor RubberPostProcessor;
typedef struct _RubberPostProcessorClass RubberPostProcessorClass;
typedef struct _RubberPostProcessorPrivate RubberPostProcessorPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

#define TYPE_LATEXMK_POST_PROCESSOR (latexmk_post_processor_get_type ())
#define LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessor))
#define LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))
#define IS_LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXMK_POST_PROCESSOR))
#define IS_LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXMK_POST_PROCESSOR))
#define LATEXMK_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))

typedef struct _LatexmkPostProcessor LatexmkPostProcessor;
typedef struct _LatexmkPostProcessorClass LatexmkPostProcessorClass;
typedef struct _LatexmkPostProcessorPrivate LatexmkPostProcessorPrivate;

#define TYPE_LATEX_POST_PROCESSOR (latex_post_processor_get_type ())
#define LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessor))
#define LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))
#define IS_LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_POST_PROCESSOR))
#define IS_LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_POST_PROCESSOR))
#define LATEX_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))

typedef struct _LatexPostProcessor LatexPostProcessor;
typedef struct _LatexPostProcessorClass LatexPostProcessorClass;
#define _build_msg_free0(var) ((var == NULL) ? NULL : (var = (build_msg_free (var), NULL)))

typedef enum  {
	BUILD_MSG_TYPE_TITLE,
	BUILD_MSG_TYPE_JOB_TITLE,
	BUILD_MSG_TYPE_JOB_SUB_COMMAND,
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_INFO
} BuildMsgType;

struct _BuildMsg {
	BuildMsgType type;
	gchar* text;
	gchar* filename;
	gint start_line;
	gint end_line;
	gboolean expand;
	GeeList* children;
};

struct _PostProcessor {
	GObject parent_instance;
	PostProcessorPrivate * priv;
	GeeList* _all_messages;
	gboolean _has_details;
	GeeList* _messages_without_details;
};

struct _PostProcessorClass {
	GObjectClass parent_class;
	void (*process) (PostProcessor* self, GFile* file, const gchar* output);
};

struct _NoOutputPostProcessor {
	PostProcessor parent_instance;
	NoOutputPostProcessorPrivate * priv;
};

struct _NoOutputPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _AllOutputPostProcessor {
	PostProcessor parent_instance;
	AllOutputPostProcessorPrivate * priv;
};

struct _AllOutputPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _RubberPostProcessor {
	PostProcessor parent_instance;
	RubberPostProcessorPrivate * priv;
};

struct _RubberPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _LatexmkPostProcessor {
	PostProcessor parent_instance;
	LatexmkPostProcessorPrivate * priv;
};

struct _LatexmkPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _LatexmkPostProcessorPrivate {
	gint _exit_status;
};


static gpointer post_processor_parent_class = NULL;
static gpointer no_output_post_processor_parent_class = NULL;
static gpointer all_output_post_processor_parent_class = NULL;
static gpointer rubber_post_processor_parent_class = NULL;
static GRegex* rubber_post_processor__pattern;
static GRegex* rubber_post_processor__pattern = NULL;
static gpointer latexmk_post_processor_parent_class = NULL;
static GRegex* latexmk_post_processor__reg_rule;
static GRegex* latexmk_post_processor__reg_rule = NULL;
static GRegex* latexmk_post_processor__reg_no_rule;
static GRegex* latexmk_post_processor__reg_no_rule = NULL;

GType post_processor_get_type (void) G_GNUC_CONST;
GType build_msg_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
enum  {
	POST_PROCESSOR_DUMMY_PROPERTY
};
gboolean post_processor_has_details (PostProcessor* self);
GeeList* post_processor_get_messages (PostProcessor* self);
GeeList* post_processor_get_detailed_messages (PostProcessor* self);
void post_processor_process (PostProcessor* self, GFile* file, const gchar* output);
static void post_processor_real_process (PostProcessor* self, GFile* file, const gchar* output);
PostProcessor* post_processor_construct (GType object_type);
static void post_processor_finalize (GObject* obj);
GType no_output_post_processor_get_type (void) G_GNUC_CONST;
enum  {
	NO_OUTPUT_POST_PROCESSOR_DUMMY_PROPERTY
};
static void no_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
NoOutputPostProcessor* no_output_post_processor_new (void);
NoOutputPostProcessor* no_output_post_processor_construct (GType object_type);
GType all_output_post_processor_get_type (void) G_GNUC_CONST;
enum  {
	ALL_OUTPUT_POST_PROCESSOR_DUMMY_PROPERTY
};
static void all_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
void build_msg_init (BuildMsg *self);
AllOutputPostProcessor* all_output_post_processor_new (void);
AllOutputPostProcessor* all_output_post_processor_construct (GType object_type);
GType rubber_post_processor_get_type (void) G_GNUC_CONST;
enum  {
	RUBBER_POST_PROCESSOR_DUMMY_PROPERTY
};
RubberPostProcessor* rubber_post_processor_new (void);
RubberPostProcessor* rubber_post_processor_construct (GType object_type);
static void rubber_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
static void rubber_post_processor_finalize (GObject* obj);
GType latexmk_post_processor_get_type (void) G_GNUC_CONST;
#define LATEXMK_POST_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorPrivate))
enum  {
	LATEXMK_POST_PROCESSOR_DUMMY_PROPERTY
};
LatexmkPostProcessor* latexmk_post_processor_new (gint exit_status);
LatexmkPostProcessor* latexmk_post_processor_construct (GType object_type, gint exit_status);
static void latexmk_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
LatexPostProcessor* latex_post_processor_new (void);
LatexPostProcessor* latex_post_processor_construct (GType object_type);
GType latex_post_processor_get_type (void) G_GNUC_CONST;
static void latexmk_post_processor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gboolean post_processor_has_details (PostProcessor* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->_has_details;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeeList* post_processor_get_messages (PostProcessor* self) {
	GeeList* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_has_details;
	if (_tmp0_) {
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		_tmp1_ = self->_messages_without_details;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		_tmp3_ = self->_all_messages;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	}
}


GeeList* post_processor_get_detailed_messages (PostProcessor* self) {
	GeeList* result = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_all_messages;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void post_processor_real_process (PostProcessor* self, GFile* file, const gchar* output) {
	g_critical ("Type `%s' does not implement abstract method `post_processor_process'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void post_processor_process (PostProcessor* self, GFile* file, const gchar* output) {
	g_return_if_fail (self != NULL);
	POST_PROCESSOR_GET_CLASS (self)->process (self, file, output);
}


PostProcessor* post_processor_construct (GType object_type) {
	PostProcessor * self = NULL;
	self = (PostProcessor*) g_object_new (object_type, NULL);
	return self;
}


static void post_processor_class_init (PostProcessorClass * klass) {
	post_processor_parent_class = g_type_class_peek_parent (klass);
	POST_PROCESSOR_CLASS (klass)->process = post_processor_real_process;
	G_OBJECT_CLASS (klass)->finalize = post_processor_finalize;
}


static void post_processor_instance_init (PostProcessor * self) {
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	_tmp0_ = gee_linked_list_new (TYPE_BUILD_MSG, (GBoxedCopyFunc) build_msg_dup, build_msg_free, NULL);
	self->_all_messages = (GeeList*) _tmp0_;
	self->_has_details = FALSE;
	_tmp1_ = gee_linked_list_new (TYPE_BUILD_MSG, (GBoxedCopyFunc) build_msg_dup, build_msg_free, NULL);
	self->_messages_without_details = (GeeList*) _tmp1_;
}


static void post_processor_finalize (GObject* obj) {
	PostProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POST_PROCESSOR, PostProcessor);
	_g_object_unref0 (self->_all_messages);
	_g_object_unref0 (self->_messages_without_details);
	G_OBJECT_CLASS (post_processor_parent_class)->finalize (obj);
}


GType post_processor_get_type (void) {
	static volatile gsize post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PostProcessor), 0, (GInstanceInitFunc) post_processor_instance_init, NULL };
		GType post_processor_type_id;
		post_processor_type_id = g_type_register_static (G_TYPE_OBJECT, "PostProcessor", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&post_processor_type_id__volatile, post_processor_type_id);
	}
	return post_processor_type_id__volatile;
}


static void no_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	NoOutputPostProcessor * self;
	self = (NoOutputPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
}


NoOutputPostProcessor* no_output_post_processor_construct (GType object_type) {
	NoOutputPostProcessor * self = NULL;
	self = (NoOutputPostProcessor*) post_processor_construct (object_type);
	return self;
}


NoOutputPostProcessor* no_output_post_processor_new (void) {
	return no_output_post_processor_construct (TYPE_NO_OUTPUT_POST_PROCESSOR);
}


static void no_output_post_processor_class_init (NoOutputPostProcessorClass * klass) {
	no_output_post_processor_parent_class = g_type_class_peek_parent (klass);
	POST_PROCESSOR_CLASS (klass)->process = no_output_post_processor_real_process;
}


static void no_output_post_processor_instance_init (NoOutputPostProcessor * self) {
}


GType no_output_post_processor_get_type (void) {
	static volatile gsize no_output_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&no_output_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NoOutputPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) no_output_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NoOutputPostProcessor), 0, (GInstanceInitFunc) no_output_post_processor_instance_init, NULL };
		GType no_output_post_processor_type_id;
		no_output_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "NoOutputPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&no_output_post_processor_type_id__volatile, no_output_post_processor_type_id);
	}
	return no_output_post_processor_type_id__volatile;
}


static void all_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	AllOutputPostProcessor * self;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint nb_lines;
	gint _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	BuildMsg message = {0};
	self = (AllOutputPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	_tmp0_ = output;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = output;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "\n", 0);
	lines = _tmp5_;
	lines_length1 = _vala_array_length (_tmp4_);
	_lines_size_ = lines_length1;
	_tmp6_ = lines;
	_tmp6__length1 = lines_length1;
	nb_lines = _tmp6__length1;
	_tmp7_ = nb_lines;
	g_return_if_fail (_tmp7_ > 0);
	_tmp8_ = lines;
	_tmp8__length1 = lines_length1;
	_tmp9_ = nb_lines;
	_tmp10_ = _tmp8_[_tmp9_ - 1];
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == 0) {
		gint _tmp13_;
		_tmp13_ = nb_lines;
		nb_lines = _tmp13_ - 1;
	}
	build_msg_init (&message);
	{
		gint line_num;
		line_num = 0;
		{
			gboolean _tmp14_;
			_tmp14_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_;
				gint _tmp17_;
				gint _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				GeeList* _tmp23_;
				BuildMsg _tmp24_;
				_tmp15_ = _tmp14_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = line_num;
					line_num = _tmp16_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp17_ = line_num;
				_tmp18_ = nb_lines;
				if (!(_tmp17_ < _tmp18_)) {
					break;
				}
				_tmp19_ = lines;
				_tmp19__length1 = lines_length1;
				_tmp20_ = line_num;
				_tmp21_ = _tmp19_[_tmp20_];
				_tmp22_ = g_strdup (_tmp21_);
				_g_free0 (message.text);
				message.text = _tmp22_;
				_tmp23_ = ((PostProcessor*) self)->_all_messages;
				_tmp24_ = message;
				gee_collection_add ((GeeCollection*) _tmp23_, &_tmp24_);
			}
		}
	}
	build_msg_destroy (&message);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


AllOutputPostProcessor* all_output_post_processor_construct (GType object_type) {
	AllOutputPostProcessor * self = NULL;
	self = (AllOutputPostProcessor*) post_processor_construct (object_type);
	return self;
}


AllOutputPostProcessor* all_output_post_processor_new (void) {
	return all_output_post_processor_construct (TYPE_ALL_OUTPUT_POST_PROCESSOR);
}


static void all_output_post_processor_class_init (AllOutputPostProcessorClass * klass) {
	all_output_post_processor_parent_class = g_type_class_peek_parent (klass);
	POST_PROCESSOR_CLASS (klass)->process = all_output_post_processor_real_process;
}


static void all_output_post_processor_instance_init (AllOutputPostProcessor * self) {
}


GType all_output_post_processor_get_type (void) {
	static volatile gsize all_output_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&all_output_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AllOutputPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) all_output_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AllOutputPostProcessor), 0, (GInstanceInitFunc) all_output_post_processor_instance_init, NULL };
		GType all_output_post_processor_type_id;
		all_output_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "AllOutputPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&all_output_post_processor_type_id__volatile, all_output_post_processor_type_id);
	}
	return all_output_post_processor_type_id__volatile;
}


RubberPostProcessor* rubber_post_processor_construct (GType object_type) {
	RubberPostProcessor * self = NULL;
	GRegex* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (RubberPostProcessor*) post_processor_construct (object_type);
	_tmp0_ = rubber_post_processor__pattern;
	if (_tmp0_ != NULL) {
		return self;
	}
	{
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("(?P<file>[^:\n]+)(:(?P<line>[\\d\\-]+))?:(?P<text>.+)$", G_REGEX_MULTILINE | G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch45_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (rubber_post_processor__pattern);
		rubber_post_processor__pattern = _tmp2_;
	}
	goto __finally45;
	__catch45_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("post_processors.vala:102: RubberPostProcessor: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally45:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


RubberPostProcessor* rubber_post_processor_new (void) {
	return rubber_post_processor_construct (TYPE_RUBBER_POST_PROCESSOR);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void rubber_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	RubberPostProcessor * self;
	GRegex* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* parent_path;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp6_;
	const gchar* _tmp7_;
	GMatchInfo* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RubberPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	_tmp0_ = rubber_post_processor__pattern;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = file;
	_tmp2_ = g_file_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_parse_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	parent_path = _tmp5_;
	_tmp6_ = rubber_post_processor__pattern;
	_tmp7_ = output;
	g_regex_match (_tmp6_, _tmp7_, 0, &_tmp8_);
	_g_match_info_free0 (match_info);
	match_info = _tmp8_;
	while (TRUE) {
		GMatchInfo* _tmp9_;
		gboolean _tmp10_ = FALSE;
		BuildMsg message = {0};
		GMatchInfo* _tmp11_;
		gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		BuildMsg _tmp14_;
		const gchar* _tmp15_;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp20_;
		GMatchInfo* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* line;
		gboolean _tmp23_ = FALSE;
		const gchar* _tmp24_;
		gboolean _tmp28_;
		GMatchInfo* _tmp49_;
		gchar* _tmp50_ = NULL;
		BuildMsg _tmp51_;
		const gchar* _tmp52_;
		gchar _tmp53_ = '\0';
		GeeList* _tmp58_;
		BuildMsg _tmp59_;
		_tmp9_ = match_info;
		_tmp10_ = g_match_info_matches (_tmp9_);
		if (!_tmp10_) {
			break;
		}
		build_msg_init (&message);
		_tmp11_ = match_info;
		_tmp12_ = g_match_info_fetch_named (_tmp11_, "text");
		_g_free0 (message.text);
		message.text = _tmp12_;
		message.type = BUILD_MSG_TYPE_ERROR;
		_tmp14_ = message;
		_tmp15_ = _tmp14_.text;
		_tmp16_ = string_contains (_tmp15_, "Underfull");
		if (_tmp16_) {
			_tmp13_ = TRUE;
		} else {
			BuildMsg _tmp17_;
			const gchar* _tmp18_;
			gboolean _tmp19_ = FALSE;
			_tmp17_ = message;
			_tmp18_ = _tmp17_.text;
			_tmp19_ = string_contains (_tmp18_, "Overfull");
			_tmp13_ = _tmp19_;
		}
		_tmp20_ = _tmp13_;
		if (_tmp20_) {
			message.type = BUILD_MSG_TYPE_BADBOX;
		}
		_tmp21_ = match_info;
		_tmp22_ = g_match_info_fetch_named (_tmp21_, "line");
		line = _tmp22_;
		_tmp24_ = line;
		if (_tmp24_ != NULL) {
			const gchar* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp25_ = line;
			_tmp26_ = strlen (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp23_ = 0 < _tmp27_;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp28_ = _tmp23_;
		if (_tmp28_) {
			const gchar* _tmp29_;
			gchar** _tmp30_;
			gchar** _tmp31_ = NULL;
			gchar** parts;
			gint parts_length1;
			gint _parts_size_;
			gchar** _tmp32_;
			gint _tmp32__length1;
			const gchar* _tmp33_;
			gint _tmp34_ = 0;
			gboolean _tmp35_ = FALSE;
			gboolean _tmp36_ = FALSE;
			gchar** _tmp37_;
			gint _tmp37__length1;
			gboolean _tmp40_;
			gboolean _tmp45_;
			_tmp29_ = line;
			_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, "-", 0);
			parts = _tmp31_;
			parts_length1 = _vala_array_length (_tmp30_);
			_parts_size_ = parts_length1;
			_tmp32_ = parts;
			_tmp32__length1 = parts_length1;
			_tmp33_ = _tmp32_[0];
			_tmp34_ = atoi (_tmp33_);
			message.start_line = _tmp34_;
			_tmp37_ = parts;
			_tmp37__length1 = parts_length1;
			if (1 < _tmp37__length1) {
				gchar** _tmp38_;
				gint _tmp38__length1;
				const gchar* _tmp39_;
				_tmp38_ = parts;
				_tmp38__length1 = parts_length1;
				_tmp39_ = _tmp38_[1];
				_tmp36_ = _tmp39_ != NULL;
			} else {
				_tmp36_ = FALSE;
			}
			_tmp40_ = _tmp36_;
			if (_tmp40_) {
				gchar** _tmp41_;
				gint _tmp41__length1;
				const gchar* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				_tmp41_ = parts;
				_tmp41__length1 = parts_length1;
				_tmp42_ = _tmp41_[1];
				_tmp43_ = strlen (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp35_ = 0 < _tmp44_;
			} else {
				_tmp35_ = FALSE;
			}
			_tmp45_ = _tmp35_;
			if (_tmp45_) {
				gchar** _tmp46_;
				gint _tmp46__length1;
				const gchar* _tmp47_;
				gint _tmp48_ = 0;
				_tmp46_ = parts;
				_tmp46__length1 = parts_length1;
				_tmp47_ = _tmp46_[1];
				_tmp48_ = atoi (_tmp47_);
				message.end_line = _tmp48_;
			}
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp49_ = match_info;
		_tmp50_ = g_match_info_fetch_named (_tmp49_, "file");
		_g_free0 (message.filename);
		message.filename = _tmp50_;
		_tmp51_ = message;
		_tmp52_ = _tmp51_.filename;
		_tmp53_ = string_get (_tmp52_, (glong) 0);
		if (_tmp53_ != '/') {
			const gchar* _tmp54_;
			BuildMsg _tmp55_;
			const gchar* _tmp56_;
			gchar* _tmp57_ = NULL;
			_tmp54_ = parent_path;
			_tmp55_ = message;
			_tmp56_ = _tmp55_.filename;
			_tmp57_ = g_strdup_printf ("%s/%s", _tmp54_, _tmp56_);
			_g_free0 (message.filename);
			message.filename = _tmp57_;
		}
		_tmp58_ = ((PostProcessor*) self)->_all_messages;
		_tmp59_ = message;
		gee_collection_add ((GeeCollection*) _tmp58_, &_tmp59_);
		{
			GMatchInfo* _tmp60_;
			_tmp60_ = match_info;
			g_match_info_next (_tmp60_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch46_g_regex_error;
				}
				_g_free0 (line);
				build_msg_destroy (&message);
				_g_match_info_free0 (match_info);
				_g_free0 (parent_path);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally46;
		__catch46_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp61_;
			const gchar* _tmp62_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp61_ = e;
			_tmp62_ = _tmp61_->message;
			g_warning ("post_processors.vala:150: RubberPostProcessor: %s", _tmp62_);
			_g_error_free0 (e);
			_g_free0 (line);
			build_msg_destroy (&message);
			break;
		}
		__finally46:
		if (_inner_error_ != NULL) {
			_g_free0 (line);
			build_msg_destroy (&message);
			_g_match_info_free0 (match_info);
			_g_free0 (parent_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (line);
		build_msg_destroy (&message);
	}
	_g_match_info_free0 (match_info);
	_g_free0 (parent_path);
}


static void rubber_post_processor_class_init (RubberPostProcessorClass * klass) {
	rubber_post_processor_parent_class = g_type_class_peek_parent (klass);
	POST_PROCESSOR_CLASS (klass)->process = rubber_post_processor_real_process;
	G_OBJECT_CLASS (klass)->finalize = rubber_post_processor_finalize;
}


static void rubber_post_processor_instance_init (RubberPostProcessor * self) {
}


static void rubber_post_processor_finalize (GObject* obj) {
	RubberPostProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessor);
	G_OBJECT_CLASS (rubber_post_processor_parent_class)->finalize (obj);
}


GType rubber_post_processor_get_type (void) {
	static volatile gsize rubber_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&rubber_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RubberPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rubber_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RubberPostProcessor), 0, (GInstanceInitFunc) rubber_post_processor_instance_init, NULL };
		GType rubber_post_processor_type_id;
		rubber_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "RubberPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&rubber_post_processor_type_id__volatile, rubber_post_processor_type_id);
	}
	return rubber_post_processor_type_id__volatile;
}


LatexmkPostProcessor* latexmk_post_processor_construct (GType object_type, gint exit_status) {
	LatexmkPostProcessor * self = NULL;
	gint _tmp0_;
	GRegex* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (LatexmkPostProcessor*) post_processor_construct (object_type);
	_tmp0_ = exit_status;
	self->priv->_exit_status = _tmp0_;
	_tmp1_ = latexmk_post_processor__reg_rule;
	if (_tmp1_ != NULL) {
		return self;
	}
	{
		gchar* _tmp2_;
		gchar* ungreedy_lines;
		gchar* _tmp3_;
		gchar* reg_rule_str;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		GRegex* _tmp34_;
		GRegex* _tmp35_;
		gchar* _tmp36_;
		gchar* reg_no_rule_str;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		const gchar* _tmp41_;
		GRegex* _tmp42_;
		GRegex* _tmp43_;
		_tmp2_ = g_strdup ("((?U)(.*\\R)*)");
		ungreedy_lines = _tmp2_;
		_tmp3_ = g_strdup ("(?P<title>Run number \\d+ of rule '(?P<rule>.*)')\\R");
		reg_rule_str = _tmp3_;
		_tmp4_ = reg_rule_str;
		_tmp5_ = g_strconcat (_tmp4_, "(-{12}\\R){2}", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp5_;
		_tmp6_ = reg_rule_str;
		_tmp7_ = g_strconcat (_tmp6_, "Running '(?P<cmd>.*)'\\R", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp7_;
		_tmp8_ = reg_rule_str;
		_tmp9_ = g_strconcat (_tmp8_, "-{12}\\R", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp9_;
		_tmp10_ = reg_rule_str;
		_tmp11_ = ungreedy_lines;
		_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp12_;
		_tmp13_ = reg_rule_str;
		_tmp14_ = g_strconcat (_tmp13_, "(Latexmk: applying rule .*\\R)+", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp14_;
		_tmp15_ = reg_rule_str;
		_tmp16_ = g_strconcat (_tmp15_, "(For rule '.*', running .*\\R)?", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp16_;
		_tmp17_ = reg_rule_str;
		_tmp18_ = ungreedy_lines;
		_tmp19_ = g_strconcat ("(?P<output>", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, ")", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp17_, _tmp22_, NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp23_;
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_tmp24_ = reg_rule_str;
		_tmp25_ = ungreedy_lines;
		_tmp26_ = g_strconcat ("(?P<latexmk>(Latexmk:|Rule '.*':)", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp27_, ")", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp24_, _tmp29_, NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp30_;
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_tmp31_ = reg_rule_str;
		_tmp32_ = g_strconcat (_tmp31_, "(-{12}\\R|$)", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp32_;
		_tmp33_ = reg_rule_str;
		_tmp34_ = g_regex_new (_tmp33_, G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp35_ = _tmp34_;
		if (_inner_error_ != NULL) {
			_g_free0 (reg_rule_str);
			_g_free0 (ungreedy_lines);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch47_g_regex_error;
			}
			_g_free0 (reg_rule_str);
			_g_free0 (ungreedy_lines);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latexmk_post_processor__reg_rule);
		latexmk_post_processor__reg_rule = _tmp35_;
		_tmp36_ = g_strdup ("(Latexmk: This is Latexmk.*\\R)?");
		reg_no_rule_str = _tmp36_;
		_tmp37_ = reg_no_rule_str;
		_tmp38_ = g_strconcat (_tmp37_, "(\\*{4} Report bugs.*\\R)?", NULL);
		_g_free0 (reg_no_rule_str);
		reg_no_rule_str = _tmp38_;
		_tmp39_ = reg_no_rule_str;
		_tmp40_ = g_strconcat (_tmp39_, "(?P<output>(.*\\R)*)", NULL);
		_g_free0 (reg_no_rule_str);
		reg_no_rule_str = _tmp40_;
		_tmp41_ = reg_no_rule_str;
		_tmp42_ = g_regex_new (_tmp41_, 0, 0, &_inner_error_);
		_tmp43_ = _tmp42_;
		if (_inner_error_ != NULL) {
			_g_free0 (reg_no_rule_str);
			_g_free0 (reg_rule_str);
			_g_free0 (ungreedy_lines);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch47_g_regex_error;
			}
			_g_free0 (reg_no_rule_str);
			_g_free0 (reg_rule_str);
			_g_free0 (ungreedy_lines);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latexmk_post_processor__reg_no_rule);
		latexmk_post_processor__reg_no_rule = _tmp43_;
		_g_free0 (reg_no_rule_str);
		_g_free0 (reg_rule_str);
		_g_free0 (ungreedy_lines);
	}
	goto __finally47;
	__catch47_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		g_warning ("post_processors.vala:195: LatexmkPostProcessor: %s", _tmp45_);
		_g_error_free0 (e);
	}
	__finally47:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


LatexmkPostProcessor* latexmk_post_processor_new (gint exit_status) {
	return latexmk_post_processor_construct (TYPE_LATEXMK_POST_PROCESSOR, exit_status);
}


static void latexmk_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	LatexmkPostProcessor * self;
	gboolean _tmp0_ = FALSE;
	GRegex* _tmp1_;
	gboolean _tmp3_;
	gchar* last_latex_output;
	gint last_latex_child_num;
	gboolean last_rule_is_latex_rule;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	const gchar* _tmp59_;
	GeeList* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	AllOutputPostProcessor* _tmp87_;
	PostProcessor* all_output_pp;
	GRegex* _tmp88_;
	const gchar* _tmp89_;
	GMatchInfo* _tmp90_ = NULL;
	gboolean _tmp91_ = FALSE;
	PostProcessor* _tmp100_;
	GeeList* _tmp101_ = NULL;
	GError * _inner_error_ = NULL;
	self = (LatexmkPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	_tmp1_ = latexmk_post_processor__reg_rule;
	if (_tmp1_ != NULL) {
		GRegex* _tmp2_;
		_tmp2_ = latexmk_post_processor__reg_no_rule;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	g_return_if_fail (_tmp3_);
	last_latex_output = NULL;
	last_latex_child_num = 0;
	last_rule_is_latex_rule = FALSE;
	_tmp4_ = latexmk_post_processor__reg_rule;
	_tmp5_ = output;
	g_regex_match (_tmp4_, _tmp5_, 0, &_tmp6_);
	_g_match_info_free0 (match_info);
	match_info = _tmp6_;
	while (TRUE) {
		GMatchInfo* _tmp7_;
		gboolean _tmp8_ = FALSE;
		BuildMsg msg = {0};
		GMatchInfo* _tmp9_;
		gchar* _tmp10_ = NULL;
		BuildMsg cmd_line_msg = {0};
		GMatchInfo* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		BuildMsg _tmp15_;
		GeeList* _tmp16_;
		BuildMsg _tmp17_;
		GMatchInfo* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* rule;
		gboolean _tmp20_ = FALSE;
		const gchar* _tmp21_;
		gboolean _tmp23_;
		gboolean is_latex_cmd;
		gboolean _tmp24_;
		gboolean _tmp25_;
		GeeList* _tmp42_;
		BuildMsg _tmp43_;
		BuildMsg latexmk_msg = {0};
		const gchar* _tmp44_ = NULL;
		gchar* _tmp45_;
		GMatchInfo* _tmp46_;
		gchar* _tmp47_ = NULL;
		gchar* latexmk_output;
		AllOutputPostProcessor* _tmp48_;
		PostProcessor* all_output_pp;
		PostProcessor* _tmp49_;
		GFile* _tmp50_;
		const gchar* _tmp51_;
		PostProcessor* _tmp52_;
		GeeList* _tmp53_ = NULL;
		GeeList* _tmp54_;
		BuildMsg _tmp55_;
		_tmp7_ = match_info;
		_tmp8_ = g_match_info_matches (_tmp7_);
		if (!_tmp8_) {
			break;
		}
		build_msg_init (&msg);
		msg.type = BUILD_MSG_TYPE_JOB_SUB_COMMAND;
		msg.expand = FALSE;
		_tmp9_ = match_info;
		_tmp10_ = g_match_info_fetch_named (_tmp9_, "title");
		_g_free0 (msg.text);
		msg.text = _tmp10_;
		build_msg_init (&cmd_line_msg);
		_tmp11_ = match_info;
		_tmp12_ = g_match_info_fetch_named (_tmp11_, "cmd");
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat ("$ ", _tmp13_, NULL);
		_g_free0 (cmd_line_msg.text);
		cmd_line_msg.text = _tmp14_;
		_g_free0 (_tmp13_);
		_tmp15_ = msg;
		_tmp16_ = _tmp15_.children;
		_tmp17_ = cmd_line_msg;
		gee_collection_add ((GeeCollection*) _tmp16_, &_tmp17_);
		_tmp18_ = match_info;
		_tmp19_ = g_match_info_fetch_named (_tmp18_, "rule");
		rule = _tmp19_;
		_tmp21_ = rule;
		if (g_strcmp0 (_tmp21_, "latex") == 0) {
			_tmp20_ = TRUE;
		} else {
			const gchar* _tmp22_;
			_tmp22_ = rule;
			_tmp20_ = g_strcmp0 (_tmp22_, "pdflatex") == 0;
		}
		_tmp23_ = _tmp20_;
		is_latex_cmd = _tmp23_;
		_tmp24_ = is_latex_cmd;
		last_rule_is_latex_rule = _tmp24_;
		_tmp25_ = is_latex_cmd;
		if (_tmp25_) {
			GMatchInfo* _tmp26_;
			gchar* _tmp27_ = NULL;
			GeeList* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			_tmp26_ = match_info;
			_tmp27_ = g_match_info_fetch_named (_tmp26_, "output");
			_g_free0 (last_latex_output);
			last_latex_output = _tmp27_;
			_tmp28_ = ((PostProcessor*) self)->_all_messages;
			_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			last_latex_child_num = _tmp30_;
		} else {
			GMatchInfo* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* cmd_output;
			AllOutputPostProcessor* _tmp33_;
			PostProcessor* all_output_pp;
			PostProcessor* _tmp34_;
			GFile* _tmp35_;
			const gchar* _tmp36_;
			BuildMsg _tmp37_;
			GeeList* _tmp38_;
			PostProcessor* _tmp39_;
			GeeList* _tmp40_ = NULL;
			GeeList* _tmp41_;
			_tmp31_ = match_info;
			_tmp32_ = g_match_info_fetch_named (_tmp31_, "output");
			cmd_output = _tmp32_;
			_tmp33_ = all_output_post_processor_new ();
			all_output_pp = (PostProcessor*) _tmp33_;
			_tmp34_ = all_output_pp;
			_tmp35_ = file;
			_tmp36_ = cmd_output;
			post_processor_process (_tmp34_, _tmp35_, _tmp36_);
			_tmp37_ = msg;
			_tmp38_ = _tmp37_.children;
			_tmp39_ = all_output_pp;
			_tmp40_ = post_processor_get_messages (_tmp39_);
			_tmp41_ = _tmp40_;
			gee_collection_add_all ((GeeCollection*) _tmp38_, (GeeCollection*) _tmp41_);
			_g_object_unref0 (_tmp41_);
			_g_object_unref0 (all_output_pp);
			_g_free0 (cmd_output);
		}
		_tmp42_ = ((PostProcessor*) self)->_all_messages;
		_tmp43_ = msg;
		gee_collection_add ((GeeCollection*) _tmp42_, &_tmp43_);
		build_msg_init (&latexmk_msg);
		latexmk_msg.type = BUILD_MSG_TYPE_JOB_SUB_COMMAND;
		_tmp44_ = _ ("Latexmk messages");
		_tmp45_ = g_strdup (_tmp44_);
		_g_free0 (latexmk_msg.text);
		latexmk_msg.text = _tmp45_;
		latexmk_msg.expand = FALSE;
		_tmp46_ = match_info;
		_tmp47_ = g_match_info_fetch_named (_tmp46_, "latexmk");
		latexmk_output = _tmp47_;
		_tmp48_ = all_output_post_processor_new ();
		all_output_pp = (PostProcessor*) _tmp48_;
		_tmp49_ = all_output_pp;
		_tmp50_ = file;
		_tmp51_ = latexmk_output;
		post_processor_process (_tmp49_, _tmp50_, _tmp51_);
		_tmp52_ = all_output_pp;
		_tmp53_ = post_processor_get_messages (_tmp52_);
		_g_object_unref0 (latexmk_msg.children);
		latexmk_msg.children = _tmp53_;
		_tmp54_ = ((PostProcessor*) self)->_all_messages;
		_tmp55_ = latexmk_msg;
		gee_collection_add ((GeeCollection*) _tmp54_, &_tmp55_);
		{
			GMatchInfo* _tmp56_;
			_tmp56_ = match_info;
			g_match_info_next (_tmp56_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch48_g_regex_error;
				}
				_g_object_unref0 (all_output_pp);
				_g_free0 (latexmk_output);
				build_msg_destroy (&latexmk_msg);
				_g_free0 (rule);
				build_msg_destroy (&cmd_line_msg);
				build_msg_destroy (&msg);
				_g_match_info_free0 (match_info);
				_g_free0 (last_latex_output);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally48;
		__catch48_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp57_;
			const gchar* _tmp58_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp57_ = e;
			_tmp58_ = _tmp57_->message;
			g_warning ("post_processors.vala:276: LatexmkPostProcessor: %s", _tmp58_);
			_g_error_free0 (e);
			_g_object_unref0 (all_output_pp);
			_g_free0 (latexmk_output);
			build_msg_destroy (&latexmk_msg);
			_g_free0 (rule);
			build_msg_destroy (&cmd_line_msg);
			build_msg_destroy (&msg);
			break;
		}
		__finally48:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (all_output_pp);
			_g_free0 (latexmk_output);
			build_msg_destroy (&latexmk_msg);
			_g_free0 (rule);
			build_msg_destroy (&cmd_line_msg);
			build_msg_destroy (&msg);
			_g_match_info_free0 (match_info);
			_g_free0 (last_latex_output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (all_output_pp);
		_g_free0 (latexmk_output);
		build_msg_destroy (&latexmk_msg);
		_g_free0 (rule);
		build_msg_destroy (&cmd_line_msg);
		build_msg_destroy (&msg);
	}
	_tmp59_ = last_latex_output;
	if (_tmp59_ != NULL) {
		LatexPostProcessor* _tmp60_;
		PostProcessor* latex_pp;
		PostProcessor* _tmp61_;
		GFile* _tmp62_;
		const gchar* _tmp63_;
		gboolean _tmp64_ = FALSE;
		gint _tmp65_;
		gboolean _tmp67_;
		GeeList* _tmp70_;
		gint _tmp71_;
		gpointer _tmp72_ = NULL;
		BuildMsg* _tmp73_;
		BuildMsg _tmp74_ = {0};
		BuildMsg _tmp75_;
		BuildMsg msg;
		BuildMsg _tmp76_;
		GeeList* _tmp77_;
		PostProcessor* _tmp78_;
		GeeList* _tmp79_ = NULL;
		GeeList* _tmp80_;
		GeeList* _tmp81_;
		gint _tmp82_;
		BuildMsg _tmp83_;
		_tmp60_ = latex_post_processor_new ();
		latex_pp = (PostProcessor*) _tmp60_;
		_tmp61_ = latex_pp;
		_tmp62_ = file;
		_tmp63_ = last_latex_output;
		post_processor_process (_tmp61_, _tmp62_, _tmp63_);
		_tmp65_ = self->priv->_exit_status;
		if (_tmp65_ == 0) {
			_tmp64_ = TRUE;
		} else {
			gboolean _tmp66_;
			_tmp66_ = last_rule_is_latex_rule;
			_tmp64_ = _tmp66_;
		}
		_tmp67_ = _tmp64_;
		if (_tmp67_) {
			PostProcessor* _tmp68_;
			GeeList* _tmp69_ = NULL;
			((PostProcessor*) self)->_has_details = TRUE;
			_tmp68_ = latex_pp;
			_tmp69_ = post_processor_get_messages (_tmp68_);
			_g_object_unref0 (((PostProcessor*) self)->_messages_without_details);
			((PostProcessor*) self)->_messages_without_details = _tmp69_;
		}
		_tmp70_ = ((PostProcessor*) self)->_all_messages;
		_tmp71_ = last_latex_child_num;
		_tmp72_ = gee_list_get (_tmp70_, _tmp71_);
		_tmp73_ = (BuildMsg*) _tmp72_;
		build_msg_copy (_tmp73_, &_tmp74_);
		_tmp75_ = _tmp74_;
		_build_msg_free0 (_tmp73_);
		msg = _tmp75_;
		_tmp76_ = msg;
		_tmp77_ = _tmp76_.children;
		_tmp78_ = latex_pp;
		_tmp79_ = post_processor_get_messages (_tmp78_);
		_tmp80_ = _tmp79_;
		gee_collection_add_all ((GeeCollection*) _tmp77_, (GeeCollection*) _tmp80_);
		_g_object_unref0 (_tmp80_);
		msg.expand = TRUE;
		_tmp81_ = ((PostProcessor*) self)->_all_messages;
		_tmp82_ = last_latex_child_num;
		_tmp83_ = msg;
		gee_list_set (_tmp81_, _tmp82_, &_tmp83_);
		build_msg_destroy (&msg);
		_g_object_unref0 (latex_pp);
	}
	_tmp84_ = ((PostProcessor*) self)->_all_messages;
	_tmp85_ = gee_collection_get_size ((GeeCollection*) _tmp84_);
	_tmp86_ = _tmp85_;
	if (_tmp86_ > 0) {
		_g_match_info_free0 (match_info);
		_g_free0 (last_latex_output);
		return;
	}
	_tmp87_ = all_output_post_processor_new ();
	all_output_pp = (PostProcessor*) _tmp87_;
	_tmp88_ = latexmk_post_processor__reg_no_rule;
	_tmp89_ = output;
	_tmp91_ = g_regex_match (_tmp88_, _tmp89_, 0, &_tmp90_);
	_g_match_info_free0 (match_info);
	match_info = _tmp90_;
	if (_tmp91_) {
		GMatchInfo* _tmp92_;
		gchar* _tmp93_ = NULL;
		gchar* all_output;
		PostProcessor* _tmp94_;
		GFile* _tmp95_;
		const gchar* _tmp96_;
		_tmp92_ = match_info;
		_tmp93_ = g_match_info_fetch_named (_tmp92_, "output");
		all_output = _tmp93_;
		_tmp94_ = all_output_pp;
		_tmp95_ = file;
		_tmp96_ = all_output;
		post_processor_process (_tmp94_, _tmp95_, _tmp96_);
		_g_free0 (all_output);
	} else {
		PostProcessor* _tmp97_;
		GFile* _tmp98_;
		const gchar* _tmp99_;
		_tmp97_ = all_output_pp;
		_tmp98_ = file;
		_tmp99_ = output;
		post_processor_process (_tmp97_, _tmp98_, _tmp99_);
	}
	_tmp100_ = all_output_pp;
	_tmp101_ = post_processor_get_messages (_tmp100_);
	_g_object_unref0 (((PostProcessor*) self)->_all_messages);
	((PostProcessor*) self)->_all_messages = _tmp101_;
	_g_object_unref0 (all_output_pp);
	_g_match_info_free0 (match_info);
	_g_free0 (last_latex_output);
}


static void latexmk_post_processor_class_init (LatexmkPostProcessorClass * klass) {
	latexmk_post_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LatexmkPostProcessorPrivate));
	POST_PROCESSOR_CLASS (klass)->process = latexmk_post_processor_real_process;
	G_OBJECT_CLASS (klass)->finalize = latexmk_post_processor_finalize;
}


static void latexmk_post_processor_instance_init (LatexmkPostProcessor * self) {
	self->priv = LATEXMK_POST_PROCESSOR_GET_PRIVATE (self);
}


static void latexmk_post_processor_finalize (GObject* obj) {
	LatexmkPostProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessor);
	G_OBJECT_CLASS (latexmk_post_processor_parent_class)->finalize (obj);
}


GType latexmk_post_processor_get_type (void) {
	static volatile gsize latexmk_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&latexmk_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LatexmkPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) latexmk_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LatexmkPostProcessor), 0, (GInstanceInitFunc) latexmk_post_processor_instance_init, NULL };
		GType latexmk_post_processor_type_id;
		latexmk_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "LatexmkPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&latexmk_post_processor_type_id__volatile, latexmk_post_processor_type_id);
	}
	return latexmk_post_processor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



