; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -global-isel -amdgpu-fixed-function-abi -stop-after=irtranslator -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -amdgpu-sroa=0 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefix=GCN %s
; This is a copy of sibling-call.ll, but stops after the IRTranslator.

define fastcc i32 @i32_fastcc_i32_i32(i32 %arg0, i32 %arg1) #1 {
  ; GCN-LABEL: name: i32_fastcc_i32_i32
  ; GCN: bb.1 (%ir-block.0):
  ; GCN:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[COPY]], [[COPY1]]
  ; GCN:   $vgpr0 = COPY [[ADD]](s32)
  ; GCN:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; GCN:   S_SETPC_B64_return [[COPY3]], implicit $vgpr0
  %add0 = add i32 %arg0, %arg1
  ret i32 %add0
}

define fastcc i32 @i32_fastcc_i32_i32_stack_object(i32 %arg0, i32 %arg1) #1 {
  ; GCN-LABEL: name: i32_fastcc_i32_i32_stack_object
  ; GCN: bb.1 (%ir-block.0):
  ; GCN:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 9
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %stack.0.alloca
  ; GCN:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 20
  ; GCN:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[FRAME_INDEX]], [[C1]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD]](p5) :: (volatile store (s32) into %ir.gep, addrspace 5)
  ; GCN:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[COPY]], [[COPY1]]
  ; GCN:   $vgpr0 = COPY [[ADD]](s32)
  ; GCN:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; GCN:   S_SETPC_B64_return [[COPY3]], implicit $vgpr0
  %alloca = alloca [16 x i32], align 4, addrspace(5)
  %gep = getelementptr inbounds [16 x i32], [16 x i32] addrspace(5)* %alloca, i32 0, i32 5
  store volatile i32 9, i32 addrspace(5)* %gep
  %add0 = add i32 %arg0, %arg1
  ret i32 %add0
}

define hidden fastcc i32 @sibling_call_i32_fastcc_i32_i32(i32 %a, i32 %b, i32 %c) #1 {
  ; GCN-LABEL: name: sibling_call_i32_fastcc_i32_i32
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_i32
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   $vgpr1 = COPY [[COPY9]](s32)
  ; GCN:   [[COPY20:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY20]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY14]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY15]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY16]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY17]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY18]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY19]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @i32_fastcc_i32_i32, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %ret = tail call fastcc i32 @i32_fastcc_i32_i32(i32 %a, i32 %b)
  ret i32 %ret
}

define fastcc i32 @sibling_call_i32_fastcc_i32_i32_stack_object(i32 %a, i32 %b, i32 %c) #1 {
  ; GCN-LABEL: name: sibling_call_i32_fastcc_i32_i32_stack_object
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 9
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %stack.0.alloca
  ; GCN:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 20
  ; GCN:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[FRAME_INDEX]], [[C1]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD]](p5) :: (volatile store (s32) into %ir.gep, addrspace 5)
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_i32
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   $vgpr1 = COPY [[COPY9]](s32)
  ; GCN:   [[COPY20:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY20]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY14]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY15]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY16]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY17]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY18]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY19]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @i32_fastcc_i32_i32, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %alloca = alloca [16 x i32], align 4, addrspace(5)
  %gep = getelementptr inbounds [16 x i32], [16 x i32] addrspace(5)* %alloca, i32 0, i32 5
  store volatile i32 9, i32 addrspace(5)* %gep
  %ret = tail call fastcc i32 @i32_fastcc_i32_i32(i32 %a, i32 %b)
  ret i32 %ret
}

define fastcc i32 @sibling_call_i32_fastcc_i32_i32_callee_stack_object(i32 %a, i32 %b, i32 %c) #1 {
  ; GCN-LABEL: name: sibling_call_i32_fastcc_i32_i32_callee_stack_object
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 9
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %stack.0.alloca
  ; GCN:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 20
  ; GCN:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[FRAME_INDEX]], [[C1]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD]](p5) :: (volatile store (s32) into %ir.gep, addrspace 5)
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_i32_stack_object
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   $vgpr1 = COPY [[COPY9]](s32)
  ; GCN:   [[COPY20:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY20]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY14]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY15]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY16]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY17]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY18]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY19]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @i32_fastcc_i32_i32_stack_object, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %alloca = alloca [16 x i32], align 4, addrspace(5)
  %gep = getelementptr inbounds [16 x i32], [16 x i32] addrspace(5)* %alloca, i32 0, i32 5
  store volatile i32 9, i32 addrspace(5)* %gep
  %ret = tail call fastcc i32 @i32_fastcc_i32_i32_stack_object(i32 %a, i32 %b)
  ret i32 %ret
}

define fastcc void @sibling_call_i32_fastcc_i32_i32_unused_result(i32 %a, i32 %b, i32 %c) #1 {
  ; GCN-LABEL: name: sibling_call_i32_fastcc_i32_i32_unused_result
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_i32
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   $vgpr1 = COPY [[COPY9]](s32)
  ; GCN:   [[COPY20:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY20]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY14]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY15]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY16]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY17]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY18]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY19]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @i32_fastcc_i32_i32, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %ret = tail call fastcc i32 @i32_fastcc_i32_i32(i32 %a, i32 %b)
  ret void
}

; It doesn't make sense to do a tail from a kernel
define amdgpu_kernel void @kernel_call_i32_fastcc_i32_i32_unused_result(i32 %a, i32 %b, i32 %c) #1 {
  ; GCN-LABEL: name: kernel_call_i32_fastcc_i32_i32_unused_result
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr14, $sgpr15, $sgpr16, $vgpr0, $vgpr1, $vgpr2, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr2
  ; GCN:   [[COPY1:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr1
  ; GCN:   [[COPY2:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr0
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr16
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_32 = COPY $sgpr15
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY8:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY9:%[0-9]+]]:_(p4) = COPY $sgpr8_sgpr9
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; GCN:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; GCN:   [[INT:%[0-9]+]]:_(p4) = G_INTRINSIC intrinsic(@llvm.amdgcn.kernarg.segment.ptr)
  ; GCN:   [[LOAD:%[0-9]+]]:_(<2 x s32>) = G_LOAD [[INT]](p4) :: (dereferenceable invariant load (<2 x s32>) from %ir.0, align 16, addrspace 4)
  ; GCN:   [[EVEC:%[0-9]+]]:_(s32) = G_EXTRACT_VECTOR_ELT [[LOAD]](<2 x s32>), [[C]](s32)
  ; GCN:   [[EVEC1:%[0-9]+]]:_(s32) = G_EXTRACT_VECTOR_ELT [[LOAD]](<2 x s32>), [[C1]](s32)
  ; GCN:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; GCN:   [[PTR_ADD:%[0-9]+]]:_(p4) = G_PTR_ADD [[INT]], [[C2]](s64)
  ; GCN:   ADJCALLSTACKUP 0, 0, implicit-def $scc
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_i32
  ; GCN:   [[COPY10:%[0-9]+]]:_(p4) = COPY [[COPY8]]
  ; GCN:   [[COPY11:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY9]](p4)
  ; GCN:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 16
  ; GCN:   [[PTR_ADD1:%[0-9]+]]:_(p4) = G_PTR_ADD [[COPY12]], [[C3]](s64)
  ; GCN:   [[COPY13:%[0-9]+]]:_(s64) = COPY [[COPY6]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(s32) = COPY [[COPY5]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY4]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY2]](s32)
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY1]](s32)
  ; GCN:   [[C4:%[0-9]+]]:_(s32) = G_CONSTANT i32 10
  ; GCN:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[COPY18]], [[C4]](s32)
  ; GCN:   [[OR:%[0-9]+]]:_(s32) = G_OR [[COPY17]], [[SHL]]
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   [[C5:%[0-9]+]]:_(s32) = G_CONSTANT i32 20
  ; GCN:   [[SHL1:%[0-9]+]]:_(s32) = G_SHL [[COPY19]], [[C5]](s32)
  ; GCN:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[OR]], [[SHL1]]
  ; GCN:   $vgpr0 = COPY [[EVEC]](s32)
  ; GCN:   $vgpr1 = COPY [[EVEC1]](s32)
  ; GCN:   [[COPY20:%[0-9]+]]:_(<4 x s32>) = COPY $private_rsrc_reg
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY20]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY10]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY11]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[PTR_ADD1]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY13]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY14]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY15]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY16]](s32)
  ; GCN:   $vgpr31 = COPY [[OR1]](s32)
  ; GCN:   $sgpr30_sgpr31 = SI_CALL [[GV]](p0), @i32_fastcc_i32_i32, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31, implicit-def $vgpr0
  ; GCN:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc
  ; GCN:   S_ENDPGM 0
entry:
  %ret = tail call fastcc i32 @i32_fastcc_i32_i32(i32 %a, i32 %b)
  ret void
}

define hidden fastcc i32 @i32_fastcc_i32_byval_i32(i32 %arg0, i32 addrspace(5)* byval(i32) align 4 %arg1) #1 {
  ; GCN-LABEL: name: i32_fastcc_i32_byval_i32
  ; GCN: bb.1 (%ir-block.0):
  ; GCN:   liveins: $vgpr0, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; GCN:   [[COPY1:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX]](p5)
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[COPY1]](p5) :: (dereferenceable load (s32) from %ir.arg1, addrspace 5)
  ; GCN:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[COPY]], [[LOAD]]
  ; GCN:   $vgpr0 = COPY [[ADD]](s32)
  ; GCN:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; GCN:   S_SETPC_B64_return [[COPY3]], implicit $vgpr0
  %arg1.load = load i32, i32 addrspace(5)* %arg1, align 4
  %add0 = add i32 %arg0, %arg1.load
  ret i32 %add0
}

; Tail call disallowed with byval in parent.
define fastcc i32 @sibling_call_i32_fastcc_i32_byval_i32_byval_parent(i32 %a, i32 addrspace(5)* byval(i32) %b.byval, i32 %c) #1 {
  ; GCN-LABEL: name: sibling_call_i32_fastcc_i32_byval_i32_byval_parent
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; GCN:   [[COPY9:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX]](p5)
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY11:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   ADJCALLSTACKUP 0, 0, implicit-def $scc
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_byval_i32
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   [[COPY20:%[0-9]+]]:_(p5) = COPY $sgpr32
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; GCN:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[COPY20]], [[C]](s32)
  ; GCN:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 4
  ; GCN:   G_MEMCPY [[PTR_ADD]](p5), [[COPY9]](p5), [[C1]](s32), 0 :: (dereferenceable store (s32) into stack, addrspace 5), (dereferenceable load (s32) from %ir.b.byval, addrspace 5)
  ; GCN:   [[COPY21:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY21]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY14]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY15]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY16]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY17]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY18]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY19]](s32)
  ; GCN:   $sgpr30_sgpr31 = SI_CALL [[GV]](p0), @i32_fastcc_i32_byval_i32, csr_amdgpu_highregs, implicit $vgpr0, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31, implicit-def $vgpr0
  ; GCN:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   ADJCALLSTACKDOWN 0, 4, implicit-def $scc
  ; GCN:   $vgpr0 = COPY [[COPY22]](s32)
  ; GCN:   [[COPY23:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY11]]
  ; GCN:   S_SETPC_B64_return [[COPY23]], implicit $vgpr0
entry:
  %ret = tail call fastcc i32 @i32_fastcc_i32_byval_i32(i32 %a, i32 addrspace(5)* byval(i32) %b.byval)
  ret i32 %ret
}

; Tail call disallowed with byval in parent, not callee. The stack
; usage of incoming arguments must be <= the outgoing stack
; arguments.
define fastcc i32 @sibling_call_i32_fastcc_i32_byval_i32(i32 %a, [32 x i32] %large) #1 {
  ; GCN-LABEL: name: sibling_call_i32_fastcc_i32_byval_i32
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GCN:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GCN:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GCN:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; GCN:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; GCN:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; GCN:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; GCN:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; GCN:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; GCN:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; GCN:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; GCN:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; GCN:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; GCN:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; GCN:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; GCN:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; GCN:   [[COPY32:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; GCN:   [[COPY33:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; GCN:   [[COPY34:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; GCN:   [[COPY35:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; GCN:   [[COPY36:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; GCN:   [[COPY37:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; GCN:   [[COPY38:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; GCN:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load (s32) from %fixed-stack.2, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; GCN:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load (s32) from %fixed-stack.1, addrspace 5)
  ; GCN:   [[COPY39:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; GCN:   [[INTTOPTR:%[0-9]+]]:_(p5) = G_INTTOPTR [[C]](s32)
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_byval_i32
  ; GCN:   [[COPY40:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY41:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY42:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY43:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY44:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY45:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY46:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY47:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; GCN:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 4
  ; GCN:   G_MEMCPY [[FRAME_INDEX2]](p5), [[INTTOPTR]](p5), [[C1]](s32), 0 :: (dereferenceable store (s32) into %fixed-stack.0, align 16, addrspace 5), (dereferenceable load (s32) from `i32 addrspace(5)* inttoptr (i32 16 to i32 addrspace(5)*)`, align 16, addrspace 5)
  ; GCN:   [[COPY48:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY48]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY40]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY41]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY42]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY43]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY44]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY45]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY46]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY47]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @i32_fastcc_i32_byval_i32, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %ret = tail call fastcc i32 @i32_fastcc_i32_byval_i32(i32 %a, i32 addrspace(5)* byval(i32) inttoptr (i32 16 to i32 addrspace(5)*))
  ret i32 %ret
}

define fastcc i32 @i32_fastcc_i32_i32_a32i32(i32 %arg0, i32 %arg1, [32 x i32] %large) #1 {
  ; GCN-LABEL: name: i32_fastcc_i32_i32_a32i32
  ; GCN: bb.1 (%ir-block.0):
  ; GCN:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GCN:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GCN:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GCN:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GCN:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; GCN:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; GCN:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; GCN:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; GCN:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; GCN:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; GCN:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; GCN:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; GCN:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; GCN:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; GCN:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; GCN:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; GCN:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; GCN:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; GCN:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; GCN:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; GCN:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load (s32) from %fixed-stack.2, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; GCN:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load (s32) from %fixed-stack.1, addrspace 5)
  ; GCN:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; GCN:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load (s32) from %fixed-stack.0, align 8, addrspace 5)
  ; GCN:   [[COPY31:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[COPY]], [[COPY1]]
  ; GCN:   [[ADD1:%[0-9]+]]:_(s32) = G_ADD [[ADD]], [[LOAD1]]
  ; GCN:   [[ADD2:%[0-9]+]]:_(s32) = G_ADD [[ADD1]], [[LOAD2]]
  ; GCN:   $vgpr0 = COPY [[ADD2]](s32)
  ; GCN:   [[COPY32:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY31]]
  ; GCN:   S_SETPC_B64_return [[COPY32]], implicit $vgpr0
  %val_firststack = extractvalue [32 x i32] %large, 30
  %val_laststack = extractvalue [32 x i32] %large, 31
  %add0 = add i32 %arg0, %arg1
  %add1 = add i32 %add0, %val_firststack
  %add2 = add i32 %add1, %val_laststack
  ret i32 %add2
}

define fastcc i32 @sibling_call_i32_fastcc_i32_i32_a32i32(i32 %a, i32 %b, [32 x i32] %c) #1 {
  ; GCN-LABEL: name: sibling_call_i32_fastcc_i32_i32_a32i32
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GCN:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GCN:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GCN:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; GCN:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; GCN:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; GCN:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; GCN:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; GCN:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; GCN:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; GCN:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; GCN:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; GCN:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; GCN:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; GCN:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; GCN:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; GCN:   [[COPY32:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; GCN:   [[COPY33:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; GCN:   [[COPY34:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; GCN:   [[COPY35:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; GCN:   [[COPY36:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; GCN:   [[COPY37:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; GCN:   [[COPY38:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.5
  ; GCN:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load (s32) from %fixed-stack.5, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.4
  ; GCN:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load (s32) from %fixed-stack.4, addrspace 5)
  ; GCN:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; GCN:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load (s32) from %fixed-stack.3, align 8, addrspace 5)
  ; GCN:   [[COPY39:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_i32_a32i32
  ; GCN:   [[COPY40:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY41:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY42:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY43:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY44:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY45:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY46:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY47:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   $vgpr1 = COPY [[COPY9]](s32)
  ; GCN:   $vgpr2 = COPY [[COPY10]](s32)
  ; GCN:   $vgpr3 = COPY [[COPY11]](s32)
  ; GCN:   $vgpr4 = COPY [[COPY12]](s32)
  ; GCN:   $vgpr5 = COPY [[COPY13]](s32)
  ; GCN:   $vgpr6 = COPY [[COPY14]](s32)
  ; GCN:   $vgpr7 = COPY [[COPY15]](s32)
  ; GCN:   $vgpr8 = COPY [[COPY16]](s32)
  ; GCN:   $vgpr9 = COPY [[COPY17]](s32)
  ; GCN:   $vgpr10 = COPY [[COPY18]](s32)
  ; GCN:   $vgpr11 = COPY [[COPY19]](s32)
  ; GCN:   $vgpr12 = COPY [[COPY20]](s32)
  ; GCN:   $vgpr13 = COPY [[COPY21]](s32)
  ; GCN:   $vgpr14 = COPY [[COPY22]](s32)
  ; GCN:   $vgpr15 = COPY [[COPY23]](s32)
  ; GCN:   $vgpr16 = COPY [[COPY24]](s32)
  ; GCN:   $vgpr17 = COPY [[COPY25]](s32)
  ; GCN:   $vgpr18 = COPY [[COPY26]](s32)
  ; GCN:   $vgpr19 = COPY [[COPY27]](s32)
  ; GCN:   $vgpr20 = COPY [[COPY28]](s32)
  ; GCN:   $vgpr21 = COPY [[COPY29]](s32)
  ; GCN:   $vgpr22 = COPY [[COPY30]](s32)
  ; GCN:   $vgpr23 = COPY [[COPY31]](s32)
  ; GCN:   $vgpr24 = COPY [[COPY32]](s32)
  ; GCN:   $vgpr25 = COPY [[COPY33]](s32)
  ; GCN:   $vgpr26 = COPY [[COPY34]](s32)
  ; GCN:   $vgpr27 = COPY [[COPY35]](s32)
  ; GCN:   $vgpr28 = COPY [[COPY36]](s32)
  ; GCN:   $vgpr29 = COPY [[COPY37]](s32)
  ; GCN:   $vgpr30 = COPY [[COPY38]](s32)
  ; GCN:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; GCN:   G_STORE [[LOAD]](s32), [[FRAME_INDEX3]](p5) :: (store (s32) into %fixed-stack.2, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX4:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; GCN:   G_STORE [[LOAD1]](s32), [[FRAME_INDEX4]](p5) :: (store (s32) into %fixed-stack.1, addrspace 5)
  ; GCN:   [[FRAME_INDEX5:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; GCN:   G_STORE [[LOAD2]](s32), [[FRAME_INDEX5]](p5) :: (store (s32) into %fixed-stack.0, align 8, addrspace 5)
  ; GCN:   [[COPY48:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY48]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY40]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY41]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY42]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY43]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY44]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY45]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY46]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY47]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @i32_fastcc_i32_i32_a32i32, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15, implicit $vgpr16, implicit $vgpr17, implicit $vgpr18, implicit $vgpr19, implicit $vgpr20, implicit $vgpr21, implicit $vgpr22, implicit $vgpr23, implicit $vgpr24, implicit $vgpr25, implicit $vgpr26, implicit $vgpr27, implicit $vgpr28, implicit $vgpr29, implicit $vgpr30, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %ret = tail call fastcc i32 @i32_fastcc_i32_i32_a32i32(i32 %a, i32 %b, [32 x i32] %c)
  ret i32 %ret
}

define fastcc i32 @sibling_call_i32_fastcc_i32_i32_a32i32_stack_object(i32 %a, i32 %b, [32 x i32] %c) #1 {
  ; GCN-LABEL: name: sibling_call_i32_fastcc_i32_i32_a32i32_stack_object
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GCN:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GCN:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GCN:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; GCN:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; GCN:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; GCN:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; GCN:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; GCN:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; GCN:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; GCN:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; GCN:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; GCN:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; GCN:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; GCN:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; GCN:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; GCN:   [[COPY32:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; GCN:   [[COPY33:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; GCN:   [[COPY34:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; GCN:   [[COPY35:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; GCN:   [[COPY36:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; GCN:   [[COPY37:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; GCN:   [[COPY38:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.5
  ; GCN:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load (s32) from %fixed-stack.5, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.4
  ; GCN:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load (s32) from %fixed-stack.4, addrspace 5)
  ; GCN:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; GCN:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load (s32) from %fixed-stack.3, align 8, addrspace 5)
  ; GCN:   [[COPY39:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 9
  ; GCN:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %stack.0.alloca
  ; GCN:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 20
  ; GCN:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[FRAME_INDEX3]], [[C1]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD]](p5) :: (volatile store (s32) into %ir.gep, addrspace 5)
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_i32_a32i32
  ; GCN:   [[COPY40:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY41:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY42:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY43:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY44:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY45:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY46:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY47:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   $vgpr1 = COPY [[COPY9]](s32)
  ; GCN:   $vgpr2 = COPY [[COPY10]](s32)
  ; GCN:   $vgpr3 = COPY [[COPY11]](s32)
  ; GCN:   $vgpr4 = COPY [[COPY12]](s32)
  ; GCN:   $vgpr5 = COPY [[COPY13]](s32)
  ; GCN:   $vgpr6 = COPY [[COPY14]](s32)
  ; GCN:   $vgpr7 = COPY [[COPY15]](s32)
  ; GCN:   $vgpr8 = COPY [[COPY16]](s32)
  ; GCN:   $vgpr9 = COPY [[COPY17]](s32)
  ; GCN:   $vgpr10 = COPY [[COPY18]](s32)
  ; GCN:   $vgpr11 = COPY [[COPY19]](s32)
  ; GCN:   $vgpr12 = COPY [[COPY20]](s32)
  ; GCN:   $vgpr13 = COPY [[COPY21]](s32)
  ; GCN:   $vgpr14 = COPY [[COPY22]](s32)
  ; GCN:   $vgpr15 = COPY [[COPY23]](s32)
  ; GCN:   $vgpr16 = COPY [[COPY24]](s32)
  ; GCN:   $vgpr17 = COPY [[COPY25]](s32)
  ; GCN:   $vgpr18 = COPY [[COPY26]](s32)
  ; GCN:   $vgpr19 = COPY [[COPY27]](s32)
  ; GCN:   $vgpr20 = COPY [[COPY28]](s32)
  ; GCN:   $vgpr21 = COPY [[COPY29]](s32)
  ; GCN:   $vgpr22 = COPY [[COPY30]](s32)
  ; GCN:   $vgpr23 = COPY [[COPY31]](s32)
  ; GCN:   $vgpr24 = COPY [[COPY32]](s32)
  ; GCN:   $vgpr25 = COPY [[COPY33]](s32)
  ; GCN:   $vgpr26 = COPY [[COPY34]](s32)
  ; GCN:   $vgpr27 = COPY [[COPY35]](s32)
  ; GCN:   $vgpr28 = COPY [[COPY36]](s32)
  ; GCN:   $vgpr29 = COPY [[COPY37]](s32)
  ; GCN:   $vgpr30 = COPY [[COPY38]](s32)
  ; GCN:   [[FRAME_INDEX4:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; GCN:   G_STORE [[LOAD]](s32), [[FRAME_INDEX4]](p5) :: (store (s32) into %fixed-stack.2, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX5:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; GCN:   G_STORE [[LOAD1]](s32), [[FRAME_INDEX5]](p5) :: (store (s32) into %fixed-stack.1, addrspace 5)
  ; GCN:   [[FRAME_INDEX6:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; GCN:   G_STORE [[LOAD2]](s32), [[FRAME_INDEX6]](p5) :: (store (s32) into %fixed-stack.0, align 8, addrspace 5)
  ; GCN:   [[COPY48:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY48]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY40]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY41]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY42]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY43]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY44]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY45]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY46]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY47]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @i32_fastcc_i32_i32_a32i32, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15, implicit $vgpr16, implicit $vgpr17, implicit $vgpr18, implicit $vgpr19, implicit $vgpr20, implicit $vgpr21, implicit $vgpr22, implicit $vgpr23, implicit $vgpr24, implicit $vgpr25, implicit $vgpr26, implicit $vgpr27, implicit $vgpr28, implicit $vgpr29, implicit $vgpr30, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %alloca = alloca [16 x i32], align 4, addrspace(5)
  %gep = getelementptr inbounds [16 x i32], [16 x i32] addrspace(5)* %alloca, i32 0, i32 5
  store volatile i32 9, i32 addrspace(5)* %gep
  %ret = tail call fastcc i32 @i32_fastcc_i32_i32_a32i32(i32 %a, i32 %b, [32 x i32] %c)
  ret i32 %ret
}

; If the callee requires more stack argument space than the caller,
; don't do a tail call.
; TODO: Do we really need this restriction?
define fastcc i32 @no_sibling_call_callee_more_stack_space(i32 %a, i32 %b) #1 {
  ; GCN-LABEL: name: no_sibling_call_callee_more_stack_space
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; GCN:   ADJCALLSTACKUP 0, 0, implicit-def $scc
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_i32_a32i32
  ; GCN:   [[COPY11:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   $vgpr1 = COPY [[COPY9]](s32)
  ; GCN:   $vgpr2 = COPY [[C]](s32)
  ; GCN:   $vgpr3 = COPY [[C]](s32)
  ; GCN:   $vgpr4 = COPY [[C]](s32)
  ; GCN:   $vgpr5 = COPY [[C]](s32)
  ; GCN:   $vgpr6 = COPY [[C]](s32)
  ; GCN:   $vgpr7 = COPY [[C]](s32)
  ; GCN:   $vgpr8 = COPY [[C]](s32)
  ; GCN:   $vgpr9 = COPY [[C]](s32)
  ; GCN:   $vgpr10 = COPY [[C]](s32)
  ; GCN:   $vgpr11 = COPY [[C]](s32)
  ; GCN:   $vgpr12 = COPY [[C]](s32)
  ; GCN:   $vgpr13 = COPY [[C]](s32)
  ; GCN:   $vgpr14 = COPY [[C]](s32)
  ; GCN:   $vgpr15 = COPY [[C]](s32)
  ; GCN:   $vgpr16 = COPY [[C]](s32)
  ; GCN:   $vgpr17 = COPY [[C]](s32)
  ; GCN:   $vgpr18 = COPY [[C]](s32)
  ; GCN:   $vgpr19 = COPY [[C]](s32)
  ; GCN:   $vgpr20 = COPY [[C]](s32)
  ; GCN:   $vgpr21 = COPY [[C]](s32)
  ; GCN:   $vgpr22 = COPY [[C]](s32)
  ; GCN:   $vgpr23 = COPY [[C]](s32)
  ; GCN:   $vgpr24 = COPY [[C]](s32)
  ; GCN:   $vgpr25 = COPY [[C]](s32)
  ; GCN:   $vgpr26 = COPY [[C]](s32)
  ; GCN:   $vgpr27 = COPY [[C]](s32)
  ; GCN:   $vgpr28 = COPY [[C]](s32)
  ; GCN:   $vgpr29 = COPY [[C]](s32)
  ; GCN:   $vgpr30 = COPY [[C]](s32)
  ; GCN:   [[COPY19:%[0-9]+]]:_(p5) = COPY $sgpr32
  ; GCN:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; GCN:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[COPY19]], [[C1]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD]](p5) :: (store (s32) into stack, align 16, addrspace 5)
  ; GCN:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 4
  ; GCN:   [[PTR_ADD1:%[0-9]+]]:_(p5) = G_PTR_ADD [[COPY19]], [[C2]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD1]](p5) :: (store (s32) into stack + 4, addrspace 5)
  ; GCN:   [[C3:%[0-9]+]]:_(s32) = G_CONSTANT i32 8
  ; GCN:   [[PTR_ADD2:%[0-9]+]]:_(p5) = G_PTR_ADD [[COPY19]], [[C3]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD2]](p5) :: (store (s32) into stack + 8, align 8, addrspace 5)
  ; GCN:   [[COPY20:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY20]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY11]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY14]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY15]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY16]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY17]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY18]](s32)
  ; GCN:   $sgpr30_sgpr31 = SI_CALL [[GV]](p0), @i32_fastcc_i32_i32_a32i32, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15, implicit $vgpr16, implicit $vgpr17, implicit $vgpr18, implicit $vgpr19, implicit $vgpr20, implicit $vgpr21, implicit $vgpr22, implicit $vgpr23, implicit $vgpr24, implicit $vgpr25, implicit $vgpr26, implicit $vgpr27, implicit $vgpr28, implicit $vgpr29, implicit $vgpr30, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31, implicit-def $vgpr0
  ; GCN:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   ADJCALLSTACKDOWN 0, 12, implicit-def $scc
  ; GCN:   $vgpr0 = COPY [[COPY21]](s32)
  ; GCN:   [[COPY22:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY10]]
  ; GCN:   S_SETPC_B64_return [[COPY22]], implicit $vgpr0
entry:
  %ret = tail call fastcc i32 @i32_fastcc_i32_i32_a32i32(i32 %a, i32 %b, [32 x i32] zeroinitializer)
  ret i32 %ret
}

; Have another non-tail in the function
define fastcc i32 @sibling_call_i32_fastcc_i32_i32_other_call(i32 %a, i32 %b, i32 %c) #1 {
  ; GCN-LABEL: name: sibling_call_i32_fastcc_i32_i32_other_call
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   ADJCALLSTACKUP 0, 0, implicit-def $scc
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_i32
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   $vgpr1 = COPY [[COPY9]](s32)
  ; GCN:   [[COPY20:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY20]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY14]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY15]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY16]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY17]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY18]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY19]](s32)
  ; GCN:   $sgpr30_sgpr31 = SI_CALL [[GV]](p0), @i32_fastcc_i32_i32, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31, implicit-def $vgpr0
  ; GCN:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc
  ; GCN:   [[GV1:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @sibling_call_i32_fastcc_i32_i32
  ; GCN:   [[COPY22:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY23:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY24:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY25:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY26:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY27:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY28:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY29:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   $vgpr1 = COPY [[COPY9]](s32)
  ; GCN:   $vgpr2 = COPY [[COPY21]](s32)
  ; GCN:   [[COPY30:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY30]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY22]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY23]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY24]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY25]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY26]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY27]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY28]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY29]](s32)
  ; GCN:   SI_TCRETURN [[GV1]](p0), @sibling_call_i32_fastcc_i32_i32, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %other.call = tail call fastcc i32 @i32_fastcc_i32_i32(i32 %a, i32 %b)
  %ret = tail call fastcc i32 @sibling_call_i32_fastcc_i32_i32(i32 %a, i32 %b, i32 %other.call)
  ret i32 %ret
}

; Have stack object in caller and stack passed arguments. SP should be
; in same place at function exit.
define fastcc i32 @sibling_call_stack_objecti32_fastcc_i32_i32_a32i32(i32 %a, i32 %b, [32 x i32] %c) #1 {
  ; GCN-LABEL: name: sibling_call_stack_objecti32_fastcc_i32_i32_a32i32
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GCN:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GCN:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GCN:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; GCN:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; GCN:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; GCN:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; GCN:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; GCN:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; GCN:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; GCN:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; GCN:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; GCN:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; GCN:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; GCN:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; GCN:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; GCN:   [[COPY32:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; GCN:   [[COPY33:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; GCN:   [[COPY34:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; GCN:   [[COPY35:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; GCN:   [[COPY36:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; GCN:   [[COPY37:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; GCN:   [[COPY38:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.5
  ; GCN:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load (s32) from %fixed-stack.5, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.4
  ; GCN:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load (s32) from %fixed-stack.4, addrspace 5)
  ; GCN:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; GCN:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load (s32) from %fixed-stack.3, align 8, addrspace 5)
  ; GCN:   [[COPY39:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 9
  ; GCN:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %stack.0.alloca
  ; GCN:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 20
  ; GCN:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[FRAME_INDEX3]], [[C1]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD]](p5) :: (volatile store (s32) into %ir.gep, addrspace 5)
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_i32_a32i32
  ; GCN:   [[COPY40:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY41:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY42:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY43:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY44:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY45:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY46:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY47:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   $vgpr1 = COPY [[COPY9]](s32)
  ; GCN:   $vgpr2 = COPY [[COPY10]](s32)
  ; GCN:   $vgpr3 = COPY [[COPY11]](s32)
  ; GCN:   $vgpr4 = COPY [[COPY12]](s32)
  ; GCN:   $vgpr5 = COPY [[COPY13]](s32)
  ; GCN:   $vgpr6 = COPY [[COPY14]](s32)
  ; GCN:   $vgpr7 = COPY [[COPY15]](s32)
  ; GCN:   $vgpr8 = COPY [[COPY16]](s32)
  ; GCN:   $vgpr9 = COPY [[COPY17]](s32)
  ; GCN:   $vgpr10 = COPY [[COPY18]](s32)
  ; GCN:   $vgpr11 = COPY [[COPY19]](s32)
  ; GCN:   $vgpr12 = COPY [[COPY20]](s32)
  ; GCN:   $vgpr13 = COPY [[COPY21]](s32)
  ; GCN:   $vgpr14 = COPY [[COPY22]](s32)
  ; GCN:   $vgpr15 = COPY [[COPY23]](s32)
  ; GCN:   $vgpr16 = COPY [[COPY24]](s32)
  ; GCN:   $vgpr17 = COPY [[COPY25]](s32)
  ; GCN:   $vgpr18 = COPY [[COPY26]](s32)
  ; GCN:   $vgpr19 = COPY [[COPY27]](s32)
  ; GCN:   $vgpr20 = COPY [[COPY28]](s32)
  ; GCN:   $vgpr21 = COPY [[COPY29]](s32)
  ; GCN:   $vgpr22 = COPY [[COPY30]](s32)
  ; GCN:   $vgpr23 = COPY [[COPY31]](s32)
  ; GCN:   $vgpr24 = COPY [[COPY32]](s32)
  ; GCN:   $vgpr25 = COPY [[COPY33]](s32)
  ; GCN:   $vgpr26 = COPY [[COPY34]](s32)
  ; GCN:   $vgpr27 = COPY [[COPY35]](s32)
  ; GCN:   $vgpr28 = COPY [[COPY36]](s32)
  ; GCN:   $vgpr29 = COPY [[COPY37]](s32)
  ; GCN:   $vgpr30 = COPY [[COPY38]](s32)
  ; GCN:   [[FRAME_INDEX4:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; GCN:   G_STORE [[LOAD]](s32), [[FRAME_INDEX4]](p5) :: (store (s32) into %fixed-stack.2, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX5:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; GCN:   G_STORE [[LOAD1]](s32), [[FRAME_INDEX5]](p5) :: (store (s32) into %fixed-stack.1, addrspace 5)
  ; GCN:   [[FRAME_INDEX6:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; GCN:   G_STORE [[LOAD2]](s32), [[FRAME_INDEX6]](p5) :: (store (s32) into %fixed-stack.0, align 8, addrspace 5)
  ; GCN:   [[COPY48:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY48]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY40]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY41]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY42]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY43]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY44]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY45]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY46]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY47]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @i32_fastcc_i32_i32_a32i32, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15, implicit $vgpr16, implicit $vgpr17, implicit $vgpr18, implicit $vgpr19, implicit $vgpr20, implicit $vgpr21, implicit $vgpr22, implicit $vgpr23, implicit $vgpr24, implicit $vgpr25, implicit $vgpr26, implicit $vgpr27, implicit $vgpr28, implicit $vgpr29, implicit $vgpr30, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %alloca = alloca [16 x i32], align 4, addrspace(5)
  %gep = getelementptr inbounds [16 x i32], [16 x i32] addrspace(5)* %alloca, i32 0, i32 5
  store volatile i32 9, i32 addrspace(5)* %gep
  %ret = tail call fastcc i32 @i32_fastcc_i32_i32_a32i32(i32 %a, i32 %b, [32 x i32] %c)
  ret i32 %ret
}

define fastcc i32 @sibling_call_stack_objecti32_fastcc_i32_i32_a32i32_larger_arg_area(i32 %a, i32 %b, [36 x i32] %c) #1 {
  ; GCN-LABEL: name: sibling_call_stack_objecti32_fastcc_i32_i32_a32i32_larger_arg_area
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GCN:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GCN:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GCN:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; GCN:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; GCN:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; GCN:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; GCN:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; GCN:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; GCN:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; GCN:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; GCN:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; GCN:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; GCN:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; GCN:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; GCN:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; GCN:   [[COPY32:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; GCN:   [[COPY33:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; GCN:   [[COPY34:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; GCN:   [[COPY35:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; GCN:   [[COPY36:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; GCN:   [[COPY37:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; GCN:   [[COPY38:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.9
  ; GCN:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load (s32) from %fixed-stack.9, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.8
  ; GCN:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load (s32) from %fixed-stack.8, addrspace 5)
  ; GCN:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.7
  ; GCN:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load (s32) from %fixed-stack.7, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.6
  ; GCN:   [[LOAD3:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX3]](p5) :: (invariant load (s32) from %fixed-stack.6, addrspace 5)
  ; GCN:   [[FRAME_INDEX4:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.5
  ; GCN:   [[LOAD4:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX4]](p5) :: (invariant load (s32) from %fixed-stack.5, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX5:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.4
  ; GCN:   [[LOAD5:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX5]](p5) :: (invariant load (s32) from %fixed-stack.4, addrspace 5)
  ; GCN:   [[FRAME_INDEX6:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; GCN:   [[LOAD6:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX6]](p5) :: (invariant load (s32) from %fixed-stack.3, align 8, addrspace 5)
  ; GCN:   [[COPY39:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 9
  ; GCN:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; GCN:   [[FRAME_INDEX7:%[0-9]+]]:_(p5) = G_FRAME_INDEX %stack.0.alloca
  ; GCN:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 20
  ; GCN:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[FRAME_INDEX7]], [[C2]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD]](p5) :: (volatile store (s32) into %ir.gep, addrspace 5)
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i32_fastcc_i32_i32_a32i32
  ; GCN:   [[COPY40:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY41:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY42:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY43:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY44:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY45:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY46:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY47:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   $vgpr1 = COPY [[COPY9]](s32)
  ; GCN:   $vgpr2 = COPY [[C1]](s32)
  ; GCN:   $vgpr3 = COPY [[C1]](s32)
  ; GCN:   $vgpr4 = COPY [[C1]](s32)
  ; GCN:   $vgpr5 = COPY [[C1]](s32)
  ; GCN:   $vgpr6 = COPY [[C1]](s32)
  ; GCN:   $vgpr7 = COPY [[C1]](s32)
  ; GCN:   $vgpr8 = COPY [[C1]](s32)
  ; GCN:   $vgpr9 = COPY [[C1]](s32)
  ; GCN:   $vgpr10 = COPY [[C1]](s32)
  ; GCN:   $vgpr11 = COPY [[C1]](s32)
  ; GCN:   $vgpr12 = COPY [[C1]](s32)
  ; GCN:   $vgpr13 = COPY [[C1]](s32)
  ; GCN:   $vgpr14 = COPY [[C1]](s32)
  ; GCN:   $vgpr15 = COPY [[C1]](s32)
  ; GCN:   $vgpr16 = COPY [[C1]](s32)
  ; GCN:   $vgpr17 = COPY [[C1]](s32)
  ; GCN:   $vgpr18 = COPY [[C1]](s32)
  ; GCN:   $vgpr19 = COPY [[C1]](s32)
  ; GCN:   $vgpr20 = COPY [[C1]](s32)
  ; GCN:   $vgpr21 = COPY [[C1]](s32)
  ; GCN:   $vgpr22 = COPY [[C1]](s32)
  ; GCN:   $vgpr23 = COPY [[C1]](s32)
  ; GCN:   $vgpr24 = COPY [[C1]](s32)
  ; GCN:   $vgpr25 = COPY [[C1]](s32)
  ; GCN:   $vgpr26 = COPY [[C1]](s32)
  ; GCN:   $vgpr27 = COPY [[C1]](s32)
  ; GCN:   $vgpr28 = COPY [[C1]](s32)
  ; GCN:   $vgpr29 = COPY [[C1]](s32)
  ; GCN:   $vgpr30 = COPY [[C1]](s32)
  ; GCN:   [[FRAME_INDEX8:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; GCN:   G_STORE [[C1]](s32), [[FRAME_INDEX8]](p5) :: (store (s32) into %fixed-stack.2, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX9:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; GCN:   G_STORE [[C1]](s32), [[FRAME_INDEX9]](p5) :: (store (s32) into %fixed-stack.1, addrspace 5)
  ; GCN:   [[FRAME_INDEX10:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; GCN:   G_STORE [[C1]](s32), [[FRAME_INDEX10]](p5) :: (store (s32) into %fixed-stack.0, align 8, addrspace 5)
  ; GCN:   [[COPY48:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY48]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY40]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY41]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY42]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY43]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY44]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY45]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY46]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY47]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @i32_fastcc_i32_i32_a32i32, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15, implicit $vgpr16, implicit $vgpr17, implicit $vgpr18, implicit $vgpr19, implicit $vgpr20, implicit $vgpr21, implicit $vgpr22, implicit $vgpr23, implicit $vgpr24, implicit $vgpr25, implicit $vgpr26, implicit $vgpr27, implicit $vgpr28, implicit $vgpr29, implicit $vgpr30, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %alloca = alloca [16 x i32], align 4, addrspace(5)
  %gep = getelementptr inbounds [16 x i32], [16 x i32] addrspace(5)* %alloca, i32 0, i32 5
  store volatile i32 9, i32 addrspace(5)* %gep
  %ret = tail call fastcc i32 @i32_fastcc_i32_i32_a32i32(i32 %a, i32 %b, [32 x i32] zeroinitializer)
  ret i32 %ret
}

declare hidden void @void_fastcc_multi_byval(i32 %a, [3 x i32] addrspace(5)* byval([3 x i32]) align 16, [2 x i64] addrspace(5)* byval([2 x i64]))

define fastcc void @sibling_call_fastcc_multi_byval(i32 %a, [64 x i32]) #1 {
  ; GCN-LABEL: name: sibling_call_fastcc_multi_byval
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GCN:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GCN:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GCN:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; GCN:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; GCN:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; GCN:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; GCN:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; GCN:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; GCN:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; GCN:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; GCN:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; GCN:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; GCN:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; GCN:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; GCN:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; GCN:   [[COPY32:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; GCN:   [[COPY33:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; GCN:   [[COPY34:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; GCN:   [[COPY35:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; GCN:   [[COPY36:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; GCN:   [[COPY37:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; GCN:   [[COPY38:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.35
  ; GCN:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load (s32) from %fixed-stack.35, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.34
  ; GCN:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load (s32) from %fixed-stack.34, addrspace 5)
  ; GCN:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.33
  ; GCN:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load (s32) from %fixed-stack.33, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.32
  ; GCN:   [[LOAD3:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX3]](p5) :: (invariant load (s32) from %fixed-stack.32, addrspace 5)
  ; GCN:   [[FRAME_INDEX4:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.31
  ; GCN:   [[LOAD4:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX4]](p5) :: (invariant load (s32) from %fixed-stack.31, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX5:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.30
  ; GCN:   [[LOAD5:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX5]](p5) :: (invariant load (s32) from %fixed-stack.30, addrspace 5)
  ; GCN:   [[FRAME_INDEX6:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.29
  ; GCN:   [[LOAD6:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX6]](p5) :: (invariant load (s32) from %fixed-stack.29, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX7:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.28
  ; GCN:   [[LOAD7:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX7]](p5) :: (invariant load (s32) from %fixed-stack.28, addrspace 5)
  ; GCN:   [[FRAME_INDEX8:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.27
  ; GCN:   [[LOAD8:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX8]](p5) :: (invariant load (s32) from %fixed-stack.27, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX9:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.26
  ; GCN:   [[LOAD9:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX9]](p5) :: (invariant load (s32) from %fixed-stack.26, addrspace 5)
  ; GCN:   [[FRAME_INDEX10:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.25
  ; GCN:   [[LOAD10:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX10]](p5) :: (invariant load (s32) from %fixed-stack.25, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX11:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.24
  ; GCN:   [[LOAD11:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX11]](p5) :: (invariant load (s32) from %fixed-stack.24, addrspace 5)
  ; GCN:   [[FRAME_INDEX12:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.23
  ; GCN:   [[LOAD12:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX12]](p5) :: (invariant load (s32) from %fixed-stack.23, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX13:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.22
  ; GCN:   [[LOAD13:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX13]](p5) :: (invariant load (s32) from %fixed-stack.22, addrspace 5)
  ; GCN:   [[FRAME_INDEX14:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.21
  ; GCN:   [[LOAD14:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX14]](p5) :: (invariant load (s32) from %fixed-stack.21, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX15:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.20
  ; GCN:   [[LOAD15:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX15]](p5) :: (invariant load (s32) from %fixed-stack.20, addrspace 5)
  ; GCN:   [[FRAME_INDEX16:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.19
  ; GCN:   [[LOAD16:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX16]](p5) :: (invariant load (s32) from %fixed-stack.19, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX17:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.18
  ; GCN:   [[LOAD17:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX17]](p5) :: (invariant load (s32) from %fixed-stack.18, addrspace 5)
  ; GCN:   [[FRAME_INDEX18:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.17
  ; GCN:   [[LOAD18:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX18]](p5) :: (invariant load (s32) from %fixed-stack.17, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX19:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.16
  ; GCN:   [[LOAD19:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX19]](p5) :: (invariant load (s32) from %fixed-stack.16, addrspace 5)
  ; GCN:   [[FRAME_INDEX20:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.15
  ; GCN:   [[LOAD20:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX20]](p5) :: (invariant load (s32) from %fixed-stack.15, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX21:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.14
  ; GCN:   [[LOAD21:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX21]](p5) :: (invariant load (s32) from %fixed-stack.14, addrspace 5)
  ; GCN:   [[FRAME_INDEX22:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.13
  ; GCN:   [[LOAD22:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX22]](p5) :: (invariant load (s32) from %fixed-stack.13, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX23:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.12
  ; GCN:   [[LOAD23:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX23]](p5) :: (invariant load (s32) from %fixed-stack.12, addrspace 5)
  ; GCN:   [[FRAME_INDEX24:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.11
  ; GCN:   [[LOAD24:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX24]](p5) :: (invariant load (s32) from %fixed-stack.11, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX25:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.10
  ; GCN:   [[LOAD25:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX25]](p5) :: (invariant load (s32) from %fixed-stack.10, addrspace 5)
  ; GCN:   [[FRAME_INDEX26:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.9
  ; GCN:   [[LOAD26:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX26]](p5) :: (invariant load (s32) from %fixed-stack.9, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX27:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.8
  ; GCN:   [[LOAD27:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX27]](p5) :: (invariant load (s32) from %fixed-stack.8, addrspace 5)
  ; GCN:   [[FRAME_INDEX28:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.7
  ; GCN:   [[LOAD28:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX28]](p5) :: (invariant load (s32) from %fixed-stack.7, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX29:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.6
  ; GCN:   [[LOAD29:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX29]](p5) :: (invariant load (s32) from %fixed-stack.6, addrspace 5)
  ; GCN:   [[FRAME_INDEX30:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.5
  ; GCN:   [[LOAD30:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX30]](p5) :: (invariant load (s32) from %fixed-stack.5, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX31:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.4
  ; GCN:   [[LOAD31:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX31]](p5) :: (invariant load (s32) from %fixed-stack.4, addrspace 5)
  ; GCN:   [[FRAME_INDEX32:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; GCN:   [[LOAD32:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX32]](p5) :: (invariant load (s32) from %fixed-stack.3, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX33:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; GCN:   [[LOAD33:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX33]](p5) :: (invariant load (s32) from %fixed-stack.2, addrspace 5)
  ; GCN:   [[COPY39:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 9
  ; GCN:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; GCN:   [[FRAME_INDEX34:%[0-9]+]]:_(p5) = G_FRAME_INDEX %stack.0.alloca0
  ; GCN:   [[FRAME_INDEX35:%[0-9]+]]:_(p5) = G_FRAME_INDEX %stack.1.alloca1
  ; GCN:   G_STORE [[C]](s32), [[FRAME_INDEX34]](p5) :: (store (s32) into %ir.alloca0, addrspace 5)
  ; GCN:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 4
  ; GCN:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[FRAME_INDEX34]], [[C2]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD]](p5) :: (store (s32) into %ir.alloca0 + 4, addrspace 5)
  ; GCN:   [[C3:%[0-9]+]]:_(s32) = G_CONSTANT i32 8
  ; GCN:   [[PTR_ADD1:%[0-9]+]]:_(p5) = G_PTR_ADD [[FRAME_INDEX34]], [[C3]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD1]](p5) :: (store (s32) into %ir.alloca0 + 8, addrspace 5)
  ; GCN:   G_STORE [[C1]](s64), [[FRAME_INDEX35]](p5) :: (store (s64) into %ir.alloca1, addrspace 5)
  ; GCN:   [[PTR_ADD2:%[0-9]+]]:_(p5) = G_PTR_ADD [[FRAME_INDEX35]], [[C3]](s32)
  ; GCN:   G_STORE [[C1]](s64), [[PTR_ADD2]](p5) :: (store (s64) into %ir.alloca1 + 8, addrspace 5)
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @void_fastcc_multi_byval
  ; GCN:   [[COPY40:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY41:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY42:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY43:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY44:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY45:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY46:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY47:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   $vgpr0 = COPY [[COPY8]](s32)
  ; GCN:   [[FRAME_INDEX36:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; GCN:   [[C4:%[0-9]+]]:_(s32) = G_CONSTANT i32 12
  ; GCN:   G_MEMCPY [[FRAME_INDEX36]](p5), [[FRAME_INDEX34]](p5), [[C4]](s32), 0 :: (dereferenceable store (s96) into %fixed-stack.1, align 16, addrspace 5), (dereferenceable load (s96) from %ir.alloca0, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX37:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; GCN:   [[C5:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; GCN:   G_MEMCPY [[FRAME_INDEX37]](p5), [[FRAME_INDEX35]](p5), [[C5]](s32), 0 :: (dereferenceable store (s128) into %fixed-stack.0, addrspace 5), (dereferenceable load (s128) from %ir.alloca1, align 8, addrspace 5)
  ; GCN:   [[COPY48:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY48]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY40]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY41]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY42]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY43]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY44]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY45]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY46]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY47]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @void_fastcc_multi_byval, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %alloca0 = alloca [3 x i32], align 16, addrspace(5)
  %alloca1 = alloca [2 x i64], align 8, addrspace(5)
  store [3 x i32] [i32 9, i32 9, i32 9], [3 x i32] addrspace(5)* %alloca0
  store [2 x i64] zeroinitializer, [2 x i64] addrspace(5)* %alloca1
  tail call fastcc void @void_fastcc_multi_byval(i32 %a, [3 x i32] addrspace(5)* byval([3 x i32]) %alloca0, [2 x i64] addrspace(5)* byval([2 x i64]) %alloca1)
  ret void
}

declare hidden void @void_fastcc_byval_and_stack_passed([3 x i32] addrspace(5)* byval([3 x i32]) align 16, [32 x i32], i32)

; Callee has a byval and non-byval stack passed argument
define fastcc void @sibling_call_byval_and_stack_passed(i32 %stack.out.arg, [64 x i32]) #1 {
  ; GCN-LABEL: name: sibling_call_byval_and_stack_passed
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GCN:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GCN:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GCN:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; GCN:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; GCN:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; GCN:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; GCN:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; GCN:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; GCN:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; GCN:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; GCN:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; GCN:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; GCN:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; GCN:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; GCN:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; GCN:   [[COPY32:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; GCN:   [[COPY33:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; GCN:   [[COPY34:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; GCN:   [[COPY35:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; GCN:   [[COPY36:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; GCN:   [[COPY37:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; GCN:   [[COPY38:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; GCN:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.36
  ; GCN:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load (s32) from %fixed-stack.36, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.35
  ; GCN:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load (s32) from %fixed-stack.35, addrspace 5)
  ; GCN:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.34
  ; GCN:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load (s32) from %fixed-stack.34, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.33
  ; GCN:   [[LOAD3:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX3]](p5) :: (invariant load (s32) from %fixed-stack.33, addrspace 5)
  ; GCN:   [[FRAME_INDEX4:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.32
  ; GCN:   [[LOAD4:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX4]](p5) :: (invariant load (s32) from %fixed-stack.32, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX5:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.31
  ; GCN:   [[LOAD5:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX5]](p5) :: (invariant load (s32) from %fixed-stack.31, addrspace 5)
  ; GCN:   [[FRAME_INDEX6:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.30
  ; GCN:   [[LOAD6:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX6]](p5) :: (invariant load (s32) from %fixed-stack.30, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX7:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.29
  ; GCN:   [[LOAD7:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX7]](p5) :: (invariant load (s32) from %fixed-stack.29, addrspace 5)
  ; GCN:   [[FRAME_INDEX8:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.28
  ; GCN:   [[LOAD8:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX8]](p5) :: (invariant load (s32) from %fixed-stack.28, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX9:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.27
  ; GCN:   [[LOAD9:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX9]](p5) :: (invariant load (s32) from %fixed-stack.27, addrspace 5)
  ; GCN:   [[FRAME_INDEX10:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.26
  ; GCN:   [[LOAD10:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX10]](p5) :: (invariant load (s32) from %fixed-stack.26, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX11:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.25
  ; GCN:   [[LOAD11:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX11]](p5) :: (invariant load (s32) from %fixed-stack.25, addrspace 5)
  ; GCN:   [[FRAME_INDEX12:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.24
  ; GCN:   [[LOAD12:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX12]](p5) :: (invariant load (s32) from %fixed-stack.24, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX13:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.23
  ; GCN:   [[LOAD13:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX13]](p5) :: (invariant load (s32) from %fixed-stack.23, addrspace 5)
  ; GCN:   [[FRAME_INDEX14:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.22
  ; GCN:   [[LOAD14:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX14]](p5) :: (invariant load (s32) from %fixed-stack.22, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX15:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.21
  ; GCN:   [[LOAD15:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX15]](p5) :: (invariant load (s32) from %fixed-stack.21, addrspace 5)
  ; GCN:   [[FRAME_INDEX16:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.20
  ; GCN:   [[LOAD16:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX16]](p5) :: (invariant load (s32) from %fixed-stack.20, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX17:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.19
  ; GCN:   [[LOAD17:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX17]](p5) :: (invariant load (s32) from %fixed-stack.19, addrspace 5)
  ; GCN:   [[FRAME_INDEX18:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.18
  ; GCN:   [[LOAD18:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX18]](p5) :: (invariant load (s32) from %fixed-stack.18, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX19:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.17
  ; GCN:   [[LOAD19:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX19]](p5) :: (invariant load (s32) from %fixed-stack.17, addrspace 5)
  ; GCN:   [[FRAME_INDEX20:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.16
  ; GCN:   [[LOAD20:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX20]](p5) :: (invariant load (s32) from %fixed-stack.16, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX21:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.15
  ; GCN:   [[LOAD21:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX21]](p5) :: (invariant load (s32) from %fixed-stack.15, addrspace 5)
  ; GCN:   [[FRAME_INDEX22:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.14
  ; GCN:   [[LOAD22:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX22]](p5) :: (invariant load (s32) from %fixed-stack.14, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX23:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.13
  ; GCN:   [[LOAD23:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX23]](p5) :: (invariant load (s32) from %fixed-stack.13, addrspace 5)
  ; GCN:   [[FRAME_INDEX24:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.12
  ; GCN:   [[LOAD24:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX24]](p5) :: (invariant load (s32) from %fixed-stack.12, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX25:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.11
  ; GCN:   [[LOAD25:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX25]](p5) :: (invariant load (s32) from %fixed-stack.11, addrspace 5)
  ; GCN:   [[FRAME_INDEX26:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.10
  ; GCN:   [[LOAD26:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX26]](p5) :: (invariant load (s32) from %fixed-stack.10, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX27:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.9
  ; GCN:   [[LOAD27:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX27]](p5) :: (invariant load (s32) from %fixed-stack.9, addrspace 5)
  ; GCN:   [[FRAME_INDEX28:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.8
  ; GCN:   [[LOAD28:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX28]](p5) :: (invariant load (s32) from %fixed-stack.8, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX29:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.7
  ; GCN:   [[LOAD29:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX29]](p5) :: (invariant load (s32) from %fixed-stack.7, addrspace 5)
  ; GCN:   [[FRAME_INDEX30:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.6
  ; GCN:   [[LOAD30:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX30]](p5) :: (invariant load (s32) from %fixed-stack.6, align 8, addrspace 5)
  ; GCN:   [[FRAME_INDEX31:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.5
  ; GCN:   [[LOAD31:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX31]](p5) :: (invariant load (s32) from %fixed-stack.5, addrspace 5)
  ; GCN:   [[FRAME_INDEX32:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.4
  ; GCN:   [[LOAD32:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX32]](p5) :: (invariant load (s32) from %fixed-stack.4, align 16, addrspace 5)
  ; GCN:   [[FRAME_INDEX33:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; GCN:   [[LOAD33:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX33]](p5) :: (invariant load (s32) from %fixed-stack.3, addrspace 5)
  ; GCN:   [[COPY39:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 9
  ; GCN:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; GCN:   [[FRAME_INDEX34:%[0-9]+]]:_(p5) = G_FRAME_INDEX %stack.0.alloca
  ; GCN:   G_STORE [[C]](s32), [[FRAME_INDEX34]](p5) :: (store (s32) into %ir.alloca, addrspace 5)
  ; GCN:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 4
  ; GCN:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[FRAME_INDEX34]], [[C2]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD]](p5) :: (store (s32) into %ir.alloca + 4, addrspace 5)
  ; GCN:   [[C3:%[0-9]+]]:_(s32) = G_CONSTANT i32 8
  ; GCN:   [[PTR_ADD1:%[0-9]+]]:_(p5) = G_PTR_ADD [[FRAME_INDEX34]], [[C3]](s32)
  ; GCN:   G_STORE [[C]](s32), [[PTR_ADD1]](p5) :: (store (s32) into %ir.alloca + 8, addrspace 5)
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @void_fastcc_byval_and_stack_passed
  ; GCN:   [[COPY40:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY41:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY42:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY43:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY44:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY45:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY46:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY47:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   [[FRAME_INDEX35:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; GCN:   [[C4:%[0-9]+]]:_(s32) = G_CONSTANT i32 12
  ; GCN:   G_MEMCPY [[FRAME_INDEX35]](p5), [[FRAME_INDEX34]](p5), [[C4]](s32), 0 :: (dereferenceable store (s96) into %fixed-stack.2, align 16, addrspace 5), (dereferenceable load (s96) from %ir.alloca, align 16, addrspace 5)
  ; GCN:   $vgpr0 = COPY [[C1]](s32)
  ; GCN:   $vgpr1 = COPY [[C1]](s32)
  ; GCN:   $vgpr2 = COPY [[C1]](s32)
  ; GCN:   $vgpr3 = COPY [[C1]](s32)
  ; GCN:   $vgpr4 = COPY [[C1]](s32)
  ; GCN:   $vgpr5 = COPY [[C1]](s32)
  ; GCN:   $vgpr6 = COPY [[C1]](s32)
  ; GCN:   $vgpr7 = COPY [[C1]](s32)
  ; GCN:   $vgpr8 = COPY [[C1]](s32)
  ; GCN:   $vgpr9 = COPY [[C1]](s32)
  ; GCN:   $vgpr10 = COPY [[C1]](s32)
  ; GCN:   $vgpr11 = COPY [[C1]](s32)
  ; GCN:   $vgpr12 = COPY [[C1]](s32)
  ; GCN:   $vgpr13 = COPY [[C1]](s32)
  ; GCN:   $vgpr14 = COPY [[C1]](s32)
  ; GCN:   $vgpr15 = COPY [[C1]](s32)
  ; GCN:   $vgpr16 = COPY [[C1]](s32)
  ; GCN:   $vgpr17 = COPY [[C1]](s32)
  ; GCN:   $vgpr18 = COPY [[C1]](s32)
  ; GCN:   $vgpr19 = COPY [[C1]](s32)
  ; GCN:   $vgpr20 = COPY [[C1]](s32)
  ; GCN:   $vgpr21 = COPY [[C1]](s32)
  ; GCN:   $vgpr22 = COPY [[C1]](s32)
  ; GCN:   $vgpr23 = COPY [[C1]](s32)
  ; GCN:   $vgpr24 = COPY [[C1]](s32)
  ; GCN:   $vgpr25 = COPY [[C1]](s32)
  ; GCN:   $vgpr26 = COPY [[C1]](s32)
  ; GCN:   $vgpr27 = COPY [[C1]](s32)
  ; GCN:   $vgpr28 = COPY [[C1]](s32)
  ; GCN:   $vgpr29 = COPY [[C1]](s32)
  ; GCN:   $vgpr30 = COPY [[C1]](s32)
  ; GCN:   [[FRAME_INDEX36:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; GCN:   G_STORE [[C1]](s32), [[FRAME_INDEX36]](p5) :: (store (s32) into %fixed-stack.1, addrspace 5)
  ; GCN:   [[FRAME_INDEX37:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; GCN:   G_STORE [[COPY8]](s32), [[FRAME_INDEX37]](p5) :: (store (s32) into %fixed-stack.0, align 16, addrspace 5)
  ; GCN:   [[COPY48:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY48]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY40]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY41]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY42]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY43]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY44]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY45]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY46]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY47]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @void_fastcc_byval_and_stack_passed, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15, implicit $vgpr16, implicit $vgpr17, implicit $vgpr18, implicit $vgpr19, implicit $vgpr20, implicit $vgpr21, implicit $vgpr22, implicit $vgpr23, implicit $vgpr24, implicit $vgpr25, implicit $vgpr26, implicit $vgpr27, implicit $vgpr28, implicit $vgpr29, implicit $vgpr30, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %alloca = alloca [3 x i32], align 16, addrspace(5)
  store [3 x i32] [i32 9, i32 9, i32 9], [3 x i32] addrspace(5)* %alloca
  tail call fastcc void @void_fastcc_byval_and_stack_passed([3 x i32] addrspace(5)* byval([3 x i32]) %alloca, [32 x i32] zeroinitializer, i32 %stack.out.arg)
  ret void
}

declare hidden fastcc i64 @i64_fastcc_i64(i64 %arg0)

define hidden fastcc i64 @sibling_call_i64_fastcc_i64(i64 %a) #1 {
  ; GCN-LABEL: name: sibling_call_i64_fastcc_i64
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY8]](s32), [[COPY9]](s32)
  ; GCN:   [[COPY10:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i64_fastcc_i64
  ; GCN:   [[COPY11:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[MV]](s64)
  ; GCN:   $vgpr0 = COPY [[UV]](s32)
  ; GCN:   $vgpr1 = COPY [[UV1]](s32)
  ; GCN:   [[COPY19:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY19]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY11]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY14]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY15]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY16]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY17]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY18]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @i64_fastcc_i64, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %ret = tail call fastcc i64 @i64_fastcc_i64(i64 %a)
  ret i64 %ret
}

declare hidden fastcc i8 addrspace(1)* @p1i8_fastcc_p1i8(i8 addrspace(1)* %arg0)

define hidden fastcc i8 addrspace(1)* @sibling_call_p1i8_fastcc_p1i8(i8 addrspace(1)* %a) #1 {
  ; GCN-LABEL: name: sibling_call_p1i8_fastcc_p1i8
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[MV:%[0-9]+]]:_(p1) = G_MERGE_VALUES [[COPY8]](s32), [[COPY9]](s32)
  ; GCN:   [[COPY10:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @p1i8_fastcc_p1i8
  ; GCN:   [[COPY11:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[MV]](p1)
  ; GCN:   $vgpr0 = COPY [[UV]](s32)
  ; GCN:   $vgpr1 = COPY [[UV1]](s32)
  ; GCN:   [[COPY19:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY19]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY11]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY14]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY15]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY16]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY17]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY18]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @p1i8_fastcc_p1i8, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %ret = tail call fastcc i8 addrspace(1)* @p1i8_fastcc_p1i8(i8 addrspace(1)* %a)
  ret i8 addrspace(1)* %ret
}

declare hidden fastcc i16 @i16_fastcc_i16(i16 %arg0)

define hidden fastcc i16 @sibling_call_i16_fastcc_i16(i16 %a) #1 {
  ; GCN-LABEL: name: sibling_call_i16_fastcc_i16
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY8]](s32)
  ; GCN:   [[COPY9:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @i16_fastcc_i16
  ; GCN:   [[COPY10:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY11:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[TRUNC]](s16)
  ; GCN:   $vgpr0 = COPY [[ANYEXT]](s32)
  ; GCN:   [[COPY18:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY18]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY10]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY11]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY13]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY14]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY15]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY16]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY17]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @i16_fastcc_i16, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %ret = tail call fastcc i16 @i16_fastcc_i16(i16 %a)
  ret i16 %ret
}

declare hidden fastcc half @f16_fastcc_f16(half %arg0)

define hidden fastcc half @sibling_call_f16_fastcc_f16(half %a) #1 {
  ; GCN-LABEL: name: sibling_call_f16_fastcc_f16
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY8]](s32)
  ; GCN:   [[COPY9:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @f16_fastcc_f16
  ; GCN:   [[COPY10:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY11:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[TRUNC]](s16)
  ; GCN:   $vgpr0 = COPY [[ANYEXT]](s32)
  ; GCN:   [[COPY18:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY18]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY10]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY11]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY13]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY14]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY15]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY16]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY17]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @f16_fastcc_f16, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %ret = tail call fastcc half @f16_fastcc_f16(half %a)
  ret half %ret
}

declare hidden fastcc <3 x i16> @v3i16_fastcc_v3i16(<3 x i16> %arg0)

define hidden fastcc <3 x i16> @sibling_call_v3i16_fastcc_v3i16(<3 x i16> %a) #1 {
  ; GCN-LABEL: name: sibling_call_v3i16_fastcc_v3i16
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; GCN:   [[DEF:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; GCN:   [[CONCAT_VECTORS:%[0-9]+]]:_(<6 x s16>) = G_CONCAT_VECTORS [[COPY8]](<2 x s16>), [[COPY9]](<2 x s16>), [[DEF]](<2 x s16>)
  ; GCN:   [[UV:%[0-9]+]]:_(<3 x s16>), [[UV1:%[0-9]+]]:_(<3 x s16>) = G_UNMERGE_VALUES [[CONCAT_VECTORS]](<6 x s16>)
  ; GCN:   [[COPY10:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @v3i16_fastcc_v3i16
  ; GCN:   [[COPY11:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   [[DEF1:%[0-9]+]]:_(<3 x s16>) = G_IMPLICIT_DEF
  ; GCN:   [[CONCAT_VECTORS1:%[0-9]+]]:_(<6 x s16>) = G_CONCAT_VECTORS [[UV]](<3 x s16>), [[DEF1]](<3 x s16>)
  ; GCN:   [[UV2:%[0-9]+]]:_(<2 x s16>), [[UV3:%[0-9]+]]:_(<2 x s16>), [[UV4:%[0-9]+]]:_(<2 x s16>) = G_UNMERGE_VALUES [[CONCAT_VECTORS1]](<6 x s16>)
  ; GCN:   $vgpr0 = COPY [[UV2]](<2 x s16>)
  ; GCN:   $vgpr1 = COPY [[UV3]](<2 x s16>)
  ; GCN:   [[COPY19:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY19]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY11]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY14]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY15]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY16]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY17]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY18]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @v3i16_fastcc_v3i16, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %ret = tail call fastcc <3 x i16> @v3i16_fastcc_v3i16(<3 x i16> %a)
  ret <3 x i16> %ret
}

declare hidden fastcc <4 x i16> @v4i16_fastcc_v4i16(<4 x i16> %arg0)

define hidden fastcc <4 x i16> @sibling_call_v4i16_fastcc_v4i16(<4 x i16> %a) #1 {
  ; GCN-LABEL: name: sibling_call_v4i16_fastcc_v4i16
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; GCN:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[COPY8]](<2 x s16>), [[COPY9]](<2 x s16>)
  ; GCN:   [[COPY10:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @v4i16_fastcc_v4i16
  ; GCN:   [[COPY11:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY12:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   [[UV:%[0-9]+]]:_(<2 x s16>), [[UV1:%[0-9]+]]:_(<2 x s16>) = G_UNMERGE_VALUES [[CONCAT_VECTORS]](<4 x s16>)
  ; GCN:   $vgpr0 = COPY [[UV]](<2 x s16>)
  ; GCN:   $vgpr1 = COPY [[UV1]](<2 x s16>)
  ; GCN:   [[COPY19:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY19]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY11]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY12]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY14]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY15]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY16]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY17]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY18]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @v4i16_fastcc_v4i16, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %ret = tail call fastcc <4 x i16> @v4i16_fastcc_v4i16(<4 x i16> %a)
  ret <4 x i16> %ret
}

declare hidden fastcc <2 x i64> @v2i64_fastcc_v2i64(<2 x i64> %arg0)

define hidden fastcc <2 x i64> @sibling_call_v2i64_fastcc_v2i64(<2 x i64> %a) #1 {
  ; GCN-LABEL: name: sibling_call_v2i64_fastcc_v2i64
  ; GCN: bb.1.entry:
  ; GCN:   liveins: $sgpr12, $sgpr13, $sgpr14, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr31, $sgpr4_sgpr5, $sgpr6_sgpr7, $sgpr8_sgpr9, $sgpr10_sgpr11, $sgpr30_sgpr31
  ; GCN:   [[COPY:%[0-9]+]]:vgpr_32(s32) = COPY $vgpr31
  ; GCN:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; GCN:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; GCN:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; GCN:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr10_sgpr11
  ; GCN:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr8_sgpr9
  ; GCN:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr6_sgpr7
  ; GCN:   [[COPY7:%[0-9]+]]:sgpr_64 = COPY $sgpr4_sgpr5
  ; GCN:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GCN:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GCN:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GCN:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GCN:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY8]](s32), [[COPY9]](s32)
  ; GCN:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY10]](s32), [[COPY11]](s32)
  ; GCN:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64)
  ; GCN:   [[COPY12:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; GCN:   [[GV:%[0-9]+]]:sreg_64(p0) = G_GLOBAL_VALUE @v2i64_fastcc_v2i64
  ; GCN:   [[COPY13:%[0-9]+]]:_(p4) = COPY [[COPY7]]
  ; GCN:   [[COPY14:%[0-9]+]]:_(p4) = COPY [[COPY6]]
  ; GCN:   [[COPY15:%[0-9]+]]:_(p4) = COPY [[COPY5]]
  ; GCN:   [[COPY16:%[0-9]+]]:_(s64) = COPY [[COPY4]]
  ; GCN:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY3]]
  ; GCN:   [[COPY18:%[0-9]+]]:_(s32) = COPY [[COPY2]]
  ; GCN:   [[COPY19:%[0-9]+]]:_(s32) = COPY [[COPY1]]
  ; GCN:   [[COPY20:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; GCN:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[BUILD_VECTOR]](<2 x s64>)
  ; GCN:   $vgpr0 = COPY [[UV]](s32)
  ; GCN:   $vgpr1 = COPY [[UV1]](s32)
  ; GCN:   $vgpr2 = COPY [[UV2]](s32)
  ; GCN:   $vgpr3 = COPY [[UV3]](s32)
  ; GCN:   [[COPY21:%[0-9]+]]:_(<4 x s32>) = COPY $sgpr0_sgpr1_sgpr2_sgpr3
  ; GCN:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY21]](<4 x s32>)
  ; GCN:   $sgpr4_sgpr5 = COPY [[COPY13]](p4)
  ; GCN:   $sgpr6_sgpr7 = COPY [[COPY14]](p4)
  ; GCN:   $sgpr8_sgpr9 = COPY [[COPY15]](p4)
  ; GCN:   $sgpr10_sgpr11 = COPY [[COPY16]](s64)
  ; GCN:   $sgpr12 = COPY [[COPY17]](s32)
  ; GCN:   $sgpr13 = COPY [[COPY18]](s32)
  ; GCN:   $sgpr14 = COPY [[COPY19]](s32)
  ; GCN:   $vgpr31 = COPY [[COPY20]](s32)
  ; GCN:   SI_TCRETURN [[GV]](p0), @v2i64_fastcc_v2i64, 0, csr_amdgpu_highregs, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $sgpr4_sgpr5, implicit $sgpr6_sgpr7, implicit $sgpr8_sgpr9, implicit $sgpr10_sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $vgpr31
entry:
  %ret = tail call fastcc <2 x i64> @v2i64_fastcc_v2i64(<2 x i64> %a)
  ret <2 x i64> %ret
}

attributes #0 = { nounwind }
attributes #1 = { nounwind noinline }
