; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=gfx600 -amdgpu-bypass-slow-div=0 -verify-machineinstrs < %s | FileCheck -check-prefix=GCN %s
; RUN: llc -march=amdgcn -mcpu=gfx600 -amdgpu-bypass-slow-div=0 -amdgpu-codegenprepare-expand-div64 -verify-machineinstrs < %s | FileCheck -check-prefix=GCN-IR %s

define amdgpu_kernel void @s_test_udiv_i64(i64 addrspace(1)* %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_udiv_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xd
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s3
; GCN-NEXT:    s_sub_u32 s4, 0, s2
; GCN-NEXT:    s_subb_u32 s5, 0, s3
; GCN-NEXT:    v_mac_f32_e32 v0, 0x4f800000, v1
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GCN-NEXT:    v_mul_f32_e32 v3, 0x2f800000, v0
; GCN-NEXT:    v_trunc_f32_e32 v3, v3
; GCN-NEXT:    v_mac_f32_e32 v0, 0xcf800000, v3
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GCN-NEXT:    v_mul_hi_u32 v5, s4, v0
; GCN-NEXT:    v_mul_lo_u32 v4, s4, v3
; GCN-NEXT:    v_mul_lo_u32 v7, s5, v0
; GCN-NEXT:    v_mul_lo_u32 v6, s4, v0
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v7
; GCN-NEXT:    v_mul_hi_u32 v5, v0, v6
; GCN-NEXT:    v_mul_lo_u32 v7, v0, v4
; GCN-NEXT:    v_mul_hi_u32 v9, v0, v4
; GCN-NEXT:    v_mul_lo_u32 v8, v3, v6
; GCN-NEXT:    v_mul_hi_u32 v6, v3, v6
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v5, v7
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v2, v9, vcc
; GCN-NEXT:    v_mul_hi_u32 v9, v3, v4
; GCN-NEXT:    v_mul_lo_u32 v4, v3, v4
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v5, v8
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v7, v6, vcc
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v9, v1, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-NEXT:    v_add_i32_e64 v0, s[0:1], v0, v4
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v2, v6, vcc
; GCN-NEXT:    v_addc_u32_e64 v4, vcc, v3, v5, s[0:1]
; GCN-NEXT:    v_mul_lo_u32 v6, s4, v4
; GCN-NEXT:    v_mul_hi_u32 v7, s4, v0
; GCN-NEXT:    v_mul_lo_u32 v8, s5, v0
; GCN-NEXT:    s_mov_b32 s5, s9
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_mul_lo_u32 v7, s4, v0
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v8, v6
; GCN-NEXT:    v_mul_lo_u32 v10, v0, v6
; GCN-NEXT:    v_mul_hi_u32 v12, v0, v6
; GCN-NEXT:    v_mul_hi_u32 v11, v0, v7
; GCN-NEXT:    v_mul_hi_u32 v9, v4, v7
; GCN-NEXT:    v_mul_lo_u32 v7, v4, v7
; GCN-NEXT:    v_mul_hi_u32 v8, v4, v6
; GCN-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GCN-NEXT:    v_addc_u32_e32 v11, vcc, v2, v12, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, v4, v6
; GCN-NEXT:    v_add_i32_e32 v7, vcc, v10, v7
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v11, v9, vcc
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v8, v1, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v7, v4
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v2, v6, vcc
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; GCN-NEXT:    v_addc_u32_e64 v3, vcc, v3, v6, s[0:1]
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, s10, v3
; GCN-NEXT:    v_mul_hi_u32 v5, s10, v0
; GCN-NEXT:    v_mul_hi_u32 v6, s10, v3
; GCN-NEXT:    v_mul_hi_u32 v7, s11, v3
; GCN-NEXT:    v_mul_lo_u32 v3, s11, v3
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v2, v6, vcc
; GCN-NEXT:    v_mul_lo_u32 v6, s11, v0
; GCN-NEXT:    v_mul_hi_u32 v0, s11, v0
; GCN-NEXT:    s_mov_b32 s4, s8
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v6
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, v5, v0, vcc
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v7, v1, vcc
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v3
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, s2, v1
; GCN-NEXT:    v_mul_hi_u32 v3, s2, v0
; GCN-NEXT:    v_mul_lo_u32 v4, s3, v0
; GCN-NEXT:    v_mov_b32_e32 v5, s3
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_mul_lo_u32 v3, s2, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_sub_i32_e32 v4, vcc, s11, v2
; GCN-NEXT:    v_sub_i32_e32 v3, vcc, s10, v3
; GCN-NEXT:    v_subb_u32_e64 v4, s[0:1], v4, v5, vcc
; GCN-NEXT:    v_subrev_i32_e64 v5, s[0:1], s2, v3
; GCN-NEXT:    v_subbrev_u32_e64 v4, s[0:1], 0, v4, s[0:1]
; GCN-NEXT:    v_cmp_le_u32_e64 s[0:1], s3, v4
; GCN-NEXT:    v_cndmask_b32_e64 v6, 0, -1, s[0:1]
; GCN-NEXT:    v_cmp_le_u32_e64 s[0:1], s2, v5
; GCN-NEXT:    v_cndmask_b32_e64 v5, 0, -1, s[0:1]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[0:1], s3, v4
; GCN-NEXT:    v_cndmask_b32_e64 v4, v6, v5, s[0:1]
; GCN-NEXT:    v_add_i32_e64 v5, s[0:1], 2, v0
; GCN-NEXT:    v_addc_u32_e64 v6, s[0:1], 0, v1, s[0:1]
; GCN-NEXT:    v_add_i32_e64 v7, s[0:1], 1, v0
; GCN-NEXT:    v_addc_u32_e64 v8, s[0:1], 0, v1, s[0:1]
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v4, v8, v6, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v6, s11
; GCN-NEXT:    v_subb_u32_e32 v2, vcc, v6, v2, vcc
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s3, v2
; GCN-NEXT:    v_cndmask_b32_e64 v6, 0, -1, vcc
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s2, v3
; GCN-NEXT:    v_cndmask_b32_e64 v3, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, s3, v2
; GCN-NEXT:    v_cndmask_b32_e32 v2, v6, v3, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v2, v7, v5, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_udiv_i64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-IR-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xd
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[8:9], s[6:7], 0
; GCN-IR-NEXT:    s_flbit_i32_b32 s10, s2
; GCN-IR-NEXT:    s_add_i32 s10, s10, 32
; GCN-IR-NEXT:    s_flbit_i32_b32 s11, s3
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s10
; GCN-IR-NEXT:    s_flbit_i32_b32 s10, s6
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s11
; GCN-IR-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 0
; GCN-IR-NEXT:    s_add_i32 s10, s10, 32
; GCN-IR-NEXT:    s_flbit_i32_b32 s11, s7
; GCN-IR-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s11
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s10
; GCN-IR-NEXT:    v_cmp_eq_u32_e64 vcc, s7, 0
; GCN-IR-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v2, v3
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[2:3], 0
; GCN-IR-NEXT:    v_subb_u32_e64 v1, s[10:11], 0, 0, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, 63, v[0:1]
; GCN-IR-NEXT:    s_or_b64 s[0:1], s[0:1], s[8:9]
; GCN-IR-NEXT:    s_or_b64 s[0:1], s[0:1], vcc
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 63, v[0:1]
; GCN-IR-NEXT:    s_xor_b64 s[8:9], s[0:1], -1
; GCN-IR-NEXT:    s_and_b64 s[8:9], s[8:9], vcc
; GCN-IR-NEXT:    s_and_b64 vcc, exec, s[8:9]
; GCN-IR-NEXT:    s_cbranch_vccz BB0_4
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v4, vcc, 1, v0
; GCN-IR-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e64 s[0:1], v[4:5], v[0:1]
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, 63, v0
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], s[6:7], v0
; GCN-IR-NEXT:    s_andn2_b64 vcc, exec, s[0:1]
; GCN-IR-NEXT:    s_cbranch_vccz BB0_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    v_not_b32_e32 v2, v2
; GCN-IR-NEXT:    v_lshr_b64 v[6:7], s[6:7], v4
; GCN-IR-NEXT:    s_add_u32 s6, s2, -1
; GCN-IR-NEXT:    v_add_i32_e32 v4, vcc, v2, v3
; GCN-IR-NEXT:    v_mov_b32_e32 v8, 0
; GCN-IR-NEXT:    s_addc_u32 s7, s3, -1
; GCN-IR-NEXT:    v_addc_u32_e64 v5, s[0:1], -1, 0, vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v9, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v3, 0
; GCN-IR-NEXT:  BB0_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[6:7], v[6:7], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v2, 31, v1
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; GCN-IR-NEXT:    v_or_b32_e32 v6, v6, v2
; GCN-IR-NEXT:    v_or_b32_e32 v0, v8, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v2, s7
; GCN-IR-NEXT:    v_sub_i32_e32 v8, vcc, s6, v6
; GCN-IR-NEXT:    v_subb_u32_e32 v2, vcc, v2, v7, vcc
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v8, 31, v2
; GCN-IR-NEXT:    v_and_b32_e32 v10, s2, v8
; GCN-IR-NEXT:    v_and_b32_e32 v2, 1, v8
; GCN-IR-NEXT:    v_and_b32_e32 v11, s3, v8
; GCN-IR-NEXT:    v_add_i32_e32 v8, vcc, 1, v4
; GCN-IR-NEXT:    v_or_b32_e32 v1, v9, v1
; GCN-IR-NEXT:    v_addc_u32_e32 v9, vcc, 0, v5, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, v[8:9], v[4:5]
; GCN-IR-NEXT:    v_mov_b32_e32 v4, v8
; GCN-IR-NEXT:    v_sub_i32_e64 v6, s[0:1], v6, v10
; GCN-IR-NEXT:    v_mov_b32_e32 v5, v9
; GCN-IR-NEXT:    v_mov_b32_e32 v9, v3
; GCN-IR-NEXT:    v_subb_u32_e64 v7, s[0:1], v7, v11, s[0:1]
; GCN-IR-NEXT:    s_and_b64 vcc, exec, vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v8, v2
; GCN-IR-NEXT:    s_cbranch_vccz BB0_3
; GCN-IR-NEXT:    s_branch BB0_6
; GCN-IR-NEXT:  BB0_4:
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s7
; GCN-IR-NEXT:    v_cndmask_b32_e64 v1, v0, 0, s[0:1]
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s6
; GCN-IR-NEXT:    v_cndmask_b32_e64 v0, v0, 0, s[0:1]
; GCN-IR-NEXT:    s_branch BB0_7
; GCN-IR-NEXT:  BB0_5:
; GCN-IR-NEXT:    v_mov_b32_e32 v2, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v3, 0
; GCN-IR-NEXT:  BB0_6: ; %Flow6
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; GCN-IR-NEXT:    v_or_b32_e32 v0, v2, v0
; GCN-IR-NEXT:    v_or_b32_e32 v1, v3, v1
; GCN-IR-NEXT:  BB0_7: ; %udiv-end
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %result = udiv i64 %x, %y
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define i64 @v_test_udiv_i64(i64 %x, i64 %y) {
; GCN-LABEL: v_test_udiv_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_u32_e32 v4, v2
; GCN-NEXT:    v_cvt_f32_u32_e32 v5, v3
; GCN-NEXT:    v_sub_i32_e32 v6, vcc, 0, v2
; GCN-NEXT:    v_subb_u32_e32 v7, vcc, 0, v3, vcc
; GCN-NEXT:    v_mov_b32_e32 v14, 0
; GCN-NEXT:    v_mac_f32_e32 v4, 0x4f800000, v5
; GCN-NEXT:    v_rcp_f32_e32 v4, v4
; GCN-NEXT:    v_mov_b32_e32 v13, 0
; GCN-NEXT:    v_mul_f32_e32 v4, 0x5f7ffffc, v4
; GCN-NEXT:    v_mul_f32_e32 v5, 0x2f800000, v4
; GCN-NEXT:    v_trunc_f32_e32 v5, v5
; GCN-NEXT:    v_mac_f32_e32 v4, 0xcf800000, v5
; GCN-NEXT:    v_cvt_u32_f32_e32 v4, v4
; GCN-NEXT:    v_cvt_u32_f32_e32 v5, v5
; GCN-NEXT:    v_mul_hi_u32 v8, v6, v4
; GCN-NEXT:    v_mul_lo_u32 v9, v6, v5
; GCN-NEXT:    v_mul_lo_u32 v10, v7, v4
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v8, v9
; GCN-NEXT:    v_mul_lo_u32 v9, v6, v4
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; GCN-NEXT:    v_mul_lo_u32 v11, v4, v8
; GCN-NEXT:    v_mul_hi_u32 v10, v4, v8
; GCN-NEXT:    v_mul_hi_u32 v12, v4, v9
; GCN-NEXT:    v_mul_hi_u32 v15, v5, v8
; GCN-NEXT:    v_mul_lo_u32 v8, v5, v8
; GCN-NEXT:    v_add_i32_e32 v11, vcc, v12, v11
; GCN-NEXT:    v_mul_lo_u32 v12, v5, v9
; GCN-NEXT:    v_mul_hi_u32 v9, v5, v9
; GCN-NEXT:    v_addc_u32_e32 v10, vcc, v14, v10, vcc
; GCN-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; GCN-NEXT:    v_addc_u32_e32 v9, vcc, v10, v9, vcc
; GCN-NEXT:    v_addc_u32_e32 v10, vcc, v15, v13, vcc
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GCN-NEXT:    v_add_i32_e64 v4, s[4:5], v4, v8
; GCN-NEXT:    v_addc_u32_e32 v9, vcc, v14, v10, vcc
; GCN-NEXT:    v_addc_u32_e64 v8, vcc, v5, v9, s[4:5]
; GCN-NEXT:    v_mul_lo_u32 v10, v6, v8
; GCN-NEXT:    v_mul_hi_u32 v11, v6, v4
; GCN-NEXT:    v_mul_lo_u32 v7, v7, v4
; GCN-NEXT:    v_mul_lo_u32 v6, v6, v4
; GCN-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GCN-NEXT:    v_add_i32_e32 v7, vcc, v10, v7
; GCN-NEXT:    v_mul_lo_u32 v12, v4, v7
; GCN-NEXT:    v_mul_hi_u32 v15, v4, v6
; GCN-NEXT:    v_mul_hi_u32 v16, v4, v7
; GCN-NEXT:    v_mul_hi_u32 v11, v8, v6
; GCN-NEXT:    v_mul_lo_u32 v6, v8, v6
; GCN-NEXT:    v_add_i32_e32 v12, vcc, v15, v12
; GCN-NEXT:    v_mul_hi_u32 v10, v8, v7
; GCN-NEXT:    v_addc_u32_e32 v15, vcc, v14, v16, vcc
; GCN-NEXT:    v_mul_lo_u32 v7, v8, v7
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v12, v6
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v15, v11, vcc
; GCN-NEXT:    v_addc_u32_e32 v8, vcc, v10, v13, vcc
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v6, v7
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v14, v8, vcc
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v5, v9
; GCN-NEXT:    v_addc_u32_e64 v5, vcc, v5, v7, s[4:5]
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v6
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; GCN-NEXT:    v_mul_lo_u32 v6, v0, v5
; GCN-NEXT:    v_mul_hi_u32 v7, v0, v4
; GCN-NEXT:    v_mul_hi_u32 v8, v0, v5
; GCN-NEXT:    v_mul_hi_u32 v9, v1, v5
; GCN-NEXT:    v_mul_lo_u32 v5, v1, v5
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v14, v8, vcc
; GCN-NEXT:    v_mul_lo_u32 v8, v1, v4
; GCN-NEXT:    v_mul_hi_u32 v4, v1, v4
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, v7, v4, vcc
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v9, v13, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v14, v6, vcc
; GCN-NEXT:    v_mul_lo_u32 v6, v2, v5
; GCN-NEXT:    v_mul_hi_u32 v7, v2, v4
; GCN-NEXT:    v_mul_lo_u32 v8, v3, v4
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_mul_lo_u32 v7, v2, v4
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; GCN-NEXT:    v_sub_i32_e32 v8, vcc, v1, v6
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, v0, v7
; GCN-NEXT:    v_subb_u32_e64 v7, s[4:5], v8, v3, vcc
; GCN-NEXT:    v_sub_i32_e64 v8, s[4:5], v0, v2
; GCN-NEXT:    v_subbrev_u32_e64 v7, s[4:5], 0, v7, s[4:5]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[4:5], v7, v3
; GCN-NEXT:    v_cndmask_b32_e64 v9, 0, -1, s[4:5]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[4:5], v8, v2
; GCN-NEXT:    v_cndmask_b32_e64 v8, 0, -1, s[4:5]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[4:5], v7, v3
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, v1, v6, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v7, v9, v8, s[4:5]
; GCN-NEXT:    v_add_i32_e64 v8, s[4:5], 2, v4
; GCN-NEXT:    v_addc_u32_e64 v9, s[4:5], 0, v5, s[4:5]
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v3
; GCN-NEXT:    v_add_i32_e64 v10, s[4:5], 1, v4
; GCN-NEXT:    v_cndmask_b32_e64 v6, 0, -1, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e64 v11, s[4:5], 0, v5, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; GCN-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v7
; GCN-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v7, v10, v8, s[4:5]
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e64 v1, v11, v9, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v0, v4, v7, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_udiv_i64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[0:1]
; GCN-IR-NEXT:    v_ffbh_u32_e32 v4, v2
; GCN-IR-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN-IR-NEXT:    v_add_i32_e32 v4, vcc, 32, v4
; GCN-IR-NEXT:    v_ffbh_u32_e32 v5, v3
; GCN-IR-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GCN-IR-NEXT:    v_cndmask_b32_e32 v8, v5, v4, vcc
; GCN-IR-NEXT:    v_ffbh_u32_e32 v4, v0
; GCN-IR-NEXT:    v_add_i32_e32 v4, vcc, 32, v4
; GCN-IR-NEXT:    v_ffbh_u32_e32 v5, v1
; GCN-IR-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GCN-IR-NEXT:    v_cndmask_b32_e32 v10, v5, v4, vcc
; GCN-IR-NEXT:    v_sub_i32_e32 v6, vcc, v8, v10
; GCN-IR-NEXT:    v_subb_u32_e64 v7, s[6:7], 0, 0, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, 63, v[6:7]
; GCN-IR-NEXT:    v_mov_b32_e32 v9, 0
; GCN-IR-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 63, v[6:7]
; GCN-IR-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; GCN-IR-NEXT:    v_mov_b32_e32 v11, v9
; GCN-IR-NEXT:    v_cndmask_b32_e64 v4, v1, 0, s[4:5]
; GCN-IR-NEXT:    v_cndmask_b32_e64 v5, v0, 0, s[4:5]
; GCN-IR-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; GCN-IR-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz BB1_6
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v12, vcc, 1, v6
; GCN-IR-NEXT:    v_addc_u32_e32 v13, vcc, 0, v7, vcc
; GCN-IR-NEXT:    v_sub_i32_e64 v4, s[4:5], 63, v6
; GCN-IR-NEXT:    v_cmp_ge_u64_e32 vcc, v[12:13], v[6:7]
; GCN-IR-NEXT:    v_mov_b32_e32 v6, 0
; GCN-IR-NEXT:    v_lshl_b64 v[4:5], v[0:1], v4
; GCN-IR-NEXT:    v_mov_b32_e32 v7, 0
; GCN-IR-NEXT:    s_mov_b64 s[10:11], 0
; GCN-IR-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GCN-IR-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz BB1_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    v_lshr_b64 v[12:13], v[0:1], v12
; GCN-IR-NEXT:    v_add_i32_e32 v0, vcc, -1, v2
; GCN-IR-NEXT:    v_addc_u32_e32 v1, vcc, -1, v3, vcc
; GCN-IR-NEXT:    v_not_b32_e32 v6, v8
; GCN-IR-NEXT:    v_mov_b32_e32 v14, 0
; GCN-IR-NEXT:    v_not_b32_e32 v7, v9
; GCN-IR-NEXT:    v_add_i32_e32 v8, vcc, v6, v10
; GCN-IR-NEXT:    v_mov_b32_e32 v15, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v9, vcc, v7, v11, vcc
; GCN-IR-NEXT:  BB1_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[10:11], v[12:13], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v6, 31, v5
; GCN-IR-NEXT:    v_or_b32_e32 v10, v10, v6
; GCN-IR-NEXT:    v_lshl_b64 v[4:5], v[4:5], 1
; GCN-IR-NEXT:    v_sub_i32_e32 v6, vcc, v0, v10
; GCN-IR-NEXT:    v_subb_u32_e32 v6, vcc, v1, v11, vcc
; GCN-IR-NEXT:    v_or_b32_e32 v4, v14, v4
; GCN-IR-NEXT:    v_add_i32_e32 v14, vcc, 1, v8
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v12, 31, v6
; GCN-IR-NEXT:    v_or_b32_e32 v5, v15, v5
; GCN-IR-NEXT:    v_addc_u32_e32 v15, vcc, 0, v9, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, v[14:15], v[8:9]
; GCN-IR-NEXT:    v_mov_b32_e32 v8, v14
; GCN-IR-NEXT:    v_mov_b32_e32 v7, 0
; GCN-IR-NEXT:    v_and_b32_e32 v6, 1, v12
; GCN-IR-NEXT:    v_and_b32_e32 v13, v12, v3
; GCN-IR-NEXT:    v_and_b32_e32 v12, v12, v2
; GCN-IR-NEXT:    v_sub_i32_e64 v12, s[4:5], v10, v12
; GCN-IR-NEXT:    v_mov_b32_e32 v9, v15
; GCN-IR-NEXT:    v_mov_b32_e32 v15, v7
; GCN-IR-NEXT:    v_subb_u32_e64 v13, s[4:5], v11, v13, s[4:5]
; GCN-IR-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; GCN-IR-NEXT:    v_mov_b32_e32 v14, v6
; GCN-IR-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:    s_cbranch_execnz BB1_3
; GCN-IR-NEXT:  ; %bb.4: ; %Flow
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:  BB1_5: ; %Flow3
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[8:9]
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[4:5], 1
; GCN-IR-NEXT:    v_or_b32_e32 v4, v7, v1
; GCN-IR-NEXT:    v_or_b32_e32 v5, v6, v0
; GCN-IR-NEXT:  BB1_6: ; %Flow4
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[6:7]
; GCN-IR-NEXT:    v_mov_b32_e32 v0, v5
; GCN-IR-NEXT:    v_mov_b32_e32 v1, v4
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %result = udiv i64 %x, %y
  ret i64 %result
}

define amdgpu_kernel void @s_test_udiv24_64(i64 addrspace(1)* %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_udiv24_64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xe
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_lshr_b32 s0, s0, 8
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s0
; GCN-NEXT:    s_lshr_b32 s0, s7, 8
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s0
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v2
; GCN-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; GCN-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_udiv24_64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-IR-NEXT:    s_load_dword s0, s[0:1], 0xe
; GCN-IR-NEXT:    s_mov_b32 s3, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s2, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_mov_b32 s1, s5
; GCN-IR-NEXT:    s_lshr_b32 s0, s0, 8
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, s0
; GCN-IR-NEXT:    s_lshr_b32 s0, s7, 8
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v1, s0
; GCN-IR-NEXT:    s_mov_b32 s0, s4
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-IR-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-IR-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v3, v2
; GCN-IR-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; GCN-IR-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-IR-NEXT:    s_endpgm
  %1 = lshr i64 %x, 40
  %2 = lshr i64 %y, 40
  %result = udiv i64 %1, %2
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define i64 @v_test_udiv24_i64(i64 %x, i64 %y) {
; GCN-LABEL: v_test_udiv24_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 8, v3
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, v0
; GCN-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, v1
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v2
; GCN-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; GCN-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_udiv24_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v0, 8, v3
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, v0
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v1, v1
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-IR-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-IR-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v3, v2
; GCN-IR-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; GCN-IR-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %1 = lshr i64 %x, 40
  %2 = lshr i64 %y, 40
  %result = udiv i64 %1, %2
  ret i64 %result
}

define amdgpu_kernel void @s_test_udiv32_i64(i64 addrspace(1)* %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_udiv32_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s2, s[0:1], 0xe
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s3
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v2
; GCN-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_udiv32_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dword s2, s[0:1], 0xe
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v1, s3
; GCN-IR-NEXT:    s_mov_b32 s4, s0
; GCN-IR-NEXT:    s_mov_b32 s5, s1
; GCN-IR-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-IR-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v3, v2
; GCN-IR-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %1 = lshr i64 %x, 32
  %2 = lshr i64 %y, 32
  %result = udiv i64 %1, %2
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @s_test_udiv31_i64(i64 addrspace(1)* %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_udiv31_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xe
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_lshr_b32 s0, s0, 1
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s0
; GCN-NEXT:    s_lshr_b32 s0, s7, 1
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s0
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v2
; GCN-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; GCN-NEXT:    v_and_b32_e32 v0, 0x7fffffff, v0
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_udiv31_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-IR-NEXT:    s_load_dword s0, s[0:1], 0xe
; GCN-IR-NEXT:    s_mov_b32 s3, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s2, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_mov_b32 s1, s5
; GCN-IR-NEXT:    s_lshr_b32 s0, s0, 1
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, s0
; GCN-IR-NEXT:    s_lshr_b32 s0, s7, 1
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v1, s0
; GCN-IR-NEXT:    s_mov_b32 s0, s4
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-IR-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-IR-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v3, v2
; GCN-IR-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; GCN-IR-NEXT:    v_and_b32_e32 v0, 0x7fffffff, v0
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-IR-NEXT:    s_endpgm
  %1 = lshr i64 %x, 33
  %2 = lshr i64 %y, 33
  %result = udiv i64 %1, %2
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @s_test_udiv23_i64(i64 addrspace(1)* %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_udiv23_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_load_dword s0, s[0:1], 0xe
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s1, s5
; GCN-NEXT:    s_lshr_b32 s0, s0, 9
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s0
; GCN-NEXT:    s_lshr_b32 s0, s7, 9
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s0
; GCN-NEXT:    s_mov_b32 s0, s4
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v2
; GCN-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; GCN-NEXT:    v_and_b32_e32 v0, 0x7fffff, v0
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_udiv23_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-IR-NEXT:    s_load_dword s0, s[0:1], 0xe
; GCN-IR-NEXT:    s_mov_b32 s3, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s2, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_mov_b32 s1, s5
; GCN-IR-NEXT:    s_lshr_b32 s0, s0, 9
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, s0
; GCN-IR-NEXT:    s_lshr_b32 s0, s7, 9
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v1, s0
; GCN-IR-NEXT:    s_mov_b32 s0, s4
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-IR-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-IR-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v3, v2
; GCN-IR-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; GCN-IR-NEXT:    v_and_b32_e32 v0, 0x7fffff, v0
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-IR-NEXT:    s_endpgm
  %1 = lshr i64 %x, 41
  %2 = lshr i64 %y, 41
  %result = udiv i64 %1, %2
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @s_test_udiv24_i48(i48 addrspace(1)* %out, i48 %x, i48 %y) {
; GCN-LABEL: s_test_udiv24_i48:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s2, s[0:1], 0xd
; GCN-NEXT:    s_load_dword s3, s[0:1], 0xe
; GCN-NEXT:    s_mov_b32 s5, 0xff000000
; GCN-NEXT:    s_mov_b32 s4, 0xffff
; GCN-NEXT:    v_cvt_f32_ubyte3_e32 v2, s4
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_and_b32 s2, s2, s5
; GCN-NEXT:    s_and_b32 s3, s3, s4
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_alignbit_b32 v0, s3, v0, 24
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, v0
; GCN-NEXT:    s_load_dword s6, s[0:1], 0xb
; GCN-NEXT:    s_load_dword s7, s[0:1], 0xc
; GCN-NEXT:    s_lshr_b64 s[2:3], s[2:3], 24
; GCN-NEXT:    v_mov_b32_e32 v9, 0
; GCN-NEXT:    v_mac_f32_e32 v1, 0x4f800000, v2
; GCN-NEXT:    v_rcp_f32_e32 v1, v1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_and_b32 s7, s7, s4
; GCN-NEXT:    s_and_b32 s6, s6, s5
; GCN-NEXT:    s_sub_u32 s8, 0, s2
; GCN-NEXT:    v_mul_f32_e32 v1, 0x5f7ffffc, v1
; GCN-NEXT:    v_mul_f32_e32 v2, 0x2f800000, v1
; GCN-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-NEXT:    v_mac_f32_e32 v1, 0xcf800000, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    s_subb_u32 s9, 0, s3
; GCN-NEXT:    v_mov_b32_e32 v8, 0
; GCN-NEXT:    v_mul_lo_u32 v3, s8, v2
; GCN-NEXT:    v_mul_hi_u32 v4, s8, v1
; GCN-NEXT:    v_mul_lo_u32 v5, s9, v1
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v4, v3
; GCN-NEXT:    v_mul_lo_u32 v4, s8, v1
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; GCN-NEXT:    v_mul_lo_u32 v6, v1, v3
; GCN-NEXT:    v_mul_hi_u32 v5, v1, v3
; GCN-NEXT:    v_mul_hi_u32 v7, v1, v4
; GCN-NEXT:    v_mul_hi_u32 v10, v2, v3
; GCN-NEXT:    v_mul_lo_u32 v3, v2, v3
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_mul_lo_u32 v7, v2, v4
; GCN-NEXT:    v_mul_hi_u32 v4, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v9, v5, vcc
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v6, v7
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, v5, v4, vcc
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v10, v8, vcc
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v4, v3
; GCN-NEXT:    v_add_i32_e64 v1, s[2:3], v1, v3
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, v9, v5, vcc
; GCN-NEXT:    v_addc_u32_e64 v3, vcc, v2, v4, s[2:3]
; GCN-NEXT:    v_mul_lo_u32 v5, s8, v3
; GCN-NEXT:    v_mul_hi_u32 v6, s8, v1
; GCN-NEXT:    v_mul_lo_u32 v7, s9, v1
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v6, v5
; GCN-NEXT:    v_mul_lo_u32 v6, s8, v1
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v7, v5
; GCN-NEXT:    v_mul_lo_u32 v11, v1, v5
; GCN-NEXT:    v_mul_hi_u32 v13, v1, v5
; GCN-NEXT:    v_mul_hi_u32 v12, v1, v6
; GCN-NEXT:    v_mul_hi_u32 v10, v3, v6
; GCN-NEXT:    v_mul_lo_u32 v6, v3, v6
; GCN-NEXT:    v_mul_hi_u32 v7, v3, v5
; GCN-NEXT:    v_add_i32_e32 v11, vcc, v12, v11
; GCN-NEXT:    v_addc_u32_e32 v12, vcc, v9, v13, vcc
; GCN-NEXT:    v_mul_lo_u32 v3, v3, v5
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v11, v6
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v12, v10, vcc
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v7, v8, vcc
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v6, v3
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v9, v5, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e64 v2, vcc, v2, v5, s[2:3]
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GCN-NEXT:    v_mov_b32_e32 v3, s6
; GCN-NEXT:    v_alignbit_b32 v3, s7, v3, 24
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GCN-NEXT:    v_mul_hi_u32 v5, v3, v1
; GCN-NEXT:    v_mul_lo_u32 v4, v3, v2
; GCN-NEXT:    v_mul_hi_u32 v6, v3, v2
; GCN-NEXT:    v_mul_hi_u32 v1, 0, v1
; GCN-NEXT:    v_mul_hi_u32 v2, 0, v2
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v9, v6, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, 0, v4
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v5, v1, vcc
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, v2, v8, vcc
; GCN-NEXT:    v_add_i32_e32 v1, vcc, 0, v1
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, v9, v2, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v5, v0, v1
; GCN-NEXT:    v_mul_lo_u32 v6, v0, v1
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-NEXT:    v_sub_i32_e32 v3, vcc, v3, v6
; GCN-NEXT:    v_subb_u32_e32 v4, vcc, 0, v4, vcc
; GCN-NEXT:    v_sub_i32_e32 v5, vcc, v3, v0
; GCN-NEXT:    v_subbrev_u32_e32 v6, vcc, 0, v4, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v0
; GCN-NEXT:    v_cndmask_b32_e64 v5, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v6
; GCN-NEXT:    v_cndmask_b32_e32 v5, -1, v5, vcc
; GCN-NEXT:    v_add_i32_e32 v6, vcc, 2, v1
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, 0, v2, vcc
; GCN-NEXT:    v_add_i32_e32 v8, vcc, 1, v1
; GCN-NEXT:    v_cmp_ge_u32_e64 s[0:1], v3, v0
; GCN-NEXT:    v_addc_u32_e32 v9, vcc, 0, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, -1, s[0:1]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v4
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v5
; GCN-NEXT:    v_cndmask_b32_e64 v0, -1, v0, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e32 v5, v8, v6, vcc
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, v1, v5, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e32 v1, v9, v7, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v1, v2, v1, s[0:1]
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    buffer_store_short v1, off, s[4:7], 0 offset:4
; GCN-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_udiv24_i48:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; GCN-IR-NEXT:    s_load_dword s2, s[0:1], 0xb
; GCN-IR-NEXT:    s_load_dword s3, s[0:1], 0xc
; GCN-IR-NEXT:    s_load_dword s6, s[0:1], 0xd
; GCN-IR-NEXT:    s_load_dword s7, s[0:1], 0xe
; GCN-IR-NEXT:    s_mov_b32 s8, 0xffff
; GCN-IR-NEXT:    s_mov_b32 s9, 0xff000000
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_and_b32 s1, s3, s8
; GCN-IR-NEXT:    s_and_b32 s0, s2, s9
; GCN-IR-NEXT:    s_and_b32 s3, s7, s8
; GCN-IR-NEXT:    s_and_b32 s2, s6, s9
; GCN-IR-NEXT:    s_lshr_b64 s[2:3], s[2:3], 24
; GCN-IR-NEXT:    s_flbit_i32_b32 s10, s2
; GCN-IR-NEXT:    s_lshr_b64 s[6:7], s[0:1], 24
; GCN-IR-NEXT:    s_add_i32 s10, s10, 32
; GCN-IR-NEXT:    s_flbit_i32_b32 s11, s3
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s10
; GCN-IR-NEXT:    s_flbit_i32_b32 s10, s6
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s11
; GCN-IR-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 0
; GCN-IR-NEXT:    s_add_i32 s10, s10, 32
; GCN-IR-NEXT:    s_flbit_i32_b32 s11, s7
; GCN-IR-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s11
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s10
; GCN-IR-NEXT:    v_cmp_eq_u32_e64 vcc, s7, 0
; GCN-IR-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v2, v3
; GCN-IR-NEXT:    v_subb_u32_e64 v1, s[10:11], 0, 0, vcc
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[2:3], 0
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[8:9], s[6:7], 0
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, 63, v[0:1]
; GCN-IR-NEXT:    s_or_b64 s[0:1], s[0:1], s[8:9]
; GCN-IR-NEXT:    s_or_b64 s[0:1], s[0:1], vcc
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 63, v[0:1]
; GCN-IR-NEXT:    s_xor_b64 s[8:9], s[0:1], -1
; GCN-IR-NEXT:    s_and_b64 s[8:9], s[8:9], vcc
; GCN-IR-NEXT:    s_and_b64 vcc, exec, s[8:9]
; GCN-IR-NEXT:    s_cbranch_vccz BB7_4
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v4, vcc, 1, v0
; GCN-IR-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e64 s[0:1], v[4:5], v[0:1]
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, 63, v0
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], s[6:7], v0
; GCN-IR-NEXT:    s_andn2_b64 vcc, exec, s[0:1]
; GCN-IR-NEXT:    s_cbranch_vccz BB7_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    v_not_b32_e32 v2, v2
; GCN-IR-NEXT:    v_lshr_b64 v[6:7], s[6:7], v4
; GCN-IR-NEXT:    s_add_u32 s6, s2, -1
; GCN-IR-NEXT:    v_add_i32_e32 v4, vcc, v2, v3
; GCN-IR-NEXT:    v_mov_b32_e32 v8, 0
; GCN-IR-NEXT:    s_addc_u32 s7, s3, -1
; GCN-IR-NEXT:    v_addc_u32_e64 v5, s[0:1], -1, 0, vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v9, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v3, 0
; GCN-IR-NEXT:  BB7_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[6:7], v[6:7], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v2, 31, v1
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; GCN-IR-NEXT:    v_or_b32_e32 v6, v6, v2
; GCN-IR-NEXT:    v_or_b32_e32 v0, v8, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v2, s7
; GCN-IR-NEXT:    v_sub_i32_e32 v8, vcc, s6, v6
; GCN-IR-NEXT:    v_subb_u32_e32 v2, vcc, v2, v7, vcc
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v8, 31, v2
; GCN-IR-NEXT:    v_and_b32_e32 v10, s2, v8
; GCN-IR-NEXT:    v_and_b32_e32 v2, 1, v8
; GCN-IR-NEXT:    v_and_b32_e32 v11, s3, v8
; GCN-IR-NEXT:    v_add_i32_e32 v8, vcc, 1, v4
; GCN-IR-NEXT:    v_or_b32_e32 v1, v9, v1
; GCN-IR-NEXT:    v_addc_u32_e32 v9, vcc, 0, v5, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, v[8:9], v[4:5]
; GCN-IR-NEXT:    v_mov_b32_e32 v4, v8
; GCN-IR-NEXT:    v_sub_i32_e64 v6, s[0:1], v6, v10
; GCN-IR-NEXT:    v_mov_b32_e32 v5, v9
; GCN-IR-NEXT:    v_mov_b32_e32 v9, v3
; GCN-IR-NEXT:    v_subb_u32_e64 v7, s[0:1], v7, v11, s[0:1]
; GCN-IR-NEXT:    s_and_b64 vcc, exec, vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v8, v2
; GCN-IR-NEXT:    s_cbranch_vccz BB7_3
; GCN-IR-NEXT:    s_branch BB7_6
; GCN-IR-NEXT:  BB7_4:
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s7
; GCN-IR-NEXT:    v_cndmask_b32_e64 v1, v0, 0, s[0:1]
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s6
; GCN-IR-NEXT:    v_cndmask_b32_e64 v0, v0, 0, s[0:1]
; GCN-IR-NEXT:    s_branch BB7_7
; GCN-IR-NEXT:  BB7_5:
; GCN-IR-NEXT:    v_mov_b32_e32 v2, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v3, 0
; GCN-IR-NEXT:  BB7_6: ; %Flow3
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; GCN-IR-NEXT:    v_or_b32_e32 v0, v2, v0
; GCN-IR-NEXT:    v_or_b32_e32 v1, v3, v1
; GCN-IR-NEXT:  BB7_7: ; %udiv-end
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    buffer_store_short v1, off, s[4:7], 0 offset:4
; GCN-IR-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %1 = lshr i48 %x, 24
  %2 = lshr i48 %y, 24
  %result = udiv i48 %1, %2
  store i48 %result, i48 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @s_test_udiv_k_num_i64(i64 addrspace(1)* %out, i64 %x) {
; GCN-LABEL: s_test_udiv_k_num_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_mov_b32 s11, 0xf000
; GCN-NEXT:    s_mov_b32 s10, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s6
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s7
; GCN-NEXT:    s_sub_u32 s2, 0, s6
; GCN-NEXT:    s_subb_u32 s3, 0, s7
; GCN-NEXT:    s_mov_b32 s8, s4
; GCN-NEXT:    v_mac_f32_e32 v0, 0x4f800000, v1
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_mov_b32 s9, s5
; GCN-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GCN-NEXT:    v_mul_f32_e32 v3, 0x2f800000, v0
; GCN-NEXT:    v_trunc_f32_e32 v3, v3
; GCN-NEXT:    v_mac_f32_e32 v0, 0xcf800000, v3
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GCN-NEXT:    v_mul_hi_u32 v5, s2, v0
; GCN-NEXT:    v_mul_lo_u32 v4, s2, v3
; GCN-NEXT:    v_mul_lo_u32 v7, s3, v0
; GCN-NEXT:    v_mul_lo_u32 v6, s2, v0
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v7
; GCN-NEXT:    v_mul_hi_u32 v5, v0, v6
; GCN-NEXT:    v_mul_lo_u32 v7, v0, v4
; GCN-NEXT:    v_mul_hi_u32 v9, v0, v4
; GCN-NEXT:    v_mul_hi_u32 v8, v3, v6
; GCN-NEXT:    v_mul_lo_u32 v6, v3, v6
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v5, v7
; GCN-NEXT:    v_mul_hi_u32 v10, v3, v4
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v2, v9, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, v3, v4
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v5, v6
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v7, v8, vcc
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v10, v1, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-NEXT:    v_add_i32_e64 v0, s[0:1], v0, v4
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v2, v6, vcc
; GCN-NEXT:    v_addc_u32_e64 v4, vcc, v3, v5, s[0:1]
; GCN-NEXT:    v_mul_lo_u32 v6, s2, v4
; GCN-NEXT:    v_mul_hi_u32 v7, s2, v0
; GCN-NEXT:    v_mul_lo_u32 v8, s3, v0
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_mul_lo_u32 v7, s2, v0
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v8, v6
; GCN-NEXT:    v_mul_lo_u32 v10, v0, v6
; GCN-NEXT:    v_mul_hi_u32 v12, v0, v6
; GCN-NEXT:    v_mul_hi_u32 v11, v0, v7
; GCN-NEXT:    v_mul_hi_u32 v9, v4, v7
; GCN-NEXT:    v_mul_lo_u32 v7, v4, v7
; GCN-NEXT:    v_mul_hi_u32 v8, v4, v6
; GCN-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GCN-NEXT:    v_addc_u32_e32 v11, vcc, v2, v12, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, v4, v6
; GCN-NEXT:    v_add_i32_e32 v7, vcc, v10, v7
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v11, v9, vcc
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v8, v1, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v7, v4
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; GCN-NEXT:    v_addc_u32_e64 v1, vcc, v3, v1, s[0:1]
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GCN-NEXT:    v_mul_lo_u32 v3, v1, 24
; GCN-NEXT:    v_mul_hi_u32 v0, v0, 24
; GCN-NEXT:    v_mul_hi_u32 v1, v1, 24
; GCN-NEXT:    v_mov_b32_e32 v5, s7
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v3
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, v2, v1, vcc
; GCN-NEXT:    v_mul_lo_u32 v1, s7, v0
; GCN-NEXT:    v_mul_hi_u32 v3, s6, v0
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v3, v1
; GCN-NEXT:    v_mul_lo_u32 v3, s6, v0
; GCN-NEXT:    v_sub_i32_e32 v4, vcc, 0, v1
; GCN-NEXT:    v_sub_i32_e32 v3, vcc, 24, v3
; GCN-NEXT:    v_subb_u32_e64 v4, s[0:1], v4, v5, vcc
; GCN-NEXT:    v_subrev_i32_e64 v5, s[0:1], s6, v3
; GCN-NEXT:    v_subbrev_u32_e64 v4, s[0:1], 0, v4, s[0:1]
; GCN-NEXT:    v_cmp_le_u32_e64 s[0:1], s7, v4
; GCN-NEXT:    v_cndmask_b32_e64 v6, 0, -1, s[0:1]
; GCN-NEXT:    v_cmp_le_u32_e64 s[0:1], s6, v5
; GCN-NEXT:    v_cndmask_b32_e64 v5, 0, -1, s[0:1]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[0:1], s7, v4
; GCN-NEXT:    v_cndmask_b32_e64 v4, v6, v5, s[0:1]
; GCN-NEXT:    v_add_i32_e64 v5, s[0:1], 2, v0
; GCN-NEXT:    v_addc_u32_e64 v6, s[0:1], 0, v2, s[0:1]
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, 0, v1, vcc
; GCN-NEXT:    v_add_i32_e64 v7, s[0:1], 1, v0
; GCN-NEXT:    v_addc_u32_e64 v2, s[0:1], 0, v2, s[0:1]
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s7, v1
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v4, 0, -1, vcc
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s6, v3
; GCN-NEXT:    v_cndmask_b32_e64 v3, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, s7, v1
; GCN-NEXT:    v_cndmask_b32_e32 v1, v4, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v2, v7, v5, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_udiv_k_num_i64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_flbit_i32_b32 s2, s6
; GCN-IR-NEXT:    s_flbit_i32_b32 s3, s7
; GCN-IR-NEXT:    s_add_i32 s2, s2, 32
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s3
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s2
; GCN-IR-NEXT:    v_cmp_eq_u32_e64 vcc, s7, 0
; GCN-IR-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GCN-IR-NEXT:    v_add_i32_e32 v0, vcc, 0xffffffc5, v2
; GCN-IR-NEXT:    v_addc_u32_e64 v1, s[2:3], 0, -1, vcc
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[6:7], 0
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, 63, v[0:1]
; GCN-IR-NEXT:    s_or_b64 s[0:1], s[0:1], vcc
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 63, v[0:1]
; GCN-IR-NEXT:    s_xor_b64 s[2:3], s[0:1], -1
; GCN-IR-NEXT:    s_and_b64 s[2:3], s[2:3], vcc
; GCN-IR-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GCN-IR-NEXT:    s_cbranch_vccz BB8_4
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v3, vcc, 1, v0
; GCN-IR-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e64 s[0:1], v[3:4], v[0:1]
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, 63, v0
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], 24, v0
; GCN-IR-NEXT:    s_andn2_b64 vcc, exec, s[0:1]
; GCN-IR-NEXT:    s_cbranch_vccz BB8_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    s_add_u32 s2, s6, -1
; GCN-IR-NEXT:    v_lshr_b64 v[6:7], 24, v3
; GCN-IR-NEXT:    v_sub_i32_e32 v4, vcc, 58, v2
; GCN-IR-NEXT:    v_mov_b32_e32 v8, 0
; GCN-IR-NEXT:    s_addc_u32 s3, s7, -1
; GCN-IR-NEXT:    v_subb_u32_e64 v5, s[0:1], 0, 0, vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v9, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v3, 0
; GCN-IR-NEXT:  BB8_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[6:7], v[6:7], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v2, 31, v1
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; GCN-IR-NEXT:    v_or_b32_e32 v6, v6, v2
; GCN-IR-NEXT:    v_or_b32_e32 v0, v8, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v2, s3
; GCN-IR-NEXT:    v_sub_i32_e32 v8, vcc, s2, v6
; GCN-IR-NEXT:    v_subb_u32_e32 v2, vcc, v2, v7, vcc
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v8, 31, v2
; GCN-IR-NEXT:    v_and_b32_e32 v10, s6, v8
; GCN-IR-NEXT:    v_and_b32_e32 v2, 1, v8
; GCN-IR-NEXT:    v_and_b32_e32 v11, s7, v8
; GCN-IR-NEXT:    v_add_i32_e32 v8, vcc, 1, v4
; GCN-IR-NEXT:    v_or_b32_e32 v1, v9, v1
; GCN-IR-NEXT:    v_addc_u32_e32 v9, vcc, 0, v5, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, v[8:9], v[4:5]
; GCN-IR-NEXT:    v_mov_b32_e32 v4, v8
; GCN-IR-NEXT:    v_sub_i32_e64 v6, s[0:1], v6, v10
; GCN-IR-NEXT:    v_mov_b32_e32 v5, v9
; GCN-IR-NEXT:    v_mov_b32_e32 v9, v3
; GCN-IR-NEXT:    v_subb_u32_e64 v7, s[0:1], v7, v11, s[0:1]
; GCN-IR-NEXT:    s_and_b64 vcc, exec, vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v8, v2
; GCN-IR-NEXT:    s_cbranch_vccz BB8_3
; GCN-IR-NEXT:    s_branch BB8_6
; GCN-IR-NEXT:  BB8_4:
; GCN-IR-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IR-NEXT:    v_cndmask_b32_e64 v0, 24, 0, s[0:1]
; GCN-IR-NEXT:    s_branch BB8_7
; GCN-IR-NEXT:  BB8_5:
; GCN-IR-NEXT:    v_mov_b32_e32 v2, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v3, 0
; GCN-IR-NEXT:  BB8_6: ; %Flow5
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; GCN-IR-NEXT:    v_or_b32_e32 v0, v2, v0
; GCN-IR-NEXT:    v_or_b32_e32 v1, v3, v1
; GCN-IR-NEXT:  BB8_7: ; %udiv-end
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %result = udiv i64 24, %x
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

; define i64 @v_test_udiv_k_num_i64(i64 %x) {
;   %result = udiv i64 24, %x
;   ret i64 %result
; }

define i64 @v_test_udiv_pow2_k_num_i64(i64 %x) {
; GCN-LABEL: v_test_udiv_pow2_k_num_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_u32_e32 v2, v0
; GCN-NEXT:    v_cvt_f32_u32_e32 v3, v1
; GCN-NEXT:    v_sub_i32_e32 v4, vcc, 0, v0
; GCN-NEXT:    v_subb_u32_e32 v5, vcc, 0, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v12, 0
; GCN-NEXT:    v_mac_f32_e32 v2, 0x4f800000, v3
; GCN-NEXT:    v_rcp_f32_e32 v2, v2
; GCN-NEXT:    v_mov_b32_e32 v11, 0
; GCN-NEXT:    v_mul_f32_e32 v2, 0x5f7ffffc, v2
; GCN-NEXT:    v_mul_f32_e32 v3, 0x2f800000, v2
; GCN-NEXT:    v_trunc_f32_e32 v3, v3
; GCN-NEXT:    v_mac_f32_e32 v2, 0xcf800000, v3
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GCN-NEXT:    v_mul_hi_u32 v7, v4, v2
; GCN-NEXT:    v_mul_lo_u32 v6, v4, v3
; GCN-NEXT:    v_mul_lo_u32 v8, v5, v2
; GCN-NEXT:    v_mul_lo_u32 v9, v4, v2
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; GCN-NEXT:    v_mul_lo_u32 v8, v2, v6
; GCN-NEXT:    v_mul_hi_u32 v10, v2, v9
; GCN-NEXT:    v_mul_hi_u32 v7, v2, v6
; GCN-NEXT:    v_mul_hi_u32 v13, v3, v6
; GCN-NEXT:    v_mul_lo_u32 v6, v3, v6
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v10, v8
; GCN-NEXT:    v_mul_lo_u32 v10, v3, v9
; GCN-NEXT:    v_mul_hi_u32 v9, v3, v9
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v12, v7, vcc
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v7, v9, vcc
; GCN-NEXT:    v_addc_u32_e32 v8, vcc, v13, v11, vcc
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_add_i32_e64 v2, s[4:5], v2, v6
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v12, v8, vcc
; GCN-NEXT:    v_addc_u32_e64 v6, vcc, v3, v7, s[4:5]
; GCN-NEXT:    v_mul_lo_u32 v8, v4, v6
; GCN-NEXT:    v_mul_hi_u32 v9, v4, v2
; GCN-NEXT:    v_mul_lo_u32 v5, v5, v2
; GCN-NEXT:    v_mul_lo_u32 v4, v4, v2
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v8, v5
; GCN-NEXT:    v_mul_lo_u32 v10, v2, v5
; GCN-NEXT:    v_mul_hi_u32 v13, v2, v4
; GCN-NEXT:    v_mul_hi_u32 v14, v2, v5
; GCN-NEXT:    v_mul_hi_u32 v9, v6, v4
; GCN-NEXT:    v_mul_lo_u32 v4, v6, v4
; GCN-NEXT:    v_add_i32_e32 v10, vcc, v13, v10
; GCN-NEXT:    v_mul_hi_u32 v8, v6, v5
; GCN-NEXT:    v_addc_u32_e32 v13, vcc, v12, v14, vcc
; GCN-NEXT:    v_mul_lo_u32 v5, v6, v5
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v10, v4
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, v13, v9, vcc
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v8, v11, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v12, v6, vcc
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GCN-NEXT:    v_addc_u32_e64 v3, vcc, v3, v5, s[4:5]
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, 0, v3, vcc
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 17, v2
; GCN-NEXT:    v_mul_lo_u32 v3, v1, v2
; GCN-NEXT:    v_mul_hi_u32 v4, v0, v2
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v4, v3
; GCN-NEXT:    v_mul_lo_u32 v4, v0, v2
; GCN-NEXT:    v_sub_i32_e32 v5, vcc, 0, v3
; GCN-NEXT:    v_sub_i32_e32 v4, vcc, 0x8000, v4
; GCN-NEXT:    v_subb_u32_e64 v5, s[4:5], v5, v1, vcc
; GCN-NEXT:    v_sub_i32_e64 v6, s[4:5], v4, v0
; GCN-NEXT:    v_subbrev_u32_e64 v5, s[4:5], 0, v5, s[4:5]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[4:5], v5, v1
; GCN-NEXT:    v_cndmask_b32_e64 v7, 0, -1, s[4:5]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[4:5], v6, v0
; GCN-NEXT:    v_cndmask_b32_e64 v6, 0, -1, s[4:5]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[4:5], v5, v1
; GCN-NEXT:    v_cndmask_b32_e64 v5, v7, v6, s[4:5]
; GCN-NEXT:    v_add_i32_e64 v6, s[4:5], 2, v2
; GCN-NEXT:    v_addc_u32_e64 v7, s[4:5], 0, v12, s[4:5]
; GCN-NEXT:    v_add_i32_e64 v8, s[4:5], 1, v2
; GCN-NEXT:    v_subb_u32_e32 v3, vcc, 0, v3, vcc
; GCN-NEXT:    v_addc_u32_e64 v9, s[4:5], 0, v12, s[4:5]
; GCN-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v5
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v1
; GCN-NEXT:    v_cndmask_b32_e64 v5, v8, v6, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v6, 0, -1, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e64 v1, v9, v7, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_udiv_pow2_k_num_i64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_ffbh_u32_e32 v2, v0
; GCN-IR-NEXT:    v_add_i32_e32 v2, vcc, 32, v2
; GCN-IR-NEXT:    v_ffbh_u32_e32 v3, v1
; GCN-IR-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GCN-IR-NEXT:    v_cndmask_b32_e32 v4, v3, v2, vcc
; GCN-IR-NEXT:    v_add_i32_e32 v5, vcc, 0xffffffd0, v4
; GCN-IR-NEXT:    v_addc_u32_e64 v6, s[6:7], 0, -1, vcc
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[0:1]
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, 63, v[5:6]
; GCN-IR-NEXT:    s_mov_b64 s[8:9], 0x8000
; GCN-IR-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v2, s8
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 63, v[5:6]
; GCN-IR-NEXT:    v_mov_b32_e32 v7, 0
; GCN-IR-NEXT:    v_cndmask_b32_e64 v2, v2, 0, s[4:5]
; GCN-IR-NEXT:    s_xor_b64 s[4:5], s[4:5], -1
; GCN-IR-NEXT:    v_mov_b32_e32 v3, v7
; GCN-IR-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GCN-IR-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz BB9_6
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v8, vcc, 1, v5
; GCN-IR-NEXT:    v_addc_u32_e32 v9, vcc, 0, v6, vcc
; GCN-IR-NEXT:    v_sub_i32_e64 v2, s[4:5], 63, v5
; GCN-IR-NEXT:    v_cmp_ge_u64_e32 vcc, v[8:9], v[5:6]
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], s[8:9], v2
; GCN-IR-NEXT:    v_mov_b32_e32 v6, 0
; GCN-IR-NEXT:    s_mov_b64 s[10:11], 0
; GCN-IR-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GCN-IR-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz BB9_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    s_mov_b64 s[4:5], 0x8000
; GCN-IR-NEXT:    v_lshr_b64 v[12:13], s[4:5], v8
; GCN-IR-NEXT:    v_add_i32_e32 v8, vcc, -1, v0
; GCN-IR-NEXT:    v_addc_u32_e32 v9, vcc, -1, v1, vcc
; GCN-IR-NEXT:    v_sub_i32_e32 v10, vcc, 47, v4
; GCN-IR-NEXT:    v_mov_b32_e32 v14, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v15, 0
; GCN-IR-NEXT:    v_subb_u32_e32 v11, vcc, 0, v7, vcc
; GCN-IR-NEXT:  BB9_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[12:13], v[12:13], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v4, 31, v3
; GCN-IR-NEXT:    v_or_b32_e32 v4, v12, v4
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; GCN-IR-NEXT:    v_sub_i32_e32 v5, vcc, v8, v4
; GCN-IR-NEXT:    v_subb_u32_e32 v5, vcc, v9, v13, vcc
; GCN-IR-NEXT:    v_or_b32_e32 v2, v14, v2
; GCN-IR-NEXT:    v_add_i32_e32 v14, vcc, 1, v10
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v7, 31, v5
; GCN-IR-NEXT:    v_or_b32_e32 v3, v15, v3
; GCN-IR-NEXT:    v_addc_u32_e32 v15, vcc, 0, v11, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, v[14:15], v[10:11]
; GCN-IR-NEXT:    v_mov_b32_e32 v10, v14
; GCN-IR-NEXT:    v_mov_b32_e32 v6, 0
; GCN-IR-NEXT:    v_and_b32_e32 v5, 1, v7
; GCN-IR-NEXT:    v_and_b32_e32 v16, v7, v1
; GCN-IR-NEXT:    v_and_b32_e32 v7, v7, v0
; GCN-IR-NEXT:    v_sub_i32_e64 v12, s[4:5], v4, v7
; GCN-IR-NEXT:    v_mov_b32_e32 v11, v15
; GCN-IR-NEXT:    v_mov_b32_e32 v15, v6
; GCN-IR-NEXT:    v_subb_u32_e64 v13, s[4:5], v13, v16, s[4:5]
; GCN-IR-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; GCN-IR-NEXT:    v_mov_b32_e32 v14, v5
; GCN-IR-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:    s_cbranch_execnz BB9_3
; GCN-IR-NEXT:  ; %bb.4: ; %Flow
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:  BB9_5: ; %Flow3
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[8:9]
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[2:3], 1
; GCN-IR-NEXT:    v_or_b32_e32 v3, v6, v1
; GCN-IR-NEXT:    v_or_b32_e32 v2, v5, v0
; GCN-IR-NEXT:  BB9_6: ; %Flow4
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[6:7]
; GCN-IR-NEXT:    v_mov_b32_e32 v0, v2
; GCN-IR-NEXT:    v_mov_b32_e32 v1, v3
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %result = udiv i64 32768, %x
  ret i64 %result
}

define i64 @v_test_udiv_pow2_k_den_i64(i64 %x) {
; GCN-LABEL: v_test_udiv_pow2_k_den_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_alignbit_b32 v0, v1, v0, 15
; GCN-NEXT:    v_lshrrev_b32_e32 v1, 15, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_udiv_pow2_k_den_i64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_ffbh_u32_e32 v2, v0
; GCN-IR-NEXT:    v_add_i32_e64 v2, s[4:5], 32, v2
; GCN-IR-NEXT:    v_ffbh_u32_e32 v3, v1
; GCN-IR-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v1
; GCN-IR-NEXT:    v_cndmask_b32_e64 v6, v3, v2, s[4:5]
; GCN-IR-NEXT:    v_sub_i32_e64 v4, s[4:5], 48, v6
; GCN-IR-NEXT:    v_subb_u32_e64 v5, s[4:5], 0, 0, s[4:5]
; GCN-IR-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GCN-IR-NEXT:    v_cmp_lt_u64_e64 s[4:5], 63, v[4:5]
; GCN-IR-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 63, v[4:5]
; GCN-IR-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; GCN-IR-NEXT:    v_cndmask_b32_e64 v2, v1, 0, s[4:5]
; GCN-IR-NEXT:    v_cndmask_b32_e64 v3, v0, 0, s[4:5]
; GCN-IR-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; GCN-IR-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz BB10_6
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v7, vcc, 1, v4
; GCN-IR-NEXT:    v_addc_u32_e32 v8, vcc, 0, v5, vcc
; GCN-IR-NEXT:    v_sub_i32_e64 v2, s[4:5], 63, v4
; GCN-IR-NEXT:    v_cmp_ge_u64_e32 vcc, v[7:8], v[4:5]
; GCN-IR-NEXT:    v_mov_b32_e32 v4, 0
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[0:1], v2
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:    s_mov_b64 s[10:11], 0
; GCN-IR-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GCN-IR-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz BB10_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    v_lshr_b64 v[7:8], v[0:1], v7
; GCN-IR-NEXT:    v_add_i32_e32 v0, vcc, 0xffffffcf, v6
; GCN-IR-NEXT:    v_mov_b32_e32 v9, 0
; GCN-IR-NEXT:    v_addc_u32_e64 v1, s[4:5], 0, -1, vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v10, 0
; GCN-IR-NEXT:    s_movk_i32 s12, 0x7fff
; GCN-IR-NEXT:  BB10_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[7:8], v[7:8], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v4, 31, v3
; GCN-IR-NEXT:    v_or_b32_e32 v7, v7, v4
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; GCN-IR-NEXT:    v_sub_i32_e32 v4, vcc, s12, v7
; GCN-IR-NEXT:    v_subb_u32_e32 v4, vcc, 0, v8, vcc
; GCN-IR-NEXT:    v_or_b32_e32 v2, v9, v2
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v9, 31, v4
; GCN-IR-NEXT:    v_and_b32_e32 v11, 0x8000, v9
; GCN-IR-NEXT:    v_and_b32_e32 v4, 1, v9
; GCN-IR-NEXT:    v_add_i32_e32 v9, vcc, 1, v0
; GCN-IR-NEXT:    v_or_b32_e32 v3, v10, v3
; GCN-IR-NEXT:    v_addc_u32_e32 v10, vcc, 0, v1, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, v[9:10], v[0:1]
; GCN-IR-NEXT:    v_mov_b32_e32 v0, v9
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, v10
; GCN-IR-NEXT:    v_mov_b32_e32 v10, v5
; GCN-IR-NEXT:    v_mov_b32_e32 v6, 0
; GCN-IR-NEXT:    v_sub_i32_e64 v7, s[4:5], v7, v11
; GCN-IR-NEXT:    v_subb_u32_e64 v8, s[4:5], v8, v6, s[4:5]
; GCN-IR-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; GCN-IR-NEXT:    v_mov_b32_e32 v9, v4
; GCN-IR-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:    s_cbranch_execnz BB10_3
; GCN-IR-NEXT:  ; %bb.4: ; %Flow
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:  BB10_5: ; %Flow3
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[8:9]
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[2:3], 1
; GCN-IR-NEXT:    v_or_b32_e32 v2, v5, v1
; GCN-IR-NEXT:    v_or_b32_e32 v3, v4, v0
; GCN-IR-NEXT:  BB10_6: ; %Flow4
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[6:7]
; GCN-IR-NEXT:    v_mov_b32_e32 v0, v3
; GCN-IR-NEXT:    v_mov_b32_e32 v1, v2
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %result = udiv i64 %x, 32768
  ret i64 %result
}

define amdgpu_kernel void @s_test_udiv_k_den_i64(i64 addrspace(1)* %out, i64 %x) {
; GCN-LABEL: s_test_udiv_k_den_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_mov_b32_e32 v0, 0x4f800000
; GCN-NEXT:    v_madak_f32 v0, 0, v0, 0x41c00000
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    s_movk_i32 s2, 0xffe8
; GCN-NEXT:    v_mov_b32_e32 v8, 0
; GCN-NEXT:    v_mov_b32_e32 v7, 0
; GCN-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GCN-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_mac_f32_e32 v0, 0xcf800000, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    v_mul_hi_u32 v2, v0, s2
; GCN-NEXT:    v_mul_lo_u32 v3, v1, s2
; GCN-NEXT:    v_mul_lo_u32 v4, v0, s2
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    v_subrev_i32_e32 v2, vcc, v0, v2
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_mul_lo_u32 v5, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v6, v0, v4
; GCN-NEXT:    v_mul_hi_u32 v3, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v9, v1, v2
; GCN-NEXT:    v_mul_lo_u32 v2, v1, v2
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v6, v5
; GCN-NEXT:    v_mul_lo_u32 v6, v1, v4
; GCN-NEXT:    v_mul_hi_u32 v4, v1, v4
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v8, v3, vcc
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s4, s8
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v5, v6
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v3, v4, vcc
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, v9, v7, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_add_i32_e64 v0, s[0:1], v0, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v8, v4, vcc
; GCN-NEXT:    v_mul_hi_u32 v4, v0, s2
; GCN-NEXT:    v_addc_u32_e64 v2, vcc, v1, v3, s[0:1]
; GCN-NEXT:    v_mul_lo_u32 v5, v2, s2
; GCN-NEXT:    v_mul_lo_u32 v6, v0, s2
; GCN-NEXT:    v_subrev_i32_e32 v4, vcc, v0, v4
; GCN-NEXT:    s_mov_b32 s5, s9
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; GCN-NEXT:    v_mul_lo_u32 v5, v0, v4
; GCN-NEXT:    v_mul_hi_u32 v9, v0, v6
; GCN-NEXT:    v_mul_hi_u32 v10, v0, v4
; GCN-NEXT:    v_mul_hi_u32 v11, v2, v4
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v9, v5
; GCN-NEXT:    v_addc_u32_e32 v9, vcc, v8, v10, vcc
; GCN-NEXT:    v_mul_lo_u32 v10, v2, v6
; GCN-NEXT:    v_mul_hi_u32 v6, v2, v6
; GCN-NEXT:    v_mul_lo_u32 v2, v2, v4
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v5, v10
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v9, v6, vcc
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, v11, v7, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v5, v2
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, v8, v4, vcc
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GCN-NEXT:    v_addc_u32_e64 v1, vcc, v1, v4, s[0:1]
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, s10, v1
; GCN-NEXT:    v_mul_hi_u32 v3, s10, v0
; GCN-NEXT:    v_mul_hi_u32 v4, s10, v1
; GCN-NEXT:    v_mul_hi_u32 v5, s11, v1
; GCN-NEXT:    v_mul_lo_u32 v1, s11, v1
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v8, v4, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, s11, v0
; GCN-NEXT:    v_mul_hi_u32 v0, s11, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, v3, v0, vcc
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, v5, v7, vcc
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v8, v2, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, v1, 24
; GCN-NEXT:    v_mul_hi_u32 v3, v0, 24
; GCN-NEXT:    v_mul_lo_u32 v4, v0, 24
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_sub_i32_e32 v4, vcc, s10, v4
; GCN-NEXT:    v_mov_b32_e32 v3, s11
; GCN-NEXT:    v_subb_u32_e32 v2, vcc, v3, v2, vcc
; GCN-NEXT:    v_subrev_i32_e32 v3, vcc, 24, v4
; GCN-NEXT:    v_subbrev_u32_e32 v5, vcc, 0, v2, vcc
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc, 23, v3
; GCN-NEXT:    v_cndmask_b32_e64 v3, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GCN-NEXT:    v_cndmask_b32_e32 v3, -1, v3, vcc
; GCN-NEXT:    v_add_i32_e32 v5, vcc, 2, v0
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, 0, v1, vcc
; GCN-NEXT:    v_add_i32_e32 v7, vcc, 1, v0
; GCN-NEXT:    v_cmp_lt_u32_e64 s[0:1], 23, v4
; GCN-NEXT:    v_addc_u32_e32 v8, vcc, 0, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v4, 0, -1, s[0:1]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GCN-NEXT:    v_cndmask_b32_e64 v2, -1, v4, s[0:1]
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v2
; GCN-NEXT:    v_cndmask_b32_e32 v3, v8, v6, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, v7, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_udiv_k_den_i64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_flbit_i32_b32 s2, s6
; GCN-IR-NEXT:    s_flbit_i32_b32 s3, s7
; GCN-IR-NEXT:    s_add_i32 s2, s2, 32
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s3
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s2
; GCN-IR-NEXT:    v_cmp_eq_u32_e64 vcc, s7, 0
; GCN-IR-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, 59, v2
; GCN-IR-NEXT:    v_subb_u32_e64 v1, s[2:3], 0, 0, vcc
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[6:7], 0
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, 63, v[0:1]
; GCN-IR-NEXT:    s_or_b64 s[0:1], s[0:1], vcc
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 63, v[0:1]
; GCN-IR-NEXT:    s_xor_b64 s[2:3], s[0:1], -1
; GCN-IR-NEXT:    s_and_b64 s[2:3], s[2:3], vcc
; GCN-IR-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GCN-IR-NEXT:    s_cbranch_vccz BB11_4
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v3, vcc, 1, v0
; GCN-IR-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e64 s[0:1], v[3:4], v[0:1]
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, 63, v0
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], s[6:7], v0
; GCN-IR-NEXT:    s_andn2_b64 vcc, exec, s[0:1]
; GCN-IR-NEXT:    s_cbranch_vccz BB11_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    v_lshr_b64 v[6:7], s[6:7], v3
; GCN-IR-NEXT:    v_add_i32_e32 v4, vcc, 0xffffffc4, v2
; GCN-IR-NEXT:    v_mov_b32_e32 v8, 0
; GCN-IR-NEXT:    v_addc_u32_e64 v5, s[0:1], 0, -1, vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v9, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v3, 0
; GCN-IR-NEXT:  BB11_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[6:7], v[6:7], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v2, 31, v1
; GCN-IR-NEXT:    v_or_b32_e32 v6, v6, v2
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; GCN-IR-NEXT:    v_sub_i32_e32 v2, vcc, 23, v6
; GCN-IR-NEXT:    v_subb_u32_e32 v2, vcc, 0, v7, vcc
; GCN-IR-NEXT:    v_or_b32_e32 v0, v8, v0
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v8, 31, v2
; GCN-IR-NEXT:    v_and_b32_e32 v10, 24, v8
; GCN-IR-NEXT:    v_and_b32_e32 v2, 1, v8
; GCN-IR-NEXT:    v_add_i32_e32 v8, vcc, 1, v4
; GCN-IR-NEXT:    v_or_b32_e32 v1, v9, v1
; GCN-IR-NEXT:    v_addc_u32_e32 v9, vcc, 0, v5, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, v[8:9], v[4:5]
; GCN-IR-NEXT:    v_mov_b32_e32 v4, v8
; GCN-IR-NEXT:    v_sub_i32_e64 v6, s[0:1], v6, v10
; GCN-IR-NEXT:    v_mov_b32_e32 v5, v9
; GCN-IR-NEXT:    v_mov_b32_e32 v9, v3
; GCN-IR-NEXT:    v_subbrev_u32_e64 v7, s[0:1], 0, v7, s[0:1]
; GCN-IR-NEXT:    s_and_b64 vcc, exec, vcc
; GCN-IR-NEXT:    v_mov_b32_e32 v8, v2
; GCN-IR-NEXT:    s_cbranch_vccz BB11_3
; GCN-IR-NEXT:    s_branch BB11_6
; GCN-IR-NEXT:  BB11_4:
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s7
; GCN-IR-NEXT:    v_cndmask_b32_e64 v1, v0, 0, s[0:1]
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s6
; GCN-IR-NEXT:    v_cndmask_b32_e64 v0, v0, 0, s[0:1]
; GCN-IR-NEXT:    s_branch BB11_7
; GCN-IR-NEXT:  BB11_5:
; GCN-IR-NEXT:    v_mov_b32_e32 v2, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v3, 0
; GCN-IR-NEXT:  BB11_6: ; %Flow5
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; GCN-IR-NEXT:    v_or_b32_e32 v0, v2, v0
; GCN-IR-NEXT:    v_or_b32_e32 v1, v3, v1
; GCN-IR-NEXT:  BB11_7: ; %udiv-end
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %result = udiv i64 %x, 24
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define i64 @v_test_udiv_k_den_i64(i64 %x) {
; GCN-LABEL: v_test_udiv_k_den_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v2, 0x4f800000
; GCN-NEXT:    v_madak_f32 v2, 0, v2, 0x41c00000
; GCN-NEXT:    v_rcp_f32_e32 v2, v2
; GCN-NEXT:    s_movk_i32 s6, 0xffe8
; GCN-NEXT:    v_mov_b32_e32 v10, 0
; GCN-NEXT:    v_mov_b32_e32 v9, 0
; GCN-NEXT:    v_mul_f32_e32 v2, 0x5f7ffffc, v2
; GCN-NEXT:    v_mul_f32_e32 v3, 0x2f800000, v2
; GCN-NEXT:    v_trunc_f32_e32 v3, v3
; GCN-NEXT:    v_mac_f32_e32 v2, 0xcf800000, v3
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GCN-NEXT:    v_mul_hi_u32 v4, v2, s6
; GCN-NEXT:    v_mul_lo_u32 v5, v3, s6
; GCN-NEXT:    v_mul_lo_u32 v6, v2, s6
; GCN-NEXT:    v_subrev_i32_e32 v4, vcc, v2, v4
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-NEXT:    v_mul_lo_u32 v7, v2, v4
; GCN-NEXT:    v_mul_hi_u32 v8, v2, v6
; GCN-NEXT:    v_mul_hi_u32 v5, v2, v4
; GCN-NEXT:    v_mul_hi_u32 v11, v3, v4
; GCN-NEXT:    v_mul_lo_u32 v4, v3, v4
; GCN-NEXT:    v_add_i32_e32 v7, vcc, v8, v7
; GCN-NEXT:    v_mul_lo_u32 v8, v3, v6
; GCN-NEXT:    v_mul_hi_u32 v6, v3, v6
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v10, v5, vcc
; GCN-NEXT:    v_add_i32_e32 v7, vcc, v7, v8
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v5, v6, vcc
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v11, v9, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-NEXT:    v_add_i32_e64 v2, s[4:5], v2, v4
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v10, v6, vcc
; GCN-NEXT:    v_mul_hi_u32 v6, v2, s6
; GCN-NEXT:    v_addc_u32_e64 v4, vcc, v3, v5, s[4:5]
; GCN-NEXT:    v_mul_lo_u32 v7, v4, s6
; GCN-NEXT:    v_mul_lo_u32 v8, v2, s6
; GCN-NEXT:    v_subrev_i32_e32 v6, vcc, v2, v6
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v6, v7
; GCN-NEXT:    v_mul_lo_u32 v7, v2, v6
; GCN-NEXT:    v_mul_hi_u32 v11, v2, v8
; GCN-NEXT:    v_mul_hi_u32 v12, v2, v6
; GCN-NEXT:    v_mul_hi_u32 v13, v4, v6
; GCN-NEXT:    v_add_i32_e32 v7, vcc, v11, v7
; GCN-NEXT:    v_addc_u32_e32 v11, vcc, v10, v12, vcc
; GCN-NEXT:    v_mul_lo_u32 v12, v4, v8
; GCN-NEXT:    v_mul_hi_u32 v8, v4, v8
; GCN-NEXT:    v_mul_lo_u32 v4, v4, v6
; GCN-NEXT:    v_add_i32_e32 v7, vcc, v7, v12
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v11, v8, vcc
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v13, v9, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v7, v4
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v10, v6, vcc
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; GCN-NEXT:    v_addc_u32_e64 v3, vcc, v3, v6, s[4:5]
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, v0, v3
; GCN-NEXT:    v_mul_hi_u32 v5, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v6, v0, v3
; GCN-NEXT:    v_mul_hi_u32 v7, v1, v3
; GCN-NEXT:    v_mul_lo_u32 v3, v1, v3
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v10, v6, vcc
; GCN-NEXT:    v_mul_lo_u32 v6, v1, v2
; GCN-NEXT:    v_mul_hi_u32 v2, v1, v2
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v6
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, v5, v2, vcc
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, v7, v9, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v10, v4, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, v3, 24
; GCN-NEXT:    v_mul_hi_u32 v5, v2, 24
; GCN-NEXT:    v_mul_lo_u32 v6, v2, 24
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, v0, v6
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, v1, v4, vcc
; GCN-NEXT:    v_subrev_i32_e32 v4, vcc, 24, v0
; GCN-NEXT:    v_subbrev_u32_e32 v5, vcc, 0, v1, vcc
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc, 23, v4
; GCN-NEXT:    v_cndmask_b32_e64 v4, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GCN-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GCN-NEXT:    v_add_i32_e32 v5, vcc, 2, v2
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, 0, v3, vcc
; GCN-NEXT:    v_add_i32_e32 v7, vcc, 1, v2
; GCN-NEXT:    v_cmp_lt_u32_e64 s[4:5], 23, v0
; GCN-NEXT:    v_addc_u32_e32 v8, vcc, 0, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, -1, s[4:5]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v1
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v0, -1, v0, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v4, v7, v5, vcc
; GCN-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v8, v6, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, v2, v4, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v1, v3, v1, s[4:5]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_udiv_k_den_i64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_ffbh_u32_e32 v2, v0
; GCN-IR-NEXT:    v_add_i32_e64 v2, s[4:5], 32, v2
; GCN-IR-NEXT:    v_ffbh_u32_e32 v3, v1
; GCN-IR-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v1
; GCN-IR-NEXT:    v_cndmask_b32_e64 v6, v3, v2, s[4:5]
; GCN-IR-NEXT:    v_sub_i32_e64 v4, s[4:5], 59, v6
; GCN-IR-NEXT:    v_subb_u32_e64 v5, s[4:5], 0, 0, s[4:5]
; GCN-IR-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GCN-IR-NEXT:    v_cmp_lt_u64_e64 s[4:5], 63, v[4:5]
; GCN-IR-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 63, v[4:5]
; GCN-IR-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; GCN-IR-NEXT:    v_cndmask_b32_e64 v2, v1, 0, s[4:5]
; GCN-IR-NEXT:    v_cndmask_b32_e64 v3, v0, 0, s[4:5]
; GCN-IR-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; GCN-IR-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz BB12_6
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v7, vcc, 1, v4
; GCN-IR-NEXT:    v_addc_u32_e32 v8, vcc, 0, v5, vcc
; GCN-IR-NEXT:    v_sub_i32_e64 v2, s[4:5], 63, v4
; GCN-IR-NEXT:    v_cmp_ge_u64_e32 vcc, v[7:8], v[4:5]
; GCN-IR-NEXT:    v_mov_b32_e32 v4, 0
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[0:1], v2
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:    s_mov_b64 s[10:11], 0
; GCN-IR-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GCN-IR-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz BB12_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    v_lshr_b64 v[7:8], v[0:1], v7
; GCN-IR-NEXT:    v_add_i32_e32 v0, vcc, 0xffffffc4, v6
; GCN-IR-NEXT:    v_mov_b32_e32 v9, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v10, 0
; GCN-IR-NEXT:    v_addc_u32_e64 v1, s[4:5], 0, -1, vcc
; GCN-IR-NEXT:  BB12_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[7:8], v[7:8], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v4, 31, v3
; GCN-IR-NEXT:    v_or_b32_e32 v6, v7, v4
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; GCN-IR-NEXT:    v_sub_i32_e32 v4, vcc, 23, v6
; GCN-IR-NEXT:    v_subb_u32_e32 v4, vcc, 0, v8, vcc
; GCN-IR-NEXT:    v_or_b32_e32 v2, v9, v2
; GCN-IR-NEXT:    v_add_i32_e32 v9, vcc, 1, v0
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v7, 31, v4
; GCN-IR-NEXT:    v_or_b32_e32 v3, v10, v3
; GCN-IR-NEXT:    v_addc_u32_e32 v10, vcc, 0, v1, vcc
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, v[9:10], v[0:1]
; GCN-IR-NEXT:    v_and_b32_e32 v4, 1, v7
; GCN-IR-NEXT:    v_and_b32_e32 v7, 24, v7
; GCN-IR-NEXT:    v_mov_b32_e32 v0, v9
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:    v_sub_i32_e64 v7, s[4:5], v6, v7
; GCN-IR-NEXT:    v_mov_b32_e32 v1, v10
; GCN-IR-NEXT:    v_mov_b32_e32 v10, v5
; GCN-IR-NEXT:    v_subbrev_u32_e64 v8, s[4:5], 0, v8, s[4:5]
; GCN-IR-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; GCN-IR-NEXT:    v_mov_b32_e32 v9, v4
; GCN-IR-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:    s_cbranch_execnz BB12_3
; GCN-IR-NEXT:  ; %bb.4: ; %Flow
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:  BB12_5: ; %Flow3
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[8:9]
; GCN-IR-NEXT:    v_lshl_b64 v[0:1], v[2:3], 1
; GCN-IR-NEXT:    v_or_b32_e32 v2, v5, v1
; GCN-IR-NEXT:    v_or_b32_e32 v3, v4, v0
; GCN-IR-NEXT:  BB12_6: ; %Flow4
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[6:7]
; GCN-IR-NEXT:    v_mov_b32_e32 v0, v3
; GCN-IR-NEXT:    v_mov_b32_e32 v1, v2
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %result = udiv i64 %x, 24
  ret i64 %result
}

define amdgpu_kernel void @s_test_udiv24_k_num_i64(i64 addrspace(1)* %out, i64 %x) {
; GCN-LABEL: s_test_udiv24_k_num_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s4, 0x41c00000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshr_b32 s2, s3, 8
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    v_rcp_iflag_f32_e32 v1, v0
; GCN-NEXT:    v_mul_f32_e32 v1, s4, v1
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v1
; GCN-NEXT:    v_mad_f32 v1, -v1, v0, s4
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, 0, v2, vcc
; GCN-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_udiv24_k_num_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-IR-NEXT:    s_mov_b32 s4, 0x41c00000
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_lshr_b32 s2, s3, 8
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GCN-IR-NEXT:    s_mov_b32 s3, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s2, -1
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v1, v0
; GCN-IR-NEXT:    v_mul_f32_e32 v1, s4, v1
; GCN-IR-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v2, v1
; GCN-IR-NEXT:    v_mad_f32 v1, -v1, v0, s4
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v0, vcc, 0, v2, vcc
; GCN-IR-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-IR-NEXT:    s_endpgm
  %x.shr = lshr i64 %x, 40
  %result = udiv i64 24, %x.shr
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @s_test_udiv24_k_den_i64(i64 addrspace(1)* %out, i64 %x) {
; GCN-LABEL: s_test_udiv24_k_den_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshr_b32 s2, s3, 8
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GCN-NEXT:    s_mov_b32 s2, 0x46b6fe00
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    v_mul_f32_e32 v1, 0x38331158, v0
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v1
; GCN-NEXT:    v_mad_f32 v0, -v1, s2, v0
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v0|, s2
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, 0, v2, vcc
; GCN-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_udiv24_k_den_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_lshr_b32 s2, s3, 8
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GCN-IR-NEXT:    s_mov_b32 s2, 0x46b6fe00
; GCN-IR-NEXT:    s_mov_b32 s4, s0
; GCN-IR-NEXT:    s_mov_b32 s5, s1
; GCN-IR-NEXT:    v_mul_f32_e32 v1, 0x38331158, v0
; GCN-IR-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v2, v1
; GCN-IR-NEXT:    v_mad_f32 v0, -v1, s2, v0
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v0|, s2
; GCN-IR-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v0, vcc, 0, v2, vcc
; GCN-IR-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %x.shr = lshr i64 %x, 40
  %result = udiv i64 %x.shr, 23423
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define i64 @v_test_udiv24_k_num_i64(i64 %x) {
; GCN-LABEL: v_test_udiv24_k_num_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 8, v1
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, v0
; GCN-NEXT:    s_mov_b32 s4, 0x41c00000
; GCN-NEXT:    v_rcp_iflag_f32_e32 v1, v0
; GCN-NEXT:    v_mul_f32_e32 v1, s4, v1
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v1
; GCN-NEXT:    v_mad_f32 v1, -v1, v0, s4
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, 0, v2, vcc
; GCN-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_udiv24_k_num_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v0, 8, v1
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, v0
; GCN-IR-NEXT:    s_mov_b32 s4, 0x41c00000
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v1, v0
; GCN-IR-NEXT:    v_mul_f32_e32 v1, s4, v1
; GCN-IR-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v2, v1
; GCN-IR-NEXT:    v_mad_f32 v1, -v1, v0, s4
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v0, vcc, 0, v2, vcc
; GCN-IR-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %x.shr = lshr i64 %x, 40
  %result = udiv i64 24, %x.shr
  ret i64 %result
}

define i64 @v_test_udiv24_pow2_k_num_i64(i64 %x) {
; GCN-LABEL: v_test_udiv24_pow2_k_num_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 8, v1
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, v0
; GCN-NEXT:    s_mov_b32 s4, 0x47000000
; GCN-NEXT:    v_rcp_iflag_f32_e32 v1, v0
; GCN-NEXT:    v_mul_f32_e32 v1, s4, v1
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v1
; GCN-NEXT:    v_mad_f32 v1, -v1, v0, s4
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, 0, v2, vcc
; GCN-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_udiv24_pow2_k_num_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v0, 8, v1
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, v0
; GCN-IR-NEXT:    s_mov_b32 s4, 0x47000000
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v1, v0
; GCN-IR-NEXT:    v_mul_f32_e32 v1, s4, v1
; GCN-IR-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v2, v1
; GCN-IR-NEXT:    v_mad_f32 v1, -v1, v0, s4
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v0, vcc, 0, v2, vcc
; GCN-IR-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %x.shr = lshr i64 %x, 40
  %result = udiv i64 32768, %x.shr
  ret i64 %result
}

define i64 @v_test_udiv24_pow2_k_den_i64(i64 %x) {
; GCN-LABEL: v_test_udiv24_pow2_k_den_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 23, v1
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_udiv24_pow2_k_den_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v0, 8, v1
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, v0
; GCN-IR-NEXT:    s_mov_b32 s4, 0x47000000
; GCN-IR-NEXT:    v_mul_f32_e32 v1, 0x38000000, v0
; GCN-IR-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v2, v1
; GCN-IR-NEXT:    v_mad_f32 v0, -v1, s4, v0
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v0|, s4
; GCN-IR-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v0, vcc, 0, v2, vcc
; GCN-IR-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %x.shr = lshr i64 %x, 40
  %result = udiv i64 %x.shr, 32768
  ret i64 %result
}
