; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+d,+experimental-zvlsseg,+experimental-zfh \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vlsseg2.nxv16i16(i16*, i64, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vlsseg2.mask.nxv16i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, i64, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vlsseg2_nxv16i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v4, (a0), a1
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vlsseg2.nxv16i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vlsseg2_mask_nxv16i16(i16* %base, i64 %offset, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v4, (a0), a1
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, tu, mu
; CHECK-NEXT:    vlsseg2e16.v v4, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vlsseg2.nxv16i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vlsseg2.mask.nxv16i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, i64 %offset, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg2.nxv4i32(i32*, i64, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg2.mask.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vlsseg2_nxv4i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg2.nxv4i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vlsseg2_mask_nxv4i32(i32* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; CHECK-NEXT:    vlsseg2e32.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg2.nxv4i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg2.mask.nxv4i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg3.nxv4i32(i32*, i64, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg3.mask.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vlsseg3_nxv4i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg3.nxv4i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vlsseg3_mask_nxv4i32(i32* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; CHECK-NEXT:    vlsseg3e32.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg3.nxv4i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg3.mask.nxv4i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg4.nxv4i32(i32*, i64, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg4.mask.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vlsseg4_nxv4i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg4.nxv4i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vlsseg4_mask_nxv4i32(i32* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vmv2r.v v12, v6
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; CHECK-NEXT:    vlsseg4e32.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg4.nxv4i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vlsseg4.mask.nxv4i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg2.nxv16i8(i8*, i64, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg2.mask.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, i64, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vlsseg2_nxv16i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg2.nxv16i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vlsseg2_mask_nxv16i8(i8* %base, i64 %offset, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, tu, mu
; CHECK-NEXT:    vlsseg2e8.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg2.nxv16i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg2.mask.nxv16i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, i64 %offset, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg3.nxv16i8(i8*, i64, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg3.mask.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, i64, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vlsseg3_nxv16i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, mu
; CHECK-NEXT:    vlsseg3e8.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg3.nxv16i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vlsseg3_mask_nxv16i8(i8* %base, i64 %offset, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, mu
; CHECK-NEXT:    vlsseg3e8.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, tu, mu
; CHECK-NEXT:    vlsseg3e8.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg3.nxv16i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg3.mask.nxv16i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, i64 %offset, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg4.nxv16i8(i8*, i64, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg4.mask.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, i64, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vlsseg4_nxv16i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, mu
; CHECK-NEXT:    vlsseg4e8.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg4.nxv16i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vlsseg4_mask_nxv16i8(i8* %base, i64 %offset, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, mu
; CHECK-NEXT:    vlsseg4e8.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vmv2r.v v12, v6
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, tu, mu
; CHECK-NEXT:    vlsseg4e8.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg4.nxv16i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vlsseg4.mask.nxv16i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, i64 %offset, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg2.nxv1i64(i64*, i64, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg2.mask.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vlsseg2_nxv1i64(i64* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg2.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vlsseg2_mask_nxv1i64(i64* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg2e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg2.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg2.mask.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg3.nxv1i64(i64*, i64, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg3.mask.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vlsseg3_nxv1i64(i64* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg3e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg3.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vlsseg3_mask_nxv1i64(i64* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg3e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg3e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg3.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg3.mask.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg4.nxv1i64(i64*, i64, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg4.mask.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vlsseg4_nxv1i64(i64* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg4e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg4.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vlsseg4_mask_nxv1i64(i64* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg4e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg4e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg4.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg4.mask.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg5.nxv1i64(i64*, i64, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg5.mask.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vlsseg5_nxv1i64(i64* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg5e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg5.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vlsseg5_mask_nxv1i64(i64* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg5e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg5e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg5.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg5.mask.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg6.nxv1i64(i64*, i64, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg6.mask.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vlsseg6_nxv1i64(i64* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg6e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg6.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vlsseg6_mask_nxv1i64(i64* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg6e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg6e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg6.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg6.mask.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg7.nxv1i64(i64*, i64, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg7.mask.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vlsseg7_nxv1i64(i64* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg7e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg7.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vlsseg7_mask_nxv1i64(i64* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg7e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg7e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg7.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg7.mask.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg8.nxv1i64(i64*, i64, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg8.mask.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vlsseg8_nxv1i64(i64* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg8e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg8.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vlsseg8_mask_nxv1i64(i64* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg8e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg8e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg8.nxv1i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vlsseg8.mask.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg2.nxv1i32(i32*, i64, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg2.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vlsseg2_nxv1i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg2.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vlsseg2_mask_nxv1i32(i32* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg2.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg2.mask.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg3.nxv1i32(i32*, i64, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg3.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vlsseg3_nxv1i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg3.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vlsseg3_mask_nxv1i32(i32* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg3.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg3.mask.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg4.nxv1i32(i32*, i64, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg4.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vlsseg4_nxv1i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg4.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vlsseg4_mask_nxv1i32(i32* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg4.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg4.mask.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg5.nxv1i32(i32*, i64, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg5.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vlsseg5_nxv1i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg5.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vlsseg5_mask_nxv1i32(i32* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg5.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg5.mask.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg6.nxv1i32(i32*, i64, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg6.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vlsseg6_nxv1i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg6.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vlsseg6_mask_nxv1i32(i32* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg6.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg6.mask.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg7.nxv1i32(i32*, i64, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg7.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vlsseg7_nxv1i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg7.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vlsseg7_mask_nxv1i32(i32* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg7.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg7.mask.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg8.nxv1i32(i32*, i64, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg8.mask.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vlsseg8_nxv1i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg8.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vlsseg8_mask_nxv1i32(i32* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg8.nxv1i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vlsseg8.mask.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg2.nxv8i16(i16*, i64, i64)
declare {<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg2.mask.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>, i16*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x i16> @test_vlsseg2_nxv8i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg2.nxv8i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i16>,<vscale x 8 x i16>} %0, 1
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vlsseg2_mask_nxv8i16(i16* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, tu, mu
; CHECK-NEXT:    vlsseg2e16.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg2.nxv8i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i16>,<vscale x 8 x i16>} %0, 0
  %2 = tail call {<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg2.mask.nxv8i16(<vscale x 8 x i16> %1,<vscale x 8 x i16> %1, i16* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x i16>,<vscale x 8 x i16>} %2, 1
  ret <vscale x 8 x i16> %3
}

declare {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg3.nxv8i16(i16*, i64, i64)
declare {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg3.mask.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, i16*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x i16> @test_vlsseg3_nxv8i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg3.nxv8i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} %0, 1
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vlsseg3_mask_nxv8i16(i16* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, tu, mu
; CHECK-NEXT:    vlsseg3e16.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg3.nxv8i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} %0, 0
  %2 = tail call {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg3.mask.nxv8i16(<vscale x 8 x i16> %1,<vscale x 8 x i16> %1,<vscale x 8 x i16> %1, i16* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} %2, 1
  ret <vscale x 8 x i16> %3
}

declare {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg4.nxv8i16(i16*, i64, i64)
declare {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg4.mask.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, i16*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x i16> @test_vlsseg4_nxv8i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg4.nxv8i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} %0, 1
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vlsseg4_mask_nxv8i16(i16* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vmv2r.v v12, v6
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, tu, mu
; CHECK-NEXT:    vlsseg4e16.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg4.nxv8i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} %0, 0
  %2 = tail call {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} @llvm.riscv.vlsseg4.mask.nxv8i16(<vscale x 8 x i16> %1,<vscale x 8 x i16> %1,<vscale x 8 x i16> %1,<vscale x 8 x i16> %1, i16* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>} %2, 1
  ret <vscale x 8 x i16> %3
}

declare {<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg2.nxv4i8(i8*, i64, i64)
declare {<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg2.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i8> @test_vlsseg2_nxv4i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg2.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 1
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vlsseg2_mask_nxv4i8(i8* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, tu, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg2.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 0
  %2 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg2.mask.nxv4i8(<vscale x 4 x i8> %1,<vscale x 4 x i8> %1, i8* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>} %2, 1
  ret <vscale x 4 x i8> %3
}

declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg3.nxv4i8(i8*, i64, i64)
declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg3.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i8> @test_vlsseg3_nxv4i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg3.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 1
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vlsseg3_mask_nxv4i8(i8* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, tu, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg3.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 0
  %2 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg3.mask.nxv4i8(<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1, i8* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %2, 1
  ret <vscale x 4 x i8> %3
}

declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg4.nxv4i8(i8*, i64, i64)
declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg4.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i8> @test_vlsseg4_nxv4i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg4.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 1
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vlsseg4_mask_nxv4i8(i8* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, tu, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg4.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 0
  %2 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg4.mask.nxv4i8(<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1, i8* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %2, 1
  ret <vscale x 4 x i8> %3
}

declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg5.nxv4i8(i8*, i64, i64)
declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg5.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i8> @test_vlsseg5_nxv4i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg5.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 1
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vlsseg5_mask_nxv4i8(i8* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, tu, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg5.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 0
  %2 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg5.mask.nxv4i8(<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1, i8* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %2, 1
  ret <vscale x 4 x i8> %3
}

declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg6.nxv4i8(i8*, i64, i64)
declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg6.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i8> @test_vlsseg6_nxv4i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg6.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 1
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vlsseg6_mask_nxv4i8(i8* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, tu, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg6.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 0
  %2 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg6.mask.nxv4i8(<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1, i8* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %2, 1
  ret <vscale x 4 x i8> %3
}

declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg7.nxv4i8(i8*, i64, i64)
declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg7.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i8> @test_vlsseg7_nxv4i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg7.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 1
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vlsseg7_mask_nxv4i8(i8* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, tu, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg7.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 0
  %2 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg7.mask.nxv4i8(<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1, i8* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %2, 1
  ret <vscale x 4 x i8> %3
}

declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg8.nxv4i8(i8*, i64, i64)
declare {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg8.mask.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, i8*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i8> @test_vlsseg8_nxv4i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg8.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 1
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vlsseg8_mask_nxv4i8(i8* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, tu, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg8.nxv4i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %0, 0
  %2 = tail call {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} @llvm.riscv.vlsseg8.mask.nxv4i8(<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1,<vscale x 4 x i8> %1, i8* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>} %2, 1
  ret <vscale x 4 x i8> %3
}

declare {<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg2.nxv1i16(i16*, i64, i64)
declare {<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg2.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i16> @test_vlsseg2_nxv1i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg2.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 1
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vlsseg2_mask_nxv1i16(i16* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg2.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 0
  %2 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg2.mask.nxv1i16(<vscale x 1 x i16> %1,<vscale x 1 x i16> %1, i16* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>} %2, 1
  ret <vscale x 1 x i16> %3
}

declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg3.nxv1i16(i16*, i64, i64)
declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg3.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i16> @test_vlsseg3_nxv1i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg3.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 1
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vlsseg3_mask_nxv1i16(i16* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg3.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 0
  %2 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg3.mask.nxv1i16(<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1, i16* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %2, 1
  ret <vscale x 1 x i16> %3
}

declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg4.nxv1i16(i16*, i64, i64)
declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg4.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i16> @test_vlsseg4_nxv1i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg4.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 1
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vlsseg4_mask_nxv1i16(i16* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg4.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 0
  %2 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg4.mask.nxv1i16(<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1, i16* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %2, 1
  ret <vscale x 1 x i16> %3
}

declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg5.nxv1i16(i16*, i64, i64)
declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg5.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i16> @test_vlsseg5_nxv1i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg5.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 1
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vlsseg5_mask_nxv1i16(i16* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg5.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 0
  %2 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg5.mask.nxv1i16(<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1, i16* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %2, 1
  ret <vscale x 1 x i16> %3
}

declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg6.nxv1i16(i16*, i64, i64)
declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg6.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i16> @test_vlsseg6_nxv1i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg6.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 1
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vlsseg6_mask_nxv1i16(i16* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg6.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 0
  %2 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg6.mask.nxv1i16(<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1, i16* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %2, 1
  ret <vscale x 1 x i16> %3
}

declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg7.nxv1i16(i16*, i64, i64)
declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg7.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i16> @test_vlsseg7_nxv1i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg7.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 1
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vlsseg7_mask_nxv1i16(i16* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg7.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 0
  %2 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg7.mask.nxv1i16(<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1, i16* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %2, 1
  ret <vscale x 1 x i16> %3
}

declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg8.nxv1i16(i16*, i64, i64)
declare {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg8.mask.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, i16*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i16> @test_vlsseg8_nxv1i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg8.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 1
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vlsseg8_mask_nxv1i16(i16* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg8.nxv1i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %0, 0
  %2 = tail call {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} @llvm.riscv.vlsseg8.mask.nxv1i16(<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1,<vscale x 1 x i16> %1, i16* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>} %2, 1
  ret <vscale x 1 x i16> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg2.nxv2i32(i32*, i64, i64)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg2.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i32> @test_vlsseg2_nxv2i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg2.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vlsseg2_mask_nxv2i32(i32* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg2.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg2.mask.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg3.nxv2i32(i32*, i64, i64)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg3.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i32> @test_vlsseg3_nxv2i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg3.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vlsseg3_mask_nxv2i32(i32* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg3.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg3.mask.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg4.nxv2i32(i32*, i64, i64)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg4.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i32> @test_vlsseg4_nxv2i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg4.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vlsseg4_mask_nxv2i32(i32* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg4.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg4.mask.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg5.nxv2i32(i32*, i64, i64)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg5.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i32> @test_vlsseg5_nxv2i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg5.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vlsseg5_mask_nxv2i32(i32* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg5.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg5.mask.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg6.nxv2i32(i32*, i64, i64)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg6.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i32> @test_vlsseg6_nxv2i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg6.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vlsseg6_mask_nxv2i32(i32* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg6.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg6.mask.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg7.nxv2i32(i32*, i64, i64)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg7.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i32> @test_vlsseg7_nxv2i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg7.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vlsseg7_mask_nxv2i32(i32* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg7.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg7.mask.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg8.nxv2i32(i32*, i64, i64)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg8.mask.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i32> @test_vlsseg8_nxv2i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg8.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vlsseg8_mask_nxv2i32(i32* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg8.nxv2i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vlsseg8.mask.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg2.nxv8i8(i8*, i64, i64)
declare {<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg2.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x i8> @test_vlsseg2_nxv8i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg2.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 1
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vlsseg2_mask_nxv8i8(i8* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, tu, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg2.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 0
  %2 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg2.mask.nxv8i8(<vscale x 8 x i8> %1,<vscale x 8 x i8> %1, i8* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>} %2, 1
  ret <vscale x 8 x i8> %3
}

declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg3.nxv8i8(i8*, i64, i64)
declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg3.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x i8> @test_vlsseg3_nxv8i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg3.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 1
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vlsseg3_mask_nxv8i8(i8* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, tu, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg3.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 0
  %2 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg3.mask.nxv8i8(<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1, i8* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %2, 1
  ret <vscale x 8 x i8> %3
}

declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg4.nxv8i8(i8*, i64, i64)
declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg4.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x i8> @test_vlsseg4_nxv8i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg4.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 1
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vlsseg4_mask_nxv8i8(i8* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, tu, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg4.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 0
  %2 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg4.mask.nxv8i8(<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1, i8* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %2, 1
  ret <vscale x 8 x i8> %3
}

declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg5.nxv8i8(i8*, i64, i64)
declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg5.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x i8> @test_vlsseg5_nxv8i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg5.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 1
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vlsseg5_mask_nxv8i8(i8* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, tu, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg5.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 0
  %2 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg5.mask.nxv8i8(<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1, i8* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %2, 1
  ret <vscale x 8 x i8> %3
}

declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg6.nxv8i8(i8*, i64, i64)
declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg6.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x i8> @test_vlsseg6_nxv8i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg6.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 1
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vlsseg6_mask_nxv8i8(i8* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, tu, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg6.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 0
  %2 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg6.mask.nxv8i8(<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1, i8* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %2, 1
  ret <vscale x 8 x i8> %3
}

declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg7.nxv8i8(i8*, i64, i64)
declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg7.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x i8> @test_vlsseg7_nxv8i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg7.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 1
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vlsseg7_mask_nxv8i8(i8* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, tu, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg7.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 0
  %2 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg7.mask.nxv8i8(<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1, i8* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %2, 1
  ret <vscale x 8 x i8> %3
}

declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg8.nxv8i8(i8*, i64, i64)
declare {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg8.mask.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, i8*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x i8> @test_vlsseg8_nxv8i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg8.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 1
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vlsseg8_mask_nxv8i8(i8* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, tu, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg8.nxv8i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %0, 0
  %2 = tail call {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} @llvm.riscv.vlsseg8.mask.nxv8i8(<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1,<vscale x 8 x i8> %1, i8* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>} %2, 1
  ret <vscale x 8 x i8> %3
}

declare {<vscale x 4 x i64>,<vscale x 4 x i64>} @llvm.riscv.vlsseg2.nxv4i64(i64*, i64, i64)
declare {<vscale x 4 x i64>,<vscale x 4 x i64>} @llvm.riscv.vlsseg2.mask.nxv4i64(<vscale x 4 x i64>,<vscale x 4 x i64>, i64*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i64> @test_vlsseg2_nxv4i64(i64* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m4, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v4, (a0), a1
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i64>,<vscale x 4 x i64>} @llvm.riscv.vlsseg2.nxv4i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i64>,<vscale x 4 x i64>} %0, 1
  ret <vscale x 4 x i64> %1
}

define <vscale x 4 x i64> @test_vlsseg2_mask_nxv4i64(i64* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m4, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v4, (a0), a1
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; CHECK-NEXT:    vlsseg2e64.v v4, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i64>,<vscale x 4 x i64>} @llvm.riscv.vlsseg2.nxv4i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i64>,<vscale x 4 x i64>} %0, 0
  %2 = tail call {<vscale x 4 x i64>,<vscale x 4 x i64>} @llvm.riscv.vlsseg2.mask.nxv4i64(<vscale x 4 x i64> %1,<vscale x 4 x i64> %1, i64* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i64>,<vscale x 4 x i64>} %2, 1
  ret <vscale x 4 x i64> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg2.nxv4i16(i16*, i64, i64)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg2.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i16> @test_vlsseg2_nxv4i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg2.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vlsseg2_mask_nxv4i16(i16* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg2.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg2.mask.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg3.nxv4i16(i16*, i64, i64)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg3.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i16> @test_vlsseg3_nxv4i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg3.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vlsseg3_mask_nxv4i16(i16* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg3.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg3.mask.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg4.nxv4i16(i16*, i64, i64)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg4.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i16> @test_vlsseg4_nxv4i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg4.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vlsseg4_mask_nxv4i16(i16* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg4.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg4.mask.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg5.nxv4i16(i16*, i64, i64)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg5.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i16> @test_vlsseg5_nxv4i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg5.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vlsseg5_mask_nxv4i16(i16* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg5.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg5.mask.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg6.nxv4i16(i16*, i64, i64)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg6.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i16> @test_vlsseg6_nxv4i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg6.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vlsseg6_mask_nxv4i16(i16* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg6.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg6.mask.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg7.nxv4i16(i16*, i64, i64)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg7.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i16> @test_vlsseg7_nxv4i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg7.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vlsseg7_mask_nxv4i16(i16* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg7.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg7.mask.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg8.nxv4i16(i16*, i64, i64)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg8.mask.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x i16> @test_vlsseg8_nxv4i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg8.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vlsseg8_mask_nxv4i16(i16* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg8.nxv4i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vlsseg8.mask.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg2.nxv1i8(i8*, i64, i64)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg2.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i8> @test_vlsseg2_nxv1i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg2.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vlsseg2_mask_nxv1i8(i8* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, tu, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg2.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg2.mask.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg3.nxv1i8(i8*, i64, i64)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg3.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i8> @test_vlsseg3_nxv1i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg3.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vlsseg3_mask_nxv1i8(i8* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, tu, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg3.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg3.mask.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg4.nxv1i8(i8*, i64, i64)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg4.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i8> @test_vlsseg4_nxv1i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg4.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vlsseg4_mask_nxv1i8(i8* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, tu, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg4.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg4.mask.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg5.nxv1i8(i8*, i64, i64)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg5.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i8> @test_vlsseg5_nxv1i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg5.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vlsseg5_mask_nxv1i8(i8* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, tu, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg5.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg5.mask.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg6.nxv1i8(i8*, i64, i64)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg6.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i8> @test_vlsseg6_nxv1i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg6.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vlsseg6_mask_nxv1i8(i8* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, tu, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg6.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg6.mask.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg7.nxv1i8(i8*, i64, i64)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg7.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i8> @test_vlsseg7_nxv1i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg7.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vlsseg7_mask_nxv1i8(i8* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, tu, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg7.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg7.mask.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg8.nxv1i8(i8*, i64, i64)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg8.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x i8> @test_vlsseg8_nxv1i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg8.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vlsseg8_mask_nxv1i8(i8* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, tu, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg8.nxv1i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vlsseg8.mask.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg2.nxv2i8(i8*, i64, i64)
declare {<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg2.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i8> @test_vlsseg2_nxv2i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg2.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 1
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vlsseg2_mask_nxv2i8(i8* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, tu, mu
; CHECK-NEXT:    vlsseg2e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg2.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 0
  %2 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg2.mask.nxv2i8(<vscale x 2 x i8> %1,<vscale x 2 x i8> %1, i8* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>} %2, 1
  ret <vscale x 2 x i8> %3
}

declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg3.nxv2i8(i8*, i64, i64)
declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg3.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i8> @test_vlsseg3_nxv2i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg3.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 1
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vlsseg3_mask_nxv2i8(i8* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, tu, mu
; CHECK-NEXT:    vlsseg3e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg3.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 0
  %2 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg3.mask.nxv2i8(<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1, i8* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %2, 1
  ret <vscale x 2 x i8> %3
}

declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg4.nxv2i8(i8*, i64, i64)
declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg4.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i8> @test_vlsseg4_nxv2i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg4.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 1
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vlsseg4_mask_nxv2i8(i8* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, tu, mu
; CHECK-NEXT:    vlsseg4e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg4.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 0
  %2 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg4.mask.nxv2i8(<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1, i8* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %2, 1
  ret <vscale x 2 x i8> %3
}

declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg5.nxv2i8(i8*, i64, i64)
declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg5.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i8> @test_vlsseg5_nxv2i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg5.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 1
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vlsseg5_mask_nxv2i8(i8* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, tu, mu
; CHECK-NEXT:    vlsseg5e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg5.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 0
  %2 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg5.mask.nxv2i8(<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1, i8* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %2, 1
  ret <vscale x 2 x i8> %3
}

declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg6.nxv2i8(i8*, i64, i64)
declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg6.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i8> @test_vlsseg6_nxv2i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg6.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 1
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vlsseg6_mask_nxv2i8(i8* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, tu, mu
; CHECK-NEXT:    vlsseg6e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg6.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 0
  %2 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg6.mask.nxv2i8(<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1, i8* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %2, 1
  ret <vscale x 2 x i8> %3
}

declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg7.nxv2i8(i8*, i64, i64)
declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg7.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i8> @test_vlsseg7_nxv2i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg7.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 1
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vlsseg7_mask_nxv2i8(i8* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, tu, mu
; CHECK-NEXT:    vlsseg7e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg7.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 0
  %2 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg7.mask.nxv2i8(<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1, i8* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %2, 1
  ret <vscale x 2 x i8> %3
}

declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg8.nxv2i8(i8*, i64, i64)
declare {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg8.mask.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, i8*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i8> @test_vlsseg8_nxv2i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg8.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 1
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vlsseg8_mask_nxv2i8(i8* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, tu, mu
; CHECK-NEXT:    vlsseg8e8.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg8.nxv2i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %0, 0
  %2 = tail call {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} @llvm.riscv.vlsseg8.mask.nxv2i8(<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1,<vscale x 2 x i8> %1, i8* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>} %2, 1
  ret <vscale x 2 x i8> %3
}

declare {<vscale x 8 x i32>,<vscale x 8 x i32>} @llvm.riscv.vlsseg2.nxv8i32(i32*, i64, i64)
declare {<vscale x 8 x i32>,<vscale x 8 x i32>} @llvm.riscv.vlsseg2.mask.nxv8i32(<vscale x 8 x i32>,<vscale x 8 x i32>, i32*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x i32> @test_vlsseg2_nxv8i32(i32* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m4, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v4, (a0), a1
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i32>,<vscale x 8 x i32>} @llvm.riscv.vlsseg2.nxv8i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i32>,<vscale x 8 x i32>} %0, 1
  ret <vscale x 8 x i32> %1
}

define <vscale x 8 x i32> @test_vlsseg2_mask_nxv8i32(i32* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m4, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v4, (a0), a1
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, tu, mu
; CHECK-NEXT:    vlsseg2e32.v v4, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x i32>,<vscale x 8 x i32>} @llvm.riscv.vlsseg2.nxv8i32(i32* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x i32>,<vscale x 8 x i32>} %0, 0
  %2 = tail call {<vscale x 8 x i32>,<vscale x 8 x i32>} @llvm.riscv.vlsseg2.mask.nxv8i32(<vscale x 8 x i32> %1,<vscale x 8 x i32> %1, i32* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x i32>,<vscale x 8 x i32>} %2, 1
  ret <vscale x 8 x i32> %3
}

declare {<vscale x 32 x i8>,<vscale x 32 x i8>} @llvm.riscv.vlsseg2.nxv32i8(i8*, i64, i64)
declare {<vscale x 32 x i8>,<vscale x 32 x i8>} @llvm.riscv.vlsseg2.mask.nxv32i8(<vscale x 32 x i8>,<vscale x 32 x i8>, i8*, i64, <vscale x 32 x i1>, i64)

define <vscale x 32 x i8> @test_vlsseg2_nxv32i8(i8* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m4, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v4, (a0), a1
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 32 x i8>,<vscale x 32 x i8>} @llvm.riscv.vlsseg2.nxv32i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 32 x i8>,<vscale x 32 x i8>} %0, 1
  ret <vscale x 32 x i8> %1
}

define <vscale x 32 x i8> @test_vlsseg2_mask_nxv32i8(i8* %base, i64 %offset, i64 %vl, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m4, ta, mu
; CHECK-NEXT:    vlsseg2e8.v v4, (a0), a1
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    vsetvli zero, zero, e8, m4, tu, mu
; CHECK-NEXT:    vlsseg2e8.v v4, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 32 x i8>,<vscale x 32 x i8>} @llvm.riscv.vlsseg2.nxv32i8(i8* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 32 x i8>,<vscale x 32 x i8>} %0, 0
  %2 = tail call {<vscale x 32 x i8>,<vscale x 32 x i8>} @llvm.riscv.vlsseg2.mask.nxv32i8(<vscale x 32 x i8> %1,<vscale x 32 x i8> %1, i8* %base, i64 %offset, <vscale x 32 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 32 x i8>,<vscale x 32 x i8>} %2, 1
  ret <vscale x 32 x i8> %3
}

declare {<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg2.nxv2i16(i16*, i64, i64)
declare {<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg2.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i16> @test_vlsseg2_nxv2i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg2.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 1
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vlsseg2_mask_nxv2i16(i16* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg2.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 0
  %2 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg2.mask.nxv2i16(<vscale x 2 x i16> %1,<vscale x 2 x i16> %1, i16* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>} %2, 1
  ret <vscale x 2 x i16> %3
}

declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg3.nxv2i16(i16*, i64, i64)
declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg3.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i16> @test_vlsseg3_nxv2i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg3.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 1
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vlsseg3_mask_nxv2i16(i16* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg3.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 0
  %2 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg3.mask.nxv2i16(<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1, i16* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %2, 1
  ret <vscale x 2 x i16> %3
}

declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg4.nxv2i16(i16*, i64, i64)
declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg4.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i16> @test_vlsseg4_nxv2i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg4.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 1
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vlsseg4_mask_nxv2i16(i16* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg4.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 0
  %2 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg4.mask.nxv2i16(<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1, i16* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %2, 1
  ret <vscale x 2 x i16> %3
}

declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg5.nxv2i16(i16*, i64, i64)
declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg5.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i16> @test_vlsseg5_nxv2i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg5.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 1
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vlsseg5_mask_nxv2i16(i16* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg5.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 0
  %2 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg5.mask.nxv2i16(<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1, i16* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %2, 1
  ret <vscale x 2 x i16> %3
}

declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg6.nxv2i16(i16*, i64, i64)
declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg6.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i16> @test_vlsseg6_nxv2i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg6.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 1
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vlsseg6_mask_nxv2i16(i16* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg6.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 0
  %2 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg6.mask.nxv2i16(<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1, i16* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %2, 1
  ret <vscale x 2 x i16> %3
}

declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg7.nxv2i16(i16*, i64, i64)
declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg7.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i16> @test_vlsseg7_nxv2i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg7.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 1
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vlsseg7_mask_nxv2i16(i16* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg7.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 0
  %2 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg7.mask.nxv2i16(<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1, i16* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %2, 1
  ret <vscale x 2 x i16> %3
}

declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg8.nxv2i16(i16*, i64, i64)
declare {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg8.mask.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, i16*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i16> @test_vlsseg8_nxv2i16(i16* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg8.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 1
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vlsseg8_mask_nxv2i16(i16* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg8.nxv2i16(i16* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %0, 0
  %2 = tail call {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} @llvm.riscv.vlsseg8.mask.nxv2i16(<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1,<vscale x 2 x i16> %1, i16* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>} %2, 1
  ret <vscale x 2 x i16> %3
}

declare {<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg2.nxv2i64(i64*, i64, i64)
declare {<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg2.mask.nxv2i64(<vscale x 2 x i64>,<vscale x 2 x i64>, i64*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i64> @test_vlsseg2_nxv2i64(i64* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg2.nxv2i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i64>,<vscale x 2 x i64>} %0, 1
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vlsseg2_mask_nxv2i64(i64* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, tu, mu
; CHECK-NEXT:    vlsseg2e64.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg2.nxv2i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i64>,<vscale x 2 x i64>} %0, 0
  %2 = tail call {<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg2.mask.nxv2i64(<vscale x 2 x i64> %1,<vscale x 2 x i64> %1, i64* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i64>,<vscale x 2 x i64>} %2, 1
  ret <vscale x 2 x i64> %3
}

declare {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg3.nxv2i64(i64*, i64, i64)
declare {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg3.mask.nxv2i64(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, i64*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i64> @test_vlsseg3_nxv2i64(i64* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg3e64.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg3.nxv2i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} %0, 1
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vlsseg3_mask_nxv2i64(i64* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg3e64.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, tu, mu
; CHECK-NEXT:    vlsseg3e64.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg3.nxv2i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} %0, 0
  %2 = tail call {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg3.mask.nxv2i64(<vscale x 2 x i64> %1,<vscale x 2 x i64> %1,<vscale x 2 x i64> %1, i64* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} %2, 1
  ret <vscale x 2 x i64> %3
}

declare {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg4.nxv2i64(i64*, i64, i64)
declare {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg4.mask.nxv2i64(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, i64*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x i64> @test_vlsseg4_nxv2i64(i64* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg4e64.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg4.nxv2i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} %0, 1
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vlsseg4_mask_nxv2i64(i64* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg4e64.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vmv2r.v v12, v6
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, tu, mu
; CHECK-NEXT:    vlsseg4e64.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg4.nxv2i64(i64* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} %0, 0
  %2 = tail call {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} @llvm.riscv.vlsseg4.mask.nxv2i64(<vscale x 2 x i64> %1,<vscale x 2 x i64> %1,<vscale x 2 x i64> %1,<vscale x 2 x i64> %1, i64* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>} %2, 1
  ret <vscale x 2 x i64> %3
}

declare {<vscale x 16 x half>,<vscale x 16 x half>} @llvm.riscv.vlsseg2.nxv16f16(half*, i64, i64)
declare {<vscale x 16 x half>,<vscale x 16 x half>} @llvm.riscv.vlsseg2.mask.nxv16f16(<vscale x 16 x half>,<vscale x 16 x half>, half*, i64, <vscale x 16 x i1>, i64)

define <vscale x 16 x half> @test_vlsseg2_nxv16f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv16f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v4, (a0), a1
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x half>,<vscale x 16 x half>} @llvm.riscv.vlsseg2.nxv16f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 16 x half>,<vscale x 16 x half>} %0, 1
  ret <vscale x 16 x half> %1
}

define <vscale x 16 x half> @test_vlsseg2_mask_nxv16f16(half* %base, i64 %offset, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv16f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v4, (a0), a1
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, tu, mu
; CHECK-NEXT:    vlsseg2e16.v v4, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x half>,<vscale x 16 x half>} @llvm.riscv.vlsseg2.nxv16f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 16 x half>,<vscale x 16 x half>} %0, 0
  %2 = tail call {<vscale x 16 x half>,<vscale x 16 x half>} @llvm.riscv.vlsseg2.mask.nxv16f16(<vscale x 16 x half> %1,<vscale x 16 x half> %1, half* %base, i64 %offset, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x half>,<vscale x 16 x half>} %2, 1
  ret <vscale x 16 x half> %3
}

declare {<vscale x 4 x double>,<vscale x 4 x double>} @llvm.riscv.vlsseg2.nxv4f64(double*, i64, i64)
declare {<vscale x 4 x double>,<vscale x 4 x double>} @llvm.riscv.vlsseg2.mask.nxv4f64(<vscale x 4 x double>,<vscale x 4 x double>, double*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x double> @test_vlsseg2_nxv4f64(double* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m4, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v4, (a0), a1
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x double>,<vscale x 4 x double>} @llvm.riscv.vlsseg2.nxv4f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x double>,<vscale x 4 x double>} %0, 1
  ret <vscale x 4 x double> %1
}

define <vscale x 4 x double> @test_vlsseg2_mask_nxv4f64(double* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m4, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v4, (a0), a1
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; CHECK-NEXT:    vlsseg2e64.v v4, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x double>,<vscale x 4 x double>} @llvm.riscv.vlsseg2.nxv4f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x double>,<vscale x 4 x double>} %0, 0
  %2 = tail call {<vscale x 4 x double>,<vscale x 4 x double>} @llvm.riscv.vlsseg2.mask.nxv4f64(<vscale x 4 x double> %1,<vscale x 4 x double> %1, double* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x double>,<vscale x 4 x double>} %2, 1
  ret <vscale x 4 x double> %3
}

declare {<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg2.nxv1f64(double*, i64, i64)
declare {<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg2.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>, double*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x double> @test_vlsseg2_nxv1f64(double* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg2.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>} %0, 1
  ret <vscale x 1 x double> %1
}

define <vscale x 1 x double> @test_vlsseg2_mask_nxv1f64(double* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg2e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg2.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>} %0, 0
  %2 = tail call {<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg2.mask.nxv1f64(<vscale x 1 x double> %1,<vscale x 1 x double> %1, double* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>} %2, 1
  ret <vscale x 1 x double> %3
}

declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg3.nxv1f64(double*, i64, i64)
declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg3.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x double> @test_vlsseg3_nxv1f64(double* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg3e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg3.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 1
  ret <vscale x 1 x double> %1
}

define <vscale x 1 x double> @test_vlsseg3_mask_nxv1f64(double* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg3e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg3e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg3.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 0
  %2 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg3.mask.nxv1f64(<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1, double* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %2, 1
  ret <vscale x 1 x double> %3
}

declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg4.nxv1f64(double*, i64, i64)
declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg4.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x double> @test_vlsseg4_nxv1f64(double* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg4e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg4.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 1
  ret <vscale x 1 x double> %1
}

define <vscale x 1 x double> @test_vlsseg4_mask_nxv1f64(double* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg4e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg4e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg4.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 0
  %2 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg4.mask.nxv1f64(<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1, double* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %2, 1
  ret <vscale x 1 x double> %3
}

declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg5.nxv1f64(double*, i64, i64)
declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg5.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x double> @test_vlsseg5_nxv1f64(double* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg5e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg5.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 1
  ret <vscale x 1 x double> %1
}

define <vscale x 1 x double> @test_vlsseg5_mask_nxv1f64(double* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg5e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg5e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg5.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 0
  %2 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg5.mask.nxv1f64(<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1, double* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %2, 1
  ret <vscale x 1 x double> %3
}

declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg6.nxv1f64(double*, i64, i64)
declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg6.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x double> @test_vlsseg6_nxv1f64(double* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg6e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg6.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 1
  ret <vscale x 1 x double> %1
}

define <vscale x 1 x double> @test_vlsseg6_mask_nxv1f64(double* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg6e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg6e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg6.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 0
  %2 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg6.mask.nxv1f64(<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1, double* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %2, 1
  ret <vscale x 1 x double> %3
}

declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg7.nxv1f64(double*, i64, i64)
declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg7.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x double> @test_vlsseg7_nxv1f64(double* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg7e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg7.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 1
  ret <vscale x 1 x double> %1
}

define <vscale x 1 x double> @test_vlsseg7_mask_nxv1f64(double* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg7e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg7e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg7.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 0
  %2 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg7.mask.nxv1f64(<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1, double* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %2, 1
  ret <vscale x 1 x double> %3
}

declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg8.nxv1f64(double*, i64, i64)
declare {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg8.mask.nxv1f64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, double*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x double> @test_vlsseg8_nxv1f64(double* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg8e64.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg8.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 1
  ret <vscale x 1 x double> %1
}

define <vscale x 1 x double> @test_vlsseg8_mask_nxv1f64(double* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; CHECK-NEXT:    vlsseg8e64.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, tu, mu
; CHECK-NEXT:    vlsseg8e64.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg8.nxv1f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %0, 0
  %2 = tail call {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} @llvm.riscv.vlsseg8.mask.nxv1f64(<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1,<vscale x 1 x double> %1, double* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>} %2, 1
  ret <vscale x 1 x double> %3
}

declare {<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg2.nxv2f32(float*, i64, i64)
declare {<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg2.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>, float*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x float> @test_vlsseg2_nxv2f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg2.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>} %0, 1
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vlsseg2_mask_nxv2f32(float* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg2.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>} %0, 0
  %2 = tail call {<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg2.mask.nxv2f32(<vscale x 2 x float> %1,<vscale x 2 x float> %1, float* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>} %2, 1
  ret <vscale x 2 x float> %3
}

declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg3.nxv2f32(float*, i64, i64)
declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg3.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x float> @test_vlsseg3_nxv2f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg3.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 1
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vlsseg3_mask_nxv2f32(float* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg3.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 0
  %2 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg3.mask.nxv2f32(<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1, float* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %2, 1
  ret <vscale x 2 x float> %3
}

declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg4.nxv2f32(float*, i64, i64)
declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg4.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x float> @test_vlsseg4_nxv2f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg4.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 1
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vlsseg4_mask_nxv2f32(float* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg4.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 0
  %2 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg4.mask.nxv2f32(<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1, float* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %2, 1
  ret <vscale x 2 x float> %3
}

declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg5.nxv2f32(float*, i64, i64)
declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg5.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x float> @test_vlsseg5_nxv2f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg5.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 1
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vlsseg5_mask_nxv2f32(float* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg5.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 0
  %2 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg5.mask.nxv2f32(<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1, float* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %2, 1
  ret <vscale x 2 x float> %3
}

declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg6.nxv2f32(float*, i64, i64)
declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg6.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x float> @test_vlsseg6_nxv2f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg6.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 1
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vlsseg6_mask_nxv2f32(float* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg6.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 0
  %2 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg6.mask.nxv2f32(<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1, float* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %2, 1
  ret <vscale x 2 x float> %3
}

declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg7.nxv2f32(float*, i64, i64)
declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg7.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x float> @test_vlsseg7_nxv2f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg7.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 1
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vlsseg7_mask_nxv2f32(float* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg7.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 0
  %2 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg7.mask.nxv2f32(<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1, float* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %2, 1
  ret <vscale x 2 x float> %3
}

declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg8.nxv2f32(float*, i64, i64)
declare {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg8.mask.nxv2f32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, float*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x float> @test_vlsseg8_nxv2f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg8.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 1
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vlsseg8_mask_nxv2f32(float* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, tu, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg8.nxv2f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %0, 0
  %2 = tail call {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} @llvm.riscv.vlsseg8.mask.nxv2f32(<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1,<vscale x 2 x float> %1, float* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>} %2, 1
  ret <vscale x 2 x float> %3
}

declare {<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg2.nxv1f16(half*, i64, i64)
declare {<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg2.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>, half*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x half> @test_vlsseg2_nxv1f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg2.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>} %0, 1
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vlsseg2_mask_nxv1f16(half* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg2.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>} %0, 0
  %2 = tail call {<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg2.mask.nxv1f16(<vscale x 1 x half> %1,<vscale x 1 x half> %1, half* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>} %2, 1
  ret <vscale x 1 x half> %3
}

declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg3.nxv1f16(half*, i64, i64)
declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg3.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x half> @test_vlsseg3_nxv1f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg3.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 1
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vlsseg3_mask_nxv1f16(half* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg3.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 0
  %2 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg3.mask.nxv1f16(<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1, half* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %2, 1
  ret <vscale x 1 x half> %3
}

declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg4.nxv1f16(half*, i64, i64)
declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg4.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x half> @test_vlsseg4_nxv1f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg4.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 1
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vlsseg4_mask_nxv1f16(half* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg4.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 0
  %2 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg4.mask.nxv1f16(<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1, half* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %2, 1
  ret <vscale x 1 x half> %3
}

declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg5.nxv1f16(half*, i64, i64)
declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg5.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x half> @test_vlsseg5_nxv1f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg5.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 1
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vlsseg5_mask_nxv1f16(half* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg5.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 0
  %2 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg5.mask.nxv1f16(<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1, half* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %2, 1
  ret <vscale x 1 x half> %3
}

declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg6.nxv1f16(half*, i64, i64)
declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg6.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x half> @test_vlsseg6_nxv1f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg6.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 1
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vlsseg6_mask_nxv1f16(half* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg6.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 0
  %2 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg6.mask.nxv1f16(<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1, half* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %2, 1
  ret <vscale x 1 x half> %3
}

declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg7.nxv1f16(half*, i64, i64)
declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg7.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x half> @test_vlsseg7_nxv1f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg7.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 1
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vlsseg7_mask_nxv1f16(half* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg7.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 0
  %2 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg7.mask.nxv1f16(<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1, half* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %2, 1
  ret <vscale x 1 x half> %3
}

declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg8.nxv1f16(half*, i64, i64)
declare {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg8.mask.nxv1f16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, half*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x half> @test_vlsseg8_nxv1f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg8.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 1
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vlsseg8_mask_nxv1f16(half* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, tu, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg8.nxv1f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %0, 0
  %2 = tail call {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} @llvm.riscv.vlsseg8.mask.nxv1f16(<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1,<vscale x 1 x half> %1, half* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>} %2, 1
  ret <vscale x 1 x half> %3
}

declare {<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg2.nxv1f32(float*, i64, i64)
declare {<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg2.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>, float*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x float> @test_vlsseg2_nxv1f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg2.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>} %0, 1
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vlsseg2_mask_nxv1f32(float* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg2e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg2.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>} %0, 0
  %2 = tail call {<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg2.mask.nxv1f32(<vscale x 1 x float> %1,<vscale x 1 x float> %1, float* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>} %2, 1
  ret <vscale x 1 x float> %3
}

declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg3.nxv1f32(float*, i64, i64)
declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg3.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x float> @test_vlsseg3_nxv1f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg3.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 1
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vlsseg3_mask_nxv1f32(float* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg3e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg3.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 0
  %2 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg3.mask.nxv1f32(<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1, float* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %2, 1
  ret <vscale x 1 x float> %3
}

declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg4.nxv1f32(float*, i64, i64)
declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg4.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x float> @test_vlsseg4_nxv1f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg4.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 1
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vlsseg4_mask_nxv1f32(float* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg4e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg4.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 0
  %2 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg4.mask.nxv1f32(<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1, float* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %2, 1
  ret <vscale x 1 x float> %3
}

declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg5.nxv1f32(float*, i64, i64)
declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg5.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x float> @test_vlsseg5_nxv1f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg5.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 1
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vlsseg5_mask_nxv1f32(float* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg5e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg5.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 0
  %2 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg5.mask.nxv1f32(<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1, float* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %2, 1
  ret <vscale x 1 x float> %3
}

declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg6.nxv1f32(float*, i64, i64)
declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg6.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x float> @test_vlsseg6_nxv1f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg6.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 1
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vlsseg6_mask_nxv1f32(float* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg6e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg6.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 0
  %2 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg6.mask.nxv1f32(<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1, float* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %2, 1
  ret <vscale x 1 x float> %3
}

declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg7.nxv1f32(float*, i64, i64)
declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg7.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x float> @test_vlsseg7_nxv1f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg7.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 1
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vlsseg7_mask_nxv1f32(float* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg7e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg7.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 0
  %2 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg7.mask.nxv1f32(<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1, float* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %2, 1
  ret <vscale x 1 x float> %3
}

declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg8.nxv1f32(float*, i64, i64)
declare {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg8.mask.nxv1f32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, float*, i64, <vscale x 1 x i1>, i64)

define <vscale x 1 x float> @test_vlsseg8_nxv1f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg8.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 1
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vlsseg8_mask_nxv1f32(float* %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; CHECK-NEXT:    vlsseg8e32.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg8.nxv1f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %0, 0
  %2 = tail call {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} @llvm.riscv.vlsseg8.mask.nxv1f32(<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1,<vscale x 1 x float> %1, float* %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>} %2, 1
  ret <vscale x 1 x float> %3
}

declare {<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg2.nxv8f16(half*, i64, i64)
declare {<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg2.mask.nxv8f16(<vscale x 8 x half>,<vscale x 8 x half>, half*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x half> @test_vlsseg2_nxv8f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg2.nxv8f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x half>,<vscale x 8 x half>} %0, 1
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vlsseg2_mask_nxv8f16(half* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, tu, mu
; CHECK-NEXT:    vlsseg2e16.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg2.nxv8f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x half>,<vscale x 8 x half>} %0, 0
  %2 = tail call {<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg2.mask.nxv8f16(<vscale x 8 x half> %1,<vscale x 8 x half> %1, half* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x half>,<vscale x 8 x half>} %2, 1
  ret <vscale x 8 x half> %3
}

declare {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg3.nxv8f16(half*, i64, i64)
declare {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg3.mask.nxv8f16(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, half*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x half> @test_vlsseg3_nxv8f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg3.nxv8f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} %0, 1
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vlsseg3_mask_nxv8f16(half* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, tu, mu
; CHECK-NEXT:    vlsseg3e16.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg3.nxv8f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} %0, 0
  %2 = tail call {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg3.mask.nxv8f16(<vscale x 8 x half> %1,<vscale x 8 x half> %1,<vscale x 8 x half> %1, half* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} %2, 1
  ret <vscale x 8 x half> %3
}

declare {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg4.nxv8f16(half*, i64, i64)
declare {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg4.mask.nxv8f16(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, half*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x half> @test_vlsseg4_nxv8f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg4.nxv8f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} %0, 1
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vlsseg4_mask_nxv8f16(half* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vmv2r.v v12, v6
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, tu, mu
; CHECK-NEXT:    vlsseg4e16.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg4.nxv8f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} %0, 0
  %2 = tail call {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} @llvm.riscv.vlsseg4.mask.nxv8f16(<vscale x 8 x half> %1,<vscale x 8 x half> %1,<vscale x 8 x half> %1,<vscale x 8 x half> %1, half* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>} %2, 1
  ret <vscale x 8 x half> %3
}

declare {<vscale x 8 x float>,<vscale x 8 x float>} @llvm.riscv.vlsseg2.nxv8f32(float*, i64, i64)
declare {<vscale x 8 x float>,<vscale x 8 x float>} @llvm.riscv.vlsseg2.mask.nxv8f32(<vscale x 8 x float>,<vscale x 8 x float>, float*, i64, <vscale x 8 x i1>, i64)

define <vscale x 8 x float> @test_vlsseg2_nxv8f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m4, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v4, (a0), a1
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x float>,<vscale x 8 x float>} @llvm.riscv.vlsseg2.nxv8f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x float>,<vscale x 8 x float>} %0, 1
  ret <vscale x 8 x float> %1
}

define <vscale x 8 x float> @test_vlsseg2_mask_nxv8f32(float* %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m4, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v4, (a0), a1
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, tu, mu
; CHECK-NEXT:    vlsseg2e32.v v4, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v4m4_v8m4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 8 x float>,<vscale x 8 x float>} @llvm.riscv.vlsseg2.nxv8f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 8 x float>,<vscale x 8 x float>} %0, 0
  %2 = tail call {<vscale x 8 x float>,<vscale x 8 x float>} @llvm.riscv.vlsseg2.mask.nxv8f32(<vscale x 8 x float> %1,<vscale x 8 x float> %1, float* %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 8 x float>,<vscale x 8 x float>} %2, 1
  ret <vscale x 8 x float> %3
}

declare {<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg2.nxv2f64(double*, i64, i64)
declare {<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg2.mask.nxv2f64(<vscale x 2 x double>,<vscale x 2 x double>, double*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x double> @test_vlsseg2_nxv2f64(double* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg2.nxv2f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x double>,<vscale x 2 x double>} %0, 1
  ret <vscale x 2 x double> %1
}

define <vscale x 2 x double> @test_vlsseg2_mask_nxv2f64(double* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg2e64.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, tu, mu
; CHECK-NEXT:    vlsseg2e64.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg2.nxv2f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x double>,<vscale x 2 x double>} %0, 0
  %2 = tail call {<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg2.mask.nxv2f64(<vscale x 2 x double> %1,<vscale x 2 x double> %1, double* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x double>,<vscale x 2 x double>} %2, 1
  ret <vscale x 2 x double> %3
}

declare {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg3.nxv2f64(double*, i64, i64)
declare {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg3.mask.nxv2f64(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, double*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x double> @test_vlsseg3_nxv2f64(double* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg3e64.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg3.nxv2f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} %0, 1
  ret <vscale x 2 x double> %1
}

define <vscale x 2 x double> @test_vlsseg3_mask_nxv2f64(double* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg3e64.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, tu, mu
; CHECK-NEXT:    vlsseg3e64.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg3.nxv2f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} %0, 0
  %2 = tail call {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg3.mask.nxv2f64(<vscale x 2 x double> %1,<vscale x 2 x double> %1,<vscale x 2 x double> %1, double* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} %2, 1
  ret <vscale x 2 x double> %3
}

declare {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg4.nxv2f64(double*, i64, i64)
declare {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg4.mask.nxv2f64(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, double*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x double> @test_vlsseg4_nxv2f64(double* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg4e64.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg4.nxv2f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} %0, 1
  ret <vscale x 2 x double> %1
}

define <vscale x 2 x double> @test_vlsseg4_mask_nxv2f64(double* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; CHECK-NEXT:    vlsseg4e64.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vmv2r.v v12, v6
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, tu, mu
; CHECK-NEXT:    vlsseg4e64.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg4.nxv2f64(double* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} %0, 0
  %2 = tail call {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} @llvm.riscv.vlsseg4.mask.nxv2f64(<vscale x 2 x double> %1,<vscale x 2 x double> %1,<vscale x 2 x double> %1,<vscale x 2 x double> %1, double* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>} %2, 1
  ret <vscale x 2 x double> %3
}

declare {<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg2.nxv4f16(half*, i64, i64)
declare {<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg2.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>, half*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x half> @test_vlsseg2_nxv4f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg2.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>} %0, 1
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vlsseg2_mask_nxv4f16(half* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg2.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>} %0, 0
  %2 = tail call {<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg2.mask.nxv4f16(<vscale x 4 x half> %1,<vscale x 4 x half> %1, half* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>} %2, 1
  ret <vscale x 4 x half> %3
}

declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg3.nxv4f16(half*, i64, i64)
declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg3.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x half> @test_vlsseg3_nxv4f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg3.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 1
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vlsseg3_mask_nxv4f16(half* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg3.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 0
  %2 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg3.mask.nxv4f16(<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1, half* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %2, 1
  ret <vscale x 4 x half> %3
}

declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg4.nxv4f16(half*, i64, i64)
declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg4.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x half> @test_vlsseg4_nxv4f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg4.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 1
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vlsseg4_mask_nxv4f16(half* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg4.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 0
  %2 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg4.mask.nxv4f16(<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1, half* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %2, 1
  ret <vscale x 4 x half> %3
}

declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg5.nxv4f16(half*, i64, i64)
declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg5.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x half> @test_vlsseg5_nxv4f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg5.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 1
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vlsseg5_mask_nxv4f16(half* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg5.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 0
  %2 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg5.mask.nxv4f16(<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1, half* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %2, 1
  ret <vscale x 4 x half> %3
}

declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg6.nxv4f16(half*, i64, i64)
declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg6.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x half> @test_vlsseg6_nxv4f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg6.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 1
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vlsseg6_mask_nxv4f16(half* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg6.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 0
  %2 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg6.mask.nxv4f16(<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1, half* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %2, 1
  ret <vscale x 4 x half> %3
}

declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg7.nxv4f16(half*, i64, i64)
declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg7.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x half> @test_vlsseg7_nxv4f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg7.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 1
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vlsseg7_mask_nxv4f16(half* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg7.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 0
  %2 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg7.mask.nxv4f16(<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1, half* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %2, 1
  ret <vscale x 4 x half> %3
}

declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg8.nxv4f16(half*, i64, i64)
declare {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg8.mask.nxv4f16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, half*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x half> @test_vlsseg8_nxv4f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg8.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 1
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vlsseg8_mask_nxv4f16(half* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg8.nxv4f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %0, 0
  %2 = tail call {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} @llvm.riscv.vlsseg8.mask.nxv4f16(<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1,<vscale x 4 x half> %1, half* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>} %2, 1
  ret <vscale x 4 x half> %3
}

declare {<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg2.nxv2f16(half*, i64, i64)
declare {<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg2.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>, half*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x half> @test_vlsseg2_nxv2f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg2.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>} %0, 1
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vlsseg2_mask_nxv2f16(half* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg2e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg2.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>} %0, 0
  %2 = tail call {<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg2.mask.nxv2f16(<vscale x 2 x half> %1,<vscale x 2 x half> %1, half* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>} %2, 1
  ret <vscale x 2 x half> %3
}

declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg3.nxv2f16(half*, i64, i64)
declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg3.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x half> @test_vlsseg3_nxv2f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg3.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 1
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vlsseg3_mask_nxv2f16(half* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg3e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg3.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 0
  %2 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg3.mask.nxv2f16(<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1, half* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %2, 1
  ret <vscale x 2 x half> %3
}

declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg4.nxv2f16(half*, i64, i64)
declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg4.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x half> @test_vlsseg4_nxv2f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg4.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 1
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vlsseg4_mask_nxv2f16(half* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg4e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg4.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 0
  %2 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg4.mask.nxv2f16(<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1, half* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %2, 1
  ret <vscale x 2 x half> %3
}

declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg5.nxv2f16(half*, i64, i64)
declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg5.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x half> @test_vlsseg5_nxv2f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg5_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg5.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 1
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vlsseg5_mask_nxv2f16(half* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg5_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg5e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg5.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 0
  %2 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg5.mask.nxv2f16(<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1, half* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %2, 1
  ret <vscale x 2 x half> %3
}

declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg6.nxv2f16(half*, i64, i64)
declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg6.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x half> @test_vlsseg6_nxv2f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg6_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg6.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 1
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vlsseg6_mask_nxv2f16(half* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg6_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg6e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg6.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 0
  %2 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg6.mask.nxv2f16(<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1, half* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %2, 1
  ret <vscale x 2 x half> %3
}

declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg7.nxv2f16(half*, i64, i64)
declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg7.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x half> @test_vlsseg7_nxv2f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg7_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg7.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 1
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vlsseg7_mask_nxv2f16(half* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg7_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg7e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg7.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 0
  %2 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg7.mask.nxv2f16(<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1, half* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %2, 1
  ret <vscale x 2 x half> %3
}

declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg8.nxv2f16(half*, i64, i64)
declare {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg8.mask.nxv2f16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, half*, i64, <vscale x 2 x i1>, i64)

define <vscale x 2 x half> @test_vlsseg8_nxv2f16(half* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg8_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg8.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 1
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vlsseg8_mask_nxv2f16(half* %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vlsseg8_mask_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vmv1r.v v9, v7
; CHECK-NEXT:    vmv1r.v v10, v7
; CHECK-NEXT:    vmv1r.v v11, v7
; CHECK-NEXT:    vmv1r.v v12, v7
; CHECK-NEXT:    vmv1r.v v13, v7
; CHECK-NEXT:    vmv1r.v v14, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, tu, mu
; CHECK-NEXT:    vlsseg8e16.v v7, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v7_v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg8.nxv2f16(half* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %0, 0
  %2 = tail call {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} @llvm.riscv.vlsseg8.mask.nxv2f16(<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1,<vscale x 2 x half> %1, half* %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>} %2, 1
  ret <vscale x 2 x half> %3
}

declare {<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg2.nxv4f32(float*, i64, i64)
declare {<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg2.mask.nxv4f32(<vscale x 4 x float>,<vscale x 4 x float>, float*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x float> @test_vlsseg2_nxv4f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg2_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg2.nxv4f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x float>,<vscale x 4 x float>} %0, 1
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vlsseg2_mask_nxv4f32(float* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg2_mask_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg2e32.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; CHECK-NEXT:    vlsseg2e32.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg2.nxv4f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x float>,<vscale x 4 x float>} %0, 0
  %2 = tail call {<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg2.mask.nxv4f32(<vscale x 4 x float> %1,<vscale x 4 x float> %1, float* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x float>,<vscale x 4 x float>} %2, 1
  ret <vscale x 4 x float> %3
}

declare {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg3.nxv4f32(float*, i64, i64)
declare {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg3.mask.nxv4f32(<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>, float*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x float> @test_vlsseg3_nxv4f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg3_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg3.nxv4f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} %0, 1
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vlsseg3_mask_nxv4f32(float* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg3_mask_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg3e32.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; CHECK-NEXT:    vlsseg3e32.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg3.nxv4f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} %0, 0
  %2 = tail call {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg3.mask.nxv4f32(<vscale x 4 x float> %1,<vscale x 4 x float> %1,<vscale x 4 x float> %1, float* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} %2, 1
  ret <vscale x 4 x float> %3
}

declare {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg4.nxv4f32(float*, i64, i64)
declare {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg4.mask.nxv4f32(<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>, float*, i64, <vscale x 4 x i1>, i64)

define <vscale x 4 x float> @test_vlsseg4_nxv4f32(float* %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vlsseg4_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v6, (a0), a1
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg4.nxv4f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} %0, 1
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vlsseg4_mask_nxv4f32(float* %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vlsseg4_mask_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, mu
; CHECK-NEXT:    vlsseg4e32.v v6, (a0), a1
; CHECK-NEXT:    vmv2r.v v8, v6
; CHECK-NEXT:    vmv2r.v v10, v6
; CHECK-NEXT:    vmv2r.v v12, v6
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; CHECK-NEXT:    vlsseg4e32.v v6, (a0), a1, v0.t
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v6m2_v8m2_v10m2_v12m2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg4.nxv4f32(float* %base, i64 %offset, i64 %vl)
  %1 = extractvalue {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} %0, 0
  %2 = tail call {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} @llvm.riscv.vlsseg4.mask.nxv4f32(<vscale x 4 x float> %1,<vscale x 4 x float> %1,<vscale x 4 x float> %1,<vscale x 4 x float> %1, float* %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>,<vscale x 4 x float>} %2, 1
  ret <vscale x 4 x float> %3
}
