#include "mapper.h"
#include "builder.h"
#include "crush.h"

int main() {
  /* create the map */
  struct crush_map *m = crush_create();
  int type = 1;
  int size = 1;
  int hash = 3;

  /* add one bucket */
  int bucketno = 0;
  struct crush_bucket *b;

  b = crush_make_bucket(m, CRUSH_BUCKET_STRAW2, hash, type,
                        0, NULL, NULL);
  assert(b != NULL);
  assert(crush_add_bucket(m, 0, b, &bucketno) == 0);

  /* add one item in the bucket */
  int item = 3;
  assert(crush_bucket_add_item(m, b, item, 0x10000) == 0);

  /* add one rule to take the item */
  struct crush_rule *r;
  int minsize = 1;
  int maxsize = 1;
  int number_of_steps = 2;
  r = crush_make_rule(number_of_steps, 0, 0, minsize, maxsize);
  assert(r != NULL);
  crush_rule_set_step(r, 0, CRUSH_RULE_TAKE, item, 0);
  crush_rule_set_step(r, 1, CRUSH_RULE_EMIT, 0, 0);
  int ruleno = crush_add_rule(m, r, -1);
  assert(ruleno >= 0);

  /* assume the map won't be changed and compute values to
     help with mapping. */
  crush_finalize(m);

  /* map x to the item */
  int result[1];
  result[0] = 0;
  __u32 weights[1];
  weights[0] = 0x10000;
  int cwin_size = crush_work_size(m, 1);
  char cwin[cwin_size];
  int x = 1;
  crush_init_workspace(m, cwin);
  assert(crush_do_rule(m, ruleno, x, result, 1, weights, 1, cwin) == 1);
  assert(result[0] == item);

  crush_destroy(m);
  return 0;
}
