------------------------------------------------------------------------------
--                                                                          --
--                	        G N A T . RAVENSCAR                         --
--                                                                          --
--                      Copyright (C) 2008-2015, AdaCore                    --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Ravenscar.Report;

package body Examples is
   use GNAT.Ravenscar;

   procedure Cyclic_OP1 is
   begin
      Report.Print ("Cyclic_OP1");
   end Cyclic_OP1;

   procedure Sporadic_OP1 is
   begin
      Report.Print ("Sporadic_OP1");
   end Sporadic_OP1;

   procedure Sporadic_OP2 (Par : Param_T) is
   begin
      Report.Print ("Sporadic_OP2 I = " & Natural'Image (Par.I) &
                      ", B = " & Boolean'Image (Par.B));
   end Sporadic_OP2;

   procedure Sporadic_OP3 (In_Param : Param_T; Out_Param : out Out_Param_T) is
   begin
      Report.Print ("Sporadic_OP3 I = " & Natural'Image (In_Param.I) &
                      ", B = " & Boolean'Image (In_Param.B));
      Out_Param.I := In_Param.I + 1;
   end Sporadic_OP3;

   procedure Sporadic_OP3_Callback (Par : Out_Param_T) is
   begin
      Report.Print ("Sporadic_OP3_Callback I = " & Natural'Image (Par.I));
   end Sporadic_OP3_Callback;

   procedure Req1 is
   begin
      Report.Print ("Req1");
   end Req1;

   procedure Req2 (I : Integer) is
   begin
      Report.Print ("Req2 with I = " & Natural'Image (I));
   end Req2;

   procedure Req3 (I : Integer; B : Boolean) is
   begin
      Report.Print ("Req3 with I = " & Natural'Image (I) &
                   " and B = " & Boolean'Image (B));
   end Req3;

   procedure Dispatch (Req : Complex_Request_T) is
   begin
      Report.Print ("Dispatch");
      case Req.Request_Kind is
         when REQ1 =>
            Req1;
         when REQ2 =>
            Req2 (Req.REQ2_I);
         when REQ3 =>
            Req3 (Req.REQ3_I, Req.REQ3_B);
      end case;
   end Dispatch;

   procedure Timed_Out_Sporadic_OP (Par : Param_T) is
   begin
      Report.Print ("Timed_Out_Sporadic_OP I = " & Natural'Image (Par.I) &
                   ", B = " & Boolean'Image (Par.B));
   end Timed_Out_Sporadic_OP;

   procedure Time_Out_Action is
   begin
      Report.Print ("Timed_Out_Sporadic_OP was NOT called in time!");
   end Time_Out_Action;

   procedure Cyclic_Dispatch (Req : Complex_Request_T) is
   begin
      Report.Print ("Cyclic_Dispatch");
      case Req.Request_Kind is
         when REQ1 =>
            Req1;
         when REQ2 =>
            Req2 (Req.REQ2_I);
         when REQ3 =>
            Req3 (Req.REQ3_I, Req.REQ3_B);
      end case;
   end Cyclic_Dispatch;

   procedure Cyclic_OP2 is
   begin
      Report.Print ("Cyclic_OP2");
   end Cyclic_OP2;

begin
   Report.Init (Ada.Real_Time.Clock);

end Examples;
