! /*
! 
! Copyright (C) 2008-2018 Michele Martone
! 
! This file is part of librsb.
! 
! librsb is free software; you can redistribute it and/or modify it
! under the terms of the GNU Lesser General Public License as published
! by the Free Software Foundation; either version 3 of the License, or
! (at your option) any later version.
! 
! librsb is distributed in the hope that it will be useful, but WITHOUT
! ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
! FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
! License for more details.
! 
! You should have received a copy of the GNU Lesser General Public
! License along with librsb; see the file COPYING.
! If not, see <http://www.gnu.org/licenses/>.
! 
! */
!
!> @cond INNERDOC
!> @file
!> @author Michele Martone 
!> @brief This file is part of the Octave based test suite for librsb
!
! Sparse BLAS fortran interface testing code
!
! FIXME: missing library initialization!
! FIXME: using zero based indices is only partially supprted!
!
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 2
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/12, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 1
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/9, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 2/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/6, 9/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 1
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 3/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 12, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 3
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 1/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 3/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 12, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 3
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 1/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 3/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/15, 3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 4
! 6 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*4 :: VA(4)=&
          &(/1, 4, 6, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/24, 18/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 1
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/12, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 3
! 0 3

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 3/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/15, 0, 12, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 3
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 2/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/12, 0, 12, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 2/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/4, 3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 2
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/4, 7/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/4, 4/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 3

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 3/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/5, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/4, 0, 5, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*4 :: VA(2)=(/1, 2/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/4, 5/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 3
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*4 :: VA(4)=&
          &(/1, 3, 2, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/6, 7/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 2
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*4 :: VA(4)=&
          &(/1, 2, 2, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/4, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 1
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/5, 0, 4, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 1
! 3 3

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*4 :: VA(4)=&
          &(/1, 1, 3, 3/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/7, 0, 7, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 3

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 3/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/2, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/2, 3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 3
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 2/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/2, -2/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/2, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 1
! 1 3

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*4 :: VA(4)=&
          &(/1, 1, 1, 3/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, -1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 1
! 2 4

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*4 :: VA(4)=&
          &(/1, 1, 2, 4/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, -2, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/2, 3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 3
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/1, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/2, 3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 3
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 2/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 1
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 3/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-1, 0, 2, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, 2, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 2
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/-6, -3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 3

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 3/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/0, -6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/0, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 2
! 1 2

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*4 :: VA(4)=&
          &(/1, 2, 1, 2/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-6, 0, -6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 5
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 1/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 5/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, -12, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, -3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*4 :: VA(2)=(/1, 2/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/0, -3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 1
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/-3, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 2/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/0, -3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 3
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 1/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 3/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-9, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 1
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 1/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 2
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 1/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 2/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, -3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 4
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: VA(3)=&
          &(/1, 4, 3/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/15, 15/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/6, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 6, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 2
! 2 3

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 2, 2, 3/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/12, 0, 18, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 3
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 1/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 3/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/15, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 2/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/12, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/9, 6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/6, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 2 3

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 3/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/12, 0, 12, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/4, 5/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 1
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/5, 4/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/4, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 3
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 3, 3, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/7, 0, 7, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 1
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 1/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/4, 0, 5, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 1
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/5, 5/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 3/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/7, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/4, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 3

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 3/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/4, 0, 6, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 3
! 2 4

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 3, 2, 4/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/6, 0, 10, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 1
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 1/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/2, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 6
! 0 3

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 6, 3/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/2, -6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/2, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 1
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 3/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 0, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 2
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 1
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 1/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/2, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 3/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/-1, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/2, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/2, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 4 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 4/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-2, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 1
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/2, 0, 0, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 3

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 3/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/0, -6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/0, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/0, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 2 2

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/0, 0, -9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 6
! 5 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: VA(3)=&
          &(/1, 6, 5/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-15, 0, -15, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 3/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-9, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 2/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/0, -3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/0, 0/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 2/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/-6, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-3, 0, 0, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 2
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 2, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-3, 0, -6, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 0+0i
! 0+0i 2+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/(1.e0,2.e0), (2,2)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(6.e0,6.e0), (9,6)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 0+2i
! 0+2i 2+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (2,2)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(6.e0,12.e0), (9,12)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 0+2i
! 0+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0,2)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(6.e0,-12.e0), (3,-6)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 0+3i
! 2+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (2.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(6.e0,15.e0), (0.e0,0.e0), (12.e0,9.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 0+0i
! 1+0i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (1,4)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(9.e0,6.e0), (0.e0,0.e0), (6.e0,12.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 0+0i
! 0+0i 0+6i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/(1.e0,2.e0), (0,6)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(6.e0,-6.e0), (0.e0,0.e0), (3.e0,-18.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 0+2i
! 0+2i 3+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (3,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(6.e0,12.e0), (12,6)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 1+8i
! 1+8i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,8.e0), (1.e0,8.e0), (0,2)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(9.e0,30.e0), (6,30)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 0+0i
! 2+0i 6+12i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (6,12)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(12.e0,-6.e0), (21,-36)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 0+0i
! 2+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 1/)
      COMPLEX*8 :: VA(2)=(/(1.e0,2.e0), (2,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(6.e0,6.e0), (0.e0,0.e0), (9.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 0+4i
! 0+4i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,4.e0), (0.e0,4.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(6.e0,18.e0), (0.e0,0.e0), (6.e0,12.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1+2i 2+2i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,2.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(6.e0,-12.e0), (0.e0,0.e0), (12.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 0+0i
! 3+0i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (3.e0,0.e0), (0,2)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(4.e0,2.e0), (6,2)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 0+0i
! 0+0i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/(1.e0,2.e0), (1,4)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(4.e0,2.e0), (4,4)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 2+5i
! 1+5i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,5.e0), (1,5)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(5.e0,-7.e0), (5,-5)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 2+0i
! 4+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (4.e0,0.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(6.e0,2.e0), (0.e0,0.e0), (8.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 1+1i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,1.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(4.e0,3.e0), (0.e0,0.e0), (5.e0,1.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 0+1i
! 2+1i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (2.e0,1.e0), (1,4)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(6.e0,-3.e0), (0.e0,0.e0), (4.e0,-5.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 0+2i
! 0+2i 2+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (2,2)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(4.e0,4.e0), (5,4)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 1+1i
! 0+1i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,1.e0), (0,1)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(4.e0,3.e0), (4,1)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 3+0i
! 2+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (3.e0,0.e0), (2,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(6.e0,-2.e0), (6,0)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 1+4i
! 0+4i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,4.e0), (0,4)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(5.e0,6.e0), (0.e0,0.e0), (3.e0,4.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 1+3i
! 0+3i 0+8i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,3.e0), (0.e0,3.e0), (0,8)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(4.e0,5.e0), (0.e0,0.e0), (4.e0,11.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1+2i 2+0i
! 3+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (3,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(7.e0,-2.e0), (0.e0,0.e0), (5.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 1+0i
! 4+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (4,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(1.e0,-2.e0), (-1,0)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 0+1i
! 1+1i 3+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (1.e0,1.e0), (3,4)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(1.e0,-3.e0), (0,-5)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 0+0i
! 1+0i 1+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (1,2)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(1.e0,2.e0), (2,2)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 0+2i
! 0+2i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (0,4)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(2.e0,-4.e0), (0.e0,0.e0), (3.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 3+3i
! 1+3i 4+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,3.e0), (1.e0,3.e0), (4,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(1.e0,-5.e0), (0.e0,0.e0), (-4.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 2+5i
! 3+5i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,5.e0), (3,5)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(-1.e0,7.e0), (0.e0,0.e0), (1.e0,5.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 1+0i
! 0+0i 0+12i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (0,12)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(1.e0,-2.e0), (3,-12)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 0+1i
! 0+1i 2+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (0.e0,1.e0), (2,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(2.e0,-3.e0), (1,-1)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 0+3i
! 0+3i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (0,3)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(2.e0,5.e0), (3,3)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 1+0i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(1.e0,-2.e0), (0.e0,0.e0), (2.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 1+3i
! 1+3i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,3.e0), (1,3)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(1.e0,-5.e0), (0.e0,0.e0), (2.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+2i 3+2i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,2.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(2.e0,4.e0), (0.e0,0.e0), (-1.e0,2.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 1+5i
! 1+5i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,5.e0), (1,5)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(-3.e0,-21.e0), (0,-15)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 3+2i
! 0+2i 0+6i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,2.e0), (0.e0,2.e0), (0,6)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(0.e0,-12.e0), (-6,-24)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 0+1i
! 1+1i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (1.e0,1.e0), (1,4)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(-3.e0,9.e0), (0,15)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 1+1i
! 1+1i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,1.e0), (1,1)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(-3.e0,-9.e0), (0.e0,0.e0), (0.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 0+1i
! 0+1i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (0.e0,1.e0), (0,2)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,-9.e0), (0.e0,0.e0), (3.e0,-9.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 0+2i
! 0+2i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (0,2)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,12.e0), (0.e0,0.e0), (3.e0,12.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 0+3i
! 5+3i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (5.e0,3.e0), (0,2)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(0.e0,-15.e0), (-12,-15)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 1+4i
! 0+4i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,4.e0), (0,4)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(0.e0,-18.e0), (0,-12)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 0+1i
! 0+1i 2+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (0.e0,1.e0), (2,4)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(0.e0,9.e0), (-3,15)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 3+0i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (3.e0,0.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(-9.e0,-6.e0), (0.e0,0.e0), (0.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 0+0i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/(1.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,-6.e0), (0.e0,0.e0), (0.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1+2i 0+3i
! 0+3i 1+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (0.e0,3.e0), (1,2)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,15.e0), (0.e0,0.e0), (0.e0,15.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 0+2i
! 3+2i 2+6i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (3.e0,2.e0), (2,6)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,12.e0), (18,24)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 0+1i
! 1+1i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (1,1)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(9.e0,9.e0), (3,3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 3+3i
! 0+3i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (3.e0,3.e0), (0,3)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,-15.e0), (12,-9)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 0+1i
! 3+1i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (3,1)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(6.e0,9.e0), (0.e0,0.e0), (12.e0,3.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 0+5i
! 1+5i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,5.e0), (1.e0,5.e0), (0,2)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(9.e0,21.e0), (0.e0,0.e0), (3.e0,21.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 0+2i
! 0+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0,2)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(6.e0,-12.e0), (0.e0,0.e0), (3.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 0+4i
! 3+4i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,4.e0), (3.e0,4.e0), (0,2)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,18.e0), (12,18)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 0+1i
! 0+1i 3+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (0.e0,1.e0), (3,2)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,9.e0), (12,9)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 0+2i
! 0+2i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (1,4)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,-12.e0), (6,-18)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 0+1i
! 3+1i 1+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (3.e0,1.e0), (1,2)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(6.e0,9.e0), (0.e0,0.e0), (15.e0,9.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 0+0i
! 2+0i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (0,2)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(12.e0,6.e0), (0.e0,0.e0), (3.e0,6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1+2i 2+1i
! 2+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,1.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(12.e0,-9.e0), (0.e0,0.e0), (12.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 0+2i
! 0+2i 1+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (1,2)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(4.e0,4.e0), (4,4)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 1+0i
! 0+0i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (1,4)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(4.e0,2.e0), (5,4)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 0+0i
! 2+0i 1+6i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (1,6)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,-2.e0), (4,-6)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 0+2i
! 0+2i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (0,4)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(4.e0,4.e0), (0.e0,0.e0), (3.e0,6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 2+4i
! 0+4i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,4.e0), (0.e0,4.e0), (0,4)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(4.e0,6.e0), (0.e0,0.e0), (5.e0,8.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 0+4i
! 3+4i 2+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,4.e0), (3.e0,4.e0), (2,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(7.e0,-6.e0), (0.e0,0.e0), (5.e0,-4.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 1+0i
! 0+0i 0+6i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (0,6)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(5.e0,2.e0), (3,6)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 0+2i
! 0+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0,2)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(4.e0,4.e0), (3,2)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 0+2i
! 1+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (1,2)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(5.e0,-4.e0), (3,-2)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 0+3i
! 0+3i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (0.e0,3.e0), (0,4)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(4.e0,5.e0), (0.e0,0.e0), (3.e0,7.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 0+2i
! 2+2i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (2.e0,2.e0), (0,4)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(6.e0,4.e0), (0.e0,0.e0), (3.e0,6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1+2i 0+2i
! 0+2i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (1,4)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(4.e0,-4.e0), (0.e0,0.e0), (4.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 3+2i
! 3+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (3.e0,2.e0), (3,2)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-1.e0,-4.e0), (0,-2)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 0+3i
! 0+3i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (0,3)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(2.e0,-5.e0), (3,-3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 0+0i
! 0+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      COMPLEX*16 :: VA(1)=(/(1,2)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(2.e0,2.e0), (3,0)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 0+1i
! 0+1i 3+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (0.e0,1.e0), (3,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,-3.e0), (0.e0,0.e0), (0.e0,-1.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 1+0i
! 0+0i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (0,2)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,-2.e0), (0.e0,0.e0), (2.e0,-2.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 2+5i
! 1+5i 1+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,5.e0), (1.e0,5.e0), (1,2)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(1.e0,7.e0), (0.e0,0.e0), (0.e0,7.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 0+1i
! 0+1i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (0,1)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(2.e0,-3.e0), (3,-1)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 1+3i
! 1+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,3.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(1.e0,-5.e0), (1,-3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 3+5i
! 0+5i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,5.e0), (0.e0,5.e0), (1,4)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(2.e0,7.e0), (-1,9)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 3+1i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,1.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(-1.e0,-3.e0), (0.e0,0.e0), (2.e0,-1.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 0+3i
! 0+3i 2+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (0.e0,3.e0), (2,2)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,-5.e0), (0.e0,0.e0), (1.e0,-5.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+2i 1+3i
! 0+3i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,3.e0), (0,3)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,5.e0), (0.e0,0.e0), (2.e0,3.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 0+0i
! 0+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=1
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(1)=(/1/)
      INTEGER :: JA(1)=(/1/)
      COMPLEX*16 :: VA(1)=(/(1,2)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(0.e0,-6.e0), (3,0)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 3+0i
! 2+0i 3+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,0.e0), (2.e0,0.e0), (3,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-6.e0,-6.e0), (-15,0)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 0+3i
! 1+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-3.e0,15.e0), (0,9)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 2+2i
! 0+2i 0+6i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,2.e0), (0.e0,2.e0), (0,6)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(-6.e0,-12.e0), (0.e0,0.e0), (3.e0,-24.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 0+5i
! 0+5i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,5.e0), (0,5)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(0.e0,-21.e0), (0.e0,0.e0), (3.e0,-15.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 0+6i
! 4+6i 3+6i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,6.e0), (4.e0,6.e0), (3,6)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(-12.e0,24.e0), (0.e0,0.e0), (-6.e0,36.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 3+1i
! 0+1i 0+6i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,1.e0), (0.e0,1.e0), (0,6)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-9.e0,-9.e0), (3,-21)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 1+2i
! 1+2i 1+10i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,2.e0), (1.e0,2.e0), (1,10)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-3.e0,-12.e0), (-3,-36)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 0+1i
! 1+1i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (1,1)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-3.e0,9.e0), (3,3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 2+0i
! 1+0i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=4
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (1.e0,0.e0), (0,2)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(-6.e0,-6.e0), (0.e0,0.e0), (0.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 4+0i
! 0+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 1/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/(1.e0,2.e0), (4,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(0.e0,-6.e0), (0.e0,0.e0), (-9.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+2i 2+5i
! 0+5i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,5.e0), (0,5)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(0.e0,21.e0), (0.e0,0.e0), (-3.e0,15.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=3
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/6, 3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=3
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/3, 9/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/3, 3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/2, 1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*4 :: alpha=1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 2, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/-1, -1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=-1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/-1, -2/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/-1, -1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=-3
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2)=(/-12, -3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=-3
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/-3, -9/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/-3, -3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=-3
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/-12, 0, -3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/3, 3/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/3, 3/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/3, 3/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=3
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/6, 0, 3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=1
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2)=(/3, 1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/1, 2/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 2, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/-1, -1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=-1
! A =
! 1 4
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 4, 1/)
      REAL*8 :: x(2)=(/-1, -5/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*8 :: alpha=-1
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2)=(/-1, -3/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*8 :: alpha=-1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/-1, 0, -2, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/-3, -3/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=-3
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(2)=(/-3, -12/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*8 :: alpha=-3
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/-3, -6/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=-3
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(4)=&
          &(/-9, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*8 :: alpha=-3
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(4)=&
          &(/-3, 0, -9, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/3, 3/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=3
! A =
! 1+0i 0+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(3.e0,0.e0), (3,9)/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=3
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(3.e0,0.e0), (3,-3)/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=3
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*8 :: x(4)=&
          &(/12, 0, 3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=3
! A =
! 1+0i 3+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(3.e0,0.e0), (0.e0,0.e0), (12.e0,3.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 0+2i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(1.e0,0.e0), (1,2)/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 1+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(1.e0,0.e0), (0.e0,0.e0), (2.e0,3.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(1.e0,0.e0), (0.e0,0.e0), (1.e0,-1.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(2)=(/-2, -1/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(2)=(/-1, -2/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 1+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(-1.e0,0.e0), (-2,3)/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 2+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(-3.e0,-1.e0), (0.e0,0.e0), (-1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+2i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(-1.e0,0.e0), (0.e0,0.e0), (-1.e0,-2.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-1, 0, -2, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 3+5i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,5.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(-12.e0,-15.e0), (-3,0)/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/-3, -3/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-3
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*8 :: x(2)=(/-3, -12/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-3
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-6, 0, -3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-3
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-3, 0, -9, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 1+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(6.e0,9.e0), (3,0)/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(3.e0,0.e0), (3,9)/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(3.e0,0.e0), (3,-9)/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=1
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: x(2)=(/3, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(2)=(/1, 2/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(1.e0,0.e0), (1,-1)/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 2+4i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,4.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(3.e0,4.e0), (0.e0,0.e0), (1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+4i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,4.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(1.e0,0.e0), (0.e0,0.e0), (1.e0,4.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(1.e0,0.e0), (0.e0,0.e0), (1.e0,-1.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(2)=(/-2, -1/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(-1.e0,0.e0), (-1,-1)/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 3+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(-1.e0,0.e0), (-4,1)/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-1
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-2, 0, -1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+2i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(-1.e0,0.e0), (0.e0,0.e0), (-1.e0,-2.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+6i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,6.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(-1.e0,0.e0), (0.e0,0.e0), (-1.e0,6.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 0+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(-3.e0,-9.e0), (-3,0)/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/-3, -3/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/-3, -3/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-3
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-6, 0, -3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 3+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(-3.e0,0.e0), (0.e0,0.e0), (-12.e0,-3.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-3
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-3, 0, -6, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2)=(/3, 12/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/6, 3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/9, 3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/6, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 2/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/2, 1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/4, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/-1, -1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2)=(/-4, -1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/-1, -1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/-1, 0, -2, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/-2, 0, -1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/-3, -6/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/-9, -3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/-9, -3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/-12, 0, -3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2)=(/3, 9/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/3, 3/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2)=(/9, 3/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(4)=&
          &(/3, 0, 9, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2)=(/1, 3/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/2, 1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2)=(/3, 1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 6 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 6, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 7, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(4)=&
          &(/3, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/-1, -2/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/-1, -1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/-2, -1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/-2, 0, -1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/-3, -3/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/-6, -3/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 6 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 6, 1/)
      REAL*8 :: x(2)=(/-21, -3/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(4)=&
          &(/-12, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: x(2)=(/3, 9/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 4, 1/)
      COMPLEX*8 :: x(2)=(/15, 3/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(2)=(/6, 3/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(1.e0,0.e0), (1,1)/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(1.e0,-1.e0), (1,0)/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 2, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/-1, -1/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(-1.e0,-2.e0), (-1,0)/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(-1.e0,1.e0), (-1,0)/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(-1.e0,0.e0), (0.e0,0.e0), (-1.e0,-3.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-2, 0, -1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-2, 0, -1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(-3.e0,0.e0), (-3,-3)/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(-3.e0,-9.e0), (-3,0)/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/-3, -3/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-12, 0, -3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 1+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(3.e0,0.e0), (6,6)/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: x(2)=(/9, 3/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/3, 3/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(3.e0,0.e0), (0.e0,0.e0), (3.e0,9.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(3.e0,3.e0), (0.e0,0.e0), (3.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*16 :: x(2)=(/1, 4/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(1.e0,2.e0), (1,0)/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 3+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(4.e0,-3.e0), (1,0)/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(1.e0,0.e0), (0.e0,0.e0), (1.e0,3.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 1+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(2.e0,-1.e0), (0.e0,0.e0), (1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(2)=(/-1, -2/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 1+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(-2.e0,-2.e0), (-1,0)/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 2+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(-3.e0,1.e0), (-1,0)/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(-1.e0,3.e0), (0.e0,0.e0), (-1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*16 :: x(2)=(/-3, -12/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/-3, -3/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      COMPLEX*16 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/-3, -3/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-3
! A =
! 1 0
! 6 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 6, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-21, 0, -3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      COMPLEX*16 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-6, 0, -3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/12, 12/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/12, 0, 12, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/15, 15/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/15, 15/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/5, 5/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/4, 4/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/5, 5/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/5, 5/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/5, 0, 5, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/7, 0, 7, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/2, 2/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/0, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/2, 2/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/2, 2/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/2, 2/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/2, 2/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 5 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 5, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-3, 0, -3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/-6, -6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/-6, -6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/-3, -3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-6, 0, -6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-3, 0, -3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/-3, -3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/0, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/0, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-3, 0, -3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_ss_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 5 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 5, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-15, 0, -15, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/12, 0, 12, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/12, 0, 12, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/15, 0, 15, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/4, 4/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/4, 4/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/4, 4/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/7, 0, 7, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 4, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/8, 0, 8, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/7, 0, 7, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/4, 4/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/5, 5/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/4, 4/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/7, 0, 7, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/2, 2/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 4, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/-2, -2/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 4, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/-2, -2/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/-1, -1/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-1, 0, -1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/-3, -3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/-9, -9/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/-3, -3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-3, 0, -3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/-9, -9/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/-3, -3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/0, 0/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE td_ss_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 4, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-12, 0, -12, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-3, 0, -3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_ss_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*8 :: alpha=-3
! A =
! 1 0
! 6 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 6, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-18, 0, -18, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_ss_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1+0i 0+0i
! 0+5i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,5.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(6.e0,15.e0), (6,15)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/15, 15/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/15, 0, 15, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1+0i 0+0i
! 1+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(9.e0,-3.e0), (0.e0,0.e0), (9.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(6.e0,3.e0), (6,3)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1+0i 0+0i
! 2+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(12.e0,3.e0), (12,3)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=3
! A =
! 1+0i 0+0i
! 1+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(9.e0,-9.e0), (9,-9)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1+0i 0+0i
! 1+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(9.e0,3.e0), (0.e0,0.e0), (9.e0,3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(6.e0,9.e0), (0.e0,0.e0), (6.e0,9.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 0+0i
! 4+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (4.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(8.e0,1.e0), (8,1)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/4, 4/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(4.e0,-2.e0), (4,-2)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 0+0i
! 1+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(5.e0,-2.e0), (0.e0,0.e0), (5.e0,-2.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(4.e0,1.e0), (4,1)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 0+0i
! 1+4i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,4.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(5.e0,4.e0), (5,4)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(4.e0,-3.e0), (4,-3)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/5, 0, 5, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1+0i 0+0i
! 1+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(5.e0,3.e0), (0.e0,0.e0), (5.e0,3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(2.e0,-3.e0), (2,-3)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 1+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(1.e0,-3.e0), (1,-3)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/2, 2/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(2.e0,-3.e0), (0.e0,0.e0), (2.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(2.e0,2.e0), (0.e0,0.e0), (2.e0,2.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+6i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,6.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(2.e0,-6.e0), (2,-6)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/2, 2/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 3+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(-1.e0,2.e0), (-1,2)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+5i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,5.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(2.e0,-5.e0), (0.e0,0.e0), (2.e0,-5.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(2.e0,-3.e0), (0.e0,0.e0), (2.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(2.e0,3.e0), (0.e0,0.e0), (2.e0,3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/-6, -6/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(0.e0,-6.e0), (0,-6)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 2+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(-6.e0,3.e0), (-6,3)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,-9.e0), (0.e0,0.e0), (0.e0,-9.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/-3, 0, -3, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 2+5i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,5.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(-6.e0,15.e0), (0.e0,0.e0), (-6.e0,15.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 0+5i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,5.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(0.e0,-15.e0), (0,-15)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(0.e0,-3.e0), (0,-3)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 3+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(-9.e0,6.e0), (-9,6)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_ss_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,-9.e0), (0.e0,0.e0), (0.e0,-9.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 4+5i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (4.e0,5.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(-12.e0,-15.e0), (0.e0,0.e0), (-12.e0,-15.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_ss_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*8 :: alpha=-3
! A =
! 1+0i 0+0i
! 1+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(-3.e0,3.e0), (0.e0,0.e0), (-3.e0,3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=c dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_ss_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/12, 12/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 2+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(12.e0,6.e0), (12,6)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 2+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(12.e0,-3.e0), (12,-3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(6.e0,3.e0), (0.e0,0.e0), (6.e0,3.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(6.e0,-9.e0), (0.e0,0.e0), (6.e0,-9.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 4+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (4.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(18.e0,6.e0), (18,6)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 1+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(9.e0,3.e0), (9,3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 1+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(9.e0,-3.e0), (9,-3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(6.e0,9.e0), (0.e0,0.e0), (6.e0,9.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/15, 0, 15, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=3
! A =
! 1+0i 0+0i
! 4+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (4.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(18.e0,-6.e0), (0.e0,0.e0), (18.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(4.e0,3.e0), (4,3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 1+5i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,5.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(5.e0,5.e0), (5,5)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(4.e0,-3.e0), (4,-3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(4.e0,2.e0), (0.e0,0.e0), (4.e0,2.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/5, 0, 5, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(4.e0,2.e0), (4,2)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(4.e0,1.e0), (4,1)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(4.e0,-2.e0), (4,-2)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 3+4i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,4.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(7.e0,4.e0), (0.e0,0.e0), (7.e0,4.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=1
! A =
! 1+0i 0+0i
! 0+6i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,6.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(4.e0,-6.e0), (0.e0,0.e0), (4.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+5i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,5.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(2.e0,-5.e0), (2,-5)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 2+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(0.e0,-1.e0), (0,-1)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/2, 2/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,-2.e0), (0.e0,0.e0), (2.e0,-2.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 1+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(1.e0,-3.e0), (0.e0,0.e0), (1.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,1.e0), (0.e0,0.e0), (2.e0,1.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 1+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(1.e0,-1.e0), (1,-1)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(2.e0,-1.e0), (2,-1)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 2+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(0.e0,3.e0), (0,3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,-3.e0), (0.e0,0.e0), (2.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,-2.e0), (0.e0,0.e0), (2.e0,-2.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 0+0i
! 2+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-6.e0,-3.e0), (-6,-3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/-3, -3/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 0+0i
! 1+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-3.e0,9.e0), (-3,9)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(0.e0,-9.e0), (0.e0,0.e0), (0.e0,-9.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 0+0i
! 1+5i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,5.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(-3.e0,15.e0), (0.e0,0.e0), (-3.e0,15.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(0.e0,-6.e0), (0,-6)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 0+0i
! 6+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (6.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-18.e0,-3.e0), (-18,-3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(0.e0,6.e0), (0,6)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_ss_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(0.e0,-3.e0), (0.e0,0.e0), (0.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 0+0i
! 3+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(-9.e0,-6.e0), (0.e0,0.e0), (-9.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_ss_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      COMPLEX*16 :: alpha=-3
! A =
! 1+0i 0+0i
! 1+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(-3.e0,3.e0), (0.e0,0.e0), (-3.e0,3.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=z dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_ss_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/12, 12/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/15, 15/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 5 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 5, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/21, 0, 21, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/15, 0, 15, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/4, 4/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/5, 5/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/4, 4/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/5, 0, 5, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/4, 4/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/5, 5/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/7, 7/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/7, 0, 7, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/5, 0, 5, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/-1, -1/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/2, 2/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/2, 2/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/2, 0, 2, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-1, 0, -1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/2, 2/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/2, 2/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-1
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/0, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-1
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 4, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-2, 0, -2, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/0, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/0, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/0, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-3, 0, -3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/-3, -3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/-3, -3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*4 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/-3, -3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sh_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-3, 0, -3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-3, 0, -3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sh_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=2
      INTEGER :: incy=2
      REAL*4 :: alpha=-3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=s dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sh_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sh_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/12, 12/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sh_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sh_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/15, 15/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sh_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sh_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sh_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sh_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sh_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sh_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sh_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sh_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER :: incx=1
      INTEGER :: incy=2
      REAL*8 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/15, 0, 15, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sh_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sh_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=3
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/15, 15/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok"
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok"
      GOTO 9998
9997      errval=-1
9998      CONTINUE
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sh_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sh_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER :: incx=2
      INTEGER :: incy=1
      REAL*8 :: alpha=3
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER :: nnz=2
      INTEGER :: nr=2
      INTEGER :: nc=2
      INTEGER :: IA(2)=(/1, 2/)
      INTEGER :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_hermitian,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,"type=d dims=2x2 sym=h diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not