/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  An SBML reaction between species in an SBML model.
 <p>
 * A <em>reaction</em> represents any transformation, transport or binding
 * process, typically a chemical reaction, that can change the quantity of
 * one or more species.  In SBML, a reaction is defined primarily in terms
 * of the participating reactants and products (and their corresponding
 * stoichiometries), along with optional modifier species, an optional rate
 * at which the reaction takes place, and optional parameters.
 <p>
 * As with other major objects in SBML, {@link Reaction} has a mandatory attribute,
 * 'id', used to give the compartment type an identifier.  The identifier
 * must be a text string conforming to the identifer syntax permitted in
 * SBML.  In SBML Level&nbsp;2 and Level&nbsp;3, the reaction 'id'
 * identifier can be used in mathematical formulas elsewhere in an SBML
 * model to represent the rate of that reaction; this usage is explained
 * below.  {@link Reaction} also has an optional 'name' attribute, of type 
 * <code>string.</code>  The 'id' and 'name' must be used according to the guidelines
 * described in the SBML specification.
 <p>
 * The species participating as reactants, products, and/or modifiers in a
 * reaction are declared using lists of {@link SpeciesReference} and/or
 * {@link ModifierSpeciesReference} instances stored in subelements
 * 'listOfReactants', 'listOfProducts' and 'listOfModifiers'.  Certain
 * restrictions are placed on the appearance of species in reaction
 * definitions:
 * <ul>
 * <li> The ability of a species to appear as a reactant or product of any
 * reaction in a model is governed by certain flags in that species'
 * definition; see the definition of {@link Species} for more information.
 <p>
 * <li> Any species appearing in the mathematical formula of the subelement
 * 'kineticLaw' (described below) of a {@link Reaction} must be declared in at
 * least one of that {@link Reaction}'s lists of reactants, products, and/or
 * modifiers.  Put another way, it is an error for a reaction's kinetic law
 * formula to refer to species that have not been declared for that
 * reaction.
 <p>
 * <li> For SBML Levels 1, 2, and SBML Level&nbsp;3 Version&nbsp;1, a 
 * reaction definition can contain an empty list of reactants
 * <em>or</em> an empty list of products, but it must have at least one
 * reactant or product; in other words, a reaction without any reactant or
 * product species is not permitted.  (This restriction does not apply to
 * modifier species, which remain optional in all cases.)  In SBML 
 * Level&nbsp;3 Version&nbsp;2, this requirement was dropped, allowing 
 * the creation of reactions with neither reactants nor products.
 * </ul>
 <p>
 * A reaction can contain up to one {@link KineticLaw} object in a subelement named
 * 'kineticLaw'.  It defines the speed at which the process defined by the
 * reaction takes place.  The description of {@link KineticLaw} provides more
 * details about its use.  Note that although the inclusion of a {@link KineticLaw}
 * object in an instance of a {@link Reaction} component is optional, there is no
 * useful default that can be substituted in place of a missing rate
 * expression in a reaction.  Moreover, a reaction's rate cannot be defined
 * in any other way in SBML&mdash;{@link InitialAssignment}, {@link AssignmentRule},
 * {@link RateRule}, {@link AlgebraicRule}, {@link Event}, and other constructs in SBML cannot be
 * used to set the reaction rate separately.  Nevertheless, for some
 * modeling applications, reactions without any defined rate can be
 * perfectly acceptable.
 <p>
 * {@link Reaction} also has a boolean attribute named 'reversible' for indicating
 * whether the reaction is reversible.  This attribute is optional in SBML
 * Level&nbsp;2, with a default of <code>true</code>; it is mandatory in SBML
 * Level&nbsp;3 (with no default value).  To say that a reaction is 
 * <em>reversible</em> is to say it can proceed in either the forward or the reverse
 * direction.  Although the reversibility of a reaction can sometimes be
 * deduced by inspecting its rate expression, this is not always the case,
 * especially for complicated expressions.  Moreover, the need in SBML to
 * allow rate expressions (i.e., {@link KineticLaw}) to be optional leads to the
 * need for a separate flag indicating reversibility.  Note that labeling a
 * reaction as irreversible is an assertion that the reaction always
 * proceeds in the given forward direction.  (Why else would it be flagged
 * as irreversible?)  This implies the rate expression in the {@link KineticLaw}
 * always has a non-negative value during simulations.  Software tools
 * could provide a means of optionally testing that this condition holds.
 * The presence of reversibility information in two places (i.e., the rate
 * expression and the 'reversible' attribute on {@link Reaction}) leaves open the
 * possibility that a model could contain contradictory information, but
 * the creation of such a model would be an error on the part of the
 * software generating it.
 <p>
 * The {@link Reaction} object class has another boolean attribute called 'fast'.
 * This attribute is optional in SBML Level&nbsp;2, with a default of 
 * <code>false</code>; it is mandatory in SBML Level&nbsp;3 (with no default value).  
 * In SBML Level&nbsp;3 Version&nbsp;2, a value of <code>true</code> for the 'fast'
 * attribute is deprecated in favor of all reactions having a 'fast' value 
 * of <code>false.</code>  It
 * is used to indicate that a reaction occurs on a vastly faster time scale
 * than others in a system.  Readers are directed to the SBML Level&nbsp;2
 * Version&nbsp;4 specification, which provides more detail about the
 * conditions under which a reaction can be considered to be fast in this
 * sense.  SBML Level&nbsp;1
 * and Level&nbsp;2 Version&nbsp;1 incorrectly claimed that software tools
 * could ignore this attribute if they did not implement support for the
 * corresponding concept; however, further research in SBML has revealed
 * that this is not true, and 'fast' <em>cannot be ignored</em> if it is
 * set to <code>true.</code>  SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 therefore
 * stipulate that if a model has any reactions with 'fast' set to <code>true</code>,
 * a software tool must be able to respect the attribute or else indicate
 * to the user that it does not have the capacity to do so.  Analysis
 * software cannot ignore the value of the 'fast' attribute because doing
 * so may lead to different results as compared to a software system that
 * <em>does</em> make use of 'fast'.
 <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, values of <code>true</code>
 * for the 'fast' attribute were deprecated, and in future
 * versions of the specification, the attribute itself will
 * be removed.  Users should be aware that even for previous
 * levels/versions of the specification, the 'fast' attribute
 * has never achieved widespread support, and many software
 * packages may ignore it.  To achieve the same or similar 
 * effects as setting the fast attribute to 'true' for a given 
 * reaction, the {@link KineticLaw} attribute should be constructed to 
 * produce a value in the desired time scale, or else the 
 * reaction could be replaced with an {@link AssignmentRule} or 
 * {@link AlgebraicRule}.
 <p>
 * In SBML Level&nbsp;3, the {@link Reaction} object has an
 * additional optional attribute named 'compartment', whose value must be
 * the identifier of a compartment defined in the enclosing {@link Model} object.
 * The 'compartment' attribute can be used to indicate the compartment in
 * which the reaction is assumed to take place.  If the attribute is
 * present, its value must be the identifier of a {@link Compartment} object
 * defined in the enclosing {@link Model} object.  Similar to the 'reversible'
 * attribute, the value of the 'compartment' attribute has no direct impact
 * on the construction of mathematical equations for the SBML model.  When
 * a kinetic law is given for a reaction, the compartment location may
 * already be implicit in the kinetic law (although this cannot always be
 * guaranteed).  Nevertheless, software tools may find the 'compartment'
 * attribute value useful for such purposes as analyzing the structure of
 * the model, guiding the modeler in constructing correct rate formulas,
 * and visualization purposes.
 <p>
 * Readers are urged to read the SBML specification for more details about
 * the proper use of {@link Reaction}.
 */

public class Reaction extends SBase {
   private long swigCPtr;

   protected Reaction(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.Reaction_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Reaction obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Reaction obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Reaction(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link Reaction} using the given SBML <code>level</code> and <code>version</code>
   * values.
   <p>
   * @param level a long integer, the SBML Level to assign to this {@link Reaction}.
   <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Reaction}.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>level</code> and <code>version</code> combination are invalid
 * or if this object is incompatible with the given level and version.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 Reaction(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Reaction__SWIG_0(level, version), true);
  }

  
/**
   * Creates a new {@link Reaction} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   <p>
   * <p>
 * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's {@link SBMLNamespaces} facilities is to create an
 * {@link SBMLNamespaces} object somewhere in a program once, then hand that object
 * as needed to object constructors that accept {@link SBMLNamespaces} as arguments.
   <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>sbmlns</code> is inconsistent or incompatible
 * with this object.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 Reaction(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Reaction__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link Reaction}.
   <p>
   * @param orig the object to copy.
   */ public
 Reaction(Reaction orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Reaction__SWIG_2(Reaction.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link Reaction} object.
   <p>
   * @return the (deep) copy of this {@link Reaction} object.
   */ public
 Reaction cloneObject() {
  return (Reaction) libsbml.DowncastSBase(libsbmlJNI.Reaction_cloneObject(swigCPtr, this), true);
}

  
/**
   * Returns the first child element found that has the given <code>id</code> in the
   * model-wide SId namespace, or <code>null</code> if no such object is found.
   <p>
   * @param id string representing the id of the object to find.
   <p>
   * @return pointer to the first element found with the given <code>id</code>.
   */ public
 SBase getElementBySId(String id) {
  return libsbml.DowncastSBase(libsbmlJNI.Reaction_getElementBySId(swigCPtr, this, id), false);
}

  
/**
   * Returns the first child element it can find with the given <code>metaid</code>, or
   * <code>null</code> if no such object is found.
   <p>
   * @param metaid string representing the metaid of the object to find.
   <p>
   * @return pointer to the first element found with the given <code>metaid</code>.
   */ public
 SBase getElementByMetaId(String metaid) {
  return libsbml.DowncastSBase(libsbmlJNI.Reaction_getElementByMetaId(swigCPtr, this, metaid), false);
}

  
/**
   * <p>
 * Replaces all uses of a given <code>SIdRef</code> type attribute value with another
 * value.
 <p>
 * <p>
 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 <p>
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of <code>oldid</code>.  If any matches are found, the
 * matching values are replaced with <code>newid</code>.  The method does <em>not</em>
 * descend into child elements.
 <p>
 * @param oldid the old identifier.
 * @param newid the new identifier.
   */ public
 void renameSIdRefs(String oldid, String newid) {
    libsbmlJNI.Reaction_renameSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/**
   * Initializes the fields of this {@link Reaction} object to 'typical' default
   * values.
   <p>
   * The SBML {@link Reaction} component has slightly different aspects and
   * default attribute values in different SBML Levels and Versions.
   * This method sets the values to certain common defaults, based
   * mostly on what they are in SBML Level&nbsp;2.  Specifically:
   <p>
   * <ul>
   * <li> Sets the 'reversible' attribute to <code>true</code>
   * <li> Sets the 'fast' attribute to <code>false</code>
   * <li> Marks the 'fast' attribute as <em>not</em> having been set
   *
   * </ul> <p>
   * <p>
 * @warning <span class='warning'>SBML definitions before SBML Level&nbsp;2
 * Version&nbsp;2 incorrectly indicated that software tools could ignore the
 * 'fast' attribute if they did not implement support for the corresponding
 * concept; however, further research in SBML has revealed that this is not
 * true, and 'fast' <em>cannot be ignored</em> if it is set to <code>true.</code>
 * Beginning with SBML Level&nbsp;2 Versions&nbsp;2, the SBML specifications
 * therefore stipulate that if a model has any reactions with 'fast' set to
 * <code>true</code>, a software tool must be able to respect the attribute or else
 * indicate to the user that it does not have the capacity to do so.  Readers
 * are directed to the SBML specifications, which provides more detail about
 * the conditions under which a reaction can be considered to be fast in this
 * sense.</span>
   */ public
 void initDefaults() {
    libsbmlJNI.Reaction_initDefaults(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'id' attribute of this {@link Reaction}.
   <p>
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   <p>
   * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 <p>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The exception to this rule is that for {@link InitialAssignment}, {@link EventAssignment}, 
 * {@link AssignmentRule}, and {@link RateRule} objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The {@link AlgebraicRule} fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return <code>false.</code>
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(String), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
   <p>
   * @return the id of this {@link Reaction}.
   <p>
   * @see #getIdAttribute()
   * @see #setIdAttribute(String sid)
   * @see #isSetIdAttribute()
   * @see #unsetIdAttribute()
   */ public
 String getId() {
    return libsbmlJNI.Reaction_getId(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'name' attribute of this {@link Reaction} object.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 <p>
 * @see #getIdAttribute()
 * @see #isSetName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 String getName() {
    return libsbmlJNI.Reaction_getName(swigCPtr, this);
  }

  
/**
   * Returns the {@link KineticLaw} object contained in this {@link Reaction}.
   <p>
   * @return the {@link KineticLaw} instance.
   */ public
 KineticLaw getKineticLaw() {
    long cPtr = libsbmlJNI.Reaction_getKineticLaw__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new KineticLaw(cPtr, false);
  }

  
/**
   * Returns the value of the 'reversible' attribute on the {@link Reaction} as a
   * boolean value.
   <p>
   * @return the reversibility status of this {@link Reaction}.
   */ public
 boolean getReversible() {
    return libsbmlJNI.Reaction_getReversible(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'fast' attribute of this {@link Reaction}.
   <p>
   * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, values of <code>true</code>
 * for the 'fast' attribute were deprecated, and in future
 * versions of the specification, the attribute itself will
 * be removed.  Users should be aware that even for previous
 * levels/versions of the specification, the 'fast' attribute
 * has never achieved widespread support, and many software
 * packages may ignore it.  To achieve the same or similar 
 * effects as setting the fast attribute to 'true' for a given 
 * reaction, the {@link KineticLaw} attribute should be constructed to 
 * produce a value in the desired time scale, or else the 
 * reaction could be replaced with an {@link AssignmentRule} or 
 * {@link AlgebraicRule}.
   <p>
   * @return the 'fast' status of this {@link Reaction}.
   <p>
   * <p>
 * @warning <span class='warning'>SBML definitions before SBML Level&nbsp;2
 * Version&nbsp;2 incorrectly indicated that software tools could ignore the
 * 'fast' attribute if they did not implement support for the corresponding
 * concept; however, further research in SBML has revealed that this is not
 * true, and 'fast' <em>cannot be ignored</em> if it is set to <code>true.</code>
 * Beginning with SBML Level&nbsp;2 Versions&nbsp;2, the SBML specifications
 * therefore stipulate that if a model has any reactions with 'fast' set to
 * <code>true</code>, a software tool must be able to respect the attribute or else
 * indicate to the user that it does not have the capacity to do so.  Readers
 * are directed to the SBML specifications, which provides more detail about
 * the conditions under which a reaction can be considered to be fast in this
 * sense.</span>
   */ public
 boolean getFast() {
    return libsbmlJNI.Reaction_getFast(swigCPtr, this);
  }

  
/**
   * (SBML Level&nbsp;3 only) Returns the value of the 'compartment'
   * attribute on the {@link Reaction}.
   <p>
   * @return the compartment of this {@link Reaction}.
   <p>
   * @note The 'compartment' attribute is available in SBML Level&nbsp;3,
   * but is not present on {@link Reaction} in lower Levels of
   * SBML.
   */ public
 String getCompartment() {
    return libsbmlJNI.Reaction_getCompartment(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Reaction}'s 'id' attribute is set.
   <p>
   * <p>
 * @note Because of the inconsistent behavior of this function with 
 * respect to assignments and rules, it is now recommended to
 * use the isSetIdAttribute() function instead.
 <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 <p>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The exception to this rule is that for {@link InitialAssignment}, {@link EventAssignment}, 
 * {@link AssignmentRule}, and {@link RateRule} objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The {@link AlgebraicRule} fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return <code>false.</code>
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(String), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 <p>
 * @return <code>true</code> if the 'id' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #unsetIdAttribute()
 * @see #isSetIdAttribute()
   */ public
 boolean isSetId() {
    return libsbmlJNI.Reaction_isSetId(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Reaction}'s 'name' attribute is set.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return <code>true</code> if the 'name' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 boolean isSetName() {
    return libsbmlJNI.Reaction_isSetName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Reaction} contains a kinetic law object.
   <p>
   * @return <code>true</code> if a {@link KineticLaw} is present in this {@link Reaction},, <code>false</code>
   * otherwise.
   */ public
 boolean isSetKineticLaw() {
    return libsbmlJNI.Reaction_isSetKineticLaw(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if the value of
   * the 'fast' attribute on this {@link Reaction} is set.
   <p>
   * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, values of <code>true</code>
 * for the 'fast' attribute were deprecated, and in future
 * versions of the specification, the attribute itself will
 * be removed.  Users should be aware that even for previous
 * levels/versions of the specification, the 'fast' attribute
 * has never achieved widespread support, and many software
 * packages may ignore it.  To achieve the same or similar 
 * effects as setting the fast attribute to 'true' for a given 
 * reaction, the {@link KineticLaw} attribute should be constructed to 
 * produce a value in the desired time scale, or else the 
 * reaction could be replaced with an {@link AssignmentRule} or 
 * {@link AlgebraicRule}.
   <p>
   * @return <code>true</code> if the 'fast' attribute is set, <code>false</code> otherwise.
   <p>
   * <p>
 * @warning <span class='warning'>SBML definitions before SBML Level&nbsp;2
 * Version&nbsp;2 incorrectly indicated that software tools could ignore the
 * 'fast' attribute if they did not implement support for the corresponding
 * concept; however, further research in SBML has revealed that this is not
 * true, and 'fast' <em>cannot be ignored</em> if it is set to <code>true.</code>
 * Beginning with SBML Level&nbsp;2 Versions&nbsp;2, the SBML specifications
 * therefore stipulate that if a model has any reactions with 'fast' set to
 * <code>true</code>, a software tool must be able to respect the attribute or else
 * indicate to the user that it does not have the capacity to do so.  Readers
 * are directed to the SBML specifications, which provides more detail about
 * the conditions under which a reaction can be considered to be fast in this
 * sense.</span>
   */ public
 boolean isSetFast() {
    return libsbmlJNI.Reaction_isSetFast(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Reaction}'s 'compartment' attribute is set.
   <p>
   * @return <code>true</code> if the 'compartment' attribute of this {@link Reaction} is
   * set, <code>false</code> otherwise.
   <p>
   * @note The 'compartment' attribute is available in SBML
   * Level&nbsp;3, but is not present on {@link Reaction} in
   * lower Levels of SBML.
   */ public
 boolean isSetCompartment() {
    return libsbmlJNI.Reaction_isSetCompartment(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Reaction}'s 'reversible' attribute is set.
   <p>
   * @return <code>true</code> if the 'reversible' attribute of this {@link Reaction} is
   * set, <code>false</code> otherwise.
   */ public
 boolean isSetReversible() {
    return libsbmlJNI.Reaction_isSetReversible(swigCPtr, this);
  }

  
/**
   * Sets the value of the 'id' attribute of this {@link Reaction}.
   <p>
   * <p>
 * The string <code>sid</code> is copied.
 <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 <p>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The exception to this rule is that for {@link InitialAssignment}, {@link EventAssignment}, 
 * {@link AssignmentRule}, and {@link RateRule} objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The {@link AlgebraicRule} fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return <code>false.</code>
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(String), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 <p>
 * @param sid the string to use as the identifier of this object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
 *
 * </ul> <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #isSetIdAttribute()
 * @see #unsetIdAttribute()
   */ public
 int setId(String sid) {
    return libsbmlJNI.Reaction_setId(swigCPtr, this, sid);
  }

  
/**
   * Sets the value of the 'name' attribute of this {@link Reaction}.
   <p>
   * <p>
 * The string in <code>name</code> is copied.
 <p>
 * @param name the new name for the SBML object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 *
 * </ul>
   */ public
 int setName(String name) {
    return libsbmlJNI.Reaction_setName(swigCPtr, this, name);
  }

  
/**
   * Sets the 'kineticLaw' subelement of this {@link Reaction} to a copy of the
   * given {@link KineticLaw} object.
   <p>
   * @param kl the {@link KineticLaw} object to use.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * </ul>
  */ public
 int setKineticLaw(KineticLaw kl) {
    return libsbmlJNI.Reaction_setKineticLaw(swigCPtr, this, KineticLaw.getCPtr(kl), kl);
  }

  
/**
   * Sets the value of the 'reversible' attribute of this {@link Reaction}.
   <p>
   * @param value the value of the 'reversible' attribute.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * </ul>
   */ public
 int setReversible(boolean value) {
    return libsbmlJNI.Reaction_setReversible(swigCPtr, this, value);
  }

  
/**
   * Sets the value of the 'fast' attribute of this {@link Reaction}.
   <p>
   * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, values of <code>true</code>
 * for the 'fast' attribute were deprecated, and in future
 * versions of the specification, the attribute itself will
 * be removed.  Users should be aware that even for previous
 * levels/versions of the specification, the 'fast' attribute
 * has never achieved widespread support, and many software
 * packages may ignore it.  To achieve the same or similar 
 * effects as setting the fast attribute to 'true' for a given 
 * reaction, the {@link KineticLaw} attribute should be constructed to 
 * produce a value in the desired time scale, or else the 
 * reaction could be replaced with an {@link AssignmentRule} or 
 * {@link AlgebraicRule}.
   <p>
   * Calling this function with an argument of <code>true</code> for an
   * SBML Level&nbsp;3 Version&nbsp;2 {@link Reaction} will set 
   * the value, but will result in a return value of 
   * {@link libsbmlConstants#LIBSBML_DEPRECATED_ATTRIBUTE LIBSBML_DEPRECATED_ATTRIBUTE}.
   <p>
   * @param value the value of the 'fast' attribute.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_DEPRECATED_ATTRIBUTE LIBSBML_DEPRECATED_ATTRIBUTE}
   *
   * </ul> <p>
   * <p>
 * @warning <span class='warning'>SBML definitions before SBML Level&nbsp;2
 * Version&nbsp;2 incorrectly indicated that software tools could ignore the
 * 'fast' attribute if they did not implement support for the corresponding
 * concept; however, further research in SBML has revealed that this is not
 * true, and 'fast' <em>cannot be ignored</em> if it is set to <code>true.</code>
 * Beginning with SBML Level&nbsp;2 Versions&nbsp;2, the SBML specifications
 * therefore stipulate that if a model has any reactions with 'fast' set to
 * <code>true</code>, a software tool must be able to respect the attribute or else
 * indicate to the user that it does not have the capacity to do so.  Readers
 * are directed to the SBML specifications, which provides more detail about
 * the conditions under which a reaction can be considered to be fast in this
 * sense.</span>
   */ public
 int setFast(boolean value) {
    return libsbmlJNI.Reaction_setFast(swigCPtr, this, value);
  }

  
/**
   * Sets the value of the 'compartment' attribute of this {@link Reaction}.
   <p>
   * The string <code>sid</code> is copied.  
   <p>
   * @param sid the string to use as the compartment of this {@link Reaction}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note The 'compartment' attribute is available in SBML
   * Level&nbsp;3, but is not present on {@link Reaction} in
   * lower Levels of SBML.
   */ public
 int setCompartment(String sid) {
    return libsbmlJNI.Reaction_setCompartment(swigCPtr, this, sid);
  }

  
/**
   * Unsets the value of the 'name' attribute of this {@link Reaction}.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
 *
 * </ul> <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #isSetName()
   */ public
 int unsetName() {
    return libsbmlJNI.Reaction_unsetName(swigCPtr, this);
  }

  
/**
   * Unsets the 'kineticLaw' subelement of this {@link Reaction}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int unsetKineticLaw() {
    return libsbmlJNI.Reaction_unsetKineticLaw(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'fast' attribute of this {@link Reaction}.
   <p>
   * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, values of <code>true</code>
 * for the 'fast' attribute were deprecated, and in future
 * versions of the specification, the attribute itself will
 * be removed.  Users should be aware that even for previous
 * levels/versions of the specification, the 'fast' attribute
 * has never achieved widespread support, and many software
 * packages may ignore it.  To achieve the same or similar 
 * effects as setting the fast attribute to 'true' for a given 
 * reaction, the {@link KineticLaw} attribute should be constructed to 
 * produce a value in the desired time scale, or else the 
 * reaction could be replaced with an {@link AssignmentRule} or 
 * {@link AlgebraicRule}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @warning <span class='warning'>SBML definitions before SBML Level&nbsp;2
 * Version&nbsp;2 incorrectly indicated that software tools could ignore the
 * 'fast' attribute if they did not implement support for the corresponding
 * concept; however, further research in SBML has revealed that this is not
 * true, and 'fast' <em>cannot be ignored</em> if it is set to <code>true.</code>
 * Beginning with SBML Level&nbsp;2 Versions&nbsp;2, the SBML specifications
 * therefore stipulate that if a model has any reactions with 'fast' set to
 * <code>true</code>, a software tool must be able to respect the attribute or else
 * indicate to the user that it does not have the capacity to do so.  Readers
 * are directed to the SBML specifications, which provides more detail about
 * the conditions under which a reaction can be considered to be fast in this
 * sense.</span>
   */ public
 int unsetFast() {
    return libsbmlJNI.Reaction_unsetFast(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'compartment' attribute of this {@link Reaction}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @note The 'compartment' attribute is available in SBML
   * Level&nbsp;3, but is not present on {@link Reaction} in
   * lower Levels of SBML.
   */ public
 int unsetCompartment() {
    return libsbmlJNI.Reaction_unsetCompartment(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'reversible' attribute of this {@link Reaction}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int unsetReversible() {
    return libsbmlJNI.Reaction_unsetReversible(swigCPtr, this);
  }

  
/**
   * Adds a given {@link SpeciesReference} object as a reactant in this {@link Reaction}.
   <p>
   * The {@link SpeciesReference} instance in <code>sr</code> is copied.
   <p>
   * @param sr a {@link SpeciesReference} object referring to a {@link Species} in the
   * enclosing {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createReactant()
   */ public
 int addReactant(SpeciesReference sr) {
    return libsbmlJNI.Reaction_addReactant__SWIG_0(swigCPtr, this, SpeciesReference.getCPtr(sr), sr);
  }

  
/**
   * Adds the given species as a reactant with the given stoichiometry
   <p>
   * @param species the species to be added as reactant.
   <p>
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the product (defaulting to 1).
   <p>
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   <p>
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * @note the {@link Species} object itself is NOT added to the model
   <p>
   * @see #createProduct()
   */ public
 int addReactant(Species species, double stoichiometry, String id, boolean constant) {
    return libsbmlJNI.Reaction_addReactant__SWIG_1(swigCPtr, this, Species.getCPtr(species), species, stoichiometry, id, constant);
  }

  
/**
   * Adds the given species as a reactant with the given stoichiometry
   <p>
   * @param species the species to be added as reactant.
   <p>
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the product (defaulting to 1).
   <p>
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   <p>
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * @note the {@link Species} object itself is NOT added to the model
   <p>
   * @see #createProduct()
   */ public
 int addReactant(Species species, double stoichiometry, String id) {
    return libsbmlJNI.Reaction_addReactant__SWIG_2(swigCPtr, this, Species.getCPtr(species), species, stoichiometry, id);
  }

  
/**
   * Adds the given species as a reactant with the given stoichiometry
   <p>
   * @param species the species to be added as reactant.
   <p>
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the product (defaulting to 1).
   <p>
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   <p>
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * @note the {@link Species} object itself is NOT added to the model
   <p>
   * @see #createProduct()
   */ public
 int addReactant(Species species, double stoichiometry) {
    return libsbmlJNI.Reaction_addReactant__SWIG_3(swigCPtr, this, Species.getCPtr(species), species, stoichiometry);
  }

  
/**
   * Adds the given species as a reactant with the given stoichiometry
   <p>
   * @param species the species to be added as reactant.
   <p>
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the product (defaulting to 1).
   <p>
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   <p>
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * @note the {@link Species} object itself is NOT added to the model
   <p>
   * @see #createProduct()
   */ public
 int addReactant(Species species) {
    return libsbmlJNI.Reaction_addReactant__SWIG_4(swigCPtr, this, Species.getCPtr(species), species);
  }

  
/**
   * Adds a given {@link SpeciesReference} object as a product in this {@link Reaction}.
   <p>
   * The {@link SpeciesReference} instance in <code>sr</code> is copied.
   <p>
   * @param sr a {@link SpeciesReference} object referring to a {@link Species} in the
   * enclosing {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createProduct()
   */ public
 int addProduct(SpeciesReference sr) {
    return libsbmlJNI.Reaction_addProduct__SWIG_0(swigCPtr, this, SpeciesReference.getCPtr(sr), sr);
  }

  
/**
   * Adds the given species as a product with the given stoichiometry
   <p>
   * @param species the species to be added as product.
   <p>
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the product (defaulting to 1).
   <p>
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   <p>
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * @note the {@link Species} object itself is NOT added to the model
   <p>
   * @see #createProduct()
   */ public
 int addProduct(Species species, double stoichiometry, String id, boolean constant) {
    return libsbmlJNI.Reaction_addProduct__SWIG_1(swigCPtr, this, Species.getCPtr(species), species, stoichiometry, id, constant);
  }

  
/**
   * Adds the given species as a product with the given stoichiometry
   <p>
   * @param species the species to be added as product.
   <p>
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the product (defaulting to 1).
   <p>
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   <p>
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * @note the {@link Species} object itself is NOT added to the model
   <p>
   * @see #createProduct()
   */ public
 int addProduct(Species species, double stoichiometry, String id) {
    return libsbmlJNI.Reaction_addProduct__SWIG_2(swigCPtr, this, Species.getCPtr(species), species, stoichiometry, id);
  }

  
/**
   * Adds the given species as a product with the given stoichiometry
   <p>
   * @param species the species to be added as product.
   <p>
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the product (defaulting to 1).
   <p>
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   <p>
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * @note the {@link Species} object itself is NOT added to the model
   <p>
   * @see #createProduct()
   */ public
 int addProduct(Species species, double stoichiometry) {
    return libsbmlJNI.Reaction_addProduct__SWIG_3(swigCPtr, this, Species.getCPtr(species), species, stoichiometry);
  }

  
/**
   * Adds the given species as a product with the given stoichiometry
   <p>
   * @param species the species to be added as product.
   <p>
   * @param stoichiometry an optional parameter specifying the
   *        stoichiometry of the product (defaulting to 1).
   <p>
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   <p>
   * @param constant an attribute specifying whether the species reference is
   *        constant or not (defaulting to true).
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * @note the {@link Species} object itself is NOT added to the model
   <p>
   * @see #createProduct()
   */ public
 int addProduct(Species species) {
    return libsbmlJNI.Reaction_addProduct__SWIG_4(swigCPtr, this, Species.getCPtr(species), species);
  }

  
/**
   * Adds a given {@link ModifierSpeciesReference} object as a product in this
   * {@link Reaction}.
   <p>
   * The {@link ModifierSpeciesReference} instance in <code>msr</code> is copied.
   <p>
   * @param msr a {@link ModifierSpeciesReference} object referring to a {@link Species} in
   * the enclosing {@link Model}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createModifier()
   */ public
 int addModifier(ModifierSpeciesReference msr) {
    return libsbmlJNI.Reaction_addModifier__SWIG_0(swigCPtr, this, ModifierSpeciesReference.getCPtr(msr), msr);
  }

  
/**
   * Adds the given species as a modifier to this reaction
   <p>
   * @param species the species to be added as modifier.
   <p>
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * @note the {@link Species} object itself is NOT added to the model
   <p>
   * @see #createModifier()
   */ public
 int addModifier(Species species, String id) {
    return libsbmlJNI.Reaction_addModifier__SWIG_1(swigCPtr, this, Species.getCPtr(species), species, id);
  }

  
/**
   * Adds the given species as a modifier to this reaction
   <p>
   * @param species the species to be added as modifier.
   <p>
   * @param id an optional id to be given to the species reference that will
   *        be created. (defaulting to empty string, i.e. not set).
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
   <p>
   * @note the {@link Species} object itself is NOT added to the model
   <p>
   * @see #createModifier()
   */ public
 int addModifier(Species species) {
    return libsbmlJNI.Reaction_addModifier__SWIG_2(swigCPtr, this, Species.getCPtr(species), species);
  }

  
/**
   * Creates a new {@link SpeciesReference}, adds it to this {@link Reaction}'s list of
   * reactants, and returns it.
   <p>
   * @return a new {@link SpeciesReference} object.
   */ public
 SpeciesReference createReactant() {
    long cPtr = libsbmlJNI.Reaction_createReactant(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
/**
   * Creates a new {@link SpeciesReference}, adds it to this {@link Reaction}'s list of
   * products, and returns it.
   <p>
   * @return a new {@link SpeciesReference} object.
   */ public
 SpeciesReference createProduct() {
    long cPtr = libsbmlJNI.Reaction_createProduct(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
/**
   * Creates a new {@link ModifierSpeciesReference}, adds it to this {@link Reaction}'s
   * list of modifiers and returns it.
   <p>
   * @return a new {@link ModifierSpeciesReference} object.
   */ public
 ModifierSpeciesReference createModifier() {
    long cPtr = libsbmlJNI.Reaction_createModifier(swigCPtr, this);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, false);
  }

  
/**
   * Creates a new {@link KineticLaw} object, installs it as this {@link Reaction}'s
   * 'kineticLaw' subelement, and returns it.
   <p>
   * If this {@link Reaction} had a previous {@link KineticLaw}, it will be destroyed.
   <p>
   * @return the new {@link KineticLaw} object.
   */ public
 KineticLaw createKineticLaw() {
    long cPtr = libsbmlJNI.Reaction_createKineticLaw(swigCPtr, this);
    return (cPtr == 0) ? null : new KineticLaw(cPtr, false);
  }

  
/**
   * Returns the list of reactants in this {@link Reaction} object.
   <p>
   * @return the {@link ListOfSpeciesReferences} containing the references to the
   * species acting as reactants in this reaction.
   */ public
 ListOfSpeciesReferences getListOfReactants() {
    long cPtr = libsbmlJNI.Reaction_getListOfReactants__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfSpeciesReferences(cPtr, false);
  }

  
/**
   * Returns the list of products in this {@link Reaction} object.
   <p>
   * @return the {@link ListOfSpeciesReferences} containing the references to the
   * species acting as products in this reaction.
   */ public
 ListOfSpeciesReferences getListOfProducts() {
    long cPtr = libsbmlJNI.Reaction_getListOfProducts__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfSpeciesReferences(cPtr, false);
  }

  
/**
   * Returns the list of modifiers in this {@link Reaction} object.
   <p>
   * @return the {@link ListOfSpeciesReferences} containing the references to the
   * species acting as modifiers in this reaction.
   */ public
 ListOfSpeciesReferences getListOfModifiers() {
    long cPtr = libsbmlJNI.Reaction_getListOfModifiers__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfSpeciesReferences(cPtr, false);
  }

  
/**
   * Returns the nth reactant species (as a {@link SpeciesReference} object) in 
   * the list of reactants in this {@link Reaction}.
   <p>
   * Callers should first call getNumReactants() to find out how many
   * reactants there are, to avoid using an invalid index number.
   <p>
   * @param n the index of the reactant sought.
   <p>
   * @return the nth reactant (as a {@link SpeciesReference} object) of this
   * {@link Reaction}.
   */ public
 SpeciesReference getReactant(long n) {
    long cPtr = libsbmlJNI.Reaction_getReactant__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
/**
   * Returns the reactant species (as a {@link SpeciesReference} object) having 
   * a specific identifier in this {@link Reaction}.
   <p>
   * @param species the identifier of the reactant {@link Species} ('species' 
   * attribute of the reactant {@link SpeciesReference} object).
   <p>
   * @return a {@link SpeciesReference} object, or <code>null</code> if no species with the
   * given identifier <code>species</code> appears as a reactant in this {@link Reaction}.
   */ public
 SpeciesReference getReactant(String species) {
    long cPtr = libsbmlJNI.Reaction_getReactant__SWIG_2(swigCPtr, this, species);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
/**
   * Returns the nth product species (as a {@link SpeciesReference} object) in 
   * the list of products in this {@link Reaction}.
   <p>
   * Callers should first call getNumProducts() to find out how many
   * products there are, to avoid using an invalid index number.
   <p>
   * @param n the index of the product sought.
   <p>
   * @return the nth product (as a {@link SpeciesReference} object) of this
   * {@link Reaction}.
   */ public
 SpeciesReference getProduct(long n) {
    long cPtr = libsbmlJNI.Reaction_getProduct__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
/**
   * Returns the product species (as a {@link SpeciesReference} object) having 
   * a specific identifier in this {@link Reaction}.
   <p>
   * @param species the identifier of the product {@link Species} ('species'
   * attribute of the product {@link SpeciesReference} object).
   <p>
   * @return a {@link SpeciesReference} object, or <code>null</code> if no species with the
   * given identifier <code>species</code> appears as a product in this {@link Reaction}.
   */ public
 SpeciesReference getProduct(String species) {
    long cPtr = libsbmlJNI.Reaction_getProduct__SWIG_2(swigCPtr, this, species);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
/**
   * Returns the nth modifier species (as a {@link ModifierSpeciesReference} object) 
   * in the list of modifiers of this {@link Reaction}.
   <p>
   * Callers should first call getNumModifiers() to find out how many
   * modifiers there are, to avoid using an invalid index number.
   <p>
   * @param n the index of the modifier species sought.
   <p>
   * @return the nth modifier (as a {@link ModifierSpeciesReference} object) of
   * this {@link Reaction}.
   */ public
 ModifierSpeciesReference getModifier(long n) {
    long cPtr = libsbmlJNI.Reaction_getModifier__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, false);
  }

  
/**
   * Returns the modifier species (as a {@link ModifierSpeciesReference} object) 
   * having a specific identifier in this {@link Reaction}.
   <p>
   * @param species the identifier of the modifier {@link Species} ('species' 
   * attribute of the {@link ModifierSpeciesReference} object).
   <p>
   * @return a {@link ModifierSpeciesReference} object, or <code>null</code> if no species with
   * the given identifier <code>species</code> appears as a modifier in this
   * {@link Reaction}.
   */ public
 ModifierSpeciesReference getModifier(String species) {
    long cPtr = libsbmlJNI.Reaction_getModifier__SWIG_2(swigCPtr, this, species);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, false);
  }

  
/**
   * Returns the number of reactant species in this {@link Reaction}.
   <p>
   * @return the number of reactants in this {@link Reaction}.
   */ public
 long getNumReactants() {
    return libsbmlJNI.Reaction_getNumReactants(swigCPtr, this);
  }

  
/**
   * Returns the number of product species in this {@link Reaction}.
   <p>
   * @return the number of products in this {@link Reaction}.
   */ public
 long getNumProducts() {
    return libsbmlJNI.Reaction_getNumProducts(swigCPtr, this);
  }

  
/**
   * Returns the number of modifier species in this {@link Reaction}.
   <p>
   * @return the number of modifiers in this {@link Reaction}.
   */ public
 long getNumModifiers() {
    return libsbmlJNI.Reaction_getNumModifiers(swigCPtr, this);
  }

  
/**
   * Removes the nth reactant species (SpeciesReference object) in the list of 
   * reactants in this {@link Reaction} and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   * The caller should first call getNumReactants() to find out how many
   * reactants there are, to avoid using an invalid index number.
   <p>
   * @param n the index of the reactant {@link SpeciesReference} object to remove.
   <p>
   * @return the removed reactant {@link SpeciesReference} object, or <code>null</code> if the 
   * given index is out of range.
   */ public
 SpeciesReference removeReactant(long n) {
    long cPtr = libsbmlJNI.Reaction_removeReactant__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, true);
  }

  
/**
   * Removes the reactant species (SpeciesReference object) having the given  
   * 'species' attribute in this {@link Reaction} and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param species the 'species' attribute of the reactant {@link SpeciesReference} 
   * object.
   <p>
   * @return the removed reactant {@link SpeciesReference} object, or <code>null</code> if no 
   * reactant {@link SpeciesReference} object with the given 'species' attribute 
   * <code>species</code> exists in this {@link Reaction}.
   */ public
 SpeciesReference removeReactant(String species) {
    long cPtr = libsbmlJNI.Reaction_removeReactant__SWIG_1(swigCPtr, this, species);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, true);
  }

  
/**
   * Removes the nth product species (SpeciesReference object) in the list of 
   * products in this {@link Reaction} and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   * The caller should first call getNumProducts() to find out how many
   * products there are, to avoid using an invalid index number.
   <p>
   * @param n the index of the product {@link SpeciesReference} object to remove.
   <p>
   * @return the removed product {@link SpeciesReference} object, or <code>null</code> if the 
   * given index is out of range.
   */ public
 SpeciesReference removeProduct(long n) {
    long cPtr = libsbmlJNI.Reaction_removeProduct__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, true);
  }

  
/**
   * Removes the product species (SpeciesReference object) having the given  
   * 'species' attribute in this {@link Reaction} and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param species the 'species' attribute of the product {@link SpeciesReference} 
   * object.
   <p>
   * @return the removed product {@link SpeciesReference} object, or <code>null</code> if no 
   * product {@link SpeciesReference} object with the given 'species' attribute 
   * <code>species</code> exists in this {@link Reaction}.
   */ public
 SpeciesReference removeProduct(String species) {
    long cPtr = libsbmlJNI.Reaction_removeProduct__SWIG_1(swigCPtr, this, species);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, true);
  }

  
/**
   * Removes the nth modifier species (ModifierSpeciesReference object) in 
   * the list of  modifiers in this {@link Reaction} and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   * The caller should first call getNumModifiers() to find out how many
   * modifiers there are, to avoid using an invalid index number.
   <p>
   * @param n the index of the {@link ModifierSpeciesReference} object to remove.
   <p>
   * @return the removed {@link ModifierSpeciesReference} object, or <code>null</code> if the 
   * given index is out of range.
   */ public
 ModifierSpeciesReference removeModifier(long n) {
    long cPtr = libsbmlJNI.Reaction_removeModifier__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, true);
  }

  
/**
   * Removes the modifier species (ModifierSpeciesReference object) having 
   * the given 'species' attribute in this {@link Reaction} and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param species the 'species' attribute of the {@link ModifierSpeciesReference} 
   * object.
   <p>
   * @return the removed {@link ModifierSpeciesReference} object, or <code>null</code> if no 
   * {@link ModifierSpeciesReference} object with the given 'species' attribute @p 
   * species exists in this {@link Reaction}.
   */ public
 ModifierSpeciesReference removeModifier(String species) {
    long cPtr = libsbmlJNI.Reaction_removeModifier__SWIG_1(swigCPtr, this, species);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, true);
  }

  public void connectToChild() {
    libsbmlJNI.Reaction_connectToChild(swigCPtr, this);
  }

  
/** * @internal */ public
 void enablePackageInternal(String pkgURI, String pkgPrefix, boolean flag) {
    libsbmlJNI.Reaction_enablePackageInternal(swigCPtr, this, pkgURI, pkgPrefix, flag);
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   <p>
   * <p>
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.    Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the <code>getPackageName()</code>
 * method on the object.
   <p>
   * @return the SBML type code for this object:
   * {@link libsbmlConstants#SBML_REACTION SBML_REACTION} (default).
   <p>
   * <p>
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getTypeCode() and getPackageName()</strong>.</span>
   <p>
   * @see #getElementName()
   * @see #getPackageName()
   */ public
 int getTypeCode() {
    return libsbmlJNI.Reaction_getTypeCode(swigCPtr, this);
  }

  
/**
   * Returns the XML element name of this object, which for {@link Reaction}, is
   * always <code>'reaction'.</code>
   <p>
   * @return the name of this element, i.e., <code>'reaction'.</code>
   */ public
 String getElementName() {
    return libsbmlJNI.Reaction_getElementName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if all the required attributes for this
   * {@link Reaction} object have been set.
   <p>
   * The required attributes for a {@link Reaction} object are:
   * <ul>
   * <li> 'id' (or 'name' in SBML Level&nbsp;1)
   * <li> 'fast' (in Level&nbsp;3 only, where it is defined as a required attribute)
   * <li> 'reversible' (in Level&nbsp;3 only, where it is defined as a required attribute)
   *
   * </ul> <p>
   * @return <code>true</code> if the required attributes have been set, <code>false</code>
   * otherwise.
   */ public
 boolean hasRequiredAttributes() {
    return libsbmlJNI.Reaction_hasRequiredAttributes(swigCPtr, this);
  }

}
