#!/bin/sh -e

VERSION=$2
TAR=../maven-bundle-plugin_$VERSION.orig.tar.xz
DIR=maven-bundle-plugin-$VERSION
TAG=$(echo "maven-bundle-plugin-$VERSION" | sed -re's/~(alpha|beta)/-\1-/')

svn export https://svn.apache.org/repos/asf/felix/releases/${TAG}/ $DIR
XZ_OPT=--best tar -c -J -f $TAR --exclude '*.jar' --exclude '*.class' $DIR
rm -rf $DIR ../$TAG

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
