/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQObstatScatterTool_H
#define MvQObstatScatterTool_H

#include "MvQMainWindow.h"
#include "MvQObstatScatterData.h"

class QSplitter;
class QTextBrowser;

class MvKeyProfile;

class MvQObstatScatterToolBase;
class MvQKeyManager;
class MvQLogBrowser;

class MvQObstatScatterTool : public MvQMainWindow
{
    Q_OBJECT

public:
    	MvQObstatScatterTool(QWidget *parent = 0);
    	~MvQObstatScatterTool();
    	void init(MvQObstatScatterData*);

public slots:
	void slotSelectMessage(int);
	void slotSelectBlock(int);
	void slotLoadKeyProfile(MvKeyProfile *);
	void slotUpdateLogOutput();	
	
private:
	void readSettings();
	void writeSettings();

	QSplitter*   centralSplitter_;
	QSplitter*   mainSplitter_;

	MvQObstatScatterData* data_;
	//MvQKeyManager *keyManager_;

	MvQObstatScatterToolBase* examinerBase_;
	MvQLogBrowser* logBrowser_;

	QString lastKeyProfileName_;
};

#endif
