/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#pragma once

#include "Thermo.h"

class MvObs;
class MvObsSetIterator;
class MvNetCDF;

class BufrThermo : public Thermo
{
public:
    // Constructors
    BufrThermo();
    BufrThermo(const char*);

    // Destructor
    ~BufrThermo() {}

    // Allocate data values storage
    void allocateDataMemory();

    // Initialise data values storage
    void initialiseDataMemory();

    // Process data and build all data structures
    bool processData();

    //  Post-process and generate NetCDF output
    bool generate(MvNetCDF&, MvObs&);

    // Generate output request
    bool createOutputRequest(MvRequest&);

    // Create a default title
    std::string title();

protected:
    // Get application specific parameters
    virtual bool getAppParameters(MvRequest&);

    // Initialise a netCDF file: variables, dimensions and attributes
    bool ncInit(MvNetCDF&, MvObs&);

    // Get Identification and Location from the Bufr data
    bool getIdent(MvRequest&, MvObsSetIterator&);
    bool getLocation(MvRequest&, MvObsSetIterator&);

    // Get the maximum number of pressure levels
    int evaluateNLevels(MvObsSetIterator&);

    // Variables members
    MvRequest station_;  // Station input request

    int counter_;    // number of thermo data
    int pCount_;     // number of levels
    int nlev_;       // maximum number of levels
    int nTIME_STR_;  // 13 - yyyymmddhhmm + 1 ('end of string')

    std::vector<double> T_;  // variables data
    std::vector<double> P_;
    std::vector<double> TD_;
    std::vector<double> U_;
    std::vector<double> V_;
    std::vector<double> Z_;
};
