/***************************** LICENSE START ***********************************

 Copyright 2019 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FUNCTIONWEBWIDGET_H
#define FUNCTIONWEBWIDGET_H

#include <QSettings>
#include <QWidget>

class LanguageHelper;
class VerbFunctionHelpFunction;
class QTreeWidgetItem;
class QWebEngineView;

namespace Ui {
    class FunctionWebWidget;
}

class FunctionWebWidget : public QWidget
{
    Q_OBJECT

public:
    FunctionWebWidget(QWidget* parent = 0);
    ~FunctionWebWidget() {}

    void clear();
    void setLanguage(LanguageHelper*);
    void showFunction(QString);
    void showFunction(VerbFunctionHelpFunction* function);
    bool hasData() const;
    bool hasView() const;

    void readSettings(QSettings&);
    void writeSettings(QSettings&);

protected slots:
    void selectWebGroup(QTreeWidgetItem* item,int);

signals:
    void functionListRequested();

protected:
    void loadWebDoc();
    void hideDescription();
    void setDescriptions(VerbFunctionHelpFunction *fn);

    Ui::FunctionWebWidget* ui_;
    LanguageHelper* language_;
#ifdef METVIEW_QT_WEBENGINE
    QWebEngineView* webView_;
#endif
    VerbFunctionHelpFunction *fn_;
    QString webGroup_;
    bool ignoreWebGroupSelection_;
};

#endif // FUNCTIONWEBWIDGET_H
