"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Nuuk"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Nuuk", { offset: true, expect: "America/Godthab" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Nuuk", { abbr: true, expect: "America/Godthab" }),

	"1916" : helpers.makeTestYear("America/Nuuk", [
		["1916-07-28T03:26:56+00:00", "00:26:56", "-03", 180]
	]),

	"1980" : helpers.makeTestYear("America/Nuuk", [
		["1980-04-06T04:59:59+00:00", "01:59:59", "-03", 180],
		["1980-04-06T05:00:00+00:00", "03:00:00", "-02", 120],
		["1980-09-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["1980-09-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1981" : helpers.makeTestYear("America/Nuuk", [
		["1981-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["1981-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["1981-09-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["1981-09-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1982" : helpers.makeTestYear("America/Nuuk", [
		["1982-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["1982-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["1982-09-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["1982-09-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1983" : helpers.makeTestYear("America/Nuuk", [
		["1983-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["1983-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["1983-09-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["1983-09-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1984" : helpers.makeTestYear("America/Nuuk", [
		["1984-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["1984-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["1984-09-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["1984-09-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1985" : helpers.makeTestYear("America/Nuuk", [
		["1985-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["1985-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["1985-09-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["1985-09-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1986" : helpers.makeTestYear("America/Nuuk", [
		["1986-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["1986-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["1986-09-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["1986-09-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1987" : helpers.makeTestYear("America/Nuuk", [
		["1987-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["1987-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["1987-09-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["1987-09-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1988" : helpers.makeTestYear("America/Nuuk", [
		["1988-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["1988-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["1988-09-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["1988-09-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1989" : helpers.makeTestYear("America/Nuuk", [
		["1989-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["1989-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["1989-09-24T00:59:59+00:00", "22:59:59", "-02", 120],
		["1989-09-24T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1990" : helpers.makeTestYear("America/Nuuk", [
		["1990-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["1990-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["1990-09-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["1990-09-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1991" : helpers.makeTestYear("America/Nuuk", [
		["1991-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["1991-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["1991-09-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["1991-09-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1992" : helpers.makeTestYear("America/Nuuk", [
		["1992-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["1992-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["1992-09-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["1992-09-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1993" : helpers.makeTestYear("America/Nuuk", [
		["1993-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["1993-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["1993-09-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["1993-09-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1994" : helpers.makeTestYear("America/Nuuk", [
		["1994-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["1994-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["1994-09-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["1994-09-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1995" : helpers.makeTestYear("America/Nuuk", [
		["1995-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["1995-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["1995-09-24T00:59:59+00:00", "22:59:59", "-02", 120],
		["1995-09-24T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1996" : helpers.makeTestYear("America/Nuuk", [
		["1996-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["1996-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["1996-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["1996-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1997" : helpers.makeTestYear("America/Nuuk", [
		["1997-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["1997-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["1997-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["1997-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1998" : helpers.makeTestYear("America/Nuuk", [
		["1998-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["1998-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["1998-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["1998-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1999" : helpers.makeTestYear("America/Nuuk", [
		["1999-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["1999-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["1999-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["1999-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2000" : helpers.makeTestYear("America/Nuuk", [
		["2000-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2000-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2000-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2000-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2001" : helpers.makeTestYear("America/Nuuk", [
		["2001-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2001-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2001-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2001-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2002" : helpers.makeTestYear("America/Nuuk", [
		["2002-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2002-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2002-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2002-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2003" : helpers.makeTestYear("America/Nuuk", [
		["2003-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2003-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2003-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2003-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2004" : helpers.makeTestYear("America/Nuuk", [
		["2004-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2004-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2004-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2004-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2005" : helpers.makeTestYear("America/Nuuk", [
		["2005-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2005-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2005-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2005-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2006" : helpers.makeTestYear("America/Nuuk", [
		["2006-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2006-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2006-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2006-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2007" : helpers.makeTestYear("America/Nuuk", [
		["2007-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2007-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2007-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2007-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2008" : helpers.makeTestYear("America/Nuuk", [
		["2008-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2008-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2008-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2008-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2009" : helpers.makeTestYear("America/Nuuk", [
		["2009-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2009-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2009-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2009-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2010" : helpers.makeTestYear("America/Nuuk", [
		["2010-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2010-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2010-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2010-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2011" : helpers.makeTestYear("America/Nuuk", [
		["2011-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2011-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2011-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2011-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2012" : helpers.makeTestYear("America/Nuuk", [
		["2012-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2012-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2012-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2012-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2013" : helpers.makeTestYear("America/Nuuk", [
		["2013-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2013-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2013-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2013-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2014" : helpers.makeTestYear("America/Nuuk", [
		["2014-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2014-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2014-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2014-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2015" : helpers.makeTestYear("America/Nuuk", [
		["2015-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2015-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2015-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2015-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2016" : helpers.makeTestYear("America/Nuuk", [
		["2016-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2016-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2016-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2016-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2017" : helpers.makeTestYear("America/Nuuk", [
		["2017-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2017-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2017-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2017-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2018" : helpers.makeTestYear("America/Nuuk", [
		["2018-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2018-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2018-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2018-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2019" : helpers.makeTestYear("America/Nuuk", [
		["2019-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2019-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2019-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2019-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2020" : helpers.makeTestYear("America/Nuuk", [
		["2020-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2020-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2020-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2020-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2021" : helpers.makeTestYear("America/Nuuk", [
		["2021-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2021-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2021-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2021-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2022" : helpers.makeTestYear("America/Nuuk", [
		["2022-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2022-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2022-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2022-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2023" : helpers.makeTestYear("America/Nuuk", [
		["2023-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2023-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2023-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2023-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2024" : helpers.makeTestYear("America/Nuuk", [
		["2024-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2024-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2024-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2024-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2025" : helpers.makeTestYear("America/Nuuk", [
		["2025-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2025-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2025-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2025-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2026" : helpers.makeTestYear("America/Nuuk", [
		["2026-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2026-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2026-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2026-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2027" : helpers.makeTestYear("America/Nuuk", [
		["2027-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2027-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2027-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2027-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2028" : helpers.makeTestYear("America/Nuuk", [
		["2028-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2028-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2028-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2028-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2029" : helpers.makeTestYear("America/Nuuk", [
		["2029-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2029-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2029-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2029-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2030" : helpers.makeTestYear("America/Nuuk", [
		["2030-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2030-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2030-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2030-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2031" : helpers.makeTestYear("America/Nuuk", [
		["2031-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2031-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2031-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2031-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2032" : helpers.makeTestYear("America/Nuuk", [
		["2032-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2032-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2032-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2032-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2033" : helpers.makeTestYear("America/Nuuk", [
		["2033-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2033-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2033-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2033-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2034" : helpers.makeTestYear("America/Nuuk", [
		["2034-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2034-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2034-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2034-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2035" : helpers.makeTestYear("America/Nuuk", [
		["2035-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2035-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2035-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2035-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2036" : helpers.makeTestYear("America/Nuuk", [
		["2036-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2036-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2036-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2036-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2037" : helpers.makeTestYear("America/Nuuk", [
		["2037-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2037-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2037-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2037-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2038" : helpers.makeTestYear("America/Nuuk", [
		["2038-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2038-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2038-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2038-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2039" : helpers.makeTestYear("America/Nuuk", [
		["2039-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2039-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2039-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2039-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2040" : helpers.makeTestYear("America/Nuuk", [
		["2040-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2040-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2040-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2040-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2041" : helpers.makeTestYear("America/Nuuk", [
		["2041-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2041-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2041-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2041-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2042" : helpers.makeTestYear("America/Nuuk", [
		["2042-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2042-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2042-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2042-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2043" : helpers.makeTestYear("America/Nuuk", [
		["2043-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2043-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2043-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2043-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2044" : helpers.makeTestYear("America/Nuuk", [
		["2044-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2044-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2044-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2044-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2045" : helpers.makeTestYear("America/Nuuk", [
		["2045-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2045-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2045-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2045-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2046" : helpers.makeTestYear("America/Nuuk", [
		["2046-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2046-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2046-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2046-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2047" : helpers.makeTestYear("America/Nuuk", [
		["2047-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2047-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2047-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2047-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2048" : helpers.makeTestYear("America/Nuuk", [
		["2048-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2048-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2048-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2048-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2049" : helpers.makeTestYear("America/Nuuk", [
		["2049-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2049-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2049-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2049-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2050" : helpers.makeTestYear("America/Nuuk", [
		["2050-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2050-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2050-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2050-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2051" : helpers.makeTestYear("America/Nuuk", [
		["2051-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2051-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2051-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2051-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2052" : helpers.makeTestYear("America/Nuuk", [
		["2052-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2052-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2052-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2052-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2053" : helpers.makeTestYear("America/Nuuk", [
		["2053-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2053-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2053-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2053-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2054" : helpers.makeTestYear("America/Nuuk", [
		["2054-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2054-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2054-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2054-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2055" : helpers.makeTestYear("America/Nuuk", [
		["2055-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2055-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2055-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2055-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2056" : helpers.makeTestYear("America/Nuuk", [
		["2056-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2056-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2056-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2056-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2057" : helpers.makeTestYear("America/Nuuk", [
		["2057-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2057-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2057-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2057-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2058" : helpers.makeTestYear("America/Nuuk", [
		["2058-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2058-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2058-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2058-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2059" : helpers.makeTestYear("America/Nuuk", [
		["2059-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2059-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2059-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2059-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2060" : helpers.makeTestYear("America/Nuuk", [
		["2060-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2060-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2060-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2060-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2061" : helpers.makeTestYear("America/Nuuk", [
		["2061-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2061-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2061-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2061-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2062" : helpers.makeTestYear("America/Nuuk", [
		["2062-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2062-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2062-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2062-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2063" : helpers.makeTestYear("America/Nuuk", [
		["2063-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2063-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2063-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2063-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2064" : helpers.makeTestYear("America/Nuuk", [
		["2064-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2064-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2064-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2064-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2065" : helpers.makeTestYear("America/Nuuk", [
		["2065-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2065-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2065-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2065-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2066" : helpers.makeTestYear("America/Nuuk", [
		["2066-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2066-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2066-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2066-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2067" : helpers.makeTestYear("America/Nuuk", [
		["2067-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2067-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2067-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2067-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2068" : helpers.makeTestYear("America/Nuuk", [
		["2068-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2068-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2068-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2068-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2069" : helpers.makeTestYear("America/Nuuk", [
		["2069-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2069-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2069-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2069-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2070" : helpers.makeTestYear("America/Nuuk", [
		["2070-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2070-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2070-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2070-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2071" : helpers.makeTestYear("America/Nuuk", [
		["2071-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2071-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2071-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2071-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2072" : helpers.makeTestYear("America/Nuuk", [
		["2072-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2072-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2072-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2072-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2073" : helpers.makeTestYear("America/Nuuk", [
		["2073-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2073-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2073-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2073-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2074" : helpers.makeTestYear("America/Nuuk", [
		["2074-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2074-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2074-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2074-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2075" : helpers.makeTestYear("America/Nuuk", [
		["2075-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2075-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2075-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2075-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2076" : helpers.makeTestYear("America/Nuuk", [
		["2076-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2076-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2076-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2076-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2077" : helpers.makeTestYear("America/Nuuk", [
		["2077-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2077-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2077-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2077-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2078" : helpers.makeTestYear("America/Nuuk", [
		["2078-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2078-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2078-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2078-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2079" : helpers.makeTestYear("America/Nuuk", [
		["2079-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2079-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2079-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2079-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2080" : helpers.makeTestYear("America/Nuuk", [
		["2080-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2080-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2080-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2080-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2081" : helpers.makeTestYear("America/Nuuk", [
		["2081-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2081-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2081-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2081-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2082" : helpers.makeTestYear("America/Nuuk", [
		["2082-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2082-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2082-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2082-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2083" : helpers.makeTestYear("America/Nuuk", [
		["2083-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2083-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2083-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2083-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2084" : helpers.makeTestYear("America/Nuuk", [
		["2084-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2084-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2084-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2084-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2085" : helpers.makeTestYear("America/Nuuk", [
		["2085-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2085-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2085-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2085-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2086" : helpers.makeTestYear("America/Nuuk", [
		["2086-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2086-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2086-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2086-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2087" : helpers.makeTestYear("America/Nuuk", [
		["2087-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2087-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2087-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2087-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2088" : helpers.makeTestYear("America/Nuuk", [
		["2088-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2088-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2088-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2088-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2089" : helpers.makeTestYear("America/Nuuk", [
		["2089-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2089-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2089-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2089-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2090" : helpers.makeTestYear("America/Nuuk", [
		["2090-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2090-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2090-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2090-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2091" : helpers.makeTestYear("America/Nuuk", [
		["2091-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2091-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2091-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2091-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2092" : helpers.makeTestYear("America/Nuuk", [
		["2092-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2092-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2092-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2092-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2093" : helpers.makeTestYear("America/Nuuk", [
		["2093-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2093-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2093-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2093-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2094" : helpers.makeTestYear("America/Nuuk", [
		["2094-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2094-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2094-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2094-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2095" : helpers.makeTestYear("America/Nuuk", [
		["2095-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2095-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2095-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2095-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2096" : helpers.makeTestYear("America/Nuuk", [
		["2096-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2096-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2096-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2096-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2097" : helpers.makeTestYear("America/Nuuk", [
		["2097-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2097-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2097-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2097-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2098" : helpers.makeTestYear("America/Nuuk", [
		["2098-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2098-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2098-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2098-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2099" : helpers.makeTestYear("America/Nuuk", [
		["2099-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2099-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2099-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2099-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2100" : helpers.makeTestYear("America/Nuuk", [
		["2100-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2100-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2100-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2100-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2101" : helpers.makeTestYear("America/Nuuk", [
		["2101-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2101-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2101-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2101-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2102" : helpers.makeTestYear("America/Nuuk", [
		["2102-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2102-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2102-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2102-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2103" : helpers.makeTestYear("America/Nuuk", [
		["2103-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2103-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2103-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2103-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2104" : helpers.makeTestYear("America/Nuuk", [
		["2104-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2104-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2104-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2104-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2105" : helpers.makeTestYear("America/Nuuk", [
		["2105-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2105-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2105-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2105-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2106" : helpers.makeTestYear("America/Nuuk", [
		["2106-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2106-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2106-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2106-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2107" : helpers.makeTestYear("America/Nuuk", [
		["2107-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2107-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2107-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2107-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2108" : helpers.makeTestYear("America/Nuuk", [
		["2108-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2108-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2108-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2108-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2109" : helpers.makeTestYear("America/Nuuk", [
		["2109-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2109-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2109-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2109-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2110" : helpers.makeTestYear("America/Nuuk", [
		["2110-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2110-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2110-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2110-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2111" : helpers.makeTestYear("America/Nuuk", [
		["2111-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2111-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2111-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2111-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2112" : helpers.makeTestYear("America/Nuuk", [
		["2112-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2112-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2112-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2112-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2113" : helpers.makeTestYear("America/Nuuk", [
		["2113-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2113-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2113-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2113-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2114" : helpers.makeTestYear("America/Nuuk", [
		["2114-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2114-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2114-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2114-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2115" : helpers.makeTestYear("America/Nuuk", [
		["2115-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2115-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2115-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2115-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2116" : helpers.makeTestYear("America/Nuuk", [
		["2116-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2116-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2116-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2116-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2117" : helpers.makeTestYear("America/Nuuk", [
		["2117-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2117-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2117-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2117-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2118" : helpers.makeTestYear("America/Nuuk", [
		["2118-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2118-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2118-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2118-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2119" : helpers.makeTestYear("America/Nuuk", [
		["2119-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2119-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2119-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2119-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2120" : helpers.makeTestYear("America/Nuuk", [
		["2120-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2120-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2120-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2120-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2121" : helpers.makeTestYear("America/Nuuk", [
		["2121-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2121-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2121-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2121-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2122" : helpers.makeTestYear("America/Nuuk", [
		["2122-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2122-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2122-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2122-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2123" : helpers.makeTestYear("America/Nuuk", [
		["2123-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2123-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2123-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2123-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2124" : helpers.makeTestYear("America/Nuuk", [
		["2124-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2124-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2124-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2124-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2125" : helpers.makeTestYear("America/Nuuk", [
		["2125-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2125-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2125-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2125-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2126" : helpers.makeTestYear("America/Nuuk", [
		["2126-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2126-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2126-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2126-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2127" : helpers.makeTestYear("America/Nuuk", [
		["2127-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2127-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2127-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2127-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2128" : helpers.makeTestYear("America/Nuuk", [
		["2128-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2128-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2128-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2128-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2129" : helpers.makeTestYear("America/Nuuk", [
		["2129-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2129-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2129-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2129-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2130" : helpers.makeTestYear("America/Nuuk", [
		["2130-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2130-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2130-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2130-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2131" : helpers.makeTestYear("America/Nuuk", [
		["2131-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2131-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2131-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2131-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2132" : helpers.makeTestYear("America/Nuuk", [
		["2132-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2132-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2132-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2132-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2133" : helpers.makeTestYear("America/Nuuk", [
		["2133-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2133-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2133-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2133-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2134" : helpers.makeTestYear("America/Nuuk", [
		["2134-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2134-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2134-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2134-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2135" : helpers.makeTestYear("America/Nuuk", [
		["2135-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2135-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2135-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2135-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2136" : helpers.makeTestYear("America/Nuuk", [
		["2136-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2136-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2136-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2136-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2137" : helpers.makeTestYear("America/Nuuk", [
		["2137-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2137-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2137-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2137-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2138" : helpers.makeTestYear("America/Nuuk", [
		["2138-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2138-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2138-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2138-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2139" : helpers.makeTestYear("America/Nuuk", [
		["2139-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2139-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2139-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2139-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2140" : helpers.makeTestYear("America/Nuuk", [
		["2140-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2140-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2140-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2140-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2141" : helpers.makeTestYear("America/Nuuk", [
		["2141-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2141-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2141-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2141-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2142" : helpers.makeTestYear("America/Nuuk", [
		["2142-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2142-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2142-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2142-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2143" : helpers.makeTestYear("America/Nuuk", [
		["2143-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2143-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2143-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2143-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2144" : helpers.makeTestYear("America/Nuuk", [
		["2144-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2144-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2144-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2144-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2145" : helpers.makeTestYear("America/Nuuk", [
		["2145-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2145-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2145-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2145-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2146" : helpers.makeTestYear("America/Nuuk", [
		["2146-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2146-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2146-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2146-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2147" : helpers.makeTestYear("America/Nuuk", [
		["2147-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2147-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2147-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2147-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2148" : helpers.makeTestYear("America/Nuuk", [
		["2148-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2148-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2148-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2148-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2149" : helpers.makeTestYear("America/Nuuk", [
		["2149-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2149-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2149-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2149-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2150" : helpers.makeTestYear("America/Nuuk", [
		["2150-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2150-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2150-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2150-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2151" : helpers.makeTestYear("America/Nuuk", [
		["2151-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2151-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2151-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2151-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2152" : helpers.makeTestYear("America/Nuuk", [
		["2152-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2152-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2152-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2152-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2153" : helpers.makeTestYear("America/Nuuk", [
		["2153-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2153-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2153-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2153-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2154" : helpers.makeTestYear("America/Nuuk", [
		["2154-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2154-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2154-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2154-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2155" : helpers.makeTestYear("America/Nuuk", [
		["2155-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2155-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2155-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2155-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2156" : helpers.makeTestYear("America/Nuuk", [
		["2156-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2156-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2156-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2156-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2157" : helpers.makeTestYear("America/Nuuk", [
		["2157-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2157-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2157-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2157-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2158" : helpers.makeTestYear("America/Nuuk", [
		["2158-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2158-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2158-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2158-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2159" : helpers.makeTestYear("America/Nuuk", [
		["2159-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2159-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2159-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2159-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2160" : helpers.makeTestYear("America/Nuuk", [
		["2160-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2160-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2160-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2160-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2161" : helpers.makeTestYear("America/Nuuk", [
		["2161-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2161-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2161-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2161-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2162" : helpers.makeTestYear("America/Nuuk", [
		["2162-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2162-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2162-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2162-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2163" : helpers.makeTestYear("America/Nuuk", [
		["2163-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2163-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2163-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2163-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2164" : helpers.makeTestYear("America/Nuuk", [
		["2164-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2164-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2164-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2164-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2165" : helpers.makeTestYear("America/Nuuk", [
		["2165-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2165-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2165-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2165-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2166" : helpers.makeTestYear("America/Nuuk", [
		["2166-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2166-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2166-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2166-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2167" : helpers.makeTestYear("America/Nuuk", [
		["2167-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2167-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2167-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2167-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2168" : helpers.makeTestYear("America/Nuuk", [
		["2168-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2168-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2168-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2168-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2169" : helpers.makeTestYear("America/Nuuk", [
		["2169-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2169-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2169-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2169-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2170" : helpers.makeTestYear("America/Nuuk", [
		["2170-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2170-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2170-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2170-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2171" : helpers.makeTestYear("America/Nuuk", [
		["2171-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2171-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2171-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2171-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2172" : helpers.makeTestYear("America/Nuuk", [
		["2172-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2172-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2172-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2172-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2173" : helpers.makeTestYear("America/Nuuk", [
		["2173-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2173-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2173-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2173-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2174" : helpers.makeTestYear("America/Nuuk", [
		["2174-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2174-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2174-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2174-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2175" : helpers.makeTestYear("America/Nuuk", [
		["2175-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2175-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2175-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2175-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2176" : helpers.makeTestYear("America/Nuuk", [
		["2176-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2176-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2176-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2176-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2177" : helpers.makeTestYear("America/Nuuk", [
		["2177-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2177-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2177-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2177-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2178" : helpers.makeTestYear("America/Nuuk", [
		["2178-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2178-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2178-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2178-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2179" : helpers.makeTestYear("America/Nuuk", [
		["2179-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2179-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2179-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2179-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2180" : helpers.makeTestYear("America/Nuuk", [
		["2180-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2180-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2180-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2180-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2181" : helpers.makeTestYear("America/Nuuk", [
		["2181-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2181-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2181-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2181-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2182" : helpers.makeTestYear("America/Nuuk", [
		["2182-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2182-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2182-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2182-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2183" : helpers.makeTestYear("America/Nuuk", [
		["2183-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2183-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2183-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2183-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2184" : helpers.makeTestYear("America/Nuuk", [
		["2184-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2184-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2184-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2184-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2185" : helpers.makeTestYear("America/Nuuk", [
		["2185-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2185-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2185-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2185-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2186" : helpers.makeTestYear("America/Nuuk", [
		["2186-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2186-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2186-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2186-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2187" : helpers.makeTestYear("America/Nuuk", [
		["2187-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2187-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2187-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2187-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2188" : helpers.makeTestYear("America/Nuuk", [
		["2188-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2188-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2188-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2188-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2189" : helpers.makeTestYear("America/Nuuk", [
		["2189-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2189-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2189-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2189-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2190" : helpers.makeTestYear("America/Nuuk", [
		["2190-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2190-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2190-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2190-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2191" : helpers.makeTestYear("America/Nuuk", [
		["2191-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2191-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2191-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2191-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2192" : helpers.makeTestYear("America/Nuuk", [
		["2192-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2192-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2192-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2192-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2193" : helpers.makeTestYear("America/Nuuk", [
		["2193-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2193-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2193-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2193-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2194" : helpers.makeTestYear("America/Nuuk", [
		["2194-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2194-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2194-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2194-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2195" : helpers.makeTestYear("America/Nuuk", [
		["2195-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2195-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2195-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2195-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2196" : helpers.makeTestYear("America/Nuuk", [
		["2196-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2196-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2196-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2196-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2197" : helpers.makeTestYear("America/Nuuk", [
		["2197-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2197-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2197-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2197-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2198" : helpers.makeTestYear("America/Nuuk", [
		["2198-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2198-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2198-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2198-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2199" : helpers.makeTestYear("America/Nuuk", [
		["2199-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2199-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2199-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2199-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2200" : helpers.makeTestYear("America/Nuuk", [
		["2200-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2200-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2200-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2200-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2201" : helpers.makeTestYear("America/Nuuk", [
		["2201-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2201-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2201-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2201-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2202" : helpers.makeTestYear("America/Nuuk", [
		["2202-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2202-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2202-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2202-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2203" : helpers.makeTestYear("America/Nuuk", [
		["2203-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2203-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2203-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2203-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2204" : helpers.makeTestYear("America/Nuuk", [
		["2204-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2204-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2204-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2204-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2205" : helpers.makeTestYear("America/Nuuk", [
		["2205-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2205-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2205-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2205-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2206" : helpers.makeTestYear("America/Nuuk", [
		["2206-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2206-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2206-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2206-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2207" : helpers.makeTestYear("America/Nuuk", [
		["2207-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2207-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2207-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2207-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2208" : helpers.makeTestYear("America/Nuuk", [
		["2208-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2208-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2208-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2208-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2209" : helpers.makeTestYear("America/Nuuk", [
		["2209-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2209-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2209-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2209-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2210" : helpers.makeTestYear("America/Nuuk", [
		["2210-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2210-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2210-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2210-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2211" : helpers.makeTestYear("America/Nuuk", [
		["2211-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2211-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2211-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2211-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2212" : helpers.makeTestYear("America/Nuuk", [
		["2212-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2212-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2212-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2212-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2213" : helpers.makeTestYear("America/Nuuk", [
		["2213-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2213-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2213-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2213-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2214" : helpers.makeTestYear("America/Nuuk", [
		["2214-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2214-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2214-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2214-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2215" : helpers.makeTestYear("America/Nuuk", [
		["2215-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2215-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2215-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2215-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2216" : helpers.makeTestYear("America/Nuuk", [
		["2216-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2216-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2216-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2216-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2217" : helpers.makeTestYear("America/Nuuk", [
		["2217-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2217-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2217-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2217-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2218" : helpers.makeTestYear("America/Nuuk", [
		["2218-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2218-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2218-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2218-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2219" : helpers.makeTestYear("America/Nuuk", [
		["2219-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2219-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2219-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2219-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2220" : helpers.makeTestYear("America/Nuuk", [
		["2220-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2220-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2220-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2220-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2221" : helpers.makeTestYear("America/Nuuk", [
		["2221-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2221-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2221-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2221-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2222" : helpers.makeTestYear("America/Nuuk", [
		["2222-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2222-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2222-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2222-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2223" : helpers.makeTestYear("America/Nuuk", [
		["2223-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2223-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2223-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2223-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2224" : helpers.makeTestYear("America/Nuuk", [
		["2224-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2224-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2224-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2224-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2225" : helpers.makeTestYear("America/Nuuk", [
		["2225-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2225-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2225-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2225-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2226" : helpers.makeTestYear("America/Nuuk", [
		["2226-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2226-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2226-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2226-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2227" : helpers.makeTestYear("America/Nuuk", [
		["2227-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2227-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2227-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2227-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2228" : helpers.makeTestYear("America/Nuuk", [
		["2228-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2228-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2228-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2228-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2229" : helpers.makeTestYear("America/Nuuk", [
		["2229-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2229-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2229-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2229-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2230" : helpers.makeTestYear("America/Nuuk", [
		["2230-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2230-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2230-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2230-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2231" : helpers.makeTestYear("America/Nuuk", [
		["2231-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2231-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2231-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2231-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2232" : helpers.makeTestYear("America/Nuuk", [
		["2232-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2232-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2232-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2232-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2233" : helpers.makeTestYear("America/Nuuk", [
		["2233-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2233-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2233-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2233-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2234" : helpers.makeTestYear("America/Nuuk", [
		["2234-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2234-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2234-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2234-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2235" : helpers.makeTestYear("America/Nuuk", [
		["2235-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2235-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2235-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2235-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2236" : helpers.makeTestYear("America/Nuuk", [
		["2236-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2236-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2236-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2236-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2237" : helpers.makeTestYear("America/Nuuk", [
		["2237-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2237-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2237-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2237-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2238" : helpers.makeTestYear("America/Nuuk", [
		["2238-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2238-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2238-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2238-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2239" : helpers.makeTestYear("America/Nuuk", [
		["2239-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2239-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2239-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2239-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2240" : helpers.makeTestYear("America/Nuuk", [
		["2240-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2240-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2240-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2240-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2241" : helpers.makeTestYear("America/Nuuk", [
		["2241-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2241-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2241-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2241-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2242" : helpers.makeTestYear("America/Nuuk", [
		["2242-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2242-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2242-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2242-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2243" : helpers.makeTestYear("America/Nuuk", [
		["2243-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2243-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2243-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2243-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2244" : helpers.makeTestYear("America/Nuuk", [
		["2244-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2244-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2244-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2244-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2245" : helpers.makeTestYear("America/Nuuk", [
		["2245-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2245-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2245-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2245-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2246" : helpers.makeTestYear("America/Nuuk", [
		["2246-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2246-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2246-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2246-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2247" : helpers.makeTestYear("America/Nuuk", [
		["2247-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2247-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2247-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2247-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2248" : helpers.makeTestYear("America/Nuuk", [
		["2248-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2248-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2248-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2248-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2249" : helpers.makeTestYear("America/Nuuk", [
		["2249-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2249-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2249-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2249-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2250" : helpers.makeTestYear("America/Nuuk", [
		["2250-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2250-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2250-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2250-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2251" : helpers.makeTestYear("America/Nuuk", [
		["2251-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2251-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2251-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2251-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2252" : helpers.makeTestYear("America/Nuuk", [
		["2252-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2252-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2252-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2252-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2253" : helpers.makeTestYear("America/Nuuk", [
		["2253-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2253-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2253-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2253-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2254" : helpers.makeTestYear("America/Nuuk", [
		["2254-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2254-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2254-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2254-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2255" : helpers.makeTestYear("America/Nuuk", [
		["2255-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2255-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2255-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2255-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2256" : helpers.makeTestYear("America/Nuuk", [
		["2256-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2256-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2256-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2256-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2257" : helpers.makeTestYear("America/Nuuk", [
		["2257-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2257-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2257-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2257-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2258" : helpers.makeTestYear("America/Nuuk", [
		["2258-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2258-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2258-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2258-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2259" : helpers.makeTestYear("America/Nuuk", [
		["2259-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2259-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2259-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2259-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2260" : helpers.makeTestYear("America/Nuuk", [
		["2260-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2260-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2260-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2260-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2261" : helpers.makeTestYear("America/Nuuk", [
		["2261-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2261-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2261-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2261-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2262" : helpers.makeTestYear("America/Nuuk", [
		["2262-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2262-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2262-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2262-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2263" : helpers.makeTestYear("America/Nuuk", [
		["2263-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2263-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2263-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2263-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2264" : helpers.makeTestYear("America/Nuuk", [
		["2264-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2264-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2264-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2264-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2265" : helpers.makeTestYear("America/Nuuk", [
		["2265-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2265-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2265-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2265-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2266" : helpers.makeTestYear("America/Nuuk", [
		["2266-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2266-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2266-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2266-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2267" : helpers.makeTestYear("America/Nuuk", [
		["2267-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2267-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2267-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2267-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2268" : helpers.makeTestYear("America/Nuuk", [
		["2268-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2268-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2268-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2268-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2269" : helpers.makeTestYear("America/Nuuk", [
		["2269-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2269-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2269-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2269-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2270" : helpers.makeTestYear("America/Nuuk", [
		["2270-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2270-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2270-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2270-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2271" : helpers.makeTestYear("America/Nuuk", [
		["2271-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2271-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2271-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2271-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2272" : helpers.makeTestYear("America/Nuuk", [
		["2272-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2272-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2272-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2272-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2273" : helpers.makeTestYear("America/Nuuk", [
		["2273-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2273-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2273-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2273-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2274" : helpers.makeTestYear("America/Nuuk", [
		["2274-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2274-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2274-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2274-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2275" : helpers.makeTestYear("America/Nuuk", [
		["2275-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2275-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2275-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2275-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2276" : helpers.makeTestYear("America/Nuuk", [
		["2276-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2276-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2276-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2276-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2277" : helpers.makeTestYear("America/Nuuk", [
		["2277-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2277-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2277-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2277-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2278" : helpers.makeTestYear("America/Nuuk", [
		["2278-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2278-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2278-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2278-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2279" : helpers.makeTestYear("America/Nuuk", [
		["2279-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2279-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2279-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2279-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2280" : helpers.makeTestYear("America/Nuuk", [
		["2280-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2280-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2280-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2280-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2281" : helpers.makeTestYear("America/Nuuk", [
		["2281-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2281-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2281-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2281-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2282" : helpers.makeTestYear("America/Nuuk", [
		["2282-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2282-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2282-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2282-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2283" : helpers.makeTestYear("America/Nuuk", [
		["2283-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2283-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2283-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2283-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2284" : helpers.makeTestYear("America/Nuuk", [
		["2284-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2284-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2284-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2284-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2285" : helpers.makeTestYear("America/Nuuk", [
		["2285-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2285-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2285-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2285-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2286" : helpers.makeTestYear("America/Nuuk", [
		["2286-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2286-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2286-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2286-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2287" : helpers.makeTestYear("America/Nuuk", [
		["2287-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2287-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2287-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2287-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2288" : helpers.makeTestYear("America/Nuuk", [
		["2288-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2288-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2288-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2288-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2289" : helpers.makeTestYear("America/Nuuk", [
		["2289-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2289-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2289-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2289-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2290" : helpers.makeTestYear("America/Nuuk", [
		["2290-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2290-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2290-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2290-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2291" : helpers.makeTestYear("America/Nuuk", [
		["2291-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2291-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2291-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2291-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2292" : helpers.makeTestYear("America/Nuuk", [
		["2292-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2292-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2292-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2292-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2293" : helpers.makeTestYear("America/Nuuk", [
		["2293-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2293-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2293-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2293-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2294" : helpers.makeTestYear("America/Nuuk", [
		["2294-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2294-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2294-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2294-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2295" : helpers.makeTestYear("America/Nuuk", [
		["2295-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2295-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2295-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2295-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2296" : helpers.makeTestYear("America/Nuuk", [
		["2296-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2296-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2296-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2296-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2297" : helpers.makeTestYear("America/Nuuk", [
		["2297-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2297-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2297-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2297-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2298" : helpers.makeTestYear("America/Nuuk", [
		["2298-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2298-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2298-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2298-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2299" : helpers.makeTestYear("America/Nuuk", [
		["2299-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2299-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2299-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2299-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2300" : helpers.makeTestYear("America/Nuuk", [
		["2300-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2300-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2300-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2300-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2301" : helpers.makeTestYear("America/Nuuk", [
		["2301-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2301-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2301-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2301-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2302" : helpers.makeTestYear("America/Nuuk", [
		["2302-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2302-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2302-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2302-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2303" : helpers.makeTestYear("America/Nuuk", [
		["2303-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2303-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2303-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2303-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2304" : helpers.makeTestYear("America/Nuuk", [
		["2304-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2304-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2304-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2304-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2305" : helpers.makeTestYear("America/Nuuk", [
		["2305-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2305-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2305-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2305-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2306" : helpers.makeTestYear("America/Nuuk", [
		["2306-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2306-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2306-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2306-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2307" : helpers.makeTestYear("America/Nuuk", [
		["2307-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2307-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2307-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2307-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2308" : helpers.makeTestYear("America/Nuuk", [
		["2308-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2308-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2308-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2308-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2309" : helpers.makeTestYear("America/Nuuk", [
		["2309-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2309-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2309-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2309-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2310" : helpers.makeTestYear("America/Nuuk", [
		["2310-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2310-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2310-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2310-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2311" : helpers.makeTestYear("America/Nuuk", [
		["2311-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2311-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2311-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2311-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2312" : helpers.makeTestYear("America/Nuuk", [
		["2312-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2312-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2312-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2312-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2313" : helpers.makeTestYear("America/Nuuk", [
		["2313-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2313-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2313-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2313-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2314" : helpers.makeTestYear("America/Nuuk", [
		["2314-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2314-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2314-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2314-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2315" : helpers.makeTestYear("America/Nuuk", [
		["2315-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2315-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2315-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2315-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2316" : helpers.makeTestYear("America/Nuuk", [
		["2316-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2316-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2316-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2316-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2317" : helpers.makeTestYear("America/Nuuk", [
		["2317-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2317-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2317-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2317-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2318" : helpers.makeTestYear("America/Nuuk", [
		["2318-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2318-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2318-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2318-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2319" : helpers.makeTestYear("America/Nuuk", [
		["2319-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2319-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2319-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2319-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2320" : helpers.makeTestYear("America/Nuuk", [
		["2320-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2320-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2320-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2320-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2321" : helpers.makeTestYear("America/Nuuk", [
		["2321-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2321-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2321-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2321-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2322" : helpers.makeTestYear("America/Nuuk", [
		["2322-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2322-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2322-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2322-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2323" : helpers.makeTestYear("America/Nuuk", [
		["2323-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2323-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2323-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2323-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2324" : helpers.makeTestYear("America/Nuuk", [
		["2324-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2324-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2324-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2324-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2325" : helpers.makeTestYear("America/Nuuk", [
		["2325-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2325-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2325-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2325-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2326" : helpers.makeTestYear("America/Nuuk", [
		["2326-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2326-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2326-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2326-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2327" : helpers.makeTestYear("America/Nuuk", [
		["2327-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2327-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2327-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2327-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2328" : helpers.makeTestYear("America/Nuuk", [
		["2328-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2328-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2328-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2328-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2329" : helpers.makeTestYear("America/Nuuk", [
		["2329-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2329-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2329-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2329-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2330" : helpers.makeTestYear("America/Nuuk", [
		["2330-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2330-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2330-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2330-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2331" : helpers.makeTestYear("America/Nuuk", [
		["2331-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2331-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2331-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2331-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2332" : helpers.makeTestYear("America/Nuuk", [
		["2332-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2332-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2332-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2332-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2333" : helpers.makeTestYear("America/Nuuk", [
		["2333-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2333-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2333-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2333-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2334" : helpers.makeTestYear("America/Nuuk", [
		["2334-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2334-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2334-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2334-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2335" : helpers.makeTestYear("America/Nuuk", [
		["2335-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2335-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2335-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2335-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2336" : helpers.makeTestYear("America/Nuuk", [
		["2336-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2336-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2336-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2336-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2337" : helpers.makeTestYear("America/Nuuk", [
		["2337-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2337-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2337-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2337-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2338" : helpers.makeTestYear("America/Nuuk", [
		["2338-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2338-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2338-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2338-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2339" : helpers.makeTestYear("America/Nuuk", [
		["2339-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2339-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2339-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2339-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2340" : helpers.makeTestYear("America/Nuuk", [
		["2340-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2340-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2340-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2340-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2341" : helpers.makeTestYear("America/Nuuk", [
		["2341-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2341-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2341-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2341-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2342" : helpers.makeTestYear("America/Nuuk", [
		["2342-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2342-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2342-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2342-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2343" : helpers.makeTestYear("America/Nuuk", [
		["2343-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2343-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2343-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2343-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2344" : helpers.makeTestYear("America/Nuuk", [
		["2344-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2344-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2344-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2344-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2345" : helpers.makeTestYear("America/Nuuk", [
		["2345-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2345-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2345-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2345-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2346" : helpers.makeTestYear("America/Nuuk", [
		["2346-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2346-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2346-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2346-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2347" : helpers.makeTestYear("America/Nuuk", [
		["2347-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2347-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2347-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2347-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2348" : helpers.makeTestYear("America/Nuuk", [
		["2348-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2348-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2348-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2348-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2349" : helpers.makeTestYear("America/Nuuk", [
		["2349-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2349-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2349-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2349-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2350" : helpers.makeTestYear("America/Nuuk", [
		["2350-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2350-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2350-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2350-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2351" : helpers.makeTestYear("America/Nuuk", [
		["2351-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2351-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2351-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2351-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2352" : helpers.makeTestYear("America/Nuuk", [
		["2352-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2352-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2352-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2352-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2353" : helpers.makeTestYear("America/Nuuk", [
		["2353-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2353-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2353-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2353-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2354" : helpers.makeTestYear("America/Nuuk", [
		["2354-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2354-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2354-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2354-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2355" : helpers.makeTestYear("America/Nuuk", [
		["2355-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2355-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2355-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2355-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2356" : helpers.makeTestYear("America/Nuuk", [
		["2356-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2356-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2356-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2356-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2357" : helpers.makeTestYear("America/Nuuk", [
		["2357-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2357-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2357-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2357-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2358" : helpers.makeTestYear("America/Nuuk", [
		["2358-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2358-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2358-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2358-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2359" : helpers.makeTestYear("America/Nuuk", [
		["2359-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2359-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2359-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2359-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2360" : helpers.makeTestYear("America/Nuuk", [
		["2360-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2360-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2360-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2360-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2361" : helpers.makeTestYear("America/Nuuk", [
		["2361-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2361-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2361-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2361-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2362" : helpers.makeTestYear("America/Nuuk", [
		["2362-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2362-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2362-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2362-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2363" : helpers.makeTestYear("America/Nuuk", [
		["2363-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2363-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2363-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2363-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2364" : helpers.makeTestYear("America/Nuuk", [
		["2364-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2364-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2364-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2364-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2365" : helpers.makeTestYear("America/Nuuk", [
		["2365-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2365-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2365-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2365-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2366" : helpers.makeTestYear("America/Nuuk", [
		["2366-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2366-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2366-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2366-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2367" : helpers.makeTestYear("America/Nuuk", [
		["2367-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2367-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2367-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2367-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2368" : helpers.makeTestYear("America/Nuuk", [
		["2368-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2368-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2368-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2368-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2369" : helpers.makeTestYear("America/Nuuk", [
		["2369-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2369-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2369-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2369-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2370" : helpers.makeTestYear("America/Nuuk", [
		["2370-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2370-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2370-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2370-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2371" : helpers.makeTestYear("America/Nuuk", [
		["2371-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2371-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2371-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2371-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2372" : helpers.makeTestYear("America/Nuuk", [
		["2372-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2372-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2372-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2372-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2373" : helpers.makeTestYear("America/Nuuk", [
		["2373-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2373-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2373-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2373-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2374" : helpers.makeTestYear("America/Nuuk", [
		["2374-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2374-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2374-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2374-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2375" : helpers.makeTestYear("America/Nuuk", [
		["2375-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2375-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2375-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2375-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2376" : helpers.makeTestYear("America/Nuuk", [
		["2376-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2376-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2376-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2376-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2377" : helpers.makeTestYear("America/Nuuk", [
		["2377-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2377-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2377-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2377-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2378" : helpers.makeTestYear("America/Nuuk", [
		["2378-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2378-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2378-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2378-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2379" : helpers.makeTestYear("America/Nuuk", [
		["2379-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2379-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2379-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2379-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2380" : helpers.makeTestYear("America/Nuuk", [
		["2380-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2380-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2380-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2380-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2381" : helpers.makeTestYear("America/Nuuk", [
		["2381-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2381-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2381-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2381-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2382" : helpers.makeTestYear("America/Nuuk", [
		["2382-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2382-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2382-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2382-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2383" : helpers.makeTestYear("America/Nuuk", [
		["2383-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2383-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2383-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2383-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2384" : helpers.makeTestYear("America/Nuuk", [
		["2384-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2384-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2384-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2384-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2385" : helpers.makeTestYear("America/Nuuk", [
		["2385-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2385-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2385-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2385-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2386" : helpers.makeTestYear("America/Nuuk", [
		["2386-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2386-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2386-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2386-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2387" : helpers.makeTestYear("America/Nuuk", [
		["2387-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2387-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2387-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2387-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2388" : helpers.makeTestYear("America/Nuuk", [
		["2388-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2388-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2388-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2388-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2389" : helpers.makeTestYear("America/Nuuk", [
		["2389-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2389-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2389-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2389-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2390" : helpers.makeTestYear("America/Nuuk", [
		["2390-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2390-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2390-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2390-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2391" : helpers.makeTestYear("America/Nuuk", [
		["2391-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2391-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2391-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2391-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2392" : helpers.makeTestYear("America/Nuuk", [
		["2392-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2392-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2392-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2392-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2393" : helpers.makeTestYear("America/Nuuk", [
		["2393-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2393-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2393-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2393-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2394" : helpers.makeTestYear("America/Nuuk", [
		["2394-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2394-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2394-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2394-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2395" : helpers.makeTestYear("America/Nuuk", [
		["2395-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2395-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2395-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2395-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2396" : helpers.makeTestYear("America/Nuuk", [
		["2396-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2396-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2396-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2396-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2397" : helpers.makeTestYear("America/Nuuk", [
		["2397-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2397-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2397-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2397-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2398" : helpers.makeTestYear("America/Nuuk", [
		["2398-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2398-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2398-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2398-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2399" : helpers.makeTestYear("America/Nuuk", [
		["2399-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2399-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2399-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2399-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2400" : helpers.makeTestYear("America/Nuuk", [
		["2400-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2400-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2400-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2400-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2401" : helpers.makeTestYear("America/Nuuk", [
		["2401-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2401-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2401-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2401-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2402" : helpers.makeTestYear("America/Nuuk", [
		["2402-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2402-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2402-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2402-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2403" : helpers.makeTestYear("America/Nuuk", [
		["2403-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2403-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2403-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2403-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2404" : helpers.makeTestYear("America/Nuuk", [
		["2404-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2404-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2404-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2404-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2405" : helpers.makeTestYear("America/Nuuk", [
		["2405-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2405-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2405-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2405-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2406" : helpers.makeTestYear("America/Nuuk", [
		["2406-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2406-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2406-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2406-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2407" : helpers.makeTestYear("America/Nuuk", [
		["2407-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2407-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2407-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2407-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2408" : helpers.makeTestYear("America/Nuuk", [
		["2408-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2408-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2408-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2408-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2409" : helpers.makeTestYear("America/Nuuk", [
		["2409-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2409-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2409-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2409-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2410" : helpers.makeTestYear("America/Nuuk", [
		["2410-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2410-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2410-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2410-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2411" : helpers.makeTestYear("America/Nuuk", [
		["2411-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2411-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2411-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2411-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2412" : helpers.makeTestYear("America/Nuuk", [
		["2412-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2412-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2412-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2412-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2413" : helpers.makeTestYear("America/Nuuk", [
		["2413-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2413-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2413-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2413-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2414" : helpers.makeTestYear("America/Nuuk", [
		["2414-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2414-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2414-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2414-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2415" : helpers.makeTestYear("America/Nuuk", [
		["2415-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2415-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2415-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2415-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2416" : helpers.makeTestYear("America/Nuuk", [
		["2416-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2416-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2416-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2416-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2417" : helpers.makeTestYear("America/Nuuk", [
		["2417-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2417-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2417-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2417-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2418" : helpers.makeTestYear("America/Nuuk", [
		["2418-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2418-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2418-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2418-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2419" : helpers.makeTestYear("America/Nuuk", [
		["2419-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2419-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2419-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2419-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2420" : helpers.makeTestYear("America/Nuuk", [
		["2420-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2420-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2420-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2420-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2421" : helpers.makeTestYear("America/Nuuk", [
		["2421-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2421-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2421-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2421-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2422" : helpers.makeTestYear("America/Nuuk", [
		["2422-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2422-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2422-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2422-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2423" : helpers.makeTestYear("America/Nuuk", [
		["2423-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2423-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2423-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2423-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2424" : helpers.makeTestYear("America/Nuuk", [
		["2424-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2424-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2424-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2424-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2425" : helpers.makeTestYear("America/Nuuk", [
		["2425-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2425-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2425-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2425-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2426" : helpers.makeTestYear("America/Nuuk", [
		["2426-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2426-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2426-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2426-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2427" : helpers.makeTestYear("America/Nuuk", [
		["2427-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2427-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2427-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2427-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2428" : helpers.makeTestYear("America/Nuuk", [
		["2428-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2428-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2428-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2428-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2429" : helpers.makeTestYear("America/Nuuk", [
		["2429-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2429-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2429-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2429-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2430" : helpers.makeTestYear("America/Nuuk", [
		["2430-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2430-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2430-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2430-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2431" : helpers.makeTestYear("America/Nuuk", [
		["2431-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2431-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2431-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2431-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2432" : helpers.makeTestYear("America/Nuuk", [
		["2432-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2432-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2432-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2432-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2433" : helpers.makeTestYear("America/Nuuk", [
		["2433-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2433-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2433-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2433-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2434" : helpers.makeTestYear("America/Nuuk", [
		["2434-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2434-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2434-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2434-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2435" : helpers.makeTestYear("America/Nuuk", [
		["2435-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2435-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2435-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2435-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2436" : helpers.makeTestYear("America/Nuuk", [
		["2436-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2436-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2436-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2436-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2437" : helpers.makeTestYear("America/Nuuk", [
		["2437-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2437-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2437-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2437-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2438" : helpers.makeTestYear("America/Nuuk", [
		["2438-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2438-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2438-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2438-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2439" : helpers.makeTestYear("America/Nuuk", [
		["2439-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2439-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2439-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2439-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2440" : helpers.makeTestYear("America/Nuuk", [
		["2440-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2440-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2440-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2440-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2441" : helpers.makeTestYear("America/Nuuk", [
		["2441-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2441-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2441-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2441-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2442" : helpers.makeTestYear("America/Nuuk", [
		["2442-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2442-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2442-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2442-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2443" : helpers.makeTestYear("America/Nuuk", [
		["2443-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2443-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2443-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2443-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2444" : helpers.makeTestYear("America/Nuuk", [
		["2444-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2444-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2444-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2444-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2445" : helpers.makeTestYear("America/Nuuk", [
		["2445-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2445-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2445-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2445-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2446" : helpers.makeTestYear("America/Nuuk", [
		["2446-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2446-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2446-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2446-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2447" : helpers.makeTestYear("America/Nuuk", [
		["2447-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2447-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2447-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2447-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2448" : helpers.makeTestYear("America/Nuuk", [
		["2448-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2448-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2448-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2448-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2449" : helpers.makeTestYear("America/Nuuk", [
		["2449-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2449-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2449-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2449-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2450" : helpers.makeTestYear("America/Nuuk", [
		["2450-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2450-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2450-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2450-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2451" : helpers.makeTestYear("America/Nuuk", [
		["2451-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2451-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2451-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2451-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2452" : helpers.makeTestYear("America/Nuuk", [
		["2452-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2452-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2452-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2452-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2453" : helpers.makeTestYear("America/Nuuk", [
		["2453-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2453-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2453-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2453-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2454" : helpers.makeTestYear("America/Nuuk", [
		["2454-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2454-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2454-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2454-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2455" : helpers.makeTestYear("America/Nuuk", [
		["2455-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2455-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2455-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2455-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2456" : helpers.makeTestYear("America/Nuuk", [
		["2456-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2456-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2456-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2456-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2457" : helpers.makeTestYear("America/Nuuk", [
		["2457-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2457-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2457-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2457-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2458" : helpers.makeTestYear("America/Nuuk", [
		["2458-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2458-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2458-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2458-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2459" : helpers.makeTestYear("America/Nuuk", [
		["2459-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2459-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2459-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2459-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2460" : helpers.makeTestYear("America/Nuuk", [
		["2460-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2460-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2460-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2460-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2461" : helpers.makeTestYear("America/Nuuk", [
		["2461-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2461-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2461-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2461-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2462" : helpers.makeTestYear("America/Nuuk", [
		["2462-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2462-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2462-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2462-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2463" : helpers.makeTestYear("America/Nuuk", [
		["2463-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2463-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2463-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2463-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2464" : helpers.makeTestYear("America/Nuuk", [
		["2464-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2464-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2464-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2464-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2465" : helpers.makeTestYear("America/Nuuk", [
		["2465-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2465-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2465-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2465-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2466" : helpers.makeTestYear("America/Nuuk", [
		["2466-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2466-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2466-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2466-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2467" : helpers.makeTestYear("America/Nuuk", [
		["2467-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2467-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2467-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2467-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2468" : helpers.makeTestYear("America/Nuuk", [
		["2468-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2468-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2468-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2468-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2469" : helpers.makeTestYear("America/Nuuk", [
		["2469-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2469-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2469-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2469-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2470" : helpers.makeTestYear("America/Nuuk", [
		["2470-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2470-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2470-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2470-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2471" : helpers.makeTestYear("America/Nuuk", [
		["2471-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2471-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2471-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2471-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2472" : helpers.makeTestYear("America/Nuuk", [
		["2472-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2472-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2472-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2472-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2473" : helpers.makeTestYear("America/Nuuk", [
		["2473-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2473-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2473-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2473-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2474" : helpers.makeTestYear("America/Nuuk", [
		["2474-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2474-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2474-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2474-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2475" : helpers.makeTestYear("America/Nuuk", [
		["2475-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2475-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2475-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2475-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2476" : helpers.makeTestYear("America/Nuuk", [
		["2476-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2476-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2476-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2476-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2477" : helpers.makeTestYear("America/Nuuk", [
		["2477-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2477-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2477-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2477-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2478" : helpers.makeTestYear("America/Nuuk", [
		["2478-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2478-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2478-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2478-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2479" : helpers.makeTestYear("America/Nuuk", [
		["2479-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2479-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2479-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2479-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2480" : helpers.makeTestYear("America/Nuuk", [
		["2480-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2480-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2480-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2480-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2481" : helpers.makeTestYear("America/Nuuk", [
		["2481-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2481-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2481-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2481-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2482" : helpers.makeTestYear("America/Nuuk", [
		["2482-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2482-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2482-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2482-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2483" : helpers.makeTestYear("America/Nuuk", [
		["2483-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2483-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2483-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2483-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2484" : helpers.makeTestYear("America/Nuuk", [
		["2484-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2484-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2484-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2484-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2485" : helpers.makeTestYear("America/Nuuk", [
		["2485-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2485-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2485-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2485-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2486" : helpers.makeTestYear("America/Nuuk", [
		["2486-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2486-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2486-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2486-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2487" : helpers.makeTestYear("America/Nuuk", [
		["2487-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2487-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2487-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2487-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2488" : helpers.makeTestYear("America/Nuuk", [
		["2488-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2488-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2488-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2488-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2489" : helpers.makeTestYear("America/Nuuk", [
		["2489-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2489-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2489-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2489-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2490" : helpers.makeTestYear("America/Nuuk", [
		["2490-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["2490-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["2490-10-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["2490-10-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2491" : helpers.makeTestYear("America/Nuuk", [
		["2491-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2491-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2491-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2491-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2492" : helpers.makeTestYear("America/Nuuk", [
		["2492-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2492-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2492-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2492-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2493" : helpers.makeTestYear("America/Nuuk", [
		["2493-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2493-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2493-10-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["2493-10-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2494" : helpers.makeTestYear("America/Nuuk", [
		["2494-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["2494-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["2494-10-31T00:59:59+00:00", "22:59:59", "-02", 120],
		["2494-10-31T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2495" : helpers.makeTestYear("America/Nuuk", [
		["2495-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["2495-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["2495-10-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["2495-10-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2496" : helpers.makeTestYear("America/Nuuk", [
		["2496-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["2496-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["2496-10-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["2496-10-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2497" : helpers.makeTestYear("America/Nuuk", [
		["2497-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["2497-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["2497-10-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["2497-10-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2498" : helpers.makeTestYear("America/Nuuk", [
		["2498-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["2498-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["2498-10-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["2498-10-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"2499" : helpers.makeTestYear("America/Nuuk", [
		["2499-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["2499-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["2499-10-25T00:59:59+00:00", "22:59:59", "-02", 120]
	])
};