/* mpdscribble (MPD Client)
 * Copyright (C) 2008-2019 The Music Player Daemon Project
 * Copyright (C) 2005-2008 Kuno Woudt <kuno@frob.nl>
 * Project homepage: http://musicpd.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef MULTI_SCROBBLER_HXX
#define MULTI_SCROBBLER_HXX

#include <chrono>
#include <forward_list>

struct ScrobblerConfig;
class CurlGlobal;
class Scrobbler;
class EventLoop;

class MultiScrobbler {
	std::forward_list<Scrobbler> scrobblers;

public:
	explicit MultiScrobbler(const std::forward_list<ScrobblerConfig> &configs,
				EventLoop &event_loop,
				CurlGlobal &curl_global);
	~MultiScrobbler() noexcept;

	void WriteJournal() noexcept;

	void NowPlaying(const char *artist, const char *track,
			const char *album, const char *number,
			const char *mbid,
			std::chrono::steady_clock::duration length) noexcept;

	void SongChange(const char *file, const char *artist, const char *track,
			const char *album, const char *number,
			const char *mbid,
			std::chrono::steady_clock::duration length,
			bool love,
			const char *time) noexcept;

	void SubmitNow() noexcept;
};

#endif
