/**
 * MVEL 2.0
 * Copyright (C) 2007 The Codehaus
 * Mike Brock, Dhanji Prasanna, John Graham, Mark Proctor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.mvel2.debug;

import org.mvel2.ParserContext;
import org.mvel2.ast.LineLabel;
import org.mvel2.integration.VariableResolverFactory;

public class Frame {
  private LineLabel label;
  private VariableResolverFactory factory;

  public Frame(LineLabel label, VariableResolverFactory factory) {
    this.label = label;
    this.factory = factory;
  }

  public String getSourceName() {
    return label.getSourceFile();
  }

  public int getLineNumber() {
    return label.getLineNumber();
  }

  public VariableResolverFactory getFactory() {
    return factory;
  }

  public void setFactory(VariableResolverFactory factory) {
    this.factory = factory;
  }
}
