/**
 * @file
 * RFC2231 MIME Charset routines
 *
 * @authors
 * Copyright (C) 1999-2000 Thomas Roessler <roessler@does-not-exist.org>
 *
 * @copyright
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MUTT_EMAIL_RFC2231_H
#define MUTT_EMAIL_RFC2231_H

#include <stddef.h>
#include <stdbool.h>

struct ParameterList;

/* These Config Variables are only used in rfc2231.c */
extern bool C_Rfc2047Parameters;

void   rfc2231_decode_parameters(struct ParameterList *pl);
size_t rfc2231_encode_string    (struct ParameterList *head, const char *attribute, char *value);

#endif /* MUTT_EMAIL_RFC2231_H */
