/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.profiler.heapwalk.ui.icons;

import org.netbeans.modules.profiler.api.icons.Icons;

/**
 *
 * @author Jiri Sedlacek
 */
public interface HeapWalkerIcons extends Icons.Keys {
    
    public static final String CLASSES = "HeapWalkerIcons.Classes"; // NOI18N
    public static final String DATA = "HeapWalkerIcons.Data"; // NOI18N
    public static final String GC_ROOT = "HeapWalkerIcons.GcRoot"; // NOI18N
    public static final String GC_ROOTS = "HeapWalkerIcons.GcRoots"; // NOI18N
    public static final String INCOMING_REFERENCES = "HeapWalkerIcons.IncomingReferences"; // NOI18N
    public static final String INSTANCES = "HeapWalkerIcons.Instances"; // NOI18N
    public static final String LOOP = "HeapWalkerIcons.Loop"; // NOI18N
    public static final String MEMORY_LINT = "HeapWalkerIcons.MemoryLint"; // NOI18N
    public static final String PROGRESS = "HeapWalkerIcons.Progress"; // NOI18N
    public static final String PROPERTIES = "HeapWalkerIcons.Properties"; // NOI18N
    public static final String RULES = "HeapWalkerIcons.Rules"; // NOI18N
    public static final String SAVED_OQL_QUERIES = "HeapWalkerIcons.SavedOqlQueries"; // NOI18N
    public static final String STATIC = "HeapWalkerIcons.Static"; // NOI18N
    public static final String SYSTEM_INFO = "HeapWalkerIcons.SystemInfo"; // NOI18N
    public static final String WINDOW = "HeapWalkerIcons.Window"; // NOI18N
    public static final String BIGGEST_OBJECTS = "HeapWalkerIcons.BiggestObjects"; // NOI18N
    public static final String OQL_CONSOLE = "HeapWalkerIcons.OQLConsole"; // NOI18N
    
}
