/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2012 Sun Microsystems, Inc.
 */
package org.netbeans.modules.bugtracking.tasks;

import org.netbeans.modules.team.commons.treelist.LinkButton;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/**
 *
 * @author jpeska
 */
public class CategoryPicker extends javax.swing.JPanel {

    private List<Category> categories;
    private final Action newCatAction;
    private CategoryComboListener listener;
    private final TaskNode[] taskNodes;
    private final DashboardViewer dashboardViewer = DashboardViewer.getInstance();

    /**
     * Creates new form CategoryPicker
     */
    public CategoryPicker(TaskNode... taskNodes) {
        this.taskNodes = taskNodes;
        newCatAction = getNewCatAction();
        initComponents();
        initCombo();
    }

    public Category getChosenCategory() {
        return categories.get(cbCategory.getSelectedIndex());
    }

    public void setCategoryListener(CategoryComboListener listener) {
        this.listener = listener;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        cbCategory = new javax.swing.JComboBox();
        btnNewCat = new LinkButton("", newCatAction);

        jLabel1.setText(org.openide.util.NbBundle.getMessage(CategoryPicker.class, "CategoryPicker.jLabel1.text")); // NOI18N

        btnNewCat.setText(org.openide.util.NbBundle.getMessage(CategoryPicker.class, "LBL_New"));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addGap(18, 18, 18)
                .addComponent(cbCategory, javax.swing.GroupLayout.PREFERRED_SIZE, 193, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnNewCat)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(cbCategory, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnNewCat))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnNewCat;
    private javax.swing.JComboBox cbCategory;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

    private Action getNewCatAction() {
        return new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Category category = DashboardTopComponent.findInstance().createCategory();
                if (category == null) {
                    return;
                }
                categories.add(category);
                initCombo();
                cbCategory.setSelectedItem(category.getName());
            }
        };
    }

    private void initCombo() {
        cbCategory.setModel(new DefaultComboBoxModel(new String[]{NbBundle.getMessage(CategoryPicker.class, "LBL_Loading")}));
        RequestProcessor.getDefault().post(new Runnable() {
            @Override
            public void run() {
                initCategories();
            }
        });
    }

    private void initCategories() throws MissingResourceException {
        this.categories = dashboardViewer.preloadCategories();
        if (taskNodes.length == 1) {
            TaskNode taskNode = taskNodes[0];
            if (taskNode.isCategorized()) {
                categories.remove(taskNode.getCategory());
            }
        }
        String[] names = new String[categories.size()];
        //names[0] = NbBundle.getMessage(CategoryPicker.class, "LBL_NoCategory"); //NOI18N
        int i = 0;
        boolean categoryAvailable = true;
        for (Category category : categories) {
            names[i++] = category.getName();
        }
        if (categories.isEmpty()) {
            names = new String[]{NbBundle.getMessage(CategoryPicker.class, "LBL_NoCategoryAvailable")};
            categoryAvailable = false;
        }
        final String[] namesF = names;
        final boolean categoryAvailableF = categoryAvailable;
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                cbCategory.setModel(new DefaultComboBoxModel(namesF));
                if (listener != null) {
                    listener.comboItemsChanged(categoryAvailableF);
                }
            }
        });
    }

    public interface CategoryComboListener {
        public void comboItemsChanged(boolean categoryAvailable);
    }
}
