<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/charts.d.plugin/ap/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/charts.d.plugin/ap/metadata.yaml"
sidebar_label: "Access Points"
learn_status: "Published"
learn_rel_path: "Data Collection/Linux Systems/Network"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Access Points


<img src="https://netdata.cloud/img/network-wired.svg" width="150"/>


Plugin: charts.d.plugin
Module: ap

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

The ap collector visualizes data related to wireless access points.

It uses the `iw` command line utility to detect access points. For each interface that is of `type AP`, it then runs `iw INTERFACE station dump` and collects statistics.

This collector is only supported on the following platforms:

- Linux

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The plugin is able to auto-detect if you are running access points on your linux box.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per wireless device

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| ap.clients | clients | clients |
| ap.net | received, sent | kilobits/s |
| ap.packets | received, sent | packets/s |
| ap.issues | retries, failures | issues/s |
| ap.signal | average signal | dBm |
| ap.bitrate | receive, transmit, expected | Mbps |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Install charts.d plugin

If [using our official native DEB/RPM packages](https://github.com/netdata/netdata/blob/master/packaging/installer/UPDATE.md#determine-which-installation-method-you-used), make sure `netdata-plugin-chartsd` is installed.


#### `iw` utility.

Make sure the `iw` utility is installed.


### Configuration

#### File

The configuration file name for this integration is `charts.d/ap.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config charts.d/ap.conf
```
#### Options

The config file is sourced by the charts.d plugin. It's a standard bash file.

The following collapsed table contains all the options that can be configured for the ap collector.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| ap_update_every | The data collection frequency. If unset, will inherit the netdata update frequency. | 1 | no |
| ap_priority | Controls the order of charts at the netdata dashboard. | 6900 | no |
| ap_retries | The number of retries to do in case of failure before disabling the collector. | 10 | no |

</details>

#### Examples

##### Change the collection frequency

Specify a custom collection frequence (update_every) for this collector

```yaml
# the data collection frequency
# if unset, will inherit the netdata update frequency
ap_update_every=10

# the charts priority on the dashboard
#ap_priority=6900

# the number of retries to do in case of failure
# before disabling the module
#ap_retries=10

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `ap` collector, run the `charts.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `charts.d.plugin` to debug the collector:

  ```bash
  ./charts.d.plugin debug 1 ap
  ```


