<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/health/notifications/prowl/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/health/notifications/prowl/metadata.yaml"
sidebar_label: "Prowl"
learn_status: "Published"
learn_rel_path: "Alerting/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# Prowl


<img src="https://netdata.cloud/img/prowl.png" width="150"/>


Send notifications to Prowl using Netdata's Agent alert notification feature, which supports dozens of endpoints, user roles, and more.


<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Limitations

- Because of how Netdata integrates with Prowl, there is a hard limit of at most 1000 notifications per hour (starting from the first notification sent). Any alerts beyond the first thousand in an hour will be dropped.
- Warning messages will be sent with the 'High' priority, critical messages will be sent with the 'Emergency' priority, and all other messages will be sent with the normal priority. Opening the notification's associated URL will take you to the Netdata dashboard of the system that issued the alert, directly to the chart that it triggered on.



## Setup

### Prerequisites

#### 

- A Prowl API key, which can be requested through the Prowl website after registering
- Access to the terminal where Netdata Agent is running



### Configuration

#### File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```
#### Options

The following options can be defined for this notification

<details><summary>Config Options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| SEND_PROWL | Set `SEND_PROWL` to YES | YES | yes |
| DEFAULT_RECIPIENT_PROWL | Set `DEFAULT_RECIPIENT_PROWL` to  the Prowl API key you want the alert notifications to be sent to. You can define multiple API keys like this: `APIKEY1`, `APIKEY2`. |  | yes |

##### DEFAULT_RECIPIENT_PROWL

All roles will default to this variable if left unconfigured.

The `DEFAULT_RECIPIENT_PROWL` can be edited in the following entries at the bottom of the same file:
```conf
role_recipients_prowl[sysadmin]="AAAAAAAA"
role_recipients_prowl[domainadmin]="BBBBBBBBB"
role_recipients_prowl[dba]="CCCCCCCCC"
role_recipients_prowl[webmaster]="DDDDDDDDDD"
role_recipients_prowl[proxyadmin]="EEEEEEEEEE"
role_recipients_prowl[sitemgr]="FFFFFFFFFF"
```


</details>

#### Examples

##### Basic Configuration



```yaml
#------------------------------------------------------------------------------
# iOS Push Notifications

SEND_PROWL="YES"
DEFAULT_RECIPIENT_PROWL="XXXXXXXXXX"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


